/*
 *  TMToggle toggles the topmost/non-topmost style of other windows.
 */

#include <windows.h>

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);

/*
 *  Function WinMain.
 */

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
    static char szAppName[] = "TMToggle";
    WNDCLASS wndclass;
    HWND hwnd;
    RECT rect;
    MSG msg;

    if (!hPrevInstance) {
        wndclass.style = 0;
        wndclass.lpfnWndProc = (WNDPROC) WndProc;
        wndclass.cbClsExtra = 0;
        wndclass.cbWndExtra = 0;
        wndclass.hInstance = hInstance;
        wndclass.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        wndclass.hCursor = LoadCursor (NULL, IDC_ARROW);
        wndclass.hbrBackground = COLOR_WINDOW + 1;
        wndclass.lpszMenuName = NULL;
        wndclass.lpszClassName = szAppName;

        RegisterClass (&wndclass);
    }

    SetRect (&rect, 0, 0, 144, 88);
    AdjustWindowRect (&rect, WS_OVERLAPPEDWINDOW, FALSE);

    hwnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT, rect.right - rect.left, rect.bottom -
        rect.top, HWND_DESKTOP, NULL, hInstance, NULL);

    ShowWindow (hwnd, nCmdShow);
    UpdateWindow (hwnd);

    while (GetMessage (&msg, NULL, 0, 0))
        DispatchMessage (&msg);

    return msg.wParam;
}

/*
 *  WndProc processes messages to the TMToggle window.
 */

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    POINT point;
    static nAction;
    static BOOL bSearching = FALSE;

    switch (message) {

    case WM_CREATE:
        CreateWindow ("button", "Topmost", WS_CHILD | WS_VISIBLE, 8, 8,
            128, 32, hwnd, 100, ((LPCREATESTRUCT) lParam)->hInstance, NULL);  
        CreateWindow ("button", "Non-Topmost", WS_CHILD | WS_VISIBLE, 8, 48,
            128, 32, hwnd, 101, ((LPCREATESTRUCT) lParam)->hInstance, NULL);  
        return 0;

    case WM_COMMAND:
        if ((wParam == 100) || (wParam == 101)) {
            ShowWindow (hwnd, SW_MINIMIZE);
            bSearching = TRUE;
            nAction = wParam - 100;
            SetCapture (hwnd);
            return 0;
        }
        break;

    case WM_LBUTTONDOWN:
        if (bSearching) {
            bSearching = FALSE;
            ReleaseCapture ();

            point.x = (int) LOWORD (lParam);
            point.y = (int) HIWORD (lParam); 
            ClientToScreen (hwnd, &point);

            SetWindowPos (WindowFromPoint (point), nAction ? HWND_NOTOPMOST :
                HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
            return 0;
        }
        break;
    }
    return DefWindowProc (hwnd, message, wParam, lParam);
}
