#ifndef _LINUX_LINKAGE_H
#define _LINUX_LINKAGE_H

#define asmlinkage

/* 
 * The a.out "as"  interprets .align as 2^n, but ELF "as" interprets as n.
 * For absolute minimum size, (at a performance cost) don't do alignment.
 * Only really impacts sys_call.S anyway.
 */
#ifdef __ELF__
#define ALIGN .align 4,0x90
#define ALIGN_STR ".align 4,0x90"
#else
#define ALIGN .align 2,0x90
#define ALIGN_STR ".align 2,0x90"
#endif

#ifdef __ELF__
#define SYMBOL_NAME_STR(X) #X
#define SYMBOL_NAME(X) X
#ifdef __STDC__
#define SYMBOL_NAME_LABEL(X) X##:
#else
#define SYMBOL_NAME_LABEL(X) X/**/:
#endif
#else
#define SYMBOL_NAME_STR(X) "_"#X
#ifdef __STDC__
#define SYMBOL_NAME(X) _##X
#define SYMBOL_NAME_LABEL(X) _##X##:
#else
#define SYMBOL_NAME(X) _/**/X
#define SYMBOL_NAME_LABEL(X) _/**/X/**/:
#endif
#endif

#define ENTRY(name) \
  .globl SYMBOL_NAME(name); \
  ALIGN; \
  SYMBOL_NAME_LABEL(name)

#endif
