(*---------------------------------------------------------------------------
 :Program.     CrM
 :Contents.    Interface to Thomas Schwarz's CrM.library V4.0
 :Author.      Alexander Ehlert ( C version by Thomas Schwarz )
 :Address.     Beethovenstr. 59/3  72458 Albstadt
 :Copyright.   refer to conditions of crm.library
 :Language.    Oberon-2
 :Translator.  Amiga-Oberon V3.10
 :History.     V1.0 translated from C to Oberon
 :Bugs.        none, I hope !
 :Remarks.     Thanx to Tom for this library
 :Remarks.     -> and for registering me :-)
 --------------------------------------------------------------------------*)
MODULE CrM;
IMPORT u  : Utility,
       e  : Exec,
       D  : Dos,
       S  : SYSTEM,
       i  : Intuition;

CONST
  CrMName*    = "CrM.library";
  CrMVersion* = 4;

  (*************************************
   ** Result Codes of CheckCrunched()
   ** and Symbols for the CMAlgo Tag
   *************************************)

  (* Crunchmode Flags *)

  Normal*   =   0;
  LZH*      =   1;
  Sample*   =   4;
  PW*       =   5;
  Overlay*  =   8;       (* only for    *)
  LEDFlash* =   9;       (* CMAlgo Tag! *)


  (* Use this mask to get the crunch algorithm without any other flags: *)
  AlgoMask  =  0FH;    (* but please not in OBERON ;-) *)

  (**********************************
   ** Action Codes for ProcessPW()
   **********************************)

  AddPW*     =  1;
  RemovePW*  =  2;
  RemoveAll* =  3;

  (**********************************
   ** Action Codes for CryptData()
   **********************************)

  EnCrypt*   =  4;
  DeCrypt*   =  5;

  (********************************************
   ** Action Codes for ProcessCrunchStruct()
   ********************************************)

  AllocStruct* = 6;
  FreeStruct*  = 7;

  (************************************
   ** Tags for ProcessCrunchStruct()
   ************************************)

  CMTagBase*  = u.user;
  CMAlgo*     = CMTagBase+1;          (* default: LZH *)
  CMOffset*   = CMTagBase+2;          (* default: 07FFEH *)
  CMHuffSize* = CMTagBase+3;          (* default: 16 *)

  (**************
   * Data Header
   **************)

TYPE
  DataHeaderPtr* = UNTRACED POINTER TO DataHeader;
  DataHeader* = STRUCT
                 ID-          : LONGINT; (* ULONG *)
                 MinSecDist-  : INTEGER; (* WORD  *)
                 OriginalLen- : LONGINT; (* ULONG *)
                 CrunchedLen- : LONGINT; (* ULONG *)
               END;


  (***************
   * CurrentStats
   ***************)

  CurrentStatsPtr* = UNTRACED POINTER TO CurrentStats;
  CurrentStats* = STRUCT
                    ToGo- : LONGINT; (* ULONG *)
                    Len-  : LONGINT;
                  END;

  (********************
   ** CrunchStruct(ure)
   ********************)

  CrunchStructPtr* = UNTRACED POINTER TO CrunchStruct;
  CrunchStruct* = STRUCT
                    Src*         : e.APTR;        (* Source Start *)
                    SrcLen*      : LONGINT;       (* Source Len *)
                    Dest*        : e.APTR;        (* Destination Start *)
                    DestLen*     : LONGINT;       (* Destination Len (maximum) *)
                    DataHdr*     : DataHeaderPtr; (* DataHeader *)
                    DisplayHook* : u.HookPtr;     (* Hook to display ToGo/Gain Counters *)

 (* Registers hold these values when the Hook is called:                  *)
 (* a0:struct Hook*  a2:struct cmCrunchStruct*  a1:struct cmCurrentStats  *)
 (* you have to return TRUE/FALSE in d0 to continue/abort crunching!      *)

                    DisplayStep* : INTEGER;       (* time between 2 calls to the Hook *)
   (******** readonly: ********)
                    Offset-      : INTEGER;       (* desired Offset *)
                    HuffSize-    : INTEGER;       (* HuffLen in KBytes *)
                    Algo-        : SET;           (* desired Packalgorithm *)
                    MaxOffset-   : LONGINT;       (* biggest possible Offset (Buffer allocated) *)
                    RealOffset-  : LONGINT;       (* currently used Offset *)
                    MinSecDist-  : LONGINT;       (* MinSecDist for packed Data *)
                    CrunchedLen- : LONGINT;       (* Length of crunched Data at cmcr_Dest *)
   (******** private: ********)
                    HuffTabs-    : LONGINT;
                    HuffBuf-     : LONGINT;
                    HuffLen-     : LONGINT;
                    SpeedLen-    : LONGINT;
                    SpeedTab-    : LONGINT;
                    MegaSpeedTab-: LONGINT;

                    QuitFlag-    : CHAR;          (* readonly: reason for failure *)
                    OverlayFlag- : BOOLEAN;
                    LEDFlashFlag-: BOOLEAN;
                    Pad-         : SHORTINT;
   (* CrunchStruct continues here, but LEAVE YOUR HANDS OFF!!! *)
                  END;(* CrunchStruct *)
     
VAR
  CrMBase : e.LibraryPtr;

PROCEDURE CheckCrunched* {CrMBase,-42} (DataHeader{8} : DataHeader):SET;

PROCEDURE CrunchData* {CrMBase,-72} (CrunchStruct{8} : CrunchStructPtr):LONGINT;

PROCEDURE CryptData* {CrMBase,-60} (DataHeader{8} : DataHeaderPtr;
                                    data{9}       : e.APTR;
                                    password{10}  : ARRAY OF CHAR;
                                    action{0}     : LONGINT):LONGINT;

PROCEDURE Decrunch* {CrMBase,-48} (source{8}      : e.APTR;
                                   dest{9}        : e.APTR;
                                   DataHeader{10} : DataHeader):e.APTR;

PROCEDURE ProcessCrunchStructA* {CrMBase,-66} (crunchstruct{9} : CrunchStructPtr;
                                               action{0}       : LONGINT;
                                               taglist{8}      : ARRAY OF u.TagItem):CrunchStructPtr;

PROCEDURE ProcessCrunchStructTags* {CrMBase,-66} (crunchstruct{9} : CrunchStructPtr;
                                                  action{0}       : LONGINT;
                                                  tag1{8}.. : u.Tag):CrunchStructPtr;

PROCEDURE ProcessPW* {CrMBase,-54} (password{8} : ARRAY OF CHAR;
                                    action{0}   : LONGINT):LONGINT;

PROCEDURE AllocCrunchStructA* {CrMBase,-78}(taglist{8} : ARRAY OF u.TagItem):CrunchStructPtr;

PROCEDURE AllocCrunchStructTags*{CrMBase,-78}(tag1{8}.. : u.Tag):CrunchStructPtr;

PROCEDURE FreeCrunchStruct*{CrMBase,-84}(crunchstruct{8}:CrunchStructPtr);

(* oberon support procedures *)

(* $RangeChk- $StackChk- $OvflChk- *)

PROCEDURE InitCrunchStruct*(cs             : CrunchStructPtr;
                            src,dest       : e.APTR;
                            srclen,destlen : LONGINT);
BEGIN
  IF cs#NIL THEN
    cs^.Src:=src;
    cs^.SrcLen:=srclen;
    cs^.Dest:=dest;
    cs^.DestLen:=destlen;
  END;
END InitCrunchStruct;

BEGIN
  CrMBase:=e.OpenLibrary(CrMName,CrMVersion);
  IF CrMBase = NIL THEN
    IF i.DisplayAlert(i.recoveryAlert,
                      "\x00\x64\x14missing crm.library V4\o\o",50) THEN END;
    HALT(20);
  END;
CLOSE
 IF CrMBase # NIL THEN
   e.CloseLibrary(CrMBase);
   CrMBase:=NIL;
 END;
END CrM.

