/*
 *  Macros for the assembler subroutines; handles NO_SANITY_CHECKS as well.
 */

/* Status codes for bit stream i/o operations. */

#define NO_VID_STREAM -1
#define UNDERFLOW -2
#define OK 1

/* Size increment of extension data buffers. */

#define EXT_BUF_SIZE 1024

/* External declarations of bitstream global variables. */
extern int bitOffset;
extern int bufLength;
extern unsigned int *bitBuffer;


#ifdef NO_SANITY_CHECKS
#define get_bits1(result)	result = sn_get_bits1()
#define get_bitsX(num, result)	result = sn_get_bitsX(num)
#else
#define get_bits1(result)	result = s_get_bits1()
#define get_bitsX(num, result)	result = s_get_bitsX(num)
#endif

#define get_bits2(result)	get_bitsX(2,  result)
#define get_bits3(result)	get_bitsX(3,  result)
#define get_bits4(result)	get_bitsX(4,  result)
#define get_bits5(result)	get_bitsX(5,  result)
#define get_bits6(result)	get_bitsX(6,  result)
#define get_bits7(result)	get_bitsX(7,  result)
#define get_bits8(result)	get_bitsX(8,  result)
#define get_bits9(result)	get_bitsX(9,  result)
#define get_bits10(result)	get_bitsX(10, result)
#define get_bits11(result)	get_bitsX(11, result)
#define get_bits12(result)	get_bitsX(12, result)
#define get_bits14(result)	get_bitsX(14, result)
#define get_bits16(result)	get_bitsX(16, result)
#define get_bits18(result)	get_bitsX(18, result)
#define get_bits32(result)	get_bitsX(32, result)

#define get_bitsn(num, result)	get_bitsX(num, result)


#ifdef NO_SANITY_CHECKS
#define show_bits32(result)	result = sn_show_bits32()
#define show_bitsX(num, result)	result = sn_show_bitsX(num)
#else
#define show_bits32(result)	result = s_show_bits32()
#define show_bitsX(num, result)	result = s_show_bitsX(num)
#endif

#define show_bits1(result)	show_bitsX(1, result)
#define show_bits2(result)	show_bitsX(2, result)
#define show_bits3(result)	show_bitsX(3, result)
#define show_bits4(result)	show_bitsX(4, result)
#define show_bits5(result)	show_bitsX(5, result)
#define show_bits6(result)	show_bitsX(6, result)
#define show_bits7(result)	show_bitsX(7, result)
#define show_bits8(result)	show_bitsX(8, result)
#define show_bits9(result)	show_bitsX(9, result)
#define show_bits10(result)	show_bitsX(10, result)
#define show_bits11(result)	show_bitsX(11, result)
#define show_bits12(result)	show_bitsX(12, result)
#define show_bits13(result)	show_bitsX(13, result)
#define show_bits14(result)	show_bitsX(14, result)
#define show_bits15(result)	show_bitsX(15, result)
#define show_bits16(result)	show_bitsX(16, result)
#define show_bits17(result)	show_bitsX(17, result)
#define show_bits18(result)	show_bitsX(18, result)
#define show_bits19(result)	show_bitsX(19, result)
#define show_bits20(result)	show_bitsX(20, result)
#define show_bits21(result)	show_bitsX(21, result)
#define show_bits22(result)	show_bitsX(22, result)
#define show_bits23(result)	show_bitsX(23, result)
#define show_bits24(result)	show_bitsX(24, result)
#define show_bits25(result)	show_bitsX(25, result)
#define show_bits26(result)	show_bitsX(26, result)
#define show_bits27(result)	show_bitsX(27, result)
#define show_bits28(result)	show_bitsX(28, result)
#define show_bits29(result)	show_bitsX(29, result)
#define show_bits30(result)	show_bitsX(30, result)
#define show_bits31(result)	show_bitsX(31, result)

#define show_bitsn(num, result)	show_bitsX(num, result)


#ifdef NO_SANITY_CHECKS
#define flush_bits32	sn_flush_bits32()
#define flush_bits(num)	sn_flush_bits(num)	
#else
#define flush_bits32	s_flush_bits32()
#define flush_bits(num)	s_flush_bits(num)	
#endif

