#ifndef CHK_ANSI_H
#define CHK_ANSI_H

/*-----------------------------------DEFINE-----------------------------------*/
#define CPRlen 12  /* max. len of CPRstr w/ 3-digit values, incl. CR and \0 */
#define CONSOLE "CON"                     /* Screen in DOS, how about Unix? */
#define KEYBD "CON"                     /* Keyboard in DOS, how about Unix? */
#define SCREEN 3               /* 1=stdout (don't use), 2=stderr, 3=CONSOLE */
#define KEYBOARD 4                       /* 0=stdin using kbhit() and getch(),
                                              without clearing stdin in advance,
                                            1=stdin using kbhit() and getch(),
                                              with clearing stdin in advance,
                                            2=stdin using INPUT (see below),
                                            3=KEYBD using INPUT (see below),
                                            4=combo of 3 and 1 (see below) */
#define INPUT 0                          /* 0=fgets()  (from KEYBD file),
                                            1=getch()  (from stdin only),
                                            2=getc()   (from KEYBD file),
                                            3=fread()  (from KEYBD file),
                                            4=fscanf() (from KEYBD file) */
/* Preferred definitions: SCREEN 3, KEYBOARD 3 and INPUT 0 or 2.
 * Does not work while reading from CON (KEYBOARD=3) with ANSI.COM 1.3;
 * then only stdin may be used, which may NOT be redirected.
 * Preferred definitions then are: SCREEN 3 and KEYBOARD 1 (and INPUT any #).
 * Most safe definitions: SCREEN 3, KEYBOARD 4 and INPUT 0 or 2. This would
 * work in most cases with eventually redirected stdin and in problem cases,
 * like with ANSI.COM 1.3, only with explicitly not-redirected stdin.
 */
                                 /* ANSI escape sequences */
#define CUU "\x1B[1A"            /* cursor up */
#define CUL "\x1B[132D"          /* cursor to Leftmost position */
#define EL  "\x1B[K"             /* erase to end-of-line */
#define DSR "\x1B[6n"            /* Device Status Report */

/*----------------------------PROTOTYPE FUNCTIONS-----------------------------*/
char *ChkAnsiCPR(int, int *, int *);
#if KEYBOARD > 1 && INPUT >= 1
char InputChar(FILE *);
#endif /* KEYBOARD > 1 && INPUT >= 1 */
int CheckCPR (char *, int *, int *);

#endif /* CHK_ANSI_H */
