/***
*dpb.h - disked definitions/declarations for DOS Drive Parameter Information
*
*Copyright (c) 1993-1995, Gregg Jennings.  All wrongs reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   For use with the diskio() functions
*
*Notice:
*   This progam may be freely used and distributed.  Any distrubution
*   with modifications must retain the above copyright statement and
*   modifications noted.
*   No pulp-publication, in whole or in part, permitted without
*   permission (magazines or books).
*******************************************************************************/

#ifndef GENERAL_H
#include "general.h"
#endif

/* DOS Disk structure definitions */

#pragma pack(1)

/* Format of a Boot Sector */

/* This is verbatim MS-DOS Technical Referance for DOS 3.3 */

struct BOOT {
   unsigned char jump[3];           /* 3 byte Near Jump to boot code */
   unsigned char name[8];           /* 8 byte OEM name and version */
   unsigned int  sec_size; /*BPB*/  /* WORD Bytes per sector */
   unsigned char secs_cluster;      /* BYTE Sectors per allocation unit */
   unsigned int  reserved_secs;     /* WORD Reserved sectors (note 1) */
   unsigned char num_fats;          /* BYTE Number of FATs */
   unsigned int  dir_entries;       /* WORD Number of root dir entries */
   unsigned int  num_sectors;       /* WORD Number of sectors in logical
                                       image or 0 (note 2) */
   unsigned char media_desc;        /* BYTE Media descriptor */
   unsigned int  secs_fat; /*BPB*/  /* WORD Number of FAT sectors */
   unsigned int  secs_track;        /* WORD Sectors per track */
   unsigned int  num_heads;         /* WORD Number of heads */
   unsigned int  hidden_sectors;    /* WORD Number of hidden sectors (note 3) */
   unsigned int  large_sectors;     /* WORD High order number of hidden
                                       sectors */
   unsigned long total_sectors;     /* DWORD Number of logical sectors */

   /*
      I've added this to keep it the same as the BPB structure defined
      later.
   */
   unsigned char reserved[6];
};

/* This is the text from the Technical Reference:

   "Although MS-DOS does not use the five fields that follow the BPB, these
   fields may be used by a device driver to help it understand the media.

   "The "Sectors per track" and "Number of heads" fields are useful for
   supporting different media that may have the same logical layout, but
   a different physical layout (for example, 40-track, double-sided versus
   80-track, single-sided). "Sectors per track" tells the device driver how
   the logical disk format is laid out on the physical disk.

   "The "Number of hidden sectors" and "High order number of hidden
   sectors" fields may be used to support drive-partitioning schemes.

   The "Number of logical sectors" field tells the device driver how many
   sectors to reserve if the "Number of sectors in logical image" field is zero
   (Notice taht this is intended for supporting devices that access more than
   32 megabytes.)"

   Note 1: Reserved sectors are the number of sectors that make up the
   boot record.  Although usually 1 that is not always the case.

   Mote 2: If the num_sectors is 0, then there are more than can fit
   in a WORD (65535), i.e. > 32 megabytes (this is how DOS has changed
   to support "un-thought-of" drive sizes), and total_sectors must be
   used. (This is an assumption on my part.)

   Note 3: Hidden sectors are for hard-drives to hold Partitioning
   information.  They are "hidden" from DOS Interrupts 25 and 26, and BIOS
   Interrupt 13, but can be accessed by DOS Interrupt 21/44. (Interrupt
   13 may read them, but I have not tried it.)
   There has been a problem with 'hidden_sectors'.  BPB says DWORD but
   BOOT says WORD (?); WORD seems to work but I've found that it also
   depends on the compiler and the optimizations ;-).

*/

/* BIOS Parameter Block definition */

/*
   There are more fields than described by the BPB area of the BOOT
   structure as defined by MS (bounded by / *BPB* / above), but they are
   the same except for the "reserved" bytes at the end.
*/

struct BPB {
   unsigned int  sec_size;
   unsigned char secs_cluster;
   unsigned int  reserved_secs;
   unsigned char num_fats;
   unsigned int  dir_entries;
   unsigned int  num_sectors;
   unsigned char media_desc;
   unsigned int  secs_fat;
   unsigned int  secs_track;
   unsigned int  num_heads;
   unsigned long hidden_sectors;
   unsigned long total_sectors;
   unsigned char reserved[6];
};

/* Disk Parameter Block */

/* IOCTL Int 21/44 interface */

struct DPB {
   unsigned char special;
   unsigned char dev_type;
   unsigned int  dev_attrib;
   unsigned int  cylinders;
   unsigned char media;
   struct BPB bpb;
};

/* Disk Control Block */

/* For drives larger than 32M */

struct DCB {
     unsigned long sector;
     unsigned int  number;
     unsigned char _far *buffer;
};

#pragma pack()
