page ,132

title lfd ( label floppy disk ) - as of 10/31/96 - 01:10 pm

;*---------------------------------------------------------
;*   this program will allow the user to create / change
;*   the volume label on a diskette in drive a or b
;*---------------------------------------------------------
;*   Syntax :
;*   LFDd:xxx...
;*   where d = drive letter ( a or b )
;*   where xxx... = label name ( max 11 characters )
;*   where  = 1 space
;*---------------------------------------------------------

         .model small

         .code

         org   128

pl       db    0                       ; parm len ( includes space )
         db    0                       ; space
drlt     db    ?                       ; drv ltr
         db    ':'                     ; colon
         db    '?'                     ; anything
newlbl   db    11 dup (0)              ; new label

         org   256

go:      jmp   lfd                     ; jump around data declarations

;
;    search file control block
;

sfcb     equ   $
         db    255
         db    5 dup (0)
svab     db    8                       ; search vol attr byte
sfdn     db    1                       ; search fcb drive number
         db    11 dup ('?')            ; search field ( anything )
         db    25 dup (0)

;
;    create file control block
;

cfcb     equ   $
         db    255
         db    5 dup (0)
         db    8                       ; create vol attr
cfdn     db    1                       ; create fcb drive number
cvl      db    11 dup (' ')            ; create volume label
         db    25 dup (0)

;
;    rename file control block
;

rfcb     equ   $
         db    255
         db    5 dup (0)
         db    8                       ; rename vol attr
rfdn     db    1                       ; rename fcb drive number
         db    11 dup ('?')            ; rename old volume label
         db    5 dup (0)
rnvl     db    11 dup (' ')            ; rename new volume label
         db    9  dup (0)
;
;    input file control block
;

ifcb     equ   $
         db    255
         db    5 dup (0)
ivab     db    8                       ; input vol attr byte
ifdn     db    1                       ; input fcb drv number
ivl      db    11 dup (0)              ; input vol label
         db    25 dup (0)

;
;    miscellaneous messages
;

crlf     db    13,10,36                ; CR, LF

pvlm     db    '* present label = '    ; present vol label msg
vlv      db    11 dup (' ')
         db    13,10,36


nvlm     db    '* the new label is '   ; new vol label msg
nvl      db    11 dup (' ')            ; new vol label
         db    13,10,36

lchok    db    '* label change o.k.',13,10,36
lcrok    db    '* label create o.k.',13,10,36

lchnok    db    '* label change n.o.k.',13,10,36
lcrnok    db    '* label create n.o.k.',13,10,36

iim      equ   $                       ; improper input msg
         db    13,10,10
         db    '  Improper input on command line !!!',13,10,10
         db    '  Syntax :',13,10
         db    '  LFDd:xxx...',13,10
         db    '  where d = drive letter ( a or b )',13,10
         db    '  where xxx... = label name ( max = 11 characters )',13,10
         db    '  where  = 1 space',13,10,10
         db    36

;
;    entry point
;

lfd      proc  near

         cmp   pl,0                    ; no parm ?
         je    errx                    ; if so, error exit

         cmp  pl,5                     ; minimum input ?
         jb   errx                     ; if LT, error exit
         cmp  pl,15                    ; maximum input ?
         ja   errx                     ; if GT, error exit

         cmp  drlt,'a'                 ; 'a' drv ?
         je   sdta
         cmp  drlt,'A'                 ; 'A' drv ?
         je   sdta
         cmp  drlt,'b'                 ; 'b' drv ?
         je   sdtb
         cmp  drlt,'B'                 ; 'B' drv ?
         je   sdtb
         jmp  errx                     ; err !

sdta:                                  ; set drv to 'a'

         mov  sfdn,1
         mov  cfdn,1
         mov  rfdn,1
         mov  ifdn,1
         jmp  mn

sdtb:                                  ; set drv to 'b'

         mov  sfdn,2
         mov  cfdn,2
         mov  rfdn,2
         mov  ifdn,2
         jmp  mn

;
;    error routine
;

errx:

         lea   dx,iim                  ; ptr to improper input msg
         call  lts                     ; list to screen
         jmp   rtd                     ; return to DOS

;
;    move name ( to fcbs and msg )
;

mn:

         lea  si,newlbl
         lea  di,cvl
         mov  ch,0
         mov  cl,pl
         sub  cl,4
         rep  movsb

         lea  si,newlbl
         lea  di,rnvl
         mov  ch,0
         mov  cl,pl
         sub  cl,4
         rep  movsb

         lea  si,newlbl
         lea  di,nvl
         mov  ch,0
         mov  cl,pl
         sub  cl,4
         rep  movsb

;
;    set the disk transfer address
;

stdta:

         lea   dx,ifcb
         mov   ah,26
         int   33

         lea   dx,crlf                 ; CR, LF
         call  lts                     ; to screen

;
;    search for volume label
;

sfvl:

         mov   ah,17
         lea   dx,sfcb
         int   33
         cmp   al,0                    ; if there, rename
         je    rovl
         cmp   al,255                  ; if not there, create
         je    cnvl
         jmp   rtd                     ; give up

;
;    rename old volume label
;

rovl:

         call  dvl                     ; display vol label

         mov   ah,23                   ; set rename file code
         lea   dx,rfcb                 ; point at rename fcb
         int   33                      ; dos call
         cmp   al,0                    ; no error ?
         je    lschm                   ; if so, successful msg
         cmp   al,255                  ; error ?
         je    luchm                   ; if so, unsuccessful msg
         jmp   rtd                     ; give up

;
;    label successful change msgs
;

lschm:

         lea   dx,lchok
         call  lts
         lea   dx,nvlm
         call  lts
         jmp   rtd                     ; return to DOS

;
;    label unsuccessful change msgs
;

luchm:

         lea   dx,lchnok
         call  lts
         lea   dx,nvlm
         call  lts
         jmp   rtd                     ; return to DOS

;
;    create new vol label
;

cnvl:

         mov   ah,22                   ; set creation file code
         lea   dx,cfcb                 ; point at create fcb
         int   33                      ; dos call
         cmp   al,0                    ; no error ?
         je    lscrm                   ; if so, successful msg
         cmp   al,255                  ; err ?
         je    lucrm                   ; if so, unsuccessful msg
         jmp   rtd                     ; give up

;
;    label successful create msgs
;

lscrm:

         lea   dx,lcrok
         call  lts
         lea   dx,nvlm
         call  lts                     ; return to DOS
         jmp   rtd

;
;    label unsuccessful create msgs
;

lucrm:

         lea   dx,lcrnok
         call  lts
         lea   dx,nvlm
         call  lts
         jmp   rtd                     ; reurn to DOS

;
;    display vol label
;

dvl      proc
         lea   si,ivl
         lea   di,vlv
         mov   cx,11
         rep   movsb
         lea   dx,pvlm
         call  lts
         ret
dvl      endp

;
;    list to screen
;

lts      proc  near
         mov   ah,9
         int   33
         ret
lts      endp

;
;    return to dos
;

rtd:

         mov   al,0                    ; set cond code to 0
         mov   ah,76                   ; exit
         int   33

lfd      endp

         end   go