(*
 *  $Id: xfsapi.pas,v 1.85 1994/10/4 17:33:25 xfs Exp $
 *  $Source: /home/xfs/project/win/RCS/xfsapi.pas,v $
 *
 *  XFSAPI.PAS - Interface to XFSLIB.DLL & XFSFMX.DLL
 *  Borland Pascal Version
 *
 *  Copyright (C) 1994 Robert Juhasz
 *)

unit
  XfsApi;

interface

uses
  WinTypes;

const
  { def./max MOUNT options }
  MOUNT_MAX_RSIZE = 1280;
  MOUNT_MAX_WSIZE = 1280;
  MOUNT_MAX_FWSIZE= 8192;    { for XFS IPF }
  MOUNT_DEF_RETRY = 4;

  { MOUNT flags }
  MOUNT_OPT_RO    = 1;       { read-only      }
  MOUNT_OPT_MAP   = 2;       { 8+3 mapping }
  MOUNT_OPT_UPPER = 4;       { uppercase mapping (for CD-ROMS's) }

  MOUNT_DEF_OPT   = MOUNT_OPT_MAP;  { my default option }

  CM_MOUNT        = 1;       { FMX mount  }
  CM_UMOUNT       = 2;       { FMX umount }
  CM_LOGIN        = 3;       { FMX login  }
  CM_LOGOUT       = 4;       { FMX logout }
  CM_INFO         = 5;       { FMX info   }

type
  { Mount options struct }
  TMOUNTOPT = record
    timeo: Word;    { seconds, for printers only }
    rsize: Word;
    wsize: Word;
    retry: Word;
    flags: Word;
  end;

  { XFS Host info }
  TXFSINFO = record
    version: Word;          { XFS version, eg. 0x0177 for 1.77 or 0x8177 for 1.77IPF }
    hostname: array[0..63] of Char;     { Host name             }
    ip_addr: Longint;                   { Hostname's IP address }
    sm_addr: Longint;                   { Subnet mask           }
    gw_addr: Longint;                   { Gateway IP address    }
    pc_addr: Longint;                   { PCNFSD IP address     }
    username: array[0..63] of Char;     { User name             }
    uid: Word;                          { User ID               }
    gid: Word;                          { Group ID              }
    umask: Word;                        { File creation mask    }
  end;

  { Error codes }
const
  { inet }
  ECONN        = -1;            { can't connect (generic)   }
  ENETUNREACH  = -2 - 0;        { network unreachable       }
  EHOSTUNREACH = -2 - 1;        { host unreachable          }
  EPROTUNREACH = -2 - 2;        { unknown protocol          }
  EPORTUNREACH = -2 - 3;        { unknown port              }
  ESOCK        = -10;           { bad socket descriptor     }
  ENOSOCK      = -11;           { out of socket descriptors }
  ETIMEO       = -12;           { connection timeout        }

  { arp }
  EARPTIMEO    = -51;           { ARP timeout               }
  EARPUNREACH  = -52;           { local host not responding }

  { host }
  EHOSTIO      = -200;          { 'hosts' file not found    }
  EHOSTNOENT   = -201;          { host not in 'hosts'       }

  { (u)mount }
  EMOUNT       = -300;          { can't mount/umount(given by server) }

  { pcnfsd }
  EPCACCES     = -400;          { authentication failure }
  EPCNOPRN     = -401;          { unknow printer         }
  EPCFAIL      = -402;          { failed initialization  }

  { portmap }
  EPMPORT      = -500;          { port not found         }

  { dpmi }
  EDOSMEM      = -600;          { can't allocate lower DOS mem }

  { Redirector (positive values!) }
  EDUP         =  $55;          { Duplicate redirections           }
  EDRIVE       =  $0f;          { Drive/device invalid             }
  EMEM         =  $08;          { insuficient memory in redirector }
  EFUNC        =  $01;          { invalid operation                }


(*
 *
 *)

function XfsInstalled: Bool;
function XfsMountDrive(localdrive, host, filesystem: PChar; var options: TMOUNTOPT): Integer;
function XfsMountPrinter(localdrive, host, printer: PChar; var options: TMOUNTOPT): Integer;
function XfsUmount(localdrive: PChar ): Integer;
function XfsFlush(printer: PChar ): Integer;
function XfsLogin(localdrive, host, name, password: PChar ): Integer;
procedure XfsLogout(localdrive: PChar);
procedure XfsNetStat( var info: TXFSINFO );
function XfsUmask( mask: Word): Word;
function WGetRedirection( index: Word; device, resource: PChar ): Word;

{ File Manager Extension }
function InitFMX: Longint;
procedure DoneFMX;
function XfsFMXCall( Handle: HWnd; call: Word): Longint;

implementation

function XfsInstalled;     external 'XFSLIB' index  1;
function XfsMountDrive;    external 'XFSLIB' index  2;
function XfsMountPrinter;  external 'XFSLIB' index  3;
function XfsUmount;        external 'XFSLIB' index  4;
function XfsFlush;         external 'XFSLIB' index  5;
function XfsLogin;         external 'XFSLIB' index  6;
procedure XfsLogout;       external 'XFSLIB' index  7;
procedure XfsNetStat;      external 'XFSLIB' index  8;
function XfsUmask;         external 'XFSLIB' index  9;
function WGetRedirection;  external 'XFSLIB' index 10;

function InitFMX;          external 'XFSFMX' index  2;
procedure DoneFMX;         external 'XFSFMX' index  3;
function XfsFMXCall;       external 'XFSFMX' index  4;

end.
