INITIALIZE:
   KEY OFF
   CLS
   bp = 8
   address = 0
   octet = 1
   FOR r = 0 TO 1
      FOR c = 1 TO 4
         a$(r, c) = "000"
         b$(r, c) = "00000000"
         host$(c) = "        "
         net$(c) = "        "
         netw$(c) = "   "
         bcast$(c) = "   "
         hmin$(c) = "   "
         hmax$(c) = "   "
      NEXT c, r
   REM "DAVID GREENWELL - BANYAN SYSTEMS 1995"
   LOCATE 2, 25: PRINT "TCP/IP Address Analyzer Program"
   LOCATE 3, 1: PRINT STRING$(79, "=");
   LOCATE 7, 1: PRINT STRING$(79, "=");
   LOCATE 15, 21: PRINT "--------   --------   --------   --------"
   LOCATE 16, 5: PRINT "Network Bits ="
   LOCATE 17, 5: PRINT "   Host Bits ="
   LOCATE 19, 5: PRINT "Network Class =               Number of Networks ="
   LOCATE 20, 5: PRINT "    Mask Bits =            Number of SubNetworks ="
   LOCATE 21, 5: PRINT "                             Number of Hosts/Net ="
   LOCATE 23, 5: PRINT "Press ESC to quit"
   GOSUB PRINT.RESULT


CALC.ROW:
   r = ABS(address) * 2 + 4
 
CALC.COL:
   IF address = -1 THEN
      IF class$ = "A" AND octet < 2 THEN octet = 2
      IF class$ = "B" AND octet < 3 THEN octet = 3
      IF class$ = "C" AND octet < 4 THEN octet = 4
   END IF
   c = octet * 6 + 29

GETKEY.INIT:
   i% = 0
   i$ = ""

NEXT.OCTET:
   i% = i% + 1
   IF i% = 4 THEN
      LOCATE r, c
      PRINT " "
      LOCATE r, c + 4
      PRINT " "
      GOTO VALIDATE
   END IF

GETKEY:
   COLOR 10
   LOCATE r, c
   PRINT ">"
   LOCATE r, 4 + c
   PRINT "<";
   COLOR 7
GETKEY1:
   i1$ = INKEY$
   IF i1$ = "" GOTO GETKEY1
   a = ASC(RIGHT$(i1$, 1))
   SELECT CASE a
      CASE IS = 8
         GOTO BACKSPACE
      CASE IS = 27
         END
      CASE IS = 72, 75, 77, 80
         GOTO ARROWS
      CASE IS = 13
         IF i% > 1 GOTO VALIDATE
         GOTO GETKEY1
      CASE IS < 48, IS > 57
         GOTO BAD.ADDRESS
   END SELECT
   i$ = RIGHT$("000" + i$ + i1$, 3)
   LOCATE r, c + 1
   PRINT i$
   GOTO NEXT.OCTET

VALIDATE:
   d# = VAL(i$)
   IF d# > 255 GOTO BAD.ADDRESS
   a$(ABS(address), octet) = i$
   IF address = 0 AND octet = 1 GOTO GET.CLASS
   IF address = -1 THEN
      IF VAL(a$(1, octet - 1)) < 255 AND d# > 0 GOTO BAD.ADDRESS
      SELECT CASE d#
         CASE IS = 0, 128, 192, 224, 240, 248, 252, 254, 255
            GOTO INPUT.OK
      END SELECT
      GOTO BAD.ADDRESS
   END IF
   GOTO INPUT.OK

GET.CLASS:
   SELECT CASE d#
      CASE IS < 128
         class$ = "A"
         sb = 2
         a$(1, 1) = "255"
         a$(1, 2) = "000"
         a$(1, 3) = "000"
         a$(1, 4) = "000"
         b$(1, 1) = "11111111"
         b$(1, 2) = "00000000"
         b$(1, 3) = "00000000"
         b$(1, 4) = "00000000"
      CASE IS < 192
         class$ = "B"
         sb = 3
         a$(1, 1) = "255"
         a$(1, 2) = "255"
         a$(1, 3) = "000"
         a$(1, 4) = "000"
         b$(1, 1) = "11111111"
         b$(1, 2) = "11111111"
         b$(1, 3) = "00000000"
         b$(1, 4) = "00000000"
      CASE IS > 191
         class$ = "C"
         sb = 4
         a$(1, 1) = "255"
         a$(1, 2) = "255"
         a$(1, 3) = "255"
         a$(1, 4) = "000"
         b$(1, 1) = "11111111"
         b$(1, 2) = "11111111"
         b$(1, 3) = "11111111"
         b$(1, 4) = "00000000"
   END SELECT
   LOCATE 19, 22: PRINT class$
   
INPUT.OK:
   GOSUB DEC2BIN
   b$(ABS(address), octet) = b$
   GOSUB NETHOST
   GOSUB PRINT.RESULT
   IF class$ <> "" THEN
      GOSUB CALC.BITS
   END IF
   octet = octet + 1
   IF octet = 5 THEN
      octet = 1
      GOTO CHANGE.COL
   END IF
   GOTO CALC.COL

CHANGE.COL:
   LOCATE r, c + 4
   PRINT " "
   address = NOT (address)
   GOTO CALC.ROW

PRINT.RESULT:
   LOCATE 4, 20
   PRINT "    IP Address: "; a$(0, 1); " . "; a$(0, 2); " . "; a$(0, 3); " . "; a$(0, 4)
   LOCATE 6, 20
   PRINT "   Subnet Mask: "; a$(1, 1); " . "; a$(1, 2); " . "; a$(1, 3); " . "; a$(1, 4)
   LOCATE 8, 20
   PRINT "       Network: "; netw$(1); " . "; netw$(2); " . "; netw$(3); " . "; netw$(4)
   LOCATE 9, 20
   PRINT "      Host Min: "; hmin$(1); " . "; hmin$(2); " . "; hmin$(3); " . "; hmin$(4)
   LOCATE 10, 20
   PRINT "      Host Max: "; hmax$(1); " . "; hmax$(2); " . "; hmax$(3); " . "; hmax$(4)
   LOCATE 11, 20
   PRINT "     Broadcast: "; bcast$(1); " . "; bcast$(2); " . "; bcast$(3); " . "; bcast$(4)
   LOCATE 13, 5
   PRINT "Binary Address: "; b$(0, 1); " . "; b$(0, 2); " . "; b$(0, 3); " . "; b$(0, 4)
   LOCATE 14, 5
   PRINT "   Binary Mask: "; b$(1, 1); " . "; b$(1, 2); " . "; b$(1, 3); " . "; b$(1, 4)
   LOCATE 16, 5
   PRINT "  Network Bits: "; net$(1); " . "; net$(2); " . "; net$(3); " . "; net$(4)
   LOCATE 17, 5
   PRINT "     Host Bits: "; host$(1); " . "; host$(2); " . "; host$(3); " . "; host$(4)
   RETURN
    
BAD.ADDRESS:
   LOCATE 5, 36
   COLOR 4
   PRINT "Invalid Address Value"
   FOR delay = 1 TO 2
      BEEP
   NEXT delay
   LOCATE 5, 36
   PRINT "                      "
   COLOR 7
   a$(ABS(address), octet) = "000"
   LOCATE r, c + 1
   PRINT "000"
   GOTO GETKEY.INIT

ARROWS:
   LOCATE r, c
   PRINT " "
   LOCATE r, c + 4
   PRINT " "
   SELECT CASE a
      CASE IS = 72, 80
         address = NOT (address)
         GOTO CALC.ROW
      CASE IS = 77
         octet = octet + 1
         IF octet = 5 THEN octet = 1
         GOTO CALC.COL
      CASE IS = 75
         octet = octet - 1
         IF octet = 0 THEN octet = 4
         GOTO CALC.COL
   END SELECT

BACKSPACE:
   i% = i% - 1
   IF i% = 0 THEN
      BEEP
      i% = 1
   END IF
   i$ = LEFT$("0" + i$, 3)
   LOCATE r, c + 1
   PRINT i$
   GOTO GETKEY

CALC.BITS:
   maskbits = 0
   FOR x = sb TO 4
   FOR y = 1 TO 8
      IF MID$(b$(1, x), y, 1) = "1" THEN
         maskbits = maskbits + 1
      END IF
   NEXT y, x
   LOCATE 20, 21: PRINT maskbits
   subnet# = 2 ^ maskbits
   LOCATE 20, 56: PRINT subnet#; "         "
   SELECT CASE class$
   CASE IS = "A"
      nets# = 2 ^ (8 + maskbits)
      hosts# = 2 ^ (24 - maskbits)
      LOCATE 19, 56: PRINT nets#; "          "
      LOCATE 21, 56: PRINT hosts#; "          "
   CASE IS = "B"
      nets# = 2 ^ (16 + maskbits)
      hosts# = 2 ^ (16 - maskbits)
      LOCATE 19, 56: PRINT nets#; "          "
      LOCATE 21, 56: PRINT hosts#; "          "
   CASE IS = "C"
      nets# = 2 ^ (24 + maskbits)
      hosts# = 2 ^ (8 - maskbits)
      LOCATE 19, 56: PRINT nets#; "          "
      LOCATE 21, 56: PRINT hosts#; "          "
   END SELECT
   RETURN

NETHOST:
   flag = 0
   FOR x = 1 TO 4
      net$(x) = ""
      host$(x) = ""
      bcast1$(x) = ""
      hmin1$(x) = ""
      hmax1$(x) = ""
      netw1$(x) = ""
   NEXT x
   FOR z = 1 TO 4
      d# = VAL(a$(0, z)) AND VAL(a$(1, z))
      GOSUB DEC2BIN
      nb$ = b$
      d# = VAL(a$(0, z)) OR VAL(a$(1, z))
      GOSUB DEC2BIN
      hb$ = b$
      FOR y = 1 TO 8
         IF MID$(b$(1, z), y, 1) = "0" THEN flag = 1
         nb1$ = MID$(nb$, y, 1)
         hb1$ = MID$(hb$, y, 1)
         IF flag = 0 THEN
            net$(z) = net$(z) + nb1$
            host$(z) = host$(z) + " "
            bcast1$(z) = bcast1$(z) + nb1$
            hmin1$(z) = hmin1$(z) + nb1$
            hmax1$(z) = hmax1$(z) + nb1$
            netw1$(z) = netw1$(z) + nb1$
         END IF
         IF flag = 1 THEN
            net$(z) = net$(z) + " "
            host$(z) = host$(z) + hb1$
            bcast1$(z) = bcast1$(z) + "1"
            netw1$(z) = netw1$(z) + "0"
            IF z = 4 AND y = 8 THEN
               hmin1$(z) = hmin1$(z) + "1"
               hmax1$(z) = hmax1$(z) + "0"
            ELSE
               hmin1$(z) = hmin1$(z) + "0"
               hmax1$(z) = hmax1$(z) + "1"
            END IF
         END IF
      NEXT y
         b$ = hmin1$(z)
         GOSUB BIN2DEC
         d$ = RIGHT$(STR$(d#), LEN(STR$(d#)) - 1)
         hmin$(z) = RIGHT$("000" + d$, 3)
         b$ = hmax1$(z)
         GOSUB BIN2DEC
         d$ = RIGHT$(STR$(d#), LEN(STR$(d#)) - 1)
         hmax$(z) = RIGHT$("000" + d$, 3)
         b$ = bcast1$(z)
         GOSUB BIN2DEC
         d$ = RIGHT$(STR$(d#), LEN(STR$(d#)) - 1)
         bcast$(z) = RIGHT$("000" + d$, 3)
         b$ = netw1$(z)
         GOSUB BIN2DEC
         d$ = RIGHT$(STR$(d#), LEN(STR$(d#)) - 1)
         netw$(z) = RIGHT$("000" + d$, 3)
         
      NEXT z
   RETURN

DEC2BIN:
   D9# = d#: b$ = ""
   FOR x = bp - 1 TO 0 STEP -1
      b = INT(D9# / 2 ^ x)
      D9# = D9# - b * 2 ^ x
      b$ = b$ + RIGHT$(STR$(b), 1)
   NEXT x
   RETURN

BIN2DEC:
   d# = 0
   FOR x = bp - 1 TO 0 STEP -1
      b9 = VAL(MID$(b$, bp - x, 1))
      d# = d# + b9 * 2 ^ x
   NEXT x
   RETURN

