        title   RS232 hardware test


Cseg    segment para public 'code'

        org 100h

        assume cs:cseg,ds:cseg,es:nothing,ss:cseg



entry   proc far


su1:
  call htest
  push cs
  xor ax,ax
  push ax
  ret


entry   endp




msg0       db 13,10
           db "RS232 test",10,13,10,13
           db 0


L8250      dw 0              ;rs232 card address


htest  proc near

  push cs
  pop ds
  mov si,80h
  lodsb
  xor cx,cx
  mov cl,al
  jcxz h6aac

h6aaa:
  lodsb
  cmp al,"1"
  jc h6aab
  cmp al,"5"
  jnc h6aab
  sub al,"1"
  mov cs:comnum,al
  jmp h6aac

h6aab:
  loop h6aaa

h6aac:
  mov ax,40h
  mov es,ax
  xor bx,bx
  mov bl,cs:comnum
  shl bx,1
  mov ax,es:[bx]
  mov cs:L8250,ax
  or ax,ax
  jnz h6aa

  mov si,offset msg6
  call outstr
  ret

h6aa:

  xor ax,ax
  mov es,ax
  mov ax,es:400h
  or ax,ax
  jz h2
  inc cs:coms
  mov si,offset msg8
  call outstr
  call hexax
  mov si,offset msg1
  call outstr

h2:
  mov ax,es:402h
  or ax,ax
  jz h3
  inc cs:coms
  mov si,offset msg8
  call outstr
  call hexax
  mov si,offset msg2
  call outstr

h3:
  mov ax,es:404h
  or ax,ax
  jz h4
  inc cs:coms
  mov si,offset msg8
  call outstr
  call hexax
  mov si,offset msg3
  call outstr

h4:
  mov ax,es:406h
  or ax,ax
  jz h5
  inc cs:coms
  mov si,offset msg8
  call outstr
  call hexax
  mov si,offset msg4
  call outstr

h5:
  mov al,cs:coms
  or al,al
  jnz h6
  mov si,offset msg5
  call outstr
  ret


h6:
  call hexal
  mov si,offset msg7
  call outstr
  mov al,0
  mov cs:comnum,0

  push cs
  pop ds
  call setup
  mov cx,5

h6a:
  push cx
  mov dx,cs:L8250
  mov al,"1"
  out dx,al
  xor cx,cx
  add dx,5

h6b:
  in al,dx
  test al,1
  jnz h6c
  loop h6b

  pop cx
  loop h6a
  jmp h6cc

h6c:
  pop cx
  sub dx,5
  in al,dx
  cmp al,"2"
  jz h6d
call hexal
  loop h6a

h6cc:
  mov si,offset msg9
  call outstr
  ret


h6d:
  push cs
  pop ds
  call teststr
  db "Data link established",10,13,0

  mov dx,L8250
  add dx,4
  mov al,1
  or al,cs:OUT1
  out dx,al
  inc dx
  inc dx
  xor cx,cx

h6e:
  in al,dx
  test al,20h
  jnz h6f
  loop h6e

  call teststr
  db "DSR from other machine never went high, may be absent or shorted low"
  db 10,13,7,0
  ret



h6f:
  dec dx
  dec dx
  xor al,al
  or al,cs:OUT1
  out dx,al
  xor cx,cx
  inc dx
  inc dx  

h6g:
  in al,dx
  test al,20h
  jz h6h
  loop h6g

  call teststr
  db "DSR from other machine did not return low, may be tied high",10,13,7,0
  ret

h6h:
  call teststr
  db "DSR-DTR lines good",10,13,10,13,0

h7:
  call chrin
  jc h9
  or al,al
  jz h8
  mov ah,14
  int 10h
  jmp h7


h8:
  call teststr
  db 10,13,10,13,"CHECK OK",10,13,0
  ret

h9:
  call teststr
  db "Error in receiving char string, cable may be noisy",10,13,0
  ret

msg1 db ", COM1 is installed",10,13,0
msg2 db ", COM2 is installed",10,13,0
msg3 db ", COM3 is installed",10,13,0
msg4 db ", COM4 is installed",10,13,0
msg5 db "No COM ports were found",7,10,13,0
msg6 db "Specified COM port is not installed",7,10,13,0
msg7 db " COM port(s) found",10,13,0
msg8 db "At port ",0
msg9 db "Data lines did not establish good link",10,13,0

;page
;........................... out char (al) ....................................

cout:
  push ax
  mov dx,cs:L8250            ;get rs232 card addr
  add dl,4                   ;dx --> modem control reg
  xor al,al
  or al,cs:OUT1
  out dx,al                  ;RTS, DTR = 0
  add dl,2                   ;dx --> modem status reg.
  mov cs:tries,4             ;init timeout
  xor cx,cx



                             ;wait for master ready

co1:
  in al,dx                   ;input modem status reg
  test al,20h                ;is  DSR = 1  yet?
  jnz co2                    ;no:               yes-->
  loop co1

  dec cs:tries               ;is this a timeout?
  jnz co1                    ;yes:              no-->
  pop ax                     ;
  jmp co6                    ;--> error




                             ;make sure transmitter is empty

co2:
  dec dx                     ;dx --> line status
  mov cs:tries,4             ;init timeout
  xor cx,cx

co3:
  in al,dx                   ;input line status 
  test al,20h                ;is transmitter empty?   
  jnz co4                    ;no:                 yes--> 
  loop co3                   ;wait til it is

  dec cs:tries               ;is this a hardware error?
  jnz co3                    ;yes:            not yet -->
  pop ax                     ;
  jmp co6                    ;-->  error



                             ;send the byte
co4:
  inc dx                     ;clear delta DSR bit
  in al,dx                   ;
  pop ax                     ;restore data
  sub dx,6                   ;dx --> buffer
  out dx,al                  ;send char  (al)
  add dx,6

;page
                             ;wait for DSR acknowledge

  xor cx,cx                  ;init timeout
  mov cs:tries,4

co5:
  in al,dx                   ;read status
  test al,2                  ;has DSR changed yet?
  jnz co5a                   ;no:              yes-->
  loop co5                   ;is timeout?
  dec tries                  ;
  jnz co5                    ;yes:             no-->



                             ;ERROR:

co6:
  call modeminit             ;init modem control reg.
  mov al,2                   ;error = device not ready
  stc                        ;return bad
  ret



co5a:
  clc                        ;return good
  ret

;page
;........................... input char to al .................................

chrin:
  mov dx,cs:L8250            ;get RS232 card addr
  add dl,4                   ;dx --> modem control reg
  mov al,1
  or al,cs:OUT1
  out dx,al                  ;signal ready:    DTR=1
  inc dx                     ;dx --> line status reg.
  mov cs:tries,4             ;setup wait counter
  xor cx,cx


                             ;wait for char
ci1:
  in al,dx                   ;is reciever buffer full?
  test al,1
  jnz ci2                    ;no:                 yes-->
  loop ci1                   ; 

  dec cs:tries               ;is this timeout?
  jnz ci1                    ;yes:                no--> try again

  call teststr
  db 10,13,"CHRIN: char never came",10,13,0

  jmp ci4                    ;timeout -->


                             ;read the char
ci2:
  mov ch,al                  ;save reciever line status
  sub dl,5                   ;dx --> reciever buffer
  in al,dx                   ;get char
  test ch,1EH                ;any errors?
  jz  ci3                    ;no:                  yes -->

  call teststr
  db 10,13,"CHRIN: receiver line status error, cable may be noisy",10,13,0

  jmp ci4


                             ;got a good char
ci3:
  push ax
  add dl,4                   ;dx --> modem control reg
  xor al,al                  ;DTR = 0
  or al,cs:OUT1
  out dx,al
  pop ax                     ;al= char, return good
  clc
  ret



                             ;ERROR:

ci4:
  call modeminit             ;init modem control reg
  mov al,2                   ;error = device not ready
  stc                        ;return bad 
  ret



tries      db 0



;page
;........................... Setup modem .....................................

setup:
  push cs
  pop ds
  mov dx,L8250               ;dx --> 8250 reg0
  inc dx                     ;dx --> 8250 reg1 = interrupt enable reg
  mov al,0                   ;disable this card's interrupts
  out dx,al                  ;
  add dl,2                   ;dx --> 8250 reg3 = line control reg
  mov al,80h                 ;select divisor latch
  out dx,al
  sub dl,3                   ;dx --> 8250 reg0 = LSB of divisor
  mov al,speed               ;write baud rate divisor
  out dx,al
  mov al,0
  inc dx
  out dx,al
  add dl,2                   ;dx --> 8250 reg3 = line control reg
  mov al,0Bh ;3              ;odd parity, 1stop, 8bits
  out dx,al
  call modeminit             ;init modem control reg. : DTR = 0
  clc                        ;return good
  ret

;........................... Init modem ....................................

modeminit:
  mov dx,cs:L8250            ;get rs232 card addr
  add dl,4
  xor al,al                  ;init modem control reg
  or al,cs:OUT1
  out dx,al                  ;DTR, RTS = 0
  ret








outstr:
  push ax

o1:
  lodsb                      ;get next char
  or al,al                   ;is end of string?
  jz o2                      ;no:              yes-->
  mov ah,14                  ;print it
  push si
  int 10h
  pop si
  jmp o1                     ;do more-->

o2:
  pop ax
  ret





teststr:
  mov cs:test_si,si
  mov cs:test_di,di
  mov cs:test_ax,ax
  mov cs:test_ds,ds
  sahf
  mov cs:test_f,ah
  mov si,cs
  mov ds,si
  pop si
  call outstr
  push si
  mov ah,cs:test_f
  lahf
  mov ds,cs:test_ds
  mov ax,cs:test_ax
  mov di,cs:test_di
  mov si,cs:test_si
  ret


test_di dw 0 
test_si dw 0
test_ax dw 0
test_ds dw 0
test_f  db 0




;page

hexal:
  push ax
  push cx
  mov ch,al
  mov cl,4
  shr al,cl
  add al,"0"
  cmp al,3Ah
  jc hx1
  add al,7

hx1:
  mov ah,14
  int 10h
  mov al,ch
  and al,0fh
  add al,"0"
  cmp al,3Ah
  jc hx2
  add al,7

hx2:
  mov ah,14
  int 10h
  pop cx
  pop ax
  ret




hexax:
  push ax
  mov al,ah
  call hexal
  pop ax
  call hexal
  ret

  

OUT1       db 0
speed      db 2
comnum     db 0
coms       db 0


htest      endp

Cseg       ends
           end su1












