/* - 731_3.c -- 731 tarkistusmerkin laskenta. pvm=17.6.94,  21:04
                by Vesa Tuomi
                
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define TESTI        0

#define PVIITEMAX   20

/*

Viitepankkisiirto
- Viitetieto on numeerinen tieto, jonka pituus on enintn 19 merkki,
  lisksi mukaan liitetn aina tarkiste (siis 19 + 1).
- Tarkistettavan viitteen numerot kerrotaan oikealta vasemmalle
  painoarvoilla 7, 3, 1, 7, 3, 1... Kertotulot lasketaan yhteen
  ja summa vhennetn seuraavasta tydest kymmenest. Erotus on
  tarkiste ja se tulostetaan viitteen viimeiseksi numeroksi.
- Pankkisiirrolle viite tulostetaan lomakkeen alaosaan 3. riville
  (rivi 1/6") alhaalta siten, ett viitteen viimeinen merkki (tarkiste)
  osuu 36. positioon laskettuna lomakkeen oikeasta reunasta. Viite
  ryhmitelln oikealta lukien viiden merkin ryhmiksi, jotka erotetaan
  toisistaan yhdell tyhjll positiolla.
  /pankkiyhdistyksen tiedoite.../
*/

/* - Tarkistusmerkin 731 -laskenta.
 ' - Input-string max 19 merkki
 ' - Output-string = input + tark.merkki
 ' - Paluukoodit: 1=Ok, 0=Virhe
 ' - Pvm=22.4.89,  22:04
 */
int laske_731(char *istr)
{
  char tmp[2];
  int i=0, k=0, s=0, t=0;

  /* lasketaan tarkistussumma */
  tmp[0] = tmp[1] = '\0';
  k = 7;
  for (i=strlen(istr)-1; i>=0; i--) {
    tmp[0] = istr[i];
    if (isdigit(tmp[0])) {
      t = atoi(tmp);
      s += t * k;
      switch(k) {
	case 7: k = 3; break;
	case 3: k = 1; break;
	case 1: k = 7; break;
      }
    }
  }

  /* otetaan viimeinen numero talteen */
  i = (9 + s) / 10;   i *= 10;   s = i - s;
  
  /* liitetn tarkistusmerkki pern */
  itoa(s, tmp, 10);   strcat(istr, tmp);
  
  return(0);
}

/* - tarkistusmerkin tarkastus
 ' - input-string, viitetieto
 ' - paluukoodi: 1=Ok, 0=Virhe
 ' - Pvm=22.4.89,  22:04
 */
int tark_731(char *istr)
{
  char tmp[81];
  int  i;

  strcpy(tmp, istr);
  i = strlen(tmp) - 1;
  tmp[i] = '\0';
  laske_731(tmp);

  if (strcmp(istr, tmp) == 0)
    return(1);	/* tosi */
  else
    return(0);
}

/* - Pankkiviitteen editointi
 ' - input-string, editoimaton viitetieto
 ' - paluukoodi: 1=Ok, 0=Virhe
 ' - Pvm=22.4.89,  22:04
 */
int pviite_731(char *istr)
{
  char tmp[81];
  char ostr[81];
  int  i, j, k;
/*<<<MARK>>>
*/

  /* oikealaitaistetaan input */
  strcpy(tmp, "                    ");
  if ((i=strlen(istr)) > PVIITEMAX) {
    strcpy(istr, "input viite max virhe");
    return(0);
  }
  tmp[PVIITEMAX-i]='\0';
  strcat(tmp, istr);

  strcpy(ostr, "--------------------------");

  /* siirretn viite outputille: i=ostr, k=tmp, j=lohko */
  ostr[PVIITEMAX+3] = '\0';
  for (i=0, k=0; i<PVIITEMAX; i+=5, k+=5) {
    for (j=0; j<5; j++) {
      ostr[i+j] = tmp[k+j];
    }
    if ((i+j) != PVIITEMAX+3)
      ostr[i+j] = ' ';    /* tss j on jo 5 */
    i++;
  }

  /* palautetaan editoitu string */
  strcpy(istr, ostr);

  return(1);	/* tosi */
}

#if TESTI==1
main()
{
  char a[40];
  char b[40];
  char c[4];
  char t;

  printf("\n\n\n\n\n\n\n");

  strcpy(a, "295527868796"); 
/*  strcpy(a, "5501019890422"); */

  strcpy(b, a);

  if (!(laske_731(a)))
    printf("Tarkistusmerkki listty %s -> :%s:\n", b, a);
  else
    printf("Ei onnistunut\n");

  if (tark_731(a))
    printf("Tarkistusmerkki ok\n");
  else
    printf("Tarkistusmerkki ei ok <----------\n");

  if (!(pviite_731(a))) {
    printf("Virhe viitteen muodostamisessa %s\n", a);
  }
  else {
    printf("                  12345 12345 12345 12345\n");
    printf("Viite editoituna :%s:\n", a);
  }

  if (tark_731(a))
    printf("Tarkistusmerkki ok\n");
  else
    printf("Tarkistusmerkki ei ok <----------\n");

  exit(0);
}
#endif
/* eof */
