
//      clip.v -- test out new clipping planes

#include color.vc

studio {
	from 1 -6 4
	at 0 0 0
	up 0 0 1
	angle 35
	res 640 480
	antialias adaptive
	aspect 4/3
	background {
		greys.map
	}
	ambient white * .2
}

light {
	type point
	falloff 0
	position 1 -.5 5
	color white * .5
}
light {
	type point
	falloff 0
	position -2 -4 5
	color white * .5
}

//      base surface

surface {
	diff plum * .5          // dark plum
}
ring { center 0 0 0 normal 0 0 1 radius 1000 }

//      clip spheres

surf {
	diff 0 .5 1
	shine 20 white
}

sphere {
	center -1.5 0 .5
	radius .5
	clip {
		center -1.5 0 .2
		normal 0 0 -1   // only keep bottom part
	}
}
sphere {
	center -0.5 0 .5
	radius .5
	clip {
		center -0.5 0 .4
		normal 0 0 -1   // only keep bottom part
	}
}
sphere {
	center 0.5 0 .5
	radius .5
	clip {
		center 0.5 0 .6
		normal 0 0 -1   // only keep bottom part
	}
}
sphere {
	center 1.5 0 .5
	radius .5
	clip {
		center 1.5 0 .8
		normal 0 0 -1   // only keep bottom part
	}
}


sphere {        //      keep bottom wedge
	center -1.5 -1 .5
	radius .5
	clip {
		center -1.5 -1 .2
		normal 1 0 -1   // only keep bottom part
	}
	clip {
		center -1.5 -1 .2
		normal -1 0 -1   // only keep bottom part
	}
}

//      use two hemispheres to make a cup with thickness

sphere {
	center 0 -1 .5
	radius .5
	clip {
		center 0 -1 .5
		normal 0 0 -1   // only keep bottom part
	}
}
sphere {
	center 0 -1 .5
	radius .4
	clip {
		center 0 -1 .5
		normal 0 0 -1   // only keep bottom part
	}
}
ring {          // edge of clip cup
	center 0 -1 .5
	normal 0 0 1
	min_radius .4   // radius of inner hemisphere
	max_radius .5   // radius of outer hemisphere
}

sphere {        // keep ring around center
	center 1.5 -1 .5
	radius .5
	clip {
		center 1.5 -1 .6
		normal 0 0 -1   // toss top
	}
	clip {
		center 1.5 -1 .4
		normal 0 0 1    // toss bottom
	}
}

