/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

class DoubleTextAdapter {
    Text textField;

    Text getObject() {
        return this.textField;
    }

    DoubleTextAdapter(Text textField) {
        this.textField = textField;
        textField.addVerifyListener((VerifyListener)new DoubleVerifyListener());
    }

    public double getDoubleValue() {
        double value = 0.0;
        try {
            value = Float.parseFloat(this.textField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public void setDoubleValue(Double value) {
        this.textField.setText(String.format("%4.2f", value));
    }

    private class DoubleVerifyListener
    implements VerifyListener {
        private DoubleVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            String string = e.text = e.text.toUpperCase();
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if (('0' > chars[i] || chars[i] > '9') && chars[i] != '.') {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            String originalValue = ((Text)e.getSource()).getText();
            String newValue = String.valueOf(originalValue.substring(0, e.start)) + e.text + originalValue.substring(e.end, originalValue.length());
            if (!newValue.isEmpty()) {
                try {
                    Float.parseFloat(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        }
    }
}

