/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.util.Vector;

class VlanPanel
extends ICPanel {
    public static final int numFields = 6;
    static boolean dlgOpen;
    static Object dlgMutex;
    EditMPOADialog dlgMPOA;
    VLANDlg vlanDlg;
    int vlanSortField = 0;
    boolean vlanSortOrder = true;
    Vector vlanList = new Vector();
    String selectedIFname;
    Vector serverList = new Vector();
    int serverSortField = 0;
    boolean serverSortOrder = true;
    Vector ARPList = new Vector();
    int ARPSortField = 0;
    boolean ARPSortOrder = true;
    boolean nonPVCs;

    VlanPanel(ICFrame iCFrame) {
        super(iCFrame);
        this.frame = iCFrame;
        this.vlanDlg = new VLANDlg(this);
    }

    public void init() {
        this.vlanDlg.CreateControls();
        this.vlanDlg.VLANList.setBackground(Color.white);
        this.vlanDlg.ServerAddrList.setBackground(Color.white);
        this.vlanDlg.ARPList.setBackground(Color.white);
        ((Component)this).setFont(this.frame.fixFont);
        this.vlanDlg.setControlFont(this.frame.baseFont);
        this.vlanDlg.VLANList.setFont(this.frame.fixFont);
        this.vlanDlg.ServerAddrList.setFont(this.frame.fixFont);
        this.vlanDlg.ARPList.setFont(this.frame.fixFont);
        this.vlanDlg.VlanListLabel.setFont(this.frame.boldFont);
        this.vlanDlg.Interface.setFont(this.frame.boldFont);
        this.vlanDlg.VName.setFont(this.frame.boldFont);
        this.vlanDlg.Type.setFont(this.frame.boldFont);
        this.vlanDlg.MTU.setFont(this.frame.boldFont);
        this.vlanDlg.Unit.setFont(this.frame.boldFont);
        ((Component)this.vlanDlg.VLANInfoGroup).setFont(this.frame.boldFont);
        this.vlanDlg.ServerName.setFont(this.frame.boldFont);
        this.vlanDlg.ServerAddr.setFont(this.frame.boldFont);
        this.vlanDlg.Properties.setFont(this.frame.boldFont);
        this.vlanDlg.ARPCacheLabel.setFont(this.frame.boldFont);
        this.vlanDlg.AddrType.setFont(this.frame.boldFont);
        this.vlanDlg.Addr.setFont(this.frame.boldFont);
        this.vlanDlg.ATMAddr.setFont(this.frame.boldFont);
        this.vlanDlg.TTL.setFont(this.frame.boldFont);
        this.vlanDlg.DeleteEntry.setFont(this.frame.boldFont);
        this.vlanDlg.DeleteAll.setFont(this.frame.boldFont);
        this.vlanDlg.deletePVC.setFont(this.frame.boldFont);
        this.vlanDlg.View.setFont(this.frame.boldFont);
        this.vlanDlg.View2.setFont(this.frame.boldFont);
        this.vlanDlg.ServerAddrListLabel.setFont(this.frame.boldFont);
        this.vlanDlg.VLANState.hide();
        this.vlanDlg.VlanStatusLabel.hide();
    }

    public void Update() {
        int n;
        String string;
        Vector<VlanPSB> vector = new Vector<VlanPSB>();
        String[] stringArray = new String[192];
        int n2 = this.frame.topLayer.get_vlan_list(32, stringArray);
        if (n2 == 0) {
            VlanPSB vlanPSB = new VlanPSB();
            vlanPSB.setField(0, "<No VLANs found>");
            vector.addElement(vlanPSB);
            ParsedStringBuffer.updateList(vector, this.vlanDlg.VLANList);
            this.vlanDlg.FailoverIndex.hide();
            this.vlanDlg.FailoverIndexLabel.hide();
            this.vlanDlg.Properties.enable(false);
            this.vlanDlg.VLANState.setText("Unknown");
            return;
        }
        int n3 = 0;
        Vector<Color> vector2 = new Vector<Color>();
        int n4 = 0;
        while (n4 < n2) {
            VlanPSB vlanPSB = new VlanPSB();
            vector.addElement(vlanPSB);
            vlanPSB.setField(1, stringArray[n3++]);
            vlanPSB.setField(0, stringArray[n3++]);
            vlanPSB.setField(2, stringArray[n3++]);
            vlanPSB.setField(3, stringArray[n3++]);
            vlanPSB.setField(4, stringArray[n3++]);
            String string2 = stringArray[n3++];
            vlanPSB.setField(5, string2);
            vector2.addElement(VlanPanel.getColor(string2));
            ++n4;
        }
        ParsedStringBuffer.sort(vector, this.vlanSortField, this.vlanSortOrder, vector2);
        VlanPSB.updateList(vector, this.vlanDlg.VLANList, vector2);
        this.vlanList = vector;
        if (this.vlanDlg.VLANList.countItems() > 0 && this.vlanDlg.VLANList.getSelectedItem() == null) {
            this.vlanDlg.VLANList.select(0);
        }
        if ((string = this.vlanDlg.VLANList.getSelectedItem()) == null) {
            this.selectedIFname = null;
            return;
        }
        this.UpdateVlanLabels(string);
        VlanPSB vlanPSB = new VlanPSB(string);
        this.selectedIFname = vlanPSB.getField(1);
        String[] stringArray2 = new String[4];
        this.frame.topLayer.get_vlan_info(vlanPSB.getField(1), stringArray2);
        if (stringArray2[0] == null) {
            this.vlanDlg.DriverVersion.setText("Unknown");
        } else {
            this.vlanDlg.DriverVersion.setText(stringArray2[0]);
        }
        if (stringArray2[1] == null) {
            this.vlanDlg.HostIPAddr.hide();
            this.vlanDlg.IPAddressLabel.hide();
        } else {
            this.vlanDlg.HostIPAddr.setText(stringArray2[1]);
            this.vlanDlg.HostIPAddr.show();
            this.vlanDlg.IPAddressLabel.show();
        }
        if (stringArray2[2] == null) {
            this.vlanDlg.HostAddr.hide();
            this.vlanDlg.HostAddrLabel.hide();
        } else {
            this.vlanDlg.HostAddr.setText(stringArray2[2]);
            this.vlanDlg.HostAddr.show();
            this.vlanDlg.HostAddrLabel.show();
        }
        if (stringArray2[3] == null) {
            this.vlanDlg.FailoverIndex.hide();
            this.vlanDlg.FailoverIndexLabel.hide();
        } else {
            this.vlanDlg.FailoverIndex.setText(stringArray2[3]);
            this.vlanDlg.FailoverIndex.show();
            this.vlanDlg.FailoverIndexLabel.show();
        }
        String[] stringArray3 = new String[4097];
        String[] stringArray4 = new String[2049];
        String[] stringArray5 = new String[2];
        int n5 = 0;
        int n6 = 0;
        int n7 = this.frame.topLayer.get_vlan_status(vlanPSB.getField(1), stringArray5, 1024, stringArray3, stringArray4);
        if (n7 != 0) {
            n = this.vlanDlg.VLANList.getSelectedIndex();
            this.vlanDlg.VLANState.setText("Unknown");
            this.vlanDlg.VLANList.setItemColor(VlanPanel.getColor("UNK"), n);
        } else {
            n = this.vlanDlg.VLANList.getSelectedIndex();
            this.vlanDlg.VLANState.setText(stringArray5[0]);
            this.vlanDlg.VLANList.setItemColor(VlanPanel.getColor(stringArray5[1]), n);
            if (stringArray5[1].equals("DISABLED")) {
                this.vlanDlg.Properties.enable(false);
            }
            n5 = Integer.parseInt(stringArray3[0]);
            n6 = Integer.parseInt(stringArray4[0]);
        }
        Vector<ServersPSB> vector3 = new Vector<ServersPSB>();
        Vector<ARPCachePSB> vector4 = new Vector<ARPCachePSB>();
        n3 = 1;
        int n8 = 0;
        while (n8 < n6) {
            ServersPSB serversPSB = new ServersPSB();
            serversPSB.setField(0, stringArray4[n3++]);
            serversPSB.setField(1, stringArray4[n3++]);
            vector3.addElement(serversPSB);
            ++n8;
        }
        n3 = 1;
        this.nonPVCs = false;
        int n9 = 0;
        while (n9 < n5) {
            ARPCachePSB aRPCachePSB = new ARPCachePSB();
            if (stringArray3[n3].trim().equals("Error:")) {
                aRPCachePSB.setField(0, stringArray3[n3]);
            } else if (vlanPSB.getField(2).equals("Classical IP")) {
                aRPCachePSB.setField(0, "CLIP Route");
            } else if (stringArray3[n3].trim().equals("IP")) {
                aRPCachePSB.setField(0, "MPOA Shortcut");
            } else {
                aRPCachePSB.setField(0, "LANE Data VC");
            }
            int n10 = ++n3;
            aRPCachePSB.setField(1, stringArray3[n10]);
            if (stringArray3[++n3].startsWith("PVC")) {
                try {
                    int n11 = Integer.parseInt(stringArray3[n3].substring(4).trim());
                    aRPCachePSB.setField(2, VlanPanel.makePVCfromVCI(n11));
                }
                catch (NumberFormatException numberFormatException) {
                    aRPCachePSB.setField(2, stringArray3[n3++]);
                }
            } else {
                aRPCachePSB.setField(2, stringArray3[n3++]);
                this.nonPVCs = true;
            }
            int n12 = ++n3;
            ++n3;
            aRPCachePSB.setField(3, stringArray3[n12]);
            vector4.addElement(aRPCachePSB);
            ++n9;
        }
        ParsedStringBuffer.sort(vector3, this.serverSortField, this.serverSortOrder);
        this.serverList = vector3;
        ParsedStringBuffer.updateList(this.serverList, this.vlanDlg.ServerAddrList);
        ParsedStringBuffer.sort(vector4, this.ARPSortField, this.ARPSortOrder);
        this.ARPList = vector4;
        ARPCachePSB.updateList(this.ARPList, this.vlanDlg.ARPList);
        this.enableButtons();
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target == this.vlanDlg.Interface || event.target == this.vlanDlg.Type || event.target == this.vlanDlg.MTU || event.target == this.vlanDlg.VName || event.target == this.vlanDlg.Unit) {
                int n = 1;
                if (event.target == this.vlanDlg.VName) {
                    n = 0;
                }
                if (event.target == this.vlanDlg.Type) {
                    n = 2;
                }
                if (event.target == this.vlanDlg.MTU) {
                    n = 3;
                }
                if (event.target == this.vlanDlg.Unit) {
                    n = 4;
                }
                if (this.vlanSortField != n) {
                    this.vlanSortOrder = true;
                    this.vlanSortField = n;
                } else {
                    this.vlanSortOrder = !this.vlanSortOrder;
                }
                this.notifySort(this.vlanDlg.VLANList);
                return true;
            }
            if (event.target == this.vlanDlg.ServerName || event.target == this.vlanDlg.ServerAddr) {
                if (this.vlanDlg.VLANList.getSelectedIndex() == -1) {
                    return true;
                }
                int n = 0;
                if (event.target == this.vlanDlg.ServerAddr) {
                    n = 1;
                }
                if (this.serverSortField != n) {
                    this.serverSortOrder = true;
                    this.serverSortField = n;
                } else {
                    this.serverSortOrder = !this.serverSortOrder;
                }
                this.notifySort(this.vlanDlg.ServerAddrList);
                return true;
            }
            if (event.target == this.vlanDlg.AddrType || event.target == this.vlanDlg.Addr || event.target == this.vlanDlg.ATMAddr || event.target == this.vlanDlg.TTL) {
                if (this.vlanDlg.VLANList.getSelectedIndex() == -1) {
                    return true;
                }
                int n = 0;
                if (event.target == this.vlanDlg.Addr) {
                    n = 1;
                }
                if (event.target == this.vlanDlg.ATMAddr) {
                    n = 2;
                }
                if (event.target == this.vlanDlg.TTL) {
                    n = 3;
                }
                if (this.ARPSortField != n) {
                    this.ARPSortOrder = true;
                    this.ARPSortField = n;
                } else {
                    this.ARPSortOrder = !this.ARPSortOrder;
                }
                this.notifySort(this.vlanDlg.ARPList);
                return true;
            }
            if (event.target == this.vlanDlg.VLANList) {
                String string = this.vlanDlg.VLANList.getSelectedItem();
                if (string == null) {
                    return true;
                }
                VlanPSB vlanPSB = new VlanPSB(string);
                String string2 = vlanPSB.getField(0);
                vlanPSB.getField(1);
                if ((event.modifiers & 2) != 0 && this.vlanDlg.Properties.isEnabled()) {
                    int n = this.vlanDlg.VLANList.getSelectedIndex();
                    new ChangeElanDialog(this.frame, n);
                    return true;
                }
                String string3 = "Detailed Status of Vlan";
                if (!string2.equals("")) {
                    string3 = String.valueOf(string3) + "  \"" + string2 + "\"";
                }
                new MessageBox(this.frame, this.vlanDlg.VLANState.getText(), string3, 1);
                return true;
            }
            if (event.target == this.vlanDlg.Properties || event.target == this.vlanDlg.VLANList && this.vlanDlg.Properties.isEnabled()) {
                Object object2 = dlgMutex;
                synchronized (object2) {
                    if (!dlgOpen) {
                        dlgOpen = true;
                        int n = this.vlanDlg.VLANList.getSelectedIndex();
                        this.dlgMPOA = new EditMPOADialog(this.frame, n);
                    }
                }
                return true;
            }
            if (event.target == this.vlanDlg.DeleteEntry) {
                this.deleteSelected(this.vlanDlg.ARPList);
                return true;
            }
            if (event.target == this.vlanDlg.DeleteAll) {
                this.deleteAll(this.vlanDlg.ARPList);
                return true;
            }
            if (event.target == this.vlanDlg.deletePVC) {
                this.deletePVC(this.vlanDlg.ARPList);
                return true;
            }
            if (event.target == this.vlanDlg.View || event.target == this.vlanDlg.ARPList) {
                String string = null;
                String string4 = this.vlanDlg.ARPList.getSelectedItem();
                if (string4 != null) {
                    ARPCachePSB aRPCachePSB = new ARPCachePSB();
                    aRPCachePSB.fromString(string4);
                    string = aRPCachePSB.getField(2);
                }
                if (string != null) {
                    this.frame.connPanel.select(string);
                }
                return true;
            }
            if (event.target == this.vlanDlg.View2 || event.target == this.vlanDlg.ServerAddrList) {
                String string = null;
                String string5 = this.vlanDlg.ServerAddrList.getSelectedItem();
                if (string5 != null) {
                    ServersPSB serversPSB = new ServersPSB();
                    serversPSB.fromString(string5);
                    string = serversPSB.getField(1);
                }
                if (string != null) {
                    this.frame.connPanel.select(string);
                }
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public boolean handleEvent(Event event) {
        try {
            switch (event.id) {
                case 701: {
                    this.notifySelection((ColorListBox)event.target);
                    return true;
                }
            }
            return super.handleEvent(event);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public void notifySort(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        if (colorListBox == this.vlanDlg.VLANList) {
            Vector vector = colorListBox.getColors();
            ParsedStringBuffer.sort(this.vlanList, this.vlanSortField, this.vlanSortOrder, vector);
            VlanPSB.updateList(this.vlanList, this.vlanDlg.VLANList, vector);
        } else if (colorListBox == this.vlanDlg.ARPList) {
            ParsedStringBuffer.sort(this.ARPList, this.ARPSortField, this.ARPSortOrder);
            ARPCachePSB.updateList(this.ARPList, this.vlanDlg.ARPList);
        } else if (colorListBox == this.vlanDlg.ServerAddrList) {
            ParsedStringBuffer.sort(this.serverList, this.serverSortField, this.serverSortOrder);
            ParsedStringBuffer.updateList(this.serverList, this.vlanDlg.ServerAddrList);
        }
        ICLock.unlock(this.frame.globalLock, l);
    }

    public void notifySelection(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        if (colorListBox == this.vlanDlg.VLANList) {
            this.Update();
        } else {
            this.enableButtons();
        }
        ICLock.unlock(this.frame.globalLock, l);
    }

    void enableButtons() {
        ParsedStringBuffer parsedStringBuffer;
        String string;
        if (this.vlanDlg.ServerAddrList.getSelectedIndex() != -1) {
            string = this.vlanDlg.ServerAddrList.getSelectedItem();
            parsedStringBuffer = new ServersPSB();
            parsedStringBuffer.fromString(string);
            boolean bl = this.frame.connPanel.isPresent(parsedStringBuffer.getField(1));
            this.vlanDlg.View2.enable(bl);
        } else {
            this.vlanDlg.View2.enable(false);
        }
        if (this.vlanDlg.ARPList.getSelectedIndex() != -1) {
            string = this.vlanDlg.ARPList.getSelectedItem();
            parsedStringBuffer = new ARPCachePSB();
            parsedStringBuffer.fromString(string);
            String string2 = parsedStringBuffer.getField(2);
            boolean bl = this.frame.connPanel.isPresent(string2);
            this.vlanDlg.View.enable(bl);
            if (parsedStringBuffer.getField(2).startsWith("PVC")) {
                this.vlanDlg.DeleteEntry.enable(false);
                this.vlanDlg.deletePVC.enable(true);
            } else {
                this.vlanDlg.DeleteEntry.enable(true);
                this.vlanDlg.deletePVC.enable(false);
            }
        } else {
            this.vlanDlg.View.enable(false);
            this.vlanDlg.DeleteEntry.enable(false);
            this.vlanDlg.deletePVC.enable(false);
        }
        if (this.vlanDlg.ARPList.countItems() > 0) {
            if (this.nonPVCs) {
                this.vlanDlg.DeleteAll.enable(true);
                return;
            }
            this.vlanDlg.DeleteAll.enable(false);
            return;
        }
        this.vlanDlg.DeleteAll.enable(false);
    }

    public void deletePVC(ColorListBox colorListBox) {
        String string = colorListBox.getSelectedItem();
        if (string == null) {
            return;
        }
        ARPCachePSB aRPCachePSB = new ARPCachePSB(string);
        String string2 = aRPCachePSB.getField(2);
        if (!string2.startsWith("PVC")) {
            return;
        }
        String string3 = this.vlanDlg.VLANList.getSelectedItem();
        if (string3 == null) {
            return;
        }
        VlanPSB vlanPSB = new VlanPSB(string3);
        String[] stringArray = new String[5];
        stringArray[0] = "0";
        stringArray[1] = String.valueOf(VlanPanel.getVCIfromPVC(string2));
        int n = this.frame.topLayer.del_pvc(vlanPSB.getField(1), stringArray);
        if (n != 0) {
            new MessageBox(this.frame, ICTop.GetErrorString(n), 1);
        }
    }

    public void deleteSelected(ColorListBox colorListBox) {
        int n = this.vlanDlg.VLANList.getSelectedIndex();
        if (n > -1) {
            VlanPSB vlanPSB = (VlanPSB)this.vlanList.elementAt(n);
            String string = vlanPSB.getField(1);
            String string2 = colorListBox.getSelectedItem();
            if (string2 != null) {
                String[] stringArray = new String[2];
                ARPCachePSB aRPCachePSB = new ARPCachePSB();
                aRPCachePSB.fromString(string2);
                String string3 = aRPCachePSB.getField(0);
                stringArray[0] = string3.equals("LANE Data VC") ? "MAC" : "IP";
                stringArray[1] = aRPCachePSB.getField(1);
                if (this.frame.topLayer.del_arp_entry(string, stringArray) == 0) {
                    this.vlanDlg.ARPList.delItem(colorListBox.getSelectedIndex());
                }
            }
        }
    }

    public void deleteAll(ColorListBox colorListBox) {
        VlanPSB vlanPSB;
        String string;
        int n = this.vlanDlg.VLANList.getSelectedIndex();
        if (n > -1 && this.frame.topLayer.del_arp_entry(string = (vlanPSB = (VlanPSB)this.vlanList.elementAt(n)).getField(1), null) == 0) {
            this.vlanDlg.ARPList.clear();
        }
    }

    public int getFlowSpecs(String string, EditMPOADialog editMPOADialog) {
        String[] stringArray = new String[600];
        int n = this.frame.topLayer.get_flow_specs(string.trim(), 50, stringArray);
        if (n != 0) {
            this.frame.topLayer.ShowError(n);
            return n;
        }
        int n2 = Integer.parseInt(stringArray[0]);
        editMPOADialog.MPOAThreshold_default = Integer.parseInt(stringArray[1]);
        editMPOADialog.lineRate = Integer.parseInt(stringArray[2]);
        int n3 = 3;
        editMPOADialog.flowSpecs.removeAllElements();
        int n4 = 0;
        while (n4 < n2) {
            FlowSpec flowSpec = new FlowSpec();
            flowSpec.template.setField(0, stringArray[n3++]);
            flowSpec.template.setField(1, stringArray[n3++]);
            flowSpec.template.setField(2, stringArray[n3++]);
            flowSpec.template.setField(3, stringArray[n3++]);
            flowSpec.template.setField(4, stringArray[n3++]);
            flowSpec.template.setField(5, stringArray[n3++]);
            flowSpec.template.setField(6, stringArray[n3++]);
            flowSpec.template.setField(7, stringArray[n3++]);
            flowSpec.template.setField(8, stringArray[n3++]);
            flowSpec.template.setField(9, stringArray[n3++]);
            flowSpec.template.setField(10, stringArray[n3++]);
            flowSpec.template.setField(11, stringArray[n3++]);
            flowSpec.fromString(flowSpec.template.toString());
            editMPOADialog.flowSpecs.addElement(flowSpec);
            ++n4;
        }
        return n;
    }

    public int saveMPOA(EditMPOADialog editMPOADialog) {
        int n = editMPOADialog.flowSpecs.size();
        String[] stringArray = new String[n * 12];
        int n2 = 0;
        while (n2 < n) {
            FlowSpec flowSpec = (FlowSpec)editMPOADialog.flowSpecs.elementAt(n2);
            int n3 = n2 * 12;
            flowSpec.template.fromString(flowSpec.toString());
            stringArray[n3++] = flowSpec.template.getField(0);
            stringArray[n3++] = String.valueOf(flowSpec.srcPort);
            stringArray[n3++] = String.valueOf(flowSpec.dstPort);
            stringArray[n3++] = String.valueOf(flowSpec.protocol);
            stringArray[n3++] = flowSpec.vcType;
            stringArray[n3++] = String.valueOf(flowSpec.pcr);
            stringArray[n3++] = String.valueOf(flowSpec.scr);
            stringArray[n3++] = String.valueOf(flowSpec.maxBurst);
            stringArray[n3++] = String.valueOf(flowSpec.LANEThreshold);
            stringArray[n3++] = String.valueOf(flowSpec.MPOAThreshold);
            stringArray[n3++] = flowSpec.template.getField(10);
            stringArray[n3++] = flowSpec.template.getField(11);
            ++n2;
        }
        int n4 = this.frame.topLayer.set_flow_specs(editMPOADialog.elanName.trim(), n, stringArray);
        if (n4 != 0) {
            this.frame.topLayer.ShowError(n4);
        }
        return n4;
    }

    public void UpdateVlanLabels(String string) {
        String string2 = "UNKNOWN";
        String string3 = "DISABLED";
        VlanPSB vlanPSB = new VlanPSB();
        if (string != null) {
            vlanPSB.fromString(string);
            string2 = vlanPSB.getField(2);
            string3 = vlanPSB.getField(5);
        }
        if (string2.startsWith("MPOA ELAN")) {
            this.vlanDlg.DriverVersionLabel.setText("MPOA Version:");
            this.vlanDlg.HostAddrLabel.setText("Host ATM Address:");
            this.vlanDlg.ATMAddr.setLabel("ATM Address");
            this.vlanDlg.FailoverIndex.hide();
            this.vlanDlg.FailoverIndexLabel.hide();
            this.vlanDlg.Properties.enable(true);
            return;
        }
        if (string2.startsWith("Classical IP")) {
            this.vlanDlg.FailoverIndex.hide();
            this.vlanDlg.FailoverIndexLabel.hide();
            this.vlanDlg.Properties.enable(false);
            this.vlanDlg.DriverVersionLabel.setText("CLIP Version:");
            this.vlanDlg.HostAddrLabel.setText("Host ATM Address:");
            this.vlanDlg.ATMAddr.setLabel("ATM Address");
            return;
        }
        if (string2.startsWith("FORE IP")) {
            this.vlanDlg.FailoverIndex.hide();
            this.vlanDlg.FailoverIndexLabel.hide();
            this.vlanDlg.Properties.enable(false);
            this.vlanDlg.DriverVersionLabel.setText("FORE IP Version:");
            this.vlanDlg.HostAddrLabel.setText("Host SPANS Address:");
            this.vlanDlg.ATMAddr.setLabel("SPANS Address");
            return;
        }
        this.vlanDlg.FailoverIndex.hide();
        this.vlanDlg.FailoverIndexLabel.hide();
        this.vlanDlg.Properties.enable(false);
        this.vlanDlg.DriverVersionLabel.setText("Driver Version:");
        this.vlanDlg.HostAddrLabel.setText("Host Address:");
        this.vlanDlg.ATMAddr.setLabel("ATM Address");
    }

    public void selectIFname(String string) {
        if (string != null && this.vlanDlg != null && this.vlanDlg.VLANList != null) {
            VlanPSB vlanPSB = new VlanPSB();
            int n = 0;
            while (n < this.vlanDlg.VLANList.countItems()) {
                String string2 = this.vlanDlg.VLANList.getItem(n);
                vlanPSB.fromString(string2);
                string2 = vlanPSB.getField(1);
                if (string.equals(string2)) {
                    this.vlanDlg.VLANList.reselect(n);
                    return;
                }
                ++n;
            }
        }
    }

    public static Color getColor(String string) {
        if (string.equals("DISABLED")) {
            return Color.lightGray;
        }
        if (string.equals("DOWN")) {
            return Color.red;
        }
        if (string.equals("WARN")) {
            return Color.yellow.darker();
        }
        if (string.equals("OK")) {
            return Color.green.darker();
        }
        return Color.black;
    }

    public static String makePVCfromVCI(int n) {
        return "PVC: VPI=0, VCI=" + n;
    }

    public static int getVCIfromPVC(String string) {
        try {
            return Integer.parseInt(string.substring(16).trim());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static {
        dlgMutex = new Object();
    }
}

