/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.io.PrintStream;

class ICFrame
extends Frame {
    String Notices = "InFOREmation Center 5.0 Copyright \u00a9 1995-1998 FORE Systems, Inc.";
    Dimension frameSize;
    int fontSize;
    Font baseFont;
    Font boldFont;
    Font fixFont;
    SplashScreen splashScreen;
    RefreshDialog refreshDlg;
    ICLock globalLock = new ICLock();
    CheckboxMenuItem detailsMenu = new CheckboxMenuItem("Advanced View");
    CheckboxMenuItem unitsMenu = new CheckboxMenuItem("Use Cell Measurements");
    ICTop topLayer;
    TabControl infoCards;
    boolean pvcBridged = true;
    static final String VLANLabel = " VLAN Information ";
    VlanPanel vlanPanel = new VlanPanel(this);
    static final String ConnLabel = " Connection List ";
    ConnPanel connPanel = new ConnPanel(this);
    static final String AdapLabel = " Adapter Information ";
    AdapPanel adapPanel = new AdapPanel(this);
    static final String StatusLabel = " Status Summary ";
    StatusPanel statusPanel = new StatusPanel(this);
    ICRefresh intro;
    Thread introThread;
    ICRefresh refresh;
    Thread refreshThread;
    static final String MENU_QUIT = "Quit";
    static final String MENU_SET_REFRESH = "Set Refresh Intervals...";
    static final String MENU_REFRESH_NOW = "Refresh Now";
    static final String MENU_VIEW_DETAILS = "Advanced View";
    static final String MENU_USE_CELLS = "Use Cell Measurements";
    static final String MENU_ABOUT = "About";
    static final String MENU_HELP = "Contents";

    public ICFrame(String string, ICTop iCTop) {
        super(string);
        this.addNotify();
        this.topLayer = iCTop;
        this.splashScreen = new SplashScreen(this);
        this.intro = new ICRefresh(this);
        this.intro.interval = 1;
        this.intro.terminate = true;
        this.introThread = new Thread(this.intro);
        this.introThread.start();
        this.frameSize = new Dimension();
        this.detailsMenu.setState(false);
        this.setFrameMode();
        this.baseFont = new Font("Helvetica", 0, this.fontSize);
        this.boldFont = new Font("Helvetica", 1, this.fontSize);
        this.fixFont = new Font("Courier", 0, this.fontSize);
        ((Component)this).setFont(this.baseFont);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File", true);
        menu.setFont(this.baseFont);
        menuBar.add(menu);
        Menu menu2 = new Menu("Options", true);
        menu2.setFont(this.baseFont);
        menuBar.add(menu2);
        Menu menu3 = new Menu("Help", true);
        menu3.setFont(this.baseFont);
        menuBar.add(menu3);
        MenuItem menuItem = new MenuItem(MENU_QUIT);
        menuItem.setFont(this.baseFont);
        menu.add(menuItem);
        menuItem = new MenuItem(MENU_SET_REFRESH);
        menuItem.setFont(this.baseFont);
        menu2.add(menuItem);
        menuItem = new MenuItem(MENU_REFRESH_NOW);
        menuItem.setFont(this.baseFont);
        menu2.add(menuItem);
        this.detailsMenu.setFont(this.baseFont);
        menu2.add(this.detailsMenu);
        this.unitsMenu.setFont(this.baseFont);
        menu2.add(this.unitsMenu);
        menuItem = new MenuItem(MENU_HELP);
        menuItem.setFont(this.baseFont);
        menu3.add(menuItem);
        menuItem = new MenuItem(MENU_ABOUT);
        menuItem.setFont(this.baseFont);
        menu3.add(menuItem);
        this.setMenuBar(menuBar);
        this.infoCards = new TabControl();
        this.refresh = new ICRefresh(this.infoCards);
        this.refreshThread = new Thread(this.refresh);
    }

    public void init() {
        this.setLayout(null);
        ((Component)this).setBackground(Color.lightGray);
        this.add(this.infoCards);
        this.infoCards.addCard(StatusLabel, this.statusPanel);
        this.infoCards.addCard(VLANLabel, this.vlanPanel);
        this.infoCards.addCard(ConnLabel, this.connPanel);
        this.infoCards.addCard(AdapLabel, this.adapPanel);
        this.detailsMenu.setState(ICTop.initDetails);
        this.unitsMenu.setState(ICTop.cellUnits);
        this.setFrameMode();
        this.setFrameView();
        this.statusPanel.init();
        this.vlanPanel.init();
        this.connPanel.init();
        this.adapPanel.init();
        ((Component)this.infoCards).setFont(this.boldFont);
        DialogLayout dialogLayout = (DialogLayout)this.vlanPanel.getLayout();
        this.vlanPanel.resize(dialogLayout.getDialogSize());
        dialogLayout = (DialogLayout)this.connPanel.getLayout();
        this.connPanel.resize(dialogLayout.getDialogSize());
        dialogLayout = (DialogLayout)this.adapPanel.getLayout();
        this.adapPanel.resize(dialogLayout.getDialogSize());
        dialogLayout = (DialogLayout)this.statusPanel.getLayout();
        this.statusPanel.resize(dialogLayout.getDialogSize());
        this.infoCards.setBackground(((Component)this).getBackground());
        this.infoCards.setTabBackground(Color.lightGray);
        this.statusPanel.setBackground(Color.lightGray);
        this.vlanPanel.setBackground(Color.lightGray);
        this.connPanel.setBackground(Color.lightGray);
        this.adapPanel.setBackground(Color.lightGray);
        this.statusPanel.Update();
        this.vlanPanel.Update();
        this.connPanel.Update();
        this.adapPanel.Update();
        this.refreshThread.start();
        try {
            while (this.introThread.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
        this.splashScreen.dispose();
        this.splashScreen = null;
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target instanceof MenuItem) {
                if (event.target == this.detailsMenu) {
                    this.setFrameMode();
                    this.setFrameView();
                    this.refreshThread.interrupt();
                    return true;
                }
                if (event.target == this.unitsMenu) {
                    ICTop.cellUnits = this.unitsMenu.getState();
                    this.refreshThread.interrupt();
                    return true;
                }
                if (event.arg.equals(MENU_QUIT)) {
                    return this.topLayer.action(event, object);
                }
                if (event.arg.equals(MENU_HELP)) {
                    this.topLayer.show_help("none");
                } else if (event.arg.equals(MENU_SET_REFRESH)) {
                    new RefreshDialog(this);
                } else if (event.arg.equals(MENU_REFRESH_NOW)) {
                    this.refreshThread.interrupt();
                } else if (event.arg.equals(MENU_ABOUT)) {
                    this.ShowMessage(this.Notices);
                }
                return true;
            }
            if (event.target == this.infoCards) {
                return true;
            }
            if (event.target == this && event.arg instanceof String) {
                new MessageBox(this, (String)event.arg, 1);
                return true;
            }
            return super.action(event, object);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this, exception);
            return true;
        }
    }

    public boolean handleEvent(Event event) {
        try {
            switch (event.id) {
                case 403: {
                    if (event.key == 1007) {
                        this.infoCards.showNextCard();
                        return true;
                    }
                    if (event.key == 1006) {
                        this.infoCards.showPrevCard();
                        return true;
                    }
                    return super.handleEvent(event);
                }
                case 1002: {
                    long l = ICLock.lock(this.globalLock, 1000L);
                    if (l == 0L) {
                        return true;
                    }
                    if (this.detailsMenu.getState()) {
                        this.vlanPanel.Update();
                        this.connPanel.Update();
                        this.adapPanel.Update();
                    } else {
                        this.statusPanel.Update();
                    }
                    ICLock.unlock(this.globalLock, l);
                    return true;
                }
                case 201: {
                    this.refresh.terminate = true;
                    this.refreshThread.interrupt();
                    return this.topLayer.handleEvent(event);
                }
            }
            return super.handleEvent(event);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this, exception);
            return true;
        }
    }

    public void paint(Graphics graphics) {
        Insets insets = this.insets();
        Dimension dimension = this.size();
        if (this.frameSize != null) {
            if (!dimension.equals(this.frameSize)) {
                this.resize(this.frameSize.width, this.frameSize.height);
            }
            if (this.infoCards != null) {
                this.infoCards.reshape(insets.left, insets.top, this.frameSize.width - (insets.left + insets.right), this.frameSize.height - (insets.top + insets.bottom));
                this.infoCards.validate();
            }
        }
    }

    public boolean gotFocus(Event event, Object object) {
        try {
            if (object instanceof String) {
                if (event.id == 1004) {
                    if (event.target instanceof TabControl) {
                        TabControl tabControl = (TabControl)event.target;
                        tabControl.setLabelColor((String)event.arg, Color.white);
                        return true;
                    }
                } else if (event.id == 1005 && event.target instanceof TabControl) {
                    TabControl tabControl = (TabControl)event.target;
                    tabControl.setLabelColor((String)event.arg, Color.black);
                    return true;
                }
            }
            return super.gotFocus(event, object);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this, exception);
            return true;
        }
    }

    private void setFrameMode() {
        boolean bl = this.detailsMenu.getState();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < 800) {
            this.fontSize = 9;
            if (!bl) {
                this.frameSize.width = 450;
                this.frameSize.height = 310;
                return;
            }
            this.frameSize.width = 620;
            this.frameSize.height = 465;
            return;
        }
        if (dimension.width < 1024) {
            this.fontSize = 10;
            if (!bl) {
                this.frameSize.width = 535;
                this.frameSize.height = 315;
                return;
            }
            this.frameSize.width = 740;
            this.frameSize.height = 470;
            return;
        }
        this.fontSize = 12;
        if (!bl) {
            this.frameSize.width = 615;
            this.frameSize.height = 365;
            return;
        }
        this.frameSize.width = 860;
        this.frameSize.height = 565;
    }

    private void setFrameView() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.detailsMenu.getState()) {
            this.infoCards.hideCard(StatusLabel);
            this.infoCards.showCard(AdapLabel);
            this.infoCards.showCard(ConnLabel);
            this.infoCards.showCard(VLANLabel);
            this.vlanPanel.selectIFname(this.statusPanel.selectedIFname);
        } else {
            this.infoCards.hideCard(AdapLabel);
            this.infoCards.hideCard(ConnLabel);
            this.infoCards.hideCard(VLANLabel);
            this.infoCards.showCard(StatusLabel);
            this.statusPanel.selectIFname(this.vlanPanel.selectedIFname);
        }
        this.resize(this.frameSize.width, this.frameSize.height);
        this.move((dimension.width - this.frameSize.width) / 2, (dimension.height - this.frameSize.height) / 2);
    }

    public void ShowMessage(String string) {
        Event event = new Event(this, 1001, string);
        this.infoCards.postEvent(event);
    }

    public static void out(String string) {
        System.out.println(string);
    }

    public static void errorHandler(ICFrame iCFrame, Exception exception) {
        ICErrorStream iCErrorStream = new ICErrorStream();
        PrintStream printStream = new PrintStream(iCErrorStream);
        exception.printStackTrace(printStream);
        String string = "WARNING: An unexpected InfoCenter error has occurred.\nIf reporting this error, the debug information shown below\nwill be helpful in determining the cause of the error.\n\nClick OK to continue InfoCenter execution\n\n=========== Exception Information ==========\n\n" + iCErrorStream.output;
        new MessageBox(iCFrame, string, 1);
    }
}

