/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Hashtable;

public class DialogLayout
implements LayoutManager {
    protected Hashtable m_map = new Hashtable();
    protected int m_width;
    protected int m_height;
    protected Container cParent;

    public DialogLayout(Container container, int n, int n2) {
        this.cParent = container;
        this.m_width = n;
        this.m_height = n2;
    }

    public DialogLayout(Container container, Dimension dimension) {
        this.cParent = container;
        this.m_width = dimension.width;
        this.m_height = dimension.height;
    }

    public void setShape(Component component, int n, int n2, int n3, int n4) {
        this.m_map.put(component, new Rectangle(n, n2, n3, n4));
    }

    public void setShape(Component component, Rectangle rectangle) {
        this.m_map.put(component, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public Rectangle getShape(Component component) {
        Rectangle rectangle = (Rectangle)this.m_map.get(component);
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Dimension getDialogSize() {
        Rectangle rectangle = this.parentRect();
        Insets insets = this.cParent.insets();
        return new Dimension(rectangle.width + (insets.left + insets.right), rectangle.height + (insets.top + insets.bottom));
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Rectangle rectangle = this.parentRect();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public Dimension minimumLayoutSize(Container container) {
        Rectangle rectangle = this.parentRect();
        return new Dimension(rectangle.width, rectangle.height);
    }

    public void layoutContainer(Container container) {
        int n = container.countComponents();
        Rectangle rectangle = new Rectangle();
        int n2 = this.getCharHeight(container);
        int n3 = this.getCharWidth(container);
        Insets insets = container.insets();
        container.getFontMetrics(container.getFont());
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Rectangle rectangle2 = (Rectangle)this.m_map.get(component);
            if (rectangle2 != null) {
                rectangle.x = rectangle2.x;
                rectangle.y = rectangle2.y;
                rectangle.height = rectangle2.height;
                rectangle.width = rectangle2.width;
                this.mapRectangle(rectangle, n3, n2);
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                component.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            ++n4;
        }
    }

    protected Rectangle parentRect() {
        Rectangle rectangle = new Rectangle(0, 0, this.m_width, this.m_height);
        this.mapRectangle(rectangle, this.getCharWidth(this.cParent), this.getCharHeight(this.cParent));
        return rectangle;
    }

    protected int getCharWidth(Container container) {
        String string;
        FontMetrics fontMetrics = container.getFontMetrics(container.getFont());
        int n = fontMetrics.stringWidth(string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ") / string.length();
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    protected int getCharHeight(Container container) {
        FontMetrics fontMetrics = container.getFontMetrics(container.getFont());
        int n = fontMetrics.getHeight();
        return n;
    }

    protected void mapRectangle(Rectangle rectangle, int n, int n2) {
        rectangle.x = rectangle.x * n / 4;
        rectangle.y = rectangle.y * n2 / 8;
        rectangle.width = rectangle.width * n / 4;
        rectangle.height = rectangle.height * n2 / 8;
    }
}

