/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.util.Vector;

class ConnPanel
extends ICPanel {
    AddClipDialog dlgClip;
    AddForeDialog dlgFore;
    ConnDlg connDlg;
    Vector connList = new Vector();
    int connSortField = 0;
    boolean connSortOrder = true;

    ConnPanel(ICFrame iCFrame) {
        super(iCFrame);
        this.frame = iCFrame;
        this.connDlg = new ConnDlg(this);
    }

    public void init() {
        this.connDlg.InitParent();
        this.connDlg.CreateControls();
        this.connDlg.ConnList.setBackground(Color.white);
        ((Component)this).setFont(this.frame.fixFont);
        this.connDlg.setControlFont(this.frame.baseFont);
        this.connDlg.ConnList.setFont(this.frame.fixFont);
        this.connDlg.ATMAddr.setFont(this.frame.boldFont);
        this.connDlg.Client.setFont(this.frame.boldFont);
        this.connDlg.Type.setFont(this.frame.boldFont);
        this.connDlg.AAL.setFont(this.frame.boldFont);
        this.connDlg.VPI.setFont(this.frame.boldFont);
        this.connDlg.VCI.setFont(this.frame.boldFont);
        this.connDlg.Unit.setFont(this.frame.boldFont);
        this.connDlg.AddClipPVC.setFont(this.frame.boldFont);
        this.connDlg.AddForePVC.setFont(this.frame.boldFont);
        ((Component)this.connDlg.connInfoGroup).setFont(this.frame.boldFont);
        this.connDlg.DeleteEntry.setFont(this.frame.boldFont);
        this.connDlg.DeleteAll.setFont(this.frame.boldFont);
    }

    public void Update() {
        Vector<ConnectionPSB> vector = new Vector<ConnectionPSB>();
        String[] stringArray = new String[13312];
        int n = this.frame.topLayer.get_connect_list(1024, stringArray);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ConnectionPSB connectionPSB = new ConnectionPSB();
            connectionPSB.setField(1, stringArray[n2++]);
            connectionPSB.setField(0, stringArray[n2++]);
            int n4 = ++n2;
            connectionPSB.setField(2, stringArray[n4]);
            int n5 = ++n2;
            connectionPSB.setField(3, stringArray[n5]);
            int n6 = ++n2;
            connectionPSB.setField(4, stringArray[n6]);
            int n7 = ++n2;
            connectionPSB.setField(5, stringArray[n7]);
            int n8 = ++n2;
            connectionPSB.setField(6, stringArray[n8]);
            int n9 = ++n2;
            connectionPSB.setField(7, stringArray[n9]);
            int n10 = ++n2;
            connectionPSB.setField(8, stringArray[n10]);
            int n11 = ++n2;
            connectionPSB.setField(9, stringArray[n11]);
            int n12 = ++n2;
            connectionPSB.setField(10, stringArray[n12]);
            int n13 = ++n2;
            ++n2;
            connectionPSB.setField(11, stringArray[n13]);
            vector.addElement(connectionPSB);
            ++n3;
        }
        ParsedStringBuffer.sort(vector, this.connSortField, this.connSortOrder);
        this.connList = vector;
        ConnectionPSB.updateList(this.connList, this.connDlg.ConnList);
        if (this.connList.size() > 0 && this.connDlg.ConnList.getSelectedIndex() == -1) {
            this.connDlg.ConnList.select(0);
        }
        this.Selection(this.connDlg.ConnList);
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target == this.connDlg.ATMAddr || event.target == this.connDlg.Client || event.target == this.connDlg.Type || event.target == this.connDlg.AAL || event.target == this.connDlg.VPI || event.target == this.connDlg.VCI || event.target == this.connDlg.Unit) {
                int n = 1;
                if (event.target == this.connDlg.Client) {
                    n = 0;
                }
                if (event.target == this.connDlg.Type) {
                    n = 2;
                }
                if (event.target == this.connDlg.AAL) {
                    n = 3;
                }
                if (event.target == this.connDlg.VPI) {
                    n = 4;
                }
                if (event.target == this.connDlg.VCI) {
                    n = 5;
                }
                if (event.target == this.connDlg.Unit) {
                    n = 6;
                }
                if (this.connSortField != n) {
                    this.connSortOrder = true;
                    this.connSortField = n;
                } else {
                    this.connSortOrder = !this.connSortOrder;
                }
                this.notifySort(this.connDlg.ConnList);
                return true;
            }
            if (event.target == this.connDlg.AddClipPVC) {
                this.dlgClip = new AddClipDialog(this.frame);
                return true;
            }
            if (event.target == this.connDlg.AddForePVC) {
                this.dlgFore = new AddForeDialog(this.frame);
                return true;
            }
            if (event.target == this.connDlg.DeleteEntry) {
                this.deleteSelected(this.connDlg.ConnList);
                return true;
            }
            if (event.target == this.connDlg.DeleteAll) {
                this.deleteAll(this.connDlg.ConnList);
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public boolean handleEvent(Event event) {
        try {
            switch (event.id) {
                case 701: {
                    this.notifySelection((ColorListBox)event.target);
                    return true;
                }
            }
            return super.handleEvent(event);
        }
        catch (Exception exception) {
            ICFrame.errorHandler(this.frame, exception);
            return true;
        }
    }

    public void deleteSelected(ColorListBox colorListBox) {
        int n = colorListBox.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.closePVC(n);
    }

    public void deleteAll(ColorListBox colorListBox) {
        int n = 0;
        while (n < this.connList.size()) {
            ConnectionPSB connectionPSB = (ConnectionPSB)this.connList.elementAt(n);
            if (ConnPanel.canDelete(connectionPSB)) {
                this.closePVC(n);
            }
            ++n;
        }
    }

    public void closePVC(int n) {
        if (n < 0 || n > this.connList.size()) {
            return;
        }
        ConnectionPSB connectionPSB = (ConnectionPSB)this.connList.elementAt(n);
        if (connectionPSB.getField(11).equals("")) {
            String string = connectionPSB.getField(5);
            new MessageBox(this.frame, "Unknown VLAN on PVC (VCI=" + string + ")", 1);
            return;
        }
        String[] stringArray = new String[5];
        stringArray[0] = connectionPSB.getField(4);
        stringArray[1] = connectionPSB.getField(5);
        int n2 = this.frame.topLayer.del_pvc(connectionPSB.getField(11), stringArray);
        if (n2 != 0) {
            new MessageBox(this.frame, ICTop.GetErrorString(n2), 1);
        }
    }

    public void notifySort(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        ParsedStringBuffer.sort(this.connList, this.connSortField, this.connSortOrder);
        ConnectionPSB.updateList(this.connList, colorListBox);
        ICLock.unlock(this.frame.globalLock, l);
    }

    public void notifySelection(ColorListBox colorListBox) {
        long l = ICLock.lock(this.frame.globalLock, 1000L);
        if (l == 0L) {
            return;
        }
        this.Selection(colorListBox);
        ICLock.unlock(this.frame.globalLock, l);
    }

    private void Selection(ColorListBox colorListBox) {
        int n = this.connList.size() == 0 ? -1 : colorListBox.getSelectedIndex();
        if (n > -1) {
            ConnectionPSB connectionPSB = (ConnectionPSB)this.connList.elementAt(n);
            this.connDlg.DeleteEntry.enable(ConnPanel.canDelete(connectionPSB));
            this.connDlg.vcType.setText(connectionPSB.getField(7));
            this.connDlg.age.setText(connectionPSB.getField(10));
            this.connDlg.IFName.setText(connectionPSB.getField(11));
            if (ICTop.cellUnits) {
                this.connDlg.txUnits.setText("cells/sec");
                this.connDlg.rxUnits.setText("cells/sec");
                this.connDlg.tx_pcr.setText(connectionPSB.getField(8));
                this.connDlg.rx_pcr.setText(connectionPSB.getField(9));
            } else {
                double d;
                int n2;
                this.connDlg.txUnits.setText("Kbits/sec");
                this.connDlg.rxUnits.setText("Kbits/sec");
                try {
                    n2 = Integer.parseInt(connectionPSB.getField(8));
                    d = ICTop.Cells2Kbits(n2);
                    this.connDlg.tx_pcr.setText(String.valueOf(d));
                }
                catch (NumberFormatException numberFormatException) {
                    this.connDlg.tx_pcr.setText("N/A");
                }
                try {
                    n2 = Integer.parseInt(connectionPSB.getField(9));
                    d = ICTop.Cells2Kbits(n2);
                    this.connDlg.rx_pcr.setText(String.valueOf(d));
                }
                catch (NumberFormatException numberFormatException) {
                    this.connDlg.rx_pcr.setText("N/A");
                }
            }
        } else {
            this.connDlg.DeleteEntry.disable();
            this.connDlg.vcType.setText("");
            this.connDlg.tx_pcr.setText("");
            this.connDlg.rx_pcr.setText("");
            this.connDlg.age.setText("");
        }
        this.connDlg.DeleteAll.enable(ConnPanel.canDeleteAny(this.connDlg.ConnList));
    }

    public boolean addClipPVC(AddClipDialog addClipDialog) {
        String[] stringArray = new String[8];
        stringArray[0] = "CLIP";
        stringArray[1] = String.valueOf(addClipDialog.vpi);
        stringArray[2] = String.valueOf(addClipDialog.vci);
        stringArray[3] = addClipDialog.host;
        stringArray[4] = String.valueOf(addClipDialog.cell_rate);
        if (addClipDialog.routed) {
            stringArray[5] = "ROUTED";
        } else {
            stringArray[5] = "BRIDGED";
            stringArray[6] = addClipDialog.macAddr;
        }
        int n = this.frame.topLayer.add_pvc(addClipDialog.vlan, stringArray);
        if (n != 0) {
            new MessageBox(this.frame, ICTop.GetErrorString(n), 1);
            return false;
        }
        return true;
    }

    public void addForePVC(AddForeDialog addForeDialog) {
        String[] stringArray = new String[7];
        stringArray[0] = "FORE";
        stringArray[1] = String.valueOf(addForeDialog.vpi);
        stringArray[2] = String.valueOf(addForeDialog.vci);
        stringArray[3] = addForeDialog.host;
        stringArray[4] = addForeDialog.capsulation == 1 ? "ROUTED" : (addForeDialog.capsulation == 2 ? "BRIDGED" : "NONE");
        stringArray[5] = addForeDialog.dir == 1 ? "MULTI" : (addForeDialog.dir == 2 ? "IN" : "OUT");
        int n = this.frame.topLayer.add_pvc(addForeDialog.vlan, stringArray);
        if (n != 0) {
            new MessageBox(this.frame, ICTop.GetErrorString(n), 1);
        }
    }

    public boolean isPresent(String string) {
        return ConnPanel.getConnectionIndex(string, this.connList) != -1;
    }

    public static boolean canDelete(ConnectionPSB connectionPSB) {
        if (connectionPSB.getField(2).startsWith("PVC")) {
            return !connectionPSB.isReserved();
        }
        return false;
    }

    public static boolean canDeleteAny(ColorListBox colorListBox) {
        ConnectionPSB connectionPSB = new ConnectionPSB();
        int n = 0;
        while (n < colorListBox.countItems()) {
            connectionPSB.fromString(colorListBox.getItem(n));
            if (ConnPanel.canDelete(connectionPSB)) break;
            ++n;
        }
        return n < colorListBox.countItems();
    }

    public void select(String string) {
        int n = ConnPanel.getConnectionIndex(string, this.connList);
        if (n == -1) {
            return;
        }
        this.connDlg.ConnList.select(n);
        this.notifySelection(this.connDlg.ConnList);
        this.frame.infoCards.showCard(" Connection List ");
    }

    static int getConnectionIndex(String string, Vector vector) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            ConnectionPSB connectionPSB = (ConnectionPSB)vector.elementAt(n2);
            if (connectionPSB.getField(1).equals(string.trim())) {
                n = connectionPSB.getIndex(vector);
                break;
            }
            String string2 = String.valueOf(ARPCachePSB.getVCI(string));
            if (connectionPSB.getField(5).equals(string2)) {
                n = connectionPSB.getIndex(vector);
                break;
            }
            ++n2;
        }
        return n;
    }
}

