/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.util.Vector;

public class ColorListBox
extends Panel {
    private boolean updateEnable = true;
    private Scrollbar vs;
    private Image offscreen;
    private Font defaultfont = new Font("Dialog", 0, 12);
    private FontMetrics fontMetrics;
    private boolean multipleSelections = false;
    private boolean selectable = true;
    private int prev = -1;
    private int page;
    private int textHigh = 20;
    private int ScrollbarWidth = 15;
    private Vector items = new Vector();
    private Vector colText = new Vector();
    private int[] selected = new int[0];
    Color colBorder = Color.lightGray;
    Color colBG = Color.white;
    Color colDefText = Color.black;
    private int nIndentTop = 3;
    private int nIndentLeft = 2;
    private int nIndentText = 5;

    public ColorListBox() {
        this(false);
    }

    public ColorListBox(String string) {
        this(false);
        if (string.equals("TRUE")) {
            this.setMultipleSelections(true);
        }
    }

    public ColorListBox(boolean bl) {
        this.setLayout(null);
        this.setBackground(this.colBG);
        this.multipleSelections = bl;
        this.vs = new Scrollbar(1, 0, 0, 0, 10);
        this.vs.setBackground(this.colBG);
        this.add("East", this.vs);
    }

    public int countItems() {
        return this.items.size();
    }

    public void clear() {
        this.items = new Vector();
        this.colText = new Vector();
        this.selected = new int[0];
        this.prev = -1;
        this.setScrollbarState();
        this.update();
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public Color getItemColor(int n) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        return (Color)this.colText.elementAt(n);
    }

    public void setItemColor(Color color, int n) {
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        if (color != null) {
            this.colText.removeElementAt(n);
            this.colText.insertElementAt(color, n);
        }
    }

    public void addItem(String string) {
        this.addItem(string, -1, null);
    }

    public void addItem(String string, Color color) {
        this.addItem(string, -1, color);
    }

    public void addItem(String string, int n) {
        this.addItem(string, n, null);
    }

    public void addItem(String string, int n, Color color) {
        if (n < -1 || n >= this.items.size()) {
            n = -1;
        }
        if (n == -1) {
            this.items.addElement(string);
            if (color != null) {
                this.colText.addElement(color);
            } else {
                this.colText.addElement(this.colDefText);
            }
        } else {
            this.items.insertElementAt(string, n);
            if (color != null) {
                this.colText.insertElementAt(color, n);
            } else {
                this.colText.insertElementAt(this.colDefText, n);
            }
            int n2 = this.getSelectedIndex();
            if (n <= n2) {
                this.setSelect(n2 + 1);
            }
        }
        this.setScrollbarState();
        this.update();
    }

    public void replaceItem(String string, int n) {
        this.replaceItem(string, n, null);
    }

    public void replaceItem(String string, int n, Color color) {
        if (this.items.size() <= n || n < 0) {
            return;
        }
        this.items.removeElementAt(n);
        this.items.insertElementAt(string, n);
        if (color != null) {
            this.colText.removeElementAt(n);
            this.colText.insertElementAt(color, n);
        }
        this.update();
    }

    public boolean getSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
        if (!bl) {
            this.deselectAll();
        }
    }

    public int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public int[] getSelectedIndexes() {
        return this.selected;
    }

    public Color getSelectedItemColor() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (Color)this.colText.elementAt(n);
    }

    public String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return this.getItem(n);
    }

    public String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public void delItem(int n) {
        this.delItems(n, n);
    }

    public void delItems(int n, int n2) {
        int n3 = n2;
        while (n3 >= n) {
            int n4 = this.getSelectedIndex();
            if (n3 < n4) {
                this.setSelect(n4 - 1);
            }
            this.deselect(n3);
            this.items.removeElementAt(n3);
            this.colText.removeElementAt(n3);
            --n3;
        }
        this.setScrollbarState();
        this.update();
    }

    public void select(int n) {
        if (this.reselect(n)) {
            Event event = new Event(this, 701, new Integer(n));
            this.getParent().postEvent(event);
            this.update();
        }
    }

    public boolean reselect(int n) {
        if (this.items.size() <= n) {
            n = -1;
        }
        if (n < 0) {
            n = -1;
        }
        if (n == -1) {
            this.deselectAll();
            return false;
        }
        if (!this.selectable) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                return true;
            }
            ++n2;
        }
        if (!this.multipleSelections) {
            this.setSelect(n);
        } else {
            int[] nArray = new int[this.selected.length + 1];
            System.arraycopy(this.selected, 0, nArray, 0, this.selected.length);
            nArray[this.selected.length] = n;
            this.selected = nArray;
        }
        this.update();
        return true;
    }

    public void deselect(int n) {
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                Event event = new Event(this, 702, new Integer(n));
                this.getParent().postEvent(event);
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                return;
            }
            ++n2;
        }
        this.update();
    }

    public void deselectAll() {
        this.selected = new int[0];
        this.prev = -1;
        this.update();
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelections;
    }

    public void setMultipleSelections(boolean bl) {
        if (bl != this.multipleSelections) {
            this.multipleSelections = bl;
        }
    }

    public int getScrollbarWidth() {
        return this.ScrollbarWidth;
    }

    public void setScrollbarWidth(int n) {
        if (n > 0) {
            this.ScrollbarWidth = n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = super.size();
        int n = this.items.size();
        int n2 = this.vs.getValue();
        int n3 = 0;
        int n4 = n2;
        while (n4 < n && n4 < n2 + this.page) {
            this.drawItem(graphics, n4, n3);
            n3 += this.textHigh;
            ++n4;
        }
        graphics.setColor(this.colBorder);
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        graphics.setColor(Color.black);
        graphics.drawLine(1, 1, dimension.width - 2, 1);
        graphics.drawLine(1, 1, 1, dimension.height - 3);
    }

    public Insets insets() {
        return new Insets(2, 2, 2, 2);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 1004: {
                if (this.getSelectedIndex() == -1 && this.items.size() > 0) {
                    this.prev = 0;
                    this.select(0);
                    this.update();
                }
                return true;
            }
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.vs.setValue(this.vs.getValue());
                this.update();
                return true;
            }
            case 501: {
                this.requestFocus();
                int n = this.getSelected(event.x, event.y);
                if (n == -1) {
                    return true;
                }
                if (event.clickCount > 2) {
                    return true;
                }
                if (event.clickCount == 2) {
                    Event event2 = new Event(this, 1001, null);
                    this.getParent().postEvent(event2);
                }
                if (event.modifiers == 1) {
                    int n2;
                    if (!this.multipleSelections) {
                        return true;
                    }
                    this.selected = new int[0];
                    int n3 = n > this.prev ? this.prev : n;
                    int n4 = n2 = n > this.prev ? n : this.prev;
                    if (n3 == -1) {
                        n3 = n;
                    }
                    this.prev = n;
                    int n5 = n3;
                    while (n5 <= n2) {
                        this.select(n5);
                        ++n5;
                    }
                    this.update();
                    return true;
                }
                if (event.modifiers == 2) {
                    if (this.isSelected(n)) {
                        this.deselect(n);
                        this.update();
                        return true;
                    }
                    this.prev = n;
                    this.select(n);
                    this.update();
                    return true;
                }
                this.prev = this.getSelectedIndex();
                if (this.prev == n && !this.multipleSelections) {
                    return true;
                }
                this.selected = new int[0];
                this.prev = n;
                this.select(n);
                this.update();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        if (n == 1004) {
            int n2 = this.getSelectedIndex();
            if (n2 > 0) {
                this.select(n2 - 1);
            }
            return true;
        }
        if (n == 1005) {
            int n3 = this.getSelectedIndex();
            if (n3 > -1 && n3 < this.items.size() - 1) {
                this.select(n3 + 1);
            }
            return true;
        }
        if (n == 1002) {
            this.vs.setValue(this.vs.getValue() - this.page);
            this.update();
            return true;
        }
        if (n == 1003) {
            this.vs.setValue(this.vs.getValue() + this.page);
            this.update();
            return true;
        }
        if (n == 1000) {
            this.vs.setValue(0);
            this.select(0);
            this.update();
            return true;
        }
        if (n == 1001) {
            this.vs.setValue(100000);
            this.select(this.items.size() - 1);
            this.update();
            return true;
        }
        if (n == 10) {
            Event event2 = new Event(this, 1001, null);
            event2.modifiers = event.modifiers;
            this.getParent().postEvent(event2);
            return true;
        }
        if (n == 32) {
            if (this.getSelectedIndex() == -1 && this.items.size() > 0) {
                this.select(0);
            }
            return true;
        }
        return super.keyDown(event, n);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (n3 > 0 && n4 > 0) {
            this.offscreen = this.createImage(n3, n4);
        }
        this.setScrollbarState();
    }

    public Dimension preferredSize() {
        return new Dimension(80, 60);
    }

    public Dimension minimumSize() {
        return new Dimension(20, 20);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.fontMetrics = this.getFontMetrics(font);
            this.textHigh = this.fontMetrics.getHeight() - 1;
        }
    }

    public Vector getColors() {
        Vector<Color> vector = new Vector<Color>();
        int n = 0;
        while (n < this.countItems()) {
            vector.addElement(this.getItemColor(n));
            ++n;
        }
        return vector;
    }

    public void addNotify() {
        super.addNotify();
        Font font = this.getFont();
        this.fontMetrics = font != null ? this.getFontMetrics(font) : this.getFontMetrics(this.defaultfont);
        this.textHigh = this.fontMetrics.getHeight() - 1;
    }

    public void update() {
        if (!this.updateEnable) {
            return;
        }
        Dimension dimension = this.size();
        try {
            if (this.offscreen == null && dimension.width > 0 && dimension.height > 0) {
                this.offscreen = this.createImage(dimension.width, dimension.height);
            }
            Graphics graphics = this.offscreen.getGraphics();
            Graphics graphics2 = this.getGraphics();
            graphics.clipRect(0, 0, dimension.width, dimension.height);
            graphics.setFont(this.getFont());
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(graphics2.getColor());
            this.paint(graphics);
            graphics2.clipRect(0, 0, dimension.width, dimension.height);
            graphics2.drawImage(this.offscreen, 0, 0, this);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private int getSelected(int n, int n2) {
        int n3;
        super.size();
        int n4 = this.items.size();
        int n5 = this.textHigh;
        int n6 = n3 = this.vs.getValue();
        while (n6 < n4 && n6 < n3 + this.page) {
            if (n2 < n5) {
                return n6;
            }
            n5 += this.textHigh;
            ++n6;
        }
        return -1;
    }

    public void drawItem(Graphics graphics, int n, int n2) {
        try {
            if (this.items.elementAt(n).getClass().getName().equals("java.lang.String")) {
                this.drawText(graphics, n, n2);
                return;
            }
        }
        catch (Exception exception) {}
    }

    private void drawText(Graphics graphics, int n, int n2) {
        Rectangle rectangle = this.bounds();
        if (this.isSelected(n)) {
            graphics.setColor((Color)this.colText.elementAt(n));
            graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.nIndentLeft, n2 + this.nIndentTop, rectangle.width - 2 * this.nIndentLeft, this.textHigh - 1);
            graphics.setColor((Color)this.colText.elementAt(n));
        }
        graphics.drawString((String)this.items.elementAt(n), this.nIndentText, n2 + this.textHigh);
    }

    private void setScrollbarState() {
        if (!this.updateEnable) {
            return;
        }
        Dimension dimension = this.size();
        Insets insets = this.insets();
        dimension.height -= insets.top + insets.bottom;
        dimension.width -= insets.right + insets.left;
        this.page = dimension.height / this.textHigh;
        this.vs.reshape(insets.left + dimension.width - this.ScrollbarWidth, insets.top, this.ScrollbarWidth, dimension.height);
        int n = this.vs.getValue();
        if (n < 0) {
            n = 0;
        } else if (n > this.items.size() - 1) {
            n = this.items.size() - 1;
        }
        this.vs.setValues(n, this.page, 0, this.items.size());
        this.vs.setPageIncrement(this.page);
        this.vs.setLineIncrement(1);
        int n2 = this.items.size();
        if (dimension.height > n2 * this.textHigh) {
            this.vs.hide();
            this.vs.setValue(0);
            return;
        }
        this.vs.show();
    }

    public void setSelect(int n) {
        if (!this.selectable) {
            return;
        }
        this.selected = new int[1];
        this.selected[0] = n;
        int n2 = this.vs.getValue();
        if (n < n2) {
            this.vs.setValue(this.vs.getValue() - (n2 - n));
            n2 = this.vs.getValue();
            return;
        }
        if (n > n2 + this.page - 1) {
            this.vs.setValue(this.vs.getValue() + (n - (n2 + this.page - 1)));
            n2 = this.vs.getValue();
        }
    }

    public boolean updateEnabled() {
        return this.updateEnable;
    }

    public void enableUpdate(boolean bl) {
        if (bl != this.updateEnable) {
            this.updateEnable = bl;
            this.setScrollbarState();
            this.update();
        }
    }

    public String toString() {
        String string = new String();
        int n = 0;
        while (n < this.items.size()) {
            string = String.valueOf(string) + this.items.elementAt(n).toString() + '\n';
            ++n;
        }
        return string;
    }

    public boolean isFocusTraversable() {
        return this.items.size() > 0;
    }
}

