Echo off
Cls
Rem *------------------------------------------------------------*
Rem * 3M.BAT                                                     *
Rem *                                                            *
Rem * Performs incremental backups daily, Monday through Friday. *
Rem * Performs an image backup on Friday.                        *
Rem *                                                            *
Rem * Drive C: is the disk drive. Drive D: is the tape drive.    *
Rem *------------------------------------------------------------*

TGDAY
IF ERRORLEVEL 6 GOTO EXIT
IF ERRORLEVEL 5 GOTO FRI
IF ERRORLEVEL 4 GOTO THR
IF ERRORLEVEL 3 GOTO WED
IF ERRORLEVEL 2 GOTO TUE
IF ERRORLEVEL 1 GOTO MON
IF ERRORLEVEL 0 GOTO EXIT

:MON
Echo 
Echo    ͻ
Echo      Today is Monday  
Echo    ͼ
GOTO MOD_ONLY

:TUE
Echo 
Echo    ͻ
Echo      Today is Tuesday  
Echo    ͼ
GOTO MOD_ONLY

:WED
Echo 
Echo    ͻ
Echo      Today is Wednesday  
Echo    ͼ
GOTO MOD_ONLY

:THR
Echo 
Echo    ͻ
Echo      Today is Thursday  
Echo    ͼ

:MOD_ONLY
Echo 
Echo Daily we are performing an incremental backup of modified files only.
Echo 
Echo This requires a tape that has been formatted using
Echo the PREPTAPE program.
Echo 
GOTO MOD_BACK

:FRI
Echo 
Echo    ͻ
Echo      Today is Friday  
Echo    ͼ
Echo 
Echo Today we are performing first an incremental backup of
Echo modified files, then an Image backup of the entire disk.
Echo 

Rem ---------------------------------------------------
Rem Modified File Backup.  Done on Mon Tue Wed Thu Fri.
Rem ---------------------------------------------------
:MOD_BACK
Echo 
Echo Please insert the formatted tape for the incremental backup.
Echo 
pause
Echo 
Echo Performing incremental TEX backup from C: to D: . . .
Tex backup c:\ d:\ /h/m/o
IF ERRORLEVEL 1 GOTO FAIL

TGDAY
IF     ERRORLEVEL 6 GOTO END
IF NOT ERRORLEVEL 5 GOTO END
Rem It must be Friday.

Echo 
Echo 
Echo The incremental backup is complete.
Echo 
prom Y N 64 Do you need to PREPTAPE a new cartridge for Image backup? [Y/N]
if errorlevel 1 goto NOFORMAT
Echo 
preptape ##
rem preptape does not return an error level !!!
goto FULL

:NOFORMAT
Echo 
Echo 
Echo Please insert a formatted tape for the Image backup.
Echo 
pause

:FULL
Echo 
Echo Performing Image backup from C: to D: . . .
Image c: d:C.img/d
IF ERRORLEVEL 1 GOTO FAIL

:END
Echo 
Echo 
Echo            ͻ
Echo                           Backup has been                
Echo                       completed successfully.            
Echo            ͼ
GOTO EXIT

:FAIL
Echo 
Echo 
Echo            ͻ
Echo                         Backup has FAILED !              
Echo            ͼ
:EXIT
