/***************************************************************************
*	NAME:  PROBE16.C
**	COPYRIGHT:
**	"Copyright (c) 1994, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 01/01/94
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	01/01/94		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "ultraerr.h"

#include "gf1os.h"
#include "extern16.h"
#include "defs16.h"
#include "codecos.h"
#include "codec.h"
#include "proto16.h"

extern ULTRA16_DATA _codec_data;
extern IMAGE16 _image_codec;
extern ULTRA_DATA _gf1_data;

static void waste_time(unsigned int val)
{
int i,j;

for (i=0;i<val;i++)
	for (j=0;j<1000;j++)
		;
}

int
Ultra16Probe(gus_base,config)
int gus_base;
ULTRA16_CFG *config;
{
unsigned char version=0;
unsigned int setup;
unsigned char bits;
unsigned int port;
int enable_16;
int temp;

port = config->base_port;

_codec_data.type = config->type;
_codec_data.base_port = port;
_codec_data.addr = port+CODEC_ADDR;
_codec_data.data = port+CODEC_DATA;
_codec_data.status = port+CODEC_STATUS;
_codec_data.pio = port+CODEC_PIO;

switch(config->type)
	{
	case 0:
		break;		/* daughter card */
	case 1:			/* UltraMAX */
		{
		setup = 0x00;		/* default codec to disabled */
		enable_16 = FALSE;
		if (port >= 0x300 && port <= 0x3f0)
			{
			enable_16 = TRUE;
			bits = (port - 0x30C) >> 4;		/* isolate bits */
			setup |= bits;
			}
		if (enable_16)
			setup |= 0x40;
		if (config->rec_dma >= 4)
			setup |= 0x10;					/* record is 16 bit channel */
		if (config->play_dma >= 4)
			setup |= 0x20;					/* play is 16 bit channel */
		_codec_data.setup = setup;			/* save to toggle later */
		outp(gus_base+0x106,setup);		/* program the interface */
		waste_time(100);				/* probably not needed ... */
		break;		/* UltraMax */
		}
	}

/* clear any pending IRQs */
(void)inp(_codec_data.status);
outp(_codec_data.status,0);

for (temp=0;temp<1000;temp++)
	{
	if (inp(_codec_data.base_port) & CODEC_INIT)
		waste_time(1);				/* probably not needed ... */
	else
		{
		version = Ultra16Revision();
		if ((version >= 1) && (version < 15))
			{
			/* Don't combine if an UltraMax */
			if ((config->play_dma == config->rec_dma) && (config->type != 1))
				_image_codec.ic |= SINGLE_DMA;	
ENTER_CRITICAL;
			outp(_codec_data.addr,CODEC_MCE|IFACE_CTRL);
			outp(_codec_data.data,_image_codec.ic);
			outp(_codec_data.addr,IFACE_CTRL);
LEAVE_CRITICAL;
			return(ULTRA_OK);
			}
		}
	}

if ((version >= 1) && (version < 15))
	{
	/* Don't combine if an UltraMax */
	if ((config->play_dma == config->rec_dma) && (config->type != 1))
		_image_codec.ic |= SINGLE_DMA;	

ENTER_CRITICAL;
	outp(_codec_data.addr,CODEC_MCE|IFACE_CTRL);
	outp(_codec_data.data,_image_codec.ic);
	outp(_codec_data.addr,IFACE_CTRL);
LEAVE_CRITICAL;
	return(ULTRA_OK);
	}
else
	return(NO_ULTRA);
}

