IFNDEF MACSRV_BCAST
include vector.inc
ENDIF

;versions
MAJORVERS	equ	1
MINORVERS	equ	7

;device characteristics flags (DOS)
DEV_SUP_IOCTL	EQU 0100000000000000B ; 14  device supports IOCTL (DOS)

;service flags
SERVFL		equ	MACSRV_BCAST + MACSRV_MCAST + MACSRV_PROMIS + MACSRV_SETSNPA \
			+ MACSRV_OPENDEV + MACSRV_GDTADDR

;module name
MODULENAME	equ	"MAC2X5_"
MODNMSZ		equ	14		;size of module name


;driver wide constants

BUFSIZE		equ	1536d		;size of buffers

;CRC not included in length constants
MINPACKET	equ	60d		;minimum packet size
MAXPACKET	equ	1514d		;maximum packet size


;default values of parameters
MCASTDEFAULT	equ	5		;number of multicast addresses


;macro for adding to double words (used for statistics)
DWADD		MACRO	addr,num
		add	WORD PTR addr,num
		adc	WORD PTR addr[2],0
		ENDM

;macro for pushing constants
pushc		MACRO	immed
IFDEF		DOS
		mov	ax,immed
		push	ax
ELSE
		push	immed
ENDIF
		ENDM

;board types
EXOS_205	equ	0
EXOS_225	equ	1
EXOS_325	equ	2
EXOS_215	equ	3


;Packet Types
REJECT		EQU	-1
DIRECTED	EQU	0
MULTICAST	EQU	1
BROADCAST	EQU	2


;length of ethernet header 
HEADERSZ	EQU	14d	;6 for each address, 2 for Type/Length

;PIC address
PIC1COM		EQU	20h	;register for EOI on PIC 1
PIC1MASK	EQU	21h	;register for masking on PIC 1
PIC2COM		EQU	0A0h	;register for EOI on PIC 2
PIC2MASK	EQU	0A3h	;register for masking on PIC2
EOI		EQU	20h	;non specific EOI


;DOS debugging macro
PRINT	MACRO	arg
IFDEF	DOS
comment ^
	push	ax
	push	dx
	mov	dl,arg
	mov	ah,2
	int	21h
	pop	dx
	pop	ax
^
ENDIF
	ENDM


;performance measurement macro used with oscilloscope.
PULSE	MACRO
	push	dx
	push	ax
	mov	dx,320h
	in	ax,dx
	pop	ax
	pop	dx
	ENDM


