#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long LONG;

#define zap(a)				{memset ( &a, NULL, sizeof(a));}

struct scanBindReq {
	WORD	Length;
	BYTE	Function;
	LONG	LastObjectID;
	WORD	ObjectType;
	BYTE	ObjectNameLength;
	BYTE	ObjectName[48];
	};

struct scanBindRep {
	WORD	Length;
	LONG	ObjectID;
	WORD	ObjectType;
	BYTE	ObjectName[48];
	BYTE	ObjectFlag;
	BYTE	ObjectSecurity;
	BYTE	ObjectHasProperties;
	};

struct getDiskUtilizationReq {
	WORD	Length;
	BYTE	Function;
	BYTE	VolumeNumber;
	LONG	ObjectID;
	};

struct getDiskUtilizationRep {
	WORD	Length;
	BYTE	VolumeNumber;
	LONG	ObjectID;
	WORD	UsedDirectories;
	WORD	UsedFiles;
	WORD	UsedBlocks;
	};

struct getVolumeNameReq {
	WORD	Length;
	BYTE	Function;
	BYTE	VolumeNumber;
	};

struct getVolumeNameRep {
	WORD	Length;
	BYTE	VolumeNameLength;
	BYTE	VolumeName[16];
	};

struct getFileServerInformationReq {
	WORD	Length;
	BYTE	Function;
	};

struct getFileServerInformationRep {
	WORD	Length;
	BYTE	ServerName[48];
	BYTE	NetWareVersion;
	BYTE	NetWareSubversion;
	WORD	ConnectionsSupported;
	WORD	ConnectionsInUse;
	WORD	MaxConnectionsUsed;
	BYTE	OSRevisionNumber;
	BYTE	SFTLevel;
	BYTE	TTSLevel;
	WORD	PeakConnectionsUsed;
	BYTE	AccountingVersion;
	BYTE	VAPVersion;
	BYTE	QueuingVersion;
	BYTE	PrintServerVersion;
	BYTE	VirtualConsoleVersion;
	BYTE	SecurityRestrictionsLevel;
	BYTE	InternalBridgeVersion;
	BYTE	Reserved[60];
	};

struct UserInfo {
	LONG	UserID;
	char	UserName[48];
	LONG	Blocks[32];
	struct UserInfo	*Next;
	};

struct scanDirectoryInformationReq {
	WORD	Length;
	BYTE	Function;
	BYTE	DirectoryHandle;
	WORD	SubdirectoryNumber;
	BYTE	DirectoryPathLength;
	BYTE	DirectoryPath[255];
	};

struct scanDirectoryInformationRep {
	WORD	Length;
	BYTE	SubdirectoryName[16];
	LONG	CreationDateAndTime;
	LONG	OwnerObjectID;
	BYTE	MaximumRightsMask;
	BYTE	Unused;
	WORD	SubdirectoryNumber;
	};

struct getFileInformationReq {
	WORD	Length;
	BYTE	Function;
	WORD	SequenceNumber;
	BYTE	DirectoryHandle;
	BYTE	SearchAttribute;
	BYTE	FilePathLength;
	BYTE	FilePath[255];
	};

struct getFileInformationRep {
	WORD	Length;
	WORD	SequenceNumber;
//	BYTE	FileName[15];
	BYTE	FileName[14];
	BYTE	FileAttributes;
	BYTE	ExtendedFileAttributes;
	LONG	FileSize;
	WORD	CreationDate;
	WORD	LastAccessDate;
	LONG	LastUpdateDateAndTime;
	LONG	OwnerObjectID;
	LONG	LastArchiveDateAndTime;
	BYTE	Reserved[56];
	};

char ServerName[49];
char VolumeName[32][17];
struct UserInfo *UserList;

int API_E3(void *Request, void *Reply)
{
	_SI=(unsigned)Request;
	_DI=(unsigned)Reply;
	_ES=_DS;
	_AH=0xE3;
	geninterrupt(0x21);
	return(_AL);
}

int API_E2(void *Request, void *Reply)
{
	_SI=(unsigned)Request;
	_DI=(unsigned)Reply;
	_ES=_DS;
	_AH=0xE2;
	geninterrupt(0x21);
	return(_AL);
}

void pause()
{
	if (getch()==NULL) getch();
}

void perror(int ern)
{
	switch (ern)
	{
		case 0x00: printf("Success\n");                  break;
		case 0x96: printf("Server Out Of Memory\n");     break;
		case 0x9C: printf("Invalid Path\n");             break;
		case 0xD0: printf("Q Error\n");                  break;
		case 0xD1: printf("No Queue\n");                 break;
		case 0xD2: printf("No Q Server\n");              break;
		case 0xD3: printf("No Q Rights\n");              break;
		case 0xD5: printf("No Q Job\n");                 break;
		case 0xEC: printf("No Such Segment\n");          break;
		case 0xEF: printf("Invalid name\n");             break;
		case 0xF0: printf("Wildcard Not Allowed\n");     break;
		case 0xF1: printf("Invalid Bindary Security\n"); break;
		case 0xFB: printf("No Such Property\n");         break;
		case 0xFC: printf("No Such Object\n");           break;
		case 0xFE: printf("Server Bindary Locked\n");    break;
		case 0xFF: printf("Bindary Failure\n");          break;
		default:   printf("Unknown error #%2x#\n",ern);  break;
	}
}

WORD swapw(WORD x)
{
	union
	{
		WORD w;
		BYTE b[2];
	} U;
	BYTE t;

	U.w=x;
	t=U.b[0];
	U.b[0]=U.b[1];
	U.b[1]=t;

	return (U.w);
}

LONG swapl(LONG x)
{
	union
	{
		LONG l;
		WORD w[2];
	} U;
	WORD t;

	U.l=x;
	t=swapw(U.w[0]);
	U.w[0]=swapw(U.w[1]);
	U.w[1]=t;
	return (U.l);
}

int ScanBinderyObject (char *searchObjectName, WORD searchObjectType,
	LONG *objectID, char *objectName, WORD *objectType,
	BYTE *objectHasProperties, BYTE *objectFlag,
	BYTE *objectSecurity)
{
	static long Last_ObjectID=0xFFFFFFFF;

	struct scanBindReq Request;
	struct scanBindRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=          sizeof(Request)-2;
	Request.Function=        0x37;
	Request.LastObjectID=    Last_ObjectID;
	Request.ObjectType=      searchObjectType;
	Request.ObjectNameLength=strlen(searchObjectName);
	strcpy(Request.ObjectName,searchObjectName);

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	*objectID           =Reply.ObjectID;
	strcpy(objectName,Reply.ObjectName);
	*objectType		    =Reply.ObjectType;
	*objectHasProperties=Reply.ObjectHasProperties;
	*objectFlag         =Reply.ObjectFlag;
	*objectSecurity     =Reply.ObjectSecurity;

	Last_ObjectID=*objectID;

	return (result);
}

void GetServerName()
{
	struct getFileServerInformationReq Request;
	struct getFileServerInformationRep Reply;

	int result;

	zap(ServerName);
	zap(Request);
	zap(Reply);

	Request.Length=      sizeof(Request)-2;
	Request.Function=    0x11;

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	if (result!=0)
	{
		perror(result);
		exit(0);
	}
	memccpy(ServerName,Reply.ServerName,'\0',sizeof(Reply.ServerName));

	return;
}

void GetVolInfo()
{
	struct getVolumeNameReq Request;
	struct getVolumeNameRep Reply;

	int i;
	int result;

	GetServerName();
	printf("%-16s",ServerName); // space over 16 cols

	zap(VolumeName);

	for(i=0;i<32;i++)
	{
		zap(Request);
		zap(Reply);

		Request.Length=      sizeof(Request)-2;
		Request.Function=    0x06;
		Request.VolumeNumber=i;

		Reply.Length=sizeof(Reply)-2;

		result=API_E2(&Request,&Reply);

		if (result!=0 && result!=0xFB) perror(result);
		if (result==0)
		{
			memccpy(VolumeName[i],Reply.VolumeName,'\0',Reply.VolumeNameLength);
			if (VolumeName[i][0]!='\0') printf("%9s",VolumeName[i]);
		}
	}
	printf("\n");
	return;
}

int getIDAndName(LONG *ObjectID, char *UserName)
{
	char searchObjectName[2]="*";
	WORD searchObjectType=0x0100;
	WORD objectType;
	BYTE objectHasProperties;
	BYTE objectFlag;
	BYTE objectSecurity;

	int result;

	result=ScanBinderyObject(searchObjectName, searchObjectType, ObjectID,
		UserName, &objectType, &objectHasProperties, &objectFlag,
		&objectSecurity);

	return(result);
}

int getUsage(LONG UserID,int Vol,LONG *Blocks)
{
	struct getDiskUtilizationReq Request;
	struct getDiskUtilizationRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=      sizeof(Request)-2;
	Request.Function=    0x0E;
	Request.VolumeNumber=Vol;
	Request.ObjectID=    UserID;

	Reply.Length=sizeof(Reply)-2;

	result=API_E3(&Request,&Reply);

	*Blocks=Reply.UsedBlocks;
	return(result);
}

void ScanRootFiles(int Vol,char *FilePath);
void ScanRootDirs(int Vol,char *FilePath)
{
	struct scanDirectoryInformationReq Request;
	struct scanDirectoryInformationRep Reply;

	int FilePathLength;
	int result;

	FilePathLength=strlen(FilePath);

	zap(Request);
	zap(Reply);

	Request.Length=      sizeof(Request)-2;
	Request.Function=    0x02;
	Request.DirectoryHandle=0;
	Request.SubdirectoryNumber=0;
	strcpy(Request.DirectoryPath,VolumeName[Vol]);
	strcat(Request.DirectoryPath,":");
	strcat(Request.DirectoryPath,FilePath);
	fprintf(stderr,"%-79s\r",Request.DirectoryPath);
	strcat(Request.DirectoryPath,"*");
	Request.DirectoryPathLength=strlen(Request.DirectoryPath);

	Reply.Length=sizeof(Reply)-2;

	result=0;
	while (result==0)
	{
		result=API_E2(&Request,&Reply);

		if (result==0x9C) break;
		if (result!=0)
		{
			perror(result);
			exit(1);
		};

//		printf("%s:%s%s\n",VolumeName[Vol],FilePath,Reply.SubdirectoryName);
		strcat(FilePath,Reply.SubdirectoryName);
		strcat(FilePath,"\\");
		ScanRootFiles(Vol,FilePath);
		ScanRootDirs(Vol,FilePath);
		FilePath[FilePathLength]='\0';

		Request.SubdirectoryNumber=swapw(swapw(Reply.SubdirectoryNumber)+1);
	}
}

WORD Clip(LONG s) // Assume 4K blocks [=2^12]
{
	LONG i,j;

	if ((s&0x0FFF)!=0) return ((s>>12)+1);
	return (s>>12);
}

void AddToUser(int Vol,LONG FileSize,LONG UserID)
{
	struct UserInfo *t;

	t=UserList;
	while (t!=NULL)
	{
		if ((*t).UserID==UserID)
		{
			(*t).Blocks[Vol]=(*t).Blocks[Vol]+Clip(FileSize);
			break;
		}
		else t=(*t).Next;
	}
}

void ScanRootFiles(int Vol,char *FilePath)
{
	struct getFileInformationReq Request;
	struct getFileInformationRep Reply;

	int result;

	zap(Request);
	zap(Reply);

	Request.Length=         sizeof(Request)-2;
	Request.Function=       0x0F;
	Request.SequenceNumber= 0xFFFF;
	Request.DirectoryHandle=0;
	Request.SearchAttribute=0x06;
	strcpy(Request.FilePath,VolumeName[Vol]);
	strcat(Request.FilePath,":");
	strcat(Request.FilePath,FilePath);
	strcat(Request.FilePath,"*");
	Request.FilePathLength=strlen(Request.FilePath);

	Reply.Length=sizeof(Reply)-2;

	result=0;
	while (result==0)
	{
		result=API_E3(&Request,&Reply);

		if (result==0xFF) break;
		if (result!=0)
		{
			perror(result);
			exit(1);
		};

//		printf("%16ld %4d %s:%s%s\n",swapl(Reply.FileSize),Clip(swapl(Reply.FileSize)),VolumeName[Vol],FilePath,Reply.FileName);
		Request.SequenceNumber=Reply.SequenceNumber;
		AddToUser(Vol,swapl(Reply.FileSize),Reply.OwnerObjectID);
	}
}

void ScanRoot(int Vol)
{
	char FilePath[128];

	zap(FilePath);
	ScanRootFiles(Vol,FilePath);

	zap(FilePath);
	ScanRootDirs(Vol,FilePath);

	zap(FilePath);
	fprintf(stderr,"%-79s\r",FilePath);

}

void GetUserList()
{
	LONG UserID;
	char UserName[48];
	struct UserInfo *t;

	int result;

	UserList=NULL;
	result=0;
	while(result==0)
	{
		result=getIDAndName(&UserID,UserName);
		if (result!=0) break;
		if (!(t = new UserInfo))
		{
			printf("Insufficient memory\n");
			exit (1);
		}
		(*t).UserID=UserID;
		memccpy((*t).UserName,UserName,'\0',sizeof(UserName));
		zap((*t).Blocks);
		(*t).Next=UserList;
		UserList=t;
	}
}

void DisplayTotals()
{
	struct UserInfo *t;
	int Vol;

//	Print namelist
	t=UserList;
	while (t!=NULL)
	{
		printf("%-16s",(*t).UserName);
		for (Vol=0;Vol<32;Vol++)
		{
			if (VolumeName[Vol][0]=='\0') break;
			printf(" %8lu",(*t).Blocks[Vol]*4);
		}
		printf("\n");
		t=(*t).Next;
	}

	return;
}

main()
{
	int Vol;

	printf("Usage Counter v1.1b\n");
	printf("By Jeff Pilant <pilant@nadc.nadc.navy.mil>\n");

	GetUserList();
	GetVolInfo();
	for (Vol=0;Vol<32;Vol++)
	{
		if (VolumeName[Vol][0]=='\0') break;
		ScanRoot(Vol);
	};
	DisplayTotals();

	return(0);
}
