#include <stdio.h>
#include <errno.h>
#include <dos.h>

void errmsg()
{
	printf("Error: problem creatng files.\n");
	exit(2);
}

void main()
{
	int i,count;
	char *s;
	char fn[130];
	FILE *fh;

	if (_argc!=4)
	{
		printf("Usage:\n");
		printf("  %s <dirname> <key> <count>\n",_argv[0]);
		printf("where <dirname> is the name of a directery to use to create the licence.\n");
		printf("      <key>     is the filename key to use for this licence.\n");
		printf("                Note: must be from one to seven chars long.\n");
		printf("      <count>   is the number of licences to generate.\n");
		exit(1);
	}

	if (strlen(_argv[2])>7)
	{
		printf("Error: key '%s' is too long.\n",_argv[2]);
		exit(2);
	}

	count=atoi(_argv[3]);
	if (count<1 || count>999)
	{
		printf("Error: count '%s' is not valid.\n",_argv[3]);
		exit(2);
	}

	s=_argv[1];
	for(i=strlen(_argv[1]);i>1;i--) s++;
	if (*s=='\\' || *s=='/')
	{
		printf("Error: dirname cannot end in a slash.\n");
		exit(2);
	}

	sprintf(fn,"%s\\%s.lic",_argv[1],_argv[2]);
	fh=fopen(fn,"a");
	if (fh==NULL) errmsg();
	fclose(fh);
	sprintf(fn,"%s\\%s.nam",_argv[1],_argv[2]);
	fh=fopen(fn,"a");
	fclose(fh);
	if (fh==NULL) errmsg();
	for (i=1;i<=count;i++)
	{
		sprintf(fn,"%s\\%sU.%03d",_argv[1],_argv[2],i);
		fh=fopen(fn,"a");
		if (fh==NULL) errmsg();
		fclose(fh);
	}
	printf("%s licence file%s created in %s.\n",_argv[2],count==1?"":"s",_argv[1]);
	exit(0);
}
