
/* NT IBM SDLC Adapter Device Driver: Tracing */

typedef UCHAR  TRC_NAME[2];
typedef USHORT TRC_WORD;
typedef ULONG  DWORD;

#ifdef XDEBUG                           /* extra debugging?                  */
#define XASSERT(c) ASSERT(c)
#else
#define XASSERT(c)
#endif
#define assert ASSERT                   /* when I say assert, i mean ASSERT! */

/*****************************************************************************/
/* Tracing                                                                   */
/*                                                                           */
/* TRACE_OBJECT depends on the objects having a TRC_NAME.                    */
/* The registered code then is FfOo - 2 chars of function, 2 giving the name */
/* of the object.                                                            */
/*                                                                           */
/* Every trace entry is 4 bytes.  Wraparound is only checked when putting in */
/* the start of an entry. If the implementation of TRACE_OBJECT/EVENT as it  */
/* stands now is too slow, we can define TRACE_EVENT_WORD(c1,c2,c3,c4)       */
/* as (c1<<24)+(c2<<16) etc. and use those values directly                   */
/*****************************************************************************/

#ifdef IBMSYNC_TRACE

#define         TRC_ENTRIES   1024 /* entry count*/
#define         TRC_ESIZ      4 /* entry size */
#define         TRC_BUFSIZE   (TRC_ENTRIES*TRC_ESIZ)
#define         TRC_BUFOVERRUN 4        /* see TRC_WRAPCHECK below           */
#define         TrcPtr2Far   (TrcBuffer+sizeof(TrcBuffer) - 16)
                                        /* leave 16 bytes spare @ end to     */
                                        /* catch any overflow situations!    */

#define DEBUG_PRINT(string)   DbgPrint string

#define TRACE_INIT()          { TrcPtr = TrcBuffer;                          \
                                memset (TrcBuffer, 0, sizeof(TrcBuffer));    \
                              }
/* WRAPCHECK's ASSERTion: we may have this sequence
   - check on non-interrupt side for wrap-check
   - get interrupt
   - check on interrupt side for wrap-check
   - now both sides feel free to increment - so can overrun TrcPtr by 4
   - but this should go no further - hence check on BUFOVERRUN=4
*/
#define TRC_WRAPCHECK()       if (TrcPtr >= TrcPtr2Far)                      \
                              {                                              \
                                ASSERT(TrcPtr<=(TrcPtr2Far+TRC_BUFOVERRUN)); \
                                /* mustn't go past end! */                   \
                                TrcPtr = TrcBuffer;                          \
                              }
#define TRC_IN_CHAR(c)        *(TrcPtr++) = ((UCHAR) c)
#define TRC_RE_SET(c)         *(TrcPtr-1) = ((UCHAR) c)
#define TRC_IN_WORD(wval)     *(CAST(TrcPtr,TRC_WORD *)++) = CAST(wval,TRC_WORD)
#define TRC_IN_DW(dval)       *(((DWORD *)TrcPtr)++)    = ((DWORD   ) (dval))

#define TRC_IN_PWORD(wp)      TRC_IN_WORD (MAKETYPE(*wp, TRC_WORD))
#define TRC_IN_PDW(dp)        TRC_IN_DW   (MAKETYPE(*dp, DWORD))

#define TRACE_OBJECT(f,o)   { TRC_WRAPCHECK();                                \
                              TRC_IN_PWORD(#f);    /* 'f' is 2 literal chars*/\
                              TRC_IN_PWORD(o.Name);/* 'o' is a .Name'd objct*/\
                            }
#define TRACE_ACTION(a,p)   { TRC_WRAPCHECK();                                \
                              TRC_IN_PWORD(#a);   /* 'a' is action name     */\
                              TRACE_WORD(p);      /* 'p' is trace param     */\
                            }
#define TRACE_CHAR(c)       { TRC_WRAPCHECK(); TRC_IN_CHAR(c); }
#define TRACE_DWORD(d)      {                                      \
                              DWORD dd = CAST (d, DWORD);          \
                              char * pd = CAST(&dd, char *);       \
                              TRC_WRAPCHECK();                     \
                              TRC_IN_CHAR(*(pd+3));                \
                              TRC_IN_CHAR(*(pd+2));                \
                              TRC_IN_CHAR(*(pd+1));                \
                              TRC_IN_CHAR(*(pd  ));                \
                            }
#define TRACE_WORD(w)       {                                      \
                              SHORT ww = CAST (w, SHORT);          \
                              char * pw = CAST(&ww, char *);       \
                              TRC_WRAPCHECK();                     \
                              TRC_IN_CHAR(*(pw+1));                \
                              TRC_IN_CHAR(*(pw  ));                \
                            }
//#define TRACE_PDWORD(pd)    TRACE_DWORD (CAST ((*pd), DWORD))
#define TRACE_EVENT(d)      { TRC_WRAPCHECK();                                \
                              TRC_IN_PDW(#d);                                 \
                            }
#define TRACE_EVENTNAME(d)  { TRC_WRAPCHECK();                                \
                              TRC_IN_PDW(d);                                  \
                            }
#define TRACE_NEWLINE()     { TRACE_CHAR ('&');                               \
                              while ((TrcPtr-TrcBuffer) & 0x0F)               \
                                TRACE_CHAR('&');                              \
                            }
#define TRACE_RCZERO(var)   { if (!var) TRACE_ACTION (Rc,0); } /*no trc if !0*/
#define TRACE_RCFALSE(var)  TRACE_RCZERO(var)
#define TRACE_RCNONZERO(var) {if (var)  TRACE_ACTION (Rc,var); } /*no trc if 0 */
#define TRACE_NTFAILURE(v)  { if (!NT_SUCCESS(v))                             \
                              {                                               \
                                TRACE_EVENT (NtFl)                            \
                                TRC_IN_DW (v);                                \
                              }                                               \
                            }
#define TRACE_DATABYTE(s,v) { TRACE_EVENT(s); TRC_RE_SET(v); }

#define TRACE_RC(var)       { TRACE_ACTION(Rc, (TRC_WORD) var); }

/*****************************************************************************/
/* TRACE EVENTS.   '_' == { etc. (entry) or } etc. (exit)                    */
/* TRACE DATABYES. '.' == databyte value                                     */
/*                                                                           */
/* Type   Cmd_   Adapter command sequence                                    */
/*        ----   ---------------------------------------------               */
/* Objct  Ad     Adapter (device extension)                                  */
/* Call   ARs_   Adapter reset (low level)                                   */
/* Call   C73_   Close8273Sequence                                           */
/* Call   DevI   Device Successfully initialised                             */
/* Call   DiNa   DeviceInit: No adapter                                      */
/* Call   DiNd   DeviceInit: No device allocated by create device            */
/* Call   DmaX   Dma buffer crosses 64k                                      */
/* Call   DPC_   Routine: DPC.                                               */
/* Call   DrvF   Driver Load Failure                                         */
/* Call   Entr   DriverEntry called from NT                                  */
/* Call   EPC_   Routine: EntryPointClose                                    */
/* Call   EPD_   Routine: EntryPointDevIoctl                                 */
/* Call   EPO_   Routine: EntryPointOpen                                     */
/* Call   EP?_   Routine: EntryPointRogueInterrupt (Int 4 from PCA adapter)  */
/* Call   GV2_   Routine: Get V24                                            */
/* Call   HwIF   Hardware init failure                                       */
/* Call   IAR_   Routine: IoctlAbortRx                                       */
/* Call   IAT_   Routine: IoctlAbortTx                                       */
/* Objct  Ii     Iostatus Information field set                              */
/* Objct  In     Initialise: (Buffer)                                        */
/* Call   InA_   Routine: Initialise adapter                                 */
/* Call   InRF   Init RFDs                                                   */
/* Call   IoC_   Routine: IoctlSetLinkCharacteristics                        */
/* Call   IoI_   Routine: IoctlSetInterfaceRecord                            */
/* Call   IoR_   Routine: IoctlRxFrame                                       */
/* Call   IoRN   Ioctl RxFrame: nothing received (unsatisfied poll)          */
/* Call   IoS_   Routine: IoctlSetInterface Record                           */
/* Call   IoT_   Routine: IoctlTxFrame                                       */
/* Call   IVI_   Routine: IoctlGetV24Input                                   */
/* Call   IVO_   Routine: IoctlSetV24Output                                  */
/* Byte   Mpc    Config byte going to MPCA                                   */
/* Call   OcAs   OpenCreate: Allocate of SpinLock failed                     */
/* Call   OcCi   OpenCreate: Connect to interrupt failed                     */
/* Call   OcWb   OpenCreate: Wrong bus                                       */
/* Word   Op     Open adapter with base address bbbb                         */
/* Word   Ra     Rx AvailableByteCount (RxFSMActionStart)                    */
/* Call   RAI_   Routine: RxFSMActionInvalid                                 */
/* Objct  Rb     Rx Buffer number                                            */
/* Word   Rc     Return code Word                                            */
/*        Rg     RFDNextToGet   - RFD_GOT          (RFD)                     */
/* Word   Rl     Received fram length llll                                   */
/* Call   RFE_   Routine: RxFSMEvent                                         */
/* Word   Rm     RxFSMActionRcvError - ErrorMapArray entry value             */
/* Call   ROk_   Routine: RxFSMActionRcvOK                                   */
/* Objct  Rp     RFDNowBeingPut - RFD_PUT_COMPLETE (RFD)                     */
/* Word   Rs     Rx StartIndex                                               */
/* Call   RSt_   Routine: RxFSMActionStart                                   */
/* Call   RSo_   Routine: RxFSMActionStop                                    */
/* Byte   RxD    Received data byte                                          */
/* Byte   RxR    Receiver result byte                                        */
/* Call   SDM_   Routine: StartDMA                                           */
/* Call   SLC_   Routine: SetLinkConfig                                      */
/* Word   St     Non-success NT status                                       */
/* Call   T!!!   Routine: TxFSMAction Invalid!                               */
/* Word   Ta     Ta Tx BuffserSpaceAvailable                                 */
/* Call   TAb    Routine: TxFSMActionAbort                                   */
/* Word   Tb     Tb TxNextToBuffer                                           */
/* Byte   TEb    Transmit result error byte                                  */
/* Call   TEr    Routine: TxFSMActionEndError                                */
/* Word   Tn     Tn BufferSpaceNeeded                                        */
/* Call   TPIO   TxPIOData pointer follows                                   */
/* Word   Tt     Tt TxNextToTransmit                                         */
/* Word   Tu     Tu TxStartUnusedArea                                        */
/* Word   Tx     Tx LinkMaxFrameSize                                         */
/* Byte   TxD    Transmit data byte                                          */
/* Byte   TxR    Transmit result byte                                        */
/* Call   WaTo   WAITUNTIL Timeout (leading to hardware error incremented)   */
/* Call   XEO_   Routine: SynchEntryPointOpen                                */
/* Call   XR8_   Routine: SynchReset8273                                     */
/* Call   XTA_   Routine: SynchTerminateAdapter                              */
/* Call   ZDM_   Zap (= Mask) DMA                                            */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/

#else

#define DEBUG_PRINT(string)

#define TRACE_OBJECT(f,o)
#define TRACE_ACTION(a,p)
#define TRACE_CHAR(c)
#define TRACE_DWORD(d)
#define TRACE_PDWORD(pd)
#define TRACE_EVENT(d)
#define TRACE_NEWLINE()
#define TRACE_RCZERO(var)
#define TRACE_RCFALSE(var)
#define TRACE_RCNONZERO(var)
#define TRACE_NTFAILURE(v)
#define TRACE_DATABYTE(s,v)
#define TRACE_RC(var)

#endif

#ifdef XDEBUG

#define XTRACE_OBJECT     TRACE_OBJECT
#define XTRACE_ACTION     TRACE_ACTION
#define XTRACE_CHAR       TRACE_CHAR
#define XTRACE_DWORD      TRACE_DWORD
#define XTRACE_PDWORD     TRACE_PDWORD
#define XTRACE_EVENT      TRACE_EVENT
#define XTRACE_NEWLINE    TRACE_NEWLINE
#define XTRACE_RCZERO     TRACE_RCZERO
#define XTRACE_RCFALSE    TRACE_RCFALSE
#define XTRACE_RCNONZERO  TRACE_RCNONZERO
#define XTRACE_NTFAILURE  TRACE_NTFAILURE
#define XTRACE_DATABYTE   TRACE_DATABYTE
#define XTRACE_RC         TRACE_RC

#else

#define XTRACE_OBJECT(f,o)
#define XTRACE_ACTION(a,p)
#define XTRACE_CHAR(c)
#define XTRACE_DWORD(d)
#define XTRACE_PDWORD(pd)
#define XTRACE_EVENT(d)
#define XTRACE_NEWLINE()
#define XTRACE_RCZERO(var)
#define XTRACE_RCFALSE(var)
#define XTRACE_RCNONZERO(var)
#define XTRACE_NTFAILURE(v)
#define XTRACE_DATABYTE(s,v)
#define XTRACE_RC(var)

#endif

