
/* NT IBM SDLC Adapter Device Driver: Device Objects */


/*       Resource Type equates */

#define GRABBEDRESOURCE_GOTDMA        0x04

//#############################################################################

/*****************************************************************************/
/* Config data record                                                        */
/*****************************************************************************/

typedef enum           _ADAPTER_TYPE
{
                        AT_NONE  = -1,
                        AT_SDLC  = 0,
                        AT_MPCA1 = 2,
                        AT_MPCA2 = 3,
                        AT_MPAA1 = 4,
                        AT_MPAA2 = 5,
                        AT_COUNT = 6
}
                        ADAPTER_TYPE;

typedef struct         _CONFIGDATA
{
  ADAPTER_TYPE          AdapterType;
  char *                FlavourName;
  IO_ADDRESS            AdapterBaseAddress;
                        /* bottom byte (& 0xFF) can be used as an identifier */
  UCHAR                 MPAAAdapterIdentifier;  /* as set in MCA POS register*/
  UCHAR                 DMAChannel;         /* set by GetConfigData          */
  IO_ADDRESS            MPCAModePort;
  UCHAR                 MPCAModeValue;
  ULONG                 AddressSpace;
  ULONG                 BusNumber;
  KIRQL                 Irql;
  CCHAR                 Vector;
  BOOLEAN               Shareable;          /* we share internally, not viaNT*/
  KINTERRUPT_MODE       InterruptMode;
  KIRQL                 Irql2;
  CCHAR                 Vector2;
  BOOLEAN               Shareable2;
  KINTERRUPT_MODE       InterruptMode2;
}                       CONFIGDATA,
                     * PCONFIGDATA;

#define IRQ3 (KIRQL)((CCHAR)HIGH_LEVEL - 3)
#define IRQ4 (KIRQL)((CCHAR)HIGH_LEVEL - 4)

/*****************************************************************************/
/* The Device object - one per adapter.                                      */
/*****************************************************************************/

typedef struct         _IBMSYNC_DEVICE_EXTENSION
{
  PDEVICE_OBJECT     pDeviceObject;     /* backpointer from extn -> DeviceObj*/
#ifdef IBMSYNC_TRACE
  TRC_NAME            Name;
#endif
  BOOLean             DeviceIsOpen;     /* true after successful OpenCreate  */
                                        /* 'device' is NT object             */
  BOOLean             AdapterIsClosing; /* 'adapter' is the card.  When this */
                                        /* is set, ignore interrupts         */
  PIRP                IoctlCurrentIrp;  /* Pass pIrp to Ioctl routines becos */
                                        /* some are exec'd via KeSynchrExec  */
                                        /* which can only pass pDX.          */
  PKEVENT            pUserEvent;        /* user's event from SetSemaphoreH   */
  BOOLean             HardwareError;    /* if set, fatal hardware error -    */
                                        /* e.g. WAITUNTIL timed out          */
                                        /* picked up @ end of EntryPtIoctl   */
                                        /* Reset by AdapterReset             */
  ULONG               Information;      /* If a synchronized routine wants to*/
                                        /* return an error status, it can't  */
                                        /* do it directly because synchnr.   */
                                        /* routines return a boolean only.   */
                                        /* Therefore return a failure        */
                                        /* indication and set the IoStatus.  */
                                        /* Information value in here.        */
                                        /* Also used to return frame length  */
                                        /* for IoctlRxFrame.                 */
  NTSTATUS            IoctlRetStatus;   /* Set by Ioctl handlers to return   */
                                        /* Ioctl statuses.                   */
  int                 LinkMaxFrameSize; /* as set by user in Set Link Charcts*/
                                        /* = max size allowed on this link   */

  PIR                pIR;               /* pointer to user interface record  */
  IR                  OurIR;            /* dummy IR for initialisation!      */
// /*IRMdl?*/   PMDL pIRMdl;            /* the IR that maps the interface rec*/
                                        /* This is set up when the user calls*/
                                        /* IoctlSetInterfaceRecord and relea-*/
                                        /* sed when IoctlClose               */
  CONFIGDATA          ConfigData;       /* copied from static configdata at  */
                                        /* start of day                      */
#define ADAPTERBASE ConfigData.AdapterBaseAddress
  int                 DPCAction;        /* Set by interrupt routines to reqst*/
                                        /* actions by DPC routine.  If this  */
                                        /* is non-0, the exit from the       */
                                        /* interrupt routine requests a DPC. */
                                        /* The DPC routine resets it.        */
#define DPC_ACTION_PULSE    1

  PKINTERRUPT         Interrupt;        /* standard interrupt (#1)           */
  PKINTERRUPT         Interrupt2;       /* alternate interrupt (#2)          */

  // send buffer stuff

  UCHAR            * pSendBuf;
#define               SENDBUF_SIZE 3000 /* as used by OS2 driver             */
                                        /* allows 2*1024 x.25 frames + some  */
  PMDL               pSendMdl;
  PHYSICAL_ADDRESS    SendBufPhysAddr;
  USHORT              TxConsecutiveUnderrunCount;
  int                 TxFSMCurState;
  USHORT              TxNextToBuffer;    /* index into pSendbuf.             */
  USHORT              TxNextToTransmit;  /* index into pSendbuf.             */
  UCHAR             *pTxPIOData;         /* pointer                          */
  UCHAR               TxResult;          /* only 1 Tx result byte from 8273  */
  USHORT              TxStartUnusedArea;

  /***************************************************************************/
  /* Ok - what the heck is TxStartUnusedArea? (I hear you cry).              */
  /*                                                                         */
  /* When we start putting stuff into the buffer, we can put and get right   */
  /* up to the end.  When the Put side wraps round, there will be some slop  */
  /* at the end - from the end of the last buffered tx frame to the real end */
  /* of the buffer.  This is then used by the Get side: we keep getting      */
  /* Tx Frames out of the buffer until the next one would be past the        */
  /* TxStartUnusedArea.  Once this occurs, we move the TxStartUnusedArea out */
  /* to the BUFFER_SIZE again - the Put side is now restricted by this rather*/
  /* than by TxNextToTransmit.                                               */
  /*                                                                         */
  /***************************************************************************/

  // receive buffer stuff

  RCVINFO             RcvInfo;          /* see rb.h for RCVINFO              */
  int                 RxFSMCurState;
  UCHAR             *pRxPIOData;
  short               RxResultCount;
  UCHAR               RxResultBuffer[8];/* RxResult bytes read from RxRes reg*/
  UCHAR               OurAddress1;      /* user's address values held here   */
  UCHAR               OurAddress2;

  UCHAR               LinkOptionsByte;  /* user's link options are held here */
                                        /* the bits in this byte have the    */
                                        /* same meaning as defined for the   */
                                        /* SLLinkOptionsByte in ui.h         */
  UCHAR               GrabbedResources;
  BOOLEAN             DMAIsActive;

  UCHAR               CmdStringReadPortA[2];
  UCHAR               CmdStringResetOpMode[3];
  UCHAR               CmdStringResetSerialIOMode[3];
  UCHAR               CmdStringSetOpMode[3];
  UCHAR               CmdStringSetSerialIOMode[3];
  UCHAR               CmdStringDataTransferMode[3];

  UCHAR               CmdStringResetPortB[3];
  UCHAR               CmdStringSetPortB[3];

  UCHAR               CmdStringReceive[6];
  UCHAR               CmdStringTransmit[6];
  UCHAR               CmdStringAbortTransmit[2];
  UCHAR               CmdStringDisableReceiver[2];

  UCHAR               LastPortA;        /* see GetV24Input/Write8273Cmd      */
  BOOLean             PowerFailed;
}
                      IBMSYNC_DEVICE_EXTENSION,
                     *PDX;              /* pDX normal name for extension ptr */

#define INIT_MAXFRSIZENOW  CAST((SENDBUF_SIZE-8) / 2, USHORT)
                                        /* -8 allows for record lengths/safty*/
