assume  cs:_TEXT

public	_cx_w
public	_cx_r

_TEXT	segment byte public 'CODE'


;**************************************************************************	
;       Function:	char cx_r (char index)
;
;       Purpose:        Reads Cyrix Configuration Register at index
;       Inputs:         byte index, Cyrix Configuration Register
;       Output:         al, Contents of Cyrix Configuration Register
;**************************************************************************
_cx_r	proc	near
	push	bp
	mov	bp,sp
	sub	sp,4
        pushf                           ; save flags
        cli                             ; clear interrupt in flags
	mov	al, byte ptr [bp+4]     ; get index
	out	22h, al                 ; tell CPU which config. register
	in	al, 23h                 ; write to CPU config. register
        popf                            ; restore flags
	mov	sp,bp
	pop	bp
	ret	
_cx_r	endp

;**************************************************************************	
;       Function:	char cx_w (char index, char val)
;
;       Purpose:        Write Cyrix Configuration Register at index with val
;       Inputs:         byte index, Cyrix Configuration Register
;                       byte val, value to be written to index
;       Output:         nothing
;**************************************************************************
_cx_w	proc	near
	push	bp
	mov	bp,sp
	sub	sp,4
        pushf                           ; save flags
        cli                             ; clear interrupt in flags
	mov	al, byte ptr [bp+4]     ; get index
        out	22h, al                 ; tell CPU which config. register
	mov	al, byte ptr [bp+6]     ; get val
	out	23h, al                 ; write to CPU config. register
        popf                            ; restore flags
	mov	sp,bp
	pop	bp
	ret	
_cx_w	endp
_TEXT	ends
	end
