                    IBM OEM STORAGE PRODUCTS

                         0632 Model C2x



The 5.25" 0632 Models C2x provide rewritable and removable optical
storage up to 1.19GB and 1.3GB cartridge.  Both 595MB and 650MB
cartridges are compatible with the drive.  The drive is particularly
suited to the demanding requirements of optical libraries.  The unique
calibration process optimizes the laser power used for read/write and
seek operations to provide enhanced performance across a wide range of
environments and media characteristics.


Applications
============

* Optical libraries/jukeboxes
* High end workstations
* Multimedia machine


Features                                   Benefits
========                                   ========

* 256KB read ahead buffer and cache.       * Improved read performance.
-----------------------------------------------------------------------
* Feature switches.                        * Allow attachment to various
                                             platforms.
-----------------------------------------------------------------------
* Supports 1.19GB, 1.3GB, 595MB and        * High capacity removable
  650MB cartridges (unformatted).            storage backwards.
                                             Compatible with existing
                                             5 1/4" cartridges.
-----------------------------------------------------------------------
* SCSI-2 interface                         * Industry standard inter-
  5MB/s burst data rate.                     face for ease of attach-
                                             ment.
-----------------------------------------------------------------------
* 3 seconds average cartridge load         * Fast load for use in
  to ready time.                             library applications.
-----------------------------------------------------------------------
* 2.5 second average ready to reload
  time.
-----------------------------------------------------------------------
* Microcode updatable via SCSI             * Field upgradable.
  (flash EPROM).
-----------------------------------------------------------------------
* Library external control interface.      * Synchronise library auto-
                                             changer and drive operations.
* Average seek (1) < 55ms for 1.3GB disk.  * Fast access to data.
  Average seek < 65ms for 650MB disk.
  Rotate speed 2400 rpm.
-----------------------------------------------------------------------
* 1.3/1.19GB disk, data rates.             * Improved media data rates
  512 byte/sector 735 to 1424 KB/s (2)       with 1.3GB cartridges.
  1024 byte/sector 806 to 1561 KB/s
-----------------------------------------------------------------------
* 650/595MB disk, data rates
  512 byte/sector 620 KB/s
  1024 byte/sector 680 KB/s
-----------------------------------------------------------------------
* MTBF 750,000 cycles for library drive.   * Exceptional loader
                                             reliability.
-----------------------------------------------------------------------
* MTBF up to 180,000 hours for             * Excellent reliability
  workstation drive.                         performance.
  MTBF up to 100,000 hours for library
  drive.
-----------------------------------------------------------------------
Drives compatible with ECMA-184 (1.3GB) and ISO/IEC 10089:1991
(Format A).  Users should verify usability of non-IBM brand
rewritable optical media prior to use.
Note 1: Actual move time, not including SCSI command overhead.
Note 2: 1KB is 1024 bytes.


Connectors and Switch Settings
==============================

The diagram below shows the location of the various switches and
connectors they include:

The switches are mounted on the electronic board behind the drive.


      J6                 J7                          J2      J3  J4  J5
      |                  |                           |       |   |   |
|||||Ŀ
|Ŀ _|_____ |||Ĵ
o o o o o o o o o o o o o o o o o o o o o o o o o/ |     \:::Ĵ###
o o o o o o o o o o o o o o o o o o o o o o o o o O O O O Ĵ###
|\/       Ĵ
Pin #1Ŀ      
      _   _   _   _   _   _   _   _   _   _   _   _      Ŀ
          / \ / \ / \ / \ / \ / \ / \ / \ / \ / \ / \ / \          
                                           
                                           
                                           
                                           
 @        \_/ \_/ \_/ \_/ \_/ \_/ \_/ \_/ \_/ \_/ \_/ \_/        @ 
ٳ
                                                           Ŀ
                                                                     
                                                                     
                                                                     
                                                                     
Ŀ                                                           ٳ


 J1  SCSI connector
 J2  Power connector
 J3  Library interface connector
 J4  Option switches 1. Spindle spin-up switch
                     2. Permit eject switch
 J5  SCSI address switch or address connector (Pin Type)
 J6  Feature switches

For details of SCSI interface and power connections, see electrical
interface section.


Option and Address Settings
===========================

     Option   Option
     Switch 2 Switch 1                               Pin #3
            | |                                      |    /SCSI Address
  ...||Ŀ                   ...|Ŀ/ Connector
       Ĵ                        Ĵ
       :::Ĵ/|\---SCSI                 :::Ĵ###---Pin #1
       Ĵ\ /   Address              Ĵ###---Pin #6
       ...Ŀ  Ĵ   Switch               ...Ŀ  Ĵ
            Ŀ                             Ŀ
              .   ..                               .   ..
              :   ::                               :   ::
  Figure 1 Option Switches and SCSI Address

Note:
-----
As viewed from the back of the drive, a switch is on when it is pushed
up and off when it is pushed down.

Spindle Spin-up Switch
----------------------
The setting of switch 1 determines whether the spindle motor is turned
on automatically at power up when a cartridge is in the loaded position
(see Figure 1).

Spindle Spin-up switch 1:
-------------------------

  Setting     Description                     Default
  -------     -----------                     -------
    Off       Spin automatically on power-      Off
              up or cartridge insert.
    On        No spin-up on power-up but
              spin-up on cartridge insert.


Permit Eject Switch
-------------------

The setting of switch 2 determines whether an eject request received
over the SCSI interface is honoured.  Eject request received over the
library interface, or by pressing the UNLOAD button, are honoured
regardless of the setting of switch 2 (see Figure 1).

Permit Eject switch 2:
----------------------

  Setting     Description                     Default
  -------     -----------                     -------
    Off       Inhibit SCSI eject request        On
    On        Permit SCSI eject request


SCSI Address Switch
-------------------

The SCSI address of the drive is selected by using a 16-position rotary
switch.  The switch is read at power up and when the drive is reset.

The drive's SCSI address (between 0 and 7) is selected by rotating the
switch to the desired location on the switch.  Addresses 8 to 15 are
reserved and should not be used.


SCSI Address Rotary Switch Setting
----------------------------------

  Setting     Description                     Default
  -------     -----------                     -------
     0        Address 0 on SCSI bus
     1        Address 1 on SCSI bus  =        Selected
     2        Address 2 on SCSI bus
     3        Address 3 on SCSI bus
     4        Address 4 on SCSI bus
     5        Address 5 on SCSI bus
     6        Address 6 on SCSI bus
     7        Address 7 on SCSI bus
    8-15      Reserved


SCSI Address Connector Pin Definitions
--------------------------------------

 Pin Number   Name                       Type
 ----------   ----                       ----
     1        Bit 0                      Input
     2        Ground                     Output
     3        Bit 2                      Input
     4        Bit 1                      Input
     5        Reserved (open)            Input
     6        Polarization key            n/a

Mating connector is BERG P/N 65051-034


Library Interface Connector
===========================

The library interface enables direct communications between a library
autochanger and the drive subassembly:
1. The autochanger controller can cause the drive to spin-down and/or
   unload a cartridge.
2. The drive can report a busy condition to the autochanger controller.
3. The drive can report when a cartridge is ready to be picked up at
   the drive cartridge entry/exit slot.
4. The autochanger controller can sense if a drive is present.

The library interface uses a pin connector on the logic board for
attachment to the (library) interface cable.  This cable connects
between the drive controller and the autochanger controller card.
The pin assignments are shown in Figure 2.

    Pin 2 Pin 4 Pin 6
         \  |  /
          \ | /
           |||
     ...|||Ŀ
          Ĵ
          :::Ĵ###
          Ĵ###
        ...|||Ŀ  Ĵ
           ||| Ŀ
          / | \  .   ..
         /  |  \ :   ::
    Pin 1 Pin 3 Pin 5

    Figure 2 Library Interface Connector J3


Library Interface Connector Pin Definitions
-------------------------------------------

    Pin       Signal Name                Signal Type
    ---       -----------                -----------
     1        Drive status (Busy)        Output
     2        Ground
     3        Eject                      Input
     4        Spin-Down                  Input
     5        Drive present (ground)     Output
     6        Ground

Mating connector is BERG P/N 69176-006


Electrical Interface Specifications
===================================

The IBM OEM 0632 Optical Disk Drive uses single-ended drivers and
receivers that permit cable lengths of up to 6 meters (19.68 feet).

Connectors
----------
The drive has two connectors: one for power, the other for connecting
to the SCSI bus.

Power
-----
The DC power connector is designed to mate with AMP part number
1-480424-0 using AMP pins part number 350078-4 or their equivalent.
Pin assignments are shown in Figure 3.


    Pin # 4 3 2 1
       Ŀ
       /\
        O O O O 
       ٳ
       
      +5V GND GND +12V

    Figure 3 Power Connector Pin Assignments




  SCSI Signal Connector
  ---------------------
The SCSI signal connector is a 50-pin connector, Molex part number
70248 or equivalent, which meets ANSI/SCSI specifications.

SCSI Bus Terminators
--------------------
Active termination for the last device on the SCSI cable is accomplished
by setting Feature Switch 5 to the OFF Position (see below).

For a single-ended cable, a 50-conductor flat cable or a 25 twisted
pair cable can be used, with a maximum length of 6.0 meters and a stub
length not to exceed 0.1 meters.

The drive has an internal stub length of 0.077 meters.  The SCSI bus
cable must not add more than 0.023 meters additional stub length to
remain compliant with ANSI.


Feature Switches
================

Location of the Feature Switches on the drive.

     .
     :.
     :
     
     ...
     ...
      Feature Switches
       Ŀ
       Ŀ6
       Ĵ5
       Ĵ4
       Ĵ3
       Ĵ2
       Ĵ1
       ٳ
       
       ON    OFF
     ...
             |
             |
            |                 Front
           |                  /|\                      
           |                   |                      
     Ŀ  |                                      Ĵ
      @   |                                       @ 
       |              Top of Drive            Ĵ
           |                                          
           |                                          
     \|/Ŀ                       
       Ŀ           Ŀ                       
                 =#=                            
                  ٳ
     
                               Rear


   Switch       Setting     Description                     Default
   ------       -------     -----------                     -------
     1            Off       Enable Unit Attention on          Off
                            POR/SCSI Reset
                  On        Feature Switch 2 OFF:
                            Disable Unit Attention on
                            POR/SCSI Reset for Apple**-attach.
                            Feature Switch 2 ON:
                            Support Mode Sense/Select
                            pages for DEC**-attach.

     2            Off       Peripheral device type in         Off
                            Inquiry data is 07h
                            optical memory device
                  On        Peripheral device type in
                            Inquiry data is 00h
                            direct access device

     3            Off       Reserved                          Off
                  On        Reserved

     4            Off       Reserved                          Off
                  On        Reserved

     5            Off       Enable SCSI termination           Off
                  On        Disable SCSI termination

     6            Off       Reserved                          On
                  On        Reserved



DC Power Requirement Limits
===========================

Power supplied to the drive must conform to the following limits:

  +12 Volt Supply
    +/-0.6 Volts
   +5 Volt Supply
    +/-0.25 Volts

Power supply ripple
-------------------
 Voltage       Maximum               Notes
 -----------------------------------------
  +5VDC        100mV peak-to peak    0-20 MHz
 +12VDC        100mV peak-to peak    0-20 MHz

Power supply current
--------------------
               Typical               Maximum
 -------------------------------------------
  +5VDC        2.3 Amps              2.7 Amps
 +12VDC        1.6 Amps              2.2 Amps

Note: The maximum power consumption is 40 watts (average 33 watts).


Command Select Options
======================

The following Commands are supported by the drive:

Group 0 Commands                       (HEX)
----------------                       -----
  Test Unit Ready                       (00)
  Re-Zero Unit                          (01)
  Request Sense                         (03)
  Format Unit                           (04)
  Reassign Blocks                       (07)
  Read                                  (08)
  Write                                 (0A)
  Seek                                  (0B)
  Inquiry                               (12)
  Mode Select                           (15)
  Reserve                               (16)
  Release                               (17)
  Mode Sense                            (1A)
  Start/Stop Unit                       (1B)
  Send Diagnostics                      (1D)
  Prevent/Allow Media Removal           (1E)

Group 1 Commands
----------------
  Read Capacity                         (25)
  Read Extended                         (28)
  Write Extended                        (2A)
  Seek Extended                         (2B)
  Erase                                 (2C)
  Write Verify                          (2E)
  Verify                                (2F)
  Read Defect Data                      (37)
  Medium Scan (not supported)           (38)
  Write Buffer                          (3B)
  Read Buffer                           (3C)
  Read Data Long                        (3E)
  Write Data Long                       (3F)

Group 5 Commands
----------------
  Read Extended                         (A8)
  Write Extended                        (AA)
  Erase Extended                        (AC)
  Write Verify Extended                 (AE)
  Verify Extended                       (AF)

Group 6 Commands
----------------
  Reserved                         (CO-C6, DO & D1)
  Manufacturers                         (D2)


Mechanical Data
===============

Dimensions           (without bezel)
----------           ---------------
Height                    82.5mm
Width                    146mm
Depth                    205.5mm
Weight                     2.5kg

Dimensions of Bezel
-------------------
Height                    85.8mm
Width                    149.3mm
Thickness                  4.8mm


Mounting Orientation
--------------------
Either vertical (left or right side down) when viewed from the front
of the drive or horizontal.  Upside down or on end is not permitted,
tilt of drive in operation mode should not exceed +/-10 degrees from
horizontal or vertical.

   1.5mm
           ----------------- 205.5mm ----------------------
         Ŀ
        ڴ Ŀ    
                      Ŀ            ÿ      .
           /                                               .
          -                                                 .
             SIDE VIEW                                     82.5
                                                          .
                     o       o (4x) M3x0.5           .
                   Ŀ             Ŀ                21.8mm .
            
          47.5+/-0.5--79.2 +/-0.5mm--
    4.8mm 



            47.5+/-0.5--79.2 +/-0.5mm--
         Ŀ
          Ŀ 
        ڴ           o                 o                   .
             .  .
                                                           .  .
                                                           |  .
                                                          139.7+/-0.5
                                                            |  .
                                                            .  .
                                                            .  .
                      BOTTOM VIEW                           .  .
                                                            .  .
                                                            .  .
                                                            .  .
                                                            .  |
                                                            .  146mm
                                                            .  |
           Ŀ   .  .
                   o                   o                  .
           
         

Note: Maximum screw lengths must not be exceeded.  All screws, M3
      thread maximum length 8mm!


Operating Environment
=====================

The drive operates within it's performance limits when the following
environment is maintained.  Product life calculations are based on
the nominal environment for a typical application.

Humidity:
---------
Operating                  8% to 80% non-condensing
Storage                    5% to 80% non-condensing
Shipping                   5% to 99% (applies at a packaged level)

Wet Bulb Temperature:
---------------------
Operating                  81 degrees F (27 degrees C) maximum
Shipping/Storage           84 degrees F (29 degrees C) maximum

Elevation:
----------
Operating                  0 to 6932 feet
                          (0 to 2133 meters)

Temperature:
------------
Operating ambient          50 to 104 degrees F (10 to 40 degrees C)
Shipping                  -40 to 140 degrees F (-40 to 60 degrees C)
Storage                    32 to 140 degrees F (1 to 60 degrees C)

Air flow requirement:
---------------------
The host system must provide at least 0.06 cubic meters per minute
(+0.03 - 0.01) at standard temperature and pressure.  Recommended
airflow direction is from rear to front of the drive.


Rewritable Data Organization
============================

Optical Disk Format for 1.19/1.3GB Disk
---------------------------------------

Format architecture            Fixed block
Sector size (bytes)            512 or 1024
Capacity per surface
  512-byte sector size         595,628,544 (formatted)
(596MB per side)               596,691,968 (unformatted)
  1024-byte sector size        652,329,984 (formatted)
(650MB per side)               654,436,352 (unformatted)
Bit density                    29,540 data bits per inch
Track Density                  18,273 tracks per inch
Total tracks in the user zone  21,600 physical tracks
                               37,600 logical tracks
Maximum number of spare
  sectors per surface
   512-byte sector size        2077
  1024-byte sector size        2057
Number of manufacturer's       2
  areas
Number of sectors per track
   512-byte sector size        31
  1024-byte sector size        17


Optical Disk Format for 595/650MB Disk
---------------------------------------

Format architecture            Fixed block
Sector size (bytes)            512 or 1024
Capacity per surface
  512-byte sector size         296,472,064 (formatted)
(297MB per side)               297,520,640 (unformatted)
  1024-byte sector size        324,215,808 (formatted)
(325MB per side)               326,312,960 (unformatted)
Bit density (inner track)      24,900 data bits per inch
Track Density                  15,875 tracks per inch
Total tracks in the user zone  18,751
Maximum number of spare        2048
  sectors per surface
Number of manufacturer's       2
  areas
Number of sectors per track
   512-byte sector size        31
  1024-byte sector size        17


Optical Disk Characteristics
============================


                       Case Side A                     Location Hole
                            |                         /
         |/Ŀ Ŀ
         |Ŀ       /   \ 
Insertion     /|           A                      o     \ 
Direction...../ |--------  A_A                        o   \
             \ |-------- A   A                            \
              \|                                          \
         Ĵ                Gripper
                                                            Slot
                                                          
                                                          
         =                                                 
                           
             Ŀ           
                                                        
                    User Label Area                     
         =                                          o    
                                                o       
                 Ŀ 
          

  Figure 4 Description of Optical Disk Cartridge

The optical disk drive sub-assembly uses a removable double-sided disk
that is housed in a cartridge with access to the recording surface
through a shutter mechanism.  The disk is rewritable and can be
reformatted many times.

Rewritable Optical Disk Characteristics
---------------------------------------
The optical disk drives uses an IBM Rewritable Optical Disk with
characteristics shown below.

Disk diameter                  130mm (+/-0.3)
Center hole diameter           4.004mm (+0.008,-0.0)
Disk cartridge dimensions      135mm Width
                               153mm Length
                                11mm Height
Hub height                     2.20mm (+0.0/-0.1)
Hub diameter                   25.0mm (+0.0/-0.2)
Maximum weight                 120 grams
Disk material                  Plastic
Recording surfaces per disk    2
Tracktype                      Spiral
                            595/650MB      1.19/1.3GB
512 Byte media              P/N 49G7797    09G7339
1024 Byte media             P/N 94F9479    09G7344

IBM OEM 5 1/4" Rewritable Optical Cartridges have been specially
developed and tested for optimum performance when used with the IBM
OEM 5 1/4" Rewritable Optical Disk Drive.  These drives are compatible
with the following ISO standard.  130mm Rewritable Optical Disk
Cartridges for information interchange ISO/IE2 10089. 1991 (format A)
595/650MB and 1.19/1.3 GB ECMA-184.

The customer should verify the usability of non-IBM OEM brand rewritable
optical media prior to use.

Today ANSI and ISO standards for rewritable optical media are broad and
various.  Manufacturers have different implementations of these
standards; as a result data stored on one manufacturers drive may not
be interchangeable with another.


Vibration and Shock
===================

Operating Vibration
-------------------
The drive will withstand (with no permanent error) vibration levels of
0.25G RMS from 0 to 500 Hz.

Operating Shock
---------------
The drive will withstand (with no permanent error) shock levels of 5G,
11mS (half sine) duration.

Non-operating Shock
---------------
No damage occurs as long as the unpackaged drive is not subjected to
a square wave shock greater than a value of 35 Gs, 11mS (half sine)
duration.


Models
======

0632-C2A P/N45G0000        Drive without dampers used in Library
                           Applications.  Fast eject, Gray bezel,
                           SCSI address switch.

0632-C2B P/N45G0001        Drive with dampers used in Workstation
                           or external library Drive.  Slow eject,
                           Gray bezel, SCSI address switch.

0632-C2C P/N61G9240        Drive with dampers used in Workstations.
                           Slow eject, white bezel, connector for
                           SCSI address.

0632-C2D P/N61G9250        Drive without dampers used in Library
                           Applications.  Fast eject, white bezel,
                           connector for SCSI address.

0632-C2G P/N61G9241        Drive with dampers used in Workstation
                           applications.  Slow eject, white bezel,
                           SCSI address switch.


WARNING:
========
This disk drive can be damaged by Electro-Static Discharge; please follow
recommended ESD procedures before unpacking or handling the drive.  Ask
your IBM marketing representative for details if you need assistance.


PACKAGING:
==========
The drive must be protected against Electro-Static Discharge especially
when being handled.  The safest way to avoid damage is to put the drive
in an anti-static bag before ESD wrist straps etc, are removed.

Drives should only be shipped in approved containers; severe damage can
be caused to the drive if the packaging does not adequately protect
against the shock levels induced when a box is dropped.  Consult your
IBM marketing representative if you do not have an approved shipping
container.


IBM Adstar's development and manufacturing operations are ISO 9001
certified.


----------------------------------------------------------------------
This data sheet is not a substitute for the full product specification,
which should be used when detailed information is required.

Product Description data represents IBM's design objectives and is
provided for comparative purposes; actual results may vary based on a
variety of factors.  This product data does not constitute a warranty.
Questions regarding IBM's warranty terms or methodology used to derive
this data should be referred to your IBM OEM representative.  Data
subject to change without notice.

-----------------------------------------------------------------------
