
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                                                         *
 * Module Name : B&D.H                                                     *
 *                                                                         *
 * Description : This is the header file for the compatibility with        *
 *               Dialogic's functions and structures.  Please include      *
 *               this file in the application programs if you used         *
 *               Dialogic's functions and structures.                      *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * BICOM (R) B&D.H  Version 1.00                                           *
 * Copyright (c) BICOM 1990, 1991     All rights reserved.                 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * *
               DIALOGIC          BICOM
 * * * * * * * * * * * * * * * * * * * * * * * * * * * */

              
#define        byte              BYTE
#define        word              WORD
#define        dword             DWORD

#define        F_DEVSRV          F_XSRV

#define        MSDEVSFN          X_MINFCN
#define        FI_REGDRV         X_REGDRV
#define        FI_SIZEQ          X_SIZEQ 
#define        FI_OPENQ          X_OPENQ 
#define        FI_PUTQ           X_PUTQ  
#define        FI_GETQ           X_GETQ  
#define        FI_EMPTYQ         X_EMPTYQ
#define        FI_FLUSHQ         X_FLUSHQ
#define        FI_SCANQ          X_SCANQ 
#define        FI_GETLVL         X_GETLVL
#define        FI_PUTLVL         X_PUTLVL
#define        FI_INSINT         X_INSINT
#define        FI_UININT         X_UININT
#define        FI_GETIV          X_GETIV 
#define        FI_PUTIV          X_PUTIV 
#define        FI_GETMSG         X_GETMSG
#define        FI_PUTMSG         X_PUTMSG
#define        FI_PUT55          X_PUT55 
#define        FI_DIS55          X_DIS55 
#define        FI_ISDRV          X_ISDRV 
#define        FI_SCHED          X_SCHED 
#define        FI_PAUSE          X_PAUSE 
#define        FI_UREG           X_UREG  
#define        FI_USREVT         X_USREVT
#define        FI_BEEP           X_BEEP  
#define        MXDEVSFN          X_MAXFCN

#define        S_STOP            M_IDLE
#define        S_RECORD          M_RECORD
#define        S_PLAY            M_PLAY
#define        S_GETDTS          M_GETDTMF
#define        S_OFFH            M_OFFHOOK
#define        S_DIAL            M_DIAL
#define        S_ONH             M_ONHOOK
#define        S_CALL            M_CALL
#define        S_PARM            M_DEFUPD
#define        S_WINK            M_WINK

#define        E_SUCC            E_OK
#define        E_FAILST          E_SELF_TEST
#define        E_NODT            E_NO_DTMF
#define        E_SACT            E_SYS_ACT
#define        E_SNACT           E_SYS_INACT
#define        E_BADDL           E_BOARD
#define        E_BADFCN          E_INV_CMD
#define        E_BADINT          E_INV_INT
#define        E_BADDCB          E_INV_SCB
#define        E_BADCH           E_INV_CHAN
#define        E_MTACT           E_TASK_ACT
#define        E_MTNACT          E_TASK_INACT
#define        E_BADPAR          E_INV_DATA
#define        E_BADVER          E_INV_VER
#define        E_NOTIMP          E_NOT_IMP
#define        E_NOTERM          E_NO_TERM
#define        E_NOMEM           E_NO_MEM
#define        E_DOSERR          E_DOS_ERR
#define        E_DSKCNT          E_DISK
#define        E_BADCUR          E_INV_VOX
#define        E_EMSSW           E_NO_EMS
#define        E_EMSERR          E_EMS_ERR
#define        E_NOVBUF          E_NO_BUF

#define        CA_BUSY           CP_BUSY 
#define        CA_NOAN           CP_NO_ANSR
#define        CA_NORNG          CP_NO_RESP
#define        CA_CONN           CP_CONNECT
#define        CA_OPINT          CP_INTERCEPT

#define        LS_CARNG          LS_RNGBCK
#define        LS_TT             LS_DTMF
#define        LS_SIL            LS_SILENCE

#define        RW_DINIT          IB_INIT
#define        RW_TONE           IB_TONE
#define        RW_DELAY          IB_DELY

#define        PM_NORM           PB_NORM
#define        PM_NDX            PB_IDX
#define        PM_FILES          PB_FILE

#define        RM_NORM           RD_NORM
#define        RM_SCOMP          RD_SILCOMP

#define        DM_D              Dtmf_D
#define        DM_1              Dtmf_1
#define        DM_2              Dtmf_2
#define        DM_3              Dtmf_3
#define        DM_4              Dtmf_4
#define        DM_5              Dtmf_5
#define        DM_6              Dtmf_6
#define        DM_7              Dtmf_7
#define        DM_8              Dtmf_8
#define        DM_9              Dtmf_9
#define        DM_0              Dtmf_0
#define        DM_S              Dtmf_S
#define        DM_P              Dtmf_P
#define        DM_A              Dtmf_A
#define        DM_B              Dtmf_B
#define        DM_C              Dtmf_C
                                   
#define        DV_USER1          U_DEV1 
#define        DV_USER2          U_DEV2 
#define        DV_USER3          U_DEV3 
#define        DV_USER4          U_DEV4 
#define        DV_USER5          U_DEV5 
#define        DV_USER6          U_DEV6 
#define        DV_USER7          U_DEV7 
#define        DV_USERF          U_DEVF 
#define        DV_USER9          U_DEV9 
#define        DV_USER10         U_DEV10
#define        DV_USER11         U_DEV11
#define        DV_USER12         U_DEV12
#define        DV_USER13         U_DEV13
#define        DV_USER14         U_DEV14
#define        DV_USER15         U_DEV15
#define        DV_USER16         U_DEV16
                                 
#define        EI_SUCC           D_SUCC  
#define        EI_REGERR         D_REGERR
#define        EI_BADHND         D_INVHND
#define        EI_BADDEV         D_INVDEV
#define        EI_MAXQS          D_MAXQS 
#define        EI_BADQT          D_INVQT 
#define        EI_QFULL          D_QFULL 
#define        EI_QMPTY          D_QEMPTY 
#define        EI_BADFCN         D_INVFCN
#define        EI_BADPAR         D_INVPAR
#define        EI_VECUSD         D_VECUSD
#define        EI_NOIMP          D_NOTIMP 

#define        DCB               SCB
#define        DCB_SIZE          SCB_SIZE
#define          flashchr          FlashChar
#define          flashtm           FlashDuration
#define          pausetm           PauseTime
#define          digrate           ScbRsv10
#define          sch_tm            ScbRsv11
#define          p_bk              PulseBreak
#define          p_mk              PulseMake
#define          p_idd             PulseDelay
#define          t_idd             ToneDelay
#define          oh_dly            HookDelay
#define          r_on              RingOn
#define          r_off             RingOff
#define          r_ird             RingEvtDelay
#define          s_bnc             ScbRsv1
#define          dcbrfu1           ScbRsv2
#define          ttdata            ToneLength
#define          minpdon           ScbRsv3
#define          minpdoff          ScbRsv4
#define          minipd            ScbRsv5 
#define          minlcoff          LoopDropTime 
#define          dcbrfu2           ScbRsv6 
#define          dcbrfu3           ScbRsv7            
#define          maxpdoff          ScbRsv8        
#define          dcbrfu            ScbRsv9 

#define        RWB               TCB
#define        RWB_SIZE          TCB_SIZE
#define          filehndl          FileHandle 
#define          xferoff           BufferOff
#define          xferseg           BufferSeg
#define          maxbyteh          XferSizeH  
#define          maxbyte           XferSizeL    
#define          maxsec            TimeOut
#define          maxdtmf           DTMF_Max
#define          termdtmf          DTMF_Term
#define          maxsil            SilenceCnt
#define          loopsig           LoopDrop
#define          indexoff          IndxTblOff
#define          indexseg          IndxTblSeg    
#define          rwbflags          Flag
#define          rwbdata1          ToneData
#define          amxterm           RwbRsv1
#define          curpos            VoxOffsetL
#define          curposh           VoxOffsetH    
#define          isxrwb            SetExtended
#define          rwbrfu            RwbRsv2
#define          xrwbrfu1          RwbRsv3
#define          dtinit            PreDTMF
#define          dtterm            PostDTMF
#define          intrdig           InterDigTime
#define          maxnsil           MaxDialTone
#define          xrwbrfu           RwbRsv4

#define        CPB               CPB
#define        CPB_SIZE          CPB_SIZE
#define          dtpl_dly          DTMFDuration
#define          dt_edge           DTMFEdge
#define          dtrc_dly          CdbRsv1
#define          sb_siz            SilenceRemDly
#define          nbrdna            NoAnswer
#define          stdely            CPDelay
#define          cnosig            AnsTimeout
#define          lcdly             LoopConn
#define          lcdly1            LoopWait
#define          hedge             VoxAnswer
#define          cnosil            HangUpTime
#define          lo1tola           CdbRsv2
#define          lo1tolb           CdbRsv3
#define          lo2tola           CdbRsv4
#define          lo2tolb           CdbRsv5
#define          hi1tola           CdbRsv6
#define          hi1tolb           CdbRsv7
#define          lo1bmax           CdbRsv8
#define          lo2bmax           CdbRsv9
#define          hi1bmax           CdbRsv10
#define          nsbusy            CdbRsv11
#define          logltch           CdbRsv12
#define          higltch           CdbRsv13
#define          lo1rmax           CdbRsv14
#define          lo2rmin           CdbRsv15
#define          intflg            CdbRsv16
#define          intfltr           CdbRsv17
#define          cpbrfu1           CdbRsv18
#define          spdeb             CdbRsv19
#define          hisiz             CdbRsv20
#define          alowmax           CdbRsv21
#define          blowmax           CdbRsv22
#define          nbrbeg            CdbRsv23
#define          hi1ceil           CdbRsv24
#define          lo1ceil           CdbRsv25
#define          lowerfrq          CdbRsv26
#define          upperfrq          CdbRsv27
#define          timefrq           CdbRsv28
#define          rejctfrq          CdbRsv29
#define          maxansr           MaxAnswer
#define          ansrdgl           AnsrFilter
#define          cpbrfu            CdbRsv30

#define          cstmask           EGMask
#define          status            ChanMode
#define          cherr             Error 
#define          mtfcn             Function 
#define          lastterm          TermEvent 
#define          bufcnth           BufCntH 
#define          bufcnt            BufCntL 
#define          dtmfrcvd          DTMF_Cnt 
#define          doserr            DOS_Error 
#define          linestat          LineStatus 
#define          callstat          CallStatus 
#define          intrfreq          CsbRsv2
#define          dig_mask          DTMFFlag 
#define          csbrfu            CsbRsv1 

#define        EVTBLK            EB
#define          devtype           DeviceType
#define          evtcode           EventCode
#define          evtdata           EventData
#define          devchan           Chan
#define          mempntr           pData
#define          board             Board
#define          rfu               EdbRsv1

#define          termtype          TermType
#define          frqout            CarRsv1
#define          frqherz           CarRsv2  
#define          sizehigh          CarRsv3  
#define          shortlow          CarRsv4  
#define          longlow           CarRsv5  
#define          ansrsize          AnswerSize  
#define          carrfu            CarRsv6  

              
#define        int_level         BCM_SoftwareInt
#define        calld40           BcmDrvCall
#define        calld40x          BcmDrvCallP
#define        d4getoff          FindOffset
#define        d4getseg          FindSegment

              
#define        dosopen           DosOpenFile
#define        dosclose          DosCloseFile
#define        dosseek           DosMoveFilePtr
#define        doscrea           DosCreateFile


#define        _d40act           BCM_SystemStatus
#define        _d40derr          BCM_DosError
#define        ralp              pRegAL
#define        ral                RegAL
#define        rah                RegAH
#define        rbxp              pRegBX
#define        rbx                RegBX
#define        rcxp              pRegCX
#define        rcx                RegCX
#define        rdxp              pRegDX
#define        rdx                RegDX
#define        rds                RegDS   
#define        rc                ReturnCode

                              
#define        startsys          Bcm1_StartSystem         
#define        stopsys           Bcm3_StopSystem
#define        stopch            Bcm4_StopChannel
#define        getcstat          Bcm5_GetChanStatus
#define        sethook           Bcm6_SetHook
#define        setcst            Bcm7_SetEGMask
#define        clrdtmf           Bcm8_ClearDTMFQ  
#define        readdtmf          Bcm9_GetDTMFDigit
#define        recfile           Bcm12_RecordFile
#define        playfile          Bcm13_PlayFile
#define        dial              Bcm14_DialOut
#define        getdtmfs          Bcm15_GetDTMFString
#define        getevt            Bcm16_GetEvent
#define        sched             Bcm18_Scheduler
#define        xplayf            Bcm19_PlayIndexedFile   
#define        getcar            Bcm27_GetCAResults
#define        setxparm          Bcm28_SetSystemParams
#define        setcparm          Bcm29_SetChanParams
#define        callp             Bcm30_CallProgress
#define        setdmask          Bcm31_SetDTMFControl
#define        getver            Bcm32_GetDrvVersion
   
#define        gtevtblk          Bcm70_GetEventBlock
#define        putevt            Bcm70_PutEventInQ
#define        clrrwb            Bcm_ClearTCB
#define        clrdcb            Bcm_ClearSCB
#define        clrcpb            Bcm_ClearCPB
#define        isdrvact          Bcm_DrvInstalled
#define        vhopen            Bcm_OpenFile
#define        vhclose           Bcm_CloseFile
#define        vhseek            Bcm_MoveFilePtr
#define        d4xerr            Bcm_ShowErrorMsg
#define        getvctr           Bcm_GetSWIntVector   



/* Compatable with previous Dialogoc versions. */
 
#define Sys_Start                Bcm1_StartSystem
#define Sys_Stop                 Bcm3_StopSystem
#define Chn_Stop                 Bcm4_StopChannel
#define Chn_Status(C,O,S)        Bcm5_GetChanStatus(C,O)
#define Sethook                  Bcm6_SetHook
#define Set_CST_Mask             Bcm7_SetEGMask
#define Clear_DTMF               Bcm8_ClearDTMFQ
#define Read_DTMF                Bcm9_GetDTMFDigit
#define Record_File(C,O,S,M)     Bcm12_RecordFile(C,O,M)
#define Play_File(C,O,S)         Bcm13_PlayFile(C,O)
#define Dial                     Bcm14_DialOut
#define Get_DTMF_String(C,O,S)   Bcm15_GetDTMFString(C,O)
#define vopen(S,O,M)             Bcm_OpenFile(O,M)
#define vclose                   Bcm_CloseFile

                                                                     
