	name	'CPNETDIO'
	title	'Direct CP/NET Calls From PL/I-80'
;
;***********************************************************
;*							   *
;*	CP/NE calls from pl/i for direct i/o		   *
;*							   *
;*	   This interface is re-entrant.                   *
;*							   *
;***********************************************************
	public	login	;login (#64)
	public	logoff	;logoff (#65)
	public	sndmsg	;send message on network (#66)
	public	rcvmsg	;receive message from network (#67)
	public	netsts	;network status (#68)
	public	cfgtbl	;configuration table address (#69)
;
;
	extrn	?bdos
;
;***********************************************************
;*							   *
;*	equates for interface to cp/net xdos		   *
;*							   *
;***********************************************************
loginf	equ	64	;login
logofff	equ	65	;logoff
sndmsgf	equ	66	;send message on network
rcvmsgf	equ	67	;receive message from network
netstsf	equ	68	;network status
cfgtblf	equ	69	;configuration table address
;
;	utility functions
;***********************************************************
;*							   *
;*	general purpose routines used upon entry	   *
;*							   *
;***********************************************************
getp1i:
	call	getp1
	jmp	?bdos		;return through bdos

getp1:	;get single byte parameter to register e
	mov	e,m		;low (addr)
	inx	h
	mov	d,m		;high (addr)
	xchg			;hl = .char
	mov	e,m		;to register e
	ret
;
getp2:	;get single word parameter to DE
getp2i:	;(equivalent to getp2)
	call 	getp1
	inx	h
	mov	d,m		;get high byte as well
	jmp	?bdos		;return through bdos
;
getp3i:	;get single word parameter to DE
	;perform bdos call and then compliment result
	call	getp2i
	cma
	ret
;
;***********************************************************
;*							   *
;***********************************************************
login:	;login (#64)
	;1->addr(loginmsg)
	mvi	c,loginf	;login function
	jmp	getp3i		;DE = .loginmsg
				;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
logoff:	;logoff (#64)
	mvi	c,logofff	;logoff function
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
sndmsg:	;send message to network (#66)
	;1->addr(msg)
	mvi	c,sndmsgf	;send message function
	jmp	getp3i		;DE = .msg
				;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
rcvmsg:	;receive message from network (#67)
	;1->addr(msg)
	mvi	c,rcvmsgf	;receive message function
	jmp	getp3i		;DE = .msg
				;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
netsts:	;get network status (#68)
	mvi	c,netstsf	;get network status function
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
cfgtbl:	;return configuration table address (#69)
	mvi	c,cfgtblf	;get cfg tbl adr function
	jmp	?bdos		;return through bdos
;
;***********************************************************
;*							   *
;***********************************************************
	end
