/* FUNCTION list 	---	---	---	---	---	---	---

*/

/* BASE headers	---	---	---	---	---	---	--- */
#include "types.h"

/* LIBRARY headers	---	---	---	---	---	---	--- */
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>

/* OTHER headers	---	---	---	---	---	---	--- */
#include "param.h"

/* PROTOTYPES	---	---	---	---	---	---	--- */
//void test_function(void);



/* VARIABLES	---	---	---	---	---	---	--- */


/* CODE	---	---	---	---	---	---	---	--- */


// TODO




#define S_NOID  0
#define S_GOTID 1

int id_check(u8 *id, PARAM *pa)
{
	assert(id != NULL);
	assert(pa != NULL);
	
	if (pa->id != 0)	// check id
		if (id[1] != 0)	// make sure it's got at least one char
			if (id[2] == 0)	// but only one char
				if (tolower(pa->id) == tolower(id[1]))
					return 1;
	
	if (pa->id_full != 0) // and full id
		if (!strcasecmp(pa->id_full, id + 1))
			return 1;
			
	return 0;
}


// return 0 if uneventful
// return -1 for bad parameters 'n stuff
int param_parse(int argc, char **argv, int pa_len, PARAM *pa)
{
	int i, j;
	int state;
	PARAM *pa_cur=0;
	
	assert(argv);
	assert(pa);
	assert(pa_len > 0);
	assert(argc > 0);
	
	// go through param list and zero data's and set flags to -1
	for (i=0; i<pa_len; i++)
	{
		if (pa[i].state != P_SET)
		{
			pa[i].data = 0;
			pa[i].flag = -1;
		}
	}
	
	state = S_NOID;
	
	for (i=1; i<argc; i++)
	{
		switch (state)
		{
			case S_NOID:
				if (argv[i][0] == '-')
				{
					// compare the current argument with all the known ids
					pa_cur = 0;
					for (j=0; j<pa_len; j++)
						// check if id == 0 too...
						if (id_check(argv[i], &pa[j]) )
						{
							pa_cur = &pa[j];
							break;
						}
				}
				else
				{
					// check for any params that don't have id's set
					// this is a default param
					pa_cur = 0;
					for (j=0; j<pa_len; j++)
						if ( (pa[j].id == 0) 
							&& (pa[j].id_full == 0) )
						{
							pa_cur = &pa[j];
							break;
						}
				}
	
				if (pa_cur == 0)
				{
					printf("%s(): invalid option \"%s\".\n", 
						__PRETTY_FUNCTION__, argv[i]);
					return -1;	// error
				}
				
				// ok, we've found a parmeter that matches the list
				
				switch (pa_cur->state)
				{
					case P_SET:
						printf("%s(): duplicate option \"%s\".\n", 
							__PRETTY_FUNCTION__, argv[i]);
						return -1;	// error
						break;
					
					case P_FLAG:
						pa_cur->flag = 1;
						pa_cur->state = P_SET;
						// all done.. don't need to set string
						break;
					
					case P_DATA:
						state = S_GOTID;
						// it needs data.. we'll skip around to next line and get it
						break;
				}
			
				// if it's not a default, needing data, then break. and read the next word
				if ( (state != S_GOTID)
					|| (pa_cur->id != 0) 
					|| (pa_cur->id_full != 0) )
					break;
				
			case S_GOTID:
				assert(pa_cur != 0);
				pa_cur->data = argv[i];
				pa_cur->state = P_SET;
				pa_cur = 0;
				state = S_NOID;
				break;
		}
	}
		
	if (state == S_GOTID)
	{
		printf("%s(): dangling option \"%s\" with no data.\n", 
			__PRETTY_FUNCTION__, argv[i]);
		return -1;	// error
	}
	
	return 0;
}





