/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * CSoundDisplay is responsible for painting the main display area. For speed,
 * it maintains an internal, pre-drawn bitmap, and blits this onto the DC
 * during OnPaint. Thus, whenever the attached SoundResource gets modified,
 * the display object's PaintBuffer() method should be called instead of
 * RedrawWindow(). PaintBuffer() will automatically redraw the entire display
 * area.
 */

class SoundResource;


// CSoundDisplay

class CSoundDisplay : public CWnd
{
	DECLARE_DYNAMIC(CSoundDisplay)

public:
	CSoundDisplay();
	virtual ~CSoundDisplay();
	bool GetShowNoteOns();
	void SetShowNoteOns(bool val);
	bool GetShowVoiceControls();
	void SetShowVoiceControls(bool val);
	bool GetShowLoopPoint();
	void SetShowLoopPoint(bool val);
	bool GetShowCues();
	void SetShowCues(bool val);
	bool GetShowTimeRules();
	void SetShowTimeRules(bool val);
	void SetSound(SoundResource *sound);
	void SetFilter(int filter);
	void SetPlayPosition(int position);

	void PaintBuffer();

protected:
	DECLARE_MESSAGE_MAP()
	bool mShowNoteOns;
	bool mShowVoiceControls;
	bool mShowLoopPoint;
	bool mShowCues;
	bool mShowTimeRules;
	int mFilter;
	int mPlayPosition;
	SoundResource *mSound;

	CDC mMemDc;
	CBitmap mMemBmp;
	CFont *mChannelNumbersFont;
	CFont mTimeRuleFont;
	CPen mTimeRulePen;
	CPen mDirectCuePen;
	CPen mCumulativeCuePen;
	CPen mLoopPointPen;
	CPen mPlayPositionPen;
	CPen mNoteOnLitPen;
	CPen mNoteOnDarkPen;
	CPen mVoiceControlLitPen;
	CPen mVoiceControlDarkPen;

	// paramaters used to paint the actual display
	int mWidth;                   // total client area width
	int mHeight;                  // total client area height
	int mDisplayWidth;            // width of event display area
	int mDisplayX;                // left of event display area
	int mDisplayLineTopY;         // top of display lines (eg time rules)
	int mDisplayLineBottomY;      // bottom of display lines
	int mDisplayLineHeight;       // height of display lines
	int mHeaderSpace;             // whitespace at the top of the display
	int mFooterSpace;             // whitespace at the bottom of the display
	int mChannelHeight;           // distance between two channels in the display
	int mChannelDisplayHeight;    // height of display elements in a channel (eg, a note on bar)
	int mChannelNumberBarWidth;   // width of vertical channel numbers bar
	int mChannelFlagsBarWidth;    // width of vertical channel play flags bar
	int mChannelFlagWidth;        // width of an individual flag marker in the channel flags bar
	int mLeftGutterWidth;         // width of vertical whitespace left of the event display area
	int mRightGutterWidth;        // width of the vertical whitespace right of the event display area
	int mRuleFrequency;           // time between two time rules
	int mRuleThreshold;           // minimum time between two time rules

	void CalcDisplayParameters();
	void PaintStaticDisplay();

	int CalcX(int time);
	void PaintChannelNumbers(CDC *dc);
	void PaintChannelFlags(CDC *dc);
	void PaintTimeRules(CDC *dc);
	void PaintDisplayLine(CDC *dc, int time);
	void PaintEventLine(CDC *dc, int time, int channel);
	void PaintTimeLabel(CDC *dc, int time);
	void PaintEvents(CDC *dc);

public:
	afx_msg void OnPaint();
	afx_msg void OnSize(UINT nType, int cx, int cy);
};
