/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

// PlayBar.cpp : implementation file
//

#include "stdafx.h"
#include "Soundbox.h"
#include "PlayBar.h"

#define IDC_FILTERLIST 10000
#define IDC_PLAYERLIST 10001
#define IDC_PLAYBTN 10002
#define IDC_STOPBTN 10003


// CPlayBar

IMPLEMENT_DYNAMIC(CPlayBar, CWnd)
CPlayBar::CPlayBar()
: mSignal(-1)
{
	mHUnit = LOWORD(GetDialogBaseUnits());
	mVUnit = HIWORD(GetDialogBaseUnits());
}

CPlayBar::~CPlayBar()
{
}

void CPlayBar::SetSignal(int signal)
{
	mSignal = signal;
	RedrawWindow();
}

void CPlayBar::SetPlayState(int state)
{
	mFilterList.EnableWindow(state != PLAYSTATE_PLAYING);
	mPlayerList.EnableWindow(state != PLAYSTATE_PLAYING);
	mPlayBtn.EnableWindow(state == PLAYSTATE_STOPPED);
	mStopBtn.EnableWindow(state == PLAYSTATE_PLAYING);
}


BEGIN_MESSAGE_MAP(CPlayBar, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_CBN_SELCHANGE(IDC_FILTERLIST, OnFilterListSelChange)
	ON_BN_CLICKED(IDC_PLAYBTN, OnPlayBtnClicked)
	ON_BN_CLICKED(IDC_STOPBTN, OnStopBtnClicked)
END_MESSAGE_MAP()



// CPlayBar message handlers


void CPlayBar::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	RECT rect;
	GetClientRect(&rect);

	CDC memDC;
	CBitmap memBmp;
	memDC.CreateCompatibleDC(&dc);
	memBmp.CreateCompatibleBitmap(&dc, rect.right, rect.bottom);
	memDC.SelectObject(&memBmp);

	memDC.FillSolidRect(&rect, GetSysColor(COLOR_BTNFACE));
	memDC.Draw3dRect(&rect, GetSysColor(COLOR_3DLIGHT), GetSysColor(COLOR_3DSHADOW));

	char cueStr[32];
	sprintf(cueStr, "Signal:  %d", mSignal);

	memDC.SetTextColor(GetSysColor(COLOR_BTNTEXT));
	memDC.SetBkColor(GetSysColor(COLOR_BTNFACE));
	memDC.SetBkMode(OPAQUE);
	memDC.TextOut(mHUnit * 3, mVUnit, "Filter:");
	memDC.TextOut(mHUnit * 38, mVUnit, "Player:");
	memDC.TextOut(mHUnit * 68, mVUnit, cueStr);

	dc.BitBlt(0, 0, rect.right, rect.bottom, &memDC, 0, 0, SRCCOPY);
}

int CPlayBar::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	RECT rect;

	rect.top = mVUnit * 3 / 4;
	rect.bottom = rect.top + mVUnit * 11;
	rect.left = mHUnit * 9;
	rect.right = mHUnit * 36;
	mFilterList.Create(WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, rect, this, IDC_FILTERLIST);
	for (int i = 0; i < 8; ++i) {
		mFilterList.AddItem(CSoundboxApp::FILTER_NAMES[i], CSoundboxApp::FILTER_COLORS_LIGHT[i]);
	}
	mFilterList.SetCurSel(0);

	// tell our parent that we're using (by default) the MT-32 filter
	int index = 0;
	int mask = (1 << index);
	GetParent()->PostMessage(SBM_SETFILTER, index, mask);

	rect.top = mVUnit * 3 / 4;
	rect.bottom = rect.top + mVUnit * 7;
	rect.left = mHUnit * 45;
	rect.right = mHUnit * 66;
	mPlayerList.Create(WS_CHILD | WS_VISIBLE | CBS_DROPDOWNLIST, rect, this, IDC_PLAYERLIST);
	mPlayerList.AddString("MIDI Mapper");
	mPlayerList.AddString("FreeSCI MT-32 -> GM");
	// don't add these until they're implemented
	// mPlayerList.AddString("Beeper Emuator");
	// mPlayerList.AddString("Adlib Emulator");
	mPlayerList.SetCurSel(0);

	rect.top = mVUnit * 3 / 2 - 12;
	rect.bottom = mVUnit * 3 / 2 + 13;
	rect.left = mHUnit * 79;
	rect.right = mHUnit * 79 + 30;
	mPlayBtn.Create("", WS_CHILD | WS_VISIBLE | WS_DISABLED | BS_OWNERDRAW, rect, this, IDC_PLAYBTN);
	mPlayBtn.LoadBitmaps(IDB_PLAYUP, IDB_PLAYDOWN, 0, IDB_PLAYDISABLED);

	rect.top = mVUnit * 3 / 2 - 12;
	rect.bottom = mVUnit * 3 / 2 + 13;
	rect.left = mHUnit * 79 + 40;
	rect.right = mHUnit * 79 + 70;
	mStopBtn.Create("", WS_CHILD | WS_VISIBLE | WS_DISABLED | BS_OWNERDRAW, rect, this, IDC_STOPBTN);
	mStopBtn.LoadBitmaps(IDB_STOPUP, IDB_STOPDOWN, 0, IDB_STOPDISABLED);

	return 0;
}

void CPlayBar::OnFilterListSelChange()
{
	CColorComboBox* list = (CColorComboBox*)GetDlgItem(IDC_FILTERLIST);
	int index = list->GetCurSel();
	int mask = (1 << index);
	GetParent()->PostMessage(SBM_SETFILTER, index, mask);
}

void CPlayBar::OnPlayBtnClicked()
{
	CComboBox *list = (CComboBox*)GetDlgItem(IDC_PLAYERLIST);
	GetParent()->PostMessage(SBM_PLAY, list->GetCurSel());
}

void CPlayBar::OnStopBtnClicked()
{
	GetParent()->PostMessage(SBM_STOP);
}
