/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * DataStream provides a set of read and write methods that work on data types
 * rather than buffers. For its implementation it just wraps std::iostream. We
 * don't work on iostream directly for two reasons. First, we want exceptions
 * thrown at eof and other fail cases. Second, we want to write things like:
 *
 *   if (in.ReadShort()) != 0x84 {
 *
 * rather than:
 *
 *   short foo;
 *   in.read(&foo, 2);
 *   if (foo != 0x84) {
 */

#include <iostream>

class DataStream
{
public:
	static const int BEG;
	static const int CUR;
	static const int END;

	DataStream(std::iostream *stream);
	~DataStream(void);
	unsigned char PeekChar();
	unsigned char ReadChar();
	unsigned short ReadShort();
	unsigned short ReadBigShort();
	unsigned long ReadBigTri();
	unsigned long ReadBigLong();
	unsigned long ReadVariableLength();
	void WriteChar(unsigned char data);
	void WriteShort(unsigned short data);
	int Tellg();
	void Seekg(int where, int how = CUR);
	void ReadBuffer(unsigned char *buffer, int length);

private:
	std::iostream *mStream;
};
