/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

/*
 * Sound cues editor dialog.
 */

#include <afxtempl.h>

class SoundResource;


// CCuesDlg dialog

class CCuesDlg : public CDialog
{
	DECLARE_DYNAMIC(CCuesDlg)

public:
	CCuesDlg(SoundResource *sound, CWnd* pParent = NULL);   // standard constructor
	virtual ~CCuesDlg();

// Dialog Data
	enum { IDD = IDD_CUESDLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void FixIndices(int startSoundIndex, int delta);

	DECLARE_MESSAGE_MAP()

	SoundResource *mSound;
	CArray<int> mDirectIndex;
	CArray<int> mCumulativeIndex;

public:
	virtual BOOL OnInitDialog();
	afx_msg void OnDirectListSelChange();
	afx_msg void OnCumulativeListSelChange();
	afx_msg void OnDirectDelBtnClicked();
	afx_msg void OnCumulativeDelBtnClicked();
	afx_msg void OnAddBtnClicked();
};
