/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

// ColorComboBox.cpp : implementation file
//

#include "stdafx.h"
#include "Soundbox.h"
#include "ColorComboBox.h"


// CColorComboBox

IMPLEMENT_DYNAMIC(CColorComboBox, CComboBox)
CColorComboBox::CColorComboBox()
{
	mHUnit = LOWORD(GetDialogBaseUnits());
}

CColorComboBox::~CColorComboBox()
{
}

int CColorComboBox::AddItem(const char *str, COLORREF bgColor)
{
	int idx = AddString(str);
	SetItemData(idx, bgColor);
	return idx;
}

BEGIN_MESSAGE_MAP(CColorComboBox, CComboBox)
END_MESSAGE_MAP()



// CColorComboBox message handlers


BOOL CColorComboBox::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= CBS_OWNERDRAWFIXED | CBS_HASSTRINGS;
	return CComboBox::PreCreateWindow(cs);
}

void CColorComboBox::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
}

void CColorComboBox::DrawItem(LPDRAWITEMSTRUCT lpdis)
{
	CDC dc;
	dc.Attach(lpdis->hDC);

	COLORREF saveTextColor = dc.GetTextColor();
	COLORREF saveBkColor = dc.GetBkColor();
	CFont *saveFont = dc.GetCurrentFont();

	dc.SetTextColor(RGB(0, 0, 0));
	dc.SetBkColor((COLORREF)lpdis->itemData);
	dc.FillSolidRect(&lpdis->rcItem, (COLORREF)lpdis->itemData);
	dc.SelectObject(GetFont());

	if (lpdis->itemID >= 0) {
		char itemStr[1024];
		GetLBText(lpdis->itemID, itemStr);
		::InflateRect(&lpdis->rcItem, -1 * mHUnit / 2, 0);
		if (lpdis->itemState & ODS_DISABLED) dc.SetTextColor(RGB(128, 128, 128));
		dc.DrawText(itemStr, &lpdis->rcItem, DT_LEFT | DT_VCENTER | DT_SINGLELINE);
		::InflateRect(&lpdis->rcItem, mHUnit / 2, 0);
		if (lpdis->itemState & ODS_SELECTED) dc.DrawFocusRect(&lpdis->rcItem);
	}

	dc.SelectObject(saveFont);
	dc.SetTextColor(saveTextColor);
	dc.SetBkColor(saveBkColor);
	dc.Detach();
}
