/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

// ChildView.h : interface of the CChildView class
//


#pragma once

#include "PlayBar.h"
#include "SoundDisplay.h"
#include "PlayerManager.h"

class SoundResource;
class SoundPlayer;


// CChildView window

class CChildView : public CWnd
{
// Construction
public:
	CChildView();

// Attributes
public:

// Operations
public:

// Overrides
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

// Implementation
public:
	virtual ~CChildView();

protected:
	SoundResource *mSound;   // the sound resource being edited
	bool mLoaded;            // is a sound resource loaded
	CString mPath;           // full path to file for loaded resource, if any ("" if none)
	bool mPlaying;           // is the player running
	SoundPlayer *mPlayer;    // player playing mSound (if mSound is playing)
	int mFilter;             // currently selected sound filter
	PlayerManager mManager;  // creates and initializes sound players

	int mVUnit;
	CPlayBar mPlayBar;
	CSoundDisplay mDisplay;

// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnUpdateFileOpen130(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileImportmidi(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileSave132(CCmdUI *pCmdUI);
	afx_msg void OnUpdateFileSaveas(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditLooppoint(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditCues(CCmdUI *pCmdUI);
	afx_msg void OnUpdateEditChannelproperties(CCmdUI *pCmdUI);
	afx_msg void OnFileOpen130();
	afx_msg void OnFileImportmidi();
	afx_msg void OnFileSave132();
	afx_msg void OnFileSaveas();
	afx_msg void OnEditLooppoint();
	afx_msg void OnEditCues();
	afx_msg void OnEditChannelproperties();
	afx_msg void OnViewCues();
	afx_msg void OnUpdateViewCues(CCmdUI *pCmdUI);
	afx_msg void OnViewLooppoint();
	afx_msg void OnUpdateViewLooppoint(CCmdUI *pCmdUI);
	afx_msg void OnViewNoteonevents();
	afx_msg void OnUpdateViewNoteonevents(CCmdUI *pCmdUI);
	afx_msg void OnViewTimemarkers();
	afx_msg void OnUpdateViewTimemarkers(CCmdUI *pCmdUI);
	afx_msg void OnViewVoicecontrols();
	afx_msg void OnUpdateViewVoicecontrols(CCmdUI *pCmdUI);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg LRESULT OnSetFilter(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSoundTick(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSoundSignal(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPlayStarted(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPlayStopped(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnPlay(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnStop(WPARAM wParam, LPARAM lParam);
	afx_msg void OnHelpLicense();
};

