/*
 * Copyright (c) 2002 by Ravi Iyengar [ravi.i@softhome.net]
 * Released under the GNU General Public License
 * See LICENSE for details.
 */

#pragma once

#include <afxtempl.h>

class SoundResource;


// CChannelsDlg dialog

class CChannelsDlg : public CDialog
{
	DECLARE_DYNAMIC(CChannelsDlg)

public:
	CChannelsDlg(SoundResource *sound, CWnd* pParent = NULL);   // standard constructor
	virtual ~CChannelsDlg();

// Dialog Data
	enum { IDD = IDD_CHANNELSDLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void SaveSettings(int channel);
	void LoadSettings(int channel);

	static const int FLAG_CHECK_IDS[8];
	int mCurChannel;
	SoundResource *mSound;
	CFont mChannelsListFont;
	CArray<int> mIndex;

	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnChannelsListSelChange();
	afx_msg void OnControlListSelChange();
	afx_msg void OnDelBtnClicked();
	afx_msg void OnAddBtnClicked();
protected:
	virtual void OnOK();
};
