/*************************************************************************
 * SCI Script Compiler Header
 * By Brian Provinciano
 *************************************************************************/
(define KEY_BACK  			$08)
(define KEY_TAB   			$09)
(define KEY_SHIFTTAB		$F00)

(define KEY_CLEAR  			$0C)
(define KEY_RETURN  		$0D)

(define KEY_SHIFT  			$10)
(define KEY_CONTROL  		$11)
(define KEY_MENU  			$12)
(define KEY_PAUSE  			$13)
(define KEY_CAPITAL  		$14)

(define KEY_ESCAPE  		$1B)
(define KEY_ESC   			$1B)

(define KEY_SPACE  			$20)
(define KEY_PRIOR  			$21)
(define KEY_NEXT  			$22)
(define KEY_END   			$4F00)
(define KEY_HOME  			$4700)
(define KEY_LEFT  			$4B00)
(define KEY_UP   			$4800)
(define KEY_RIGHT  			$4D00)
(define KEY_DOWN  			$5000)
(define KEY_PAGEDOWN  		$4900)
(define KEY_PAGEUP  		$5100)
(define KEY_PERCENT  		$25)
(define KEY_SELECT  		$29)
(define KEY_PRINT  			$2A)
(define KEY_EXECUTE  		$2B)
(define KEY_SNAPSHOT 		$2C)
(define KEY_INSERT  		$5200)
(define KEY_DELETE  		$5300)
(define KEY_HELP  			$2F)

(define KEY_0   			$30)
(define KEY_1   			$31)
(define KEY_2   			$32)
(define KEY_3   			$33)
(define KEY_4   			$34)
(define KEY_5   			$35)
(define KEY_6   			$36)
(define KEY_7   			$37)
(define KEY_8   			$38)
(define KEY_9   			$39)
(define KEY_QUESTION        $3F)
(define KEY_A   			$41)
(define KEY_B   			$42)
(define KEY_C   			$43)
(define KEY_D   			$44)
(define KEY_E   			$45)
(define KEY_F   			$46)
(define KEY_G   			$47)
(define KEY_H   			$48)
(define KEY_I   			$49)
(define KEY_J   			$4A)
(define KEY_K   			$4B)
(define KEY_L   			$4C)
(define KEY_M   			$4D)
(define KEY_N   			$4E)
(define KEY_O   			$4F)
(define KEY_P   			$50)
(define KEY_Q   			$51)
(define KEY_R   			$52)
(define KEY_S   			$53)
(define KEY_T   			$54)
(define KEY_U   			$55)
(define KEY_V   			$56)
(define KEY_W   			$57)
(define KEY_X   			$58)
(define KEY_Y   			$59)
(define KEY_Z   			$5A)

(define KEY_a   			$61)
(define KEY_b   			$62)
(define KEY_c   			$63)
(define KEY_d   			$64)
(define KEY_e   			$65)
(define KEY_f   			$66)
(define KEY_g   			$67)
(define KEY_h   			$68)
(define KEY_i   			$69)
(define KEY_j   			$6A)
(define KEY_k   			$6B)
(define KEY_l   			$6C)
(define KEY_m   			$6D)
(define KEY_n   			$6E)
(define KEY_o   			$6F)
(define KEY_p   			$70)
(define KEY_q   			$71)
(define KEY_r   			$72)
(define KEY_s   			$73)
(define KEY_t   			$74)
(define KEY_u   			$75)
(define KEY_v   			$76)
(define KEY_w   			$77)
(define KEY_x   			$78)
(define KEY_y   			$79)
(define KEY_z   			$7A)

(define KEY_ALT_q           $1000)
(define KEY_ALT_w           $1100)
(define KEY_ALT_e           $1200)
(define KEY_ALT_r           $1300)
(define KEY_ALT_t           $1400)
(define KEY_ALT_y           $1500)
(define KEY_ALT_u           $1600)
(define KEY_ALT_i           $1700)
(define KEY_ALT_o           $1800)
(define KEY_ALT_p           $1900)

(define KEY_ALT_a           $1E00)
(define KEY_ALT_s           $1F00)
(define KEY_ALT_d           $2000)
(define KEY_ALT_f           $2100)
(define KEY_ALT_g           $2200)
(define KEY_ALT_h           $2300)
(define KEY_ALT_j           $2400)
(define KEY_ALT_k           $2500)
(define KEY_ALT_l           $2600)

(define KEY_ALT_z           $2C00)
(define KEY_ALT_x           $2D00)
(define KEY_ALT_c           $2E00)
(define KEY_ALT_v           $2F00)
(define KEY_ALT_b           $3000)
(define KEY_ALT_n           $3100)
(define KEY_ALT_m           $3200)

(define KEY_NUMPAD0  		$5200)
(define KEY_NUMPAD1  		$4F00)
(define KEY_NUMPAD2  		$5000)
(define KEY_NUMPAD3  		$5100)
(define KEY_NUMPAD4  		$4B00)
(define KEY_NUMPAD5  		$4C00)
(define KEY_NUMPAD6  		$4D00)
(define KEY_NUMPAD7  		$4700)
(define KEY_NUMPAD8  		$4800)
(define KEY_NUMPAD9  		$4900)
(define KEY_MULTIPLY 		$2A)
(define KEY_ADD   			$2B)
(define KEY_SEPARATOR 		$2F)
(define KEY_SUBTRACT 		$2D)
(define KEY_DECIMAL  		$2E)
(define KEY_DIVIDE  		$2F)
(define KEY_F1   			$3B00)
(define KEY_F2   			$3C00)
(define KEY_F3   			$3D00)
(define KEY_F4   			$3E00)
(define KEY_F5   			$3F00)
(define KEY_F6   			$4000)
(define KEY_F7   			$4100)
(define KEY_F8   			$4200)
(define KEY_F9   			$4300)
(define KEY_F10   			$4400)
/*************************************************************************/
(define JOY_NULL			0)
(define JOY_UP				1)
(define JOY_UPRIGHT			2)
(define JOY_RIGHT			3)
(define JOY_DOWNRIGHT		4)
(define JOY_DOWN			5)
(define JOY_DOWNLEFT		6)
(define JOY_LEFT			7)
(define JOY_UPLEFT			8)
/*************************************************************************/
