/* SPDX-License-Identifier: GPL-3.0-or-later */
/* apoplexy v3.17 (January 2023)
 * Copyright (C) 2008-2023 The apoplexy Team (see credits.txt)
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see [ www.gnu.org/licenses/ ].
 *
 * To properly read this code, set your program's tab stop to: 2.
 */

/*========== Includes ==========*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <math.h>
#include <time.h>
#include <errno.h>
#include <dirent.h>
#if defined WIN32 || _WIN32 || WIN64 || _WIN64
#include <windows.h>
#undef PlaySound
#endif

#include <curl/curl.h>
#include <zip.h>

#include <SDL.h>
#include <SDL_audio.h>
#include <SDL_thread.h>
#include <SDL_ttf.h>
#include <SDL_image.h>
/*========== Includes ==========*/

/*========== Defines ==========*/
#define EXIT_NORMAL 0
#define EXIT_ERROR 1
#define MAX_DATA 720
#define MAX_TEXT 100
#define ROOMS 32 /*** PoP1 only uses 24. ***/
#define USER_DATA 2000
#define WINDOW_WIDTH 642 + 50
#define WINDOW_HEIGHT 380 + 75
#define EDITOR_NAME "apoplexy"
#define EDITOR_VERSION "v3.17 (January 2023)" /*** Modify? Also _MINOR! ***/
#define EDITOR_VERSION_MAJOR 3
#define EDITOR_VERSION_MINOR 17
#define EDITOR_VERSION_PATCH 0
#define COPYRIGHT "Copyright (C) 2023 The apoplexy Team"
#define COMPATIBLE_NATIVE "SDLPoP 1.23, MININIM 0.10"
#define REFRESH 30 /*** That is 33 frames per second, 1000/30. ***/
#define MAX_FILE 600
#define MAX_ADJ 10
#define MAX_GRID 10
#define FONT_SIZE_15 15
#define FONT_SIZE_11 11
#define FONT_SIZE_20 20
#define MAX_TOWRITE 720
#define NUM_SOUNDS 20 /*** Sounds that may play at the same time. ***/
#define MAX_OPTION 100
#define MAX_CUSTOM 100
#define MAX_DATETIME 50
#define MAX_IMG 200
#define MAX_CON 30
#define MAX_EXETYPE 10
#define MAX_TILES 1000
#define MAX_CURDIR 100
#define MAX_GUARDNAME 100
#define GUARD_TABS 9
#define MAX_STATUS 100 /*** Cannot be more than MAX_TEXT. ***/
#define MAX_LEVELNAME 20
#define MAX_INFO 200
#define MAX_LOCATION 500
#define MAX_ERROR 100
#define AUTOMATIC_SNES 459
#define MAX_WARNING 500
#define END_SHADOW 65534
#define END_PRINCE 65535
#define URL_CUSPOP "https://www.popot.org/other_useful_tools.php?tool=CusPop"
#define URL_THREAD "https://forum.princed.org/viewtopic.php?t=3099"
#define URL_LATEST "https://apoplexy.github.io/apoplexysite/latest_release.xml"
#define MAX_TEXT_JUMP 20
#define MAX_TEXT_FIND 44

/*** Map window ***/
#define MAP_BIG_AREA_W 1225
#define MAP_BIG_AREA_H 745 /*** With the edit panel open, visible u/i 477. ***/
#define MAX_ZOOM 7
#define DEFAULT_ZOOM 4

/*** DOS ***/
#define OFFSETD_X 25 /*** Pixels from the left, where tiles are visible. ***/
#define OFFSETD_Y 50 /*** Pixels from the top, where tiles are visible. ***/
#define TTPD_1 27 /*** Top row, pixels behind interface. ***/
#define TTPD_O 27 /*** Other rows, pixels behind superjacent rows. ***/
#define DD_X 64 /*** Horizontal distance between (overlapping) tiles. ***/
#define DD_Y 126 /*** Vertical distance between (overlapping) tiles. ***/

/*** SNES ***/
#define OFFSETS_X 105
#define OFFSETS_Y 50
#define TTPS_1 5
#define TTPS_O 0
#define DS_X 48
#define DS_Y 128

#define BROKEN_ROOM_X 438
#define BROKEN_ROOM_Y 76
#define BROKEN_LEFT_X 423
#define BROKEN_LEFT_Y 76
#define BROKEN_RIGHT_X 453
#define BROKEN_RIGHT_Y 76
#define BROKEN_UP_X 438
#define BROKEN_UP_Y 61
#define BROKEN_DOWN_X 438
#define BROKEN_DOWN_Y 91
#define ADJ_BASE_X 422
#define ADJ_BASE_Y 60
#define STATIC 5
#define DYNAMIC 3
#define TILESX1 2
#define TILESX2 52
#define TILESX3 102
#define TILESX4 152
#define TILESX5 202
#define TILESX6 252
#define TILESX7 302
#define TILESX8 352
#define TILESX9 402
#define TILESX10 452
#define TILESX11 502
#define TILESX12 552
#define TILESX13 602
#define TILESY1 2
#define TILESY15 46
#define TILESY2 66
#define TILESY25 120
#define TILESY3 130
#define TILESY4 194
#define TILESY5 258
#define TILESY6 322
#define TILESY7 386
#define TILEWIDTH 48
#define TILEHEIGHT 62
#define BAR_FULL 432
#define MAX_HEX 100

#define G1RIGHT 38
#define G2RIGHT 80
#define G3RIGHT 122
#define G4RIGHT 164
#define G5RIGHT 206
#define G1LEFT 19
#define G2LEFT 61
#define G3LEFT 103
#define G4LEFT 145
#define G5LEFT 187
#define GTYPE1 48
#define GTYPE2 83
#define GTYPE3 130
#define GTYPE4 166
#define GTYPE5 200
#define GTYPE6 227
#define GTYPE7 246
#define GTYPE8 274
#define GTYPE9 300
#define GTYPE10 318
#define GTYPE11 349
#define GTYPE12 377
#define GTYPE13 405
#define ROWW 33
#define ROWH 6

#ifndef O_BINARY
#define O_BINARY 0
#endif

#if defined WIN32 || _WIN32 || WIN64 || _WIN64
#define DEVNULL "NUL"
#define COPY "copy"
#define PR_EXECUTABLE "pr\\pr.exe"
#define POP1_EXECUTABLE "prince\\PRINCE.EXE"
#define POP1_DIR "prince\\"
#define BATCH_FILE_NATIVE "apoplexy.bat"
#define SLASH "\\"
#define HERE ""
#define POP2_EXECUTABLE "prince2\\PRINCE.EXE"
#define POP2_DIR "prince2\\"
#define LEVELS_DAT "prince\\LEVELS.DAT"
#define LEVELS_BAK "prince\\LEVELS.BAK"
#define PRINCE_DAT "prince2\\PRINCE.DAT"
#define PRINCE_BAK "prince2\\PRINCE.BAK"
#define SNES_DIR "snes\\"
#define SNES_BAK "snes\\PRINCE.BAK"
#define PR_RESOURCES "pr\\resources.xml"
#define PR_POP2 "pr\\pop2.xml"
#define IN_DIR "levels\\"
#define OUT_DIR "levels\\"
#define IN_DIR_POP2 "levels2\\PRINCE\\"
#define OUT_DIR_POP2 "levels2\\PRINCE\\"
#define XML_DIR "xml\\"
#define SDLPOP_DIR "SDLPoP\\"
#define MININIM_DIR "MININIM\\"
#define BATCH_FILE "prince\\apoplexy.bat"
#define BATCH_FILE_POP2 "prince2\\apoplexy.bat"
#define TEMPLATES_SNES "templates\\snes\\"
#define PNG_DUNGEON "png\\dungeon\\"
#define PNG_PALACE "png\\palace\\"
#define PNG_OTH "png\\oth\\"
#define PNG_CAVERNS "png\\caverns\\"
#define PNG_CAVERNSD "png\\caverns_details\\"
#define PNG_RUINS "png\\ruins\\"
#define PNG_RUINSD "png\\ruins_details\\"
#define PNG_RUINSB "png\\ruins_back\\"
#define PNG_TEMPLE "png\\temple\\"
#define PNG_TEMPLEB "png\\temple_back\\"
#define PNG_BLUE "png\\blue\\"
#define PNG_BLUEB "png\\blue_back\\"
#define PNG_FAWN "png\\fawn\\"
#define PNG_FAWNB "png\\fawn_back\\"
#define PNG_SILVER "png\\silver\\"
#define PNG_SILVERB "png\\silver_back\\"
#define PNG_LAVA "png\\lava\\"
#define PNG_LAVAB "png\\lava_back\\"
#define PNG_GREEN "png\\green\\"
#define PNG_GREENB "png\\green_back\\"
#define PNG_UMBER "png\\umber\\"
#define PNG_UMBERB "png\\umber_back\\"
#define PNG_MARBLE "png\\marble\\"
#define PNG_MARBLEB "png\\marble_back\\"
#define PNG_HALLWAY "png\\hallway\\"
#define PNG_HALLWAYB "png\\hallway_back\\"
#define PNG_JAFFAR "png\\jaffar\\"
#define PNG_JAFFARB "png\\jaffar_back\\"
#define PNG_INTRO "png\\intro\\"
#define PNG_INTROB "png\\intro_back\\"
#define PNG_ROOMS "png\\rooms\\"
#define PNG_EXTRAS "png\\extras\\"
#define PNG_VARIOUS "png\\various\\"
#define PNG_BACKSS "png\\backgrounds_snes\\"
#define PNG_TEMPS "png\\templates_snes\\"
#define PNG_LIVING1 "png\\living_pop1\\"
#define PNG_LIVING2 "png\\living_pop2\\"
#define PNG_LIVING3 "png\\living_pop1snes\\"
#define PNG_BUTTONS "png\\buttons\\"
#define PNG_BACK "png\\back\\"
#define PNG_INCOMING "png\\incoming\\"
#define PNG_MUSIC "png\\music\\"
#define PNG_CONTROLLER "png\\controller\\"
#define PNG_NATIVE "png\\native\\"
#define PNG_PLAYTEST "png\\playtest\\"
#define PNG_MINI1 "png\\mini_pop1\\"
#define PNG_MINI3 "png\\mini_pop1snes\\"
#define PNG_SIXBITRGB "png\\six_bit_rgb\\"
#define PNG_AUTOMATIC "png\\automatic\\"
#else
#define DEVNULL "/dev/null"
#define COPY "cp"
#define PR_EXECUTABLE "pr/pr"
#define POP1_EXECUTABLE "prince/PRINCE.EXE"
#define POP1_DIR "prince/"
#define BATCH_FILE_NATIVE "apoplexy.sh"
#define SLASH "/"
#define HERE "./"
#define POP2_EXECUTABLE "prince2/PRINCE.EXE"
#define POP2_DIR "prince2/"
#define LEVELS_DAT "prince/LEVELS.DAT"
#define LEVELS_BAK "prince/LEVELS.BAK"
#define PRINCE_DAT "prince2/PRINCE.DAT"
#define PRINCE_BAK "prince2/PRINCE.BAK"
#define SNES_DIR "snes/"
#define SNES_BAK "snes/PRINCE.BAK"
#define PR_RESOURCES "pr/resources.xml"
#define PR_POP2 "pr/pop2.xml"
#define IN_DIR "levels/"
#define OUT_DIR "levels/"
#define IN_DIR_POP2 "levels2/PRINCE/"
#define OUT_DIR_POP2 "levels2/PRINCE/"
#define XML_DIR "xml/"
#define SDLPOP_DIR "SDLPoP/"
#define MININIM_DIR "MININIM/"
#define BATCH_FILE "prince/apoplexy.bat"
#define BATCH_FILE_POP2 "prince2/apoplexy.bat"
#define TEMPLATES_SNES "templates/snes/"
#define PNG_DUNGEON "png/dungeon/"
#define PNG_PALACE "png/palace/"
#define PNG_OTH "png/oth/"
#define PNG_CAVERNS "png/caverns/"
#define PNG_CAVERNSD "png/caverns_details/"
#define PNG_RUINS "png/ruins/"
#define PNG_RUINSD "png/ruins_details/"
#define PNG_RUINSB "png/ruins_back/"
#define PNG_TEMPLE "png/temple/"
#define PNG_TEMPLEB "png/temple_back/"
#define PNG_BLUE "png/blue/"
#define PNG_BLUEB "png/blue_back/"
#define PNG_FAWN "png/fawn/"
#define PNG_FAWNB "png/fawn_back/"
#define PNG_SILVER "png/silver/"
#define PNG_SILVERB "png/silver_back/"
#define PNG_LAVA "png/lava/"
#define PNG_LAVAB "png/lava_back/"
#define PNG_GREEN "png/green/"
#define PNG_GREENB "png/green_back/"
#define PNG_UMBER "png/umber/"
#define PNG_UMBERB "png/umber_back/"
#define PNG_MARBLE "png/marble/"
#define PNG_MARBLEB "png/marble_back/"
#define PNG_HALLWAY "png/hallway/"
#define PNG_HALLWAYB "png/hallway_back/"
#define PNG_JAFFAR "png/jaffar/"
#define PNG_JAFFARB "png/jaffar_back/"
#define PNG_INTRO "png/intro/"
#define PNG_INTROB "png/intro_back/"
#define PNG_ROOMS "png/rooms/"
#define PNG_EXTRAS "png/extras/"
#define PNG_VARIOUS "png/various/"
#define PNG_BACKSS "png/backgrounds_snes/"
#define PNG_TEMPS "png/templates_snes/"
#define PNG_LIVING1 "png/living_pop1/"
#define PNG_LIVING2 "png/living_pop2/"
#define PNG_LIVING3 "png/living_pop1snes/"
#define PNG_BUTTONS "png/buttons/"
#define PNG_BACK "png/back/"
#define PNG_INCOMING "png/incoming/"
#define PNG_MUSIC "png/music/"
#define PNG_CONTROLLER "png/controller/"
#define PNG_NATIVE "png/native/"
#define PNG_PLAYTEST "png/playtest/"
#define PNG_MINI1 "png/mini_pop1/"
#define PNG_MINI3 "png/mini_pop1snes/"
#define PNG_SIXBITRGB "png/six_bit_rgb/"
#define PNG_AUTOMATIC "png/automatic/"
#endif
/*========== Defines ==========*/

int iDX, iDY, iTTP1, iTTPO;
int iHor0, iHor1, iHor2, iHor3, iHor4, iHor5;
int iHor6, iHor7, iHor8, iHor9, iHor10;
int iVer1, iVer2, iVer3, iVer4;

/*** for text ***/
SDL_Color color_bl = {0x00, 0x00, 0x00, 255};
SDL_Color color_wh = {0xff, 0xff, 0xff, 255};
SDL_Color color_red = {0xff, 0x00, 0x00, 255};
SDL_Color color_blue = {0x00, 0x00, 0xff, 255};
SDL_Color color_mag = {0xff, 0x00, 0xff, 255};
SDL_Color color_g3 = {0x33, 0x33, 0x33, 255};
SDL_Color color_g8 = {0x88, 0x88, 0x88, 255};
SDL_Color color_gb = {0xbb, 0xbb, 0xbb, 255};
SDL_Color color_f4 = {0xf4, 0xf4, 0xf4, 255};
SDL_Color color_tooltip = {0xc7, 0xff, 0xc7, 255};
SDL_Color color_cc = {0xcc, 0xcc, 0xcc, 255};
SDL_Color color_melrose = {0x99, 0x99, 0xff, 255};
SDL_Rect offset;
SDL_Surface *message;
SDL_Texture *messaget;

/* Text. The magic identifier "POP_LVL" text distinguishes a POP
 * level file from other file formats.
 */
unsigned char sMagicID[7 + 2];

/*** UC. 01 = POP1, 02 = POP2 ***/
unsigned char sPOPVersion[1 + 2];

/*** UC. Level version. ***/
unsigned char sPLVVersion[1 + 2];

/*** UC. Level number. ***/
unsigned char sLevelNumber[1 + 2];

/*** UL. Number of fields. ***/
unsigned char sNumberOfFields[4 + 2];

/* UL. Size of the level in bytes. All PoP1 levels are 2305, except
 * the potions level, which is 2304. All PoP2 levels are 12025.
 */
unsigned char sLevelSize[4 + 2];

/*** The checksum. ***/
unsigned char sChecksum[1 + 2];

/*** The first and second door events. ***/
unsigned char sFirstDoorEvents[256 + 2];
unsigned char sSecondDoorEvents[256 + 2];
unsigned char sPoP2DoorEvents[1280 + 2];
int iPoP2DoorLocation[256 + 2];
int iPoP2DoorRoom[256 + 2];
int iPoP2DoorType[256 + 2];
int iPoP2DoorLeft[256 + 2];
int iPoP2DoorRight[256 + 2];

unsigned char sRoomLinks[128 + 2]; /*** PoP1 is only 96. ***/
unsigned char sUnknownI[64 + 2]; /*** PoP2 and PoP1 for SNES are only 1. ***/
unsigned char sStartPosition[3 + 2];
unsigned char sUnknownIIandIII[4 + 2];
unsigned char sGuardLocations[ROOMS + 2];
unsigned char sGuardDirections[ROOMS + 2];
unsigned char sUnknownIVaandIVb[48 + 2];
unsigned char sGuardSkills[ROOMS + 2];
unsigned char sUnknownIVc[24 + 2];
unsigned char sGuardColors[ROOMS + 2];
unsigned char sUnknownIVd[16 + 2];
unsigned char sEndCode[2 + 2];
unsigned char sUserDataCount[4 + 2];
unsigned char sUserData[USER_DATA + 2];
unsigned char sLastRoom[1 + 2];
unsigned char sJEFF[4 + 2];
unsigned char sLevelTypeC[1 + 2];
unsigned char sLevelInit[1 + 2];
unsigned char sExtraImgResources[24 + 2];
unsigned char sUnknownII[72 + 2]; /*** PoP2 is only 3. ***/
unsigned char sLevelGuardTypeC[1 + 2];
unsigned char sStaticGuards[3712 + 2];
unsigned char sCheckPoints[18 + 2];
unsigned char sDynamicGuards[1088 + 2];
unsigned char sMusic[960 + 2];
unsigned char sGuardTypesDirections[ROOMS + 2]; /*** PoP1 for SNES only. ***/
unsigned char sGuardTypes[ROOMS + 2]; /*** PoP1 for SNES only. ***/

int iStaticGuards_Amount[ROOMS + 2];
int iStaticGuards_1_Locations[ROOMS + 2][STATIC + 2];
int iStaticGuards_2_Offsets1[ROOMS + 2][STATIC + 2];
int iStaticGuards_3_Offsets2[ROOMS + 2][STATIC + 2];
int iStaticGuards_4_Directions[ROOMS + 2][STATIC + 2];
int iStaticGuards_5_Skills[ROOMS + 2][STATIC + 2];
int iStaticGuards_6_Mod[ROOMS + 2][STATIC + 2];
int iStaticGuards_7_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_8_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_9_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_10_Colors[ROOMS + 2][STATIC + 2];
int iStaticGuards_11_Number[ROOMS + 2][STATIC + 2];
int iStaticGuards_12_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_13_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_14_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_15_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_16_Type[ROOMS + 2][STATIC + 2];
int iStaticGuards_17_Hitpoints[ROOMS + 2][STATIC + 2];
int iStaticGuards_18_SkelAct1[ROOMS + 2][STATIC + 2];
int iStaticGuards_19_SkelAct2[ROOMS + 2][STATIC + 2];
int iStaticGuards_20_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_21_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_22_Unknown[ROOMS + 2][STATIC + 2];
int iStaticGuards_23_Unknown[ROOMS + 2][STATIC + 2];
int iDynamicGuards_Sets[ROOMS + 2];
int iDynamicGuards_Skill[ROOMS + 2];
int iDynamicGuards_Unknown1[ROOMS + 2];
int iDynamicGuards_Unknown2[ROOMS + 2];
int iDynamicGuards_1_SetNr[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_2_MaxTog[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_3_Row[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_4_Column[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_5_LatBefore[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_6_LatBetween[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_7_CanJump[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_8_PrinceRow[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_9_Amount[ROOMS + 2][DYNAMIC + 2];
int iDynamicGuards_10_Hitpoints[ROOMS + 2][DYNAMIC + 2];
int iCheckPoints[18 + 2];

unsigned int gamespeed;
Uint32 looptime;

int iDebug;
int iNoAudio;
int iNoChomp;
int iNoAnim;
int iNoController;
int iNoSave;
int iScreen;
char cCurType;
int iCurGuard;
int iCurRoom;
int iDownAt;
int iDownAtMap;
int iSelected;
int iOnTile;
int iOnTileNative;
int iOKOn;
int iYesOn;
int iNoOn;
int iCloseOn;
int iCloseCustomOn;
int iCloseGuardsOn;
int iCloseMusicOn;
int iCloseBackgroundOn;
int iCloseTemplateOn;
int iBackgroundOn;
int iTemplatesOn;
int iColorsOn;
int iKidOn;
int iCloseKidOn;
int iGuardsOn;
int iCustomOn;
int iCustomUseOn;
int iMusicOn;
int iEditLeftOn;
int iEndLeftOn;
int iEditRightOn;
int iEndRightOn;
int iMAllOn;
int iMNoneOn;
int iMLeftOn;
int iMRightOn;
int iMTopOn;
int iMMiddleOn;
int iMBottomOn;
int iMInvertOn;
int iNativeOn;
int iCloseNativeOn;
int iNativeTabOn;
int iHelpOK;
int iEXESave;
int iEXEDetails;
int iEXETab;
int iKidColorsSave;
int iKidColorsBW;
unsigned long luLevelSize;
unsigned long luLevelNr;
/***/
int arKidU1[8 + 2];
int arKidU2[8 + 2];
int arKidU3[8 + 2];
int arKidU4[8 + 2];
int arKidClr[8 + 2];
int arKidRoom[8 + 2];
int arKidPos[8 + 2];
int arKidDir[8 + 2];
/***/
unsigned long luNumberOfFields;
int iRoomConnections[32 + 2][4 + 2]; /*** PoP1 only uses 24. ***/
int iRoomConnectionsBroken[32 + 2][4 + 2]; /*** PoP1 only uses 24. ***/
int iBrokenRoomLinks;
int iBackA[24 + 2][30 + 2]; /*** Only for SNES. ***/
int iThingA[32 + 2][30 + 2]; /*** PoP1 only uses 24. ***/
int iModifierA[32 + 2][30 + 2][4 + 2]; /*** PoP1 only uses 24 and 1. ***/
unsigned char sBlock1[256 + 2];
unsigned char sBlock2[256 + 2];
unsigned char sBlock3[256 + 2];
unsigned char sBlock4[256 + 2];
int iBlock1A[32 + 2][30 + 2];
int iBlock2A[32 + 2][30 + 2];
int iBlock3A[32 + 2][30 + 2];
int iBlock4A[32 + 2][30 + 2];
int arSpecial254[3 + 2];
int arSpecial255[3 + 2];
int arAnim[255 + 2];
char sInformation[20 + 2][2 + 2][100 + 2]; /*** 20 times User Data ***/
int iInformationNr;
TTF_Font *font1;
TTF_Font *font2;
TTF_Font *font3;
TTF_Font *font4;
TTF_Font *font5;
SDL_Window *window;
SDL_Window *windowmap;
unsigned int iWindowID;
unsigned int iWindowMapID;
SDL_Renderer *ascreen;
SDL_Renderer *mscreen;
int iXPos, iYPos;
int iXPosMap, iYPosMap;
int iXPosMapMoveStart, iYPosMapMoveStart;
int iXPosMapMoveOffset, iYPosMapMoveOffset;
int iMovingMap;
int iDrawingOnMap;
int iMapMoved;
int iChanged;
int iChangeEvent;
int iChangeStuck;
int iChangeMarker;
int iChangeJumps;
int iChangeFrame;
int iChangePercent;
int iChangeWall;
int iChangeStal;
int iChangeBot;
int iChangeSym;
int iChangeCrk;
int iGuardSkill;
char sAuthor[MAX_OPTION];
char sStartLevel[MAX_OPTION];
char sCheat1[MAX_OPTION];
char sCheat2[MAX_OPTION];
int iRoomArray[32 + 1 + 2][32 + 2]; /*** PoP1 only uses 24. ***/
int iMovingRoom;
int iMovingOldX;
int iMovingOldY;
int iMovingNewX;
int iMovingNewY;
int iMovingNewBusy;
int iChangingBrokenRoom;
int iChangingBrokenSide;
int iScale;
int iZoom; /*** For the big area on the Map window. ***/
int iFullscreen;
int iChangeForeRand;
int iChangeForeMod;
int iChangeFore;
int iChangeBlock[4 + 2]; /*** PoP1 for SNES ***/
int iChangeMod[4 + 2]; /*** PoP1 only uses 1. ***/
int iIsCustom;
int iExtras;
int iLastThing;
int iLastModifier[4 + 2];
int iLastThingSNES[4 + 2];
int iLastModifierSNES;
int iThingACopyPaste[30 + 2];
int iModifierACopyPaste[30 + 2][4 + 2];
int iGuardACopyPaste[4 + 2];
unsigned char sMusicACopyPaste[30 + 2];
int iStaticGuardsACopyPaste[116 + 2];
int iDynamicGuardsACopyPaste[34 + 2];
int iBlockACopyPaste[30 + 2][4 + 2];
int iBackACopyPaste[30 + 2];
int iCopied;
int iStartLevel;
int iPoP1;
int iPoP2;
int iPoP1SNES;
int iPR;
int iOnPoP1;
int iOnPoP2;
int iOnPoP1SNES;
int iPoP1OrPoP2;
int iUsesNative;
int iEditPoP;
int iRooms;
int iRoomLinks;
int iTileW;
int iTileH;
int iPosShown;
int iPreLoaded;
int iNrToPreLoad;
int iCurrentBarHeight;
int iStartMilli;
int iHourglassFrame;
int iSandFrame;
int iStatusBarFrame;
int iFlameFrameDP;
int iChomperFrameDP;
int iChomped;
int iSwordFrameDP;
int iFlameFrameC;
int iFlameFrameT;
int iGuardTooltip, iGuardTooltipOld;
int iLvlWarning;
int iZSNES;
int iSkillTooltip, iSkillTooltipOld;
int iJaffarTooltip, iJaffarTooltipOld;
int iMod3Hi, iMod4Hi, iModHi, iTempHi;
SDL_Cursor *curArrow;
SDL_Cursor *curWait;
SDL_Cursor *curHand;
SDL_Cursor *curText;
int iEditNote;
int iEditGuardNr;
int iEditGuardDir;
int iEditGuardType;
int iLoadXML;
int iInfo;
int iSMCHeader;
int iModified;
int iReadFromFile;
unsigned char sStoredLevels[27 + 2][5000 + 2];
int iStoredLevelsSizes[27 + 2];
char sSNESFile[MAX_FILE + 2];
char sStatus[MAX_STATUS + 2], sStatusOld[MAX_STATUS + 2];
int iTooltip, iTooltipHeight;
char sNativeFile[3 + 2][MAX_FILE + 2];
int iNativeTab;
int iNativeOldTab, iNativeOldX, iNativeOldY;
int iNativeColor;
int iNativeMod;
char cStore[3 + 2];
unsigned int iActiveWindowID;
int iMapOpen;
int iMapHoverYes;
int iMapHoverRoom;
int iMapHoverTile;
int iMapShowNumbers;
int iMapEditPanel;
int iMapSelTile;
int iFoundDOSBox, iOnDOSBox;
int iFoundSDLPoP, iOnSDLPoP;
int iFoundMININIM, iOnMININIM;
int iPlaytest;
int iAutoUse, iAutoUseChk;
int iTextSave;
char arTextS[10 + 2][30 + 2][MAX_DATA + 2];
int iTextTab;
int iTextHover;
int iAutomaticSave;
int iAutomaticSel;
int iJumpTo;
int iJumpSel;
char sLatest[MAX_TEXT + 2];
int iEventHover;
int iUserCode;
int iIgnoreTab;

/*** controller ***/
SDL_GameController *controller;
SDL_Joystick *joystick;
SDL_Haptic *haptic;
char sControllerName[MAX_CON + 2];
int iController;
Uint32 joyleft;
Uint32 joyright;
Uint32 joyup;
Uint32 joydown;
Uint32 trigleft;
Uint32 trigright;

/*** multiplayer ***/
int iNrPlayers;
int iKidHover;
int arLiveX[8 + 2];
int arLiveY[8 + 2];

/*** hex editor ***/
int iCloseHexEditorOn;
int iHexOffset;
int iHitOffset;
int iHitNrChars;
int iHexCursor;
unsigned char sHexBytes[64 + 2];
char arTextH[2 + 2][MAX_DATA + 2];
char cHexInput;
Uint32 saved;

/*** exe ***/
char sEXEType[MAX_EXETYPE + 2];
int iEXEType;
int iEXEPacked;
/*** The order is always: p0, u0, p3, u3, p4, u4 ***/
static const unsigned long arStartTimeHit[6] =
	{ 0X04A1F, 0X060CF, 0X04E9F, 0X055DF, 0X0495B, 0X05A8B };
int iEXEMinutesLeft;
int iEXEHitPoints;
static const unsigned long arAllowTr[6] =
	{ 0X0910D, 0X0A7BD, 0X095BA, 0X09CFA, 0X09076, 0X0A1A6 };
int iEXETriggering;
static const unsigned long arGuardHit[6] =
	{ 0X1B8A8, 0X1D46A, 0X1C6C5, 0X1D35C, 0X18A97, 0X19D06 };
int iEXEGuard[16 + 2];
static const unsigned long arSword[6] =
	{ 0X04B25, 0X061D5, 0X04FA5, 0X056E5, 0X04A61, 0X05B91 };
int iEXESword;
static const unsigned long arWin[6] =
	{ 0X011D8, 0X02888, 0X01393, 0X01AD3, 0X01323, 0X02453 };
int iEXEWinLevel;
int iEXEWinRoom;
static const unsigned long arBaseSpeed[6] =
	{ 0X4F01, 0X65B1, 0X5389, 0X5AC9, 0X4E45, 0X5F75 };
int iEXEBaseSpeed;
static const unsigned long arFightSpeed[6] =
	{ 0X4EF9, 0X65A9, 0X5381, 0X5AC1, 0X4E3D, 0X5F6D };
int iEXEFightSpeed;
static const unsigned long arChomperSpeed[6] =
	{ 0X8BBD, 0XA26D, 0X906D, 0X97AD, 0X8B29, 0X9C59 };
int iEXEChomperSpeed;
static const unsigned long arEnvironment[6] =
	{ 0X1ACE8, 0X1C840, 0X1B9AC, 0X1C5C4, 0X17D4A, 0X18F3A };
static const int arDefaultEnv[16] =
	{ 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0 };
int iEXEEnv[16 + 2];
static const unsigned long arGuardRes[6] =
	{ 0X00000, 0X1C964, 0X00000, 0X1C702, 0X00000, 0X1905E };
int iEXEGRes[16 + 2];
static const int arDefaultGRes[16] =
	{ 0, 0, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 4, 3, 65535, 65535 };
static const unsigned long arImmortal[6] =
	{ 0X03A16, 0X050C6, 0X00000, 0X00000, 0X00000, 0X00000 };
static const unsigned long arResources[6] =
	{ 0X00000, 0X1C782, 0X00000, 0X1C4F6, 0X00000, 0X18E70 };
/***/
static const unsigned long ulGuardSNES[GUARD_TABS] =
	{ 0X8022, 0X8035, 0X8048, 0X805B, 0X806E, 0X8081, 0X80A7, 0X75A0, 0XBF84 };
int iEXEGuardSNES[GUARD_TABS + 2][18 + 2];
static const unsigned long ulMusicSNES = 0X1145C;
int iEXEMusicSNESValue;
int iEXEMusicSNESOnOff;
static const unsigned long arDefaultMusicValuesJP[27] =
	{ 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x05, 0x05, 0x06, 0x07, 0x06, 0x08, 0x09, 0x0D, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const unsigned long arDefaultMusicValuesUSandEU[27] =
	{ 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x03, 0x03, 0x03, 0x04, 0x05, 0x05, 0x06, 0x06, 0x06, 0x07, 0x08, 0x07, 0x09, 0x0A, 0x0E, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01 };
static const unsigned long ulHazeSNES = 0X4DEF;
int iEXEHazeSNESValue;
int iEXEHazeSNESOnOff;
static const unsigned long ulDefaultHazeValue = 0x09;
static const unsigned long ulHitSNES = 0XED4B;
static const unsigned long ulSwordSNES = 0XEE0D;
int iEXEDemoPlayableS;
static const unsigned long ulMirrorLevelRoomChk = 0X9A79;
static const unsigned long ulMirrorRowColumnChk = 0X9A87;
/***/
static const unsigned long ulEnvL = 0X36EE; /*** Level type. ***/
static const unsigned long ulEnvO = 0XED08; /*** Loose, buttons, doors. ***/
static const unsigned long ulEnvF = 0XC54E; /*** Flame addresses. ***/
int iEXEEnvL[27 + 2];
int iEXEEnvO[27 + 2];
int iEXEEnvF[27 + 2];
/***/
static const unsigned long ulWarpRoom = 0X856E;
static const unsigned long ulWarpFace = 0X8573;
static const unsigned long ulWarpCol = 0X8578;
static const unsigned long ulWarpRow = 0X8586;
int iEXEWarpRoom;
int iEXEWarpFace;
int iEXEWarpCol;
int iEXEWarpRow;
/***/
static const unsigned long ulKidColorNormal = 0X73E6;
static const unsigned long ulKidColorLava = 0X73EB;
static const unsigned long ulKidColorFloat = 0X7443;
int iKidColorNormal;
int iKidColorLava;
int iKidColorFloat;
/***/
static const char *sSongNames[34] = { "Konami logo", "blue and training (levels 1-3 and 23-27)", "fawn (levels 4-6)", "silver (levels 7-9)", "lava with heat haze (level 10)", "lava without heat haze (levels 11 and 12)", "green (levels 13-15)", "umber without boss (levels 16 and 18)", "umber with boss (level 17)", "marble (level 19)", "hallway (level 20)", "kali idol battle", "guard battle", "boss battle", "jaffar (level 21)", "title screen", "menu", "princess", "ending", "memories", "credits", "death, by sword", "death, not by sword", "sword pickup", "life potion", "girl and shadow intro", "?", "level exit open", "level cleared", "guard defeated", "jaffar intro", "heal potion", "too late", "boss intro" };

/*** exe, F3 ***/
static const unsigned long arLooseDelayA[6] =
	{ 0X9536, 0XABE6, 0X00000, 0X00000, 0X00000, 0X00000 };
static const unsigned long arLooseDelayB[6] =
	{ 0XAE1D, 0XC4CD, 0XB2C9, 0XBA09, 0XAD85, 0XBEB5 };
int iEXELooseDelayA;
int iEXELooseDelayB;
static const unsigned long arLooseClimbing[6] =
	{ 0X7E4D, 0X94FD, 0X82F1, 0X8A31, 0X7DAD, 0X8EDD };
int iEXELooseClimbing;
/***/
static const unsigned long arShadowStart[6] =
	{ 0X1B8B8, 0X1D47A, 0X1C6D5, 0X1D36C, 0X18AA7, 0X19D16 };
int iEXEShadowStartF5, iEXEShadowStartF6, iEXEShadowStartF12;
int iEXEShadowStartX5, iEXEShadowStartX6, iEXEShadowStartX12;
int iEXEShadowStartY5, iEXEShadowStartY6, iEXEShadowStartY12;
int iEXEShadowStartD5, iEXEShadowStartD6, iEXEShadowStartD12;
int iEXEShadowStartC5, iEXEShadowStartC6, iEXEShadowStartC12;
int iEXEShadowStartR5, iEXEShadowStartR6, iEXEShadowStartR12;
int iEXEShadowStartA5, iEXEShadowStartA6, iEXEShadowStartA12;
int iEXEShadowStartN5, iEXEShadowStartN6, iEXEShadowStartN12;
static const unsigned long arShadowMoves[6] =
	{ 0X1DB82, 0X1D496, 0X1C6EF, 0X1D388, 0X18AC1, 0X19D32 };
int iEXEShadowMovesTime[7 + 2];
int iEXEShadowMovesAction[7 + 2];
static const unsigned long arPrinceMoves[6] =
	{ 0X1B8F2, 0X1D4B6, 0X1C70F, 0X1D3A8, 0X18AE1, 0X19D52 };
int iEXEPrinceMovesTime[24 + 2];
int iEXEPrinceMovesAction[24 + 2];

/*** exe, F4 ***/
static const unsigned long arDemoPlayableD1[6] =
	{ 0X7BAA, 0X925A, 0X804E, 0X878E, 0X7B0A, 0X8C3A };
static const unsigned long arDemoPlayableD2[6] =
	{ 0X6E2, 0X1D92, 0X7B6, 0XEF6, 0X77A, 0X18AA };
int iEXEDemoPlayableD;
static const unsigned long arDemoPrinceHP[6] =
	{ 0X4C28, 0X62D8, 0X50B0, 0X57F0, 0X4B6C, 0X5C9C };
int iEXEDemoPrinceHP;
static const unsigned long arDemoEndingRoom[6] =
	{ 0XB40, 0X21F0, 0XC25, 0X1365, 0XBE9, 0X1D19 };
int iEXEDemoEndingRoom;
static const unsigned long arDemoPrinceSkill[6] =
	{ 0x7C1C, 0x92CC, 0x80C0, 0x8800, 0x7B7C, 0x8CAC };
int iEXEDemoPrinceSkill;
static const unsigned long arDemoGuardSkill[6] =
	{ 0x7C27, 0x92D7, 0x80CB, 0x880B, 0x7B87, 0x8CB7 };
int iEXEDemoGuardSkill;
/***/
static const unsigned long arDisable2[6] =
	{ 0X0, 0X2DD5, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable2;
static const unsigned long arDisable4[6] =
	{ 0X0, 0X2DE1, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable4;
static const unsigned long arDisable5[6] =
	{ 0X0, 0X2DCE, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable5;
static const unsigned long arDisable6[6] =
	{ 0X0, 0X2DF6, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable6;
static const unsigned long arDisable7A[6] =
	{ 0X0, 0X2DB9, 0X0, 0X0, 0X0, 0X0 };
static const unsigned long arDisable7B[6] =
	{ 0X0, 0X2DE8, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable7;
static const unsigned long arDisable8[6] =
	{ 0X0, 0X2DB2, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable8;
static const unsigned long arDisable9A[6] =
	{ 0X0, 0X2DC0, 0X0, 0X0, 0X0, 0X0 };
static const unsigned long arDisable9B[6] =
	{ 0X0, 0X2DFD, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisable9;
static const unsigned long arDisableS[6] =
	{ 0X0, 0X2E17, 0X0, 0X0, 0X0, 0X0 };
int iEXEDisableS;
static const unsigned long arAutorun[6] =
	{ 0X0, 0X2DE4, 0X0, 0X0, 0X0, 0X0 };
int iEXEAutorun;
static const unsigned long arQuicker[6] =
	{ 0X0, 0X7818, 0X0, 0X0, 0X0, 0X0 };
int iEXEQuicker;

/*** exe, F5 ***/
static const unsigned long ulSkelCont = 0x85A9;
int iEXESkelCont;

/*** exe, PoP2 ***/
static const int arDefaultEnvPoP2[29] =
	{ -1, 5, 1, 3, 3, 3, 4, 4, 4, 4, 2, 2, 2, 2, 6, 5, 1, 3, 3, 3, 4, 4, 4, 4, 2, 2, 2, 2, 6 };
int iEXEEnvPoP2;
static const int arDefaultGuardTypePoP2[29] =
	{ -1, 0, 255, 2, 2, 2, 5, 5, 5, 5, 7, 7, 7, 7, 0, 0, 255, 2, 255, 2, 5, 5, 5, 5, 7, 7, 255, 255, 255 };
int iEXEGuardTypePoP2;

/*** smc ***/
/*** The order is always: JP, US, EU ***/
/***
static const unsigned long arSkipIntro[3] =
	{ 0X00000, 0X1801C, 0X1801C };
***/
static const unsigned long arSkipToDemo[3] =
	{ 0X18018, 0X18018, 0X18018 };
/***
static const unsigned long arCurrentLevel[3] =
	{ 0X00000, 0X19C3A, 0X19C3A };
static const unsigned long arCurrentTraining[3] =
	{ 0X00000, 0X011AC, 0X011AC };
***/
static const unsigned long arDemoLevel[3] =
	{ 0X18072, 0X1806C, 0X1806C };
static const unsigned long arDemoPlayableS1[3] =
	{ 0X0A0A2, 0X0A0A2, 0X0A0A2 };
static const unsigned long arDemoPlayableS2[3] =
	{ 0X0E835, 0X0E835, 0X0E835 };

/*** SNES guard defaults. ***/
static const char *sGuardNamesSNES[18] =
	{ "dead pink guard", "silver skeleton", "bronze skeleton", "golden skeleton", "female", "fat", "shadow", "green guard", "greenish blue guard", "blue guard", "red guard", "purple guard", "blue faced guard", "red knight", "blue knight", "sinbad kali idol", "jaffar", "dead white guard" };
static const int arDefaultGuard[][18] = {
	{ 0x00, 0x4B, 0x4B, 0x4B, 0x3C, 0x3C, 0xDC, 0x4B, 0x64, 0x4B, 0x4B, 0x4B, 0x32, 0x3C, 0x3C, 0x00, 0x28, 0x00 },
	{ 0x00, 0x05, 0x05, 0x05, 0xFF, 0xFF, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x05, 0xAF, 0xFF, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0x00, 0xC8, 0xC8, 0xC8, 0xFF, 0xFF, 0xFA, 0x00, 0x96, 0x96, 0xC8, 0xC8, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0x00 },
	{ 0x00, 0x64, 0x64, 0x64, 0x91, 0x91, 0xFA, 0x00, 0x4B, 0x4B, 0x64, 0x64, 0x91, 0x91, 0xAF, 0x00, 0xFF, 0x00 },
	{ 0x00, 0xC8, 0xC8, 0xC8, 0xFF, 0xFF, 0x00, 0xFF, 0xC8, 0xC8, 0xC8, 0xFF, 0xFF, 0xFF, 0x64, 0x00, 0x64, 0x00 },
	{ 0x00, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x00, 0x14, 0x00 },
	{ 0x00, 0xFF, 0x01, 0x09, 0x06, 0x08, 0x04, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0A, 0x0C, 0x0D, 0x0F, 0x00 },
	{ 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15 },
	{ 1, 2, 2, 2, 3, 4, 5, 1, 1, 1, 1, 1, 1, 6, 6, 7, 8, 1 }
};

/*** PoP1 for DOS guard details. ***/
static const unsigned long arGuardDetails[][6] = {
	{ 0X1B80E, 0X1D3C2, 0X1C62B, 0X1D2B4, 0X189FD, 0X19C5E }, /*** strike prob. ***/
	{ 0X1B826, 0X1D3DA, 0X1C643, 0X1D2CC, 0X18A15, 0X19C76 }, /*** re-strike prob. ***/
	{ 0X1B83E, 0X1D3F2, 0X1C65B, 0X1D2E4, 0X18A2D, 0X19C8E }, /*** block prob. ***/
	{ 0X1B856, 0X1D40A, 0X1C673, 0X1D2FC, 0X18A45, 0X19CA6 }, /*** imp. block prob. ***/
	{ 0X1B86E, 0X1D422, 0X1C68B, 0X1D314, 0X18A5D, 0X19CBE }, /*** advance prob. ***/
	{ 0X00000, 0X1D43A, 0X00000, 0X1D32C, 0X00000, 0X19CD6 }, /*** refractory timer ***/
	{ 0X00000, 0X1D452, 0X00000, 0X1D344, 0X00000, 0X19CEE } /*** extra hit points ***/
};
int iEXEGuardD[7 + 2][12 + 2];
static const int arDefaultGuardD0[][12] = {
	{ 61, 100, 61, 61, 61, 40, 100, 220, 0, 48, 32, 48 },
	{ 0, 0, 0, 5, 5, 175, 16, 8, 0, 255, 255, 150 },
	{ 0, 150, 150, 200, 200, 255, 200, 250, 0, 255, 255, 255 },
	{ 0, 61, 61, 100, 100, 145, 100, 250, 0, 145, 255, 175 },
	{ 255, 200, 200, 200, 255, 255, 200, 0, 0, 255, 100, 100 },
	{ 16, 16, 16, 16, 8, 8, 8, 8, 0, 8, 0, 0 },
	{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 }
};
static const int arDefaultGuardD1[][12] = {
	{ 75, 100, 75, 75, 75, 50, 100, 220, 0, 60, 40, 60 },
	{ 0, 0, 0, 5, 5, 175, 20, 10, 0, 255, 255, 150 },
	{ 0, 150, 150, 200, 200, 255, 200, 250, 0, 255, 255, 255 },
	{ 0, 75, 75, 100, 100, 145, 100, 250, 0, 145, 255, 175 },
	{ 255, 200, 200, 200, 255, 255, 200, 0, 0, 255, 100, 100 },
	{ 20, 20, 20, 20, 10, 10, 10, 10, 0, 10, 0, 0 },
	{ 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 }
};

static const char *arTextTab[][30] = {
	{
		" In the Sultan's absence the   ",
		" Grand Vizier JAFFAR rules with",
		" an iron fist of tyranny.",
		"",
		" Only one obstacle remains     ",
		" between Jaffar and the throne,",
		" the Sultan's beautiful young  ",
		" daughter...",
		"",
		" An adventurer from a foreign  ",
		" land has won the Princess's   ",
		" heart.",
		"",
		"  On Jaffar's orders, he is    ",
		"  arrested and thrown into the ",
		"  Sultan's dungeons.",
		"",
		" Jaffar gives her a choice and ",
		" two hours to decide.          ",
		" Marry him ... or die.         ",
		"",
		" Locked in her room high in    ",
		" the palace tower,the Princess ",
		" rests all her hopes on the    ",
		" brave youth she loves.",
		"",
		"  Little does she know that   ",
		"  he is already a prisoner in ",
		"  Jaffar's dungeons...",
		""
	},
	{
		" The tyrant Jaffar lies        ",
		" defeated, his power shattered.",
		" Throughout the land the people",
		" of Persia hail their Princess ",
		" ... and the brave youth who   ",
		" saved her from the force of   ",
		" darkness.",
		" No longer a stranger,he shall ",
		" from this day forth be known  ",
		" as ... PRINCE OF PERSIA.",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""
	},
	{
		"           Producer",
		"       Keiichi Onogi",
		"",
		"           Director",
		"       Keisuke Yasaka",
		"",
		"          Programming",
		"       Seiichi Ikiuo",
		"                (Arsys)",
		"     Katsunori Yoshimura",
		"                (Arsys)",
		"", "", "", "",
		"      Art and Animations",
		"      Takaharu Matsuo",
		"                (Arsys)",
		"       Kenichi Yaguchi",
		"                (Arsys)",
		"",
		"             Music",
		"       Toshiya Yamanaka",
		"                (Arsys)",
		"       Tetsuya Nakano",
		"                (Arsys)",
		"", "", "", ""
	},
	{
		"         Thanks to ....",
		"          Akio Matsuda",
		"         Taiji Hida",
		"   and all staffs of ",
		"",
		"",
		"     Nippon Imageworks Inc.",
		"",
		"            Marketing",
		"        Masaki Uchida",
		"        Kyohko Katagiri",
		"       Yasuaki Yokoe",
		"           Jun Mimura",
		"", "",
		"       Exective Producer",
		"      Yasumasa Shirakura",
		"",
		"         Original Game",
		"        Jordan Mechner",
		"", "", "", "", "", "", "", "", "", ""
	},
	{
		"   MENU",
		" GAME START",
		" CONTINUE",
		" TRAINING",
		" BEST TIME",
		" OPTION",
		"",
		"   MENU   ",
		" BEST TIME",
		" PASSWORD ",
		" GAME END ",
		" OPTION   ",
		"", "", "",
		" STATUS  ",
		"LV  TIME ",
		"00 ---:--",
		"", "", "", "", "", "", "", "", "", "", "", ""
	},
	{
		"   ENTER PASSWORD",
		"  PASSWORD:        ",
		"  1 2 3 4 5 6 7 8 9",
		"  B C D F G H J K L",
		"  M N P Q R S T V W",
		"  X Y Z + ! - - - -",
		" CANCEL  OK",
		"", "", "", "", "", "", "", "",
		"123456789BCDFGHJKLMNPQRSTVWXYZ+!----",
		"BTL3GY7Q9CVM4HZ8R+DWN5J12S!FXP6K",
		"", "", "", "", "", "", "", "", "", "", "", "", ""
	},
	{
		"     BEST TIME     ",
		"LV  TIME  LV  TIME ",
		" 1 ---:-- 11 ---:--",
		" 2 ---:-- 12 ---:--",
		" 3 ---:-- 13 ---:--",
		" 4 ---:-- 14 ---:--",
		" 5 ---:-- 15 ---:--",
		" 6 ---:-- 16 ---:--",
		" 7 ---:-- 17 ---:--",
		" 8 ---:-- 18 ---:--",
		" 9 ---:-- 19 ---:--",
		"10 ---:-- 20 ---:--",
		"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""
	},
	{
		"        OPTION",
		"      SOUND ",
		"     REPEAT ",
		" OK  CANCEL  INITIALIZE",
		"",
		"------------",
		"CROUCH      ",
		"SPECIAL     ",
		"JUMP FORWARD",
		"HANG        ",
		"TIME        ",
		"KILL        ",
		"", "", "",
		"------",
		"STRIKE",
		"BLOCK ",
		"STEREO",
		"MONO  ",
		"",
		"ON ",
		"OFF",
		"", "", "", "", "", "", ""
	},
	{
		"SPCCMD!",
		"",
		" LEVEL SELECT",
		" SOUND SELECT",
		" BOOST METER",
		"",
		" LEVEL ",
		"",
		" SOUND ",
		"", "", "", "", "", "",
		"BRNGBB9",
		"",
		"A",
		"B",
		"X",
		"Y",
		"L",
		"R  345678901234  789012",
		"", "", "", "", "", "", ""
	},
	{
		"LEVEL ",
		"TRAINING ",
		"",
		"TRAINING !!",
		"",
		"TRAINING MODE !!",
		"",
		"Press button to continue",
		"",
		"TIME UP",
		"",
		"GAME OVER",
		"",
		"CLEAR TIME  ---:--",
		"PASSWORD   ",
		"",
		"PASSWORD  ",
		"",
		"PRINCE OF PERSIA      ",
		"",
		"\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x00", /*** MINUTES LEFT ***/
		"\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9A\x9B\x00", /*** SEC. LEFT ***/
		"\x84\x20\x1E\x1F", /*** THE END ***/
		"", "", "", "", "", "", ""
	}
};

static const int arTextOffsets[][30] = {
	{ 0x18258, 0x18279, 0x1829A, 0x00, 0x182B6, 0x182D7, 0x182F8, 0x18319, 0x00, 0x18659, 0x1867A, 0x1869B, 0x00, 0x189C9, 0x189EA, 0x18A0B, 0x00, 0x194AC, 0x194CD, 0x194EE, 0x00, 0x19511, 0x19532, 0x19553, 0x19574, 0x00, 0x1958E, 0x195AE, 0x195CE, 0x00 },
	{ 0x1BD36, 0x1BD58, 0x1BD7A, 0x1BD9C, 0x1BDBE, 0x1BDE0, 0x1BE02, 0x1BE0F, 0x1BE31, 0x1BE53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x1B863, 0x1B87A, 0x00, 0x1B896, 0x1B8AD, 0x00, 0x1B8CA, 0x1B8E3, 0x1B8F9, 0x1B914, 0x1B92E, 0x00, 0x00, 0x00, 0x00, 0x1B94D, 0x1B969, 0x1B980, 0x1B99B, 0x1B9B3, 0x00, 0x1B9D2, 0x1B9E8, 0x1BA01, 0x1BA1C, 0x1BA33, 0x00, 0x00, 0x00, 0x00 },
	{ 0x1BA52, 0x1BA6D, 0x1BA87, 0x1BA9E, 0x00, 0x00, 0x1BAC7, 0x00, 0x1BAEA, 0x1BB03, 0x1BB1C, 0x1BB37, 0x1BB4F, 0x00, 0x00, 0x1BB6C, 0x1BB88, 0x00, 0x1BBA6, 0x1BBC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x125F, 0x1269, 0x1277, 0x1283, 0x128F, 0x129C, 0x00, 0x1109, 0x1116, 0x1123, 0x1130, 0x113D, 0x00, 0x00, 0x00, 0x10A5, 0x10B1, 0x10BD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x154DA, 0x154EE, 0x1551A, 0x15530, 0x15546, 0x1555C, 0x15577, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15583, 0x15C38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x156DF, 0x156F5, 0x1570B, 0x15721, 0x15737, 0x1574D, 0x15763, 0x15779, 0x1578F, 0x157A5, 0x157BB, 0x157D1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x161E0, 0x1621F, 0x1622E, 0x1623D, 0x00, 0x16255, 0x16262, 0x1626F, 0x1627C, 0x16289, 0x16296, 0x162A3, 0x00, 0x00, 0x00, 0x162B0, 0x162B7, 0x162BE, 0x162C8, 0x162D2, 0x00, 0x162DC, 0x162E3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x15497, 0x00, 0x16615, 0x16625, 0x16635, 0x00, 0x16768, 0x00, 0x16966, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15DF2, 0x00, 0x161F1, 0x161F5, 0x161F9, 0x161FD, 0x16201, 0x16205, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0xCAE8, 0xCAEF, 0x00, 0xCA2F, 0x00, 0x10F5, 0x00, 0xCB1D, 0x00, 0xCA27, 0x00, 0x14B9A, 0x00, 0x15D0E, 0x15D23, 0x00, 0x15D7F, 0x00, 0x7FC0, 0x00, 0xCA0E, 0xCA1A, 0x1BC01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 }
};

/*** automatic ***/
int iAutomaticSNESKeys[459 + 2];
int iAutomaticSNESFrames[459 + 2];
static const int arAutomaticXY[][2] = {
	              {  49,  26 }, {  75,  26 }, { 101,  26 }, { 127,  26 },
	{ 153,  26 }, { 179,  26 }, { 205,  26 }, { 231,  26 }, { 257,  26 },
	{ 283,  26 }, { 309,  26 }, { 335,  26 }, { 361,  26 }, { 387,  26 },
	{ 413,  26 }, { 439,  26 }, { 465,  26 }, { 491,  26 }, { 517,  26 },
	{ 543,  26 }, { 569,  26 }, { 595,  26 }, { 621,  26 }, { 647,  26 },

	{  23,  46 }, {  49,  46 }, {  75,  46 }, { 101,  46 }, { 127,  46 },
	{ 153,  46 }, { 179,  46 }, { 205,  46 }, { 231,  46 }, { 257,  46 },
	{ 283,  46 }, { 309,  46 }, { 335,  46 }, { 361,  46 }, { 387,  46 },
	{ 413,  46 }, { 439,  46 }, { 465,  46 }, { 491,  46 }, { 517,  46 },
	{ 543,  46 }, { 569,  46 }, { 595,  46 }, { 621,  46 }, { 647,  46 },

	{  23,  66 }, {  49,  66 }, {  75,  66 }, { 101,  66 }, { 127,  66 },
	{ 153,  66 }, { 179,  66 }, { 205,  66 }, { 231,  66 }, { 257,  66 },
	{ 283,  66 }, { 309,  66 }, { 335,  66 }, { 361,  66 }, { 387,  66 },
	{ 413,  66 }, { 439,  66 }, { 465,  66 }, { 491,  66 }, { 517,  66 },
	{ 543,  66 }, { 569,  66 }, { 595,  66 }, { 621,  66 }, { 647,  66 },

	{  23,  86 }, {  49,  86 }, {  75,  86 }, { 101,  86 }, { 127,  86 },
	{ 153,  86 }, { 179,  86 }, { 205,  86 }, { 231,  86 }, { 257,  86 },
	{ 283,  86 }, { 309,  86 }, { 335,  86 }, { 361,  86 }, { 387,  86 },
	{ 413,  86 }, { 439,  86 }, { 465,  86 }, { 491,  86 }, { 517,  86 },
	{ 543,  86 }, { 569,  86 }, { 595,  86 }, { 621,  86 }, { 647,  86 },

	{  23, 106 }, {  49, 106 }, {  75, 106 }, { 101, 106 }, { 127, 106 },
	{ 153, 106 }, { 179, 106 }, { 205, 106 }, { 231, 106 }, { 257, 106 },
	{ 283, 106 }, { 309, 106 }, { 335, 106 }, { 361, 106 }, { 387, 106 },
	{ 413, 106 }, { 439, 106 }, { 465, 106 }, { 491, 106 }, { 517, 106 },
	{ 543, 106 }, { 569, 106 }, { 595, 106 }, { 621, 106 }, { 647, 106 },

	{  23, 126 }, {  49, 126 }, {  75, 126 }, { 101, 126 }, { 127, 126 },
	{ 153, 126 }, { 179, 126 }, { 205, 126 }, { 231, 126 }, { 257, 126 },
	{ 283, 126 }, { 309, 126 }, { 335, 126 }, { 361, 126 }, { 387, 126 },
	{ 413, 126 }, { 439, 126 }, { 465, 126 }, { 491, 126 }, { 517, 126 },
	{ 543, 126 }, { 569, 126 }, { 595, 126 }, { 621, 126 }, { 647, 126 },

	{  23, 146 }, {  49, 146 }, {  75, 146 }, { 101, 146 }, { 127, 146 },
	{ 153, 146 }, { 179, 146 }, { 205, 146 }, { 231, 146 }, { 257, 146 },
	{ 283, 146 }, { 309, 146 }, { 335, 146 }, { 361, 146 }, { 387, 146 },
	{ 413, 146 }, { 439, 146 }, { 465, 146 }, { 491, 146 }, { 517, 146 },
	{ 543, 146 }, { 569, 146 }, { 595, 146 }, { 621, 146 }, { 647, 146 },

	{  23, 166 }, {  49, 166 }, {  75, 166 }, { 101, 166 }, { 127, 166 },
	{ 153, 166 }, { 179, 166 }, { 205, 166 }, { 231, 166 }, { 257, 166 },
	{ 283, 166 }, { 309, 166 }, { 335, 166 }, { 361, 166 }, { 387, 166 },
	{ 413, 166 }, { 439, 166 }, { 465, 166 }, { 491, 166 }, { 517, 166 },
	{ 543, 166 }, { 569, 166 }, { 595, 166 }, { 621, 166 }, { 647, 166 },

	{  23, 186 }, {  49, 186 }, {  75, 186 }, { 101, 186 }, { 127, 186 },
	{ 153, 186 }, { 179, 186 }, { 205, 186 }, { 231, 186 }, { 257, 186 },
	{ 283, 186 }, { 309, 186 }, { 335, 186 }, { 361, 186 }, { 387, 186 },
	{ 413, 186 }, { 439, 186 }, { 465, 186 }, { 491, 186 }, { 517, 186 },
	{ 543, 186 }, { 569, 186 }, { 595, 186 }, { 621, 186 }, { 647, 186 },

	{  23, 206 }, {  49, 206 }, {  75, 206 }, { 101, 206 }, { 127, 206 },
	{ 153, 206 }, { 179, 206 }, { 205, 206 }, { 231, 206 }, { 257, 206 },
	{ 283, 206 }, { 309, 206 }, { 335, 206 }, { 361, 206 }, { 387, 206 },
	{ 413, 206 }, { 439, 206 }, { 465, 206 }, { 491, 206 }, { 517, 206 },
	{ 543, 206 }, { 569, 206 }, { 595, 206 }, { 621, 206 }, { 647, 206 },

	{  23, 226 }, {  49, 226 }, {  75, 226 }, { 101, 226 }, { 127, 226 },
	{ 153, 226 }, { 179, 226 }, { 205, 226 }, { 231, 226 }, { 257, 226 },
	{ 283, 226 }, { 309, 226 }, { 335, 226 }, { 361, 226 }, { 387, 226 },
	{ 413, 226 }, { 439, 226 }, { 465, 226 }, { 491, 226 }, { 517, 226 },
	{ 543, 226 }, { 569, 226 }, { 595, 226 }, { 621, 226 }, { 647, 226 },

	{  23, 246 }, {  49, 246 }, {  75, 246 }, { 101, 246 }, { 127, 246 },
	{ 153, 246 }, { 179, 246 }, { 205, 246 }, { 231, 246 }, { 257, 246 },
	{ 283, 246 }, { 309, 246 }, { 335, 246 }, { 361, 246 }, { 387, 246 },
	{ 413, 246 }, { 439, 246 }, { 465, 246 }, { 491, 246 }, { 517, 246 },
	{ 543, 246 }, { 569, 246 }, { 595, 246 }, { 621, 246 }, { 647, 246 },

	{  23, 266 }, {  49, 266 }, {  75, 266 }, { 101, 266 }, { 127, 266 },
	{ 153, 266 }, { 179, 266 }, { 205, 266 }, { 231, 266 }, { 257, 266 },
	{ 283, 266 }, { 309, 266 }, { 335, 266 }, { 361, 266 }, { 387, 266 },
	{ 413, 266 }, { 439, 266 }, { 465, 266 }, { 491, 266 }, { 517, 266 },
	{ 543, 266 }, { 569, 266 }, { 595, 266 }, { 621, 266 }, { 647, 266 },

	{  23, 286 }, {  49, 286 }, {  75, 286 }, { 101, 286 }, { 127, 286 },
	{ 153, 286 }, { 179, 286 }, { 205, 286 }, { 231, 286 }, { 257, 286 },
	{ 283, 286 }, { 309, 286 }, { 335, 286 }, { 361, 286 }, { 387, 286 },
	{ 413, 286 }, { 439, 286 }, { 465, 286 }, { 491, 286 }, { 517, 286 },
	{ 543, 286 }, { 569, 286 }, { 595, 286 }, { 621, 286 }, { 647, 286 },

	{  23, 306 }, {  49, 306 }, {  75, 306 },               { 127, 306 },
	{ 153, 306 }, { 179, 306 }, { 205, 306 }, { 231, 306 },
	{ 283, 306 }, { 309, 306 }, { 335, 306 }, { 361, 306 }, { 387, 306 },
	{ 413, 306 },               { 465, 306 }, { 491, 306 }, { 517, 306 },
	{ 543, 306 }, { 569, 306 }, { 595, 306 }, { 621, 306 }, { 647, 306 },

	{  23, 326 }, {  49, 326 }, {  75, 326 }, { 101, 326 }, { 127, 326 },
	{ 153, 326 },               { 205, 326 }, { 231, 326 },
	{ 283, 326 }, { 309, 326 }, { 335, 326 }, { 361, 326 }, { 387, 326 },
	{ 413, 326 }, { 439, 326 }, { 465, 326 }, { 491, 326 }, { 517, 326 },
	{ 543, 326 }, { 569, 326 }, { 595, 326 }, { 621, 326 }, { 647, 326 },

	{  23, 346 }, {  49, 346 }, {  75, 346 }, { 101, 346 }, { 127, 346 },
	{ 153, 346 },               { 205, 346 }, { 231, 346 }, { 257, 346 },
	{ 283, 346 }, { 309, 346 }, { 335, 346 }, { 361, 346 }, { 387, 346 },
	{ 413, 346 }, { 439, 346 }, { 465, 346 },               { 517, 346 },
	{ 543, 346 }, { 569, 346 }, { 595, 346 }, { 621, 346 }, { 647, 346 },

	{  23, 366 }, {  49, 366 }, {  75, 366 }, { 101, 366 }, { 127, 366 },
	{ 153, 366 }, { 179, 366 }, { 205, 366 }, { 231, 366 }, { 257, 366 },
	              { 309, 366 }, { 335, 366 }, { 361, 366 }, { 387, 366 },
	{ 413, 366 }, { 439, 366 }, { 465, 366 }, { 491, 366 }, { 517, 366 },
	{ 543, 366 }, { 569, 366 }, { 595, 366 }, { 621, 366 }, { 647, 366 },

	{  23, 386 }, {  49, 386 },               { 101, 386 }, { 127, 386 },
	{ 153, 386 }, { 179, 386 }, { 205, 386 }, { 231, 386 }, { 257, 386 },
	{ 283, 386 }, { 309, 386 }, { 335, 386 }, { 361, 386 }, { 387, 386 },
	{ 413, 386 }, { 439, 386 },               { 491, 386 }, { 517, 386 }
};

/*** Used with CurTypeBlocks(). ***/
int iPillarOne;
int iWallOne;
int iGateOne;
int iLavaOne;
int iDoorTopOne;
int iTorchOnSpaceOne;
int iTorchOnSpaceTwo;
int iTorchOnSpaceThree;
int iTorchOFThree;
int iSpaceTwo[5 + 2];
int iFloorTwo[5 + 2];
int iPillarTwo[5 + 2];
int iWallTwo[5 + 2];
int iGateTwo[5 + 2];
int iTorchOFTwo[5 + 2];
int iDoorTopTwo[5 + 2];

/*** locations; PoP1 ***/
SDL_Texture *imgd0_0[2 + 2];
SDL_Texture *imgp0_0[2 + 2];
SDL_Texture *imgd0_1[2 + 2];
SDL_Texture *imgp0_1[2 + 2];
SDL_Texture *imgd0_2[2 + 2];
SDL_Texture *imgp0_2[2 + 2];
SDL_Texture *imgd0_3[2 + 2];
SDL_Texture *imgp0_3[2 + 2];
SDL_Texture *imgd0_255[2 + 2];
SDL_Texture *imgp0_255[2 + 2];
SDL_Texture *imgd1_0[2 + 2];
SDL_Texture *imgp1_0[2 + 2];
SDL_Texture *imgd1_1[2 + 2];
SDL_Texture *imgp1_1[2 + 2];
SDL_Texture *imgd1_2[2 + 2];
SDL_Texture *imgp1_2[2 + 2];
SDL_Texture *imgd1_3[2 + 2];
SDL_Texture *imgp1_3[2 + 2];
SDL_Texture *imgd1_255[2 + 2];
SDL_Texture *imgp1_255[2 + 2];
SDL_Texture *imgd2_0[2 + 2];
SDL_Texture *imgp2_0[2 + 2];
SDL_Texture *imgd2_1[2 + 2];
SDL_Texture *imgp2_1[2 + 2];
SDL_Texture *imgd2_2[2 + 2];
SDL_Texture *imgp2_2[2 + 2];
SDL_Texture *imgd2_3[2 + 2];
SDL_Texture *imgp2_3[2 + 2];
SDL_Texture *imgd2_4[2 + 2];
SDL_Texture *imgp2_4[2 + 2];
SDL_Texture *imgd2_5[2 + 2];
SDL_Texture *imgp2_5[2 + 2];
SDL_Texture *imgd2_6[2 + 2];
SDL_Texture *imgp2_6[2 + 2];
SDL_Texture *imgd2_7[2 + 2];
SDL_Texture *imgp2_7[2 + 2];
SDL_Texture *imgd2_8[2 + 2];
SDL_Texture *imgp2_8[2 + 2];
SDL_Texture *imgd2_9[2 + 2];
SDL_Texture *imgp2_9[2 + 2];
SDL_Texture *imgd3_0[2 + 2];
SDL_Texture *imgp3_0[2 + 2];
SDL_Texture *imgd4_0[2 + 2];
SDL_Texture *imgp4_0[2 + 2];
SDL_Texture *imgd4_1[2 + 2];
SDL_Texture *imgp4_1[2 + 2];
SDL_Texture *imgd5_0[2 + 2];
SDL_Texture *imgp5_0[2 + 2];
SDL_Texture *imgd6[2 + 2];
SDL_Texture *imgp6[2 + 2];
SDL_Texture *imgd7_0[2 + 2];
SDL_Texture *imgp7_0[2 + 2];
SDL_Texture *imgd7_1[2 + 2];
SDL_Texture *imgp7_1[2 + 2];
SDL_Texture *imgd7_2[2 + 2];
SDL_Texture *imgp7_2[2 + 2];
SDL_Texture *imgd7_3[2 + 2];
SDL_Texture *imgp7_3[2 + 2];
SDL_Texture *imgd8_0[2 + 2];
SDL_Texture *imgp8_0[2 + 2];
SDL_Texture *imgd9_0[2 + 2];
SDL_Texture *imgp9_0[2 + 2];
SDL_Texture *imgd10_0[2 + 2];
SDL_Texture *imgp10_0[2 + 2];
SDL_Texture *imgd10_1[2 + 2];
SDL_Texture *imgp10_1[2 + 2];
SDL_Texture *imgd10_2[2 + 2];
SDL_Texture *imgp10_2[2 + 2];
SDL_Texture *imgd10_3[2 + 2];
SDL_Texture *imgp10_3[2 + 2];
SDL_Texture *imgd10_4[2 + 2];
SDL_Texture *imgp10_4[2 + 2];
SDL_Texture *imgd10_5[2 + 2];
SDL_Texture *imgp10_5[2 + 2];
SDL_Texture *imgd10_6[2 + 2];
SDL_Texture *imgp10_6[2 + 2];
SDL_Texture *imgd11_0[2 + 2];
SDL_Texture *imgp11_0[2 + 2];
SDL_Texture *imgd12_0[2 + 2];
SDL_Texture *imgp12_0[2 + 2];
SDL_Texture *imgd12_1[2 + 2];
SDL_Texture *imgp12_1[2 + 2];
SDL_Texture *imgd12_2[2 + 2];
SDL_Texture *imgp12_2[2 + 2];
SDL_Texture *imgd12_3[2 + 2];
SDL_Texture *imgp12_3[2 + 2];
SDL_Texture *imgd12_4[2 + 2];
SDL_Texture *imgp12_4[2 + 2];
SDL_Texture *imgd12_5[2 + 2];
SDL_Texture *imgp12_5[2 + 2];
SDL_Texture *imgd12_6[2 + 2];
SDL_Texture *imgp12_6[2 + 2];
SDL_Texture *imgd12_7[2 + 2];
SDL_Texture *imgp12_7[2 + 2];
SDL_Texture *imgd13_0[2 + 2];
SDL_Texture *imgp13_0[2 + 2];
SDL_Texture *imgd14_0[2 + 2];
SDL_Texture *imgp14_0[2 + 2];
SDL_Texture *imgd15[2 + 2];
SDL_Texture *imgp15[2 + 2];
SDL_Texture *imgd16_0[2 + 2];
SDL_Texture *imgp16_0[2 + 2];
SDL_Texture *imgd17_0[2 + 2];
SDL_Texture *imgp17_0[2 + 2];
SDL_Texture *imgd18_0[2 + 2];
SDL_Texture *imgp18_0[2 + 2];
SDL_Texture *imgd18_1[2 + 2];
SDL_Texture *imgp18_1[2 + 2];
SDL_Texture *imgd18_2[2 + 2];
SDL_Texture *imgp18_2[2 + 2];
SDL_Texture *imgd18_3[2 + 2];
SDL_Texture *imgp18_3[2 + 2];
SDL_Texture *imgd18_4[2 + 2];
SDL_Texture *imgp18_4[2 + 2];
SDL_Texture *imgd18_5[2 + 2];
SDL_Texture *imgp18_5[2 + 2];
SDL_Texture *imgd19_0[2 + 2];
SDL_Texture *imgp19_0[2 + 2];
SDL_Texture *imgd20_0[2 + 2];
SDL_Texture *imgp20_0[2 + 2];
SDL_Texture *imgd20_1[2 + 2];
SDL_Texture *imgp20_1[2 + 2];
SDL_Texture *imgd21_0[2 + 2];
SDL_Texture *imgp21_0[2 + 2];
SDL_Texture *imgd22_0[2 + 2];
SDL_Texture *imgp22_0[2 + 2];
SDL_Texture *imgd23_0[2 + 2];
SDL_Texture *imgp23_0[2 + 2];
SDL_Texture *imgd24_0[2 + 2];
SDL_Texture *imgp24_0[2 + 2];
SDL_Texture *imgd25_0[2 + 2];
SDL_Texture *imgp25_0[2 + 2];
SDL_Texture *imgd26_0[2 + 2];
SDL_Texture *imgp26_0[2 + 2];
SDL_Texture *imgd27_0[2 + 2];
SDL_Texture *imgp27_0[2 + 2];
SDL_Texture *imgd28_0[2 + 2];
SDL_Texture *imgp28_0[2 + 2];
SDL_Texture *imgd29_0[2 + 2];
SDL_Texture *imgp29_0[2 + 2];
SDL_Texture *imgd30_0[2 + 2];
SDL_Texture *imgp30_0[2 + 2];
SDL_Texture *imgd43_0[2 + 2];
SDL_Texture *imgp43_0[2 + 2];
SDL_Texture *spriteflamed1;
SDL_Texture *spriteflamed2;
SDL_Texture *spriteflamed3;
SDL_Texture *spriteflamed4;
SDL_Texture *spriteflamep1;
SDL_Texture *spriteflamep2;
SDL_Texture *spriteflamep3;
SDL_Texture *spriteflamep4;
SDL_Texture *spritechomperd;
SDL_Texture *spritechomperdsel;
SDL_Texture *spritechomperp;
SDL_Texture *spritechomperpsel;
SDL_Texture *spriteswordd;
SDL_Texture *spritesworddsel;
SDL_Texture *spriteswordp;
SDL_Texture *spriteswordpsel;
SDL_Texture *imgp26_0_wl[2 + 2];

/*** locations; native ***/
SDL_Texture *imgd0_4[2 + 2];
SDL_Texture *imgp0_4[2 + 2];
SDL_Texture *imgd0_5[2 + 2];
SDL_Texture *imgp0_5[2 + 2];
SDL_Texture *imgd0_12[2 + 2];
SDL_Texture *imgp0_12[2 + 2];
SDL_Texture *imgd0_13[2 + 2];
SDL_Texture *imgp0_13[2 + 2];
SDL_Texture *imgd0_50[2 + 2];
SDL_Texture *imgp0_50[2 + 2];
SDL_Texture *imgd0_51[2 + 2];
SDL_Texture *imgp0_51[2 + 2];
SDL_Texture *imgd0_52[2 + 2];
SDL_Texture *imgp0_52[2 + 2];
SDL_Texture *imgd0_53[2 + 2];
SDL_Texture *imgp0_53[2 + 2];
SDL_Texture *imgd1_5[2 + 2];
SDL_Texture *imgp1_5[2 + 2];
SDL_Texture *imgd1_6[2 + 2];
SDL_Texture *imgp1_6[2 + 2];
SDL_Texture *imgd1_13[2 + 2];
SDL_Texture *imgp1_13[2 + 2];
SDL_Texture *imgd1_14[2 + 2];
SDL_Texture *imgp1_14[2 + 2];
SDL_Texture *imgd1_50[2 + 2];
SDL_Texture *imgp1_50[2 + 2];
SDL_Texture *imgd1_51[2 + 2];
SDL_Texture *imgp1_51[2 + 2];
SDL_Texture *imgd1_52[2 + 2];
SDL_Texture *imgp1_52[2 + 2];
SDL_Texture *imgd1_53[2 + 2];
SDL_Texture *imgp1_53[2 + 2];
SDL_Texture *imgd19[2 + 2];
SDL_Texture *imgp19[2 + 2];
SDL_Texture *imgd20_4[2 + 2];
SDL_Texture *imgp20_4[2 + 2];
SDL_Texture *imgd20_6[2 + 2];
SDL_Texture *imgp20_6[2 + 2];
SDL_Texture *imgd20_12[2 + 2];
SDL_Texture *imgp20_12[2 + 2];
SDL_Texture *imgd20_14[2 + 2];
SDL_Texture *imgp20_14[2 + 2];
SDL_Texture *imgd23[2 + 2];
SDL_Texture *imgp23[2 + 2];
SDL_Texture *imgd24[2 + 2];
SDL_Texture *imgp24[2 + 2];
SDL_Texture *imgd30[2 + 2];
SDL_Texture *imgp30[2 + 2];

/*** locations; rooftops, desert, final ***/
SDL_Texture *imgo0[2 + 2];
SDL_Texture *imgo1[2 + 2];
SDL_Texture *imgo20[2 + 2];
SDL_Texture *imgo3[2 + 2];
SDL_Texture *imgo37[2 + 2];
SDL_Texture *imgo38[2 + 2];
SDL_Texture *imgo39[2 + 2];
SDL_Texture *imgo4[2 + 2];
SDL_Texture *imgo28[2 + 2];
SDL_Texture *imgo29[2 + 2];
SDL_Texture *imgo30[2 + 2];
SDL_Texture *imgo10_32[2 + 2];
SDL_Texture *imgo31[2 + 2];
SDL_Texture *imgo40[2 + 2];
SDL_Texture *imgo41[2 + 2];
SDL_Texture *imgo2[2 + 2];
SDL_Texture *imgo5[2 + 2];
SDL_Texture *imgo6[2 + 2];
SDL_Texture *imgo7_0[2 + 2];
SDL_Texture *imgo7_1[2 + 2];
SDL_Texture *imgo7_2[2 + 2];
SDL_Texture *imgo7_3[2 + 2];
SDL_Texture *imgo8[2 + 2];
SDL_Texture *imgo9[2 + 2];
SDL_Texture *imgo10_0[2 + 2];
SDL_Texture *imgo10_64[2 + 2];
SDL_Texture *imgo10_96[2 + 2];
SDL_Texture *imgo10_128[2 + 2];
SDL_Texture *imgo10_160[2 + 2];
SDL_Texture *imgo10_192[2 + 2];
SDL_Texture *imgo10_224[2 + 2];
SDL_Texture *imgo11[2 + 2];
SDL_Texture *imgo12[2 + 2];
SDL_Texture *imgo13[2 + 2];
SDL_Texture *imgo14[2 + 2];
SDL_Texture *imgo15[2 + 2];
SDL_Texture *imgo16[2 + 2];
SDL_Texture *imgo17[2 + 2];
SDL_Texture *imgo18[2 + 2];
SDL_Texture *imgo19[2 + 2];
SDL_Texture *imgo21[2 + 2];
SDL_Texture *imgo22_0[2 + 2];
SDL_Texture *imgo22_1[2 + 2];
SDL_Texture *imgo23[2 + 2];
SDL_Texture *imgo24[2 + 2];
SDL_Texture *imgo25[2 + 2];
SDL_Texture *imgo26[2 + 2];
SDL_Texture *imgo27[2 + 2];
SDL_Texture *imgo32[2 + 2];
SDL_Texture *imgo33[2 + 2];
SDL_Texture *imgo34[2 + 2];
SDL_Texture *imgo35[2 + 2];
SDL_Texture *imgo36[2 + 2];
SDL_Texture *imgo43[2 + 2];
SDL_Texture *imgo44[2 + 2];

/*** locations; caverns ***/
SDL_Texture *imgc0_0[2 + 2];
SDL_Texture *imgc0_1[2 + 2];
SDL_Texture *imgc0_2[2 + 2];
SDL_Texture *imgc0_3[2 + 2];
SDL_Texture *imgc0_4[2 + 2];
SDL_Texture *imgc1_0[2 + 2];
SDL_Texture *imgc1_1[2 + 2];
SDL_Texture *imgc1_2[2 + 2];
SDL_Texture *imgc2_0[2 + 2];
SDL_Texture *imgc2_5[2 + 2];
SDL_Texture *imgc3[2 + 2];
SDL_Texture *imgc4_0[2 + 2];
SDL_Texture *imgc4_100[2 + 2];
SDL_Texture *imgc4_200[2 + 2];
SDL_Texture *imgc8_0[2 + 2];
SDL_Texture *imgc8_1[2 + 2];
SDL_Texture *imgc8_2[2 + 2];
SDL_Texture *imgc9[2 + 2];
SDL_Texture *imgc10_0[2 + 2];
SDL_Texture *imgc10_128[2 + 2];
SDL_Texture *imgc10_160[2 + 2];
SDL_Texture *imgc10_192[2 + 2];
SDL_Texture *imgc10_224[2 + 2];
SDL_Texture *imgc10_32[2 + 2];
SDL_Texture *imgc10_64[2 + 2];
SDL_Texture *imgc10_96[2 + 2];
SDL_Texture *imgc11_0[2 + 2];
SDL_Texture *imgc11_128[2 + 2];
SDL_Texture *imgc14_0[2 + 2];
SDL_Texture *imgc14_1[2 + 2];
SDL_Texture *imgc14_2[2 + 2];
SDL_Texture *imgc16[2 + 2];
SDL_Texture *imgc17_0[2 + 2];
SDL_Texture *imgc17_21[2 + 2];
SDL_Texture *imgc17_42[2 + 2];
SDL_Texture *imgc18[2 + 2];
SDL_Texture *imgc19[2 + 2];
SDL_Texture *imgc20_0[2 + 2];
SDL_Texture *imgc20_1[2 + 2];
SDL_Texture *imgc20_2[2 + 2];
SDL_Texture *imgc20_3[2 + 2];
SDL_Texture *imgc20_4[2 + 2];
SDL_Texture *imgc20_5[2 + 2];
SDL_Texture *imgc20_6[2 + 2];
SDL_Texture *imgc20_7[2 + 2];
SDL_Texture *imgc20_8[2 + 2];
SDL_Texture *imgc20_9[2 + 2];
SDL_Texture *imgc20_10[2 + 2];
SDL_Texture *imgc20_128[2 + 2];
SDL_Texture *imgc20_129[2 + 2];
SDL_Texture *imgc20_130[2 + 2];
SDL_Texture *imgc20_131[2 + 2];
SDL_Texture *imgc20_132[2 + 2];
SDL_Texture *imgc20_133[2 + 2];
SDL_Texture *imgc20_134[2 + 2];
SDL_Texture *imgc20_135[2 + 2];
SDL_Texture *imgc20_136[2 + 2];
SDL_Texture *imgc20_137[2 + 2];
SDL_Texture *imgc20_138[2 + 2];
SDL_Texture *imgc23[2 + 2];
SDL_Texture *imgc24[2 + 2];
SDL_Texture *imgc28[2 + 2];
SDL_Texture *imgc32[2 + 2];
SDL_Texture *imgc33[2 + 2];
SDL_Texture *imgc34_E_0[2 + 2];
SDL_Texture *imgc34_E_8[2 + 2];
SDL_Texture *imgc35[2 + 2];
SDL_Texture *imgc36[2 + 2];
SDL_Texture *imgc44[2 + 2];
SDL_Texture *spriteflamec1;
SDL_Texture *spriteflamec2;

/*** locations; ruins ***/
SDL_Texture *imgr0[2 + 2];
SDL_Texture *imgr1_0[2 + 2];
SDL_Texture *imgr1_1[2 + 2];
SDL_Texture *imgr1_2[2 + 2];
SDL_Texture *imgr1_3[2 + 2];
SDL_Texture *imgr2[2 + 2];
SDL_Texture *imgr3_0[2 + 2];
SDL_Texture *imgr3_1[2 + 2];
SDL_Texture *imgr3_2[2 + 2];
SDL_Texture *imgr4_0[2 + 2];
SDL_Texture *imgr4_100[2 + 2];
SDL_Texture *imgr4_200[2 + 2];
SDL_Texture *imgr5_E_0[2 + 2];
SDL_Texture *imgr5_E_8[2 + 2];
SDL_Texture *imgr6_E_0[2 + 2];
SDL_Texture *imgr6_E_8[2 + 2];
SDL_Texture *imgr7_0[2 + 2];
SDL_Texture *imgr7_1[2 + 2];
SDL_Texture *imgr7_2[2 + 2];
SDL_Texture *imgr7_3[2 + 2];
SDL_Texture *imgr8[2 + 2];
SDL_Texture *imgr9[2 + 2];
SDL_Texture *imgr10_0[2 + 2];
SDL_Texture *imgr10_128[2 + 2];
SDL_Texture *imgr10_160[2 + 2];
SDL_Texture *imgr10_192[2 + 2];
SDL_Texture *imgr10_224[2 + 2];
SDL_Texture *imgr10_32[2 + 2];
SDL_Texture *imgr10_64[2 + 2];
SDL_Texture *imgr10_96[2 + 2];
SDL_Texture *imgr11[2 + 2];
SDL_Texture *imgr12_0[2 + 2];
SDL_Texture *imgr12_128[2 + 2];
SDL_Texture *imgr12_160[2 + 2];
SDL_Texture *imgr12_32[2 + 2];
SDL_Texture *imgr13_0[2 + 2];
SDL_Texture *imgr13_32[2 + 2];
SDL_Texture *imgr14_16[2 + 2];
SDL_Texture *imgr14_32[2 + 2];
SDL_Texture *imgr14_64[2 + 2];
SDL_Texture *imgr15_0[2 + 2];
SDL_Texture *imgr15_1[2 + 2];
SDL_Texture *imgr15_2[2 + 2];
SDL_Texture *imgr15_3[2 + 2];
SDL_Texture *imgr16[2 + 2];
SDL_Texture *imgr17_0[2 + 2];
SDL_Texture *imgr17_21[2 + 2];
SDL_Texture *imgr17_42[2 + 2];
SDL_Texture *imgr18[2 + 2];
SDL_Texture *imgr20_0[2 + 2];
SDL_Texture *imgr20_1[2 + 2];
SDL_Texture *imgr20_2[2 + 2];
SDL_Texture *imgr20_4[2 + 2];
SDL_Texture *imgr20_5[2 + 2];
SDL_Texture *imgr20_6[2 + 2];
SDL_Texture *imgr20_8[2 + 2];
SDL_Texture *imgr20_9[2 + 2];
SDL_Texture *imgr20_10[2 + 2];
SDL_Texture *imgr20_12[2 + 2];
SDL_Texture *imgr20_13[2 + 2];
SDL_Texture *imgr20_14[2 + 2];
SDL_Texture *imgr21[2 + 2];
SDL_Texture *imgr22_1[2 + 2];
SDL_Texture *imgr22_2[2 + 2];

/*** locations; temple ***/
SDL_Texture *imgt0[2 + 2];
SDL_Texture *imgt1_0[2 + 2];
SDL_Texture *imgt1_1[2 + 2];
SDL_Texture *imgt2_0[2 + 2];
SDL_Texture *imgt2_5[2 + 2];
SDL_Texture *imgt3_0[2 + 2];
SDL_Texture *imgt3_1[2 + 2];
SDL_Texture *imgt4_0[2 + 2];
SDL_Texture *imgt4_100[2 + 2];
SDL_Texture *imgt4_200[2 + 2];
SDL_Texture *imgt5_E_0[2 + 2];
SDL_Texture *imgt5_E_8[2 + 2];
SDL_Texture *imgt6_E_0[2 + 2];
SDL_Texture *imgt6_E_8[2 + 2];
SDL_Texture *imgt8[2 + 2];
SDL_Texture *imgt9[2 + 2];
SDL_Texture *imgt10_0[2 + 2];
SDL_Texture *imgt10_128[2 + 2];
SDL_Texture *imgt10_160[2 + 2];
SDL_Texture *imgt10_192[2 + 2];
SDL_Texture *imgt10_224[2 + 2];
SDL_Texture *imgt10_32[2 + 2];
SDL_Texture *imgt10_64[2 + 2];
SDL_Texture *imgt10_96[2 + 2];
SDL_Texture *imgt11[2 + 2];
SDL_Texture *imgt12_0[2 + 2];
SDL_Texture *imgt12_128[2 + 2];
SDL_Texture *imgt12_160[2 + 2];
SDL_Texture *imgt12_32[2 + 2];
SDL_Texture *imgt13_0[2 + 2];
SDL_Texture *imgt13_32[2 + 2];
SDL_Texture *imgt14_0[2 + 2];
SDL_Texture *imgt14_1[2 + 2];
SDL_Texture *imgt16[2 + 2];
SDL_Texture *imgt17_0[2 + 2];
SDL_Texture *imgt17_21[2 + 2];
SDL_Texture *imgt17_42[2 + 2];
SDL_Texture *imgt18[2 + 2];
SDL_Texture *imgt19[2 + 2];
SDL_Texture *imgt20_0[2 + 2];
SDL_Texture *imgt20_1[2 + 2];
SDL_Texture *imgt20_2[2 + 2];
SDL_Texture *imgt25_0[2 + 2];
SDL_Texture *imgt25_1[2 + 2];
SDL_Texture *imgt25_2[2 + 2];
SDL_Texture *imgt26[2 + 2];
SDL_Texture *imgt32[2 + 2];
SDL_Texture *spriteflamet1;
SDL_Texture *spriteflamet2;

/*** locations; PoP1 for SNES ***/
SDL_Texture *imgtilesblue[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesfawn[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilessilver[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtileslava[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesgreen[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesumber[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesmarble[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtileshallway[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesjaffar[MAX_TILES + 2][2 + 2];
SDL_Texture *imgtilesintro[MAX_TILES + 2][2 + 2];
char sTileBlocksBlue[MAX_TILES + 2][20 + 2];
char sTileBlocksFawn[MAX_TILES + 2][20 + 2];
char sTileBlocksSilver[MAX_TILES + 2][20 + 2];
char sTileBlocksLava[MAX_TILES + 2][20 + 2];
char sTileBlocksGreen[MAX_TILES + 2][20 + 2];
char sTileBlocksUmber[MAX_TILES + 2][20 + 2];
char sTileBlocksMarble[MAX_TILES + 2][20 + 2];
char sTileBlocksHallway[MAX_TILES + 2][20 + 2];
char sTileBlocksJaffar[MAX_TILES + 2][20 + 2];
char sTileBlocksIntro[MAX_TILES + 2][20 + 2];
int iTilesBlue;
int iTilesFawn;
int iTilesSilver;
int iTilesLava;
int iTilesGreen;
int iTilesUmber;
int iTilesMarble;
int iTilesHallway;
int iTilesJaffar;
int iTilesIntro;

/*** PoP1 guards ***/
SDL_Texture *imggdb[2 + 2];
SDL_Texture *imgggy[2 + 2];
SDL_Texture *imgglp[2 + 2];
SDL_Texture *imggoy[2 + 2];
SDL_Texture *imggpb[2 + 2];
SDL_Texture *imggrp[2 + 2];
SDL_Texture *imggyo[2 + 2];
SDL_Texture *imgguc[2 + 2];
SDL_Texture *imgskel[2 + 2];
SDL_Texture *imgfat[2 + 2];
SDL_Texture *imgjaffar[2 + 2];
SDL_Texture *imgshadow[2 + 2];

/*** PoP1 guards, selected ***/
SDL_Texture *imggsel[2 + 2];
SDL_Texture *imgskelsel[2 + 2];
SDL_Texture *imgfatsel[2 + 2];
SDL_Texture *imgjaffarsel[2 + 2];
SDL_Texture *imgshadowsel[2 + 2];

/*** PoP2 guards ***/
SDL_Texture *imgbirdman[2 + 2];
SDL_Texture *imgfakeprince[2 + 2];
SDL_Texture *imgguardblack[2 + 2];
SDL_Texture *imgguardblue[2 + 2];
SDL_Texture *imgguardred[2 + 2];
SDL_Texture *imgheadlong[2 + 2];
SDL_Texture *imgheadshort[2 + 2];
SDL_Texture *imgskelawake[2 + 2];
SDL_Texture *imgskelawakes[2 + 2];
SDL_Texture *imgskelawakessws[2 + 2];
SDL_Texture *imgskelsleeps[2 + 2];
SDL_Texture *imgsnake[2 + 2];
SDL_Texture *imgsword[2 + 2];

/*** PoP1 for SNES guards (regular and selected) ***/
SDL_Texture *imgsg02[2 + 2], *imgsg02sel[2 + 2];
SDL_Texture *imgsg03[2 + 2], *imgsg03sel[2 + 2];
SDL_Texture *imgsg04[2 + 2], *imgsg04sel[2 + 2];
SDL_Texture *imgsg05[2 + 2], *imgsg05sel[2 + 2];
SDL_Texture *imgsg06[2 + 2], *imgsg06sel[2 + 2];
SDL_Texture *imgsg07[2 + 2], *imgsg07sel[2 + 2];
SDL_Texture *imgsg08[2 + 2], *imgsg08sel[2 + 2];
SDL_Texture *imgsg09[2 + 2], *imgsg09sel[2 + 2];
SDL_Texture *imgsg0a[2 + 2], *imgsg0asel[2 + 2];
SDL_Texture *imgsg0b[2 + 2], *imgsg0bsel[2 + 2];
SDL_Texture *imgsg0c[2 + 2], *imgsg0csel[2 + 2];
SDL_Texture *imgsg0d[2 + 2], *imgsg0dsel[2 + 2];
SDL_Texture *imgsg0e[2 + 2], *imgsg0esel[2 + 2];
SDL_Texture *imgsg0f[2 + 2], *imgsg0fsel[2 + 2];
SDL_Texture *imgsg10[2 + 2], *imgsg10sel[2 + 2];
SDL_Texture *imgsg11[2 + 2], *imgsg11sel[2 + 2];
SDL_Texture *imgsg12[2 + 2], *imgsg12sel[2 + 2];
SDL_Texture *imgsg13[2 + 2], *imgsg13sel[2 + 2];

/*** various ***/
SDL_Texture *imgunk[2 + 2], *imgup_0, *imgup_1, *imgdown_0, *imgdown_1;
SDL_Texture *imgleft_0, *imgleft_1, *imgright_0, *imgright_1, *imgroomson_0;
SDL_Texture *imgroomson_1, *imgroomsoff, *imgeventson_0, *imgeventson_1;
SDL_Texture *imgeventsoff, *imgsaveoff, *imgsoffp, *imgsaveon_0, *imgsaveon_1;
SDL_Texture *imgquit_0, *imgquit_1, *imgevents, *imgeventu;
SDL_Texture *imgchkb, *imgchkg;
SDL_Texture *imgblack, *imghourglass, *imgprevon_0, *imgprevon_1;
SDL_Texture *imghourglasssprite, *imgsandsprite, *imgstatusbarsprite;
SDL_Texture *imgnexton_0, *imgnexton_1, *imgbar;
SDL_Texture *extras_0, *extras_1, *extras_2, *extras_3, *extras_4;
SDL_Texture *extras_5, *extras_6, *extras_7, *extras_8;
SDL_Texture *extras_9, *extras_10;
SDL_Texture *imgudno, *imglrno, *imgudnonfo, *imgkidr[2 + 2], *imgkidl[2 + 2];
SDL_Texture *imgkidrr[2 + 2], *imgkidlr[2 + 2], *imggs[2 + 2];
SDL_Texture *imgprevoff, *imgnextoff, *imgrl, *imgrl2, *imgbrl3;
SDL_Texture *imgsrc, *imgsrs, *imgsrm, *imgsrp, *imgsrb, *imgsro;
SDL_Texture *imgfadedl, *imgfadeds, *imgpopup, *imgok[2 + 2], *imgsave[2 + 2];
SDL_Texture *imgpopup_yn, *imgyes[2 + 2], *imgno[2 + 2], *imghelp, *imgexe;
SDL_Texture *imgexepacked, *imgexemusicyes, *imgexemusicno;
SDL_Texture *imgexehazeyes, *imgexehazeno, *imgexeskeldis, *imgexetab;
SDL_Texture *imgexedetails, *imgexepacked2, *imgexef3, *imgexepacked3;
SDL_Texture *imgexef4, *imgexef5;
SDL_Texture *imgexeactionr, *imgexeactionf, *imgexeactionb;
SDL_Texture *imgexeactionu, *imgexeactiond, *imgexeactionj;
SDL_Texture *imgexeactions, *imgexeactionh, *imgexeactione;
SDL_Texture *imgnomarker, *imgredp, *imgkcolors, *imgkcolorsb, *imgkcolorsw;
SDL_Texture *imgkcolorsr, *imgkcolorsl, *imgkcolorsf;
SDL_Texture *imgdungeon, *imgpalace, *imgeventh, *imgclose_0, *imgclose_1;
SDL_Texture *imgback_0, *imgback_1, *imgguards_0, *imgguards_1;
SDL_Texture *imgborderr, *imgborderb, *imgborders, *imgborderbl, *imgbordersl;
SDL_Texture *imgdother, *imgdjaffar, *imgdguards, *imgprincew;
SDL_Texture *imgbroomson_0, *imgbroomson_1, *imgbroomsoff, *imgbrl, *imgbrl2;
SDL_Texture *imgcustoma0, *imgcustomi0, *imgcustoma1, *imgcustomi1, *imgcustom;
SDL_Texture *imgcustoms, *imgl21warn, *imgstooltip, *imgzsnes, *imgjtooltip;
SDL_Texture *imgcustom_0, *imgcustom_1, *imgclosebig_0, *imgclosebig_1;
SDL_Texture *imgoth, *imgcaverns, *imgruins, *imgruins_back;
SDL_Texture *imgtemple, *imgtemple_back, *imgguards;
SDL_Texture *imgguard_row, *imgguard_entry;
SDL_Texture *imgfadeddg, *imgfadedsgl, *imgfadedsgr, *imgxtooltip, *imgl10warn;
SDL_Texture *imggw_255, *imggw_2;
SDL_Texture *imggw_5, *imggw_7, *imggw_0, *imggw_dynamic;
SDL_Texture *imgsb, *imgsbs, *imghb, *imghc;
SDL_Texture *imgincomingl[10 + 2], *imgincomingr[10 + 2];
SDL_Texture *imgmusic_0, *imgmusic_1, *imgmusic, *imgmusic_note;
SDL_Texture *imgm_all_0, *imgm_all_1, *imgm_none_0, *imgm_none_1;
SDL_Texture *imgm_left_0, *imgm_left_1, *imgm_right_0, *imgm_right_1;
SDL_Texture *imgm_top_0, *imgm_top_1, *imgm_middle_0, *imgm_middle_1;
SDL_Texture *imgm_bottom_0, *imgm_bottom_1, *imgm_invert_0, *imgm_invert_1;
SDL_Texture *imgee_0, *imgee_1, *imgec_0, *imgec_1, *imgdistort, *imgtooltip;
SDL_Texture *imgblue, *imgfawn, *imgsilver, *imglava, *imggreen;
SDL_Texture *imgumber, *imgmarble, *imghallway, *imgjaffart, *imgintro;
SDL_Texture *imgsnesback, *imganimback;
SDL_Texture *imgblueb, *imgfawnb, *imgsilverb, *imglavab, *imggreenb;
SDL_Texture *imgumberb, *imgmarbleb, *imghallwayb, *imgjaffarb, *imgintrob;
SDL_Texture *imgsnestemp, *imgtemp_0, *imgtemp_1, *imgcolor_0, *imgcolor_1;
SDL_Texture *imgtempb, *imgtempf, *imgtemps, *imgtempl, *imgtempg;
SDL_Texture *imgtempu, *imgtempm, *imgtemph, *imgtempj, *imgtempi;
SDL_Texture *imgautomatic, *imgautomaticsel;
SDL_Texture *imgautof[15 + 2], *imgautok[255 + 2], *imgautokunk;
SDL_Texture *imgjump, *imgjumpdis16, *imgjumpdis25, *imgjumpdis28;
SDL_Texture *imgjumpdis29, *imgseljump;
SDL_Texture *imghexeditor, *imgshb, *imgshg, *imgshj, *imgshf;
SDL_Texture *imgclosea[2 + 2];

/*** the rooms ***/
SDL_Texture *imgroom1, *imgroom2, *imgroom3, *imgroom4, *imgroom5, *imgroom6;
SDL_Texture *imgroom7, *imgroom8, *imgroom9, *imgroom10, *imgroom11;
SDL_Texture *imgroom12, *imgroom13, *imgroom14, *imgroom15, *imgroom16;
SDL_Texture *imgroom17, *imgroom18, *imgroom19, *imgroom20, *imgroom21;
SDL_Texture *imgroom22, *imgroom23, *imgroom24, *imgroom25, *imgroom26;
SDL_Texture *imgroom27, *imgroom28, *imgroom29, *imgroom30, *imgroom31;
SDL_Texture *imgroom32;

/*** PoP select ***/
SDL_Texture *imgpop, *imgpop1dis, *imgpop1off, *imgpop1on;
SDL_Texture *imgpop2dis, *imgpop2off, *imgpop2on, *imgprprob;
SDL_Texture *imgcontroller, *imgpop1snesdis, *imgpop1snesoff, *imgpop1sneson;
SDL_Texture *imgupgrade;

/*** PoP2 backgrounds ***/
SDL_Texture *backl1r1, *backl1r2, *backl1r3, *backl1r4, *backl1r5, *backl1r10;
SDL_Texture *backl1r11, *backl1r12, *backl1r15, *backl1r16, *backl1r19;
SDL_Texture *backl2r1, *backl2r2, *backl2r3, *backl14r1, *backl14r2;
SDL_Texture *backl14r3, *backl14r4, *backl14r5, *backl14r6, *backl14r7;
SDL_Texture *backl14r8, *backl6r27, *backl9r2, *backl9r11, *backl9r12;
SDL_Texture *backl9r13, *backl9r14, *backl9r15, *backl9r16, *backl13r4;
SDL_Texture *backl8r9;

SDL_Texture *crack1[2 + 2], *crack3[2 + 2], *crack4[2 + 2], *crack5[2 + 2];
SDL_Texture *crack6[2 + 2], *crack7[2 + 2], *crack8[2 + 2], *crack9[2 + 2];
SDL_Texture *crack10[2 + 2], *crack11[2 + 2], *crack12[2 + 2];
SDL_Texture *symbol16[2 + 2], *symbol32[2 + 2], *symbol48[2 + 2];

SDL_Texture *bottom1[2 + 2], *bottom2[2 + 2], *bottom3[2 + 2];
SDL_Texture *bottom4[2 + 2], *bottom5[2 + 2], *bottom6[2 + 2];
SDL_Texture *bottom7[2 + 2], *stalactite8[2 + 2], *stalactite16[2 + 2];
SDL_Texture *stalactite24[2 + 2], *stalactite32[2 + 2], *stalactite40[2 + 2];
SDL_Texture *stalactite48[2 + 2], *stalactite56[2 + 2];

SDL_Texture *templeb[31 + 2];
int iTempleBHeight[31 + 2];
SDL_Texture *ruinsb[31 + 2];
int iRuinsBHeight[31 + 2];
SDL_Texture *imghorse;
SDL_Texture *imgarrow;
SDL_Texture *imginvisible;
SDL_Texture *imgcurtainl, *imgcurtainr;
SDL_Texture *imggates;
SDL_Texture *imgexitl, *imgexitr, *imgexitu, *imgexitd;
SDL_Texture *imgcheckpl, *imgcheckpr, *imgcheckpu, *imgcheckpd;

/*** PoP1 for SNES backgrounds ***/
SDL_Texture *blueb[0x53 + 2];
SDL_Texture *fawnb[0x60 + 2];
SDL_Texture *silverb[0x36 + 2];
SDL_Texture *lavab[0x36 + 2];
SDL_Texture *greenb[0x62 + 2];
SDL_Texture *umberb[0x59 + 2];
SDL_Texture *marbleb[0x75 + 2];
SDL_Texture *hallwayb[0x21 + 2];
SDL_Texture *jaffarb[0x0f + 2];
SDL_Texture *introb[0x65 + 2];

/*** native ***/
SDL_Texture *imgnativeoff, *imgnativeon_0, *imgnativeon_1, *imgnative_f;
SDL_Texture *imgnativetab_0[12 + 2], *imgnativetab_1[12 + 2];
SDL_Texture *imgnativetab_0a[12 + 2], *imgnative;
SDL_Texture *imgnative_bb, *imgnative_bbl;
SDL_Texture *imgnative_d[12 + 2], *imgnative_p[12 + 2];
SDL_Texture *imgnative_s, *imgnative_m, *imgnative_b;
SDL_Texture *six_bit_rgb[0x3f + 2];

/*** playtest ***/
SDL_Texture *imgpt;
SDL_Texture *imgptdosboxdis, *imgptdosboxoff, *imgptdosboxon;
SDL_Texture *imgptsdlpopdis, *imgptsdlpopoff, *imgptsdlpopon;
SDL_Texture *imgptmininimdis, *imgptmininimoff, *imgptmininimon;
SDL_Texture *imgptnativeoff, *imgptnativeon;
SDL_Texture *imgptdosboxkey, *imgptsdlpopkey, *imgptmininimkey;

/*** Map window ***/
SDL_Texture *imgmapon_0, *imgmapon_1, *imgmapoff;
SDL_Texture *imggrid;
SDL_Texture *imgmap, *imgmapgrid, *imgmapseltile, *imgmappanel;
SDL_Texture *imgmini1[31 + 2][255 + 2]; /*** PoP1 for DOS ***/
SDL_Texture *imgmini3[48 + 2][255 + 2]; /*** PoP1 for SNES ***/
SDL_Texture *imgminiguard, *imgminiprince, *imgminihover, *imgminirelated;
SDL_Texture *imgclosem[2 + 2];
SDL_Texture *imgzoom1on_0, *imgzoom1on_1, *imgzoom1off;
SDL_Texture *imgzoomfiton_0, *imgzoomfiton_1, *imgzoomfitoff;
SDL_Texture *imgzoominon_0, *imgzoominon_1, *imgzoominoff;
SDL_Texture *imgzoomouton_0, *imgzoomouton_1, *imgzoomoutoff;
SDL_Texture *imgarrowdoff, *imgarrowdon_0, *imgarrowdon_1;
SDL_Texture *imgarrowloff, *imgarrowlon_0, *imgarrowlon_1;
SDL_Texture *imgarrowroff, *imgarrowron_0, *imgarrowron_1;
SDL_Texture *imgarrowuoff, *imgarrowuon_0, *imgarrowuon_1;
SDL_Texture *imgbmrooma, *imgbmroomh;
SDL_Texture *imgchkbmap;

/*** Download ***/
SDL_Texture *imgdownload1[2 + 2];
SDL_Texture *imgdownload2[2 + 2];
SDL_Texture *imgdownload3[2 + 2];
SDL_Texture *imgdownloads[2 + 2];
SDL_Texture *imgdownloadm[2 + 2];

/*** text ***/
SDL_Texture *imgtext;
SDL_Texture *imgtextnone;
SDL_Texture *imgtexthover;

/*** kid button and screen ***/
SDL_Texture *imgkid;
SDL_Texture *imgkidp;
SDL_Texture *imgkidf;
SDL_Texture *imgkidfp1;
SDL_Texture *imgkidb;
SDL_Texture *imgkidbl;
SDL_Texture *imgkidbb;
SDL_Texture *imgkid0;
SDL_Texture *imgkid1;

int iMinX, iMaxX, iMinY, iMaxY, iStartRoomsX, iStartRoomsY;
int iDone[32 + 2]; /*** PoP1 only uses 24. ***/

struct sample {
	Uint8 *data;
	Uint32 dpos;
	Uint32 dlen;
} sounds[NUM_SOUNDS];

void CheckSSE (void);
void CheckLatest (void);
void CheckRequiredFiles (void);
void LoadPLV (char *sFileName);
void LoadXML (char *sFileName);
int GetResourceAddress (int iFd, int iResource);
void LoadSMC (int iLevel);
void SaveSMC (int iLevel);
void CreateVariousSNES (unsigned char *sVariousS);
void Decompress (int iFd, char *sWhat, int iNeed,
	unsigned char *sDecompressed);
int Compress (char *sWhat, int iNeed, unsigned char *sToCompress,
	unsigned char *sCompressed);
int EventInfo (int iNr, int iType);
int ReadFromFile (int iFd, char *sWhat, int iSize, unsigned char *sRetString);
int ReadLineFromFile (int iFd, char *sRetString, int iLtrim);
void GetAsEightBits (unsigned char cChar, char *sBinary);
int BitsToInt (char *sString);
void IntToBits (int iInt, char *sOutput, int iBits);
void GetForegroundAsName (char *sBinaryFore, char *sName);
void GetModifierAsName (int iFore, int iMod, char *sName);
char cShowDirection (int iDirection);
void ShowImage (int iThingOrRoom, int iModifier[], SDL_Renderer *screen,
	int iLocation, int iFromImageX, int iFromImageY,
	int iFromImageWidth, int iFromImageHeight);
void ShowImageBasic (SDL_Texture *img, int iX, int iY, char *sImageInfo,
	SDL_Renderer *screen, float fMultiply, int iXYScale);
void CmpPrep (char *sBlock, char *sCompare, SDL_Texture **imgcmp,
	SDL_Texture **imgshow);
int InArea (int iUpperLeftX, int iUpperLeftY,
	int iLowerRightX, int iLowerRightY);
int InAreaMap (int iUpperLeftX, int iUpperLeftY,
	int iLowerRightX, int iLowerRightY);
void PreventCPUEating (void);
void InitScreenAction (char *sAction);
void InitScreen (void);
void EventDoor (int iX, int iY);
void EventNext (int iNoNext);
void RunLevel (int iLevel);
void RunLevelS (int iLevel);
void RunLevelM (int iLevel);
void EventRoom (int iRoom);
void RemoveOldRoom (void);
void AddNewRoom (int iX, int iY, int iRoom);
void InitRooms (void);
int StartGame (void *unused);
int StartGameS (void *unused);
int StartGameM (void *unused);
int UPack (void *unused);
void Quit (void);
void ShowScreen (int iScreenS, SDL_Renderer *screen);
void Prev (int iCurLevel);
void Next (int iCurLevel);
void WhereToStart (void);
void CheckSides (int iRoom, int iX, int iY);
void ShowRooms (int iRoom, int iX, int iY, int iNext);
void SetMapHover (int iRoom, int iX, int iY);
void ShowRoomsMap (int iRoom, int iX, int iY);
void InitPopUp (void);
void ShowPopUp (void);
int InitPopUpYN (int iYNText);
void ShowPopUpYN (int iYNText);
void DisplayText (int iStartX, int iStartY, int iFontSize,
	char arText[9 + 2][MAX_TEXT + 2], int iLines, TTF_Font *font);
void DisplayTextLine (int iStartX, int iStartY, char sText[MAX_TEXT + 2],
	TTF_Font *font, SDL_Color fore, SDL_Color back, int iOnMap);
void ShowPos (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img_first[2 + 2], SDL_Texture *img_second[2 + 2], char *sLbl);
void ShowPosPoP2 (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img[2 + 2], char *sLbl);
void ShowPosSNES (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img[2 + 2], char *sLbl);
void ShowDetail (SDL_Texture *img[2 + 2], SDL_Rect loc,
	SDL_Renderer *screen, SDL_Rect dest, int iLocation);
void ChangePosAction (char *sAction, int iLocation);
void ChangePos (int iLocation, SDL_Renderer *screen);
void ChangePosCustomAction (char *sAction, int iLocation);
int ChangePosCustom (int iLocation, SDL_Renderer *screen);
void ApplyNewGuardType (int iGuardNr, int iGuardType);
void ChangeGuards (SDL_Renderer *screen);
void ChangeMusicAction (char *sAction);
void ChangeMusic (SDL_Renderer *screen);
void ChangeBackgroundAction (char *sAction, int iLocation);
int ChangeBackground (int iLocation, SDL_Renderer *screen);
void PickTemplateAction (char *sAction);
int PickTemplate (SDL_Renderer *screen);
void ChangeEvent (int iAmount, int iChangePos);
void ChangeCustom (int iAmount, int iForeModi, int iArNr);
int IsDisabled (int iTile);
void UseTile (int iTile, int iLocation, int iRoom, int iTileUnderMe);
void SetGuard (int iLoc, int iDirection, int iSkill, int iColor);
void SetGuardSNES (int iLoc, int iDirection, int iSkill, int iType);
void ShowChange (int iLocation, SDL_Renderer *screen);
void ShowChangeCustom (SDL_Renderer *screen);
void ShowChangeGuards (SDL_Renderer *screen);
void ShowChangeMusic (SDL_Renderer *screen);
void ShowChangeBackground (int iLocation, SDL_Renderer *screen);
void ShowPickTemplate (SDL_Renderer *screen);
void DisableSome (void);
int OnTile (void);
int Modulo (long lOne, long lTwo, int iType);
void SetLocation (int iRoom, int iLocation, int iThing, int iModifier1,
	int iModifier2, int iModifier3, int iModifier4);
void SetLocationSNES (int iRoom, int iLocation, int iBlock1, int iBlock2,
	int iBlock3, int iBlock4, int iModifier, int iTileUnderMe);
void CallSave (int iJustXML);
int ChecksumOrWrite (int iFd);
void SavePLV (char *sFileName);
int WriteUserData (int iFd, int iType);
void WriteCharByChar (int iFd, unsigned char *sString, int iLength);
int AddCharByChar (unsigned char *sTo, int iToSize,
	unsigned char *sString, int iLength);
void ShowUsage (void);
void PrIfDe (char *sString);
void MixAudio (void *unused, Uint8 *stream, int iLen);
void PlaySound (char *sFile);
int BrokenRoomLinks (int iPrint);
int BrokenRoomChange (int iRoom, int iSide);
int MouseSelectAdj (void);
void CustomRenderCopy (SDL_Texture* src, char *srcn, SDL_Rect* srcrect,
	SDL_Renderer* dst, SDL_Rect *dstrect);
void LoadFonts (void);
void CustomTile (int iThing, int iModifier[], char *sRetString);
void ShowCurrentCustom (SDL_Renderer *screen);
void CreateBAK (void);
void Help (void);
void ShowHelp (void);
unsigned long BytesAsLU (unsigned char *sData, int iBytes);
void EXECheckbox (int iX, int iY17, int *iChange, int iTo);
void EXELoad_F2_1 (void);
void EXELoad_F3_1 (void);
void EXELoad_F4_1 (void);
void EXELoad_F5_1 (void);
void EXELoad_F2_2 (void);
void EXELoad_F2_3 (void);
void EXELoad_F5_3 (void);
void EXESave_F2_1 (void);
void EXESave_F3_1 (void);
void EXESave_F4_1 (void);
void EXESave_F5_1 (void);
void EXESave_F2_2 (void);
void EXESave_F2_3 (void);
void EXESave_F5_3 (void);
void EXE (void);
void ShowEXE (void);
void EXE_F3 (void); /*** SNES: See Text(). ***/
void ShowEXE_F3 (void);
void EXE_F4 (void); /*** SNES: See Automatic(). ***/
void ShowEXE_F4 (void);
void EXE_F5 (void);
void ShowEXE_F5 (void);
void KidColorsLoad (void);
void KidColorsSave (void);
void KidColors (void);
void ShowKidColors (void);
void CheckCodes (char *sHex, int iFdEXE);
void Zoom (int iToggleFull);
void Sprinkle (void);
void LoadLevel (int iLevel);
void GetOptionValue (char *sArgv, char *sValue);
void FlipRoom (int iRoom, int iAxis);
void CopyPaste (int iRoom, int iAction);
void DateTime (char *sDateTime);
void SaveXML (char *sFileName);
void PoP1OrPoP2Action (char *sAction);
void PoP1OrPoP2 (void);
void ShowPoP1OrPoP2 (SDL_Renderer *screen);
void PreLoad (char *sPath, char *sPNG, SDL_Texture **imgImage);
void PreLoadMap (char *sPath, char *sPNG, SDL_Texture **imgImage);
void PreLoadSet (char *sPath, char cType, char *sTile, SDL_Texture **img);
void LoadingBar (SDL_Renderer *screen, int iBarHeight);
void CenterNumber (SDL_Renderer *screen, int iNumber, int iX, int iY,
	SDL_Color fore, SDL_Color back, int iHex);
int IntsToHexToSSLittleEndian (int iHexRight, int iHexLeft);
void SSLittleEndianToHexToInts (int iValue, int *iHexRight, int *iHexLeft);
int PlusMinus (int *iWhat, int iX, int iY,
	int iMin, int iMax, int iChange, int iAddChanged);
int WhichStaticGuard (int iGuardNr);
void Backgrounds (void);
void ShowBackground (int iModifier[], int iLoc);
void StrangeBack (int iModifier, int iLoc);
void OpenURL (char *sURL);
int ModAsJumps (int iModifier);
int JumpsAsMod (int iJumps);
int ModAsFrame (int iModifier);
int FrameAsMod (int iFrame);
int ModAsPercent (int iModifier, int iThing);
int PercentAsMod (int iPercent, int iThing);
int ModAsWall (int iModifier);
int WallAsMod (int iWall, int iModifier);
int ModAsStuck (int iModifier, int iType);
int StuckAsMod (int iStuck, int iType);
void PoP1Basics (void);
void PoP2Basics (void);
void PoP1SNESBasics (void);
int HiSetBackArea (int iX, int iY, int iLoc, int iMod3, int iMod4, int iType);
int HiSetBack (int iLoc, int iType);
int BackKey (SDL_Event event, char cKey, int iLoc);
void ApplyJumpsFrameIfNecessary (int iLoc);
void ApplyPercentIfNecessary (int iLoc);
void ApplyWallIfNecessary (int iLoc);
void ApplySkillIfNecessary (int iLoc);
void ApplyStuckIfNecessary (int iLoc);
void ApplyMarkerIfNecessary (int iLoc);
void ExtractFromMod2 (int iMod2, char cCrackBot, char cSymbolStal);
int ExtractedAsMod2 (char cCrackBot, char cSymbolStal);
void UpdateMod2IfNecessary (int iLoc);
void substr (char *sString, int iStart, int iLength, char *sOutput);
void substru (unsigned char *sString, int iStart,
	int iLength, unsigned char *sOutput);
int strpos (char *sHaystack, char *sNeedle, int iOffset);
void XMLValue (char *sLine, char *sKey, char *sValue);
void XMLTag (char *sLine, char *sTag);
int Block (int iRoom, int iLocation, char *sBlock);
void ModifyForZSNES (int iLevel);
void ModifyBack (void);
int TileUnderMe (int iRoom, int iLocation, int iTileUnderMe);
int BackOutOfBounds (int iV);
int MaxBackSNES (void);
void BackRowAndColumnSNES (int *iBackRow, int *iBackColumn);
void LinkPlus (void);
void LinkMinus (void);
void CurTypeBlocks (void);
void ClearRoom (void);
void ShowArrow (char *sWhat, char cDir);
void PreLoadTilesSNES (char cType);
void GetCurDir (char cType, char *sCurDir);
void UpdateTileAboveMe (int iRoom, int iLocation);
int GetTileNr (int iTileC, int iMod1);
int GetTileNrSNES (int iB1, int iB2, int iB3, int iB4, int iMod1);
int GetTileNrSNESApprox (int iB3, int iB4, int iMod1);
int CompressedLevelSize (int iFd, int iLevel);
void LSeek (int iFd, int iOffset);
void EnvNrAsName (int iEnvNr, char *sLevelName);
void ForceSpecialsToMatchEnv (void);
int OnKid (int iKOld);
void GiveAnimationGroups (void);
void UpdateStatusBar_F2_1 (void);
void UpdateStatusBar_F3_1 (void);
void UpdateStatusBar_F4_1 (void);
void UpdateStatusBar_F5_1 (void);
void UpdateStatusBar_F2_3 (void);
void UpdateStatusBar_F3_3 (void);
void UpdateStatusBar_F5_3 (void);
void UpdateStatusBar_F12_All (void);
int OnLevelBar (void);
void AlwaysJumpThroughMirror (void);
void StringToLower (char *sInput, char *sOutput);
int UsesNative (int iDir, char *sNameWithoutExtension);
void NativeAction (char *sAction);
void NativeOldTile (void);
int Native (int iLocation, SDL_Renderer *screen, int iViaCustom);
void ShowNative (SDL_Renderer *screen);
int OnTileNative (void);
int UseTileNative (int iTile, int iLocation, int iRoom);
void MapAction (char *sAction);
int MapEvents (SDL_Event event);
void MapControllerDown (SDL_Event event);
void MapControllerUp (SDL_Event event);
void MapControllerMotion (SDL_Event event);
void MapButtonDown (SDL_Event event);
void MapButtonUp (SDL_Event event);
void MapKeyDown (SDL_Event event);
void MapKeyUp (SDL_Event event);
void MapMouseMotion (SDL_Event event);
void MapMouseWheel (SDL_Event event);
void MapShow (void);
void MapHide (void);
void ShowMap (void);
int MapGridStartX (void);
int MapGridStartY (void);
float ZoomGet (void);
void ZoomIncrease (void);
void ZoomDecrease (void);
int RelatedToHover1 (int iRoom, int iTile);
int RelatedToHover3 (int iRoom, int iTile);
size_t WriteData (void *ptr, size_t size, size_t nmemb, FILE *stream);
int DownloadAndUnzipTo (char *sURLBase, char *sURLFile, char *sDir);
void CreateDir (char *sDir);
void PlaytestAction (char *sAction, int iLevel);
void Playtest (int iLevel);
void ShowPlaytest (void);
void CheckPlaytestFiles (void);
void AutoUse (int iLevel);
/***/
void Text (void);
void TextLoadSNES (void);
void TextSaveSNES (void);
void ShowText (void);
/***/
void AutomaticLoadSNES (void);
void AutomaticSaveSNES (void);
void AutomaticAction (char *sAction);
void Automatic (void);
void ShowAutomatic (void);
/***/
void JumpToAction (int iType, char *sAction);
void JumpTo (int iType);
void ShowJumpTo (int iType);
int JumpLoc (int iNr, int iAxis);
int JumpAllowed (int iType, int iNr);
void JumpDo (int iType, int iNr);
void ShowAction (int iAction, int iX, int iY);
void Move (int *iTime, int *iAction, int iX, int iY, int iEnd);
void KidAction (char *sAction, int iLocation);
int Kid (int iLocation, SDL_Renderer *screen);
void ShowKid (SDL_Renderer *screen);
void GetHorVer (int iLocation, int *iHor, int *iVer);
int FixDir (int iDir);
void RemoveSpaces (char *sString, int iToUpper);
void HexEditorAction (char *sAction, int iFileSize, int iFdEXE);
void HexEditor (char *sFileName);
void ShowHexEditor (void);
void HexEditorKey (char cAdd);
int GetMapSelTileXY (int iAxis);
void SetMapSelTile (void);

/*****************************************************************************/
int main (int argc, char *argv[])
/*****************************************************************************/
{
	time_t tm;
	int iTemp;
	int iLevel;
	SDL_version verc, verl;
	int iTest;

	iDebug = 0;
	iNoAudio = 0;
	iNoChomp = 1;
	iNoAnim = 0;
	iNoController = 0;
	iNoSave = 0;
	snprintf (sAuthor, MAX_OPTION, "%s user", EDITOR_NAME);
	snprintf (sCheat1, MAX_OPTION, "%s", "megahit");
	snprintf (sCheat2, MAX_OPTION, "%s", "yippeeyahoo");
	iScale = 1;
	iZoom = DEFAULT_ZOOM;
	iFullscreen = 0;
	iStartLevel = 1;
	iExtras = 0;
	iLastThing = 0;
	iLastModifier[1] = 0;
	iLastModifier[2] = 0;
	iLastModifier[3] = 0;
	iLastModifier[4] = 0;
	iLastThingSNES[1] = 0x00;
	iLastThingSNES[2] = 0x00;
	iLastThingSNES[3] = 0x00;
	iLastThingSNES[4] = 0x00;
	iLastModifierSNES = 0x00;
	iCopied = 0;
	iEditPoP = 0;
	iEditNote = 0;
	iEditGuardNr = 0;
	iEditGuardDir = 255;
	iEditGuardType = 1;
	iLoadXML = 0;
	snprintf (sEXEType, MAX_EXETYPE, "%s", "");
	iEXEType = -1;
	iInfo = 0;
	iModified = 0;
	iKidColorsBW = 1; /*** white ***/
	snprintf (sNativeFile[1], MAX_FILE, "%s", "");
	iMapOpen = 0;
	iMapHoverRoom = 0;
	iMapShowNumbers = 0;
	iMapEditPanel = 0;
	iMapSelTile = 1;
	iAutoUse = 0;
	iNativeColor = 0x01;
	iNativeMod = 1;
	iAutomaticSel = 1;
	iJumpSel = 1;
	iEventHover = 0;
	iHexOffset = 0;
	iHitOffset = 0;
	iHitNrChars = 0;
	iHexCursor = 0;
	iUserCode = 0;
	iIgnoreTab = 0;

	CheckSSE();
	CheckLatest();

	if (argc > 1)
	{
		for (iTemp = 1; iTemp <= argc - 1; iTemp++)
		{
			if ((strcmp (argv[iTemp], "-h") == 0) ||
				(strcmp (argv[iTemp], "-?") == 0) ||
				(strcmp (argv[iTemp], "--help") == 0))
			{
				ShowUsage();
			}
			else if ((strcmp (argv[iTemp], "-v") == 0) ||
				(strcmp (argv[iTemp], "--version") == 0))
			{
				printf ("%s %s\n", EDITOR_NAME, EDITOR_VERSION);
				exit (EXIT_NORMAL);
			}
			else if ((strcmp (argv[iTemp], "-x") == 0) ||
				(strcmp (argv[iTemp], "--xml") == 0))
			{
				iEditPoP = 1;
				PoP1Basics();
				for (iLevel = 0; iLevel <= 15; iLevel++)
					{ LoadLevel (iLevel); CallSave (1); }
				printf ("Exported all PoP1 levels to the"
					" \"" XML_DIR "\" directory.\n");
				exit (EXIT_NORMAL);
			}
			else if ((strcmp (argv[iTemp], "-y") == 0) ||
				(strcmp (argv[iTemp], "--import") == 0))
			{
				iLoadXML = 1;
			}
			else if ((strcmp (argv[iTemp], "-d") == 0) ||
				(strcmp (argv[iTemp], "--debug") == 0))
			{
				iDebug = 1;
			}
			else if ((strcmp (argv[iTemp], "-n") == 0) ||
				(strcmp (argv[iTemp], "--noaudio") == 0))
			{
				iNoAudio = 1;
			}
			else if ((strcmp (argv[iTemp], "-q") == 0) ||
				(strcmp (argv[iTemp], "--quiteloud") == 0))
			{
				iNoChomp = 0;
			}
			else if ((strcmp (argv[iTemp], "-i") == 0) ||
				(strcmp (argv[iTemp], "--improved") == 0))
			{
				snprintf (sCheat1, MAX_OPTION, "%s", "improved");
				iUserCode = 1;
			}
			else if ((strcmp (argv[iTemp], "-m") == 0) ||
				(strcmp (argv[iTemp], "--makinit") == 0))
			{
				snprintf (sCheat2, MAX_OPTION, "%s", "makinit");
			}
			else if ((strncmp (argv[iTemp], "-a=", 3) == 0) ||
				(strncmp (argv[iTemp], "--author=", 9) == 0))
			{
				GetOptionValue (argv[iTemp], sAuthor);
				if (iDebug == 1)
					printf ("[ INFO ] Using author name: %s\n", sAuthor);
			}
			else if ((strcmp (argv[iTemp], "-z") == 0) ||
				(strcmp (argv[iTemp], "--zoom") == 0))
			{
				iScale = 2;
			}
			else if ((strcmp (argv[iTemp], "-f") == 0) ||
				(strcmp (argv[iTemp], "--fullscreen") == 0))
			{
				iFullscreen = SDL_WINDOW_FULLSCREEN_DESKTOP;
			}
			else if ((strncmp (argv[iTemp], "-l=", 3) == 0) ||
				(strncmp (argv[iTemp], "--level=", 8) == 0))
			{
				GetOptionValue (argv[iTemp], sStartLevel);
				iStartLevel = atoi (sStartLevel);
			}
			else if ((strncmp (argv[iTemp], "-c=", 3) == 0) ||
				(strncmp (argv[iTemp], "--cheat=", 8) == 0))
			{
				GetOptionValue (argv[iTemp], sCheat1);
				GetOptionValue (argv[iTemp], sCheat2);
				iUserCode = 1;
				if (iDebug == 1)
					printf ("[ INFO ] Using cheat code: %s\n", sCheat1);
			}
			else if ((strcmp (argv[iTemp], "-1") == 0) ||
				(strcmp (argv[iTemp], "--pop1") == 0))
			{
				iEditPoP = 1;
			}
			else if ((strcmp (argv[iTemp], "-2") == 0) ||
				(strcmp (argv[iTemp], "--pop2") == 0))
			{
				iEditPoP = 2;
			}
			else if ((strcmp (argv[iTemp], "-3") == 0) ||
				(strcmp (argv[iTemp], "--snes1") == 0))
			{
				iEditPoP = 3;
			}
			else if ((strcmp (argv[iTemp], "-s") == 0) ||
				(strcmp (argv[iTemp], "--static") == 0))
			{
				iNoAnim = 1;
			}
			else if ((strcmp (argv[iTemp], "-k") == 0) ||
				(strcmp (argv[iTemp], "--keyboard") == 0))
			{
				iNoController = 1;
			}
			else if ((strncmp (argv[iTemp], "-e=", 3) == 0) ||
				(strncmp (argv[iTemp], "--exe=", 6) == 0))
			{
				GetOptionValue (argv[iTemp], sEXEType);
				/*** PoP1 for DOS ***/
				if (strcmp (sEXEType, "p0") == 0) { iEXEType = 0; iEXEPacked = 1; }
				if (strcmp (sEXEType, "u0") == 0) { iEXEType = 1; iEXEPacked = 0; }
				if (strcmp (sEXEType, "p3") == 0) { iEXEType = 2; iEXEPacked = 1; }
				if (strcmp (sEXEType, "u3") == 0) { iEXEType = 3; iEXEPacked = 0; }
				if (strcmp (sEXEType, "p4") == 0) { iEXEType = 4; iEXEPacked = 1; }
				if (strcmp (sEXEType, "u4") == 0) { iEXEType = 5; iEXEPacked = 0; }
				/*** PoP2 for DOS ***/
				if (strcmp (sEXEType, "F0") == 0) { iEXEType = 0; iEXEPacked = 0; }
				if (strcmp (sEXEType, "F1") == 0) { iEXEType = 1; iEXEPacked = 0; }
				if (strcmp (sEXEType, "IR") == 0) { iEXEType = 2; iEXEPacked = 0; }
				if (strcmp (sEXEType, "D0") == 0) { iEXEType = 3; iEXEPacked = 0; }
				if (strcmp (sEXEType, "D1") == 0) { iEXEType = 4; iEXEPacked = 0; }
				/*** PoP1 for SNES ***/
				if (strcmp (sEXEType, "JP") == 0) { iEXEType = 0; iEXEPacked = 0; }
				if (strcmp (sEXEType, "US") == 0) { iEXEType = 1; iEXEPacked = 0; }
				if (strcmp (sEXEType, "EU") == 0) { iEXEType = 2; iEXEPacked = 0; }
				if (iEXEType == -1)
				{
					printf ("[FAILED] Unknown executable type \"%s\"!\n", sEXEType);
					exit (EXIT_ERROR);
				}
			}
			else if ((strncmp (argv[iTemp], "-t=", 3) == 0) ||
				(strncmp (argv[iTemp], "--test=", 7) == 0))
			{
				cCurType = argv[iTemp][strlen (argv[iTemp]) - 1];
				if ((cCurType != 'b') && (cCurType != 'f') &&
					(cCurType != 'g') && (cCurType != 'h') &&
					(cCurType != 'i') && (cCurType != 'j') &&
					(cCurType != 'l') && (cCurType != 'm') &&
					(cCurType != 's') && (cCurType != 'u'))
				{
					printf ("[FAILED] Unknown env type \"%c\"!\n", cCurType);
					exit (EXIT_ERROR);
				}
				iEditPoP = 3;
				for (iTest = 1; iTest <= 48; iTest++)
				{
					printf ("[ INFO ] Tile %i:\n", iTest);
					UseTile (iTest, 12, 1, 1); /*** above space ***/
					UseTile (iTest, 12, 1, 2); /*** above pillar ***/
					UseTile (iTest, 12, 1, 3); /*** above wall ***/
					UseTile (iTest, 12, 1, 4); /*** above gate ***/
				}
				exit (EXIT_NORMAL);
			}
			else
			{
				ShowUsage();
			}
		}
	}
	srand ((unsigned)time(&tm));

	/*** Show the SDL version used for compiling and linking. ***/
	if (iDebug == 1)
	{
		SDL_VERSION (&verc);
		SDL_GetVersion (&verl);
		printf ("[ INFO ] Compiled with SDL %u.%u.%u, linked with SDL %u.%u.%u.\n",
			verc.major, verc.minor, verc.patch, verl.major, verl.minor, verl.patch);
	}

	CheckRequiredFiles();
	InitScreen();
	Quit();

	return 0;
}
/*****************************************************************************/
void CheckSSE (void)
/*****************************************************************************/
{
	if (SDL_HasSSE() == SDL_FALSE)
	{
		printf ("[ WARN ] Your CPU has no Streaming SIMD"
			" Extensions (SSE) features!\n");
	}
}
/*****************************************************************************/
void CheckLatest (void)
/*****************************************************************************/
{
	/* After using this function, sLatest is either empty or - if a newer
	 * version is available - contains the latest version number.
	 */

	CURL *curl;
	CURLcode res;
	FILE *fFile;
	int iFd;
	int iLine;
	int iEOF;
	char sLine[MAX_DATA + 2];
	char sValue[MAX_DATA + 2];
	int iMajor, iMinor, iPatch;

	/*** Default. ***/
	snprintf (sLatest, MAX_TEXT, "%s", "");

	curl = curl_easy_init();
	if (curl != NULL)
	{
		fFile = fopen ("latest_release.xml", "wb");
		curl_easy_setopt (curl, CURLOPT_URL, URL_LATEST);
		curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION, WriteData);
		curl_easy_setopt (curl, CURLOPT_WRITEDATA, fFile);
		curl_easy_setopt (curl, CURLOPT_FAILONERROR, 1L);
		/* Without this, the Windows port will say "Peer certificate cannot be
		 * authenticated with given CA certificates!". This may be related to
		 * the (old?) cURL version.
		 */
		curl_easy_setopt (curl, CURLOPT_SSL_VERIFYPEER, 0);
		/*** Without this, the connect timeout will be 300 seconds. ***/
		curl_easy_setopt (curl, CURLOPT_CONNECTTIMEOUT, 3L);
		res = curl_easy_perform (curl);
		curl_easy_cleanup (curl);
		fclose (fFile);
		if (res == CURLE_OK)
		{
			iFd = open ("latest_release.xml", O_RDONLY);
			if (iFd != -1)
			{
				iLine = 0;
				iMajor = 0; iMinor = 0; iPatch = 0; /*** Fallback. ***/
				do {
					iEOF = ReadLineFromFile (iFd, sLine, 1); iLine++;

					switch (iLine)
					{
						case 5: /*** major ***/
							substr (sLine, 7, strpos (sLine, "</major>", 0) - 7, sValue);
							iMajor = atoi (sValue); break;
						case 6: /*** minor ***/
							substr (sLine, 7, strpos (sLine, "</minor>", 0) - 7, sValue);
							iMinor = atoi (sValue); break;
						case 7: /*** patch ***/
							substr (sLine, 7, strpos (sLine, "</patch>", 0) - 7, sValue);
							iPatch = atoi (sValue); break;
					}
				} while (iEOF == 0);
				if ((iMajor > EDITOR_VERSION_MAJOR) ||
					((iMajor == EDITOR_VERSION_MAJOR) &&
					(iMinor > EDITOR_VERSION_MINOR)) ||
					((iMajor == EDITOR_VERSION_MAJOR) &&
					(iMinor == EDITOR_VERSION_MINOR) &&
					(iPatch > EDITOR_VERSION_PATCH)))
				{
					/*** A newer version is available. ***/
					if (iPatch == 0)
					{
						snprintf (sLatest, MAX_TEXT, "%i.%i", iMajor, iMinor);
					} else {
						snprintf (sLatest, MAX_TEXT, "%i.%i.%i", iMajor, iMinor, iPatch);
					}
				}
			}
		}
		unlink ("latest_release.xml");
	}
}
/*****************************************************************************/
void CheckRequiredFiles (void)
/*****************************************************************************/
{
	DIR *dDir;
	struct dirent *stDirent;
	char sExtension[100 + 2];
	int iFound;

	/*** PoP1 ***/
	if (access (LEVELS_DAT, R_OK|W_OK) == -1)
	{
		if (iEditPoP != 1)
		{
			printf ("[ WARN ] %s: %s!\n", LEVELS_DAT, strerror (errno));
			iPoP1 = 0;
		} else {
			/*** Started with "-1". ***/
			printf ("[FAILED] %s: %s!\n", LEVELS_DAT, strerror (errno));
			exit (EXIT_ERROR);
		}
	} else {
		iPoP1 = 1;
		CheckPlaytestFiles();
	}

	/*** PoP2 ***/
	if (access (PRINCE_DAT, R_OK|W_OK) == -1)
	{
		printf ("[ WARN ] %s: %s!\n", PRINCE_DAT, strerror (errno));
		iPoP2 = 0;
	} else { iPoP2 = 1; }

	/*** PoP1 for SNES ***/
	iFound = 0;
	dDir = opendir (SNES_DIR);
	if (dDir == NULL)
	{
		printf ("[ WARN ] %s: %s!\n", SNES_DIR, strerror (errno));
		iPoP1SNES = 0;
	} else {
		while ((stDirent = readdir (dDir)) != NULL)
		{
			if (iFound == 0)
			{
				if ((strcmp (stDirent->d_name, ".") != 0) &&
					(strcmp (stDirent->d_name, "..") != 0))
				{
					snprintf (sExtension, 100, "%s", strrchr (stDirent->d_name, '.'));
					if ((toupper (sExtension[1]) == 'S') &&
						(toupper (sExtension[2]) == 'M') &&
						(toupper (sExtension[3]) == 'C'))
						{ iFound = 1; } /*** Super Magicom ***/
					if ((toupper (sExtension[1]) == 'S') &&
						(toupper (sExtension[2]) == 'F') &&
						(toupper (sExtension[3]) == 'C'))
						{ iFound = 1; } /*** Super Famicom ***/
					if (iFound == 1)
					{
						snprintf (sSNESFile, MAX_FILE, "%s%s", SNES_DIR, stDirent->d_name);
						if (iDebug == 1)
						{
							printf ("[ INFO ] Found SMC file \"%s\".\n", stDirent->d_name);
						}
					}
				}
			}
		}
		if (iFound == 0)
		{
			printf ("[ WARN ] %s: Could not find a (.smc or .sfc) ROM file!\n",
				SNES_DIR);
			iPoP1SNES = 0;
		} else {
			if (access (sSNESFile, R_OK|W_OK) == -1)
			{
				printf ("[ WARN ] %s: %s!\n", sSNESFile, strerror (errno));
				iPoP1SNES = 0;
			} else { iPoP1SNES = 1; }
		}
	}
	closedir (dDir);

	/*** PR ***/
	if (((access (PR_EXECUTABLE, R_OK) == -1) &&
		((iPoP1 == 1) || (iPoP2 == 1))) ||
		((access (PR_RESOURCES, R_OK) == -1) && (iPoP1 == 1)) ||
		((access (PR_POP2, R_OK) == -1) && (iPoP2 == 1)))
	{
		printf ("[FAILED] %s or %s or %s: %s!\n", PR_EXECUTABLE, PR_RESOURCES,
			PR_POP2, strerror (errno));
		iPR = 0;
	} else { iPR = 1; }
}
/*****************************************************************************/
void LoadPLV (char *sFileName)
/*****************************************************************************/
{
	int iFd;
	int iRoom;
	int iTile;
	int iTemp;
	int iTemp2;
	int iUD;
	int iStatic;
	int iDynamic;
	char sBinaryFore[9 + 2]; /*** 8 chars, plus \0 ***/
	char sBinaryMod[9 + 2]; /*** 8 chars, plus \0 ***/
	char sBinaryModMore[9 + 2]; /*** 8 chars, plus \0 ***/
	char sString[MAX_DATA + 2];
	char sTemp[100 + 2];
	unsigned long luNumber;
	char sReferenceNr[7 + 2];
	int iFieldOrValue;
	int iForeSize, iModiSize;
	int iForePos, iBackPos;
	int iModDone;
	char sName[7 + 2];
	char sModifiers[100 + 2];
	char sModifiersTemp[100 + 2];
	char sForegrounds[100 + 2];
	char sForegroundsTemp[100 + 2];

	/*** For PoP2 luLevelNr. ***/
	char cFirst;
	char cSecond;
	char sFirstSecond[MAX_TEXT + 2];
	int iFirstSecond;

	/*** Everything on the foreground of the level. ***/
	unsigned char sLevelForeground[960 + 2]; /*** PoP1 only uses 720. ***/
	/*** The modifiers of the level. ***/
	unsigned char sLevelModifier[3840 + 2]; /*** PoP1 only uses 720. ***/

	/*** Used for looping. ***/
	int iLoopPlayer;

	iChanged = 0;

	/*** Open file. ***/
	iFd = open (sFileName, O_RDONLY|O_BINARY);
	if (iFd == -1)
	{
		printf ("[FAILED] Could not open %s: %s!\n", sFileName, strerror (errno));
		printf ("[ INFO ] PR did not (or incorrectly) export this level\n\n");
		exit (EXIT_ERROR);
	}

	/*** Check the Magic ID. ***/
	ReadFromFile (iFd, "Magic ID", 7, sMagicID);
	snprintf (sString, MAX_DATA, "%s", sMagicID);
	if (strcmp (sString, "POP_LVL") != 0)
	{ printf ("[FAILED] This is not a POP level!\n"); exit (EXIT_ERROR); }

	/*** Check the POP Version. ***/
	ReadFromFile (iFd, "POP Version", 1, sPOPVersion);
	if ((iEditPoP == 1) && (sPOPVersion[0] != 0x01))
		{ printf ("[FAILED] This is not a PoP1 level!\n"); exit (EXIT_ERROR); }
	if ((iEditPoP == 2) && (sPOPVersion[0] != 0x02))
		{ printf ("[FAILED] This is not a PoP2 level!\n"); exit (EXIT_ERROR); }

	/*** Check the PLV Version. ***/
	ReadFromFile (iFd, "PLV Version", 1, sPLVVersion);
	if ((sPLVVersion[0] != 0x01) && (iDebug == 1))
	{ printf ("[ INFO ] Strange version detected: %02x\n", sPLVVersion[0]); }

	/*** Load the level number. ***/
	ReadFromFile (iFd, "Level Number", 1, sLevelNumber);
	if (iEditPoP == 1)
	{
		snprintf (sString, MAX_DATA, "%02x", sLevelNumber[0]);
		luLevelNr = strtoul (sString, NULL, 16);
	} else {
		cFirst = sFileName[strlen (sFileName) - 6];
		cSecond = sFileName[strlen (sFileName) - 5];
		snprintf (sFirstSecond, MAX_TEXT, "%c%c", cFirst, cSecond);
		iFirstSecond = atoi (sFirstSecond);
		if ((iFirstSecond >= 0) && (iFirstSecond <= 13))
			{ luLevelNr = iFirstSecond + 1; }
				else { luLevelNr = iFirstSecond - 5; }
	}
	if (iDebug == 1)
	{
		printf ("[ INFO ] The level number is: %lu\n", luLevelNr);
	}

	/*** Load the number of fields. ***/
	ReadFromFile (iFd, "Number Of Fields", 4, sNumberOfFields);
	snprintf (sString, MAX_DATA, "%02x%02x%02x%02x", sNumberOfFields[3],
		sNumberOfFields[2], sNumberOfFields[1], sNumberOfFields[0]);
	luNumber = strtoul (sString, NULL, 16);
	luNumberOfFields = luNumber;
	if (iDebug == 1)
	{
		printf ("[ INFO ] The number of user data fields is: %lu\n", luNumber);
	}

	/*** Load the level size. ***/
	ReadFromFile (iFd, "Level Size", 4, sLevelSize);
	snprintf (sString, MAX_DATA, "%02x%02x%02x%02x", sLevelSize[3],
		sLevelSize[2], sLevelSize[1], sLevelSize[0]);
	luLevelSize = strtoul (sString, NULL, 16);
	if (((iEditPoP == 1) && ((luLevelSize < 2304) || (luLevelSize > 2305))) ||
		((iEditPoP == 2) && (luLevelSize != 12025)))
	{
		printf ("[FAILED] Level has an incorrect size: %lu!\n", luLevelSize);
		exit (EXIT_ERROR);
	}
	if (iDebug == 1)
	{
		printf ("[ INFO ] The level size is: %lu\n", luLevelSize);
	}

	/*** Load the checksum. ***/
	ReadFromFile (iFd, "Checksum", 1, sChecksum);

	/*** Load the level foreground and modifier. ***/
	snprintf (sForegrounds, 100, "%s", "");
	snprintf (sModifiers, 100, "%s", "");
	if (iEditPoP == 1)
		{ iForeSize = 720; iModiSize = 720; }
			else { iForeSize = 960; iModiSize = 3840; }
	ReadFromFile (iFd, "Level Foreground", iForeSize, sLevelForeground);
	ReadFromFile (iFd, "Level Modifier", iModiSize, sLevelModifier);
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		if (iDebug == 1) { printf ("\nRoom %i:\n\n", iRoom); }
		for (iTile = 0; iTile <= 29; iTile++)
		{
			iForePos = ((iRoom * 30) - 30) + iTile;
			if (iEditPoP == 1)
				{ iBackPos = iForePos; }
					else { iBackPos = ((iRoom * (30 * 4)) - (30 * 4)) + (iTile * 4); }

			/*** foreground ***/
			GetAsEightBits (sLevelForeground[iForePos], sBinaryFore);
			GetForegroundAsName (sBinaryFore, sName);
			iThingA[iRoom][iTile] = (int)sLevelForeground[iForePos];

			/*** Add to sForegrounds. ***/
			if (strcmp (sForegrounds, "") == 0)
			{
				snprintf (sForegrounds, 100, "%s", sName);
			} else {
				snprintf (sForegroundsTemp, 100, "%s", sForegrounds);
				snprintf (sForegrounds, 100, "%s|%s", sForegroundsTemp, sName);
			}

			/*** modifier ***/
			GetAsEightBits (sLevelModifier[iBackPos], sBinaryMod);
			if (iEditPoP == 2)
			{
				GetAsEightBits (sLevelModifier[iBackPos + 1], sBinaryModMore);
				iModifierA[iRoom][iTile][2] = BitsToInt (sBinaryModMore);
				GetAsEightBits (sLevelModifier[iBackPos + 2], sBinaryModMore);
				iModifierA[iRoom][iTile][3] = BitsToInt (sBinaryModMore);
				GetAsEightBits (sLevelModifier[iBackPos + 3], sBinaryModMore);
				iModifierA[iRoom][iTile][4] = BitsToInt (sBinaryModMore);
			}

			iModDone = 0;

			/*** gate or door ***/
			if ((iThingA[iRoom][iTile] == 4) ||
				(iThingA[iRoom][iTile] == 36))
			{
				if (iDebug == 1)
				{
					switch (BitsToInt (sBinaryMod))
					{
						case 1:
							snprintf (sName, 9, "%s", "Open   ");
							break;
						default:
							snprintf (sName, 9, "%s", "Closed ");
							break;
					}
				}
				iModifierA[iRoom][iTile][1] = BitsToInt (sBinaryMod);
				iModDone = 1;
			}

			/*** drop or raise ***/
			if ((iThingA[iRoom][iTile] == 6) ||
				(iThingA[iRoom][iTile] == 15) ||
				(iThingA[iRoom][iTile] == 38) ||
				(iThingA[iRoom][iTile] == 47))
			{
				snprintf (sString, 3 + 6, "%i      ",
					BitsToInt (sBinaryMod) + 1);
				strncpy (sReferenceNr, sString, 7);
				sReferenceNr[7] = '\0';
				snprintf (sName, 9, "%s", sReferenceNr);
				iModifierA[iRoom][iTile][1] = BitsToInt (sBinaryMod);
				iModDone = 1;
			}

			/*** the rest ***/
			if (iModDone == 0)
			{
				GetModifierAsName (BitsToInt (sBinaryFore),
					BitsToInt (sBinaryMod), sName);
				iModifierA[iRoom][iTile][1] = (int)sLevelModifier[iBackPos];
			}

			/*** Add to sModifiers. ***/
			if (strcmp (sModifiers, "") == 0)
			{
				snprintf (sModifiers, 100, "%s", sName);
			} else {
				snprintf (sModifiersTemp, 100, "%s", sModifiers);
				snprintf (sModifiers, 100, "%s|%s", sModifiersTemp, sName);
			}

			/*** Display the room. ***/
			if (iDebug == 1)
			{
				if ((iTile == 9) || (iTile == 19) || (iTile == 29))
				{
					printf ("%s\n", sForegrounds);
					printf ("%s\n", sModifiers);
					if ((iTile == 9) || (iTile == 19))
					{
						for (iTemp = 1; iTemp <= 79; iTemp++) { printf ("-"); }
						printf ("\n");
					}
					snprintf (sForegrounds, 100, "%s", "");
					snprintf (sModifiers, 100, "%s", "");
				}
			}
		}
		PrIfDe ("\n");
	}

	/*** Load first and second door events. ***/
	if (iEditPoP == 1)
	{
		ReadFromFile (iFd, "First Door Events", 256, sFirstDoorEvents);
		ReadFromFile (iFd, "Second Door Events", 256, sSecondDoorEvents);
	} else {
		ReadFromFile (iFd, "PoP2 Door Events", 1280, sPoP2DoorEvents);

		for (iTemp = 0; iTemp < 256; iTemp++)
		{
			iPoP2DoorRoom[iTemp] = sPoP2DoorEvents[(iTemp * 5) + 0];
			iPoP2DoorLocation[iTemp] = sPoP2DoorEvents[(iTemp * 5) + 1];
			iPoP2DoorType[iTemp] = sPoP2DoorEvents[(iTemp * 5) + 2];
			iPoP2DoorLeft[iTemp] = sPoP2DoorEvents[(iTemp * 5) + 3];
			iPoP2DoorRight[iTemp] = sPoP2DoorEvents[(iTemp * 5) + 4];

			/*** Some events in (the original) PoP2 point to non-exist. tiles. ***/
			if ((iPoP2DoorRoom[iTemp] < 1) || (iPoP2DoorRoom[iTemp] > iRooms))
				{ iPoP2DoorRoom[iTemp] = 1; }
			if ((iPoP2DoorLocation[iTemp] < 0) || (iPoP2DoorLocation[iTemp] > 29))
				{ iPoP2DoorLocation[iTemp] = 0; }
		}
	}
	if (iDebug == 1)
	{
		if (iEditPoP == 1)
		{
			for (iTemp = 0; iTemp < 256; iTemp++)
			{
				printf ("[ INFO ] Event %i changes the door in room: %i, location:"
					" %i.", iTemp + 1, EventInfo (iTemp, 1), EventInfo (iTemp, 2));
				switch (EventInfo (iTemp, 3))
				{
					case 1: printf (" (next: yes)\n"); break;
					case 0: printf (" (next: no)\n"); break;
				}
			}
		} else {
			for (iTemp = 0; iTemp < 256; iTemp++)
			{
				printf ("[ INFO ] Event %i changes room: %i, loc: %i."
					" (t: %i, l: %i, r: %i)\n", iTemp + 1, iPoP2DoorRoom[iTemp],
					iPoP2DoorLocation[iTemp], iPoP2DoorType[iTemp],
					iPoP2DoorLeft[iTemp], iPoP2DoorRight[iTemp]);
			}
		}
	}

	/*** Load the room links. ***/
	ReadFromFile (iFd, "Room Links", iRoomLinks, sRoomLinks);
	for (iTemp = 0; iTemp < iRoomLinks; iTemp+=4)
	{
		iRoomConnections[(iTemp / 4) + 1][1] =
			sRoomLinks[iTemp]; /*** left ***/
		iRoomConnections[(iTemp / 4) + 1][2] =
			sRoomLinks[iTemp + 1]; /*** right ***/
		iRoomConnections[(iTemp / 4) + 1][3] =
			sRoomLinks[iTemp + 2]; /*** up ***/
		iRoomConnections[(iTemp / 4) + 1][4] =
			sRoomLinks[iTemp + 3]; /*** down ***/
		if (iDebug == 1)
		{
			printf ("[ INFO ] Room %i is connected to room (0 = none): l%i, "
				"r%i, u%i, d%i\n", (iTemp / 4) + 1, sRoomLinks[iTemp],
				sRoomLinks[iTemp + 1], sRoomLinks[iTemp + 2], sRoomLinks[iTemp + 3]);
		}
	}

	if (iEditPoP == 1)
	{
		/*** Load Unknown I. ***/
		ReadFromFile (iFd, "Unknown I", 64, sUnknownI);
		/*** We want remapped modifiers in all 24 rooms. ***/
		sUnknownI[0] = 0x18;

		/*** number of players ***/
		if (sUnknownI[1] == 0x01)
		{
			iNrPlayers = sUnknownI[2];
			if ((iNrPlayers < 1) || (iNrPlayers > 8))
			{
				printf ("[ WARN ] Invalid # players: %i\n", iNrPlayers);
				if (iNrPlayers < 1) { iNrPlayers = 1; }
				if (iNrPlayers > 8) { iNrPlayers = 8; }
			}
		} else {
			iNrPlayers = 1;
		}
	} else {
		ReadFromFile (iFd, "Last Room", 1, sLastRoom);
		ReadFromFile (iFd, "JEFF", 4, sJEFF);
		ReadFromFile (iFd, "Level Type", 1, sLevelTypeC);
		ReadFromFile (iFd, "Unknown I", 1, sUnknownI);
		ReadFromFile (iFd, "Level Number Events", 1, sLevelInit);
		ReadFromFile (iFd, "Extra Resources", 24, sExtraImgResources);

		if (iDebug == 1)
		{
			printf ("[ INFO ] Extra resources: ");
			for (iTemp = 0; iTemp < 24; iTemp++)
			{
				printf ("%i", sExtraImgResources[iTemp]);
				if (iTemp != 23) { printf (","); }
			}
			printf ("\n");
		}
	}

	/*** Load Start Position (P1). ***/
	ReadFromFile (iFd, "Start Position", 3, sStartPosition);

	/*** player(s) ***/
	for (iLoopPlayer = 1; iLoopPlayer <= 8; iLoopPlayer++)
	{
		arKidU1[iLoopPlayer] = 0xFF; /*** disabled ***/
		arKidU2[iLoopPlayer] = 0xFF; /*** disabled ***/
		arKidU3[iLoopPlayer] = 0xFF; /*** disabled ***/
		arKidU4[iLoopPlayer] = 0xFF; /*** disabled ***/
		arKidClr[iLoopPlayer] = 0x3F; /*** approx. ***/
		arKidRoom[iLoopPlayer] = sStartPosition[0];
		arKidPos[iLoopPlayer] = sStartPosition[1] + 1;
		arKidDir[iLoopPlayer] = FixDir (sStartPosition[2]);
	}
	if (iNrPlayers == 8)
	{
		arKidU1[8] = sUnknownI[3];
		arKidU2[8] = sUnknownI[4];
		arKidU3[8] = sUnknownI[5];
		arKidU4[8] = sUnknownI[6];
		arKidClr[8] = sUnknownI[7];
		arKidRoom[8] = sUnknownI[8];
		arKidPos[8] = sUnknownI[9] + 1;
		arKidDir[8] = FixDir (sUnknownI[10]);
	}
	if (iNrPlayers >= 7)
	{
		arKidU1[7] = sUnknownI[11];
		arKidU2[7] = sUnknownI[12];
		arKidU3[7] = sUnknownI[13];
		arKidU4[7] = sUnknownI[14];
		arKidClr[7] = sUnknownI[15];
		arKidRoom[7] = sUnknownI[16];
		arKidPos[7] = sUnknownI[17] + 1;
		arKidDir[7] = FixDir (sUnknownI[18]);
	}
	if (iNrPlayers >= 6)
	{
		arKidU1[6] = sUnknownI[19];
		arKidU2[6] = sUnknownI[20];
		arKidU3[6] = sUnknownI[21];
		arKidU4[6] = sUnknownI[22];
		arKidClr[6] = sUnknownI[23];
		arKidRoom[6] = sUnknownI[24];
		arKidPos[6] = sUnknownI[25] + 1;
		arKidDir[6] = FixDir (sUnknownI[26]);
	}
	if (iNrPlayers >= 5)
	{
		arKidU1[5] = sUnknownI[27];
		arKidU2[5] = sUnknownI[28];
		arKidU3[5] = sUnknownI[29];
		arKidU4[5] = sUnknownI[30];
		arKidClr[5] = sUnknownI[31];
		arKidRoom[5] = sUnknownI[32];
		arKidPos[5] = sUnknownI[33] + 1;
		arKidDir[5] = FixDir (sUnknownI[34]);
	}
	if (iNrPlayers >= 4)
	{
		arKidU1[4] = sUnknownI[35];
		arKidU2[4] = sUnknownI[36];
		arKidU3[4] = sUnknownI[37];
		arKidU4[4] = sUnknownI[38];
		arKidClr[4] = sUnknownI[39];
		arKidRoom[4] = sUnknownI[40];
		arKidPos[4] = sUnknownI[41] + 1;
		arKidDir[4] = FixDir (sUnknownI[42]);
	}
	if (iNrPlayers >= 3)
	{
		arKidU1[3] = sUnknownI[43];
		arKidU2[3] = sUnknownI[44];
		arKidU3[3] = sUnknownI[45];
		arKidU4[3] = sUnknownI[46];
		arKidClr[3] = sUnknownI[47];
		arKidRoom[3] = sUnknownI[48];
		arKidPos[3] = sUnknownI[49] + 1;
		arKidDir[3] = FixDir (sUnknownI[50]);
	}
	if (iNrPlayers >= 2)
	{
		arKidU1[2] = sUnknownI[51];
		arKidU2[2] = sUnknownI[52];
		arKidU3[2] = sUnknownI[53];
		arKidU4[2] = sUnknownI[54];
		arKidClr[2] = sUnknownI[55];
		arKidRoom[2] = sUnknownI[56];
		arKidPos[2] = sUnknownI[57] + 1;
		arKidDir[2] = FixDir (sUnknownI[58]);
		/***/
		arKidU1[1] = sUnknownI[59];
		arKidU2[1] = sUnknownI[60];
		arKidU3[1] = sUnknownI[61];
		arKidU4[1] = sUnknownI[62];
		arKidClr[1] = sUnknownI[63];
	}
	arKidRoom[1] = sStartPosition[0];
	arKidPos[1] = sStartPosition[1] + 1;
	arKidDir[1] = FixDir (sStartPosition[2]); /*** 1 of 4 (DOS) ***/

	if (iEditPoP != 1)
	{
		if ((luLevelNr == 2) || (luLevelNr == 16) ||
			(((luLevelNr == 1) || (luLevelNr == 15)) && (arKidRoom[1] == 4)) ||
			(((luLevelNr == 6) || (luLevelNr == 20)) && (arKidRoom[1] == 27)) ||
			(((luLevelNr == 10) || (luLevelNr == 24)) && (arKidRoom[1] == 22)) ||
			(((luLevelNr == 14) || (luLevelNr == 28)) && (arKidRoom[1] == 1)))
		{
			if (arKidDir[1] == 0) { arKidDir[1] = 255; } else { arKidDir[1] = 0; }
		}
	}
	if (iDebug == 1)
	{
		printf ("[ INFO ] The kid starts in room: %i, position: %i, turned: "
			"%c\n", arKidRoom[1], arKidPos[1], cShowDirection (arKidDir[1]));
	}

	PrIfDe ("[  OK  ] Checking for broken room links.\n");
	iBrokenRoomLinks = BrokenRoomLinks (1);

	/*** Load Unknown II-IVd, guard data, checkpoints, music. ***/
	if (iEditPoP == 1)
	{
		switch ((int)luLevelNr)
		{
			case 15: /*** potions level ***/
				ReadFromFile (iFd, "Unknown II and III", 3, sUnknownIIandIII); break;
			default:
				ReadFromFile (iFd, "Unknown II and III", 4, sUnknownIIandIII); break;
		}
		ReadFromFile (iFd, "Guard Locations", iRooms, sGuardLocations);
		ReadFromFile (iFd, "Guard Directions", iRooms, sGuardDirections);
		ReadFromFile (iFd, "Unknown IVa and IVb", 48, sUnknownIVaandIVb);
		ReadFromFile (iFd, "Guard Skills", iRooms, sGuardSkills);
		ReadFromFile (iFd, "Unknown IVc", 24, sUnknownIVc);
		ReadFromFile (iFd, "Guard Colors", iRooms, sGuardColors);
		ReadFromFile (iFd, "Unknown IVd", 16, sUnknownIVd);
	} else {
		ReadFromFile (iFd, "Unknown II", 3, sUnknownII);
		ReadFromFile (iFd, "Level Guard Type", 1, sLevelGuardTypeC);
		ReadFromFile (iFd, "Static Guards", iRooms * 116, sStaticGuards);
		ReadFromFile (iFd, "Check Points", 18, sCheckPoints);
		ReadFromFile (iFd, "Dynamic Guards", iRooms * 34, sDynamicGuards);
		ReadFromFile (iFd, "Music", iRooms * 30, sMusic);

		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			iStaticGuards_Amount[iTemp] = sStaticGuards[(iTemp * 116) + 0];
			for (iStatic = 0; iStatic < STATIC; iStatic++)
			{
				iStaticGuards_1_Locations[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 1];
				iStaticGuards_2_Offsets1[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 2];
				iStaticGuards_3_Offsets2[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 3];
				iStaticGuards_4_Directions[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 4];
				iStaticGuards_5_Skills[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 5];
				iStaticGuards_6_Mod[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 6];
				iStaticGuards_7_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 7];
				iStaticGuards_8_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 8];
				iStaticGuards_9_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 9];
				iStaticGuards_10_Colors[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 10];
				iStaticGuards_11_Number[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 11];
				iStaticGuards_12_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 12];
				iStaticGuards_13_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 13];
				iStaticGuards_14_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 14];
				iStaticGuards_15_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 15];
				iStaticGuards_16_Type[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 16];
				iStaticGuards_17_Hitpoints[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 17];
				if (iStaticGuards_17_Hitpoints[iTemp][iStatic] > 128)
				{
					iStaticGuards_17_Hitpoints[iTemp][iStatic]-=128;
				}
				iStaticGuards_18_SkelAct1[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 18];
				iStaticGuards_19_SkelAct2[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 19];
				iStaticGuards_20_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 20];
				iStaticGuards_21_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 21];
				iStaticGuards_22_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 22];
				iStaticGuards_23_Unknown[iTemp][iStatic] =
					sStaticGuards[(iTemp * 116) + (iStatic * 23) + 23];
			}
		}

		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			iDynamicGuards_Sets[iTemp] = sDynamicGuards[(iTemp * 34) + 0];
			iDynamicGuards_Skill[iTemp] = sDynamicGuards[(iTemp * 34) + 1];
			iDynamicGuards_Unknown1[iTemp] = sDynamicGuards[(iTemp * 34) + 2];
			iDynamicGuards_Unknown2[iTemp] = sDynamicGuards[(iTemp * 34) + 3];
			for (iDynamic = 0; iDynamic < DYNAMIC; iDynamic++)
			{
				iDynamicGuards_1_SetNr[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 4];
				iDynamicGuards_2_MaxTog[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 5];
				iDynamicGuards_3_Row[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 6];
				iDynamicGuards_4_Column[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 7];
				iDynamicGuards_5_LatBefore[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 8];
				iDynamicGuards_6_LatBetween[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 9];
				iDynamicGuards_7_CanJump[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 10];
				iDynamicGuards_8_PrinceRow[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 11];
				iDynamicGuards_9_Amount[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 12];
				iDynamicGuards_10_Hitpoints[iTemp][iDynamic] =
					sDynamicGuards[(iTemp * 34) + (iDynamic * 10) + 13];
				if (iDynamicGuards_10_Hitpoints[iTemp][iDynamic] > 128)
				{
					iDynamicGuards_10_Hitpoints[iTemp][iDynamic]-=128;
				}
			}
		}

		for (iTemp = 0; iTemp < 18; iTemp++)
		{
			iCheckPoints[iTemp] = (int)sCheckPoints[iTemp];
		}
	}

	if (iEditPoP == 1)
	{
		/*** Load and display the end code. ***/
		ReadFromFile (iFd, "End Code", 2, sEndCode);
		snprintf (sString, MAX_DATA, "%02x%02x", sEndCode[0], sEndCode[1]);
		if (iDebug == 1)
		{
			printf ("[ INFO ] The end code is (usually 0f09): %s\n", sString);
		}
	}

	/*** Display guard information. ***/
	if (iDebug == 1)
	{
		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			if (iEditPoP == 1)
			{
				if (sGuardLocations[iTemp] <= 29)
				{
					printf ("[ INFO ] A guard in room: %i, location: %i, turned: %c, "
						"skill: %i, color: %i\n", iTemp + 1, sGuardLocations[iTemp] + 1,
						cShowDirection (sGuardDirections[iTemp]), sGuardSkills[iTemp],
						sGuardColors[iTemp]);
					if (((sUnknownIVaandIVb[iTemp] != 255) && (sUnknownIVaandIVb[iTemp]
						!= 0)) || ((sUnknownIVaandIVb[iTemp + 24] != 255) &&
						(sUnknownIVaandIVb[iTemp + 24] != 0)) ||
						((sUnknownIVc[iTemp] != 255) && (sUnknownIVc[iTemp] != 0)))
					{
						printf ("[ INFO ] Extra data for the above guard: "
							"%i|%i|%i\n", sUnknownIVaandIVb[iTemp],
							sUnknownIVaandIVb[iTemp + 24], sUnknownIVc[iTemp]);
					}
				}
			} else {
				printf ("[ INFO ] Static guards in room %i: %i\n",
					iTemp + 1, iStaticGuards_Amount[iTemp]);
				if (iStaticGuards_Amount[iTemp] > 0)
				{
					for (iStatic = 0; iStatic < iStaticGuards_Amount[iTemp]; iStatic++)
					{
						printf ("[ INFO ] Static guard %i: %i|%i|%i|%i|%i|%i|%i|%i|%i|%i"
							"|%i|%i|%i|%i|%i|%i|%i|%i|%i|%i|%i|%i|%i\n", iStatic + 1,
							iStaticGuards_1_Locations[iTemp][iStatic],
							iStaticGuards_2_Offsets1[iTemp][iStatic],
							iStaticGuards_3_Offsets2[iTemp][iStatic],
							iStaticGuards_4_Directions[iTemp][iStatic],
							iStaticGuards_5_Skills[iTemp][iStatic],
							iStaticGuards_6_Mod[iTemp][iStatic],
							iStaticGuards_7_Unknown[iTemp][iStatic],
							iStaticGuards_8_Unknown[iTemp][iStatic],
							iStaticGuards_9_Unknown[iTemp][iStatic],
							iStaticGuards_10_Colors[iTemp][iStatic],
							iStaticGuards_11_Number[iTemp][iStatic],
							iStaticGuards_12_Unknown[iTemp][iStatic],
							iStaticGuards_13_Unknown[iTemp][iStatic],
							iStaticGuards_14_Unknown[iTemp][iStatic],
							iStaticGuards_15_Unknown[iTemp][iStatic],
							iStaticGuards_16_Type[iTemp][iStatic],
							iStaticGuards_17_Hitpoints[iTemp][iStatic],
							iStaticGuards_18_SkelAct1[iTemp][iStatic],
							iStaticGuards_19_SkelAct2[iTemp][iStatic],
							iStaticGuards_20_Unknown[iTemp][iStatic],
							iStaticGuards_21_Unknown[iTemp][iStatic],
							iStaticGuards_22_Unknown[iTemp][iStatic],
							iStaticGuards_23_Unknown[iTemp][iStatic]);
					}
				}

				printf ("[ INFO ] Dynamic guard sets in room %i: %i\n",
					iTemp + 1, iDynamicGuards_Sets[iTemp]);
				if (iDynamicGuards_Sets[iTemp] > 0)
				{
					for (iDynamic = 0; iDynamic < iDynamicGuards_Sets[iTemp]; iDynamic++)
					{
						printf ("[ INFO ] Dynamic guard %i: "
							"%i|%i|%i|%i|%i|%i|%i|%i|%i|%i\n",
							iDynamic + 1,
							iDynamicGuards_1_SetNr[iTemp][iDynamic],
							iDynamicGuards_2_MaxTog[iTemp][iDynamic],
							iDynamicGuards_3_Row[iTemp][iDynamic],
							iDynamicGuards_4_Column[iTemp][iDynamic],
							iDynamicGuards_5_LatBefore[iTemp][iDynamic],
							iDynamicGuards_6_LatBetween[iTemp][iDynamic],
							iDynamicGuards_7_CanJump[iTemp][iDynamic],
							iDynamicGuards_8_PrinceRow[iTemp][iDynamic],
							iDynamicGuards_9_Amount[iTemp][iDynamic],
							iDynamicGuards_10_Hitpoints[iTemp][iDynamic]);
					}
				}
			}
		}
	}

	/*** Display checkpoint information. ***/
	if ((iDebug == 1) && (iEditPoP == 2))
	{
		for (iTemp = 0; iTemp < 9; iTemp++)
		{
			printf ("[ INFO ] Checkpoint %i: %i, %i\n", iTemp + 1,
				iCheckPoints[(iTemp * 2) + 0], iCheckPoints[(iTemp * 2) + 1]);
		}
	}

	/* Display a warning if the PoP2 guard number differs from the guard's
	 * number. Never for (the original) PoP2, and if another level editor
	 * broke this, apoplexy will fix it when saving levels.
	 */
	if (iEditPoP == 2)
	{
		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			if (iStaticGuards_Amount[iTemp] > 0)
			{
				for (iStatic = 0; iStatic < iStaticGuards_Amount[iTemp]; iStatic++)
				{
					if (iStatic != iStaticGuards_11_Number[iTemp][iStatic])
					{
						printf ("[ WARN ] Guard number differs from guard's number:"
							" %i and %i\n", iStatic,
							iStaticGuards_11_Number[iTemp][iStatic]);
					}
				}
			}
		}
	}

	/*** Read the user data. ***/
	ReadFromFile (iFd, "User Data Count", 4, sUserDataCount);
	snprintf (sString, MAX_DATA, "%02x%02x%02x%02x", sUserDataCount[3],
		sUserDataCount[2], sUserDataCount[1], sUserDataCount[0]);
	luNumber = strtoul (sString, NULL, 16);
	if (iDebug == 1)
	{
		printf ("[ INFO ] The user data count is: %lu\n", luNumber);
	}
	ReadFromFile (iFd, "User Data", (int)luNumber, sUserData);
	snprintf (sString, 100, "%s", "");
	iInformationNr = 0;
	iFieldOrValue = 0;
	for (iTemp = 0; iTemp < (int)luNumber; iTemp++)
	{
		if (sUserData[iTemp] == '\0')
		{
			snprintf (sInformation[iInformationNr + 1][iFieldOrValue], 100, "%s",
				sString);
			snprintf (sString, 100, "%s", "");
			switch (iFieldOrValue)
			{
				case 0:
					iFieldOrValue = 1; break;
				case 1:
					iInformationNr++; iFieldOrValue = 0; break;
			}
		} else {
			snprintf (sTemp, 100, "%s", sString);
			snprintf (sString, 100, "%s%c", sTemp, sUserData[iTemp]);
		}
	}
	iUD = 0;
	iTemp2 = 0;
	for (iTemp = 1; iTemp <= iInformationNr; iTemp++)
	{
		if (strcmp (sInformation[iTemp][0], "Editor Name") == 0)
		{
			iUD = iUD + 1;
			if (strcmp (sInformation[iTemp][1], "PR") == 0) { iTemp2++; }
		}
		if (strcmp (sInformation[iTemp][0], "Editor Version") == 0)
		{
			iUD = iUD + 2;
			if (strcmp (sInformation[iTemp][1], "v1.3.1") != 0) { iTemp2++; }
		}
		if (strcmp (sInformation[iTemp][0], "Level Author") == 0)
			{ iUD = iUD + 4; }
		if (strcmp (sInformation[iTemp][0], "Level Title") == 0)
			{ iUD = iUD + 8; }
		if (strcmp (sInformation[iTemp][0], "Level Description") == 0)
			{ iUD = iUD + 16; }
		if (strcmp (sInformation[iTemp][0], "Time Created") == 0)
			{ iUD = iUD + 32; }
		if (strcmp (sInformation[iTemp][0], "Time Last Modified") == 0)
			{ iUD = iUD + 64; }
		if (strcmp (sInformation[iTemp][0], "Original Filename") == 0)
			{ iUD = iUD + 128; }
		if (strcmp (sInformation[iTemp][0], "Original Level Number") == 0)
			{ iUD = iUD + 256; }
		if (iDebug == 1)
		{
			printf ("[ INFO ] %s: %s\n", sInformation[iTemp][0],
				sInformation[iTemp][1]);
		}
	}
	if ((iUD != 511) && (iDebug == 1))
	{
		printf ("[ WARN ] Could not find required User Data: %i\n", iUD);
	}
	if (iTemp2 == 2)
	{
		printf ("[ WARN ] Please use PR 1.3.1 with apoplexy.\n");
	}

	iCurRoom = arKidRoom[1];
	iMod3Hi = 0;
	iMod4Hi = 0;
	iLvlWarning = 0;
	close (iFd);
}
/*****************************************************************************/
void LoadXML (char *sFileName)
/*****************************************************************************/
{
	int iFd;
	int iEOF;
	int iLine;
	int iTemp;
	int iGuardLocation;
	char sLine[MAX_DATA + 2];
	char sDateTime[MAX_DATETIME + 2];
	char sProgram[MAX_DATA + 2];
	char sValue[MAX_DATA + 2];
	char sTag[MAX_DATA + 2];
	int iEndTag;
	int iRoomNumber;
	int iTileNumber;
	int iEventNumber;
	int iFieldNumber;
	char sBitsRoom[8 + 2];
	char sBitsLocation[8 + 2];
	char sBitsNext[8 + 2];
	char sBinaryFDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sBinarySDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sString[MAX_DATA + 2];

	iChanged = 0;

	/*** Open file. ***/
	iFd = open (sFileName, O_RDONLY);
	if (iFd == -1)
	{
		printf ("[FAILED] Could not open %s: %s!\n", sFileName, strerror (errno));
		exit (EXIT_ERROR);
	}

	iLine = 0;
	do {
		iEOF = ReadLineFromFile (iFd, sLine, 1); iLine++;

		/*** XML? ***/
		if ((iLine == 1) && (strcmp (sLine,
			"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>") != 0))
		{
			printf ("[FAILED] Not a proper XML file!\n"); exit (EXIT_ERROR);
		}

		/*** source ***/
		if ((iLine == 2) && (iDebug == 1))
		{
			substr (sLine, 26, 19, sDateTime);
			substr (sLine, 51, strlen (sLine) - 56, sProgram);
			printf ("[ INFO ] Created on %s by %s.\n", sDateTime, sProgram);
		}

		/*** level number ***/
		if (iLine == 3)
		{
			XMLValue (sLine, "number", sValue);
			sLevelNumber[0] = atoi (sValue);
			snprintf (sString, MAX_DATA, "%02x", sLevelNumber[0]);
			luLevelNr = strtoul (sString, NULL, 16);
		}

		/*** rooms ***/
		if (strcmp (sLine, "<rooms>") == 0)
		{
			iEndTag = 0;
			iRoomNumber = 0;
			iTileNumber = -1;
			do {
				iEOF = ReadLineFromFile (iFd, sLine, 1); iLine++;
				if (strcmp (sLine, "</rooms>") == 0) { iEndTag = 1; }
				if ((iEndTag == 0) && (iEOF == 1))
				{
					printf ("[FAILED] Could not find \"</rooms>\"!");
					exit (EXIT_ERROR);
				}
				XMLTag (sLine, sTag);
				if (strcmp (sTag, "room") == 0)
				{
					XMLValue (sLine, "number", sValue);
					iRoomNumber = atoi (sValue);
					iTileNumber = -1;
				}
				if (strcmp (sTag, "tile") == 0)
				{
					iTileNumber++;
					XMLValue (sLine, "element", sValue);
					iThingA[iRoomNumber][iTileNumber] = atoi (sValue);
					XMLValue (sLine, "modifier", sValue);
					iModifierA[iRoomNumber][iTileNumber][1] = atoi (sValue);
				}
				if (strcmp (sTag, "links") == 0)
				{
					XMLValue (sLine, "left", sValue);
					iRoomConnections[iRoomNumber][1] = atoi (sValue);
					XMLValue (sLine, "right", sValue);
					iRoomConnections[iRoomNumber][2] = atoi (sValue);
					XMLValue (sLine, "up", sValue);
					iRoomConnections[iRoomNumber][3] = atoi (sValue);
					XMLValue (sLine, "down", sValue);
					iRoomConnections[iRoomNumber][4] = atoi (sValue);
				}
				if (strcmp (sTag, "guard") == 0)
				{
					XMLValue (sLine, "location", sValue);
					iGuardLocation = atoi (sValue);
					if (iGuardLocation == 0) /*** no guard ***/
					{
						sGuardLocations[iRoomNumber - 1] = 30;
					} else if ((iGuardLocation >= 1) && (iGuardLocation <= 30)) {
						sGuardLocations[iRoomNumber - 1] = iGuardLocation - 1;
					} else {
						printf ("[ WARN ] Incorrect guard location \"%i\" in room %i!\n",
							iGuardLocation, iRoomNumber);
					}
					XMLValue (sLine, "direction", sValue);
					switch (atoi (sValue))
					{
						case 1: sGuardDirections[iRoomNumber - 1] = 0; break;
						case 2: sGuardDirections[iRoomNumber - 1] = 255; break;
						default: printf ("[ WARN ] Unknown guard direction!\n"); break;
					}
					XMLValue (sLine, "skill", sValue);
					sGuardSkills[iRoomNumber - 1] = atoi (sValue);
					XMLValue (sLine, "colors", sValue);
					sGuardColors[iRoomNumber - 1] = atoi (sValue);
				}
			} while (iEndTag == 0);
		}

		/*** events ***/
		if (strcmp (sLine, "<events>") == 0)
		{
			iEndTag = 0;
			iEventNumber = -1;
			do {
				iEOF = ReadLineFromFile (iFd, sLine, 1); iLine++;
				if (strcmp (sLine, "</events>") == 0) { iEndTag = 1; }
				if ((iEndTag == 0) && (iEOF == 1))
				{
					printf ("[FAILED] Could not find \"</events>\"!");
					exit (EXIT_ERROR);
				}
				XMLTag (sLine, sTag);
				if (strcmp (sTag, "event") == 0)
				{
					iEventNumber++;
					XMLValue (sLine, "number", sValue);
					if (atoi (sValue) != iEventNumber + 1)
					{
						printf ("[FAILED] Events not in the correct order!\n");
						exit (EXIT_ERROR);
					}
					XMLValue (sLine, "room", sValue);
					IntToBits (atoi (sValue), sBitsRoom, 5);
					XMLValue (sLine, "location", sValue);
					IntToBits (atoi (sValue) - 1, sBitsLocation, 5);
					XMLValue (sLine, "next", sValue);
					switch (atoi (sValue))
					{
						case 0: sBitsNext[0] = '1'; sBitsNext[1] = '\0'; break;
						case 1: sBitsNext[0] = '0'; sBitsNext[1] = '\0'; break;
						default: printf ("[FAILED] Unknown next value for event %i!\n",
							iEventNumber); exit (EXIT_ERROR);
					}

					sBinarySDoors[0] = sBitsRoom[0];
					sBinarySDoors[1] = sBitsRoom[1];
					sBinarySDoors[2] = sBitsRoom[2];
					sBinarySDoors[3] = '0';
					sBinarySDoors[4] = '0';
					sBinarySDoors[5] = '0';
					sBinarySDoors[6] = '0';
					sBinarySDoors[7] = '0';
					sBinarySDoors[8] = '\0';

					sBinaryFDoors[0] = sBitsNext[0];
					sBinaryFDoors[1] = sBitsRoom[3];
					sBinaryFDoors[2] = sBitsRoom[4];
					sBinaryFDoors[3] = sBitsLocation[0];
					sBinaryFDoors[4] = sBitsLocation[1];
					sBinaryFDoors[5] = sBitsLocation[2];
					sBinaryFDoors[6] = sBitsLocation[3];
					sBinaryFDoors[7] = sBitsLocation[4];
					sBinaryFDoors[8] = '\0';

					sFirstDoorEvents[iEventNumber] = BitsToInt (sBinaryFDoors);
					sSecondDoorEvents[iEventNumber] = BitsToInt (sBinarySDoors);
				}
			} while (iEndTag == 0);
		}

		/*** prince ***/
		XMLTag (sLine, sTag);
		if (strcmp (sTag, "prince") == 0)
		{
			XMLValue (sLine, "room", sValue);
			arKidRoom[1] = strtoul (sValue, NULL, 10);
			XMLValue (sLine, "location", sValue);
			arKidPos[1] = strtoul (sValue, NULL, 10);
			XMLValue (sLine, "direction", sValue);
			switch (atoi (sValue))
			{
				case 1: arKidDir[1] = 0; break;
				case 2: arKidDir[1] = 255; break;
			}
			/*** 2 of 4 (DOS) ***/
			if (((int)luLevelNr == 1) || ((int)luLevelNr == 13))
			{
				if (arKidDir[1] == 0) { arKidDir[1] = 255; } else { arKidDir[1] = 0; }
			}
		}

		/*** userdata ***/
		XMLTag (sLine, sTag);
		if (strcmp (sTag, "userdata") == 0)
		{
			XMLValue (sLine, "fields", sValue);
			luNumberOfFields = atoi (sValue);
			iInformationNr = atoi (sValue);

			/* It's unlikely anyone will ever use more than 255 fields, so
			 * I'm using this cheap solution.
			 */
			sNumberOfFields[0] = iInformationNr;
			sNumberOfFields[1] = 0x00;
			sNumberOfFields[2] = 0x00;
			sNumberOfFields[3] = 0x00;

			iEndTag = 0;
			iFieldNumber = 0;
			do {
				iEOF = ReadLineFromFile (iFd, sLine, 1); iLine++;
				if (strcmp (sLine, "</userdata>") == 0) { iEndTag = 1; }
				if ((iEndTag == 0) && (iEOF == 1))
				{
					printf ("[FAILED] Could not find \"</userdata>\"!");
					exit (EXIT_ERROR);
				}
				XMLTag (sLine, sTag);
				if (strcmp (sTag, "field") == 0)
				{
					iFieldNumber++;
					if (iFieldNumber > (int)luNumberOfFields)
					{
						printf ("[ WARN ] More fields than indicated!\n");
					}
					XMLValue (sLine, "key", sValue);
					snprintf (sInformation[iFieldNumber][0], 100, "%s", sValue);
					XMLValue (sLine, "value", sValue);
					snprintf (sInformation[iFieldNumber][1], 100, "%s", sValue);
				}
			} while (iEndTag == 0);
		}

	} while (iEOF == 0);

	/*** Not in XML files. ***/
	sMagicID[0] = 'P'; sMagicID[1] = 'O'; sMagicID[2] = 'P'; sMagicID[3] = '_';
	sMagicID[4] = 'L'; sMagicID[5] = 'V'; sMagicID[6] = 'L';
	sPOPVersion[0] = 0x01;
	sPLVVersion[0] = 0x01;
	sChecksum[0] = 0x00; /*** Unused. ***/
	if ((int)luLevelNr == 15) /*** potions level ***/
	{
		luLevelSize = 2304;
		sLevelSize[0] = 0x00;
		sLevelSize[1] = 0x09;
		sLevelSize[2] = 0x00;
		sLevelSize[3] = 0x00;
	} else {
		luLevelSize = 2305;
		sLevelSize[0] = 0x01;
		sLevelSize[1] = 0x09;
		sLevelSize[2] = 0x00;
		sLevelSize[3] = 0x00;
	}
	sEndCode[0] = 0x0f;
	sEndCode[1] = 0x09;
	for (iTemp = 0; iTemp < 64; iTemp++) { sUnknownI[iTemp] = 0x00; }
	for (iTemp = 0; iTemp < 4; iTemp++) { sUnknownIIandIII[iTemp] = 0x00; }
	for (iTemp = 0; iTemp < 48; iTemp++) { sUnknownIVaandIVb[iTemp] = 0x00; }
	for (iTemp = 0; iTemp < 24; iTemp++) { sUnknownIVc[iTemp] = 0x00; }
	for (iTemp = 0; iTemp < 16; iTemp++) { sUnknownIVd[iTemp] = 0x00; }

	/*** We want remapped modifiers in all 24 rooms. ***/
	sUnknownI[0] = 0x18;

	iBrokenRoomLinks = BrokenRoomLinks (1);
	iCurRoom = arKidRoom[1];
	iMod3Hi = 0;
	iMod4Hi = 0;
	iLvlWarning = 0;
	close (iFd);
}
/*****************************************************************************/
int GetResourceAddress (int iFd, int iResource)
/*****************************************************************************/
{
	unsigned char sOffset[2 + 2];
	unsigned char sSegment[1 + 2];
	int iOffset, iSegment, iResourceAddress;

	LSeek (iFd, 0x20000 + (3 * iResource));
	ReadFromFile (iFd, "Level Offset", 2, sOffset);
	iOffset = BytesAsLU (sOffset, 2);
	ReadFromFile (iFd, "Level Segment", 1, sSegment);
	iSegment = BytesAsLU (sSegment, 1);
	iResourceAddress = (iSegment * 0x8000) + (iOffset - 0x8000);

	return (iResourceAddress);
}
/*****************************************************************************/
void LoadSMC (int iLevel)
/*****************************************************************************/
{
	int iFd;
	int iRoom;
	int iTile;
	int iTemp;
	char sString[MAX_DATA + 2];
	int iPos;
	char sBitsGuard[100 + 2];
	char sGuardType[100 + 2];
	char sGuardDirection[100 + 2];
	int iLevelAddress;
	int iStoreLevel;
	int iLastResource;
	int iLastResourceLocation;
	char sGuardName[MAX_GUARDNAME + 2];

	/*** Animation. ***/
	int iAnim;
	char sBitsAnim[100 + 2];
	char sAnim[6 + 2];
	char sFloorWall[2 + 2];

	unsigned char sLevelBackgroundS[720 + 2];
	unsigned char sLevelForegroundS[720 + 2];
	unsigned char sLevelModifierS[720 + 2];
	unsigned char sVariousS[244 + 2];

	iChanged = 0;

	luLevelNr = iLevel;

	/*** Open file. ***/
	iFd = open (sSNESFile, O_RDONLY|O_BINARY);
	if (iFd == -1)
	{
		printf ("[FAILED] Could not open %s: %s!\n\n",
			sSNESFile, strerror (errno));
		exit (EXIT_ERROR);
	}

	/*** Store the sizes and compressed data of all levels. ***/
	for (iStoreLevel = 1; iStoreLevel <= 27; iStoreLevel++)
	{
		iStoredLevelsSizes[iStoreLevel] = CompressedLevelSize (iFd, iStoreLevel);
		iLevelAddress = GetResourceAddress (iFd, iStoreLevel + 40);
		LSeek (iFd, iLevelAddress);
		ReadFromFile (iFd, "", iStoredLevelsSizes[iStoreLevel],
			sStoredLevels[iStoreLevel]);
	}

	/* If there are non-level resources in the second save area, saving is
	 * being disabled entirely.
	 */
	if (iEXEType == 0)
		{ iLastResource = 90; } /*** JP ***/
			else { iLastResource = 91; } /*** US and EU ***/
	iLastResourceLocation = GetResourceAddress (iFd, iLastResource);
	if (iLastResourceLocation >= 0xE0A00) { iNoSave = 1; }

	/*** Move to the current level. ***/
	iLevelAddress = GetResourceAddress (iFd, iLevel + 40);
	LSeek (iFd, iLevelAddress);

	iReadFromFile = 0;

	/*** Load the level background, foreground and modifier. ***/
	Decompress (iFd, "Level Background", 720, sLevelBackgroundS);
	Decompress (iFd, "Level Foreground", 720, sLevelForegroundS);
	Decompress (iFd, "Level Modifier", 720, sLevelModifierS);
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		for (iTile = 0; iTile <= 29; iTile++)
		{
			iPos = ((iRoom * 30) - 30) + iTile;
			iBackA[iRoom][iTile] = (int)sLevelBackgroundS[iPos];
			iThingA[iRoom][iTile] = (int)sLevelForegroundS[iPos];
			iModifierA[iRoom][iTile][1] = (int)sLevelModifierS[iPos];
			iModifierA[iRoom][iTile][2] = 0x00; /*** Unused. ***/
			iModifierA[iRoom][iTile][3] = 0x00; /*** Unused. ***/
			iModifierA[iRoom][iTile][4] = 0x00; /*** Unused. ***/
		}
	}

	/*** Load block information. ***/
	Decompress (iFd, "Block 1", 256, sBlock1);
	Decompress (iFd, "Block 2", 256, sBlock2);
	Decompress (iFd, "Block 3", 256, sBlock3);
	Decompress (iFd, "Block 4", 256, sBlock4);

	/* Extract, store and remove background animation information.
	 * Confusingly enough, the game has this information in sBlock4.
	 * We remove it from sBlock4 here and put it back when saving.
	 * This allows us to change tiles freely when editing levels.
	 */
	for (iAnim = 0; iAnim <= 255; iAnim++)
	{
		IntToBits (sBlock4[iAnim], sBitsAnim, 8);
		substr (sBitsAnim, 0, 6, sAnim);
		substr (sBitsAnim, 6, 2, sFloorWall);
		arAnim[iAnim] = BitsToInt (sAnim);
		sBlock4[iAnim] = BitsToInt (sFloorWall);
	}
	if (iDebug == 1)
	{
		for (iTemp = 0; iTemp < 256; iTemp++)
		{
			if (arAnim[iTemp] != 0x00)
			{
				printf ("[ INFO ] Background 0x%02x is part of animation group %i.\n",
					iTemp, arAnim[iTemp]);
			}
		}
	}

	/* We are not going to work with iThingA or sBlock1-sBlock4. Instead,
	 * we'll use iBlock1A-iBlock4A. When saving, we'll use these to
	 * (re)construct iThingA and sBlock1-sBlock4.
	 */
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		for (iTile = 0; iTile <= 29; iTile++)
		{
			iBlock1A[iRoom][iTile] = sBlock1[iThingA[iRoom][iTile]];
			iBlock2A[iRoom][iTile] = sBlock2[iThingA[iRoom][iTile]];
			iBlock3A[iRoom][iTile] = sBlock3[iThingA[iRoom][iTile]];
			iBlock4A[iRoom][iTile] = sBlock4[iThingA[iRoom][iTile]];
		}
	}
	arSpecial254[0] = sBlock1[254]; arSpecial255[0] = sBlock1[255];
	arSpecial254[1] = sBlock2[254]; arSpecial255[1] = sBlock2[255];
	arSpecial254[2] = sBlock3[254]; arSpecial255[2] = sBlock3[255];
	arSpecial254[3] = sBlock4[254]; arSpecial255[3] = sBlock4[255];
	ForceSpecialsToMatchEnv();
	if (iDebug == 1)
	{
		printf ("[ INFO ] 254 = %02x %02x %02x %02x\n",
			arSpecial254[0], arSpecial254[1], arSpecial254[2], arSpecial254[3]);
		printf ("[ INFO ] 255 = %02x %02x %02x %02x\n",
			arSpecial255[0], arSpecial255[1], arSpecial255[2], arSpecial255[3]);
	}

	/*** Room links, starting position, Unknown I, guard data, Unknown II. ***/
	Decompress (iFd, "Various", 244, sVariousS);
	substru (sVariousS, 0, 96, sRoomLinks);
	substru (sVariousS, 96, 3, sStartPosition);
	substru (sVariousS, 96+3, 1, sUnknownI);
	substru (sVariousS, 96+3+1, iRooms, sGuardLocations);
	substru (sVariousS, 96+3+1+iRooms, iRooms, sGuardTypesDirections);
	substru (sVariousS, 96+3+1+iRooms+iRooms, iRooms, sGuardSkills);
	substru (sVariousS, 96+3+1+iRooms+iRooms+iRooms, 72, sUnknownII);

	/*** Load the room links. ***/
	for (iTemp = 0; iTemp < iRoomLinks; iTemp++)
	{
		if (sRoomLinks[iTemp] <= 23) { sRoomLinks[iTemp] = sRoomLinks[iTemp] + 1; }
	}
	for (iTemp = 0; iTemp < iRoomLinks; iTemp+=4)
	{
		iRoomConnections[(iTemp / 4) + 1][1] =
			sRoomLinks[iTemp]; /*** left ***/
		iRoomConnections[(iTemp / 4) + 1][2] =
			sRoomLinks[iTemp + 1]; /*** right ***/
		iRoomConnections[(iTemp / 4) + 1][3] =
			sRoomLinks[iTemp + 2]; /*** up ***/
		iRoomConnections[(iTemp / 4) + 1][4] =
			sRoomLinks[iTemp + 3]; /*** down ***/
		if (iDebug == 1)
		{
			printf ("[ INFO ] Room %i is connected to room (254/255 = none): l%i, "
				"r%i, u%i, d%i\n", (iTemp / 4) + 1, sRoomLinks[iTemp],
				sRoomLinks[iTemp + 1], sRoomLinks[iTemp + 2],
				sRoomLinks[iTemp + 3]);
		}
	}

	/*** Load Start Position. ***/
	snprintf (sString, MAX_DATA, "%02x", sStartPosition[0]);
	arKidRoom[1] = strtoul (sString, NULL, 16) + 1;
	snprintf (sString, MAX_DATA, "%02x", sStartPosition[1]);
	arKidPos[1] = strtoul (sString, NULL, 16) + 1;
	snprintf (sString, MAX_DATA, "%02x", sStartPosition[2]);
	arKidDir[1] = strtoul (sString, NULL, 16);
	/*** 1 of 2 (SNES) ***/
	if (((int)luLevelNr == 10) || ((int)luLevelNr == 17))
	{
		if (arKidDir[1] == 0) { arKidDir[1] = 255; } else { arKidDir[1] = 0; }
	}
	/*** jaffar ***/
	if ((arKidRoom[1] == 256) && (arKidPos[1] == 256) && (arKidDir[1] == 255))
	{
		arKidRoom[1] = 1; arKidPos[1] = 28;
	}
	if (iDebug == 1)
	{
		printf ("[ INFO ] The kid starts in room: %i, position: %i, turned: "
			"%c\n", arKidRoom[1], arKidPos[1], cShowDirection (arKidDir[1]));
	}

	/*** Load first and second door events. ***/
	Decompress (iFd, "First Door Events", 256, sFirstDoorEvents);
	Decompress (iFd, "Second Door Events", 256, sSecondDoorEvents);

	if (iDebug == 1)
	{
		for (iTemp = 0; iTemp < 256; iTemp++)
		{
			printf ("[ INFO ] Event %i changes the door in room: %i, location:"
				" %i.", iTemp + 1, EventInfo (iTemp, 1), EventInfo (iTemp, 2));
			switch (EventInfo (iTemp, 3))
			{
				case 1: printf (" (next: yes)\n"); break;
				case 0: printf (" (next: no)\n"); break;
			}
		}
	}

	PrIfDe ("[  OK  ] Checking for broken room links.\n");
	iBrokenRoomLinks = BrokenRoomLinks (1);

	/*** Extract guard types and directions. ***/
	for (iTemp = 0; iTemp < iRooms; iTemp++)
	{
		IntToBits (sGuardTypesDirections[iTemp], sBitsGuard, 8);
		substr (sBitsGuard, 1, 7, sGuardType);
		sGuardTypes[iTemp] = BitsToInt (sGuardType);
		substr (sBitsGuard, 0, 1, sGuardDirection);
		sGuardDirections[iTemp] = BitsToInt (sGuardDirection);
		sGuardColors[iTemp] = -1; /*** Not applicable. ***/
	}

	/*** Display guard information. ***/
	if (iDebug == 1)
	{
		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			if (sGuardLocations[iTemp] <= 29)
			{
				if ((sGuardTypes[iTemp] >= 0x02) && (sGuardTypes[iTemp] <= 0x13))
				{
					snprintf (sGuardName, MAX_GUARDNAME, "%s",
						sGuardNamesSNES[sGuardTypes[iTemp] - 2]);
				} else {
					snprintf (sGuardName, MAX_GUARDNAME, "%s", "?");
				}
				printf ("[ INFO ] Guard; room: %i, loc: %i, type: %s,"
					" S:%i, turned: %c\n", iTemp + 1, sGuardLocations[iTemp] + 1,
					sGuardName, sGuardSkills[iTemp],
					cShowDirection (sGuardDirections[iTemp]));
			}
		}
	}

	/*** No user data. ***/
	iInformationNr = 0;

	if (iDebug == 1)
	{
		printf ("[ INFO ] The compressed level is %i bytes"
			" (%i-%i; 0x%06x-0x%06x).\n", iReadFromFile,
			iLevelAddress, iLevelAddress + iReadFromFile - 1,
			iLevelAddress, iLevelAddress + iReadFromFile - 1);
	}

	iCurRoom = arKidRoom[1];
	iModHi = 1;
	iTempHi = 1;
	iLvlWarning = 0;
	iZSNES = 0;
	close (iFd);

/***
	This is the decompressed level.

	printf ("Level %i:\n", iLevel);
	for (iTemp = 0; iTemp < 720; iTemp++)
		{ printf ("%02x ", sLevelBackgroundS[iTemp]); }
	for (iTemp = 0; iTemp < 720; iTemp++)
		{ printf ("%02x ", sLevelForegroundS[iTemp]); }
	for (iTemp = 0; iTemp < 720; iTemp++)
		{ printf ("%02x ", sLevelModifierS[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sBlock1[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sBlock2[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sBlock3[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sBlock4[iTemp]); }
	for (iTemp = 0; iTemp < 244; iTemp++)
		{ printf ("%02x ", sVariousS[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sFirstDoorEvents[iTemp]); }
	for (iTemp = 0; iTemp < 256; iTemp++)
		{ printf ("%02x ", sSecondDoorEvents[iTemp]); }
	printf ("\n");
***/
}
/*****************************************************************************/
void SaveSMC (int iLevel)
/*****************************************************************************/
{
	int iFd;
	int iRoom;
	int iTile;
	int iPos;
	int iFree;
	int iGotIt;
	int iCheck;
	int iClear;
	unsigned char arCompData[10 + 2][720 + 2];
	int iCompSize[10 + 2];
	int iLevelSize, iComp;
	int iSave;
	int iLevelLoop;
	int iAddress, iSegment, iOffset;
	unsigned char sBytes[2 + 2];
	int iTemp;

	/*** Animation. ***/
	int iAnim;
	char sBitsAnim[100 + 2];
	char sAnim[6 + 2];
	char sFloorWall[2 + 2];

	/*** Save areas. ***/
	int iSaveArea1Start;
	int iSaveArea1Stop;
	int iSaveArea2Start;
	int iSaveArea2Stop;

	unsigned char sLevelBackgroundS[720 + 2];
	unsigned char sLevelForegroundS[720 + 2];
	unsigned char sLevelModifierS[720 + 2];
	unsigned char sVariousS[244 + 2];

	/* Here we (re)construct iThingA and sBlock1-sBlock4, using
	 * iBlock1A-iBlock4A.
	 */
	iFree = 255;
	ForceSpecialsToMatchEnv();
	sBlock1[254] = arSpecial254[0]; sBlock1[255] = arSpecial255[0];
	sBlock2[254] = arSpecial254[1]; sBlock2[255] = arSpecial255[1];
	sBlock3[254] = arSpecial254[2]; sBlock3[255] = arSpecial255[2];
	sBlock4[254] = arSpecial254[3]; sBlock4[255] = arSpecial255[3];
	iFree = 253;
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		for (iTile = 0; iTile <= 29; iTile++)
		{
			/*** Check if the block-combination is already in sBlock1-4. ***/
			iGotIt = 0;
			for (iCheck = 255; iCheck > iFree; iCheck--)
			{
				if ((iBlock1A[iRoom][iTile] == sBlock1[iCheck]) &&
					(iBlock2A[iRoom][iTile] == sBlock2[iCheck]) &&
					(iBlock3A[iRoom][iTile] == sBlock3[iCheck]) &&
					(iBlock4A[iRoom][iTile] == sBlock4[iCheck]))
				{
					iGotIt = iCheck;
				}
			}

			/*** If it's not yet available, add the block-combination. ***/
			if (iGotIt == 0)
			{
				if (iFree >= 0)
				{
					/*** Add a new block-combination. ***/
					sBlock1[iFree] = iBlock1A[iRoom][iTile];
					sBlock2[iFree] = iBlock2A[iRoom][iTile];
					sBlock3[iFree] = iBlock3A[iRoom][iTile];
					sBlock4[iFree] = iBlock4A[iRoom][iTile];
					iGotIt = iFree;
					iFree--;
				} else {
					/*** Adding is not possible. ***/
					iGotIt = 255; /*** As a fallback. ***/
					printf ("[ WARN ] Cannot save more than 256 different blocks!\n");
				}
			}

			iThingA[iRoom][iTile] = iGotIt;
		}
	}

	/*** Clear unused blocks. Then re-enable background animations. ***/
	if (iFree >= 0)
	{
		for (iClear = iFree; iClear >= 0; iClear--)
		{
			sBlock1[iClear] = 0x00;
			sBlock2[iClear] = 0x00;
			sBlock3[iClear] = 0x00;
			sBlock4[iClear] = 0x00;
		}
	}
	/* Yes, we went through the trouble of storing (remembering)
	 * background animations. However, what we really want is to have
	 * ALL animations enabled for the current environment type.
	 */
	GiveAnimationGroups();
	for (iAnim = 0; iAnim <= 255; iAnim++)
	{
		IntToBits (sBlock4[iAnim], sFloorWall, 2);
		IntToBits (arAnim[iAnim], sAnim, 6);
		snprintf (sBitsAnim, 100, "%s%s", sAnim, sFloorWall);
		sBlock4[iAnim] = BitsToInt (sBitsAnim);
	}

	/*** The level background, foreground and modifier. ***/
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		for (iTile = 0; iTile <= 29; iTile++)
		{
			iPos = ((iRoom * 30) - 30) + iTile;
			sLevelBackgroundS[iPos] = iBackA[iRoom][iTile];
			sLevelForegroundS[iPos] = iThingA[iRoom][iTile];
			sLevelModifierS[iPos] = iModifierA[iRoom][iTile][1];
		}
	}

	CreateVariousSNES (sVariousS);

	/*** Open file. ***/
	iFd = open (sSNESFile, O_RDWR|O_BINARY, 0600);
	if (iFd == -1)
	{
		printf ("[FAILED] Could not open SMC file: %s!\n", strerror (errno));
		exit (EXIT_ERROR);
	}

	/*** Set the boundaries for the two save areas. ***/
	iSaveArea1Start = GetResourceAddress (iFd, 41);
	iSaveArea1Stop = GetResourceAddress (iFd, 68) - 1;
	iSaveArea2Start = 0xE0A00;
	iSaveArea2Stop = 0xE8000 - 1;

	iAddress = iSaveArea1Start;
	for (iLevelLoop = 1; iLevelLoop <= 27; iLevelLoop++)
	{
		/*** Get the compressed level size. ***/
		if (iLevelLoop == iLevel) /*** Current level. ***/
		{
			for (iComp = 1; iComp <= 10; iComp++)
			{
				for (iTemp = 0; iTemp <= 720; iTemp++)
					{ arCompData[iComp][iTemp] = '\0'; }
			}
			iCompSize[1] = Compress ("Level Background", 720,
				sLevelBackgroundS, arCompData[1]);
			iCompSize[2] = Compress ("Level Foreground", 720,
				sLevelForegroundS, arCompData[2]);
			iCompSize[3] = Compress ("Level Modifier", 720,
				sLevelModifierS, arCompData[3]);
			iCompSize[4] = Compress ("Block 1", 256, sBlock1, arCompData[4]);
			iCompSize[5] = Compress ("Block 2", 256, sBlock2, arCompData[5]);
			iCompSize[6] = Compress ("Block 3", 256, sBlock3, arCompData[6]);
			iCompSize[7] = Compress ("Block 4", 256, sBlock4, arCompData[7]);
			iCompSize[8] = Compress ("Various", 244, sVariousS, arCompData[8]);
			iCompSize[9] = Compress ("First Door Events", 256,
				sFirstDoorEvents, arCompData[9]);
			iCompSize[10] = Compress ("Second Door Events", 256,
				sSecondDoorEvents, arCompData[10]);
			iLevelSize = 0;
			for (iComp = 1; iComp <= 10; iComp++) { iLevelSize+=iCompSize[iComp]; }
		} else { /*** Other levels. ***/
			iLevelSize = iStoredLevelsSizes[iLevelLoop];
		}

		/*** Change the offset. ***/
		iSave = 0;
		if (iAddress < iSaveArea1Stop + 1) /*** In the first save area. ***/
		{
			if (iAddress + iLevelSize <= iSaveArea1Stop)
			{
				iSave = 1;
			} else {
				iAddress = iSaveArea2Start;
				iSave = 1;
			}
		}
		if (iAddress < iSaveArea2Stop + 1) /*** In the second save area. ***/
		{
			if (iAddress + iLevelSize <= iSaveArea2Stop)
			{
				iSave = 1;
			} else {
				printf ("[ WARN ] Not enough room to save all levels!\n");
				iSave = 0;
			}
		}

		if (iSave == 1)
		{
			/*** Save the address. ***/
			LSeek (iFd, 0x20000 + (3 * (40 + iLevelLoop)));
			iSegment = iAddress / 0x8000;
			iOffset = (iAddress % 0x8000) + 0x8000;
			/*** Or, also correct: iAddress - (iSegment * 0x8000) + 0x8000; ***/
			sBytes[0] = (iOffset >> 0) & 0xFF;
			sBytes[1] = (iOffset >> 8) & 0xFF;
			WriteCharByChar (iFd, sBytes, 2);
			sBytes[0] = iSegment;
			WriteCharByChar (iFd, sBytes, 1);

			/*** Save the compressed level. ***/
			LSeek (iFd, iAddress);
			if (iLevelLoop == iLevel) /*** Current level. ***/
			{
				for (iComp = 1; iComp <= 10; iComp++)
				{
					WriteCharByChar (iFd, arCompData[iComp], iCompSize[iComp]);
				}
			} else { /*** Other levels. ***/
				WriteCharByChar (iFd, sStoredLevels[iLevelLoop], iLevelSize);
			}
			iAddress+=iLevelSize;
		}
	}

	close (iFd);

	AlwaysJumpThroughMirror();

	PlaySound ("wav/save.wav");

	iChanged = 0;
}
/*****************************************************************************/
void CreateVariousSNES (unsigned char *sVariousS)
/*****************************************************************************/
{
	unsigned long luKidRoomSave;
	unsigned long luKidPosSave;
	unsigned long luKidDirSave;
	int iTemp;
	char sBitsGuard[100 + 2];
	char sGuardType[7 + 2];
	char sGuardDirection[1 + 2];

	/*** jaffar ***/
	if ((int)luLevelNr == 21)
	{
		luKidRoomSave = 256;
		luKidPosSave = 256;
		luKidDirSave = 255;
	} else {
		luKidRoomSave = arKidRoom[1] - 1;
		luKidPosSave = arKidPos[1] - 1;
		luKidDirSave = arKidDir[1];
		/*** 2 of 2 (SNES) ***/
		if (((int)luLevelNr == 10) || ((int)luLevelNr == 17))
		{
			if (luKidDirSave == 0) { luKidDirSave = 255; } else { luKidDirSave = 0; }
		}
	}

	for (iTemp = 0; iTemp < iRoomLinks; iTemp+=4)
	{
		sRoomLinks[iTemp] =
			iRoomConnections[(iTemp / 4) + 1][1]; /*** left ***/
		sRoomLinks[iTemp + 1] =
			iRoomConnections[(iTemp / 4) + 1][2]; /*** right ***/
		sRoomLinks[iTemp + 2] =
			iRoomConnections[(iTemp / 4) + 1][3]; /*** up ***/
		sRoomLinks[iTemp + 3] =
			iRoomConnections[(iTemp / 4) + 1][4]; /*** down ***/
	}
	for (iTemp = 0; iTemp < iRoomLinks; iTemp++)
	{
		if (sRoomLinks[iTemp] <= 24) { sRoomLinks[iTemp] = sRoomLinks[iTemp] - 1; }
	}

	/*** Compact guard types and directions. ***/
	for (iTemp = 0; iTemp < iRooms; iTemp++)
	{
		IntToBits (sGuardDirections[iTemp], sGuardDirection, 1);
		IntToBits (sGuardTypes[iTemp], sGuardType, 7);
		snprintf (sBitsGuard, 100, "%s%s", sGuardDirection, sGuardType);
		sGuardTypesDirections[iTemp] = BitsToInt (sBitsGuard);
	}

	/*** Room links, starting position, Unknown I, guard data, Unknown II. ***/
	for (iTemp = 0; iTemp < 244; iTemp++)
	{
		if ((iTemp >= 0) && (iTemp < 96))
		{
			sVariousS[iTemp] = sRoomLinks[iTemp];
		}
		if (iTemp == 96)
		{
			sVariousS[iTemp] = luKidRoomSave;
		}
		if (iTemp == 97)
		{
			sVariousS[iTemp] = luKidPosSave;
		}
		if (iTemp == 98)
		{
			sVariousS[iTemp] = luKidDirSave;
		}
		if (iTemp == 99)
		{
			sVariousS[iTemp] = sUnknownI[0];
		}
		if ((iTemp >= 100) && (iTemp < 124))
		{
			sVariousS[iTemp] = sGuardLocations[iTemp - 100];
		}
		if ((iTemp >= 124) && (iTemp < 148))
		{
			sVariousS[iTemp] = sGuardTypesDirections[iTemp - 124];
		}
		if ((iTemp >= 148) && (iTemp < 172))
		{
			sVariousS[iTemp] = sGuardSkills[iTemp - 148];
		}
		if ((iTemp >= 172) && (iTemp < 244))
		{
			sVariousS[iTemp] = sUnknownII[iTemp - 172];
		}
	}
}
/*****************************************************************************/
void Decompress (int iFd, char *sWhat, int iNeed,
	unsigned char *sDecompressed)
/*****************************************************************************/
{
	unsigned char sByte[1 + 2];
	unsigned char sTwoByte[2 + 2];
	int iX, iY, iD, iA;
	int iTemp;
	int iHave;

	if ((iDebug == 1) && (strcmp (sWhat, "") != 0))
		{ printf ("[  OK  ] Loading: %s\n", sWhat); }

	/*** You cannot use snprintf for this (\0 values). ***/
	for (iTemp = 0; iTemp < iNeed; iTemp++) { sDecompressed[iTemp] = '\0'; }
	/* Previously used:
	 * for (iTemp = 0; iTemp < (int)strlen ((char *)sDecompressed); iTemp++)
	 */

	iHave = 0;
	while (iHave < iNeed)
	{
		ReadFromFile (iFd, "", 1, sByte);
		iX = sByte[0];
		if (iX >= 128)
		{
			for (iTemp = 1; iTemp <= iX - 128; iTemp++)
			{
				ReadFromFile (iFd, "", 1, sByte);
				sDecompressed[iHave] = sByte[0];
				iHave++;
			}
		} else {
			ReadFromFile (iFd, "", 1, sByte);
			iY = sByte[0];
			if (iY == 0) { iY = 256; }
			switch (iX)
			{
				case 1:
					ReadFromFile (iFd, "", 1, sByte);
					iD = sByte[0];
					for (iTemp = 1; iTemp <= iY; iTemp++)
					{
						sDecompressed[iHave] = iD;
						iHave++;
					}
					break;
				case 2:
					ReadFromFile (iFd, "", 1, sByte);
					iD = sByte[0];
					for (iTemp = 1; iTemp <= iY; iTemp++)
					{
						sDecompressed[iHave] = iD;
						iHave++;
						iD++;
					}
					break;
				case 3:
					ReadFromFile (iFd, "", 1, sByte);
					iD = sByte[0];
					for (iTemp = 1; iTemp <= iY; iTemp++)
					{
						sDecompressed[iHave] = iD;
						iHave++;
						iD--;
					}
					break;
				case 4:
					ReadFromFile (iFd, "", 1, sByte);
					iA = sByte[0];
					for (iTemp = 1; iTemp <= iY; iTemp++)
					{
						sDecompressed[iHave] = sDecompressed[iA + iTemp - 1];
						iHave++;
					}
					break;
				case 5:
					ReadFromFile (iFd, "", 2, sTwoByte);
					iA = BytesAsLU (sTwoByte, 2);
					for (iTemp = 1; iTemp <= iY; iTemp++)
					{
						sDecompressed[iHave] = sDecompressed[iA + iTemp - 1];
						iHave++;
					}
					break;
				default:
					printf ("[FAILED] Strange value for iX (%s): %i!\n", sWhat, iX);
					exit (EXIT_ERROR);
					break;
			}
		}
	}
}
/*****************************************************************************/
int Compress (char *sWhat, int iNeed, unsigned char *sToCompress,
	unsigned char *sCompressed)
/*****************************************************************************/
{
	/* Pr1SnesLevEd and apoplexy differ from the original game. For example,
	 * 01 01 01 00 00 00 is compressed to 01 03 01 01 03 00 in the original
	 * game, but Pr1SnesLevEd and apoplexy use 86 01 01 01 00 00 00.
	 */

	int iHave;
	int iDataLength;
	int arLengthX[4 + 2];
	int iTemp;
	int iLength;
	int iSame;
	int iX;
	unsigned char sData[500 + 2];
	int iCopy;
	unsigned char sToAdd[MAX_TOWRITE + 2];
	int iOut1, iOut2;
	int iSize;

	iHave = 0;
	iDataLength = 0;
	iSize = 0;

	if ((iDebug == 1) && (strcmp (sWhat, "") != 0))
	{
		printf ("[ INFO ] Compressing: %s\n", sWhat);
	}
	iSame = 0; /*** To prevent warnings. ***/
	while (iHave < iNeed)
	{
		/*** Reset all X lengths to 0. ***/
		for (iTemp = 0; iTemp <= 4; iTemp++)
		{
			arLengthX[iTemp] = 0;
		}

		/* Store the length for method X = 1.
		 * This is for a string of the same characters.
		 */
		for (iLength = 0; iLength < 256; iLength++)
		{
			/*** If adding more would exceed what we need, then break. ***/
			if (iHave + iLength + 1 >= iNeed)
				{ break; }

			/*** If not the same, then break. ***/
			if (sToCompress[iHave + iLength] != sToCompress[iHave + iLength + 1])
				{ break; }
		}
		if (iLength > 3) { arLengthX[1] = iLength; }

		/* Store the length for method X = 2.
		 * This is for a string of decreasing characters.
		 */
		for (iLength = 0; iLength < 256; iLength++)
		{
			/*** If adding more would exceed what we need, then break. ***/
			if (iHave + iLength + 1 >= iNeed)
				{ break; }

			/*** If not decreasing, then break. ***/
			if (sToCompress[iHave + iLength] + 1 != sToCompress[iHave + iLength + 1])
				{ break; }
		}
		if (iLength > 3) { arLengthX[2] = iLength; }

		/* Store the length for method X = 3.
		 * This is for a string of increasing characters.
		 */
		for (iLength = 0; iLength < 256; iLength++)
		{
			/*** If adding more would exceed what we need, then break. ***/
			if (iHave + iLength + 1 >= iNeed)
				{ break; }

			/*** If not increasing, then break. ***/
			if (sToCompress[iHave + iLength] - 1 != sToCompress[iHave + iLength + 1])
				{ break; }
		}
		if (iLength > 3) { arLengthX[3] = iLength; }

		/* Store the length for method X = 4 (and 5).
		 * This is for a copied string of characters.
		 */
		for (iCopy = 0; iCopy < iHave; iCopy++)
		{
			for (iLength = 0; iLength < 256; iLength++)
			{
				if (iHave + iLength >= iNeed)
					{ break; }

				if (sToCompress[iHave + iLength] != sToCompress[iCopy + iLength])
					{ break; }
			}
			if ((iLength > arLengthX[4]) && ((iLength > 4) || ((iCopy < 255) &&
				(iLength > 3))))
			{
				iSame = iCopy;
				arLengthX[4] = iLength;
			}
		}

		/*** Store the X method with the greatest length. ***/
		iLength = 0;
		iX = 0;
		for (iTemp = 1; iTemp <= 4; iTemp++)
		{
			if (arLengthX[iTemp] > iLength)
			{
				iX = iTemp;
				iLength = arLengthX[iTemp];
			}
		}

		if (iLength < 2)
		{ /*** Simple copy. ***/
			sData[iDataLength] = sToCompress[iHave];
			iDataLength++;
			iHave++;
			if (iDataLength == 127)
			{
				sToAdd[0] = (unsigned char)(iDataLength + 128);
				iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
				iSize+=AddCharByChar (sCompressed, iSize, sData, iDataLength);
				iDataLength = 0;
			}
		} else { /*** Compress. ***/
			if (iDataLength > 0)
			{
				sToAdd[0] = (unsigned char)(iDataLength + 128);
				iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
				iSize+=AddCharByChar (sCompressed, iSize, sData, iDataLength);
				iDataLength = 0;
			}

			if (iX == 4)
			{
				if (iSame >= 256) /*** X = 5 ***/
				{
					iX = 5;
					SSLittleEndianToHexToInts (iSame, &iOut1, &iOut2);
					sToAdd[0] = (unsigned char)iX;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					sToAdd[0] = (unsigned char)iLength;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					sToAdd[0] = (unsigned char)iOut2;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					sToAdd[0] = (unsigned char)iOut1;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					/* Or, also correct:
					 * iSize+=AddCharByChar (sCompressed, iSize, &iSame, 2);
					 */
				} else { /*** X = 4 ***/
					sToAdd[0] = (unsigned char)iX;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					sToAdd[0] = (unsigned char)iLength;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
					sToAdd[0] = (unsigned char)iSame;
					iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
				}
			} else {
				sToAdd[0] = (unsigned char)iX;
				iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
				sToAdd[0] = (unsigned char)iLength;
				iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
				sToAdd[0] = (unsigned char)sToCompress[iHave];
				iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
			}
			iHave+=iLength;
		}
	}

	/*** If there is still data to add, add it without compression. ***/
	if (iDataLength > 0)
	{
		sToAdd[0] = (unsigned char)(iDataLength + 128);
		iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
		iSize+=AddCharByChar (sCompressed, iSize, sData, iDataLength);
	}

	/*** Fill the rest with 0x00. ***/
	while (iHave < iNeed)
	{
		sToAdd[0] = (unsigned char)0x00;
		iSize+=AddCharByChar (sCompressed, iSize, sToAdd, 1);
	}

	return (iSize);
}
/*****************************************************************************/
int EventInfo (int iNr, int iType)
/*****************************************************************************/
{
	char sBinaryFDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sBinarySDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sTemp[MAX_DATA + 2];

	GetAsEightBits (sFirstDoorEvents[iNr], sBinaryFDoors);
	GetAsEightBits (sSecondDoorEvents[iNr], sBinarySDoors);

	switch (iType)
	{
		case 1: /*** room ***/
			snprintf (sTemp, MAX_DATA, "%c%c%c%c%c", sBinarySDoors[0],
				sBinarySDoors[1], sBinarySDoors[2], sBinaryFDoors[1],
				sBinaryFDoors[2]);
			if (iEditPoP == 3)
			{
				return (BitsToInt (sTemp) + 1);
			} else {
				return (BitsToInt (sTemp));
			}
			break;
		case 2: /*** location ***/
			snprintf (sTemp, MAX_DATA, "%c%c%c%c%c", sBinaryFDoors[3],
				sBinaryFDoors[4], sBinaryFDoors[5], sBinaryFDoors[6],
				sBinaryFDoors[7]);
			return (BitsToInt (sTemp) + 1); break;
		case 3: /*** next ***/
			switch (sBinaryFDoors[0])
			{
				case '0': return (1); break;
				case '1': return (0); break;
			}
			break;
		default:
			printf ("[ WARN ] Strange event info type: %i!\n", iType);
			break;
	}

	return (-1);
}
/*****************************************************************************/
int ReadFromFile (int iFd, char *sWhat, int iSize, unsigned char *sRetString)
/*****************************************************************************/
{
	int iLength;
	int iRead;
	char sRead[1 + 2];
	int iEOF;

	if ((iDebug == 1) && (strcmp (sWhat, "") != 0))
	{
		printf ("[  OK  ] Loading: %s\n", sWhat);
	}
	iLength = 0;
	iEOF = 0;
	do {
		iRead = read (iFd, sRead, 1);
		switch (iRead)
		{
			case -1:
				printf ("[FAILED] Could not read (1): %s!\n", strerror (errno));
				exit (EXIT_ERROR);
				break;
			case 0: PrIfDe ("[ INFO ] End of level file\n"); iEOF = 1; break;
			default:
				sRetString[iLength] = sRead[0];
				iLength++;
				break;
		}
	} while ((iLength < iSize) && (iEOF == 0));
	sRetString[iLength] = '\0';

	iReadFromFile+=iLength;

	return (iLength);
}
/*****************************************************************************/
int ReadLineFromFile (int iFd, char *sRetString, int iLtrim)
/*****************************************************************************/
{
	int iLength;
	int iRead;
	char sRead[1 + 2];
	int iEOF;
	int iEOL;
	char sRetNew[MAX_DATA + 2];
	char sRetTemp[MAX_DATA + 2];
	int iTemp;
	int iCount;

	iLength = 0;
	iEOF = 0;
	iEOL = 0;

	do {
		iRead = read (iFd, sRead, 1);
		switch (iRead)
		{
			case -1:
				printf ("[FAILED] Could not read (2): %s!\n", strerror (errno));
				exit (EXIT_ERROR);
				break;
			case 0: iEOF = 1; break;
			default:
				if (sRead[0] == '\n')
				{
					iEOL = 1;
				} else {
					sRetString[iLength] = sRead[0];
					iLength++;
				}
				break;
		}
	} while ((iEOL == 0) && (iEOF == 0) && (iLength < MAX_DATA));
	sRetString[iLength] = '\0';

	/*** Left trim tabs and spaces. ***/
	if (iLtrim == 1)
	{
		snprintf (sRetNew, MAX_DATA, "%s", "");
		iCount = 0;
		for (iTemp = 0; iTemp < (int)strlen (sRetString); iTemp++)
		{
			if ((iCount != 0) || ((sRetString[iTemp] != '\t') &&
				(sRetString[iTemp] != ' ')))
			{
				snprintf (sRetTemp, MAX_DATA, "%s", sRetNew);
				snprintf (sRetNew, MAX_DATA, "%s%c", sRetTemp, sRetString[iTemp]);
				iCount++;
			}
		}
		snprintf (sRetString, MAX_DATA, "%s", sRetNew);
	}

	switch (iEOF)
	{
		case 1: return (1); break;
		default: return (0); break;
	}
}
/*****************************************************************************/
void GetAsEightBits (unsigned char cChar, char *sBinary)
/*****************************************************************************/
{
	int i = CHAR_BIT;
	int iTemp;

	iTemp = 0;
	while (i > 0)
	{
		i--;
		if (cChar&(1 << i))
		{
			sBinary[iTemp] = '1';
		} else {
			sBinary[iTemp] = '0';
		}
		iTemp++;
	}
	sBinary[iTemp] = '\0';
}
/*****************************************************************************/
int BitsToInt (char *sString)
/*****************************************************************************/
{
	/*** Converts binary to decimal. ***/
	/*** Example: 11111111 to 255 ***/

	int iTemp = 0;

	for (; *sString; iTemp = (iTemp << 1) | (*sString++ - '0'));
	return (iTemp);
}
/*****************************************************************************/
void IntToBits (int iInt, char *sOutput, int iBits)
/*****************************************************************************/
{
	/*** Converts decimal to exactly iBits bits. ***/
	/*** Example: 255 to 11111111 ***/

	unsigned long luScale;
	unsigned long luFinal;
	int iTemp;
	int iDigit;
	char sOutputTemp[MAX_DATA + 2];

	iTemp = iInt;
	luScale = 1;
	luFinal = 0;

	while (iTemp > 0)
	{
		iDigit = iTemp % 2;
		luFinal+=iDigit * luScale;
		iTemp = iTemp / 2;
		luScale = luScale * 10;
	}

	snprintf (sOutput, MAX_DATA, "%lu", luFinal);
	if ((int)strlen (sOutput) != iBits)
	{
		do {
			snprintf (sOutputTemp, MAX_DATA, "%s", sOutput);
			snprintf (sOutput, MAX_DATA, "0%s", sOutputTemp);
		} while ((int)strlen (sOutput) != iBits);
	}
}
/*****************************************************************************/
void GetForegroundAsName (char *sBinaryFore, char *sName)
/*****************************************************************************/
{
	char sPart[6 + 2];

	strncpy (sPart, sBinaryFore + 3, 5);
	sPart[5]='\0';
	if (strcmp (sPart, "00000") == 0) { snprintf (sName, 9, "%s", "Empty  "); }
	if (strcmp (sPart, "00001") == 0) { snprintf (sName, 9, "%s", "Floor  "); }
	if (strcmp (sPart, "00010") == 0) { snprintf (sName, 9, "%s", "Spikes "); }
	if (strcmp (sPart, "00011") == 0) { snprintf (sName, 9, "%s", "Pillar "); }
	if (strcmp (sPart, "00100") == 0) { snprintf (sName, 9, "%s", "Gate   "); }
	if (strcmp (sPart, "00101") == 0) { snprintf (sName, 9, "%s", "StckBtn"); }
	if (strcmp (sPart, "00110") == 0) { snprintf (sName, 9, "%s", "DropBtn"); }
	if (strcmp (sPart, "00111") == 0) { snprintf (sName, 9, "%s", "Tpstry "); }
	if (strcmp (sPart, "01000") == 0) { snprintf (sName, 9, "%s", "BBgpilr"); }
	if (strcmp (sPart, "01001") == 0) { snprintf (sName, 9, "%s", "TBgpilr"); }
	if (strcmp (sPart, "01010") == 0) { snprintf (sName, 9, "%s", "Potion "); }
	if (strcmp (sPart, "01011") == 0)
	{
		if (sBinaryFore[2] == '1')
			{ snprintf (sName, 9, "%s", "LoosStk"); }
				else { snprintf (sName, 9, "%s", "LoosBrd"); }
	}
	if (strcmp (sPart, "01100") == 0) { snprintf (sName, 9, "%s", "TpstryT"); }
	if (strcmp (sPart, "01101") == 0) { snprintf (sName, 9, "%s", "Mirror "); }
	if (strcmp (sPart, "01110") == 0) { snprintf (sName, 9, "%s", "Debris "); }
	if (strcmp (sPart, "01111") == 0) { snprintf (sName, 9, "%s", "RaisBtn"); }
	if (strcmp (sPart, "10000") == 0) { snprintf (sName, 9, "%s", "ExitLft"); }
	if (strcmp (sPart, "10001") == 0) { snprintf (sName, 9, "%s", "ExitRgt"); }
	if (strcmp (sPart, "10010") == 0) { snprintf (sName, 9, "%s", "Chomper"); }
	if (strcmp (sPart, "10011") == 0) { snprintf (sName, 9, "%s", "Torch  "); }
	if (strcmp (sPart, "10100") == 0) { snprintf (sName, 9, "%s", "Wall   "); }
	if (strcmp (sPart, "10101") == 0) { snprintf (sName, 9, "%s", "Skeletn"); }
	if (strcmp (sPart, "10110") == 0) { snprintf (sName, 9, "%s", "Sword  "); }
	if (strcmp (sPart, "10111") == 0) { snprintf (sName, 9, "%s", "BcnyLft"); }
	if (strcmp (sPart, "11000") == 0) { snprintf (sName, 9, "%s", "BcnyRgt"); }
	if (strcmp (sPart, "11001") == 0) { snprintf (sName, 9, "%s", "LcePilr"); }
	if (strcmp (sPart, "11010") == 0) { snprintf (sName, 9, "%s", "LceSprt"); }
	if (strcmp (sPart, "11011") == 0) { snprintf (sName, 9, "%s", "SmalLce"); }
	if (strcmp (sPart, "11100") == 0) { snprintf (sName, 9, "%s", "LceLft "); }
	if (strcmp (sPart, "11101") == 0) { snprintf (sName, 9, "%s", "LceRgt "); }
	if (strcmp (sPart, "11110") == 0) { snprintf (sName, 9, "%s", "TorchDb"); }
	if (strcmp (sPart, "11111") == 0) { snprintf (sName, 9, "%s", "Null   "); }
}
/*****************************************************************************/
void GetModifierAsName (int iFore, int iMod, char *sName)
/*****************************************************************************/
{
	int iForeR;

	iForeR = iFore;
	if (iForeR >= 192) { iForeR-=192; }
	if (iForeR >= 128) { iForeR-=128; }
	if (iForeR >= 64) { iForeR-=64; }
	if (iForeR >= 32) { iForeR-=32; }

	snprintf (sName, 9, "%s", "???????");
	switch (iForeR)
	{
		case 0:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "+Not-Bl"); break;
				case 1: snprintf (sName, 9, "%s", "+Spt1-N"); break;
				case 2: snprintf (sName, 9, "%s", "+Spt2-D"); break;
				case 3: snprintf (sName, 9, "%s", "Window "); break;
				case 6: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 78: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 144: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 255: snprintf (sName, 9, "%s", "+Spt3-B"); break;
			}
			break;
		case 1:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "+Not-Bl"); break;
				case 1: snprintf (sName, 9, "%s", "+Spt1-N"); break;
				case 2: snprintf (sName, 9, "%s", "+Spt2-D"); break;
				case 3: snprintf (sName, 9, "%s", "Window "); break;
				case 6: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 78: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 144: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 255: snprintf (sName, 9, "%s", "+Spt3-B"); break;
			}
			break;
		case 2:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "Normal "); break;
				case 1: snprintf (sName, 9, "%s", "BarelyO"); break;
				case 2: snprintf (sName, 9, "%s", "HalfOut"); break;
				case 3: snprintf (sName, 9, "%s", "FulyOut"); break;
				case 4: snprintf (sName, 9, "%s", "FulyOut"); break;
				case 5: snprintf (sName, 9, "%s", "Out    "); break;
				case 6: snprintf (sName, 9, "%s", "Out    "); break;
				case 7: snprintf (sName, 9, "%s", "HalfOut"); break;
				case 8: snprintf (sName, 9, "%s", "BarelyO"); break;
				case 9: snprintf (sName, 9, "%s", "Disabld"); break;
			}
			break;
		case 3: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 4:
			switch (iMod)
			{
				/*** says the documentation ***/
				case 0: snprintf (sName, 9, "%s", "Closed "); break;
				case 1: snprintf (sName, 9, "%s", "Open   "); break;
				/*** says the game ***/
				case 2: snprintf (sName, 9, "%s", "Closed "); break;
			}
			break;
		case 5: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 6: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 7:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "-WithLt"); break;
				case 1: snprintf (sName, 9, "%s", "-AlterD"); break;
				case 2: snprintf (sName, 9, "%s", "-Normal"); break;
				case 3: snprintf (sName, 9, "%s", "-Black "); break;
				case 4: snprintf (sName, 9, "%s", "-Black "); break;
				case 5: snprintf (sName, 9, "%s", "-AltDes"); break;
				case 6: snprintf (sName, 9, "%s", "-WthBtm"); break;
				case 7: snprintf (sName, 9, "%s", "-WthWin"); break;
			}
			break;
		case 8: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 9: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 10:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "Empty  "); break;
				case 1: snprintf (sName, 9, "%s", "HealthP"); break;
				case 2: snprintf (sName, 9, "%s", "Life   "); break;
				case 3: snprintf (sName, 9, "%s", "FeatFal"); break;
				case 4: snprintf (sName, 9, "%s", "Invert "); break;
				case 5: snprintf (sName, 9, "%s", "Poison "); break;
				case 6: snprintf (sName, 9, "%s", "Open   "); break;
				case 32: snprintf (sName, 9, "%s", "PRINCES"); break;
				case 64: snprintf (sName, 9, "%s", "PRINCES"); break;
				case 160: snprintf (sName, 9, "%s", "PRINCES"); break;
			}
			break;
		case 11: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 12:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "-WithLt"); break;
				case 1: snprintf (sName, 9, "%s", "-AlterD"); break;
				case 2: snprintf (sName, 9, "%s", "-Normal"); break;
				case 3: snprintf (sName, 9, "%s", "-Black "); break;
			}
			break;
		case 13: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 14: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 15: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 16: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 17:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "Always "); break;
				case 255: snprintf (sName, 9, "%s", "POTIONS"); break;
			}
			break;
		case 18:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "Normal "); break;
				case 1: snprintf (sName, 9, "%s", "HalfOpn"); break;
				case 2: snprintf (sName, 9, "%s", "Closed "); break;
				case 3: snprintf (sName, 9, "%s", "PartOpn"); break;
				case 4: snprintf (sName, 9, "%s", "ExtrOpn"); break;
				case 5: snprintf (sName, 9, "%s", "StckOpn"); break;
			}
			break;
		case 19: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 20:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "+Norm-B"); break;
				case 1: snprintf (sName, 9, "%s", "+Norm-N"); break;
			}
			break;
		case 21: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 22: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 23: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 24: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 25: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 26: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 27: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 28: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 29: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 30: if (iMod == 0) { snprintf (sName, 9, "%s", "Always "); } break;
		case 31:
			switch (iMod)
			{
				case 0: snprintf (sName, 9, "%s", "Always "); break;
				case 253: snprintf (sName, 9, "%s", "POTIONS"); break;
				case 255: snprintf (sName, 9, "%s", "POTIONS"); break;
			}
			break;
	}
}
/*****************************************************************************/
char cShowDirection (int iDirection)
/*****************************************************************************/
{
	switch (iDirection)
	{
		case 0: return ('r'); break;
		case 1: return ('l'); break; /*** PoP1 for SNES guards only. ***/
		case 255: return ('l'); break;
		default: return ('?'); break;
	}
}
/*****************************************************************************/
void ShowImage (int iThingOrRoom, int iModifier[], SDL_Renderer *screen,
	int iLocation, int iFromImageX, int iFromImageY,
	int iFromImageWidth, int iFromImageHeight)
/*****************************************************************************/
{
	/* When it comes to showing regular, full images, ShowImage() is deprecated.
	 * Wherever possible, try to call ShowImageBasic() instead.
	 */

	SDL_Rect dest;
	SDL_Rect loc;
	char sAdj[MAX_ADJ + 2];
	char sAdjR[MAX_ADJ + 2];
	char sAdjL[MAX_ADJ + 2];
	char sGrid[MAX_GRID + 2];
	char sGridX[MAX_GRID + 2];
	char sGridY[MAX_GRID + 2];
	char sText[MAX_TEXT + 2];
	char sCustomTile[MAX_CUSTOM + 2];
	int iTemp;
	int iTemp2;
	int iTile;
	int iMod1;
	int iMod2;
	int iDirection;
	int iBaseY;
	int iUseSprite;
	int iGuardSwitch;
	int iDAmount;
	int iInfoC;
	char arText[9 + 2][MAX_TEXT + 2];
	int iThing, iRoom;
	char sBlock[20 + 2];
	int iTargetRoom, iTargetTile;
	SDL_Texture *imgshow[2 + 2];
	int iBackValue, iBackAnim, iBackRow, iBackColumn;
	int iB1, iB2, iB3, iB4;
	int iType;
	int iArLX, iArLY, iArRX, iArRY, iArUX, iArUY, iArDX, iArDY;
	int iTileLoop;
	int iTileNr;
	char sAnimGroup[MAX_TEXT + 2];
	char sSFW[10 + 2];

	iThing = iThingOrRoom;
	iRoom = -1; /*** To prevent warnings. ***/
	if (iEditPoP == 3) { iRoom = iThingOrRoom; }

	loc.x = iFromImageX;
	loc.y = iFromImageY;
	loc.w = iFromImageWidth;
	loc.h = iFromImageHeight;

	switch (iLocation)
	{
		case -1: dest.x = iHor0; dest.y = iVer1; break;
		case -2: dest.x = iHor0; dest.y = iVer2; break;
		case -3: dest.x = iHor0; dest.y = iVer3; break;
		case -4: dest.x = iHor0; dest.y = iVer4; break;
		case -5: dest.x = iHor1; dest.y = iVer4; break;
		case -6: dest.x = iHor2; dest.y = iVer4; break;
		case -7: dest.x = iHor3; dest.y = iVer4; break;
		case -8: dest.x = iHor4; dest.y = iVer4; break;
		case -9: dest.x = iHor5; dest.y = iVer4; break;
		case -10: dest.x = iHor6; dest.y = iVer4; break;
		case -11: dest.x = iHor7; dest.y = iVer4; break;
		case -12: dest.x = iHor8; dest.y = iVer4; break;
		case -13: dest.x = iHor9; dest.y = iVer4; break;
		case -14: dest.x = iHor10; dest.y = iVer4; break;
		case 1:
			if (iThing >= 0) /*** A tile. ***/
			{
				if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
					(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
					(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
				{
					if (iEditPoP != 3)
						{ iThingOrRoom = iThingA[iRoomConnections[iCurRoom][1]][9]; }
							else { iThingOrRoom = iRoomConnections[iCurRoom][1]; }
					ShowImage (iThingOrRoom, (int[]){
						iModifierA[iRoomConnections[iCurRoom][1]][9][1],
						iModifierA[iRoomConnections[iCurRoom][1]][9][2],
						iModifierA[iRoomConnections[iCurRoom][1]][9][3],
						iModifierA[iRoomConnections[iCurRoom][1]][9][4]},
						screen, -1, 0, 0, iTileW, iTileH);
				} else {
					if (iEditPoP != 3)
					{
						ShowImage (20, (int[]){0, 0, 0, 0},
							screen, -1, 0, 0, iTileW, iTileH);
					} else {
						ShowImage (255, (int[]){0, 0, 0, 0},
							screen, -1, 0, 0, iTileW, iTileH);
					}
				}
				ShowImage (-11, (int[]){0, 0, 0, 0}, screen, -1, 0, 0, iTileW, iTileH);
			}
			dest.x = iHor1; dest.y = iVer1;
			break;
		case 2: dest.x = iHor2; dest.y = iVer1; break;
		case 3: dest.x = iHor3; dest.y = iVer1; break;
		case 4: dest.x = iHor4; dest.y = iVer1; break;
		case 5: dest.x = iHor5; dest.y = iVer1; break;
		case 6: dest.x = iHor6; dest.y = iVer1; break;
		case 7: dest.x = iHor7; dest.y = iVer1; break;
		case 8: dest.x = iHor8; dest.y = iVer1; break;
		case 9: dest.x = iHor9; dest.y = iVer1; break;
		case 10: dest.x = iHor10; dest.y = iVer1; break;

		case 11:
			if (iThing >= 0) /*** A tile. ***/
			{
				if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
					(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
					(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
				{
					if (iEditPoP != 3)
						{ iThingOrRoom = iThingA[iRoomConnections[iCurRoom][1]][19]; }
							else { iThingOrRoom = iRoomConnections[iCurRoom][1]; }
					ShowImage (iThingOrRoom, (int[]){
						iModifierA[iRoomConnections[iCurRoom][1]][19][1],
						iModifierA[iRoomConnections[iCurRoom][1]][19][2],
						iModifierA[iRoomConnections[iCurRoom][1]][19][3],
						iModifierA[iRoomConnections[iCurRoom][1]][19][4]},
						screen, -2, 0, 0, iTileW, iTileH);
				} else {
					if (iEditPoP != 3)
					{
						ShowImage (20, (int[]){0, 0, 0, 0},
							screen, -2, 0, 0, iTileW, iTileH);
					} else {
						ShowImage (255, (int[]){0, 0, 0, 0},
							screen, -2, 0, 0, iTileW, iTileH);
					}
				}
				ShowImage (-11, (int[]){0, 0, 0, 0}, screen, -2, 0, 0, iTileW, iTileH);
			}
			dest.x = iHor1; dest.y = iVer2;
			break;
		case 12: dest.x = iHor2; dest.y = iVer2; break;
		case 13: dest.x = iHor3; dest.y = iVer2; break;
		case 14: dest.x = iHor4; dest.y = iVer2; break;
		case 15: dest.x = iHor5; dest.y = iVer2; break;
		case 16: dest.x = iHor6; dest.y = iVer2; break;
		case 17: dest.x = iHor7; dest.y = iVer2; break;
		case 18: dest.x = iHor8; dest.y = iVer2; break;
		case 19: dest.x = iHor9; dest.y = iVer2; break;
		case 20: dest.x = iHor10; dest.y = iVer2; break;

		case 21:
			if (iThing >= 0) /*** A tile. ***/
			{
				/* One day, we could also do the following for rooms
				 * down,left in addition to the current left,down.
				 */
				if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
					(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
					(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
				{
					/*** DOS, SNES, SNES ***/
					if ((iRoomConnections[iRoomConnections[iCurRoom][1]][4] != 0) &&
						(iRoomConnections[iRoomConnections[iCurRoom][1]][4] != 254) &&
						(iRoomConnections[iRoomConnections[iCurRoom][1]][4] != 255))
					{
						if (iEditPoP != 3)
							{ iThingOrRoom = iThingA[iRoomConnections[iRoomConnections
								[iCurRoom][1]][4]][9]; }
								else { iThingOrRoom = iRoomConnections[iRoomConnections
									[iCurRoom][1]][4]; }
						ShowImage (iThingOrRoom, (int[]){
							iModifierA[iRoomConnections[iRoomConnections
								[iCurRoom][1]][4]][9][1],
							iModifierA[iRoomConnections[iRoomConnections
								[iCurRoom][1]][4]][9][2],
							iModifierA[iRoomConnections[iRoomConnections
								[iCurRoom][1]][4]][9][3],
							iModifierA[iRoomConnections[iRoomConnections
								[iCurRoom][1]][4]][9][4]},
							screen, -4, 0, 0, iTileW, iTileH);
					} else {
						if (iEditPoP != 3)
						{
							ShowImage (20, (int[]){0, 0, 0, 0},
								screen, -4, 0, 0, iTileW, iTileH);
						} else {
							ShowImage (255, (int[]){0, 0, 0, 0},
								screen, -4, 0, 0, iTileW, iTileH);
						}
					}
				}
				ShowImage (-11, (int[]){0, 0, 0, 0}, screen, -4, 0, 0, iTileW, iTileH);
				if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
					(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
					(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
				{
					if (iEditPoP != 3)
						{ iThingOrRoom = iThingA[iRoomConnections[iCurRoom][1]][29]; }
							else { iThingOrRoom = iRoomConnections[iCurRoom][1]; }
					ShowImage (iThingOrRoom, (int[]){
						iModifierA[iRoomConnections[iCurRoom][1]][29][1],
						iModifierA[iRoomConnections[iCurRoom][1]][29][2],
						iModifierA[iRoomConnections[iCurRoom][1]][29][3],
						iModifierA[iRoomConnections[iCurRoom][1]][29][4]},
						screen, -3, 0, 0, iTileW, iTileH);
				} else {
					if (iEditPoP != 3)
					{
						ShowImage (20, (int[]){0, 0, 0, 0},
							screen, -3, 0, 0, iTileW, iTileH);
					} else {
						ShowImage (255, (int[]){0, 0, 0, 0},
							screen, -3, 0, 0, iTileW, iTileH);
					}
				}
				ShowImage (-11, (int[]){0, 0, 0, 0}, screen, -3, 0, 0, iTileW, iTileH);
			}
			dest.x = iHor1; dest.y = iVer3;
			break;
		case 22: dest.x = iHor2; dest.y = iVer3; break;
		case 23: dest.x = iHor3; dest.y = iVer3; break;
		case 24: dest.x = iHor4; dest.y = iVer3; break;
		case 25: dest.x = iHor5; dest.y = iVer3; break;
		case 26: dest.x = iHor6; dest.y = iVer3; break;
		case 27: dest.x = iHor7; dest.y = iVer3; break;
		case 28: dest.x = iHor8; dest.y = iVer3; break;
		case 29: dest.x = iHor9; dest.y = iVer3; break;
		case 30: dest.x = iHor10; dest.y = iVer3; break;

		/*** black background & previous & faded background & changes & help ***/
		/*** & exe & PoP select background ***/
		case 31: dest.x = 0; dest.y = 0; break;
		case 32: dest.x = 0; dest.y = 50; break; /*** left ***/
		case 33: dest.x = 667; dest.y = 50; break; /*** right ***/
		case 34: dest.x = 25; dest.y = 25; break; /*** up ***/
		case 35: dest.x = 25; dest.y = 430; break; /*** down ***/
		case 36: dest.x = 0; dest.y = 25; break; /*** rooms ***/
		case 37: dest.x = 667; dest.y = 25; break; /*** events ***/
		case 38: dest.x = 0; dest.y = 430; break; /*** save ***/
		case 39: dest.x = 667; dest.y = 430; break; /*** quit ***/
		case 40: dest.x = 667; dest.y = 0; break; /*** next ***/
		case 41: dest.x = 25; dest.y = 0; break; /*** level bar ***/
		/*** room links and events and PoP2 backgrounds ***/
		case 42: dest.x = 25; dest.y = 50; break;
		case 43: dest.x = 590; dest.y = 405; break; /*** OK (help) ***/
		case 44: dest.x = 84; dest.y = 5; break; /*** popup ***/
		case 45: dest.x = 440; dest.y = 317; break; /*** OK ***/
		case 46: dest.x = 300; dest.y = 183; break; /*** hourglass ***/
		case 47: dest.x = 656; dest.y = 0; break; /*** close ***/
		case 48: /*** changing ***/
			if (iOnTile <= (7 * 13)) /*** Regular large tiles. ***/
			{
				/*** Was: (Modulo (iOnTile, 13, 1) - 1) ***/
				dest.x = 2 + (((iOnTile - 1) % 13) * 50);
				/*** Was: (Modulo (iOnTile, 13, 2) - 1) ***/
				dest.y = 2 + (((int)((iOnTile - 1) / 13)) * 64);
				if ((cCurType == 'o') && (iOnTile >= 14) && (iOnTile <= 26))
					{ dest.y-=20; } /*** 1.5 row ***/
				if ((cCurType == 'o') && (iOnTile >= 27) && (iOnTile <= 39))
					{ dest.y-=10; } /*** 2.5 row ***/
			} else { /*** Half sized tiles (humans). ***/
				if (iEditPoP != 3)
				{
					dest.x = 2 + ((iOnTile - (7 * 13) - 1) * 25);
					dest.y = 386;
				} else {
					if ((iOnTile >= (7 * 13) + 1) && (iOnTile <= (7 * 13) + 26))
					{
						/*** top row ***/
						dest.x = 2 + ((iOnTile - (7 * 13) - 1) * 25);
						dest.y = 258;
					} else {
						/*** bottom row ***/
						dest.x = 2 + ((iOnTile - (7 * 13) - 27) * 25);
						dest.y = 322;
					}
				}
			}
			break;
		case 49: /*** sel event, room ***/
			if (iEditPoP != 2)
			{
				dest.x = 282 + (EventInfo (iChangeEvent, 1) * 15);
				dest.y = 115;
			} else {
				if (iPoP2DoorRoom[iChangeEvent] <= 24)
				{
					dest.x = 282 + (iPoP2DoorRoom[iChangeEvent] * 15);
					dest.y = 115;
				} else {
					dest.x = -78 + (iPoP2DoorRoom[iChangeEvent] * 15);
					dest.y = 150;
				}
			}
			break;
		case 50: /*** sel event, location ***/
			if (iEditPoP != 2)
			{
				iTemp = EventInfo (iChangeEvent, 2);
			} else {
				iTemp = iPoP2DoorLocation[iChangeEvent] + 1;
			}
			if ((iTemp >= 1) && (iTemp <= 10))
			{
				dest.x = 447 + (iTemp * 15);
				dest.y = 155;
			}
			if ((iTemp >= 11) && (iTemp <= 20))
			{
				dest.x = 447 + ((iTemp - 10) * 15);
				dest.y = 170;
			}
			if ((iTemp >= 21) && (iTemp <= 30))
			{
				dest.x = 447 + ((iTemp - 20) * 15);
				dest.y = 185;
			}
			break;
		case 51: /*** sel event, next ***/
			if (iEditPoP != 2)
			{
				dest.x = 582 + (EventInfo (iChangeEvent, 3) * 15);
				dest.y = 225;
			} else {
				printf ("[ WARN ] PoP2 has left/right chains, no next.\n");
			}
			break;
		case 52: dest.x = 552; dest.y = 322; break;
		case 53: dest.x = 452; dest.y = 322; break;
		case 54: dest.x = 402; dest.y = 386; break;
		case 55: dest.x = 352; dest.y = 322; break;
		case 56: dest.x = 2; dest.y = 386; break;
		case 57: /*** kid, turned right ***/
			if (iEditPoP != 3)
			{
				dest.x = 352; dest.y = 386;
			} else {
				dest.x = 2; dest.y = 258;
			}
			break;
		case 58: /*** kid, turned left ***/
			if (iEditPoP != 3)
			{
				dest.x = 377; dest.y = 386;
			} else {
				dest.x = 27; dest.y = 258;
			}
			break;

		/*** guards ***/
		case 59: dest.x = 2; dest.y = 386; break;
		case 60: dest.x = 27; dest.y = 386; break;
		case 61: dest.x = 52; dest.y = 386; break;
		case 62: dest.x = 77; dest.y = 386; break;
		case 63: dest.x = 102; dest.y = 386; break;
		case 64: dest.x = 127; dest.y = 386; break;
		case 65: dest.x = 152; dest.y = 386; break;
		case 66: dest.x = 177; dest.y = 386; break;
		case 67: dest.x = 202; dest.y = 386; break;
		case 68: dest.x = 227; dest.y = 386; break;
		case 69: dest.x = 252; dest.y = 386; break;
		case 70: dest.x = 277; dest.y = 386; break;
		case 71: dest.x = 302; dest.y = 386; break;
		case 72: dest.x = 327; dest.y = 386; break;

		/*** skeleton, fat, jaffar, shadow ***/
		case 73: dest.x = 552; dest.y = 322; break;
		case 74: dest.x = 602; dest.y = 322; break;
		case 75: dest.x = 452; dest.y = 322; break;
		case 76: dest.x = 502; dest.y = 322; break;
		case 77: dest.x = 402; dest.y = 386; break;
		case 78: dest.x = 427; dest.y = 386; break;
		case 79: dest.x = 352; dest.y = 322; break;
		case 80: dest.x = 402; dest.y = 322; break;

		case 81:
			switch (iGuardSkill)
			{
				case 0: dest.x = 455; dest.y = 420; break;
				case 1: dest.x = 470; dest.y = 420; break;
				case 2: dest.x = 485; dest.y = 420; break;
				case 3: dest.x = 500; dest.y = 420; break;
				case 4: dest.x = 515; dest.y = 420; break;
				case 5: dest.x = 455; dest.y = 435; break;
				case 6: dest.x = 470; dest.y = 435; break;
				case 7: dest.x = 485; dest.y = 435; break;
				case 8: dest.x = 500; dest.y = 435; break;
				case 9: dest.x = 515; dest.y = 435; break;
				case 10: dest.x = 500; dest.y = 405; break;
				case 11: dest.x = 515; dest.y = 405; break;
			}
			break;
		case 82:
			iIsCustom = 0;
			if (iEditPoP != 3)
			{
				iTile = iThingA[iCurRoom][iSelected - 1];
			} else {
				iB1 = iBlock1A[iCurRoom][iSelected - 1];
				iB2 = iBlock2A[iCurRoom][iSelected - 1];
				iB3 = iBlock3A[iCurRoom][iSelected - 1];
				iB4 = iBlock4A[iCurRoom][iSelected - 1];
			}
			iMod1 = iModifierA[iCurRoom][iSelected - 1][1];
			if (iEditPoP == 2)
			{
				iMod2 = iModifierA[iCurRoom][iSelected - 1][2];
			} else { iMod2 = 0; } /*** To prevent an "uninitialized" warning. ***/

			if (iEditPoP == 1)
			{
				iTileNr = GetTileNr (iTile, iMod1);
				switch (iTileNr)
				{
					case 0: iIsCustom = 1; break;

					/*** first row ***/
					case 1: dest.x = TILESX1; dest.y = TILESY1; break;
					case 2: dest.x = TILESX2; dest.y = TILESY1; break;
					case 3: dest.x = TILESX3; dest.y = TILESY1; break;
					case 4: dest.x = TILESX4; dest.y = TILESY1; break;
					case 5: dest.x = TILESX5; dest.y = TILESY1; break;
					case 6: dest.x = TILESX6; dest.y = TILESY1; break;
					case 7: dest.x = TILESX7; dest.y = TILESY1; break;
					case 8: dest.x = TILESX8; dest.y = TILESY1; break;
					case 9: dest.x = TILESX9; dest.y = TILESY1; break;
					case 10: dest.x = TILESX10; dest.y = TILESY1; break;
					case 11: dest.x = TILESX11; dest.y = TILESY1; break;
					case 12: dest.x = TILESX12; dest.y = TILESY1; break;
					case 13: dest.x = TILESX13; dest.y = TILESY1; break;

					/*** second row ***/
					case 14: dest.x = TILESX1; dest.y = TILESY2; break;
					case 15: dest.x = TILESX2; dest.y = TILESY2; break;
					case 16: dest.x = TILESX3; dest.y = TILESY2; break;
					case 17: dest.x = TILESX4; dest.y = TILESY2; break;
					case 18: dest.x = TILESX5; dest.y = TILESY2; break;
					case 19: dest.x = TILESX6; dest.y = TILESY2; break;
					case 20: dest.x = TILESX7; dest.y = TILESY2; break;
					case 21: dest.x = TILESX8; dest.y = TILESY2; break;
					case 22: dest.x = TILESX9; dest.y = TILESY2; break;
					case 23: dest.x = TILESX10; dest.y = TILESY2; break;
					case 24: dest.x = TILESX11; dest.y = TILESY2; break;
					case 25: dest.x = TILESX12; dest.y = TILESY2; /*** Drop button. ***/
						iChangeEvent = iMod1; break;
					case 26: dest.x = TILESX13; dest.y = TILESY2; break;

					/*** third row ***/
					case 27: dest.x = TILESX1; dest.y = TILESY3; break;
					case 28: dest.x = TILESX2; dest.y = TILESY3; break;
					case 29: dest.x = TILESX3; dest.y = TILESY3; break;
					case 30: dest.x = TILESX4; dest.y = TILESY3; break;
					case 31: dest.x = TILESX5; dest.y = TILESY3; break;
					case 32: dest.x = TILESX6; dest.y = TILESY3; break;
					case 33: dest.x = TILESX7; dest.y = TILESY3; break;
					case 34: dest.x = TILESX8; dest.y = TILESY3; break;
					case 35: dest.x = TILESX9; dest.y = TILESY3; break;
					case 36: dest.x = TILESX10; dest.y = TILESY3; break;
					case 37: dest.x = TILESX11; dest.y = TILESY3; break;
					case 38: dest.x = TILESX12; dest.y = TILESY3; break;
					case 39: dest.x = TILESX13; dest.y = TILESY3; break;

					/*** fourth row ***/
					case 40: dest.x = TILESX1; dest.y = TILESY4; break;
					case 41: dest.x = TILESX2; dest.y = TILESY4; break;
					case 42: dest.x = TILESX3; dest.y = TILESY4; break;
					case 43: dest.x = TILESX4; dest.y = TILESY4; break;
					case 44: dest.x = TILESX5; dest.y = TILESY4; break;
					case 45: dest.x = TILESX6; dest.y = TILESY4; break;
					case 46: dest.x = TILESX7; dest.y = TILESY4; break;
					case 47: dest.x = TILESX8; dest.y = TILESY4; break;
					case 48: dest.x = TILESX9; dest.y = TILESY4; break;
					case 49: dest.x = TILESX10; dest.y = TILESY4; break;
					case 50: dest.x = TILESX11; dest.y = TILESY4; /*** Raise button. ***/
						iChangeEvent = iMod1; break;
					case 51: dest.x = TILESX12; dest.y = TILESY4; break;
					case 52: dest.x = TILESX13; dest.y = TILESY4; break;

					/*** fifth row ***/
					case 53: dest.x = TILESX1; dest.y = TILESY5; break;
					case 54: dest.x = TILESX2; dest.y = TILESY5; break;
					case 55: dest.x = TILESX3; dest.y = TILESY5; break;
					case 56: dest.x = TILESX4; dest.y = TILESY5; break;
					case 57: dest.x = TILESX5; dest.y = TILESY5; break;
					case 58: dest.x = TILESX6; dest.y = TILESY5; break;
					case 59: dest.x = TILESX7; dest.y = TILESY5; break;
					case 60: dest.x = TILESX8; dest.y = TILESY5; break;
					case 61: dest.x = TILESX9; dest.y = TILESY5; break;
					case 62: dest.x = TILESX10; dest.y = TILESY5; break;
					case 63: dest.x = TILESX11; dest.y = TILESY5; break;
					case 64: dest.x = TILESX12; dest.y = TILESY5; break;
					case 65: dest.x = TILESX13; dest.y = TILESY5; break;

					/*** sixth row ***/
					case 66: dest.x = TILESX1; dest.y = TILESY6; break;
					case 67: dest.x = TILESX2; dest.y = TILESY6; break;
					case 68: dest.x = TILESX3; dest.y = TILESY6; break;
					case 69: dest.x = TILESX4; dest.y = TILESY6; break;
					case 70: dest.x = TILESX5; dest.y = TILESY6; break;
					case 71: dest.x = TILESX6; dest.y = TILESY6; break;
					case 72: dest.x = TILESX7; dest.y = TILESY6; break;

					default:
						if (iTileNr >= 10000) /*** native ***/
						{
							iIsCustom = 1;
						} else {
							printf ("[ WARN ] Unknown tile: %i!\n", iTileNr);
							iIsCustom = 1; /*** Fallback. ***/
						}
						break;
				}
			}

			if (iEditPoP == 2)
			{
				/*** rooftops, desert, final ***/
				if (cCurType == 'o')
				{
					/*** 1.5 row ***/
					if (iTile == 0)
						{ dest.x = TILESX4; dest.y = TILESY15; }
					else if (iTile == 1)
						{ dest.x = TILESX5; dest.y = TILESY15; }
					else if (iTile == 20)
						{ dest.x = TILESX6; dest.y = TILESY15; }
					else if (iTile == 3)
						{ dest.x = TILESX10; dest.y = TILESY15; }
					else if (iTile == 37)
						{ dest.x = TILESX11; dest.y = TILESY15; }
					else if (iTile == 38)
						{ dest.x = TILESX12; dest.y = TILESY15; }
					else if (iTile == 39)
						{ dest.x = TILESX13; dest.y = TILESY15; }

					/*** 2.5 row ***/
					else if (iTile == 4)
					{
						dest.x = TILESX3; dest.y = TILESY25;
						iChangePercent = ModAsPercent (iMod1, 4);
					}
					else if (iTile == 28)
						{ dest.x = TILESX4; dest.y = TILESY25; }
					else if (iTile == 29)
						{ dest.x = TILESX5; dest.y = TILESY25; }
					else if (iTile == 30)
						{ dest.x = TILESX6; dest.y = TILESY25; }
					else if ((iTile == 10) && (iMod1 >= 32) && (iMod1 <= 63))
						{ dest.x = TILESX10; dest.y = TILESY25; }
					else if (iTile == 31)
						{ dest.x = TILESX11; dest.y = TILESY25; }
					else if (iTile == 40)
						{ dest.x = TILESX12; dest.y = TILESY25; }
					else if (iTile == 41)
						{ dest.x = TILESX13; dest.y = TILESY25; }

					/*** fourth row ***/
					else if (iTile == 2)
						{ dest.x = TILESX1; dest.y = TILESY4; }
					else if (iTile == 5)
						{ dest.x = TILESX2; dest.y = TILESY4; iChangeEvent = iMod1; }
					else if (iTile == 6)
						{ dest.x = TILESX3; dest.y = TILESY4; iChangeEvent = iMod1; }
					else if ((iTile == 7) && (iMod1 == 0))
						{ dest.x = TILESX4; dest.y = TILESY4; }
					else if ((iTile == 7) && (iMod1 == 1))
						{ dest.x = TILESX5; dest.y = TILESY4; }
					else if ((iTile == 7) && (iMod1 == 2))
						{ dest.x = TILESX6; dest.y = TILESY4; }
					else if ((iTile == 7) && (iMod1 == 3))
						{ dest.x = TILESX7; dest.y = TILESY4; }
					else if (iTile == 8)
						{ dest.x = TILESX8; dest.y = TILESY4; }
					else if (iTile == 9)
						{ dest.x = TILESX9; dest.y = TILESY4; }
					else if ((iTile == 10) && (iMod1 >= 0) && (iMod1 <= 31))
						{ dest.x = TILESX10; dest.y = TILESY4; }
					else if ((iTile == 10) && (iMod1 >= 64) && (iMod1 <= 95))
						{ dest.x = TILESX11; dest.y = TILESY4; }
					else if ((iTile == 10) && (iMod1 >= 96) && (iMod1 <= 127))
						{ dest.x = TILESX12; dest.y = TILESY4; }
					else if ((iTile == 10) && (iMod1 >= 128) && (iMod1 <= 159))
						{ dest.x = TILESX13; dest.y = TILESY4; }

					/*** fifth row ***/
					else if ((iTile == 10) && (iMod1 >= 160) && (iMod1 <= 191))
						{ dest.x = TILESX1; dest.y = TILESY5; }
					else if ((iTile == 10) && (iMod1 >= 192) && (iMod1 <= 223))
						{ dest.x = TILESX2; dest.y = TILESY5; }
					else if ((iTile == 10) && (iMod1 >= 224) && (iMod1 <= 255))
						{ dest.x = TILESX3; dest.y = TILESY5; }
					else if (iTile == 11)
					{
						dest.x = TILESX4; dest.y = TILESY5;
						iChangeJumps = ModAsJumps (iMod1);
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if (iTile == 12)
					{
						dest.x = TILESX5; dest.y = TILESY5;
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if (iTile == 13)
						{ dest.x = TILESX6; dest.y = TILESY5; }
					else if (iTile == 14)
						{ dest.x = TILESX7; dest.y = TILESY5; }
					else if (iTile == 15)
						{ dest.x = TILESX8; dest.y = TILESY5; }
					else if (iTile == 16)
						{ dest.x = TILESX9; dest.y = TILESY5; }
					else if (iTile == 17)
					{
						dest.x = TILESX10; dest.y = TILESY5;
						iChangePercent = ModAsPercent (iMod1, 17);
					}

					/*** sixth row ***/
					else if (iTile == 18)
						{ dest.x = TILESX1; dest.y = TILESY6; }
					else if (iTile == 19)
						{ dest.x = TILESX2; dest.y = TILESY6; }
					else if (iTile == 21)
						{ dest.x = TILESX3; dest.y = TILESY6; }
					else if ((iTile == 22) && (iMod1 == 0))
						{ dest.x = TILESX4; dest.y = TILESY6; }
					else if ((iTile == 22) && (iMod1 == 1))
						{ dest.x = TILESX5; dest.y = TILESY6; }
					else if (iTile == 23)
						{ dest.x = TILESX6; dest.y = TILESY6; }
					else if (iTile == 24)
						{ dest.x = TILESX7; dest.y = TILESY6; }
					else if (iTile == 25)
						{ dest.x = TILESX8; dest.y = TILESY6; }
					else if (iTile == 26)
						{ dest.x = TILESX9; dest.y = TILESY6; }
					else if (iTile == 27)
						{ dest.x = TILESX10; dest.y = TILESY6; }

					/*** seventh row ***/
					else if (iTile == 32)
						{ dest.x = TILESX1; dest.y = TILESY7; }
					else if (iTile == 33)
						{ dest.x = TILESX2; dest.y = TILESY7; }
					else if (iTile == 34)
						{ dest.x = TILESX3; dest.y = TILESY7; iChangeEvent = iMod1; }
					else if (iTile == 35)
						{ dest.x = TILESX4; dest.y = TILESY7; }
					else if (iTile == 36)
					{
						dest.x = TILESX5; dest.y = TILESY7;
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if (iTile == 43)
						{ dest.x = TILESX9; dest.y = TILESY7; }
					else if (iTile == 44)
						{ dest.x = TILESX10; dest.y = TILESY7; }

					else { iIsCustom = 1; }
				}
				/*** caverns ***/
				if (cCurType == 'c')
				{
					/*** first row ***/
					if ((iTile == 0) && (iMod1 == 0))
					{
						dest.x = TILESX1; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 0) && (iMod1 == 1))
					{
						dest.x = TILESX2; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 0) && (iMod1 == 2))
					{
						dest.x = TILESX3; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 0) && (iMod1 == 3))
					{
						dest.x = TILESX4; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 0) && (iMod1 == 4))
					{
						dest.x = TILESX5; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 1) && (iMod1 == 0))
					{
						dest.x = TILESX6; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 1) && (iMod1 == 1))
					{
						dest.x = TILESX7; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 1) && (iMod1 == 2))
					{
						dest.x = TILESX8; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 2) && (iMod1 == 0))
					{
						dest.x = TILESX9; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 2) && (iMod1 == 5))
					{
						dest.x = TILESX10; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if (iTile == 3)
					{
						dest.x = TILESX11; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 4) && (iMod1 == 0))
					{
						dest.x = TILESX12; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 4) && (iMod1 != 0) && (iMod1 != 200))
					{
						dest.x = TILESX13; dest.y = TILESY1;
						iChangePercent = ModAsPercent (iMod1, 4);
						ExtractFromMod2 (iMod2, 'b', 's');
					}

					/*** second row ***/
					else if ((iTile == 4) && (iMod1 == 200))
					{
						dest.x = TILESX1; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 8) && (iMod1 == 0))
					{
						dest.x = TILESX2; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 8) && ((iMod1 == 1) || (iMod1 == 5)))
					{
						dest.x = TILESX3; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 8) && (iMod1 == 2))
					{
						dest.x = TILESX4; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if (iTile == 9)
					{
						dest.x = TILESX5; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 0) && (iMod1 <= 31))
					{
						dest.x = TILESX6; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 32) && (iMod1 <= 63))
					{
						dest.x = TILESX7; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 64) && (iMod1 <= 95))
					{
						dest.x = TILESX8; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 96) && (iMod1 <= 127))
					{
						dest.x = TILESX9; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 128) && (iMod1 <= 159))
					{
						dest.x = TILESX10; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 160) && (iMod1 <= 191))
					{
						dest.x = TILESX11; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 192) && (iMod1 <= 223))
					{
						dest.x = TILESX12; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 224) && (iMod1 <= 255))
					{
						dest.x = TILESX13; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'b', 's');
					}

					/*** third row ***/
					else if ((iTile == 11) && (iMod1 <= 127))
					{
						dest.x = TILESX1; dest.y = TILESY3;
						iChangeJumps = ModAsJumps (iMod1);
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 11) && (iMod1 >= 128))
					{
						dest.x = TILESX2; dest.y = TILESY3;
						iChangeJumps = ModAsJumps (iMod1);
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 14) && (iMod1 == 0))
					{
						dest.x = TILESX3; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 14) && (iMod1 == 1))
					{
						dest.x = TILESX4; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 14) && (iMod1 == 2))
					{
						dest.x = TILESX5; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if (iTile == 16)
					{
						dest.x = TILESX6; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 17) && (iMod1 == 0))
					{
						dest.x = TILESX7; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 17) && (iMod1 != 0) && (iMod1 != 42))
					{
						dest.x = TILESX8; dest.y = TILESY3;
						iChangePercent = ModAsPercent (iMod1, 17);
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 17) && (iMod1 == 42))
					{
						dest.x = TILESX9; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if (iTile == 18)
					{
						dest.x = TILESX10; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if (iTile == 19)
					{
						dest.x = TILESX11; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if ((iTile == 20) && ((iMod1 == 0) || (iMod1 == 128)))
					{
						dest.x = TILESX12; dest.y = TILESY3;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 1) || (iMod1 == 129)))
					{
						dest.x = TILESX13; dest.y = TILESY3;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}

					/*** fourth row ***/
					else if ((iTile == 20) && ((iMod1 == 2) || (iMod1 == 130)))
					{
						dest.x = TILESX1; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 3) || (iMod1 == 131)))
					{
						dest.x = TILESX2; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 4) || (iMod1 == 132)))
					{
						dest.x = TILESX3; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 5) || (iMod1 == 133)))
					{
						dest.x = TILESX4; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 6) || (iMod1 == 134)))
					{
						dest.x = TILESX5; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 7) || (iMod1 == 135)))
					{
						dest.x = TILESX6; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 8) || (iMod1 == 136)))
					{
						dest.x = TILESX7; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 9) || (iMod1 == 137)))
					{
						dest.x = TILESX8; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 10) || (iMod1 == 138)))
					{
						dest.x = TILESX9; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if (iTile == 23)
					{
						dest.x = TILESX10; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if (iTile == 24)
					{
						dest.x = TILESX11; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if (iTile == 28)
					{
						dest.x = TILESX12; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if (iTile == 32)
					{
						dest.x = TILESX13; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'b', 's');
					}

					/*** fifth row ***/
					else if (iTile == 33)
					{
						dest.x = TILESX1; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 34) && (iMod2 % 16 >= 0) &&
						(iMod2 % 16 <= 7)) /*** raise drop (reg) ***/
					{
						dest.x = TILESX2; dest.y = TILESY5;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if ((iTile == 34) && (iMod2 % 16 >= 8) &&
						(iMod2 % 16 <= 15)) /*** raise drop (down) ***/
					{
						dest.x = TILESX3; dest.y = TILESY5;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, 'b', ' ');
					}
					else if (iTile == 35)
					{
						dest.x = TILESX4; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if (iTile == 36)
					{
						dest.x = TILESX5; dest.y = TILESY5;
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'b', 's');
					}
					else if (iTile == 44)
					{
						dest.x = TILESX6; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}

					else { iIsCustom = 1; }
				}
				/*** ruins ***/
				if (cCurType == 'r')
				{
					/*** first row ***/
					if (iTile == 0)
					{
						dest.x = TILESX1; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 1) && (iMod1 == 0))
					{
						dest.x = TILESX2; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 1) && (iMod1 == 1))
					{
						dest.x = TILESX3; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 1) && (iMod1 == 2))
					{
						dest.x = TILESX4; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 1) && (iMod1 == 3))
					{
						dest.x = TILESX5; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if (iTile == 2)
					{
						dest.x = TILESX6; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if ((iTile == 3) && (iMod1 == 0))
					{
						dest.x = TILESX7; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 3) && (iMod1 == 1))
					{
						dest.x = TILESX8; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 3) && (iMod1 == 2))
					{
						dest.x = TILESX9; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 4) && (iMod1 == 0))
					{
						dest.x = TILESX10; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 4) && (iMod1 != 0) && (iMod1 != 200))
					{
						dest.x = TILESX11; dest.y = TILESY1;
						iChangePercent = ModAsPercent (iMod1, 4);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 4) && (iMod1 == 200))
					{
						dest.x = TILESX12; dest.y = TILESY1;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 5) && (iMod2 >= 0) && (iMod2 <= 7))
					{
						dest.x = TILESX13; dest.y = TILESY1;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}

					/*** second row ***/
					else if ((iTile == 5) && (iMod2 >= 8) && (iMod2 <= 15))
					{
						dest.x = TILESX1; dest.y = TILESY2;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if ((iTile == 6) && (iMod2 >= 0) && (iMod2 <= 7))
					{
						dest.x = TILESX2; dest.y = TILESY2;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if ((iTile == 6) && (iMod2 >= 8) && (iMod2 <= 15))
					{
						dest.x = TILESX3; dest.y = TILESY2;
						iChangeEvent = iMod1;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if ((iTile == 7) && ((iMod1 == 0) || (iMod1 == 128)))
					{
						dest.x = TILESX4; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 7) && ((iMod1 == 1) || (iMod1 == 129)))
					{
						dest.x = TILESX5; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 7) && ((iMod1 == 2) || (iMod1 == 130)))
					{
						dest.x = TILESX6; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 7) && ((iMod1 == 3) || (iMod1 == 131)))
					{
						dest.x = TILESX7; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if (iTile == 8)
					{
						dest.x = TILESX8; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', ' ');
					}
					else if (iTile == 9)
					{
						dest.x = TILESX9; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', ' ');
					}
					else if ((iTile == 10) && (iMod1 >= 0) && (iMod1 <= 31))
					{
						dest.x = TILESX10; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 32) && (iMod1 <= 63))
					{
						dest.x = TILESX11; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 64) && (iMod1 <= 95))
					{
						dest.x = TILESX12; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 96) && (iMod1 <= 127))
					{
						dest.x = TILESX13; dest.y = TILESY2;
						ExtractFromMod2 (iMod2, 'c', 's');
					}

					/*** third row ***/
					else if ((iTile == 10) && (iMod1 >= 128) && (iMod1 <= 159))
					{
						dest.x = TILESX1; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 160) && (iMod1 <= 191))
					{
						dest.x = TILESX2; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 192) && (iMod1 <= 223))
					{
						dest.x = TILESX3; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 10) && (iMod1 >= 224) && (iMod1 <= 255))
					{
						dest.x = TILESX4; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if (iTile == 11)
					{
						dest.x = TILESX5; dest.y = TILESY3;
						iChangeJumps = ModAsJumps (iMod1);
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 12) && (iMod1 >= 0) && (iMod1 <= 31))
					{
						dest.x = TILESX6; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 12) && (iMod1 >= 32) && (iMod1 <= 63))
					{
						dest.x = TILESX7; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 12) && (iMod1 >= 128) && (iMod1 <= 159))
					{
						dest.x = TILESX8; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 12) && (iMod1 >= 160) && (iMod1 <= 191))
					{
						dest.x = TILESX9; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 13) && (iMod1 == 0))
					{
						dest.x = TILESX10; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 13) && (iMod1 == 32))
					{
						dest.x = TILESX11; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 14) && (iMod1 == 16))
					{
						dest.x = TILESX12; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 14) && (iMod1 == 32))
					{
						dest.x = TILESX13; dest.y = TILESY3;
						ExtractFromMod2 (iMod2, 'c', 's');
					}

					/*** fourth row ***/
					else if ((iTile == 14) && (iMod1 == 64))
					{
						dest.x = TILESX1; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 15) && (iMod1 == 0))
					{
						dest.x = TILESX2; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 15) && (iMod1 == 1))
					{
						dest.x = TILESX3; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 15) && (iMod1 == 2))
					{
						dest.x = TILESX4; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 15) && (iMod1 == 3))
					{
						dest.x = TILESX5; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if (iTile == 16)
					{
						dest.x = TILESX6; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 17) && (iMod1 == 0))
					{
						dest.x = TILESX7; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 17) && (iMod1 != 0) && (iMod1 != 42))
					{
						dest.x = TILESX8; dest.y = TILESY4;
						iChangePercent = ModAsPercent (iMod1, 17);
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if ((iTile == 17) && (iMod1 == 42))
					{
						dest.x = TILESX9; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, ' ', 's');
					}
					else if (iTile == 18)
					{
						dest.x = TILESX10; dest.y = TILESY4;
						ExtractFromMod2 (iMod2, ' ', ' ');
					}
					else if ((iTile == 20) && ((iMod1 == 0) ||
						(iMod1 == 4) || (iMod1 == 8) || (iMod1 == 12)))
					{
						dest.x = TILESX11; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 20) && ((iMod1 == 1) ||
						(iMod1 == 5) || (iMod1 == 9) || (iMod1 == 13)))
					{
						dest.x = TILESX12; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 20) && ((iMod1 == 2) ||
						(iMod1 == 6) || (iMod1 == 10) || (iMod1 == 14)))
					{
						dest.x = TILESX13; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
						ExtractFromMod2 (iMod2, 'c', 's');
					}

					/*** fifth row ***/
					else if (iTile == 21)
					{
						dest.x = TILESX1; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 22) && (iMod1 == 2))
					{
						dest.x = TILESX2; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, 'c', 's');
					}
					else if ((iTile == 22) && (iMod1 != 2))
					{
						dest.x = TILESX3; dest.y = TILESY5;
						ExtractFromMod2 (iMod2, 'c', 's');
					}

					else { iIsCustom = 1; }
				}
				/*** temple ***/
				if (cCurType == 't')
				{
					/*** first row ***/
					if (iTile == 0)
						{ dest.x = TILESX1; dest.y = TILESY1; }
					else if ((iTile == 1) && (iMod1 == 0))
						{ dest.x = TILESX2; dest.y = TILESY1; }
					else if ((iTile == 1) && (iMod1 == 1))
						{ dest.x = TILESX3; dest.y = TILESY1; }
					else if ((iTile == 2) && (iMod1 == 0))
						{ dest.x = TILESX4; dest.y = TILESY1; }
					else if ((iTile == 2) && (iMod1 == 5))
						{ dest.x = TILESX5; dest.y = TILESY1; }
					else if ((iTile == 3) && (iMod1 == 0))
						{ dest.x = TILESX6; dest.y = TILESY1; }
					else if ((iTile == 3) && (iMod1 == 1))
						{ dest.x = TILESX7; dest.y = TILESY1; }
					else if ((iTile == 4) && (iMod1 == 0))
						{ dest.x = TILESX8; dest.y = TILESY1; }
					else if ((iTile == 4) && (iMod1 != 0) && (iMod1 != 200))
					{
						dest.x = TILESX9; dest.y = TILESY1;
						iChangePercent = ModAsPercent (iMod1, 4);
					}
					else if ((iTile == 4) && (iMod1 == 200))
						{ dest.x = TILESX10; dest.y = TILESY1; }
					else if ((iTile == 5) && (iMod2 >= 0) && (iMod2 <= 7))
						{ dest.x = TILESX11; dest.y = TILESY1; iChangeEvent = iMod1; }
					else if ((iTile == 5) && (iMod2 >= 8) && (iMod2 <= 15))
						{ dest.x = TILESX12; dest.y = TILESY1; iChangeEvent = iMod1; }
					else if ((iTile == 6) && (iMod2 >= 0) && (iMod2 <= 7))
						{ dest.x = TILESX13; dest.y = TILESY1; iChangeEvent = iMod1; }

					/*** second row ***/
					else if ((iTile == 6) && (iMod2 >= 8) && (iMod2 <= 15))
						{ dest.x = TILESX1; dest.y = TILESY2; iChangeEvent = iMod1; }
					else if (iTile == 8)
						{ dest.x = TILESX2; dest.y = TILESY2; }
					else if (iTile == 9)
						{ dest.x = TILESX3; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 0) && (iMod1 <= 31))
						{ dest.x = TILESX4; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 32) && (iMod1 <= 63))
						{ dest.x = TILESX5; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 64) && (iMod1 <= 95))
						{ dest.x = TILESX6; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 96) && (iMod1 <= 127))
						{ dest.x = TILESX7; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 128) && (iMod1 <= 159))
						{ dest.x = TILESX8; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 160) && (iMod1 <= 191))
						{ dest.x = TILESX9; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 192) && (iMod1 <= 223))
						{ dest.x = TILESX10; dest.y = TILESY2; }
					else if ((iTile == 10) && (iMod1 >= 224) && (iMod1 <= 255))
						{ dest.x = TILESX11; dest.y = TILESY2; }
					else if (iTile == 11)
					{
						dest.x = TILESX12; dest.y = TILESY2;
						iChangeJumps = ModAsJumps (iMod1);
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if ((iTile == 12) && (iMod1 >= 0) && (iMod1 <= 31))
					{
						dest.x = TILESX13; dest.y = TILESY2;
						iChangeFrame = ModAsFrame (iMod1);
					}

					/*** third row ***/
					else if ((iTile == 12) && (iMod1 >= 32) && (iMod1 <= 63))
					{
						dest.x = TILESX6; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if ((iTile == 12) && (iMod1 >= 128) && (iMod1 <= 159))
					{
						dest.x = TILESX7; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if ((iTile == 12) && (iMod1 >= 160) && (iMod1 <= 191))
					{
						dest.x = TILESX8; dest.y = TILESY3;
						iChangeFrame = ModAsFrame (iMod1);
					}
					else if ((iTile == 13) && (iMod1 == 0))
						{ dest.x = TILESX9; dest.y = TILESY3; }
					else if ((iTile == 13) && (iMod1 == 32))
						{ dest.x = TILESX10; dest.y = TILESY3; }
					else if ((iTile == 14) && (iMod1 == 0))
						{ dest.x = TILESX11; dest.y = TILESY3; }
					else if ((iTile == 14) && (iMod1 == 1))
						{ dest.x = TILESX12; dest.y = TILESY3; }
					else if (iTile == 16)
						{ dest.x = TILESX13; dest.y = TILESY3; }

					/*** fourth row ***/
					else if ((iTile == 17) && (iMod1 == 0))
						{ dest.x = TILESX6; dest.y = TILESY4; }
					else if ((iTile == 17) && (iMod1 != 0) && (iMod1 != 42))
					{
						dest.x = TILESX7; dest.y = TILESY4;
						iChangePercent = ModAsPercent (iMod1, 17);
					}
					else if ((iTile == 17) && (iMod1 == 42))
						{ dest.x = TILESX8; dest.y = TILESY4; }
					else if (iTile == 18)
						{ dest.x = TILESX9; dest.y = TILESY4; }
					else if (iTile == 19)
						{ dest.x = TILESX10; dest.y = TILESY4; }
					else if (iTile == 20)
					{
						dest.x = TILESX11; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
					}
					else if (iTile == 25)
					{
						dest.x = TILESX12; dest.y = TILESY4;
						iChangeWall = ModAsWall (iMod1);
					}
					else if (iTile == 26)
						{ dest.x = TILESX13; dest.y = TILESY4; }

					/*** fifth row ***/
					else if (iTile == 32)
						{ dest.x = TILESX6; dest.y = TILESY5; }

					else { iIsCustom = 1; }
				}
			}

			if (iEditPoP == 3)
			{
				CurTypeBlocks();
				iTileNr = GetTileNrSNES (iB1, iB2, iB3, iB4, iMod1);
				if (iTileNr == 0)
				{
					iIsCustom = 1;

					/*** Set iChangeMarker. ***/
					if ((cCurType == 'g') && ((iB2 == 0x0d) || (iB2 == 0x11) ||
						(iB2 == 0x12) || (iB2 == 0x14) || (iB2 == 0x15) ||
						(iB2 == 0x16) || (iB2 == 0x17)))
						{ iChangeMarker = iB2; }
				} else {
					switch (iTileNr)
					{
						case 1: dest.x = TILESX1; dest.y = TILESY1; break;
						case 2: dest.x = TILESX2; dest.y = TILESY1; break;
						case 3: dest.x = TILESX3; dest.y = TILESY1; break;
						case 4: dest.x = TILESX4; dest.y = TILESY1; break;
						case 5: dest.x = TILESX5; dest.y = TILESY1; break;
						case 6: dest.x = TILESX6; dest.y = TILESY1; break;
						case 7: dest.x = TILESX7; dest.y = TILESY1; break;
						case 8: dest.x = TILESX8; dest.y = TILESY1; break;
						case 9: dest.x = TILESX9; dest.y = TILESY1; break;
						case 10: dest.x = TILESX10; dest.y = TILESY1; break;
						case 11: dest.x = TILESX11; dest.y = TILESY1; break;
						case 12: dest.x = TILESX12; dest.y = TILESY1; break;
						case 13: dest.x = TILESX13; dest.y = TILESY1; break;
						case 14: dest.x = TILESX1; dest.y = TILESY2; break;
						case 15: dest.x = TILESX2; dest.y = TILESY2; break;
						case 16: dest.x = TILESX3; dest.y = TILESY2; break;
						case 17: dest.x = TILESX4; dest.y = TILESY2; break;
						case 18: dest.x = TILESX5; dest.y = TILESY2; break;
						case 19: dest.x = TILESX6; dest.y = TILESY2; break;
						case 20: dest.x = TILESX7; dest.y = TILESY2; break;
						case 21: dest.x = TILESX8; dest.y = TILESY2; break;
						case 22: dest.x = TILESX9; dest.y = TILESY2; break;
						case 23: dest.x = TILESX10; dest.y = TILESY2; break;
						case 24: dest.x = TILESX11; dest.y = TILESY2; break;
						case 25: dest.x = TILESX12; dest.y = TILESY2; break;
						case 26: dest.x = TILESX13; dest.y = TILESY2; break;
						case 27: dest.x = TILESX1; dest.y = TILESY3; break;
						case 28: dest.x = TILESX2; dest.y = TILESY3; break;
						case 29: dest.x = TILESX3; dest.y = TILESY3; break;
						case 30: dest.x = TILESX4; dest.y = TILESY3; break;
						case 31: dest.x = TILESX5; dest.y = TILESY3; break;
						case 32: dest.x = TILESX6; dest.y = TILESY3; break;
						case 33: dest.x = TILESX7; dest.y = TILESY3; break;
						case 34: dest.x = TILESX8; dest.y = TILESY3; break;
						case 35: dest.x = TILESX9; dest.y = TILESY3; break;
						case 36: dest.x = TILESX10; dest.y = TILESY3; break;
						case 37: dest.x = TILESX11; dest.y = TILESY3; break;
						case 38: dest.x = TILESX12; dest.y = TILESY3; break;
						case 39: dest.x = TILESX13; dest.y = TILESY3; break;
						case 40: dest.x = TILESX1; dest.y = TILESY4; break;
						case 41: dest.x = TILESX2; dest.y = TILESY4; break;
						case 42: dest.x = TILESX3; dest.y = TILESY4; break;
						case 43: dest.x = TILESX4; dest.y = TILESY4; break;
						case 44: dest.x = TILESX5; dest.y = TILESY4; break;
						case 45: dest.x = TILESX6; dest.y = TILESY4; break;
						case 46: dest.x = TILESX7; dest.y = TILESY4; break;
						case 47: dest.x = TILESX8; dest.y = TILESY4; break;
						case 48: dest.x = TILESX9; dest.y = TILESY4; break;
					}
				}
				/*** Set iChangeEvent, iChangePercent and iChangeStuck. ***/
				if ((iB3 == 0x04) || (iB3 == 0x05) || (iB3 == 0x23))
					{ iChangeEvent = iMod1; }
				if ((iB3 == 0x06) && (iMod1 != 0) && (iMod1 < 188))
					{ iChangePercent = ModAsPercent (iMod1, 6); }
				if ((iB3 == 0x02) || (iB3 == 0x0c) || (iB3 == 0x0d) ||
					(iB3 == 0x0e) || (iB3 == 0x10) || (iB3 == 0x1e))
					{ iChangeStuck = ModAsStuck (iMod1, iB3); }
			}
			break;
		case 83:
			/*** mouse cursor doesn't need scaling ***/
			dest.x = (iXPos + 10) / iScale;
			dest.y = (iYPos + 10) / iScale;
			break;
		case 84: dest.x = 150; dest.y = 89; break; /*** popup_yn ***/
		case 85: dest.x = 440; dest.y = 317; break; /*** Yes ***/
		case 86: dest.x = 167; dest.y = 317; break; /*** No ***/
		case 87: dest.x = 629; dest.y = 63; break; /*** rooms broken ***/
		case 88: dest.x = 656; dest.y = 387; break; /*** custom ***/
		case 89:
			switch (iChangeForeRand)
			{
				case 0: dest.x = 33; break;
				case 1: dest.x = 48; break;
				case 2: dest.x = 63; break;
				case 3: dest.x = 78; break;
			}
			dest.y = 114;
			break;
		case 90:
			if (iChangeForeMod == 0) { dest.x = 114; dest.y = 114; }
			if (iChangeForeMod == 1) { dest.x = 129; dest.y = 114; }
			break;
		case 91: /*** current custom ***/
			if (iEditPoP != 3)
			{
				dest.x = 76; dest.y = 241;
			} else {
				dest.x = 87; dest.y = 253;
			}
			break;
		case 92: /*** event target ***/
			if (iEditPoP != 3)
			{
				dest.x = 77; dest.y = 146;
			} else {
				dest.x = 88; dest.y = 158;
			}
			break;
		case 93: dest.x = 459; dest.y = 3; break; /*** extras ***/
		case 94: dest.x = 17; dest.y = 17; break; /*** PoP1, problems ***/
		case 95: dest.x = 241; dest.y = 17; break; /*** PoP2 ***/
		case 96: /*** background button ***/
			switch (iEditPoP)
			{
				case 2: dest.x = 254; dest.y = 324; break;
				case 3: dest.x = 504; dest.y = 196; break;
			}
			break;
		case 97: dest.x = 254; dest.y = 388; break; /*** guards ***/
		case 98: /*** guards in room ***/
			switch (iStaticGuards_Amount[iCurRoom - 1])
			{
				case 0: dest.x = 543; break;
				case 1: dest.x = 558; break;
				case 2: dest.x = 573; break;
				case 3: dest.x = 588; break;
				case 4: dest.x = 603; break;
				case 5: dest.x = 618; break;
			}
			dest.y = 191;
			break;
		case 99: /*** incoming sets ***/
			switch (iDynamicGuards_Sets[iCurRoom - 1])
			{
				case 0: dest.x = 566; break;
				case 1: dest.x = 581; break;
				case 2: dest.x = 596; break;
			}
			dest.y = 233;
			break;
		case 100: /*** 1st guard row ***/
			dest.x = 365;
			if (iStaticGuards_1_Locations[iCurRoom - 1][0] < 10) { dest.y = 17; }
			if ((iStaticGuards_1_Locations[iCurRoom - 1][0] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][0] < 20)) { dest.y = 24; }
			if (iStaticGuards_1_Locations[iCurRoom - 1][0] >= 20) { dest.y = 31; }
			break;
		case 101: /*** 2nd guard row ***/
			dest.x = 483;
			if (iStaticGuards_1_Locations[iCurRoom - 1][1] < 10) { dest.y = 17; }
			if ((iStaticGuards_1_Locations[iCurRoom - 1][1] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][1] < 20)) { dest.y = 24; }
			if (iStaticGuards_1_Locations[iCurRoom - 1][1] >= 20) { dest.y = 31; }
			break;
		case 102: /*** 3rd guard row ***/
			dest.x = 601;
			if (iStaticGuards_1_Locations[iCurRoom - 1][2] < 10) { dest.y = 17; }
			if ((iStaticGuards_1_Locations[iCurRoom - 1][2] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][2] < 20)) { dest.y = 24; }
			if (iStaticGuards_1_Locations[iCurRoom - 1][2] >= 20) { dest.y = 31; }
			break;
		case 103: /*** 4th guard row ***/
			dest.x = 365;
			if (iStaticGuards_1_Locations[iCurRoom - 1][3] < 10) { dest.y = 158; }
			if ((iStaticGuards_1_Locations[iCurRoom - 1][3] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][3] < 20)) { dest.y = 165; }
			if (iStaticGuards_1_Locations[iCurRoom - 1][3] >= 20) { dest.y = 172; }
			break;
		case 104: /*** 5th guard row ***/
			dest.x = 483;
			if (iStaticGuards_1_Locations[iCurRoom - 1][4] < 10) { dest.y = 158; }
			if ((iStaticGuards_1_Locations[iCurRoom - 1][4] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][4] < 20)) { dest.y = 165; }
			if (iStaticGuards_1_Locations[iCurRoom - 1][4] >= 20) { dest.y = 172; }
			break;
		case 105: /*** static guard checkboxes ***/
			/*** dest.x ***/
			if (iModifier[2] == 0)
			{
				iGuardSwitch =
					iStaticGuards_4_Directions[iCurRoom - 1][iModifier[1]];
			} else {
				iGuardSwitch = iEditGuardDir;
			}
			switch (iGuardSwitch)
			{
				case 0: /*** right ***/
					switch (iModifier[1])
					{
						case 0: dest.x = G1RIGHT; break;
						case 1: dest.x = G2RIGHT; break;
						case 2: dest.x = G3RIGHT; break;
						case 3: dest.x = G4RIGHT; break;
						case 4: dest.x = G5RIGHT; break;
					}
					break;
				case 255: /*** left ***/
					switch (iModifier[1])
					{
						case 0: dest.x = G1LEFT; break;
						case 1: dest.x = G2LEFT; break;
						case 2: dest.x = G3LEFT; break;
						case 3: dest.x = G4LEFT; break;
						case 4: dest.x = G5LEFT; break;
					}
					break;
			}
			/*** dest.y ***/
			if (iModifier[2] == 0)
			{
				iGuardSwitch = WhichStaticGuard (iModifier[1]);
			} else {
				iGuardSwitch = iEditGuardType;
			}
			switch (iGuardSwitch)
			{
				case 1: dest.y = GTYPE1; break;
				case 2: dest.y = GTYPE2; break;
				case 3: dest.y = GTYPE3; break;
				case 4: dest.y = GTYPE4; break;
				case 5: dest.y = GTYPE5; break;
				case 6: dest.y = GTYPE6; break;
				case 7: dest.y = GTYPE7; break;
				case 8: dest.y = GTYPE8; break;
				case 9: dest.y = GTYPE9; break;
				case 10: dest.y = GTYPE10; break;
				case 11: dest.y = GTYPE11; break;
				case 12: dest.y = GTYPE12; break;
				case 13: dest.y = GTYPE13; break;
				default: dest.y = GTYPE1; break; /*** As a fallback. ***/
			}
			if (iThing == -12) { dest.y--; dest.x--; } /*** Guard selection. ***/
			break;
		case 106: /*** entry 1st ***/
			switch (iDynamicGuards_3_Row[iCurRoom - 1][0])
			{
				case 0:
					/*** top left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][0] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][0] <= 5))
					{
						dest.x = 302; dest.y = 366;
					} else { /*** top right ***/
						dest.x = 319; dest.y = 366;
					}
					break;
				case 1:
					/*** middle left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][0] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][0] <= 5))
					{
						dest.x = 302; dest.y = 373;
					} else { /*** middle right ***/
						dest.x = 319; dest.y = 373;
					}
					break;
				case 2:
					/*** lower left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][0] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][0] <= 5))
					{
						dest.x = 302; dest.y = 380;
					} else { /*** lower right ***/
						dest.x = 319; dest.y = 380;
					}
					break;
			}
			break;
		case 107: /*** entry 2nd ***/
			switch (iDynamicGuards_3_Row[iCurRoom - 1][1])
			{
				case 0:
					/*** top left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][1] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][1] <= 5))
					{
						dest.x = 473; dest.y = 366;
					} else { /*** top right ***/
						dest.x = 490; dest.y = 366;
					}
					break;
				case 1:
					/*** middle left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][1] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][1] <= 5))
					{
						dest.x = 473; dest.y = 373;
					} else { /*** middle right ***/
						dest.x = 490; dest.y = 373;
					}
					break;
				case 2:
					/*** lower left ***/
					if ((iDynamicGuards_4_Column[iCurRoom - 1][1] >= 0) &&
						(iDynamicGuards_4_Column[iCurRoom - 1][1] <= 5))
					{
						dest.x = 473; dest.y = 380;
					} else { /*** lower right ***/
						dest.x = 490; dest.y = 380;
					}
					break;
			}
			break;
		case 108: /*** max alive ***/
			if (iModifier[1] == 0)
			{
				switch (iDynamicGuards_2_MaxTog[iCurRoom - 1][0])
				{
					case 1: dest.x = 438; dest.y = 311; break; /*** 1 ***/
					case 2: dest.x = 453; dest.y = 311; break; /*** 2 ***/
					default: dest.x = -100; dest.y = -100; break; /*** hide ***/
				}
			}
			if (iModifier[1] == 1)
			{
				switch (iDynamicGuards_2_MaxTog[iCurRoom - 1][1])
				{
					case 1: dest.x = 609; dest.y = 311; break; /*** 1 ***/
					case 2: dest.x = 624; dest.y = 311; break; /*** 2 ***/
					default: dest.x = -100; dest.y = -100; break; /*** hide ***/
				}
			}
			break;
		case 109: /*** can jump ***/
			if (iModifier[1] == 0)
			{
				switch (iDynamicGuards_7_CanJump[iCurRoom - 1][0])
				{
					case 255: dest.x = 438; dest.y = 331; break; /*** no ***/
					case 1: dest.x = 453; dest.y = 331; break; /*** yes ***/
					default: dest.x = -100; dest.y = -100; break; /*** hide ***/
				}
			}
			if (iModifier[1] == 1)
			{
				switch (iDynamicGuards_7_CanJump[iCurRoom - 1][1])
				{
					case 255: dest.x = 609; dest.y = 331; break; /*** no ***/
					case 1: dest.x = 624; dest.y = 331; break; /*** yes ***/
					default: dest.x = -100; dest.y = -100; break; /*** hide ***/
				}
			}
			break;
		case 110: /*** prince row ***/
			if (iModifier[1] == 0)
			{
				switch (iDynamicGuards_8_PrinceRow[iCurRoom - 1][0])
				{
					case 0: dest.x = 341; dest.y = 310; break;
					case 1: dest.x = 341; dest.y = 317; break;
					case 2: dest.x = 341; dest.y = 324; break;
				}
			}
			if (iModifier[1] == 1)
			{
				switch (iDynamicGuards_8_PrinceRow[iCurRoom - 1][1])
				{
					case 0: dest.x = 512; dest.y = 310; break;
					case 1: dest.x = 512; dest.y = 317; break;
					case 2: dest.x = 512; dest.y = 324; break;
				}
			}
			break;
		case 111: /*** static left ***/
			switch (iModifier[1])
			{
				case 0: dest.x = 14; dest.y = 14; break;
				case 1: dest.x = 56; dest.y = 14; break;
				case 2: dest.x = 98; dest.y = 14; break;
				case 3: dest.x = 140; dest.y = 14; break;
				case 4: dest.x = 182; dest.y = 14; break;
			}
			break;
		case 112: /*** static right ***/
			switch (iModifier[1])
			{
				case 0: dest.x = 287; dest.y = 14; break;
				case 1: dest.x = 405; dest.y = 14; break;
				case 2: dest.x = 523; dest.y = 14; break;
				case 3: dest.x = 287; dest.y = 155; break;
				case 4: dest.x = 405; dest.y = 155; break;
			}
			break;
		case 113: dest.x = 299; dest.y = 307; break; /*** 1st dynamic ***/
		case 114: dest.x = 470; dest.y = 307; break; /*** 2nd dynamic ***/
		case 115: /*** X-coordinate tooltip ***/
			switch (iModifier[1])
			{
				case 0: dest.x = 288; dest.y = 15; break;
				case 1: dest.x = 406; dest.y = 15; break;
				case 2: dest.x = 524; dest.y = 15; break;
				case 3: dest.x = 288; dest.y = 156; break;
				case 4: dest.x = 406; dest.y = 156; break;
			}
			break;
		case 116: /*** incoming arrow ***/
			if ((iDynamicGuards_4_Column[iCurRoom - 1][iModifier[1]] >= 0) &&
				(iDynamicGuards_4_Column[iCurRoom - 1][iModifier[1]] <= 5))
			{
				dest.x = 25;
			} else {
				dest.x = 654;
			}
			switch (iDynamicGuards_3_Row[iCurRoom - 1][iModifier[1]])
			{
				case 0: dest.y = 100; break;
				case 1: dest.y = 226; break;
				case 2: dest.y = 352; break;
			}
			break;
		case 117: /*** static guard location ***/
			dest.x = 25 + ((IntsToHexToSSLittleEndian (iStaticGuards_3_Offsets2
				[iCurRoom - 1][iModifier[1]], iStaticGuards_2_Offsets1
				[iCurRoom - 1][iModifier[1]]) - 144) * 2);
			switch (WhichStaticGuard (iModifier[1]))
			{
				case 1: case 2: case 3: iBaseY = 76; break; /*** guards ***/
				case 4: iBaseY = 121; break; /*** s. wakes up; wobbly if jump ***/
				case 5: iBaseY = 87; break; /*** skeleton already awake ***/
				case 6: iBaseY = 147; break; /*** skeleton only sleeps ***/
				case 7: iBaseY = 121; break; /*** s. wakes up; NOT wobbly if jump ***/
				case 8: iBaseY = 93; break; /*** head, long hair ***/
				case 9: iBaseY = 95; break; /*** head, short hair ***/
				case 10: iBaseY = 147; break; /*** snake ***/
				case 11: iBaseY = 75; break; /*** birdman ***/
				case 12: iBaseY = 152; break; /*** sword ***/
				case 13: iBaseY = 78; break; /*** fake prince ***/
				default: iBaseY = 76; break; /*** As a fallback. ***/
			}
			if (iStaticGuards_1_Locations[iCurRoom - 1][iModifier[1]] < 10)
			{
				dest.y = iBaseY;
			}
			if ((iStaticGuards_1_Locations[iCurRoom - 1][iModifier[1]] >= 10) &&
				(iStaticGuards_1_Locations[iCurRoom - 1][iModifier[1]] < 20))
			{
				dest.y = iBaseY + 126;
			}
			if (iStaticGuards_1_Locations[iCurRoom - 1][iModifier[1]] >= 20)
			{
				dest.y = iBaseY + 126 + 126;
			}
			break;
		case 118: /*** foreground elements ***/
			iArLX = 38; iArLY = 218;
			iArRX = 602; iArRY = 218;
			iArUX = 325; iArUY = 63;
			iArDX = 325; iArDY = 365;
			if (iEditPoP == 3) { iArLX+=81; iArRX-=81; } /*** Curtain width. ***/
			switch (iModifier[0])
			{
				case 1: dest.x = 264; dest.y = 248; break; /*** horse ***/
				case 2: dest.x = iArLX; dest.y = iArLY; break; /*** level 6 arrow ***/
				case 3: dest.x = 30; dest.y = 409; break; /*** invisible ***/
				case 6: dest.x = 111; dest.y = 409; break; /*** gates ***/
				case 7: dest.x = iArLX; dest.y = iArLY; break; /*** exit left ***/
				case 8: dest.x = iArRX; dest.y = iArRY; break; /*** exit right ***/
				case 9: dest.x = iArUX; dest.y = iArUY; break; /*** exit up ***/
				case 10: dest.x = iArDX; dest.y = iArDY; break; /*** exit down ***/
				case 11: dest.x = iArLX; dest.y = iArLY; break; /*** checkp left ***/
				case 12: dest.x = iArRX; dest.y = iArRY; break; /*** checkp right ***/
				case 13: dest.x = iArUX; dest.y = iArUY; break; /*** checkp up ***/
				case 14: dest.x = iArDX; dest.y = iArDY; break; /*** checkp down ***/
			}
			break;
		case 119: dest.x = 637; dest.y = 305; break; /*** music ***/
		case 120: /*** music checkboxes ***/
			if ((iModifier[1] >= 0) && (iModifier[1] <= 9)) { dest.y = 130; }
			if ((iModifier[1] >= 10) && (iModifier[1] <= 19)) { dest.y = 145; }
			if ((iModifier[1] >= 20) && (iModifier[1] <= 29)) { dest.y = 160; }
			switch (iModifier[1])
			{
				case 0: case 10: case 20: dest.x = 253 + (0 * 15); break;
				case 1: case 11: case 21: dest.x = 253 + (1 * 15); break;
				case 2: case 12: case 22: dest.x = 253 + (2 * 15); break;
				case 3: case 13: case 23: dest.x = 253 + (3 * 15); break;
				case 4: case 14: case 24: dest.x = 253 + (4 * 15); break;
				case 5: case 15: case 25: dest.x = 253 + (5 * 15); break;
				case 6: case 16: case 26: dest.x = 253 + (6 * 15); break;
				case 7: case 17: case 27: dest.x = 253 + (7 * 15); break;
				case 8: case 18: case 28: dest.x = 253 + (8 * 15); break;
				case 9: case 19: case 29: dest.x = 253 + (9 * 15); break;
			}
			if (iThing == -12) { dest.y--; dest.x--; } /*** Note selection. ***/
			break;
		case 121: /*** edit/end for left/right ***/
			switch (iModifier[1])
			{
				case 1: dest.x = 251; break;
				case 2: dest.x = 346; break;
				case 3: dest.x = 476; break;
				case 4: dest.x = 571; break;
			}
			dest.y = 254;
			break;
		case 122: /*** music buttons ***/
			switch (iModifier[0])
			{
				case 1: case 2: dest.x = 32; dest.y = 115; break;
				case 3: case 4: dest.x = 32; dest.y = 145; break;
				case 5: case 6: dest.x = 104; dest.y = 115; break;
				case 7: case 8: dest.x = 104; dest.y = 145; break;
				case 9: case 10: dest.x = 481; dest.y = 115; break;
				case 11: case 12: dest.x = 481; dest.y = 145; break;
				case 13: case 14: dest.x = 553; dest.y = 115; break;
				case 15: case 16: dest.x = 553; dest.y = 145; break;
			}
			break;
		case 123: /*** PoP2 prince ***/
			dest.x = TILESX8; dest.y = TILESY7; break;
		case 124: /*** guard warning static ***/
			dest.x = 18; dest.y = 47; break;
		case 125: /*** jumps ***/
			switch (iChangeJumps)
			{
				case 1: dest.x = 588; break;
				case 2: dest.x = 603; break;
				case 3: dest.x = 618; break;
				case 4: dest.x = 633; break;
			}
			dest.y = 265;
			break;
		case 126: /*** guard warning dynamic ***/
			dest.x = 297; dest.y = 305; break;
		case 127: /*** broken room links 25-32 ***/
			dest.x = 34; dest.y = 282; break;
		case 128: /*** room links 25-32 ***/
			dest.x = 175; dest.y = 290; break;
		case 129: /*** sel back ***/
			if (cCurType == 'r')
			{
				dest.x = 601; dest.y = 159; /*** Default to 0. ***/
				switch (iModifier[2])
				{
					case 1:
						switch (iModifier[3])
						{
							case 0: dest.x = 23; dest.y = 86; break;
							case 1: dest.x = 55; dest.y = 86; break;
							case 4: dest.x = 23; dest.y = 23; break;
							case 5: dest.x = 55; dest.y = 23; break;
						}
						break;
					case 2:
						switch (iModifier[3])
						{
							case 0: dest.x = 97; dest.y = 86; break;
							case 1: dest.x = 129; dest.y = 86; break;
							case 4: dest.x = 97; dest.y = 23; break;
							case 5: dest.x = 129; dest.y = 23; break;
						}
						break;
					case 3:
						switch (iModifier[3])
						{
							case 0: dest.x = 171; dest.y = 86; break;
							case 1: dest.x = 203; dest.y = 86; break;
							case 4: dest.x = 171; dest.y = 23; break;
							case 5: dest.x = 203; dest.y = 23; break;
						}
						break;
					case 4:
						switch (iModifier[3])
						{
							case 0: dest.x = 245; dest.y = 86; break;
							case 1: dest.x = 277; dest.y = 86; break;
							case 4: dest.x = 245; dest.y = 23; break;
							case 5: dest.x = 277; dest.y = 23; break;
						}
						break;
					case 5:
						switch (iModifier[3])
						{
							case 0: dest.x = 319; dest.y = 86; break;
							case 1: dest.x = 351; dest.y = 86; break;
							case 2: dest.x = 383; dest.y = 86; break;
							case 3: dest.x = 415; dest.y = 86; break;
							case 4: dest.x = 319; dest.y = 23; break;
							case 5: dest.x = 351; dest.y = 23; break;
							case 6: dest.x = 383; dest.y = 23; break;
							case 7: dest.x = 415; dest.y = 23; break;
						}
						break;
					case 6:
						switch (iModifier[3])
						{
							case 0: dest.x = 467; dest.y = 149; break;
							case 1: dest.x = 499; dest.y = 149; break;
							case 4: dest.x = 467; dest.y = 86; break;
							case 5: dest.x = 499; dest.y = 86; break;
							case 8: dest.x = 467; dest.y = 23; break;
							case 9: dest.x = 499; dest.y = 23; break;
						}
						break;
					case 7:
						switch (iModifier[3])
						{
							case 0: dest.x = 23; dest.y = 222; break;
							case 1: dest.x = 55; dest.y = 222; break;
							case 4: dest.x = 23; dest.y = 159; break;
							case 5: dest.x = 55; dest.y = 159; break;
						}
						break;
					case 8:
						switch (iModifier[3])
						{
							case 0: dest.x = 97; dest.y = 222; break;
							case 1: dest.x = 129; dest.y = 222; break;
							case 2: dest.x = 161; dest.y = 222; break;
							case 3: dest.x = 193; dest.y = 222; break;
							case 4: dest.x = 97; dest.y = 159; break;
							case 5: dest.x = 129; dest.y = 159; break;
							case 6: dest.x = 161; dest.y = 159; break;
							case 7: dest.x = 193; dest.y = 159; break;
						}
						break;
					case 9:
						switch (iModifier[3])
						{
							case 0: dest.x = 235; dest.y = 159; break;
							case 1: dest.x = 267; dest.y = 159; break;
						}
						break;
					case 10:
						switch (iModifier[3])
						{
							case 0: dest.x = 309; dest.y = 159; break;
							case 1: dest.x = 341; dest.y = 159; break;
						}
						break;
					case 12: dest.x = 383; dest.y = 159; break;
					case 13: dest.x = 425; dest.y = 159; break;
					case 14: dest.x = 23; dest.y = 295; break;
					case 15: dest.x = 65; dest.y = 295; break;
					case 16: dest.x = 107; dest.y = 295; break;
					case 17: dest.x = 149; dest.y = 295; break;
					case 18: dest.x = 191; dest.y = 295; break;
					case 19: dest.x = 233; dest.y = 295; break;
					case 20: dest.x = 275; dest.y = 295; break;
					case 22: dest.x = 23; dest.y = 368; break;
					case 23: dest.x = 65; dest.y = 368; break;
					case 24: dest.x = 107; dest.y = 368; break;
					case 25: dest.x = 149; dest.y = 368; break;
					case 26: dest.x = 191; dest.y = 368; break;
					case 30: dest.x = 233; dest.y = 368; break;
					case 31: dest.x = 275; dest.y = 368; break;
				}
			}
			if (cCurType == 't')
			{
				dest.x = 344; dest.y = 373; /*** Default to 0. ***/
				switch (iModifier[2])
				{
					case 1: dest.x = 18; dest.y = 18; break;
					case 2: dest.x = 60; dest.y = 18; break;
					case 3: dest.x = 102; dest.y = 18; break;
					case 4: dest.x = 144; dest.y = 18; break;
					case 5: dest.x = 186; dest.y = 18; break;
					case 6: dest.x = 228; dest.y = 18; break;
					case 7: dest.x = 270; dest.y = 18; break;
					case 8: dest.x = 60; dest.y = 91; break;
					case 9: dest.x = 144; dest.y = 91; break;
					case 10: dest.x = 102; dest.y = 91; break;
					case 11: dest.x = 18; dest.y = 91; break;
					case 12: dest.x = 186; dest.y = 91; break;
					case 13: dest.x = 228; dest.y = 91; break;
					case 14: dest.x = 270; dest.y = 91; break;
					case 15: dest.x = 186; dest.y = 164; break;
					case 16: dest.x = 228; dest.y = 164; break;
					case 17: dest.x = 270; dest.y = 164; break;
					case 18:
						switch (iModifier[3])
						{
							case 0: dest.x = 312; dest.y = 18; break;
							case 1: dest.x = 344; dest.y = 18; break;
						}
						break;
					case 19:
						switch (iModifier[3])
						{
							case 0: dest.x = 18; dest.y = 227; break;
							case 1: dest.x = 50; dest.y = 227; break;
							case 4: dest.x = 18; dest.y = 164; break;
							case 5: dest.x = 50; dest.y = 164; break;
						}
						break;
					case 20:
						switch (iModifier[3])
						{
							case 0: dest.x = 102; dest.y = 227; break;
							case 1: dest.x = 134; dest.y = 227; break;
							case 4: dest.x = 102; dest.y = 164; break;
							case 5: dest.x = 134; dest.y = 164; break;
						}
						break;
					case 21: dest.x = 102; dest.y = 373; break;
					case 22: dest.x = 18; dest.y = 300; break;
					case 23: dest.x = 60; dest.y = 300; break;
					case 24: dest.x = 102; dest.y = 300; break;
					case 25:
						switch (iModifier[3])
						{
							case 0: dest.x = 144; dest.y = 300; break;
							case 1: dest.x = 176; dest.y = 300; break;
						}
						break;
					case 26:
						switch (iModifier[3])
						{
							case 0: dest.x = 218; dest.y = 300; break;
							case 1: dest.x = 250; dest.y = 300; break;
						}
						break;
					case 27: dest.x = 292; dest.y = 300; break;
					case 28: dest.x = 18; dest.y = 373; break;
					case 29: dest.x = 60; dest.y = 373; break;
					case 30: dest.x = 144; dest.y = 373; break;
					case 31: dest.x = 186; dest.y = 373; break;
				}
			}
			if (iEditPoP == 3)
			{
				iBackValue = iModifier[1];

				iBackColumn = iBackValue % 20;
				if (iBackColumn == 0) { iBackColumn = 20; }
				iBackRow = (int)((iBackValue - 1) / 20) + 1;

				dest.x = 9 + ((iBackColumn - 1) * 29);
				dest.y = 9 + ((iBackRow - 1) * 69);
			}
			break;
		case 130: /*** alt wall ***/
			dest.y = 287;
			if (cCurType == 'c')
			{
				switch (iChangeWall)
				{
					case 1: dest.x = 618; break;
					case 2: dest.x = 633; break;
				}
			}
			if (cCurType == 'r')
			{
				switch (iChangeWall)
				{
					case 1: dest.x = 588; break;
					case 2: dest.x = 603; break;
					case 3: dest.x = 618; break;
					case 4: dest.x = 633; break;
				}
			}
			if (cCurType == 't')
			{
				switch (iChangeWall)
				{
					case 1: dest.x = 603; break;
					case 2: dest.x = 618; break;
					case 3: dest.x = 633; break;
				}
			}
			break;
		case 131: /*** stal ***/
			switch (iChangeStal)
			{
				case 0: dest.x = 231; dest.y = 393; break;
				case 1: dest.x = 11; dest.y = 347; break;
				case 2: dest.x = 67; dest.y = 347; break;
				case 3: dest.x = 117; dest.y = 347; break;
				case 4: dest.x = 185; dest.y = 347; break;
				case 5: dest.x = 11; dest.y = 393; break;
				case 6: dest.x = 95; dest.y = 393; break;
				case 7: dest.x = 145; dest.y = 393; break;
				default: printf ("[ WARN ] iChangeStal is: %i\n", iChangeStal); break;
			}
			break;
		case 132: /*** bot ***/
			switch (iChangeBot)
			{
				case 0: dest.x = 411; dest.y = 283; break;
				case 1: dest.x = 411; dest.y = 304; break;
				case 2: dest.x = 411; dest.y = 325; break;
				case 3: dest.x = 411; dest.y = 346; break;
				case 4: dest.x = 411; dest.y = 367; break;
				case 5: dest.x = 411; dest.y = 388; break;
				case 6: dest.x = 411; dest.y = 409; break;
				case 7: dest.x = 411; dest.y = 430; break;
				default: printf ("[ WARN ] iChangeBot is: %i\n", iChangeBot); break;
			}
			break;
		case 133: /*** sym ***/
			switch (iChangeSym)
			{
				case 0: dest.x = 411; dest.y = 429; break;
				case 1: dest.x = 411; dest.y = 304; break;
				case 2: dest.x = 411; dest.y = 362; break;
				case 3: dest.x = 411; dest.y = 404; break;
				default:
					printf ("[ WARN ] iChangeSym is: %i\n", iChangeSym);
					break;
			}
			break;
		case 134: /*** crk ***/
			switch (iChangeCrk)
			{
				case 0: dest.x = 231; dest.y = 415; break;
				case 1: dest.x = 11; dest.y = 352; break;
				case 3: dest.x = 115; dest.y = 331; break;
				case 4: dest.x = 161; dest.y = 331; break;
				case 5: dest.x = 202; dest.y = 331; break;
				case 6: dest.x = 11; dest.y = 380; break;
				case 7: dest.x = 85; dest.y = 380; break;
				case 8: dest.x = 85; dest.y = 415; break;
				case 9: dest.x = 11; dest.y = 415; break;
				case 10: dest.x = 143; dest.y = 415; break;
				case 11: dest.x = 143; dest.y = 380; break;
				case 12: dest.x = 231; dest.y = 380; break;
				default:
					printf ("[ WARN ] iChangeCrk is: %i\n", iChangeCrk);
					break;
			}
			break;
		case 135: dest.x = 327; dest.y = 183; break; /*** hourglass sprite ***/
		case 136: dest.x = 345; dest.y = 215; break; /*** sand sprite ***/
		case 137: dest.x = 4; dest.y = 4; break; /*** distort, tooltip ***/
		case 138: dest.x = 188; dest.y = 394; break; /*** controller ***/
		case 139: /*** Allow triggering of any tile. ***/
			if (iEXETriggering == 0)
			{
				dest.x = 261;
			} else {
				dest.x = 276;
			}
			dest.y = 129;
			break;
		case 140: /*** Prince has sword. ***/
			switch (iEXESword)
			{
				case -1: dest.x = 253; break;
				case 0: dest.x = 268; break;
				case 1: dest.x = 283; break;
			}
			switch (iEditPoP)
			{
				case 1: dest.y = 153; break;
				case 3: dest.y = 247; break;
			}
			break;
		case 141: /*** (environments) ***/
			/*** D ***/
			if ((iModifier[1] == 0) && (iModifier[2] >= 1) && (iModifier[2] <= 8))
				{ dest.x = 35; }
			if ((iModifier[1] == 0) && ((iModifier[2] >= 9) || (iModifier[2] == 0)))
				{ dest.x = 208; }
			/*** P ***/
			if ((iModifier[1] == 1) && (iModifier[2] >= 1) && (iModifier[2] <= 8))
				{ dest.x = 50; }
			if ((iModifier[1] == 1) && ((iModifier[2] >= 9) || (iModifier[2] == 0)))
				{ dest.x = 223; }
			/*** dest.y ***/
			switch (iModifier[2])
			{
				case 1: case 9: dest.y = 241 + (0 * 17); break;
				case 2: case 10: dest.y = 241 + (1 * 17); break;
				case 3: case 11: dest.y = 241 + (2 * 17); break;
				case 4: case 12: dest.y = 241 + (3 * 17); break;
				case 5: case 13: dest.y = 241 + (4 * 17); break;
				case 6: case 14: dest.y = 241 + (5 * 17); break;
				case 7: case 15: dest.y = 241 + (6 * 17); break;
				case 8: case 0: dest.y = 241 + (7 * 17); break;
			}
			break;
		case 142: /*** (enemy resources) ***/
			/*** dest.x ***/
			if ((iModifier[2] >= 1) && (iModifier[2] <= 8))
			{
				switch (iModifier[1])
				{
					case 0: dest.x = 69 + (0 * 15); break; /* guard (G) */
					case 1: dest.x = 69 + (1 * 15); break; /* fat (F) */
					case 2: dest.x = 69 + (2 * 15); break; /* skeleton (S) */
					case 3: dest.x = 69 + (3 * 15); break; /* jaffar (J) */
					case 4: dest.x = 69 + (4 * 15); break; /* mirror (M) */
					case 65535: dest.x = 69 + (5 * 15); break; /* nothing (N) */
				}
			} else {
				switch (iModifier[1])
				{
					case 0: dest.x = 242 + (0 * 15); break; /* guard (G) */
					case 1: dest.x = 242 + (1 * 15); break; /* fat (F) */
					case 2: dest.x = 242 + (2 * 15); break; /* skeleton (S) */
					case 3: dest.x = 242 + (3 * 15); break; /* jaffar (J) */
					case 4: dest.x = 242 + (4 * 15); break; /* mirror (M) */
					case 65535: dest.x = 242 + (5 * 15); break; /* nothing (N) */
				}
			}
			/*** dest.y ***/
			switch (iModifier[2])
			{
				case 1: case 9: dest.y = 241 + (0 * 17); break;
				case 2: case 10: dest.y = 241 + (1 * 17); break;
				case 3: case 11: dest.y = 241 + (2 * 17); break;
				case 4: case 12: dest.y = 241 + (3 * 17); break;
				case 5: case 13: dest.y = 241 + (4 * 17); break;
				case 6: case 14: dest.y = 241 + (5 * 17); break;
				case 7: case 15: dest.y = 241 + (6 * 17); break;
				case 8: case 0: dest.y = 241 + (7 * 17); break;
			}
			break;
		case 143: dest.x = 68; dest.y = 240; break; /*** packed ***/
		case 144: dest.x = 465; dest.y = 17; break; /*** PoP1 for SNES ***/
		case 145: dest.x = 25; dest.y = 50; break; /*** curtain left ***/
		case 146: dest.x = 586; dest.y = 50; break; /*** curtain right ***/
		case 147: dest.x = 14; dest.y = 14; break; /*** custom snes ***/

		/*** PoP1 for SNES guards ***/
		case 148: dest.x = 277; dest.y = 322; break; /*** dead pink (l) ***/
		case 149: dest.x = 252; dest.y = 322; break; /*** dead pink (r) ***/
		case 150: dest.x = 77; dest.y = 258; break; /*** silver s (l) ***/
		case 151: dest.x = 52; dest.y = 258; break; /*** silver s (r) ***/
		case 152: dest.x = 127; dest.y = 258; break; /*** bronze s (l) ***/
		case 153: dest.x = 102; dest.y = 258; break; /*** bronze s (r) ***/
		case 154: dest.x = 177; dest.y = 258; break; /*** golden s (l) ***/
		case 155: dest.x = 152; dest.y = 258; break; /*** golden s (r) ***/
		case 156: dest.x = 227; dest.y = 258; break; /*** female (l) ***/
		case 157: dest.x = 202; dest.y = 258; break; /*** female (r) ***/
		case 158: dest.x = 277; dest.y = 258; break; /*** fat (l) ***/
		case 159: dest.x = 252; dest.y = 258; break; /*** fat (r) ***/
		case 160: dest.x = 327; dest.y = 258; break; /*** shadow (l) ***/
		case 161: dest.x = 302; dest.y = 258; break; /*** shadow (r) ***/
		case 162: dest.x = 377; dest.y = 258; break; /*** green g (l) ***/
		case 163: dest.x = 352; dest.y = 258; break; /*** green g (r) ***/
		case 164: dest.x = 427; dest.y = 258; break; /*** greenish (l) ***/
		case 165: dest.x = 402; dest.y = 258; break; /*** greenish (r) ***/
		case 166: dest.x = 477; dest.y = 258; break; /*** blue g (l) ***/
		case 167: dest.x = 452; dest.y = 258; break; /*** blue g (r) ***/
		case 168: dest.x = 527; dest.y = 258; break; /*** red g (l) ***/
		case 169: dest.x = 502; dest.y = 258; break; /*** red g (r) ***/
		case 170: dest.x = 577; dest.y = 258; break; /*** purple g (l) ***/
		case 171: dest.x = 552; dest.y = 258; break; /*** purple g (r) ***/
		case 172: dest.x = 627; dest.y = 258; break; /*** blue faced (l) ***/
		case 173: dest.x = 602; dest.y = 258; break; /*** blue faced (r) ***/
		case 174: dest.x = 27; dest.y = 322; break; /*** red k (l) ***/
		case 175: dest.x = 2; dest.y = 322; break; /*** red k (r) ***/
		case 176: dest.x = 77; dest.y = 322; break; /*** blue k (l) ***/
		case 177: dest.x = 52; dest.y = 322; break; /*** blue k (r) ***/
		case 178: dest.x = 127; dest.y = 322; break; /*** sinbad k (l) ***/
		case 179: dest.x = 102; dest.y = 322; break; /*** sinbad k (r) ***/
		case 180: dest.x = 177; dest.y = 322; break; /*** jaffar (l) ***/
		case 181: dest.x = 152; dest.y = 322; break; /*** jaffar (r) ***/
		case 182: dest.x = 227; dest.y = 322; break; /*** dead white (l) ***/
		case 183: dest.x = 202; dest.y = 322; break; /*** dead white (r) ***/
		case 184: dest.x = 4; dest.y = 4; break; /*** PoP1 for SNES back tiles ***/
		case 185: dest.x = 69; dest.y = 138; break; /*** event unused ***/
		case 186: dest.x = 242; dest.y = 198; break; /*** outdoor (no ceiling) ***/
		case 187: dest.x = 195; dest.y = 76; break; /*** exe, SNES music ***/
		case 188:
			switch (iChangeStuck)
			{
				case 0: dest.x = 163; break; /*** no ***/
				case 1: dest.x = 206; break; /*** harmful ***/
				case 2: dest.x = 278; break; /*** harmless ***/
			}
			dest.y = 427;
			break;
		case 189:
			switch (iChangeBlock[4])
			{
				case 0: dest.x = 183; break; /*** S ***/
				case 1: dest.x = 198; break; /*** F ***/
				case 2: dest.x = 213; break; /*** W ***/
				case 3: dest.x = 213; break; /*** Floor + wall = wall. ***/
			}
			dest.y = 114;
			break;
		case 190: dest.x = 454; dest.y = 196; break; /*** templates button ***/
		case 191: dest.x = 9; dest.y = 9; break; /*** PoP1 for SNES templates ***/
		case 192: /*** highlighted template ***/
			switch (iTempHi)
			{
				case 1: dest.x = 5; dest.y = 5; break;
				case 2: dest.x = 219; dest.y = 5; break;
				case 3: dest.x = 433; dest.y = 5; break;
				case 4: dest.x = 5; dest.y = 177; break;
				case 5: dest.x = 219; dest.y = 177; break;
				case 6: dest.x = 433; dest.y = 177; break;
			}
			break;
		case 193: dest.x = 195; dest.y = 147; break; /*** exe, SNES haze ***/
		case 194: dest.x = TILESX1; dest.y = TILESY5; break; /*** SNES prince ***/
		case 195: dest.x = 219; dest.y = 270; break; /*** JP ***/
		case 196: /*** Intro (level 22) is playable. ***/
			switch (iEXEDemoPlayableS)
			{
				case 0: dest.x = 261; break;
				case 1: dest.x = 276; break;
			}
			dest.y = 271;
			break;
		case 197: dest.x = 4; dest.y = 388; break; /*** no teleport marker ***/
		case 198: /*** teleport marker ***/
			switch (iChangeMarker)
			{
				case 0x0d: dest.x = 14; break;
				case 0x11: dest.x = 33; break;
				case 0x12: dest.x = 52; break;
				case 0x14: dest.x = 71; break;
				case 0x15: dest.x = 90; break;
				case 0x16: dest.x = 109; break;
				case 0x17: dest.x = 128; break;
			}
			dest.y = 427;
			break;
		case 199: /*** Warp potion (face). ***/
			switch (iEXEWarpFace)
			{
				case 0x00: dest.x = 126; break; /*** right ***/
				case 0xff: dest.x = 111; break; /*** left ***/
			}
			dest.y = 336;
			break;
		case 200: /*** Warp potion (col, row). ***/
			dest.x = 182 + (iEXEWarpCol * 15);
			dest.y = 330 + (iEXEWarpRow * 15);
			break;
		case 201: dest.x = 304; dest.y = 324; break; /*** kid colors button ***/
		case 202: dest.x = 42; dest.y = 164; break; /*** colors (black, white) ***/
		case 203: dest.x = 286; dest.y = 129; break; /*** Preview on black. ***/
		case 204: dest.x = 355; dest.y = 389; break; /*** skill tooltip ***/
		case 205: dest.x = 361; dest.y = 76; break; /*** unchangeable skel. ***/
		case 206: /*** guard tab ***/
			switch (iEXETab)
			{
				case 1: dest.x = 361; dest.y = 302; break; /*** strike prob. ***/
				case 2: dest.x = 463; dest.y = 302; break; /*** re-strike prob. ***/
				case 3: dest.x = 565; dest.y = 302; break; /*** block prob. ***/
				case 4: dest.x = 361; dest.y = 329; break; /*** imp. block prob. ***/
				case 5: dest.x = 463; dest.y = 329; break; /*** advance prob. ***/
				case 6: dest.x = 565; dest.y = 329; break; /*** refractory timer ***/
				case 7: dest.x = 361; dest.y = 356; break; /*** hit points ***/
				case 8: dest.x = 463; dest.y = 356; break; /*** palette ***/
				case 9: dest.x = 565; dest.y = 356; break; /*** sprite ***/
			}
			break;
		case 207: /*** animated back ***/
			iBackAnim = iModifier[1];

			iBackColumn = iBackAnim % 20;
			if (iBackColumn == 0) { iBackColumn = 20; }
			iBackRow = (int)((iBackAnim - 1) / 20) + 1;

			dest.x = 6 + ((iBackColumn - 1) * 29);
			dest.y = 6 + ((iBackRow - 1) * 69);
			break;
		case 208: dest.x = 4; dest.y = 260; break; /*** red prince ***/
		case 209: dest.x = 23; dest.y = 411; break; /*** status bar bulb ***/
		case 210: /*** guard sprites ***/
			dest.x = iModifier[1];
			dest.y = iModifier[2];
			break;
		case 211: /*** kid colors (r, l, f) ***/
			switch (iModifier[2])
			{
				/*** top row ***/
				case 0: dest.x = 6 + (36 * 1); dest.y = 90 + (74 * 1); break;
				case 1: dest.x = 6 + (36 * 2); dest.y = 90 + (74 * 1); break;
				case 2: dest.x = 6 + (36 * 3); dest.y = 90 + (74 * 1); break;
				case 3: dest.x = 6 + (36 * 4); dest.y = 90 + (74 * 1); break;
				case 8: dest.x = 6 + (36 * 5); dest.y = 90 + (74 * 1); break;
				case 9: dest.x = 6 + (36 * 6); dest.y = 90 + (74 * 1); break;
				case 10: dest.x = 6 + (36 * 7); dest.y = 90 + (74 * 1); break;
				case 11: dest.x = 6 + (36 * 8); dest.y = 90 + (74 * 1); break;
				case 12: dest.x = 6 + (36 * 9); dest.y = 90 + (74 * 1); break;
				case 13: dest.x = 6 + (36 * 10); dest.y = 90 + (74 * 1); break;
				case 15: dest.x = 6 + (36 * 11); dest.y = 90 + (74 * 1); break;
				case 16: dest.x = 6 + (36 * 12); dest.y = 90 + (74 * 1); break;
				case 17: dest.x = 6 + (36 * 13); dest.y = 90 + (74 * 1); break;
				case 18: dest.x = 6 + (36 * 14); dest.y = 90 + (74 * 1); break;
				case 20: dest.x = 6 + (36 * 15); dest.y = 90 + (74 * 1); break;
				case 23: dest.x = 6 + (36 * 16); dest.y = 90 + (74 * 1); break;
				case 25: dest.x = 6 + (36 * 17); dest.y = 90 + (74 * 1); break;

				/*** middle row ***/
				case 35: dest.x = 6 + (36 * 1); dest.y = 90 + (74 * 2); break;
				case 39: dest.x = 6 + (36 * 2); dest.y = 90 + (74 * 2); break;
				case 41: dest.x = 6 + (36 * 3); dest.y = 90 + (74 * 2); break;
				case 43: dest.x = 6 + (36 * 4); dest.y = 90 + (74 * 2); break;
				case 44: dest.x = 6 + (36 * 5); dest.y = 90 + (74 * 2); break;
				case 47: dest.x = 6 + (36 * 6); dest.y = 90 + (74 * 2); break;
				case 49: dest.x = 6 + (36 * 7); dest.y = 90 + (74 * 2); break;
				case 53: dest.x = 6 + (36 * 8); dest.y = 90 + (74 * 2); break;
				case 56: dest.x = 6 + (36 * 9); dest.y = 90 + (74 * 2); break;
				case 57: dest.x = 6 + (36 * 10); dest.y = 90 + (74 * 2); break;
				case 58: dest.x = 6 + (36 * 11); dest.y = 90 + (74 * 2); break;
				case 59: dest.x = 6 + (36 * 12); dest.y = 90 + (74 * 2); break;
				case 63: dest.x = 6 + (36 * 13); dest.y = 90 + (74 * 2); break;
				case 74: dest.x = 6 + (36 * 14); dest.y = 90 + (74 * 2); break;
				case 92: dest.x = 6 + (36 * 15); dest.y = 90 + (74 * 2); break;
				case 101: dest.x = 6 + (36 * 16); dest.y = 90 + (74 * 2); break;
				case 107: dest.x = 6 + (36 * 17); dest.y = 90 + (74 * 2); break;

				/*** bottom row ***/
				case 113: dest.x = 6 + (36 * 1); dest.y = 90 + (74 * 3); break;
				case 115: dest.x = 6 + (36 * 2); dest.y = 90 + (74 * 3); break;
				case 122: dest.x = 6 + (36 * 3); dest.y = 90 + (74 * 3); break;
				case 123: dest.x = 6 + (36 * 4); dest.y = 90 + (74 * 3); break;
				case 124: dest.x = 6 + (36 * 5); dest.y = 90 + (74 * 3); break;
				case 146: dest.x = 6 + (36 * 6); dest.y = 90 + (74 * 3); break;
				case 155: dest.x = 6 + (36 * 7); dest.y = 90 + (74 * 3); break;
				case 161: dest.x = 6 + (36 * 8); dest.y = 90 + (74 * 3); break;
				case 162: dest.x = 6 + (36 * 9); dest.y = 90 + (74 * 3); break;
				case 173: dest.x = 6 + (36 * 10); dest.y = 90 + (74 * 3); break;
				case 184: dest.x = 6 + (36 * 11); dest.y = 90 + (74 * 3); break;
				case 187: dest.x = 6 + (36 * 12); dest.y = 90 + (74 * 3); break;
				case 188: dest.x = 6 + (36 * 13); dest.y = 90 + (74 * 3); break;
				case 192: dest.x = 6 + (36 * 14); dest.y = 90 + (74 * 3); break;
				case 207: dest.x = 6 + (36 * 15); dest.y = 90 + (74 * 3); break;
				case 229: dest.x = 6 + (36 * 16); dest.y = 90 + (74 * 3); break;
				default: dest.x = 6 + (36 * 17); dest.y = 90 + (74 * 3); break;
			}
			break;
		case 212: dest.x = 25; dest.y = 50; break; /*** ZSNES ***/
		case 213: dest.x = 0; dest.y = 258; break; /*** jaffar tooltip ***/
		case 214: dest.x = 275; dest.y = 14; break; /*** native button ***/
		case 215:
			dest.x = 277;
			switch (iModifier[1])
			{
				case 1: dest.y = 50; break; /*** Not found ***/
				case 2: dest.y = 65; break; /*** Linux ELF ***/
				case 3: dest.y = 95; break; /*** MS Windows: i386 32-bit ***/
				case 4: dest.y = 110; break; /*** MS Windows: AMD64 64-bit ***/
				case 5: dest.y = 125; break; /*** MS Windows: Other ***/
			}
			break;
		case 216: /*** native changing ***/
			dest.x = 2 + (((iOnTileNative - 1) % 13) * 50);
			dest.y = 2 + (((int)((iOnTileNative - 1) / 13)) * 64);
			break;
		case 217: /*** native old tile ***/
			dest.x = iNativeOldX;
			dest.y = iNativeOldY;
			break;
		/*** case 218 ***/
		case 219: dest.x = 518; dest.y = 18; break; /*** native preview ***/
		case 220: /*** native color cross ***/
			/*** Start at 0x01, NOT 0x00. ***/
			if ((iNativeColor >= 0x01) && (iNativeColor <= 0x0f))
				{ dest.x = 5 + (15 * (iNativeColor - 0x00)); dest.y = 262; }
			if ((iNativeColor >= 0x10) && (iNativeColor <= 0x1f))
				{ dest.x = 5 + (15 * (iNativeColor - 0x10)); dest.y = 277; }
			if ((iNativeColor >= 0x20) && (iNativeColor <= 0x2f))
				{ dest.x = 5 + (15 * (iNativeColor - 0x20)); dest.y = 292; }
			if ((iNativeColor >= 0x30) && (iNativeColor <= 0x3f))
				{ dest.x = 5 + (15 * (iNativeColor - 0x30)); dest.y = 307; }
			break;
	}
	if ((iLocation >= 2010) && (iLocation <= 2324)) /*** adjacent rooms ***/
	{
		snprintf (sAdj, MAX_ADJ, "%i", iLocation);
		snprintf (sAdjR, MAX_ADJ, "%c%c", sAdj[1], sAdj[2]);
		snprintf (sAdjL, MAX_ADJ, "%c", sAdj[3]);

		switch (atoi (sAdjL))
		{
			case 0:
				dest.x = BROKEN_ROOM_X;
				dest.y = BROKEN_ROOM_Y;
				break;
			case 1:
				dest.x = BROKEN_LEFT_X;
				dest.y = BROKEN_LEFT_Y;
				break;
			case 2:
				dest.x = BROKEN_RIGHT_X;
				dest.y = BROKEN_RIGHT_Y;
				break;
			case 3:
				dest.x = BROKEN_UP_X;
				dest.y = BROKEN_UP_Y;
				break;
			case 4:
				dest.x = BROKEN_DOWN_X;
				dest.y = BROKEN_DOWN_Y;
				break;
		}

		switch (atoi (sAdjR))
		{
			case 1: dest.x += (63 * 0); dest.y += (63 * 0); break;
			case 2: dest.x += (63 * 1); dest.y += (63 * 0); break;
			case 3: dest.x += (63 * 2); dest.y += (63 * 0); break;
			case 4: dest.x += (63 * 3); dest.y += (63 * 0); break;
			case 5: dest.x += (63 * 0); dest.y += (63 * 1); break;
			case 6: dest.x += (63 * 1); dest.y += (63 * 1); break;
			case 7: dest.x += (63 * 2); dest.y += (63 * 1); break;
			case 8: dest.x += (63 * 3); dest.y += (63 * 1); break;
			case 9: dest.x += (63 * 0); dest.y += (63 * 2); break;
			case 10: dest.x += (63 * 1); dest.y += (63 * 2); break;
			case 11: dest.x += (63 * 2); dest.y += (63 * 2); break;
			case 12: dest.x += (63 * 3); dest.y += (63 * 2); break;
			case 13: dest.x += (63 * 0); dest.y += (63 * 3); break;
			case 14: dest.x += (63 * 1); dest.y += (63 * 3); break;
			case 15: dest.x += (63 * 2); dest.y += (63 * 3); break;
			case 16: dest.x += (63 * 3); dest.y += (63 * 3); break;
			case 17: dest.x += (63 * 0); dest.y += (63 * 4); break;
			case 18: dest.x += (63 * 1); dest.y += (63 * 4); break;
			case 19: dest.x += (63 * 2); dest.y += (63 * 4); break;
			case 20: dest.x += (63 * 3); dest.y += (63 * 4); break;
			case 21: dest.x += (63 * 0); dest.y += (63 * 5); break;
			case 22: dest.x += (63 * 1); dest.y += (63 * 5); break;
			case 23: dest.x += (63 * 2); dest.y += (63 * 5); break;
			case 24: dest.x += (63 * 3); dest.y += (63 * 5); break;
			case 25: dest.x -= (63 * 4); dest.y += (63 * 4); break;
			case 26: dest.x -= (63 * 3); dest.y += (63 * 4); break;
			case 27: dest.x -= (63 * 2); dest.y += (63 * 4); break;
			case 28: dest.x -= (63 * 1); dest.y += (63 * 4); break;
			case 29: dest.x -= (63 * 4); dest.y += (63 * 5); break;
			case 30: dest.x -= (63 * 3); dest.y += (63 * 5); break;
			case 31: dest.x -= (63 * 2); dest.y += (63 * 5); break;
			case 32: dest.x -= (63 * 1); dest.y += (63 * 5); break;
		}
	}
	if ((iLocation >= 10101) && (iLocation <= 12532)) /*** room grid ***/
	{
		snprintf (sGrid, MAX_GRID, "%i", iLocation);
		snprintf (sGridX, MAX_GRID, "%c%c", sGrid[1], sGrid[2]);
		snprintf (sGridY, MAX_GRID, "%c%c", sGrid[3], sGrid[4]);

		/*** save room location ***/
		if (iThing != -7)
		{
			iRoomArray[atoi (sGridX)][atoi (sGridY)] = iModifier[0];
		}

		if (strcmp (sGridX, "25") == 0) /*** side pane ***/
		{
			if (atoi (sGridY) <= 24)
			{
				dest.x = 272; /*** right pane ***/
			} else {
				dest.x = 247; /*** left pane ***/
			}
		} else {
			dest.x = 282 + (atoi (sGridX) * 15); /*** grid, 24x24 ***/
		}
		if (atoi (sGridY) <= 24)
		{
			dest.y = 46 + (atoi (sGridY) * 15); /*** grid, 24x24 & right pane ***/
		} else {
			dest.y = 286 + ((atoi (sGridY) - 24) * 15); /*** left pane ***/
		}
	}

	/*** We set dest.w and dest.h in CustomRenderCopy. ***/

	if (iThing == -4)
	{
		switch (iModifier[0])
		{
			case 1: /*** black background ***/
				CustomRenderCopy (imgblack, "imgblack", &loc,
					screen, &dest); break;
			case 2: /*** hourglass ***/
				CustomRenderCopy (imghourglass, "imghourglass", &loc,
					screen, &dest); break;
			case 3: /*** hourglass sprite ***/
				loc.x = iHourglassFrame * 38;
				CustomRenderCopy (imghourglasssprite, "imghourglasssprite", &loc,
					screen, &dest); break;
			case 4: /*** sand sprite ***/
				loc.x = (iSandFrame - 1) * 2;
				CustomRenderCopy (imgsandsprite, "imgsandsprite", &loc,
					screen, &dest); break;
		}
	}

	/*** room links selections ***/
	if (iThing == -7)
	{
		switch (iModifier[0])
		{
			case 0: /*** green stripes ***/
				CustomRenderCopy (imgsrc, "imgsrc", &loc,
					screen, &dest); break;
			case 1: /*** blue border ***/
				CustomRenderCopy (imgsrs, "imgsrs", &loc,
					screen, &dest); break;
			case 2: /*** red stripes ***/
				CustomRenderCopy (imgsrm, "imgsrm", &loc,
					screen, &dest); break;
			case 3: /*** white cross ***/
				CustomRenderCopy (imgsrp, "imgsrp", &loc,
					screen, &dest); break;
			case 4: /*** blue square ***/
				CustomRenderCopy (imgsrb, "imgsrb", &loc,
					screen, &dest); break;
			case 5: /*** yellow square ***/
				CustomRenderCopy (imgsro, "imgsro", &loc,
					screen, &dest); break;
		}
	}

	/*** rooms ***/
	if (iThing == -6)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgrl, "imgrl", &loc,
					screen, &dest); break;
			case 1:
				CustomRenderCopy (imgroom1, "imgroom1", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgroom2, "imgroom2", &loc,
					screen, &dest); break;
			case 3:
				CustomRenderCopy (imgroom3, "imgroom3", &loc,
					screen, &dest); break;
			case 4:
				CustomRenderCopy (imgroom4, "imgroom4", &loc,
					screen, &dest); break;
			case 5:
				CustomRenderCopy (imgroom5, "imgroom5", &loc,
					screen, &dest); break;
			case 6:
				CustomRenderCopy (imgroom6, "imgroom6", &loc,
					screen, &dest); break;
			case 7:
				CustomRenderCopy (imgroom7, "imgroom7", &loc,
					screen, &dest); break;
			case 8:
				CustomRenderCopy (imgroom8, "imgroom8", &loc,
					screen, &dest); break;
			case 9:
				CustomRenderCopy (imgroom9, "imgroom9", &loc,
					screen, &dest); break;
			case 10:
				CustomRenderCopy (imgroom10, "imgroom10", &loc,
					screen, &dest); break;
			case 11:
				CustomRenderCopy (imgroom11, "imgroom11", &loc,
					screen, &dest); break;
			case 12:
				CustomRenderCopy (imgroom12, "imgroom12", &loc,
					screen, &dest); break;
			case 13:
				CustomRenderCopy (imgroom13, "imgroom13", &loc,
					screen, &dest); break;
			case 14:
				CustomRenderCopy (imgroom14, "imgroom14", &loc,
					screen, &dest); break;
			case 15:
				CustomRenderCopy (imgroom15, "imgroom15", &loc,
					screen, &dest); break;
			case 16:
				CustomRenderCopy (imgroom16, "imgroom16", &loc,
					screen, &dest); break;
			case 17:
				CustomRenderCopy (imgroom17, "imgroom17", &loc,
					screen, &dest); break;
			case 18:
				CustomRenderCopy (imgroom18, "imgroom18", &loc,
					screen, &dest); break;
			case 19:
				CustomRenderCopy (imgroom19, "imgroom19", &loc,
					screen, &dest); break;
			case 20:
				CustomRenderCopy (imgroom20, "imgroom20", &loc,
					screen, &dest); break;
			case 21:
				CustomRenderCopy (imgroom21, "imgroom21", &loc,
					screen, &dest); break;
			case 22:
				CustomRenderCopy (imgroom22, "imgroom22", &loc,
					screen, &dest); break;
			case 23:
				CustomRenderCopy (imgroom23, "imgroom23", &loc,
					screen, &dest); break;
			case 24:
				CustomRenderCopy (imgroom24, "imgroom24", &loc,
					screen, &dest); break;
			case 25:
				CustomRenderCopy (imgroom25, "imgroom25", &loc,
					screen, &dest); break;
			case 26:
				CustomRenderCopy (imgroom26, "imgroom26", &loc,
					screen, &dest); break;
			case 27:
				CustomRenderCopy (imgroom27, "imgroom27", &loc,
					screen, &dest); break;
			case 28:
				CustomRenderCopy (imgroom28, "imgroom28", &loc,
					screen, &dest); break;
			case 29:
				CustomRenderCopy (imgroom29, "imgroom29", &loc,
					screen, &dest); break;
			case 30:
				CustomRenderCopy (imgroom30, "imgroom30", &loc,
					screen, &dest); break;
			case 31:
				CustomRenderCopy (imgroom31, "imgroom31", &loc,
					screen, &dest); break;
			case 32:
				CustomRenderCopy (imgroom32, "imgroom32", &loc,
					screen, &dest); break;
			case 33:
				CustomRenderCopy (imgbrl, "imgbrl", &loc,
					screen, &dest); break;
			case 34:
				CustomRenderCopy (imgbrl2, "imgbrl2", &loc,
					screen, &dest); break;
			case 35:
				CustomRenderCopy (imgrl2, "imgrl2", &loc,
					screen, &dest); break;
			case 36:
				CustomRenderCopy (imgbrl3, "imgbrl3", &loc,
					screen, &dest); break;
		}
	}

	/*** events ***/
	if (iThing == -10)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgevents, "imgevents", &loc,
					screen, &dest); break;
			case 1:
				CustomRenderCopy (imgchkg, "imgchkg", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgeventu, "imgeventu", &loc,
					screen, &dest); break;
		}
	}

	/*** faded tile ***/
	if (iThing == -11)
	{
		if (iModifier[0] == 0)
			{ CustomRenderCopy (imgfadeds, "imgfadeds", &loc,
				screen, &dest); }
	}

	/*** changing ***/
	if (iThing == -12)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgdungeon, "imgdungeon", &loc,
					screen, &dest); break;
			case 1:
				CustomRenderCopy (imgpalace, "imgpalace", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgclose_0, "imgclose_0", &loc,
					screen, &dest); break;
			case 3:
				CustomRenderCopy (imgclose_1, "imgclose_1", &loc,
					screen, &dest); break;
			case 4:
				if (IsDisabled (iOnTile) == 0)
				{
					/*** Show bright green border. ***/
					if (iOnTile <= (7 * 13))
						CustomRenderCopy (imgborderb, "imgborderb", &loc,
							screen, &dest);
					else CustomRenderCopy (imgborders, "imgborders", &loc,
						screen, &dest);
				}
				break;
			case 5:
				CustomRenderCopy (imgdother, "imgdother", &loc,
					screen, &dest); break;
			case 6:
				CustomRenderCopy (imgdother, "imgdother", &loc,
					screen, &dest); break;
			case 7:
				CustomRenderCopy (imgdjaffar, "imgdjaffar", &loc,
					screen, &dest); break;
			case 8:
				CustomRenderCopy (imgdother, "imgdother", &loc,
					screen, &dest); break;
			case 9:
				CustomRenderCopy (imgdguards, "imgdguards", &loc,
					screen, &dest); break;
			case 10:
				CustomRenderCopy (imgbordersl, "imgbordersl", &loc,
					screen, &dest); break;
			case 11:
				if (iIsCustom == 0)
					CustomRenderCopy (imgborderbl, "imgborderbl", &loc,
						screen, &dest);
				break;
			case 12:
				CustomRenderCopy (imgchkb, "imgchkb", &loc,
					screen, &dest); break;
			case 13:
				CustomRenderCopy (imgcustoma0, "imgcustoma0", &loc,
					screen, &dest); break;
			case 14:
				CustomRenderCopy (imgcustomi0, "imgcustomi0", &loc,
					screen, &dest); break;
			case 15:
				CustomRenderCopy (imgcustoma1, "imgcustoma1", &loc,
					screen, &dest); break;
			case 16:
				CustomRenderCopy (imgcustomi1, "imgcustomi1", &loc,
					screen, &dest); break;
			case 17:
				CustomRenderCopy (imgcustom, "imgcustom", &loc,
					screen, &dest); break;
			case 18:
				CustomRenderCopy (imgcustom_0, "imgcustom_0", &loc,
					screen, &dest); break;
			case 19:
				CustomRenderCopy (imgcustom_1, "imgcustom_1", &loc,
					screen, &dest); break;
			case 20:
				CustomRenderCopy (imgoth, "imgoth", &loc,
					screen, &dest); break;
			case 21:
				CustomRenderCopy (imgcaverns, "imgcaverns", &loc,
					screen, &dest); break;
			case 22:
				CustomRenderCopy (imgruins, "imgruins", &loc,
					screen, &dest); break;
			case 23:
				CustomRenderCopy (imgruins_back, "imgruins_back", &loc,
					screen, &dest); break;
			case 24:
				CustomRenderCopy (imgtemple, "imgtemple", &loc,
					screen, &dest); break;
			case 25:
				CustomRenderCopy (imgtemple_back, "imgtemple_back", &loc,
					screen, &dest); break;
			case 26:
				CustomRenderCopy (imgback_0, "imgback_0", &loc,
					screen, &dest); break;
			case 27:
				CustomRenderCopy (imgback_1, "imgback_1", &loc,
					screen, &dest); break;
			case 28:
				CustomRenderCopy (imgguards_0, "imgguards_0", &loc,
					screen, &dest); break;
			case 29:
				CustomRenderCopy (imgguards_1, "imgguards_1", &loc,
					screen, &dest); break;
			case 30:
				CustomRenderCopy (imgguards, "imgguards", &loc,
					screen, &dest); break;
			case 31:
				CustomRenderCopy (imgclosebig_0, "imgclosebig_0", &loc,
					screen, &dest); break;
			case 32:
				CustomRenderCopy (imgclosebig_1, "imgclosebig_1", &loc,
					screen, &dest); break;
			case 33:
				CustomRenderCopy (imgguard_row, "imgguard_row", &loc,
					screen, &dest); break;
			case 34:
				CustomRenderCopy (imgguard_entry, "imgguard_entry", &loc,
					screen, &dest); break;
			case 35:
				CustomRenderCopy (imgfadeddg, "imgfadeddg", &loc,
					screen, &dest); break;
			case 36:
				CustomRenderCopy (imgfadedsgl, "imgfadedsgl", &loc,
					screen, &dest); break;
			case 37:
				CustomRenderCopy (imgfadedsgr, "imgfadedsgr", &loc,
					screen, &dest); break;
			case 38:
				CustomRenderCopy (imgxtooltip, "imgxtooltip", &loc,
					screen, &dest); break;
			case 39:
				CustomRenderCopy (imgmusic_0, "imgmusic_0", &loc,
					screen, &dest); break;
			case 40:
				CustomRenderCopy (imgmusic_1, "imgmusic_1", &loc,
					screen, &dest); break;
			case 41:
				CustomRenderCopy (imgmusic, "imgmusic", &loc,
					screen, &dest); break;
			case 42:
				CustomRenderCopy (imgee_0, "imgee_0", &loc,
					screen, &dest); break;
			case 43:
				CustomRenderCopy (imgee_1, "imgee_1", &loc,
					screen, &dest); break;
			case 44:
				CustomRenderCopy (imgec_0, "imgec_0", &loc,
					screen, &dest); break;
			case 45:
				CustomRenderCopy (imgec_1, "imgec_1", &loc,
					screen, &dest); break;
			case 46:
				CustomRenderCopy (imgprincew, "imgprincew", &loc,
					screen, &dest); break;
			case 47: break; /*** Was imggw_rooftops. ***/
			case 48:
				CustomRenderCopy (imggw_255, "imggw_255", &loc,
					screen, &dest); break;
			case 49:
				CustomRenderCopy (imggw_2, "imggw_2", &loc,
					screen, &dest); break;
			case 50:
				CustomRenderCopy (imggw_5, "imggw_5", &loc,
					screen, &dest); break;
			case 51:
				CustomRenderCopy (imggw_7, "imggw_7", &loc,
					screen, &dest); break;
			case 52:
				CustomRenderCopy (imggw_0, "imggw_0", &loc,
					screen, &dest); break;
			case 53:
				CustomRenderCopy (imggw_dynamic, "imggw_dynamic", &loc,
					screen, &dest); break;
			case 54:
				CustomRenderCopy (imgsb, "imgsb", &loc,
					screen, &dest); break;
			case 55:
				CustomRenderCopy (imghb, "imghb", &loc,
					screen, &dest); break;
			case 56:
				CustomRenderCopy (imgdistort, "imgdistort", &loc,
					screen, &dest); break;
			case 57:
				CustomRenderCopy (imghc, "imghc", &loc, screen, &dest); break;
			case 58:
				CustomRenderCopy (imgblue, "imgblue", &loc, screen, &dest); break;
			case 59:
				CustomRenderCopy (imgfawn, "imgfawn", &loc, screen, &dest); break;
			case 60:
				CustomRenderCopy (imggreen, "imggreen", &loc, screen, &dest); break;
			case 61:
				CustomRenderCopy (imghallway, "imghallway", &loc,
					screen, &dest); break;
			case 62:
				CustomRenderCopy (imgintro, "imgintro", &loc, screen, &dest); break;
			case 63:
				CustomRenderCopy (imgjaffart, "imgjaffart", &loc,
					screen, &dest); break;
			case 64:
				CustomRenderCopy (imglava, "imglava", &loc, screen, &dest); break;
			case 65:
				CustomRenderCopy (imgmarble, "imgmarble", &loc, screen, &dest); break;
			case 66:
				CustomRenderCopy (imgsilver, "imgsilver", &loc, screen, &dest); break;
			case 67:
				CustomRenderCopy (imgumber, "imgumber", &loc, screen, &dest); break;
			case 68:
				CustomRenderCopy (imgsnesback, "imgsnesback", &loc,
					screen, &dest); break;
			case 69:
				switch (cCurType)
				{
					case 'b':
						CustomRenderCopy (imgblueb, "imgblueb", &loc,
							screen, &dest); break;
					case 'f':
						CustomRenderCopy (imgfawnb, "imgfawnb", &loc,
							screen, &dest); break;
					case 's':
						CustomRenderCopy (imgsilverb, "imgsilverb", &loc,
							screen, &dest); break;
					case 'l':
						CustomRenderCopy (imglavab, "imglavab", &loc,
							screen, &dest); break;
					case 'g':
						CustomRenderCopy (imggreenb, "imggreenb", &loc,
							screen, &dest); break;
					case 'u':
						CustomRenderCopy (imgumberb, "imgumberb", &loc,
							screen, &dest); break;
					case 'm':
						CustomRenderCopy (imgmarbleb, "imgmarbleb", &loc,
							screen, &dest); break;
					case 'h':
						CustomRenderCopy (imghallwayb, "imghallwayb", &loc,
							screen, &dest); break;
					case 'j':
						CustomRenderCopy (imgjaffarb, "imgjaffarb", &loc,
							screen, &dest); break;
					case 'i':
						CustomRenderCopy (imgintrob, "imgintrob", &loc,
							screen, &dest); break;
				}
				break;
			case 70:
				CustomRenderCopy (imgtemp_0, "imgtemp_0", &loc, screen, &dest); break;
			case 71:
				CustomRenderCopy (imgtemp_1, "imgtemp_1", &loc, screen, &dest); break;
			case 72:
				CustomRenderCopy (imgsnestemp, "imgsnestemp", &loc,
					screen, &dest); break;
			case 73:
				switch (cCurType)
				{
					case 'b':
						CustomRenderCopy (imgtempb, "imgtempb", &loc,
							screen, &dest); break;
					case 'f':
						CustomRenderCopy (imgtempf, "imgtempf", &loc,
							screen, &dest); break;
					case 's':
						CustomRenderCopy (imgtemps, "imgtemps", &loc,
							screen, &dest); break;
					case 'l':
						CustomRenderCopy (imgtempl, "imgtempl", &loc,
							screen, &dest); break;
					case 'g':
						CustomRenderCopy (imgtempg, "imgtempg", &loc,
							screen, &dest); break;
					case 'u':
						CustomRenderCopy (imgtempu, "imgtempu", &loc,
							screen, &dest); break;
					case 'm':
						CustomRenderCopy (imgtempm, "imgtempm", &loc,
							screen, &dest); break;
					case 'h':
						CustomRenderCopy (imgtemph, "imgtemph", &loc,
							screen, &dest); break;
					case 'j':
						CustomRenderCopy (imgtempj, "imgtempj", &loc,
							screen, &dest); break;
					case 'i':
						CustomRenderCopy (imgtempi, "imgtempi", &loc,
							screen, &dest); break;
				}
				break;
			case 74:
				CustomRenderCopy (imgborderr, "imgborderr", &loc,
					screen, &dest); break;
			case 75:
				CustomRenderCopy (imgcolor_0, "imgcolor_0", &loc,
					screen, &dest); break;
			case 76:
				CustomRenderCopy (imgcolor_1, "imgcolor_1", &loc,
					screen, &dest); break;
			case 77:
				CustomRenderCopy (imgstooltip, "imgstooltip", &loc,
					screen, &dest); break;
			case 78: /*** animated back ***/
				CustomRenderCopy (imganimback, "imganimback", &loc,
					screen, &dest);
				snprintf (sAnimGroup, MAX_TEXT, "%i", iModifier[2]);
				DisplayTextLine (dest.x + 6, dest.y + 4, sAnimGroup, font2,
					color_wh, color_bl, 0);
				break;
			case 79: /*** red prince ***/
				CustomRenderCopy (imgredp, "imgredp", &loc, screen, &dest); break;
			case 80: /*** tooltip ***/
				CustomRenderCopy (imgtooltip, "imgtooltip", &loc,
					screen, &dest); break;
		}
	}

	/*** PoP select ***/
	if (iThing == -13)
	{
		switch (iModifier[0])
		{
			case 1:
				CustomRenderCopy (imgpop, "imgpop", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgpop1dis, "imgpop1dis", &loc,
					screen, &dest); break;
			case 3:
				CustomRenderCopy (imgpop1off, "imgpop1off", &loc,
					screen, &dest); break;
			case 4:
				CustomRenderCopy (imgpop1on, "imgpop1on", &loc,
					screen, &dest); break;
			case 5:
				CustomRenderCopy (imgpop2dis, "imgpop2dis", &loc,
					screen, &dest); break;
			case 6:
				CustomRenderCopy (imgpop2off, "imgpop2off", &loc,
					screen, &dest); break;
			case 7:
				CustomRenderCopy (imgpop2on, "imgpop2on", &loc,
					screen, &dest); break;
			case 8:
				CustomRenderCopy (imgprprob, "imgprprob", &loc,
					screen, &dest); break;
			/*** case 9: ***/
			case 10:
				CustomRenderCopy (imgcontroller, "imgcontroller", &loc,
					screen, &dest); break;
			case 11:
				CustomRenderCopy (imgpop1snesdis, "imgpop1snesdis", &loc,
					screen, &dest); break;
			case 12:
				CustomRenderCopy (imgpop1snesoff, "imgpop1snesoff", &loc,
					screen, &dest); break;
			case 13:
				CustomRenderCopy (imgpop1sneson, "imgpop1sneson", &loc,
					screen, &dest); break;
		}
	}

	/*** PoP2 backgrounds ***/
	if (iThing == -14)
	{
		if ((iModifier[0] == 1) && (iModifier[1] == 1))
			CustomRenderCopy (backl1r1, "backl1r1", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 2))
			CustomRenderCopy (backl1r2, "backl1r2", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 3))
			CustomRenderCopy (backl1r3, "backl1r3", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 4))
			CustomRenderCopy (backl1r4, "backl1r4", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 5))
			CustomRenderCopy (backl1r5, "backl1r5", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 10))
			CustomRenderCopy (backl1r10, "backl1r10", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 11))
			CustomRenderCopy (backl1r11, "backl1r11", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 12))
			CustomRenderCopy (backl1r12, "backl1r12", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 15))
			CustomRenderCopy (backl1r15, "backl1r15", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 16))
			CustomRenderCopy (backl1r16, "backl1r16", &loc, screen, &dest);
		if ((iModifier[0] == 1) && (iModifier[1] == 19))
			CustomRenderCopy (backl1r19, "backl1r19", &loc, screen, &dest);
		if ((iModifier[0] == 2) && (iModifier[1] == 1))
			CustomRenderCopy (backl2r1, "backl2r1", &loc, screen, &dest);
		if ((iModifier[0] == 2) && (iModifier[1] == 2))
			CustomRenderCopy (backl2r2, "backl2r2", &loc, screen, &dest);
		if ((iModifier[0] == 2) && (iModifier[1] == 3))
			CustomRenderCopy (backl2r3, "backl2r3", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 1))
			CustomRenderCopy (backl14r1, "backl14r1", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 2))
			CustomRenderCopy (backl14r2, "backl14r2", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 3))
			CustomRenderCopy (backl14r3, "backl14r3", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 4))
			CustomRenderCopy (backl14r4, "backl14r4", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 5))
			CustomRenderCopy (backl14r5, "backl14r5", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 6))
			CustomRenderCopy (backl14r6, "backl14r6", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 7))
			CustomRenderCopy (backl14r7, "backl14r7", &loc, screen, &dest);
		if ((iModifier[0] == 14) && (iModifier[1] == 8))
			CustomRenderCopy (backl14r8, "backl14r8", &loc, screen, &dest);
		if ((iModifier[0] == 6) && (iModifier[1] == 27))
			CustomRenderCopy (backl6r27, "backl6r27", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 2))
			CustomRenderCopy (backl9r2, "backl9r2", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 11))
			CustomRenderCopy (backl9r11, "backl9r11", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 12))
			CustomRenderCopy (backl9r12, "backl9r12", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 13))
			CustomRenderCopy (backl9r13, "backl9r13", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 14))
			CustomRenderCopy (backl9r14, "backl9r14", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 15))
			CustomRenderCopy (backl9r15, "backl9r15", &loc, screen, &dest);
		if ((iModifier[0] == 9) && (iModifier[1] == 16))
			CustomRenderCopy (backl9r16, "backl9r16", &loc, screen, &dest);
		if ((iModifier[0] == 13) && (iModifier[1] == 4))
			CustomRenderCopy (backl13r4, "backl13r4", &loc, screen, &dest);
		if ((iModifier[0] == 8) && (iModifier[1] == 9))
			CustomRenderCopy (backl8r9, "backl8r9", &loc, screen, &dest);
	}

	/*** details ***/
	if (iThing == -15)
	{
		/*** For cracks and symbols in the ruins. ***/
		if ((iModifier[2] == -54) && (iModifier[3] == -38))
		{
			dest.x-=54;
			dest.y-=38;
		}

		/*** stalactites ***/
		if ((iModifier[0] == 0) && (iModifier[1] == 8))
			ShowDetail (stalactite8, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 16))
			ShowDetail (stalactite16, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 24))
			ShowDetail (stalactite24, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 32))
			ShowDetail (stalactite32, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 40))
			ShowDetail (stalactite40, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 48))
			ShowDetail (stalactite48, loc, screen, dest, iLocation);
		if ((iModifier[0] == 0) && (iModifier[1] == 56))
			ShowDetail (stalactite56, loc, screen, dest, iLocation);

		/*** bottoms ***/
		if ((iModifier[0] == 1) && (iModifier[1] == 1))
			ShowDetail (bottom1, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 2))
			ShowDetail (bottom2, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 3))
			ShowDetail (bottom3, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 4))
			ShowDetail (bottom4, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 5))
			ShowDetail (bottom5, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 6))
			ShowDetail (bottom6, loc, screen, dest, iLocation);
		if ((iModifier[0] == 1) && (iModifier[1] == 7))
			ShowDetail (bottom7, loc, screen, dest, iLocation);

		/*** cracks ***/
		if ((iModifier[0] == 2) && (iModifier[1] == 1))
			ShowDetail (crack1, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 3))
			ShowDetail (crack3, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 4))
			ShowDetail (crack4, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 5))
			ShowDetail (crack5, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 6))
			ShowDetail (crack6, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 7))
			ShowDetail (crack7, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 8))
			ShowDetail (crack8, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 9))
			ShowDetail (crack9, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 10))
			ShowDetail (crack10, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 11))
			ShowDetail (crack11, loc, screen, dest, iLocation);
		if ((iModifier[0] == 2) && (iModifier[1] == 12))
			ShowDetail (crack12, loc, screen, dest, iLocation);

		/*** symbols ***/
		if ((iModifier[0] == 3) && (iModifier[1] == 16))
			ShowDetail (symbol16, loc, screen, dest, iLocation);
		if ((iModifier[0] == 3) && (iModifier[1] == 32))
			ShowDetail (symbol32, loc, screen, dest, iLocation);
		if ((iModifier[0] == 3) && (iModifier[1] == 48))
			ShowDetail (symbol48, loc, screen, dest, iLocation);
	}

	/*** foreground elements ***/
	if (iThing == -16)
	{
		switch (iModifier[0])
		{
			case 1: /*** horse ***/
				CustomRenderCopy (imghorse, "imghorse", &loc,
					screen, &dest); break;
			case 2: /*** level 6 arrow ***/
				CustomRenderCopy (imgarrow, "imgarrow", &loc,
					screen, &dest); break;
			case 3: /*** invisible ***/
				CustomRenderCopy (imginvisible, "imginvisible", &loc,
					screen, &dest); break;
			case 4: /*** curtain left ***/
				CustomRenderCopy (imgcurtainl, "imgcurtainl", &loc,
					screen, &dest); break;
			case 5: /*** curtain right ***/
				CustomRenderCopy (imgcurtainr, "imgcurtainr", &loc,
					screen, &dest); break;
			case 6: /*** gates ***/
				CustomRenderCopy (imggates, "imggates", &loc, screen, &dest); break;
			case 7: /*** exit arrow left ***/
				CustomRenderCopy (imgexitl, "imgexitl", &loc, screen, &dest); break;
			case 8: /*** exit arrow right ***/
				CustomRenderCopy (imgexitr, "imgexitr", &loc, screen, &dest); break;
			case 9: /*** exit arrow up ***/
				CustomRenderCopy (imgexitu, "imgexitu", &loc, screen, &dest); break;
			case 10: /*** exit arrow down ***/
				CustomRenderCopy (imgexitd, "imgexitd", &loc, screen, &dest); break;
			case 11: /*** checkp arrow left ***/
				CustomRenderCopy (imgcheckpl, "imgcheckpl", &loc,
					screen, &dest); break;
			case 12: /*** checkp arrow right ***/
				CustomRenderCopy (imgcheckpr, "imgcheckpr", &loc,
					screen, &dest); break;
			case 13: /*** checkp arrow up ***/
				CustomRenderCopy (imgcheckpu, "imgcheckpu", &loc,
					screen, &dest); break;
			case 14: /*** checkp arrow down ***/
				CustomRenderCopy (imgcheckpd, "imgcheckpd", &loc,
					screen, &dest); break;
		}
	}

	/*** music note and buttons ***/
	if (iThing == -17)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgmusic_note, "imgmusic_note", &loc,
					screen, &dest); break;
			case 1:
				CustomRenderCopy (imgm_all_0, "imgm_all_0", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgm_all_1, "imgm_all_1", &loc,
					screen, &dest); break;
			case 3:
				CustomRenderCopy (imgm_none_0, "imgm_none_0", &loc,
					screen, &dest); break;
			case 4:
				CustomRenderCopy (imgm_none_1, "imgm_none_1", &loc,
					screen, &dest); break;
			case 5:
				CustomRenderCopy (imgm_left_0, "imgm_left_0", &loc,
					screen, &dest); break;
			case 6:
				CustomRenderCopy (imgm_left_1, "imgm_left_1", &loc,
					screen, &dest); break;
			case 7:
				CustomRenderCopy (imgm_right_0, "imgm_right_0", &loc,
					screen, &dest); break;
			case 8:
				CustomRenderCopy (imgm_right_1, "imgm_right_1", &loc,
					screen, &dest); break;
			case 9:
				CustomRenderCopy (imgm_top_0, "imgm_top_0", &loc,
					screen, &dest); break;
			case 10:
				CustomRenderCopy (imgm_top_1, "imgm_top_1", &loc,
					screen, &dest); break;
			case 11:
				CustomRenderCopy (imgm_middle_0, "imgm_middle_0", &loc,
					screen, &dest); break;
			case 12:
				CustomRenderCopy (imgm_middle_1, "imgm_middle_1", &loc,
					screen, &dest); break;
			case 13:
				CustomRenderCopy (imgm_bottom_0, "imgm_bottom_0", &loc,
					screen, &dest); break;
			case 14:
				CustomRenderCopy (imgm_bottom_1, "imgm_bottom_1", &loc,
					screen, &dest); break;
			case 15:
				CustomRenderCopy (imgm_invert_0, "imgm_invert_0", &loc,
					screen, &dest); break;
			case 16:
				CustomRenderCopy (imgm_invert_1, "imgm_invert_1", &loc,
					screen, &dest); break;
		}
	}

	/*** PoP1 for SNES ***/
	if (iThing == -18)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgsbs, "imgsbs", &loc, screen, &dest);
				break;
			case 1:
				CustomRenderCopy (imgcustoms, "imgcustoms", &loc, screen, &dest);
				break;
			case 2:
				CustomRenderCopy (imgzsnes, "imgzsnes", &loc, screen, &dest);
				break;
			case 3:
				CustomRenderCopy (imgjtooltip, "imgjtooltip", &loc, screen, &dest);
				break;
		}
	}

	/*** native ***/
	if (iThing == -3)
	{
		switch (iModifier[0])
		{
			case 0:
				CustomRenderCopy (imgnativeoff, "imgnativeoff", &loc, screen, &dest);
				break;
			case 1:
				CustomRenderCopy (imgnativeon_0, "imgnativeon_0", &loc,
					screen, &dest); break;
			case 2:
				CustomRenderCopy (imgnativeon_1, "imgnativeon_1", &loc,
					screen, &dest); break;
			case 3:
				CustomRenderCopy (imgnative_f, "imgnative_f", &loc, screen, &dest);
				break;
			/*** case 4: ***/
			/*** case 5: ***/
			/*** case 6: ***/
			case 7:
				CustomRenderCopy (imgnative, "imgnative", &loc, screen, &dest);
				break;
			case 8:
				CustomRenderCopy (imgnative_bb, "imgnative_bb", &loc, screen, &dest);
				break;
			case 9:
				if (iIsCustom == 0)
					CustomRenderCopy (imgnative_bbl, "imgnative_bbl", &loc,
						screen, &dest);
				break;
			case 10:
				snprintf (sText, MAX_TEXT, "imgnative_d[%i]", iModifier[1]);
				CustomRenderCopy (imgnative_d[iModifier[1]], sText, &loc,
					screen, &dest);
				break;
			case 11:
				snprintf (sText, MAX_TEXT, "imgnative_p[%i]", iModifier[1]);
				CustomRenderCopy (imgnative_p[iModifier[1]], sText, &loc,
					screen, &dest);
				break;
		}
	}

	/*** arrows ***/
	if (iThing == -1)
	{
		switch (iModifier[0])
		{
			case 1:
				if (iDownAt == 1)
				{
					CustomRenderCopy (imgleft_1, "imgleft_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgleft_0, "imgleft_0", &loc,
						screen, &dest);
				}
				break;
			case 2:
				if (iDownAt == 2)
				{
					CustomRenderCopy (imgright_1, "imgright_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgright_0, "imgright_0", &loc,
						screen, &dest);
				}
				break;
			case 3:
				if (iDownAt == 3)
				{
					CustomRenderCopy (imgup_1, "imgup_1", &loc, screen, &dest);
				} else {
					CustomRenderCopy (imgup_0, "imgup_0", &loc, screen, &dest);
				}
				break;
			case 4:
				if (iDownAt == 4)
				{
					CustomRenderCopy (imgdown_1, "imgdown_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgdown_0, "imgdown_0", &loc,
						screen, &dest);
				}
				break;
			case 5:
				CustomRenderCopy (imgudno, "imgudno", &loc,
					screen, &dest); break;
			case 6:
				CustomRenderCopy (imglrno, "imglrno", &loc,
					screen, &dest); break;
			case 7:
				CustomRenderCopy (imgudnonfo, "imgudnonfo", &loc,
					screen, &dest); break;
		}
	}

	/*** buttons ***/
	if (iThing == -2)
	{
		switch (iModifier[0])
		{
			case 1: /*** rooms on ***/
				if (iDownAt == 5)
				{
					CustomRenderCopy (imgroomson_1, "imgroomson_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgroomson_0, "imgroomson_0", &loc,
						screen, &dest);
				}
				break;
			case 8: /*** rooms broken on ***/
				if (iDownAt == 11)
				{
					CustomRenderCopy (imgbroomson_1, "imgbroomson_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgbroomson_0, "imgbroomson_0", &loc,
						screen, &dest);
				}
				break;
			case 6: /*** rooms off ***/
				CustomRenderCopy (imgroomsoff, "imgroomsoff", &loc,
					screen, &dest); break;
			case 9: /*** rooms broken off ***/
				CustomRenderCopy (imgbroomsoff, "imgbroomsoff", &loc,
					screen, &dest); break;
			case 2: /*** events on ***/
				if (iDownAt == 6)
				{
					CustomRenderCopy (imgeventson_1, "imgeventson_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgeventson_0, "imgeventson_0", &loc,
						screen, &dest);
				}
				break;
			case 7: /*** events off ***/
				CustomRenderCopy (imgeventsoff, "imgeventsoff", &loc,
					screen, &dest); break;
			case 3: /*** save on ***/
				if (iDownAt == 7)
				{
					CustomRenderCopy (imgsaveon_1, "imgsaveon_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgsaveon_0, "imgsaveon_0", &loc,
						screen, &dest);
				}
				break;
			case 4: /*** quit ***/
				if (iDownAt == 8)
				{
					CustomRenderCopy (imgquit_1, "imgquit_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgquit_0, "imgquit_0", &loc,
						screen, &dest);
				}
				break;
			case 5: /*** save off ***/
				CustomRenderCopy (imgsaveoff, "imgsaveoff", &loc,
					screen, &dest); break;
			case 10: /*** save off perm ***/
				CustomRenderCopy (imgsoffp, "imgsoffp", &loc, screen, &dest); break;
		}
	}

	/*** previous and next ***/
	if (iThing == -5)
	{
		switch (iModifier[0])
		{
			case 1:
				if (iDownAt == 9)
				{
					CustomRenderCopy (imgprevon_1, "imgprevon_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgprevon_0, "imgprevon_0", &loc,
						screen, &dest);
				}
				break;
			case 2:
				if (iDownAt == 10)
				{
					CustomRenderCopy (imgnexton_1, "imgnexton_1", &loc,
						screen, &dest);
				} else {
					CustomRenderCopy (imgnexton_0, "imgnexton_0", &loc,
						screen, &dest);
				}
				break;
			case 3:
				CustomRenderCopy (imgbar, "imgbar", &loc,
					screen, &dest); break;
			case 4:
				CustomRenderCopy (imgprevoff, "imgprevoff", &loc,
					screen, &dest); break;
			case 5:
				CustomRenderCopy (imgnextoff, "imgnextoff", &loc,
					screen, &dest); break;
			case 10:
				CustomRenderCopy (extras_0, "extras_0", &loc,
					screen, &dest); break;
			case 11:
				CustomRenderCopy (extras_1, "extras_1", &loc,
					screen, &dest); break;
			case 12:
				CustomRenderCopy (extras_2, "extras_2", &loc,
					screen, &dest); break;
			case 13:
				CustomRenderCopy (extras_3, "extras_3", &loc,
					screen, &dest); break;
			case 14:
				CustomRenderCopy (extras_4, "extras_4", &loc,
					screen, &dest); break;
			case 15:
				CustomRenderCopy (extras_5, "extras_5", &loc,
					screen, &dest); break;
			case 16:
				CustomRenderCopy (extras_6, "extras_6", &loc,
					screen, &dest); break;
			case 17:
				CustomRenderCopy (extras_7, "extras_7", &loc,
					screen, &dest); break;
			case 18:
				CustomRenderCopy (extras_8, "extras_8", &loc,
					screen, &dest); break;
			case 19:
				CustomRenderCopy (extras_9, "extras_9", &loc,
					screen, &dest); break;
			case 20:
				CustomRenderCopy (extras_10, "extras_10", &loc,
					screen, &dest); break;
			case 21:
				CustomRenderCopy (imgl10warn, "imgl10warn", &loc,
					screen, &dest); break;
			case 22:
				CustomRenderCopy (imgl21warn, "imgl21warn", &loc,
					screen, &dest); break;
		}
	}

	/*** positions ***/
	if (iThing >= 0)
	{
		iPosShown = 0;

		if (iEditPoP == 1)
		{
			iTileNr = GetTileNr (iThing, iModifier[0]);
			switch (iTileNr)
			{
				/*** first row ***/
				case 1:
					ShowPos (loc, dest, iLocation, imgd0_0, imgp0_0, ""); break;
				case 2:
					ShowPos (loc, dest, iLocation, imgd0_1, imgp0_1, ""); break;
				case 3:
					ShowPos (loc, dest, iLocation, imgd0_2, imgp0_2, ""); break;
				case 4:
					ShowPos (loc, dest, iLocation, imgd0_3, imgp0_3, ""); break;
				case 5:
					ShowPos (loc, dest, iLocation, imgd0_255, imgp0_255, ""); break;
				case 6:
					ShowPos (loc, dest, iLocation, imgd1_0, imgp1_0, ""); break;
				case 7:
					ShowPos (loc, dest, iLocation, imgd1_1, imgp1_1, ""); break;
				case 8:
					ShowPos (loc, dest, iLocation, imgd1_2, imgp1_2, ""); break;
				case 9:
					ShowPos (loc, dest, iLocation, imgd1_3, imgp1_3, ""); break;
				case 10:
					ShowPos (loc, dest, iLocation, imgd1_255, imgp1_255, ""); break;
				case 11:
					ShowPos (loc, dest, iLocation, imgd2_0, imgp2_0, ""); break;
				case 12:
					ShowPos (loc, dest, iLocation, imgd2_1, imgp2_1, ""); break;
				case 13:
					ShowPos (loc, dest, iLocation, imgd2_2, imgp2_2, ""); break;

				/*** second row ***/
				case 14:
					ShowPos (loc, dest, iLocation, imgd2_3, imgp2_3, ""); break;
				case 15:
					ShowPos (loc, dest, iLocation, imgd2_4, imgp2_4, ""); break;
				case 16:
					ShowPos (loc, dest, iLocation, imgd2_5, imgp2_5, ""); break;
				case 17:
					ShowPos (loc, dest, iLocation, imgd2_6, imgp2_6, ""); break;
				case 18:
					ShowPos (loc, dest, iLocation, imgd2_7, imgp2_7, ""); break;
				case 19:
					ShowPos (loc, dest, iLocation, imgd2_8, imgp2_8, ""); break;
				case 20:
					ShowPos (loc, dest, iLocation, imgd2_9, imgp2_9, ""); break;
				case 21:
					ShowPos (loc, dest, iLocation, imgd3_0, imgp3_0, ""); break;
				case 22:
					ShowPos (loc, dest, iLocation, imgd4_0, imgp4_0, ""); break;
				case 23:
					ShowPos (loc, dest, iLocation, imgd4_1, imgp4_1, ""); break;
				case 24:
					ShowPos (loc, dest, iLocation, imgd5_0, imgp5_0, ""); break;
				case 25: /*** drop button ***/
					snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
					ShowPos (loc, dest, iLocation, imgd6, imgp6, sText);
					break;
				case 26:
					ShowPos (loc, dest, iLocation, imgd7_0, imgp7_0, ""); break;

				/*** third row ***/
				case 27:
					ShowPos (loc, dest, iLocation, imgd7_1, imgp7_1, ""); break;
				case 28:
					ShowPos (loc, dest, iLocation, imgd7_2, imgp7_2, ""); break;
				case 29:
					ShowPos (loc, dest, iLocation, imgd7_3, imgp7_3, ""); break;
				case 30:
					ShowPos (loc, dest, iLocation, imgd8_0, imgp8_0, ""); break;
				case 31:
					ShowPos (loc, dest, iLocation, imgd9_0, imgp9_0, ""); break;
				case 32:
					ShowPos (loc, dest, iLocation, imgd10_0, imgp10_0, ""); break;
				case 33:
					ShowPos (loc, dest, iLocation, imgd10_1, imgp10_1, ""); break;
				case 34:
					ShowPos (loc, dest, iLocation, imgd10_2, imgp10_2, ""); break;
				case 35:
					ShowPos (loc, dest, iLocation, imgd10_3, imgp10_3, ""); break;
				case 36:
					ShowPos (loc, dest, iLocation, imgd10_4, imgp10_4, ""); break;
				case 37:
					ShowPos (loc, dest, iLocation, imgd10_5, imgp10_5, ""); break;
				case 38:
					ShowPos (loc, dest, iLocation, imgd10_6, imgp10_6, ""); break;
				case 39:
					ShowPos (loc, dest, iLocation, imgd11_0, imgp11_0, ""); break;

				/*** fourth row ***/
				case 40:
					ShowPos (loc, dest, iLocation, imgd12_0, imgp12_0, ""); break;
				case 41:
					ShowPos (loc, dest, iLocation, imgd12_1, imgp12_1, ""); break;
				case 42:
					ShowPos (loc, dest, iLocation, imgd12_2, imgp12_2, ""); break;
				case 43:
					ShowPos (loc, dest, iLocation, imgd12_3, imgp12_3, ""); break;
				case 44:
					ShowPos (loc, dest, iLocation, imgd12_4, imgp12_4, ""); break;
				case 45:
					ShowPos (loc, dest, iLocation, imgd12_5, imgp12_5, ""); break;
				case 46:
					ShowPos (loc, dest, iLocation, imgd12_6, imgp12_6, ""); break;
				case 47:
					ShowPos (loc, dest, iLocation, imgd12_3, imgp12_7, ""); break;
				case 48:
					ShowPos (loc, dest, iLocation, imgd13_0, imgp13_0, ""); break;
				case 49:
					ShowPos (loc, dest, iLocation, imgd14_0, imgp14_0, ""); break;
				case 50: /*** raise button ***/
					snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
					ShowPos (loc, dest, iLocation, imgd15, imgp15, sText);
					break;
				case 51:
					ShowPos (loc, dest, iLocation, imgd16_0, imgp16_0, ""); break;
				case 52:
					ShowPos (loc, dest, iLocation, imgd17_0, imgp17_0, ""); break;

				/*** fifth row ***/
				case 53: /*** chomper ***/
					if (iNoAnim == 0)
					{
						switch (iChomperFrameDP)
						{
							case 10: iUseSprite = 1; break;
							case 11:
								iUseSprite = 2;
								if (iChomped == 0)
								{
									if ((iNoChomp != 1) && (iLocation >= 1))
									{
										PlaySound ("wav/chomper.wav");
										iChomped = 1;
									}
								}
								break;
							case 12: iUseSprite = 3; iChomped = 0; break;
							case 13: iUseSprite = 4; break;
							default: iUseSprite = 0; break; /*** 1-9 ***/
						}
						loc.x = iUseSprite * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spritechomperd, "spritechomperd", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spritechomperp, "spritechomperp", &loc,
								screen, &dest);
						}
						if (iSelected == iLocation)
						{
							if (cCurType == 'd')
							{
								CustomRenderCopy (spritechomperdsel, "spritechomperdsel", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (spritechomperpsel, "spritechomperpsel", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd18_0, imgp18_0, "");
					}
					break;
				case 54:
					ShowPos (loc, dest, iLocation, imgd18_1, imgp18_1, ""); break;
				case 55:
					ShowPos (loc, dest, iLocation, imgd18_2, imgp18_2, ""); break;
				case 56:
					ShowPos (loc, dest, iLocation, imgd18_3, imgp18_3, ""); break;
				case 57:
					ShowPos (loc, dest, iLocation, imgd18_4, imgp18_4, ""); break;
				case 58:
					ShowPos (loc, dest, iLocation, imgd18_5, imgp18_5, ""); break;
				case 59:
					if (iNoAnim == 0)
					{
						loc.x = (iFlameFrameDP - 1) * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spriteflamed1, "spriteflamed1", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spriteflamep1, "spriteflamep1", &loc,
								screen, &dest);
						}
						if (iSelected == iLocation)
						{
							loc.x = iFromImageX * iScale;
							if (cCurType == 'd')
							{
								CustomRenderCopy (imgd19_0[2], "imgd19_0[2]", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (imgp19_0[2], "imgp19_0[2]", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd19_0, imgp19_0, "");
					}
					break;
				case 60:
					ShowPos (loc, dest, iLocation, imgd20_0, imgp20_0, ""); break;
				case 61:
					ShowPos (loc, dest, iLocation, imgd20_1, imgp20_1, ""); break;
				case 62:
					ShowPos (loc, dest, iLocation, imgd21_0, imgp21_0, ""); break;
				case 63:
					if (iNoAnim == 0)
					{
						switch (iSwordFrameDP)
						{
							case 48: iUseSprite = 1; break;
							default: iUseSprite = 0; break; /*** 1-47 ***/
						}
						loc.x = iUseSprite * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spriteswordd, "spriteswordd", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spriteswordp, "spriteswordp", &loc,
								screen, &dest);
						}
						if (iSelected == iLocation)
						{
							if (cCurType == 'd')
							{
								CustomRenderCopy (spritesworddsel, "spritesworddsel", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (spriteswordpsel, "spriteswordpsel", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd22_0, imgp22_0, "");
					}
					break;
				case 64:
					ShowPos (loc, dest, iLocation, imgd23_0, imgp23_0, ""); break;
				case 65:
					ShowPos (loc, dest, iLocation, imgd24_0, imgp24_0, ""); break;

				/*** sixth row ***/
				case 66:
					ShowPos (loc, dest, iLocation, imgd25_0, imgp25_0, ""); break;
				case 67:
					/* The game changes tapestries when the lattice top is to the left
					 * of them (to SDLPoP's res206.png). This editor, instead, visually
					 * modifies the lattice top. This is easier (multiple tapestry
					 * tiles vs. single lattice top tile).
					 */
					if ((iThingA[iCurRoom][iLocation] == 12) && /*** NOT iLoc. + 1 ***/
						(((iLocation >= 1) && (iLocation <= 9)) ||
						((iLocation >= 11) && (iLocation <= 19)) ||
						((iLocation >= 21) && (iLocation <= 29))))
					{
						ShowPos (loc, dest, iLocation, imgd26_0, imgp26_0_wl, "");
					} else {
						ShowPos (loc, dest, iLocation, imgd26_0, imgp26_0, "");
					}
					break;
				case 68:
					ShowPos (loc, dest, iLocation, imgd27_0, imgp27_0, ""); break;
				case 69:
					ShowPos (loc, dest, iLocation, imgd28_0, imgp28_0, ""); break;
				case 70:
					ShowPos (loc, dest, iLocation, imgd29_0, imgp29_0, ""); break;
				case 71:
					if (iNoAnim == 0)
					{
						loc.x = (iFlameFrameDP - 1) * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spriteflamed2, "spriteflamed2", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spriteflamep2, "spriteflamep2", &loc,
								screen, &dest);
						}
						if (iSelected == iLocation)
						{
							loc.x = iFromImageX * iScale;
							if (cCurType == 'd')
							{
								CustomRenderCopy (imgd30_0[2], "imgd30_0[2]", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (imgp30_0[2], "imgp30_0[2]", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd30_0, imgp30_0, "");
					}
					break;
				case 72:
					ShowPos (loc, dest, iLocation, imgd43_0, imgp43_0, ""); break;

				/*** native, tab 01/12 ***/
				case 10101:
					ShowPos (loc, dest, iLocation, imgd0_12, imgp0_12, "SDLPoP"); break;
				case 10102:
					ShowPos (loc, dest, iLocation, imgd0_4, imgp0_4, "SDLPoP"); break;
				case 10103:
					ShowPos (loc, dest, iLocation, imgd0_13, imgp0_13, "SDLPoP"); break;
				case 10104:
					ShowPos (loc, dest, iLocation, imgd0_5, imgp0_5, "SDLPoP"); break;
				case 10105:
					ShowPos (loc, dest, iLocation, imgd1_6, imgp1_6, "SDLPoP"); break;
				case 10106:
					ShowPos (loc, dest, iLocation, imgd1_14, imgp1_14, "SDLPoP"); break;
				case 10107:
					ShowPos (loc, dest, iLocation, imgd1_13, imgp1_13, "SDLPoP"); break;
				case 10108:
					ShowPos (loc, dest, iLocation, imgd1_5, imgp1_5, "SDLPoP"); break;
				case 10109:
					ShowPos (loc, dest, iLocation, imgd20_6, imgp20_6, "SDLPoP"); break;
				case 10110:
					ShowPos (loc, dest, iLocation, imgd20_14, imgp20_14, "SDLPoP"); break;
				case 10111:
					ShowPos (loc, dest, iLocation, imgd20_12, imgp20_12, "SDLPoP"); break;
				case 10112:
					ShowPos (loc, dest, iLocation, imgd20_4, imgp20_4, "SDLPoP"); break;
				/***/
				case 10141:
					ShowPos (loc, dest, iLocation, imgd0_50, imgp0_50, "SDLPoP"); break;
				case 10142:
					ShowPos (loc, dest, iLocation, imgd0_51, imgp0_51, "SDLPoP"); break;
				case 10143:
					ShowPos (loc, dest, iLocation, imgd0_52, imgp0_52, "SDLPoP"); break;
				case 10144:
					ShowPos (loc, dest, iLocation, imgd0_53, imgp0_53, "SDLPoP"); break;
				case 10145:
					ShowPos (loc, dest, iLocation, imgd1_50, imgp1_50, "SDLPoP"); break;
				case 10146:
					ShowPos (loc, dest, iLocation, imgd1_51, imgp1_51, "SDLPoP"); break;
				case 10147:
					ShowPos (loc, dest, iLocation, imgd1_52, imgp1_52, "SDLPoP"); break;
				case 10148:
					ShowPos (loc, dest, iLocation, imgd1_53, imgp1_53, "SDLPoP"); break;

				/*** native, tab 02/12 ***/
				case 10201:
					if (iNoAnim == 0)
					{
						loc.x = (iFlameFrameDP - 1) * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spriteflamed3, "spriteflamed3", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spriteflamep3, "spriteflamep3", &loc,
								screen, &dest);
						}
						ShowImageBasic (imgnative_s, dest.x + 22, dest.y + 32,
							"imgnative_s", ascreen, iScale, 1);
						ShowImageBasic (six_bit_rgb[(iModifier[0] & 0x3F)], dest.x + 90,
							dest.y + 48, "six_bit_rgb[...]", ascreen, iScale, 1);
						if (iSelected == iLocation)
						{
							loc.x = iFromImageX * iScale;
							if (cCurType == 'd')
							{
								CustomRenderCopy (imgd19[2], "imgd19[2]", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (imgp19[2], "imgp19[2]", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd19, imgp19, "SDLPoP");
						ShowImageBasic (six_bit_rgb[(iModifier[0] & 0x3F)], dest.x + 90,
							dest.y + 48, "six_bit_rgb[...]", ascreen, iScale, 1);
					}
					break;
				case 10202:
					if (iNoAnim == 0)
					{
						loc.x = (iFlameFrameDP - 1) * 120;
						if (cCurType == 'd')
						{
							CustomRenderCopy (spriteflamed4, "spriteflamed4", &loc,
								screen, &dest);
						} else {
							CustomRenderCopy (spriteflamep4, "spriteflamep4", &loc,
								screen, &dest);
						}
						ShowImageBasic (imgnative_s, dest.x + 22, dest.y + 32,
							"imgnative_s", ascreen, iScale, 1);
						ShowImageBasic (six_bit_rgb[(iModifier[0] & 0x3F)], dest.x + 90,
							dest.y + 48, "six_bit_rgb[...]", ascreen, iScale, 1);
						if (iSelected == iLocation)
						{
							loc.x = iFromImageX * iScale;
							if (cCurType == 'd')
							{
								CustomRenderCopy (imgd30[2], "imgd30[2]", &loc,
									screen, &dest);
							} else {
								CustomRenderCopy (imgp30[2], "imgp30[2]", &loc,
									screen, &dest);
							}
						}
						iPosShown = 1;
					} else {
						ShowPos (loc, dest, iLocation, imgd30, imgp30, "SDLPoP");
						ShowImageBasic (six_bit_rgb[(iModifier[0] & 0x3F)], dest.x + 90,
							dest.y + 48, "six_bit_rgb[...]", ascreen, iScale, 1);
					}
					break;

				/*** native, tab 03/12 ***/
				case 10301:
					ShowPos (loc, dest, iLocation, imgd23, imgp23, "SDLPoP");
					snprintf (sText, MAX_TEXT, "T:%i", iModifier[0]);
					DisplayTextLine (dest.x + 7, dest.y + 145 - FONT_SIZE_11,
						sText, font2, color_bl, color_wh, 0);
					break;
				case 10302:
					ShowPos (loc, dest, iLocation, imgd24, imgp24, "SDLPoP"); break;
			}
		}

		if (iEditPoP == 2)
		{
			switch (cCurType)
			{
				case 'o':
					if (iThing == 0)
						ShowPosPoP2 (loc, dest, iLocation, imgo0, "");
					if (iThing == 1)
						ShowPosPoP2 (loc, dest, iLocation, imgo1, "");
					if (iThing == 2)
						ShowPosPoP2 (loc, dest, iLocation, imgo2, "");
					if (iThing == 3)
						ShowPosPoP2 (loc, dest, iLocation, imgo3, "");
					if (iThing == 4)
					{
						snprintf (sText, MAX_TEXT, "%i%%", ModAsPercent (iModifier[0], 4));
						ShowPosPoP2 (loc, dest, iLocation, imgo4, sText);
					}
					if (iThing == 5) /*** raise button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgo5, sText);
					}
					if (iThing == 6) /*** drop button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgo6, sText);
					}
					if ((iThing == 7) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgo7_0, "");
					if ((iThing == 7) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgo7_1, "");
					if ((iThing == 7) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgo7_2, "");
					if ((iThing == 7) && (iModifier[0] == 3))
						ShowPosPoP2 (loc, dest, iLocation, imgo7_3, "");
					if (iThing == 8)
						ShowPosPoP2 (loc, dest, iLocation, imgo8, "");
					if (iThing == 9)
						ShowPosPoP2 (loc, dest, iLocation, imgo9, "");
					if ((iThing == 10) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_0, "");
					if ((iThing == 10) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_32, "");
					if ((iThing == 10) && (iModifier[0] >= 64) && (iModifier[0] <= 95))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_64, "");
					if ((iThing == 10) && (iModifier[0] >= 96) && (iModifier[0] <= 127))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_96, "");
					if ((iThing == 10) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_128, "");
					if ((iThing == 10) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_160, "");
					if ((iThing == 10) && (iModifier[0] >= 192) && (iModifier[0] <= 223))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_192, "");
					if ((iThing == 10) && (iModifier[0] >= 224) && (iModifier[0] <= 255))
						ShowPosPoP2 (loc, dest, iLocation, imgo10_224, "");
					if (iThing == 11)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							snprintf (sText, MAX_TEXT, "J:%i", ModAsJumps (iModifier[0]));
						} else {
							snprintf (sText, MAX_TEXT, "J:%i|F:%i",
								ModAsJumps (iModifier[0]), ModAsFrame (iModifier[0]));
						}
						ShowPosPoP2 (loc, dest, iLocation, imgo11, sText);
					}
					if (iThing == 12)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgo12, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgo12, sText);
						}
					}
					if (iThing == 13)
						ShowPosPoP2 (loc, dest, iLocation, imgo13, "");
					if (iThing == 14)
						ShowPosPoP2 (loc, dest, iLocation, imgo14, "");
					if (iThing == 15)
						ShowPosPoP2 (loc, dest, iLocation, imgo15, "");
					if (iThing == 16)
						ShowPosPoP2 (loc, dest, iLocation, imgo16, "");
					if (iThing == 17)
					{
						snprintf (sText, MAX_TEXT, "%i%%",
							ModAsPercent (iModifier[0], 17));
						ShowPosPoP2 (loc, dest, iLocation, imgo17, sText);
					}
					if (iThing == 18)
						ShowPosPoP2 (loc, dest, iLocation, imgo18, "");
					if (iThing == 19)
						ShowPosPoP2 (loc, dest, iLocation, imgo19, "");
					if (iThing == 20)
						ShowPosPoP2 (loc, dest, iLocation, imgo20, "");
					if (iThing == 21)
						ShowPosPoP2 (loc, dest, iLocation, imgo21, "");
					if ((iThing == 22) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgo22_0, "");
					if ((iThing == 22) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgo22_1, "");
					if (iThing == 23)
						ShowPosPoP2 (loc, dest, iLocation, imgo23, "");
					if (iThing == 24)
						ShowPosPoP2 (loc, dest, iLocation, imgo24, "");
					if (iThing == 25)
						ShowPosPoP2 (loc, dest, iLocation, imgo25, "");
					if (iThing == 26)
						ShowPosPoP2 (loc, dest, iLocation, imgo26, "");
					if (iThing == 27)
						ShowPosPoP2 (loc, dest, iLocation, imgo27, "");
					if (iThing == 28)
						ShowPosPoP2 (loc, dest, iLocation, imgo28, "");
					if (iThing == 29)
						ShowPosPoP2 (loc, dest, iLocation, imgo29, "");
					if (iThing == 30)
						ShowPosPoP2 (loc, dest, iLocation, imgo30, "");
					if (iThing == 31)
						ShowPosPoP2 (loc, dest, iLocation, imgo31, "");
					if (iThing == 32)
						ShowPosPoP2 (loc, dest, iLocation, imgo32, "");
					if (iThing == 33)
						ShowPosPoP2 (loc, dest, iLocation, imgo33, "");
					if (iThing == 34) /*** raise drop ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgo34, sText);
					}
					if (iThing == 35)
						ShowPosPoP2 (loc, dest, iLocation, imgo35, "");
					if (iThing == 36)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgo36, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgo36, sText);
						}
					}
					if (iThing == 37)
						ShowPosPoP2 (loc, dest, iLocation, imgo37, "");
					if (iThing == 38)
						ShowPosPoP2 (loc, dest, iLocation, imgo38, "");
					if (iThing == 39)
						ShowPosPoP2 (loc, dest, iLocation, imgo39, "");
					if (iThing == 40)
						ShowPosPoP2 (loc, dest, iLocation, imgo40, "");
					if (iThing == 41)
						ShowPosPoP2 (loc, dest, iLocation, imgo41, "");
					if (iThing == 43)
						ShowPosPoP2 (loc, dest, iLocation, imgo43, "");
					if (iThing == 44)
						ShowPosPoP2 (loc, dest, iLocation, imgo44, "");
					break;
				case 'c':
					if ((iThing == 0) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc0_0, "");
					if ((iThing == 0) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgc0_1, "");
					if ((iThing == 0) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgc0_2, "");
					if ((iThing == 0) && (iModifier[0] == 3))
						ShowPosPoP2 (loc, dest, iLocation, imgc0_3, "");
					if ((iThing == 0) && (iModifier[0] == 4))
						ShowPosPoP2 (loc, dest, iLocation, imgc0_4, "");
					if ((iThing == 1) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc1_0, "");
					if ((iThing == 1) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgc1_1, "");
					if ((iThing == 1) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgc1_2, "");
					if ((iThing == 2) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc2_0, "");
					if ((iThing == 2) && (iModifier[0] == 5))
						ShowPosPoP2 (loc, dest, iLocation, imgc2_5, "");
					if (iThing == 3)
						ShowPosPoP2 (loc, dest, iLocation, imgc3, "");
					if ((iThing == 4) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc4_0, "");
					if ((iThing == 4) && (iModifier[0] != 0) && (iModifier[0] != 200))
					{
						snprintf (sText, MAX_TEXT, "%i%%", ModAsPercent (iModifier[0], 4));
						ShowPosPoP2 (loc, dest, iLocation, imgc4_100, sText);
					}
					if ((iThing == 4) && (iModifier[0] == 200))
						ShowPosPoP2 (loc, dest, iLocation, imgc4_200, "");
					if ((iThing == 8) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc8_0, "");
					if ((iThing == 8) && ((iModifier[0] == 1) || (iModifier[0] == 5)))
						ShowPosPoP2 (loc, dest, iLocation, imgc8_1, "");
					if ((iThing == 8) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgc8_2, "");
					if (iThing == 9)
						ShowPosPoP2 (loc, dest, iLocation, imgc9, "");
					if ((iThing == 10) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_0, "");
					if ((iThing == 10) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_32, "");
					if ((iThing == 10) && (iModifier[0] >= 64) && (iModifier[0] <= 95))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_64, "");
					if ((iThing == 10) && (iModifier[0] >= 96) && (iModifier[0] <= 127))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_96, "");
					if ((iThing == 10) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_128, "");
					if ((iThing == 10) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_160, "");
					if ((iThing == 10) && (iModifier[0] >= 192) && (iModifier[0] <= 223))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_192, "");
					if ((iThing == 10) && (iModifier[0] >= 224) && (iModifier[0] <= 255))
						ShowPosPoP2 (loc, dest, iLocation, imgc10_224, "");
					if ((iThing == 11) && (iModifier[0] >= 0) && (iModifier[0] <= 127))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							snprintf (sText, MAX_TEXT, "J:%i", ModAsJumps (iModifier[0]));
						} else {
							snprintf (sText, MAX_TEXT, "J:%i|F:%i",
								ModAsJumps (iModifier[0]), ModAsFrame (iModifier[0]));
						}
						ShowPosPoP2 (loc, dest, iLocation, imgc11_0, sText);
					}
					if ((iThing == 11) && (iModifier[0] >= 128) && (iModifier[0] <= 255))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							snprintf (sText, MAX_TEXT, "J:%i", ModAsJumps (iModifier[0]));
						} else {
							snprintf (sText, MAX_TEXT, "J:%i|F:%i",
								ModAsJumps (iModifier[0]), ModAsFrame (iModifier[0]));
						}
						ShowPosPoP2 (loc, dest, iLocation, imgc11_128, sText);
					}
					if ((iThing == 14) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc14_0, "");
					if ((iThing == 14) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgc14_1, "");
					if ((iThing == 14) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgc14_2, "");
					if (iThing == 16)
						ShowPosPoP2 (loc, dest, iLocation, imgc16, "");
					if ((iThing == 17) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc17_0, "");
					if ((iThing == 17) && (iModifier[0] != 0) && (iModifier[0] != 42))
					{
						snprintf (sText, MAX_TEXT, "%i%%",
							ModAsPercent (iModifier[0], 17));
						ShowPosPoP2 (loc, dest, iLocation, imgc17_21, sText);
					}
					if ((iThing == 17) && (iModifier[0] == 42))
						ShowPosPoP2 (loc, dest, iLocation, imgc17_42, "");
					if (iThing == 18)
						ShowPosPoP2 (loc, dest, iLocation, imgc18, "");
					if (iThing == 19)
					{
						if (iNoAnim == 0)
						{
							loc.x = (iFlameFrameC - 1) * 116;
							CustomRenderCopy (spriteflamec1, "spriteflamec1", &loc,
								screen, &dest);
							if (iSelected == iLocation)
							{
								loc.x = iFromImageX * iScale;
								CustomRenderCopy (imgc19[2], "imgc19[2]", &loc,
									screen, &dest);
							}
							iPosShown = 1;
						} else {
							ShowPosPoP2 (loc, dest, iLocation, imgc19, "");
						}
					}
					if ((iThing == 20) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_0, "");
					if ((iThing == 20) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_1, "");
					if ((iThing == 20) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_2, "");
					if ((iThing == 20) && (iModifier[0] == 3))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_3, "");
					if ((iThing == 20) && (iModifier[0] == 4))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_4, "");
					if ((iThing == 20) && (iModifier[0] == 5))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_5, "");
					if ((iThing == 20) && (iModifier[0] == 6))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_6, "");
					if ((iThing == 20) && (iModifier[0] == 7))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_7, "");
					if ((iThing == 20) && (iModifier[0] == 8))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_8, "");
					if ((iThing == 20) && (iModifier[0] == 9))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_9, "");
					if ((iThing == 20) && (iModifier[0] == 10))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_10, "");
					if ((iThing == 20) && (iModifier[0] == 128))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_128, "");
					if ((iThing == 20) && (iModifier[0] == 129))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_129, "");
					if ((iThing == 20) && (iModifier[0] == 130))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_130, "");
					if ((iThing == 20) && (iModifier[0] == 131))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_131, "");
					if ((iThing == 20) && (iModifier[0] == 132))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_132, "");
					if ((iThing == 20) && (iModifier[0] == 133))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_133, "");
					if ((iThing == 20) && (iModifier[0] == 134))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_134, "");
					if ((iThing == 20) && (iModifier[0] == 135))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_135, "");
					if ((iThing == 20) && (iModifier[0] == 136))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_136, "");
					if ((iThing == 20) && (iModifier[0] == 137))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_137, "");
					if ((iThing == 20) && (iModifier[0] == 138))
						ShowPosPoP2 (loc, dest, iLocation, imgc20_138, "");
					if (iThing == 23)
						ShowPosPoP2 (loc, dest, iLocation, imgc23, "");
					if (iThing == 24)
						ShowPosPoP2 (loc, dest, iLocation, imgc24, "");
					if (iThing == 28)
						ShowPosPoP2 (loc, dest, iLocation, imgc28, "");
					if (iThing == 32)
					{
						if (iNoAnim == 0)
						{
							loc.x = (iFlameFrameC - 1) * 116;
							CustomRenderCopy (spriteflamec2, "spriteflamec2", &loc,
								screen, &dest);
							if (iSelected == iLocation)
							{
								loc.x = iFromImageX * iScale;
								CustomRenderCopy (imgc32[2], "imgc32[2]", &loc,
									screen, &dest);
							}
							iPosShown = 1;
						} else {
							ShowPosPoP2 (loc, dest, iLocation, imgc32, "");
						}
					}
					if (iThing == 33)
						ShowPosPoP2 (loc, dest, iLocation, imgc33, "");
					if ((iThing == 34) && (iModifier[1] % 16 >= 0) &&
						(iModifier[1] % 16 <= 7)) /*** raise drop (reg) ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgc34_E_0, sText);
					}
					if ((iThing == 34) && (iModifier[1] % 16 >= 8) &&
						(iModifier[1] % 16 <= 15)) /*** raise drop (down) ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgc34_E_8, sText);
					}
					if (iThing == 35)
						ShowPosPoP2 (loc, dest, iLocation, imgc35, "");
					if (iThing == 36)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgc36, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgc36, sText);
						}
					}
					if (iThing == 44)
						ShowPosPoP2 (loc, dest, iLocation, imgc44, "");

					/*** stalactites ***/
					if ((iThing == 0) || (iThing == 1) || (iThing == 3) ||
						(iThing == 4) || (iThing == 8) || (iThing == 9) ||
						(iThing == 10) || (iThing == 16) || (iThing == 17) ||
						(iThing == 19) || (iThing == 23) || (iThing == 24) ||
						(iThing == 32) || (iThing == 33) || (iThing == 35) ||
						(iThing == 36))
					{
						if ((iModifier[1] >= 8) && (iModifier[1] <= 15))
						{
							ShowImage (-15, (int[]){0, 8, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 16) && (iModifier[1] <= 23))
						{
							ShowImage (-15, (int[]){0, 16, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 24) && (iModifier[1] <= 31))
						{
							ShowImage (-15, (int[]){0, 24, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 32) && (iModifier[1] <= 39))
						{
							ShowImage (-15, (int[]){0, 32, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 40) && (iModifier[1] <= 47))
						{
							ShowImage (-15, (int[]){0, 40, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 48) && (iModifier[1] <= 55))
						{
							ShowImage (-15, (int[]){0, 48, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
						if ((iModifier[1] >= 56) && (iModifier[1] <= 63))
						{
							ShowImage (-15, (int[]){0, 56, 0, 0}, screen,
								iLocation, 0, 0, 116, 164);
						}
					}

					/*** bottoms ***/
					if ((iThing == 1) || (iThing == 2) || (iThing == 3) ||
						(iThing == 4) || (iThing == 8) || (iThing == 10) ||
						(iThing == 11) || (iThing == 14) || (iThing == 16) ||
						(iThing == 17) || (iThing == 19) || (iThing == 20) ||
						(iThing == 23) || (iThing == 24) || (iThing == 32) ||
						(iThing == 34) || (iThing == 36))
					{
						switch (iModifier[1] % 8)
						{
							case 0: break; /*** no bottom ***/
							case 1:
								ShowImage (-15, (int[]){1, 1, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 2:
								ShowImage (-15, (int[]){1, 2, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 3:
								ShowImage (-15, (int[]){1, 3, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 4:
								ShowImage (-15, (int[]){1, 4, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 5:
								ShowImage (-15, (int[]){1, 5, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 6:
								ShowImage (-15, (int[]){1, 6, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
							case 7:
								ShowImage (-15, (int[]){1, 7, 0, 0}, screen,
									iLocation, 0, 0, 116, 164); break;
						}
					}
					break;
				case 'r':
					if (iThing == 0)
						ShowPosPoP2 (loc, dest, iLocation, imgr0, "");
					if ((iThing == 1) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr1_0, "");
					if ((iThing == 1) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgr1_1, "");
					if ((iThing == 1) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgr1_2, "");
					if ((iThing == 1) && (iModifier[0] == 3))
						ShowPosPoP2 (loc, dest, iLocation, imgr1_3, "");
					if (iThing == 2)
						ShowPosPoP2 (loc, dest, iLocation, imgr2, "");
					if ((iThing == 3) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr3_0, "");
					if ((iThing == 3) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgr3_1, "");
					if ((iThing == 3) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgr3_2, "");
					if ((iThing == 4) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr4_0, "");
					if ((iThing == 4) && (iModifier[0] != 0) && (iModifier[0] != 200))
					{
						snprintf (sText, MAX_TEXT, "%i%%", ModAsPercent (iModifier[0], 4));
						ShowPosPoP2 (loc, dest, iLocation, imgr4_100, sText);
					}
					if ((iThing == 4) && (iModifier[0] == 200))
						ShowPosPoP2 (loc, dest, iLocation, imgr4_200, "");
					if ((iThing == 5) && (iModifier[1] == 0)) /*** raise button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgr5_E_0, sText);
					}
					if ((iThing == 5) && (iModifier[1] == 8)) /*** raise button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgr5_E_8, sText);
					}
					if ((iThing == 6) && (iModifier[1] == 0)) /*** drop button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgr6_E_0, sText);
					}
					if ((iThing == 6) && (iModifier[1] == 8)) /*** drop button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgr6_E_8, sText);
					}
					if ((iThing == 7) && ((iModifier[0] == 0) || (iModifier[0] == 128)))
						ShowPosPoP2 (loc, dest, iLocation, imgr7_0, "");
					if ((iThing == 7) && ((iModifier[0] == 1) || (iModifier[0] == 129)))
						ShowPosPoP2 (loc, dest, iLocation, imgr7_1, "");
					if ((iThing == 7) && ((iModifier[0] == 2) || (iModifier[0] == 130)))
						ShowPosPoP2 (loc, dest, iLocation, imgr7_2, "");
					if ((iThing == 7) && ((iModifier[0] == 3) || (iModifier[0] == 131)))
						ShowPosPoP2 (loc, dest, iLocation, imgr7_3, "");
					if (iThing == 8)
						ShowPosPoP2 (loc, dest, iLocation, imgr8, "");
					if (iThing == 9)
						ShowPosPoP2 (loc, dest, iLocation, imgr9, "");
					if ((iThing == 10) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_0, "");
					if ((iThing == 10) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_32, "");
					if ((iThing == 10) && (iModifier[0] >= 64) && (iModifier[0] <= 95))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_64, "");
					if ((iThing == 10) && (iModifier[0] >= 96) && (iModifier[0] <= 127))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_96, "");
					if ((iThing == 10) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_128, "");
					if ((iThing == 10) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_160, "");
					if ((iThing == 10) && (iModifier[0] >= 192) && (iModifier[0] <= 223))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_192, "");
					if ((iThing == 10) && (iModifier[0] >= 224) && (iModifier[0] <= 255))
						ShowPosPoP2 (loc, dest, iLocation, imgr10_224, "");
					if (iThing == 11)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							snprintf (sText, MAX_TEXT, "J:%i", ModAsJumps (iModifier[0]));
						} else {
							snprintf (sText, MAX_TEXT, "J:%i|F:%i",
								ModAsJumps (iModifier[0]), ModAsFrame (iModifier[0]));
						}
						ShowPosPoP2 (loc, dest, iLocation, imgr11, sText);
					}
					if ((iThing == 12) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgr12_0, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgr12_0, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgr12_32, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgr12_32, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgr12_128, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgr12_128, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgr12_160, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgr12_160, sText);
						}
					}
					if ((iThing == 13) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr13_0, "");
					if ((iThing == 13) && (iModifier[0] == 32))
						ShowPosPoP2 (loc, dest, iLocation, imgr13_32, "");
					if ((iThing == 14) && (iModifier[0] == 16))
						ShowPosPoP2 (loc, dest, iLocation, imgr14_16, "");
					if ((iThing == 14) && (iModifier[0] == 32))
						ShowPosPoP2 (loc, dest, iLocation, imgr14_32, "");
					if ((iThing == 14) && (iModifier[0] == 64))
						ShowPosPoP2 (loc, dest, iLocation, imgr14_64, "");
					if ((iThing == 15) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr15_0, "");
					if ((iThing == 15) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgr15_1, "");
					if ((iThing == 15) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgr15_2, "");
					if ((iThing == 15) && (iModifier[0] == 3))
						ShowPosPoP2 (loc, dest, iLocation, imgr15_3, "");
					if (iThing == 16)
						ShowPosPoP2 (loc, dest, iLocation, imgr16, "");
					if ((iThing == 17) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr17_0, "");
					if ((iThing == 17) && (iModifier[0] != 0) && (iModifier[0] != 42))
					{
						snprintf (sText, MAX_TEXT, "%i%%",
							ModAsPercent (iModifier[0], 17));
						ShowPosPoP2 (loc, dest, iLocation, imgr17_21, sText);
					}
					if ((iThing == 17) && (iModifier[0] == 42))
						ShowPosPoP2 (loc, dest, iLocation, imgr17_42, "");
					if (iThing == 18)
						ShowPosPoP2 (loc, dest, iLocation, imgr18, "");
					if ((iThing == 20) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_0, "");
					if ((iThing == 20) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_1, "");
					if ((iThing == 20) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_2, "");
					if ((iThing == 20) && (iModifier[0] == 4))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_4, "");
					if ((iThing == 20) && (iModifier[0] == 5))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_5, "");
					if ((iThing == 20) && (iModifier[0] == 6))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_6, "");
					if ((iThing == 20) && (iModifier[0] == 8))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_8, "");
					if ((iThing == 20) && (iModifier[0] == 9))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_9, "");
					if ((iThing == 20) && (iModifier[0] == 10))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_10, "");
					if ((iThing == 20) && (iModifier[0] == 12))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_12, "");
					if ((iThing == 20) && (iModifier[0] == 13))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_13, "");
					if ((iThing == 20) && (iModifier[0] == 14))
						ShowPosPoP2 (loc, dest, iLocation, imgr20_14, "");
					if (iThing == 21)
						ShowPosPoP2 (loc, dest, iLocation, imgr21, "");
					if ((iThing == 22) && (iModifier[0] != 2)) /*** big sword ***/
						ShowPosPoP2 (loc, dest, iLocation, imgr22_1, "");
					if ((iThing == 22) && (iModifier[0] == 2)) /*** small sword ***/
						ShowPosPoP2 (loc, dest, iLocation, imgr22_2, "");

					/*** symbols ***/
					if ((iThing == 0) || (iThing == 1) || (iThing == 3) ||
						(iThing == 4) || (iThing == 7) || (iThing == 10) ||
						(iThing == 11) || (iThing == 12) || (iThing == 13) ||
						(iThing == 14) || (iThing == 15) || (iThing == 16) ||
						(iThing == 17) || (iThing == 20) || (iThing == 21) ||
						(iThing == 22))
					{
						if ((iModifier[1] >= 16) && (iModifier[1] <= 31))
						{
							ShowImage (-15, (int[]){3, 16, -54, -38}, screen,
								iLocation, 0, 0, 182, 254);
						}
						if ((iModifier[1] >= 32) && (iModifier[1] <= 47))
						{
							ShowImage (-15, (int[]){3, 32, -54, -38}, screen,
								iLocation, 0, 0, 182, 254);
						}
						if ((iModifier[1] >= 48) && (iModifier[1] <= 63))
						{
							ShowImage (-15, (int[]){3, 48, -54, -38}, screen,
								iLocation, 0, 0, 182, 254);
						}
					}

					/*** cracks ***/
					if ((iThing == 0) || (iThing == 1) || (iThing == 3) ||
						(iThing == 4) || (iThing == 7) || (iThing == 8) ||
						(iThing == 9) || (iThing == 10) || (iThing == 11) ||
						(iThing == 12) || (iThing == 13) || (iThing == 14) ||
						(iThing == 15) || (iThing == 16) || (iThing == 20) ||
						(iThing == 21) || (iThing == 22))
					{
						switch (iModifier[1] % 16)
						{
							case 0: break; /*** no crack ***/
							case 1:
								ShowImage (-15, (int[]){2, 1, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 2: break; /*** no crack ***/
							case 3:
								ShowImage (-15, (int[]){2, 3, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 4:
								ShowImage (-15, (int[]){2, 4, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 5:
								ShowImage (-15, (int[]){2, 5, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 6:
								ShowImage (-15, (int[]){2, 6, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 7:
								ShowImage (-15, (int[]){2, 7, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 8:
								ShowImage (-15, (int[]){2, 8, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 9:
								ShowImage (-15, (int[]){2, 9, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 10:
								ShowImage (-15, (int[]){2, 10, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 11:
								ShowImage (-15, (int[]){2, 11, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 12:
								ShowImage (-15, (int[]){2, 12, -54, -38}, screen,
									iLocation, 0, 0, 182, 254); break;
							case 13: case 14: case 15: break; /*** no crack ***/
						}
					}

					break;
				case 't':
					if (iThing == 0)
						ShowPosPoP2 (loc, dest, iLocation, imgt0, "");
					if ((iThing == 1) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt1_0, "");
					if ((iThing == 1) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgt1_1, "");
					if ((iThing == 2) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt2_0, "");
					if ((iThing == 2) && (iModifier[0] == 5))
						ShowPosPoP2 (loc, dest, iLocation, imgt2_5, "");
					if ((iThing == 3) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt3_0, "");
					if ((iThing == 3) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgt3_1, "");
					if ((iThing == 3) && (iModifier[0] == 2))
						ShowPosPoP2 (loc, dest, iLocation, imgt18, ""); /*** inv. tile ***/
					if ((iThing == 4) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt4_0, "");
					if ((iThing == 4) && (iModifier[0] != 0) && (iModifier[0] != 200))
					{
						snprintf (sText, MAX_TEXT, "%i%%", ModAsPercent (iModifier[0], 4));
						ShowPosPoP2 (loc, dest, iLocation, imgt4_100, sText);
					}
					if ((iThing == 4) && (iModifier[0] == 200))
						ShowPosPoP2 (loc, dest, iLocation, imgt4_200, "");
					if ((iThing == 5) && (iModifier[1] == 0)) /*** raise button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgt5_E_0, sText);
					}
					if ((iThing == 5) && (iModifier[1] == 8)) /*** raise button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgt5_E_8, sText);
					}
					if ((iThing == 6) && (iModifier[1] == 0)) /*** drop button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgt6_E_0, sText);
					}
					if ((iThing == 6) && (iModifier[1] == 8)) /*** drop button ***/
					{
						snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
						ShowPosPoP2 (loc, dest, iLocation, imgt6_E_8, sText);
					}
					if (iThing == 8)
						ShowPosPoP2 (loc, dest, iLocation, imgt8, "");
					if (iThing == 9)
						ShowPosPoP2 (loc, dest, iLocation, imgt9, "");
					if ((iThing == 10) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_0, "");
					if ((iThing == 10) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_32, "");
					if ((iThing == 10) && (iModifier[0] >= 64) && (iModifier[0] <= 95))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_64, "");
					if ((iThing == 10) && (iModifier[0] >= 96) && (iModifier[0] <= 127))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_96, "");
					if ((iThing == 10) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_128, "");
					if ((iThing == 10) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_160, "");
					if ((iThing == 10) && (iModifier[0] >= 192) && (iModifier[0] <= 223))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_192, "");
					if ((iThing == 10) && (iModifier[0] >= 224) && (iModifier[0] <= 255))
						ShowPosPoP2 (loc, dest, iLocation, imgt10_224, "");
					if (iThing == 11)
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							snprintf (sText, MAX_TEXT, "J:%i", ModAsJumps (iModifier[0]));
						} else {
							snprintf (sText, MAX_TEXT, "J:%i|F:%i",
								ModAsJumps (iModifier[0]), ModAsFrame (iModifier[0]));
						}
						ShowPosPoP2 (loc, dest, iLocation, imgt11, sText);
					}
					if ((iThing == 12) && (iModifier[0] >= 0) && (iModifier[0] <= 31))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgt12_0, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgt12_0, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 32) && (iModifier[0] <= 63))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgt12_32, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgt12_32, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 128) && (iModifier[0] <= 159))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgt12_128, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgt12_128, sText);
						}
					}
					if ((iThing == 12) && (iModifier[0] >= 160) && (iModifier[0] <= 191))
					{
						if (ModAsFrame (iModifier[0]) == 0)
						{
							ShowPosPoP2 (loc, dest, iLocation, imgt12_160, "");
						} else {
							snprintf (sText, MAX_TEXT, "F:%i", ModAsFrame (iModifier[0]));
							ShowPosPoP2 (loc, dest, iLocation, imgt12_160, sText);
						}
					}
					if ((iThing == 13) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt13_0, "");
					if ((iThing == 13) && (iModifier[0] == 32))
						ShowPosPoP2 (loc, dest, iLocation, imgt13_32, "");
					if ((iThing == 14) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt14_0, "");
					if ((iThing == 14) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgt14_1, "");
					if (iThing == 16)
						ShowPosPoP2 (loc, dest, iLocation, imgt16, "");
					if ((iThing == 17) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt17_0, "");
					if ((iThing == 17) && (iModifier[0] != 0) && (iModifier[0] != 42))
					{
						snprintf (sText, MAX_TEXT, "%i%%",
							ModAsPercent (iModifier[0], 17));
						ShowPosPoP2 (loc, dest, iLocation, imgt17_21, sText);
					}
					if ((iThing == 17) && (iModifier[0] == 42))
						ShowPosPoP2 (loc, dest, iLocation, imgt17_42, "");
					if (iThing == 18)
						ShowPosPoP2 (loc, dest, iLocation, imgt18, "");
					if (iThing == 19)
					{
						if (iNoAnim == 0)
						{
							loc.x = (iFlameFrameT - 1) * 116;
							CustomRenderCopy (spriteflamet1, "spriteflamet1", &loc,
								screen, &dest);
							if (iSelected == iLocation)
							{
								loc.x = iFromImageX * iScale;
								CustomRenderCopy (imgt19[2], "imgt19[2]", &loc,
									screen, &dest);
							}
							iPosShown = 1;
						} else {
							ShowPosPoP2 (loc, dest, iLocation, imgt19, "");
						}
					}
					if ((iThing == 20) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt20_0, "");
					if ((iThing == 20) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgt20_1, "");
					if ((iThing == 20) && ((iModifier[0] == 2) || (iModifier[0] == 3)))
						ShowPosPoP2 (loc, dest, iLocation, imgt20_2, "");
					if ((iThing == 25) && (iModifier[0] == 0))
						ShowPosPoP2 (loc, dest, iLocation, imgt25_0, "");
					if ((iThing == 25) && (iModifier[0] == 1))
						ShowPosPoP2 (loc, dest, iLocation, imgt25_1, "");
					if ((iThing == 25) && ((iModifier[0] == 2) || (iModifier[0] == 3)))
						ShowPosPoP2 (loc, dest, iLocation, imgt25_2, "");
					if (iThing == 26)
						ShowPosPoP2 (loc, dest, iLocation, imgt26, "");
					if (iThing == 32)
					{
						if (iNoAnim == 0)
						{
							loc.x = (iFlameFrameT - 1) * 116;
							CustomRenderCopy (spriteflamet2, "spriteflamet2", &loc,
								screen, &dest);
							if (iSelected == iLocation)
							{
								loc.x = iFromImageX * iScale;
								CustomRenderCopy (imgt32[2], "imgt32[2]", &loc,
									screen, &dest);
							}
							iPosShown = 1;
						} else {
							ShowPosPoP2 (loc, dest, iLocation, imgt32, "");
						}
					}
					break;
			}
		}

		if (iEditPoP == 3)
		{
			switch (iThing)
			{
				case 255: /*** For nonexistent rooms, on the left. ***/
					snprintf (sBlock, 20, "%02x_%02x_%02x_%02x", arSpecial255[0],
						arSpecial255[1], arSpecial255[2], arSpecial255[3]);
					iType = arSpecial255[2];
					break;
				case 998: /*** event target ***/
					iTargetRoom = EventInfo (iChangeEvent, 1);
					iTargetTile = EventInfo (iChangeEvent, 2) - 1;
					snprintf (sBlock, 20, "%02x_%02x_%02x_%02x",
						iBlock1A[iTargetRoom][iTargetTile],
						iBlock2A[iTargetRoom][iTargetTile],
						iBlock3A[iTargetRoom][iTargetTile],
						iBlock4A[iTargetRoom][iTargetTile]);
					iType = iBlock3A[iTargetRoom][iTargetTile];
					break;
				case 999: /*** current custom ***/
					snprintf (sBlock, 20, "%02x_%02x_%02x_%02x", iChangeBlock[1],
						iChangeBlock[2], iChangeBlock[3], iChangeBlock[4]);
					iType = iChangeBlock[3];
					break;
				default:
					iType = Block (iRoom, iLocation, sBlock);
					break;
			}

			/*** Begin or end door. ***/
			if ((iType == 0x24) || (iType == 0x07))
			{
				dest.y-=32; /*** 162 - 130 (iTileH) = 32 ***/
				loc.h = 162; /*** Instead of 130 (iTileH). ***/
			}

			/*** Set the text. ***/
			snprintf (sText, MAX_TEXT, "%s", ""); /*** Default. ***/
			if (iType == 0x04) /*** raise ***/
			{
				snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
			}
			if (iType == 0x05) /*** drop ***/
			{
				snprintf (sText, MAX_TEXT, "E:%i", iModifier[0] + 1);
			}
			if (iType == 0x06) /*** gate ***/
			{
				snprintf (sText, MAX_TEXT, "%i%%", ModAsPercent (iModifier[0], 6));
			}
			if (iType == 0x23) /*** teleport ***/
			{
				snprintf (sText, MAX_TEXT, "T:%i", iModifier[0] + 1);
			}
			if (iType == 0x02) /*** loose ***/
			{
				/*** Never harmful. ***/
				if (iModifier[0] == 0x01)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}
			if (iType == 0x0c) /*** chomper ***/
			{
				if (iModifier[0] == 0x02)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck f"); }
				if (iModifier[0] == 0x05)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}
			if (iType == 0x0d) /*** guillotine ***/
			{
				if (iModifier[0] == 0x02)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck f"); }
				if (iModifier[0] == 0x01)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}
			if (iType == 0x0e) /*** spike ***/
			{
				if (iModifier[0] == 0x04)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck f"); }
				if (iModifier[0] == 0x09)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}
			if (iType == 0x10) /*** crusher ***/
			{
				if (iModifier[0] == 0x03)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck f"); }
				if (iModifier[0] == 0x01)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}
			if (iType == 0x1e) /*** spinning log ***/
			{
				if (iModifier[0] == 0x03)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck f"); }
				if (iModifier[0] == 0x01)
					{ snprintf (sText, MAX_TEXT, "%s", "stuck l"); }
			}

			imgshow[0] = NULL; imgshow[1] = NULL;
			switch (cCurType)
			{
				case 'b': /*** locations; blue ***/
					for (iTileLoop = 0; iTileLoop < iTilesBlue; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksBlue[iTileLoop],
							imgtilesblue[iTileLoop], imgshow);
					}
					break;
				case 'f': /*** locations; fawn ***/
					for (iTileLoop = 0; iTileLoop < iTilesFawn; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksFawn[iTileLoop],
							imgtilesfawn[iTileLoop], imgshow);
					}
					break;
				case 's': /*** locations; silver ***/
					for (iTileLoop = 0; iTileLoop < iTilesSilver; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksSilver[iTileLoop],
							imgtilessilver[iTileLoop], imgshow);
					}
					break;
				case 'l': /*** locations; lava ***/
					for (iTileLoop = 0; iTileLoop < iTilesLava; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksLava[iTileLoop],
							imgtileslava[iTileLoop], imgshow);
					}
					break;
				case 'g': /*** locations; green ***/
					for (iTileLoop = 0; iTileLoop < iTilesGreen; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksGreen[iTileLoop],
							imgtilesgreen[iTileLoop], imgshow);
					}
					break;
				case 'u': /*** locations; umber ***/
					for (iTileLoop = 0; iTileLoop < iTilesUmber; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksUmber[iTileLoop],
							imgtilesumber[iTileLoop], imgshow);
					}
					break;
				case 'm': /*** locations; marble ***/
					for (iTileLoop = 0; iTileLoop < iTilesMarble; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksMarble[iTileLoop],
							imgtilesmarble[iTileLoop], imgshow);
					}
					break;
				case 'h': /*** locations; hallway ***/
					for (iTileLoop = 0; iTileLoop < iTilesHallway; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksHallway[iTileLoop],
							imgtileshallway[iTileLoop], imgshow);
					}
					break;
				case 'j': /*** locations; jaffar ***/
					for (iTileLoop = 0; iTileLoop < iTilesJaffar; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksJaffar[iTileLoop],
							imgtilesjaffar[iTileLoop], imgshow);
					}
					break;
				case 'i': /*** locations; intro ***/
					for (iTileLoop = 0; iTileLoop < iTilesIntro; iTileLoop++)
					{
						CmpPrep (sBlock, sTileBlocksIntro[iTileLoop],
							imgtilesintro[iTileLoop], imgshow);
					}
					break;
			}
			if ((imgshow[1] != NULL) && (imgshow[2] != NULL))
				{ ShowPosSNES (loc, dest, iLocation, imgshow, sText); }
		} else { iType = 0x00; } /*** To prevent warnings. ***/

		if (iPosShown == 0) /*** Custom tile. ***/
		{
			/*** Undo the temporary changes for level doors. ***/
			if (iEditPoP == 3)
			{
				if ((iType == 0x24) || (iType == 0x07)) { dest.y+=32; loc.h = 130; }
			}

			ShowPos (loc, dest, iLocation, imgunk, imgunk, "");
			iInfoC = 1;
		} else { iInfoC = 0; }

		/*** Show tile's foreground and modifier number. ***/
		if ((iInfo == 1) || (iInfoC == 1))
		{
			if (iEditPoP != 3)
			{
				CustomTile (iThing, (int[]){iModifier[0], iModifier[1],
					iModifier[2], iModifier[3]}, sCustomTile);
				snprintf (arText[0], MAX_TEXT, "%s", sCustomTile);
				DisplayText (dest.x, dest.y + 155 - 10 -
					FONT_SIZE_11, FONT_SIZE_11, arText, 1, font2);
			} else {
				snprintf (arText[0], MAX_TEXT, "%c%c %c%c",
					sBlock[3], sBlock[4], /*** back ***/
					sBlock[6], sBlock[7]); /*** object ***/
				snprintf (sSFW, 10, "%c%c", sBlock[9], sBlock[10]);
				if (strcmp (sSFW, "00") == 0) { snprintf (sSFW, 10, "%s", "S"); }
				else if (strcmp (sSFW, "01") == 0) { snprintf (sSFW, 10, "%s", "F"); }
				else if (strcmp (sSFW, "02") == 0) { snprintf (sSFW, 10, "%s", "W"); }
				else { printf ("[ WARN ] Strange SFW value: %s!\n", sSFW); }
				snprintf (arText[1], MAX_TEXT, "%c%c %s",
					sBlock[0], sBlock[1], /*** fore ***/
					sSFW); /*** attributes ***/
				DisplayText (dest.x, dest.y + 130 - 10 -
					(FONT_SIZE_11 + 4 + FONT_SIZE_11), FONT_SIZE_11, arText, 2, font2);
			}
		}
	}

	if (iThing == -8)
	{
		if (iModifier[0] == 1) /*** kid ***/
		{
			switch (iEditPoP)
			{
				case 1: dest.y = dest.y + 51; break;
				case 2: dest.y = dest.y + 52; break;
				case 3: dest.y = dest.y + 26; break;
			}
			switch (arKidDir[iModifier[1]])
			{
				case 0: /*** looks right ***/
					switch (iEditPoP)
					{
						case 1: dest.x = dest.x + 74; break;
						case 2: dest.x = dest.x + 22; break;
						case 3: dest.x = dest.x + 55; break;
					}
					if ((iEditPoP == 3) && (luLevelNr >= 10) && (luLevelNr <= 12))
					{
						CustomRenderCopy (imgkidrr[1], "imgkidrr[1]", &loc,
							screen, &dest);
						if (iSelected == iLocation)
						{ CustomRenderCopy (imgkidrr[2], "imgkidrr[2]", &loc,
							screen, &dest); }
					} else {
						CustomRenderCopy (imgkidr[1], "imgkidr[1]", &loc,
							screen, &dest);
						if (iSelected == iLocation)
						{ CustomRenderCopy (imgkidr[2], "imgkidr[2]", &loc,
							screen, &dest); }
					}
					break;
				case 255: /*** looks left ***/
					switch (iEditPoP)
					{
						case 1: dest.x = dest.x + 36; break;
						case 2: dest.x = dest.x + 12; break;
						case 3: dest.x = dest.x + 23; break;
					}
					if ((iEditPoP == 3) && (luLevelNr >= 10) && (luLevelNr <= 12))
					{
						CustomRenderCopy (imgkidlr[1], "imgkidlr[1]", &loc,
							screen, &dest);
						if (iSelected == iLocation)
						{ CustomRenderCopy (imgkidlr[2], "imgkidlr[2]", &loc,
							screen, &dest); }
					} else {
						CustomRenderCopy (imgkidl[1], "imgkidl[1]", &loc,
							screen, &dest);
						if (iSelected == iLocation)
						{ CustomRenderCopy (imgkidl[2], "imgkidl[2]", &loc,
							screen, &dest); }
					}
					break;
				default: printf ("[FAILED] Wrong dir.!\n"); exit (EXIT_ERROR); break;
			}
		}
		if (iModifier[0] == 2) /*** PoP1 guard ***/
		{
			iTemp = dest.x;
			iTemp2 = dest.y;
			if ((iCurGuard == 2) || (iCurGuard == 4))
			{
				dest.y = dest.y + 63; /*** skeleton + shadow ***/
			} else if (iCurGuard == 3) {
				dest.y = dest.y + 43; /*** jaffar ***/
			} else {
				dest.y = dest.y + 51; /*** normal guards + fat ***/
			}
			if (sGuardDirections[iCurRoom - 1] == 255) /*** looking to the left ***/
			{
				if ((iCurGuard == 2) || (iCurGuard == 4))
				{
					dest.x = dest.x + 34; /*** skeleton + shadow ***/
				} else {
					dest.x = dest.x + 54; /*** normal guards + fat + jaffar ***/
				}
				switch (iCurGuard)
				{
					case 0:
						switch (sGuardColors[iCurRoom - 1] - 1)
						{
							case 0: CustomRenderCopy (imgglp[1], "imgglp[1]", &loc,
								screen, &dest); break;
							case 1: CustomRenderCopy (imggrp[1], "imggrp[1]", &loc,
								screen, &dest); break;
							case 2: CustomRenderCopy (imggoy[1], "imggoy[1]", &loc,
								screen, &dest); break;
							case 3: CustomRenderCopy (imgggy[1], "imgggy[1]", &loc,
								screen, &dest); break;
							case 4: CustomRenderCopy (imggdb[1], "imggdb[1]", &loc,
								screen, &dest); break;
							case 5: CustomRenderCopy (imggpb[1], "imggpb[1]", &loc,
								screen, &dest); break;
							case 6: CustomRenderCopy (imggyo[1], "imggyo[1]", &loc,
								screen, &dest); break;
							default:
								CustomRenderCopy (imgguc[1], "imgguc[1]", &loc,
									screen, &dest);
								if (iDebug == 1)
								{
									printf ("[ INFO ] Strange guard color: %i (jaffar, shadow, "
										"fat, skeleton?)\n", sGuardColors[iCurRoom - 1] - 1);
								}
								break;
						}
						break;
					case 1:
						CustomRenderCopy (imgfat[1], "imgfat[1]", &loc,
							screen, &dest); break;
					case 2:
						CustomRenderCopy (imgskel[1], "imgskel[1]", &loc,
							screen, &dest); break;
					case 3:
						CustomRenderCopy (imgjaffar[1], "imgjaffar[1]", &loc,
							screen, &dest); break;
					case 4:
						CustomRenderCopy (imgshadow[1], "imgshadow[1]", &loc,
							screen, &dest); break;
				}
			} else {
				if ((iCurGuard == 2) || (iCurGuard == 4))
				{
					dest.x = dest.x + 8; /*** skeleton + shadow ***/
				} else if (iCurGuard == 3) {
					dest.x = dest.x + 20; /*** jaffar ***/
				} else {
					dest.x = dest.x + 6; /*** normal guards + fat ***/
				}
				switch (iCurGuard)
				{
					case 0:
						switch (sGuardColors[iCurRoom - 1] - 1)
						{
							case 0: CustomRenderCopy (imgglp[2], "imgglp[2]", &loc,
								screen, &dest); break;
							case 1: CustomRenderCopy (imggrp[2], "imggrp[2]", &loc,
								screen, &dest); break;
							case 2: CustomRenderCopy (imggoy[2], "imggoy[2]", &loc,
								screen, &dest); break;
							case 3: CustomRenderCopy (imgggy[2], "imgggy[2]", &loc,
								screen, &dest); break;
							case 4: CustomRenderCopy (imggdb[2], "imggdb[2]", &loc,
								screen, &dest); break;
							case 5: CustomRenderCopy (imggpb[2], "imggpb[2]", &loc,
								screen, &dest); break;
							case 6: CustomRenderCopy (imggyo[2], "imggyo[2]", &loc,
								screen, &dest); break;
							default:
								CustomRenderCopy (imgguc[2], "imgguc[2]", &loc,
									screen, &dest);
								if (iDebug == 1)
								{
									printf ("[ INFO ] Strange guard color: %i (jaffar, shadow, "
										"fat, skeleton?)\n", sGuardColors[iCurRoom - 1] - 1);
								}
								break;
						}
						break;
					case 1:
						CustomRenderCopy (imgfat[2], "imgfat[2]", &loc,
							screen, &dest); break;
					case 2:
						CustomRenderCopy (imgskel[2], "imgskel[2]", &loc,
							screen, &dest); break;
					case 3:
						CustomRenderCopy (imgjaffar[2], "imgjaffar[2]", &loc,
							screen, &dest); break;
					case 4:
						CustomRenderCopy (imgshadow[2], "imgshadow[2]", &loc,
							screen, &dest); break;
				}
			}
			switch (sGuardSkills[iCurRoom - 1])
			{
				case 10:
					snprintf (sText, MAX_TEXT, "%s", "LVL:a"); break;
				case 11:
					snprintf (sText, MAX_TEXT, "%s", "LVL:b"); break;
				default:
					snprintf (sText, MAX_TEXT, "LVL:%i", sGuardSkills[iCurRoom - 1]);
					break;
			}
			DisplayTextLine (iTemp + 7, iTemp2 + 145 - FONT_SIZE_11,
				sText, font2, color_bl, color_wh, 0);
			if (iSelected == iLocation)
			{
				/*** looking to the left ***/
				if (sGuardDirections[iCurRoom - 1] == 255)
				{
					switch (iCurGuard)
					{
						case 0:
							CustomRenderCopy (imggsel[1], "imggsel[1]", &loc,
								screen, &dest); break;
						case 1:
							CustomRenderCopy (imgfatsel[1], "imgfatsel[1]", &loc,
								screen, &dest); break;
						case 2:
							CustomRenderCopy (imgskelsel[1], "imgskelsel[1]", &loc,
								screen, &dest); break;
						case 3:
							CustomRenderCopy (imgjaffarsel[1], "imgjaffarsel[1]", &loc,
								screen, &dest); break;
						case 4:
							CustomRenderCopy (imgshadowsel[1], "imgshadowsel[1]", &loc,
								screen, &dest); break;
					}
				} else {
					switch (iCurGuard)
					{
						case 0:
							CustomRenderCopy (imggsel[2], "imggsel[2]", &loc,
								screen, &dest); break;
						case 1:
							CustomRenderCopy (imgfatsel[2], "imgfatsel[2]", &loc,
								screen, &dest); break;
						case 2:
							CustomRenderCopy (imgskelsel[2], "imgskelsel[2]", &loc,
								screen, &dest); break;
						case 3:
							CustomRenderCopy (imgjaffarsel[2], "imgjaffarsel[2]", &loc,
								screen, &dest); break;
						case 4:
							CustomRenderCopy (imgshadowsel[2], "imgshadowsel[2]", &loc,
								screen, &dest); break;
					}
				}
			}
		}
		if (iModifier[0] == 3) /*** incoming arrow ***/
		{
			iDAmount = iDynamicGuards_9_Amount[iCurRoom - 1][iModifier[1]];
			if ((iDAmount < 0) || (iDAmount > 9)) { iDAmount = 10; }
			if ((iDynamicGuards_4_Column[iCurRoom - 1][iModifier[1]] >= 0) &&
				(iDynamicGuards_4_Column[iCurRoom - 1][iModifier[1]] <= 5))
			{
				CustomRenderCopy (imgincomingl[iDAmount],
					"imgincomingl[]", &loc, screen, &dest);
			} else {
				CustomRenderCopy (imgincomingr[iDAmount],
					"imgincomingr[]", &loc, screen, &dest);
			}
		}
		if (iModifier[0] == 4) /*** PoP2 guard ***/
		{
			if (iStaticGuards_4_Directions[iCurRoom - 1][iModifier[1]] == 0)
			{
				iDirection = 2; /*** right ***/
			} else { /*** 255 ***/
				iDirection = 1; /*** left ***/
			}
			switch (WhichStaticGuard (iModifier[1]))
			{
				case 1:
					CustomRenderCopy (imgguardblack[iDirection],
						"imgguardblack[iDirection]",
						&loc, screen, &dest); break;
				case 2:
					CustomRenderCopy (imgguardblue[iDirection],
						"imgguardblue[iDirection]",
						&loc, screen, &dest); break;
				case 3:
					CustomRenderCopy (imgguardred[iDirection],
						"imgguardred[iDirection]",
						&loc, screen, &dest); break;
				case 4:
					CustomRenderCopy (imgskelawakes[iDirection],
						"imgskelawakes[iDirection]",
						&loc, screen, &dest); break;
				case 5:
					CustomRenderCopy (imgskelawake[iDirection],
						"imgskelawake[iDirection]",
						&loc, screen, &dest); break;
				case 6:
					CustomRenderCopy (imgskelsleeps[iDirection],
						"imgskelsleeps[iDirection]",
						&loc, screen, &dest); break;
				case 7:
					CustomRenderCopy (imgskelawakessws[iDirection],
						"imgskelawakessws[iDirection]",
						&loc, screen, &dest); break;
				case 8:
					CustomRenderCopy (imgheadlong[iDirection],
						"imgheadlong[iDirection]",
						&loc, screen, &dest); break;
				case 9:
					CustomRenderCopy (imgheadshort[iDirection],
						"imgheadshort[iDirection]",
						&loc, screen, &dest); break;
				case 10:
					CustomRenderCopy (imgsnake[iDirection],
						"imgsnake[iDirection]",
						&loc, screen, &dest); break;
				case 11:
					CustomRenderCopy (imgbirdman[iDirection],
						"imgbirdman[iDirection]",
						&loc, screen, &dest); break;
				case 12:
					CustomRenderCopy (imgsword[iDirection],
						"imgsword[iDirection]",
						&loc, screen, &dest); break;
				case 13:
					CustomRenderCopy (imgfakeprince[iDirection],
						"imgfakeprince[iDirection]",
						&loc, screen, &dest); break;
				default: /*** As a fallback. ***/
					CustomRenderCopy (imgguardblack[iDirection],
						"imgguardblack[iDirection]",
						&loc, screen, &dest); break;
			}
			snprintf (sText, MAX_TEXT, "S:%i",
				iStaticGuards_5_Skills[iCurRoom - 1][iModifier[1]]);
			DisplayTextLine (dest.x + 7, dest.y + iFromImageHeight - FONT_SIZE_11,
				sText, font2, color_bl, color_wh, 0);
		}
		if (iModifier[0] == 5) /*** PoP1 for SNES guard ***/
		{
			if (sGuardDirections[iCurRoom - 1] == 0)
			{
				iDirection = 2; /*** right ***/
			} else { /*** 1 ***/
				iDirection = 1; /*** left ***/
			}
			switch (sGuardTypes[iCurRoom - 1])
			{
				case 0x02: /*** dead pink ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg02[iDirection], "imgsg02[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg02sel
						[iDirection], "imgsg02sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x03: /*** silver s ***/
					if (iDirection == 1) { dest.x-=6; } else { dest.x+=20; }
					dest.y = dest.y + 40;
					CustomRenderCopy (imgsg03[iDirection], "imgsg03[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg03sel
						[iDirection], "imgsg03sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x04: /*** bronze s ***/
					if (iDirection == 1) { dest.x-=6; } else { dest.x+=20; }
					dest.y = dest.y + 40;
					CustomRenderCopy (imgsg04[iDirection], "imgsg04[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg04sel
						[iDirection], "imgsg04sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x05: /*** golden s ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x-=8; }
					dest.y = dest.y + 42;
					CustomRenderCopy (imgsg05[iDirection], "imgsg05[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg05sel
						[iDirection], "imgsg05sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x06: /*** female ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=4; }
					dest.y = dest.y + 20;
					CustomRenderCopy (imgsg06[iDirection], "imgsg06[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg06sel
						[iDirection], "imgsg06sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x07: /*** fat ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=2; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg07[iDirection], "imgsg07[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg07sel
						[iDirection], "imgsg07sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x08: /*** shadow ***/
					if (iDirection == 1) { dest.x+=48; } else { dest.x+=32; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg08[iDirection], "imgsg08[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg08sel
						[iDirection], "imgsg08sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x09: /*** green g ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg09[iDirection], "imgsg09[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg09sel
						[iDirection], "imgsg09sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0a: /*** greenish ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg0a[iDirection], "imgsg0a[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0asel
						[iDirection], "imgsg0asel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0b: /*** blue g ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg0b[iDirection], "imgsg0b[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0bsel
						[iDirection], "imgsg0bsel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0c: /*** red g ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg0c[iDirection], "imgsg0c[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0csel
						[iDirection], "imgsg0csel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0d: /*** purple g ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg0d[iDirection], "imgsg0d[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0dsel
						[iDirection], "imgsg0dsel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0e: /*** blue faced ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg0e[iDirection], "imgsg0e[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0esel
						[iDirection], "imgsg0esel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x0f: /*** red k ***/
					if (iDirection == 1) { dest.x+=20; } else { dest.x+=10; }
					dest.y = dest.y + 12;
					CustomRenderCopy (imgsg0f[iDirection], "imgsg0f[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg0fsel
						[iDirection], "imgsg0fsel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x10: /*** blue k ***/
					if (iDirection == 1) { dest.x+=20; } else { dest.x+=10; }
					dest.y = dest.y + 12;
					CustomRenderCopy (imgsg10[iDirection], "imgsg10[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg10sel
						[iDirection], "imgsg10sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x11: /*** sinbad k ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=2; }
					dest.y = dest.y + 8;
					CustomRenderCopy (imgsg11[iDirection], "imgsg11[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg11sel
						[iDirection], "imgsg11sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x12: /*** jaffar ***/
					if (iDirection == 1) { dest.x+=20; } else { dest.x+=10; }
					dest.y = dest.y + 16;
					CustomRenderCopy (imgsg12[iDirection], "imgsg12[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg12sel
						[iDirection], "imgsg12sel[iDirection]", &loc, screen, &dest); }
					break;
				case 0x13: /*** dead white ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg13[iDirection], "imgsg13[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg13sel
						[iDirection], "imgsg13sel[iDirection]", &loc, screen, &dest); }
					break;
				default: /*** As a fallback. ***/
					if (iDirection == 1) { dest.x+=18; } else { dest.x+=8; }
					dest.y = dest.y + 26;
					CustomRenderCopy (imgsg09[iDirection], "imgsg09[iDirection]",
						&loc, screen, &dest);
					if (iSelected == iLocation) { CustomRenderCopy (imgsg09sel
						[iDirection], "imgsg09sel[iDirection]", &loc, screen, &dest); }
					if (iDebug == 1)
					{
						printf ("[ INFO ] Strange guard type: %i\n",
							sGuardTypes[iCurRoom - 1]);
					}
					break;
			}
			snprintf (sText, MAX_TEXT, "S:%i",
				sGuardSkills[iCurRoom - 1]);
			DisplayTextLine (dest.x + 7, dest.y + iFromImageHeight - FONT_SIZE_11,
				sText, font2, color_bl, color_wh, 0);
		}
	}

	if (iThing == -9)
	{
		switch (iModifier[0])
		{
			case 1: /*** faded background ***/
				CustomRenderCopy (imgfadedl, "imgfadedl", &loc,
					screen, &dest); break;
			case 2: /*** popup ***/
				CustomRenderCopy (imgpopup, "imgpopup", &loc,
					screen, &dest); break;
			case 3: /*** OK off ***/
				CustomRenderCopy (imgok[1], "imgok[1]", &loc,
					screen, &dest); break;
			case 4: /*** OK on ***/
				CustomRenderCopy (imgok[2], "imgok[2]", &loc,
					screen, &dest); break;
			case 5: /*** popup_yn ***/
				CustomRenderCopy (imgpopup_yn, "imgpopup_yn", &loc,
					screen, &dest); break;
			case 6: /*** Yes off ***/
				CustomRenderCopy (imgyes[1], "imgyes[1]", &loc,
					screen, &dest); break;
			case 7: /*** Yes on ***/
				CustomRenderCopy (imgyes[2], "imgyes[2]", &loc,
					screen, &dest); break;
			case 8: /*** No off ***/
				CustomRenderCopy (imgno[1], "imgno[1]", &loc,
					screen, &dest); break;
			case 9: /*** No on ***/
				CustomRenderCopy (imgno[2], "imgno[2]", &loc,
					screen, &dest); break;
			case 10: /*** help ***/
				CustomRenderCopy (imghelp, "imghelp", &loc,
					screen, &dest); break;
			case 11: /*** exe ***/
				CustomRenderCopy (imgexe, "imgexe", &loc,
					screen, &dest); break;
			case 12: /*** Save off ***/
				CustomRenderCopy (imgsave[1], "imgsave[1]", &loc,
					screen, &dest); break;
			case 13: /*** Save on ***/
				CustomRenderCopy (imgsave[2], "imgsave[2]", &loc,
					screen, &dest); break;
			case 14: /*** packed ***/
				CustomRenderCopy (imgexepacked, "imgexepacked", &loc,
					screen, &dest); break;
			case 15: /*** music on (PoP1 for SNES) ***/
				CustomRenderCopy (imgexemusicyes, "imgexemusicyes", &loc,
					screen, &dest); break;
			case 16: /*** music off (PoP1 for SNES) ***/
				CustomRenderCopy (imgexemusicno, "imgexemusicno", &loc,
					screen, &dest); break;
			case 17: /*** haze on (PoP1 for SNES) ***/
				CustomRenderCopy (imgexehazeyes, "imgexehazeyes", &loc,
					screen, &dest); break;
			case 18: /*** haze off (PoP1 for SNES) ***/
				CustomRenderCopy (imgexehazeno, "imgexehazeno", &loc,
					screen, &dest); break;
			/*** case 19 ***/
			case 20: /*** no teleport marker ***/
				CustomRenderCopy (imgnomarker, "imgnomarker", &loc,
					screen, &dest); break;
			case 21: /*** kid colors ***/
				CustomRenderCopy (imgkcolors, "imgkcolors", &loc,
					screen, &dest); break;
			case 22: /*** kid colors (black, white) ***/
				if (iKidColorsBW == 0)
				{
					CustomRenderCopy (imgkcolorsb, "imgkcolorsb", &loc, screen, &dest);
				} else {
					CustomRenderCopy (imgkcolorsw, "imgkcolorsw", &loc, screen, &dest);
				}
				break;
			case 23: /*** unchangeable skeletons ***/
				CustomRenderCopy (imgexeskeldis, "imgexeskeldis", &loc,
					screen, &dest); break;
			case 24: /*** guard tab ***/
				CustomRenderCopy (imgexetab, "imgexetab", &loc, screen, &dest); break;
			case 25: /*** status bar sprite ***/
				loc.x = (iStatusBarFrame - 1) * 20;
				CustomRenderCopy (imgstatusbarsprite, "imgstatusbarsprite", &loc,
					screen, &dest); break;
			case 26: /*** guard sprites ***/
				snprintf (sText, MAX_TEXT, "imggs[%i]", iModifier[3]);
				CustomRenderCopy (imggs[iModifier[3]], sText, &loc,
					screen, &dest); break;
			case 27: /*** kid colors (r, l, f) ***/
				switch (iModifier[1])
				{
					case 1:
						CustomRenderCopy (imgkcolorsr, "imgkcolorsr", &loc, screen, &dest);
						break;
					case 2:
						CustomRenderCopy (imgkcolorsl, "imgkcolorsl", &loc, screen, &dest);
						break;
					case 3:
						CustomRenderCopy (imgkcolorsf, "imgkcolorsf", &loc, screen, &dest);
						break;
				}
				break;
		}
	}
}
/*****************************************************************************/
void ShowImageBasic (SDL_Texture *img, int iX, int iY, char *sImageInfo,
	SDL_Renderer *screen, float fMultiply, int iXYScale)
/*****************************************************************************/
{
	/* Usually, fMultiply is either iScale or ZoomGet().
	 *
	 * Also, usually, iXYScale is 1 with iScale and 0 with ZoomGet().
	 *
	 * If you use this function, make sure to verify the image is properly
	 * (re)scaled and (re)positioned when the main window is zoomed ("z")!
	 */

	SDL_Rect dest;
	SDL_Rect loc;
	int iWidth, iHeight;

	SDL_QueryTexture (img, NULL, NULL, &iWidth, &iHeight);
	loc.x = 0; loc.y = 0; loc.w = iWidth; loc.h = iHeight;
	if (iXYScale == 0)
	{
		dest.x = iX;
		dest.y = iY;
	} else {
		dest.x = iX * fMultiply;
		dest.y = iY * fMultiply;
	}
	dest.w = iWidth * fMultiply;
	dest.h = iHeight * fMultiply;

	/*** This is for the animation. ***/
	if (strcmp (sImageInfo, "imgstatusbarsprite") == 0)
	{
		loc.x = (iStatusBarFrame - 1) * 20;
		loc.w = loc.w / 18;
		dest.w = dest.w / 18;
	}

	if (SDL_RenderCopy (screen, img, &loc, &dest) != 0)
	{
		printf ("[ WARN ] SDL_RenderCopy (%s): %s\n", sImageInfo, SDL_GetError());
	}
}
/*****************************************************************************/
void CmpPrep (char *sBlock, char *sCompare, SDL_Texture **imgcmp,
	SDL_Texture **imgshow)
/*****************************************************************************/
{
	if (strcmp (sBlock, sCompare) == 0)
	{
		imgshow[1] = imgcmp[1];
		imgshow[2] = imgcmp[2];
	}
}
/*****************************************************************************/
int InArea (int iUpperLeftX, int iUpperLeftY,
	int iLowerRightX, int iLowerRightY)
/*****************************************************************************/
{
	if ((iUpperLeftX * iScale <= iXPos) &&
		(iLowerRightX * iScale >= iXPos) &&
		(iUpperLeftY * iScale <= iYPos) &&
		(iLowerRightY * iScale >= iYPos))
	{
		return (1);
	} else {
		return (0);
	}
}
/*****************************************************************************/
int InAreaMap (int iUpperLeftX, int iUpperLeftY,
	int iLowerRightX, int iLowerRightY)
/*****************************************************************************/
{
	if ((iUpperLeftX <= iXPosMap) &&
		(iLowerRightX >= iXPosMap) &&
		(iUpperLeftY <= iYPosMap) &&
		(iLowerRightY >= iYPosMap))
	{
		return (1);
	} else {
		return (0);
	}
}
/*****************************************************************************/
void PreventCPUEating (void)
/*****************************************************************************/
{
	gamespeed = REFRESH;
	while ((SDL_GetTicks() - looptime) < gamespeed)
	{
		SDL_Delay (10);
	}
	looptime = SDL_GetTicks();
}
/*****************************************************************************/
void InitScreenAction (char *sAction)
/*****************************************************************************/
{
	int iEventDoor;
	int iEventRoom;

	if (strcmp (sAction, "left") == 0)
	{
		switch (iScreen)
		{
			case 1:
				iSelected--;
				switch (iSelected)
				{
					case 0: iSelected = 10; break;
					case 10: iSelected = 20; break;
					case 20: iSelected = 30; break;
				}
				break;
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					if (iMovingRoom != 0)
					{
						if (iMovingNewX != 1) { iMovingNewX--; }
							else { iMovingNewX = 25; }
						PlaySound ("wav/cross.wav");
					}
				} else {
					if (iChangingBrokenSide != 1)
					{
						iChangingBrokenSide = 1;
					} else {
						if (iEditPoP != 2)
						{
							switch (iChangingBrokenRoom)
							{
								case 1: iChangingBrokenRoom = 4; break;
								case 5: iChangingBrokenRoom = 8; break;
								case 9: iChangingBrokenRoom = 12; break;
								case 13: iChangingBrokenRoom = 16; break;
								case 17: iChangingBrokenRoom = 20; break;
								case 21: iChangingBrokenRoom = 24; break;
								default: iChangingBrokenRoom--; break;
							}
						} else {
							switch (iChangingBrokenRoom)
							{
								case 1: iChangingBrokenRoom = 4; break;
								case 5: iChangingBrokenRoom = 8; break;
								case 9: iChangingBrokenRoom = 12; break;
								case 13: iChangingBrokenRoom = 16; break;
								case 17: iChangingBrokenRoom = 28; break;
								case 21: iChangingBrokenRoom = 32; break;
								case 25: iChangingBrokenRoom = 20; break;
								case 29: iChangingBrokenRoom = 24; break;
								default: iChangingBrokenRoom--; break;
							}
						}
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventDoor = EventInfo (iChangeEvent, 2);
					switch (iEventDoor)
					{
						case 1: iEventDoor = 10; break;
						case 11: iEventDoor = 20; break;
						case 21: iEventDoor = 30; break;
						default: iEventDoor--; break;
					}
					if (iEventDoor > 20) { EventDoor (iEventDoor - 20, 3); }
						else if (iEventDoor > 10)
							{ EventDoor (iEventDoor - 10, 2); }
						else { EventDoor (iEventDoor, 1); }
				} else {
					iEventDoor = iPoP2DoorLocation[iChangeEvent];
					switch (iEventDoor)
					{
						case 0: iEventDoor = 9; break;
						case 10: iEventDoor = 19; break;
						case 20: iEventDoor = 29; break;
						default: iEventDoor--; break;
					}
					iPoP2DoorLocation[iChangeEvent] = iEventDoor;
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "right") == 0)
	{
		switch (iScreen)
		{
			case 1:
				iSelected++;
				switch (iSelected)
				{
					case 11: iSelected = 1; break;
					case 21: iSelected = 11; break;
					case 31: iSelected = 21; break;
				}
				break;
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					if (iMovingRoom != 0)
					{
						if (iMovingNewX != 25) { iMovingNewX++; }
							else { iMovingNewX = 1; }
						PlaySound ("wav/cross.wav");
					}
				} else {
					if (iChangingBrokenSide != 2)
					{
						iChangingBrokenSide = 2;
					} else {
						if (iEditPoP != 2)
						{
							switch (iChangingBrokenRoom)
							{
								case 4: iChangingBrokenRoom = 1; break;
								case 8: iChangingBrokenRoom = 5; break;
								case 12: iChangingBrokenRoom = 9; break;
								case 16: iChangingBrokenRoom = 13; break;
								case 20: iChangingBrokenRoom = 17; break;
								case 24: iChangingBrokenRoom = 21; break;
								default: iChangingBrokenRoom++; break;
							}
						} else {
							switch (iChangingBrokenRoom)
							{
								case 4: iChangingBrokenRoom = 1; break;
								case 8: iChangingBrokenRoom = 5; break;
								case 12: iChangingBrokenRoom = 9; break;
								case 16: iChangingBrokenRoom = 13; break;
								case 20: iChangingBrokenRoom = 25; break;
								case 24: iChangingBrokenRoom = 29; break;
								case 28: iChangingBrokenRoom = 17; break;
								case 32: iChangingBrokenRoom = 21; break;
								default: iChangingBrokenRoom++; break;
							}
						}
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventDoor = EventInfo (iChangeEvent, 2);
					switch (iEventDoor)
					{
						case 10: iEventDoor = 1; break;
						case 20: iEventDoor = 11; break;
						case 30: iEventDoor = 21; break;
						default: iEventDoor++; break;
					}
					if (iEventDoor > 20) { EventDoor (iEventDoor - 20, 3); }
						else if (iEventDoor > 10)
							{ EventDoor (iEventDoor - 10, 2); }
						else { EventDoor (iEventDoor, 1); }
				} else {
					iEventDoor = iPoP2DoorLocation[iChangeEvent];
					switch (iEventDoor)
					{
						case 9: iEventDoor = 0; break;
						case 19: iEventDoor = 10; break;
						case 29: iEventDoor = 20; break;
						default: iEventDoor++; break;
					}
					iPoP2DoorLocation[iChangeEvent] = iEventDoor;
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "up") == 0)
	{
		switch (iScreen)
		{
			case 1:
				if (iSelected > 10) { iSelected-=10; }
					else { iSelected+=20; }
				break;
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					if (iMovingRoom != 0)
					{
						if (iMovingNewY != 1) { iMovingNewY--; }
							else { iMovingNewY = 24; }
						PlaySound ("wav/cross.wav");
					}
				} else {
					if (iChangingBrokenSide != 3)
					{
						iChangingBrokenSide = 3;
					} else {
						switch (iChangingBrokenRoom)
						{
							case 1: iChangingBrokenRoom = 21; break;
							case 2: iChangingBrokenRoom = 22; break;
							case 3: iChangingBrokenRoom = 23; break;
							case 4: iChangingBrokenRoom = 24; break;
							case 25: iChangingBrokenRoom = 29; break;
							case 26: iChangingBrokenRoom = 30; break;
							case 27: iChangingBrokenRoom = 31; break;
							case 28: iChangingBrokenRoom = 32; break;
							default: iChangingBrokenRoom -= 4; break;
						}
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventDoor = EventInfo (iChangeEvent, 2);
					if (iEventDoor > 10) { iEventDoor-=10; }
						else { iEventDoor+=20; }
					if (iEventDoor > 20) { EventDoor (iEventDoor - 20, 3); }
						else if (iEventDoor > 10)
							{ EventDoor (iEventDoor - 10, 2); }
						else { EventDoor (iEventDoor, 1); }
				} else {
					if (iPoP2DoorLocation[iChangeEvent] > 9)
						{ iPoP2DoorLocation[iChangeEvent]-=10; }
							else { iPoP2DoorLocation[iChangeEvent]+=20; }
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "down") == 0)
	{
		switch (iScreen)
		{
			case 1:
				if (iSelected <= 20) { iSelected+=10; }
					else { iSelected-=20; }
				break;
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					if (iMovingRoom != 0)
					{
						if (iMovingNewY != 24) { iMovingNewY++; }
							else { iMovingNewY = 1; }
						PlaySound ("wav/cross.wav");
					}
				} else {
					if (iChangingBrokenSide != 4)
					{
						iChangingBrokenSide = 4;
					} else {
						switch (iChangingBrokenRoom)
						{
							case 21: iChangingBrokenRoom = 1; break;
							case 22: iChangingBrokenRoom = 2; break;
							case 23: iChangingBrokenRoom = 3; break;
							case 24: iChangingBrokenRoom = 4; break;
							case 29: iChangingBrokenRoom = 25; break;
							case 30: iChangingBrokenRoom = 26; break;
							case 31: iChangingBrokenRoom = 27; break;
							case 32: iChangingBrokenRoom = 28; break;
							default: iChangingBrokenRoom += 4; break;
						}
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventDoor = EventInfo (iChangeEvent, 2);
					if (iEventDoor <= 20) { iEventDoor+=10; }
						else { iEventDoor-=20; }
					if (iEventDoor > 20) { EventDoor (iEventDoor - 20, 3); }
						else if (iEventDoor > 10)
							{ EventDoor (iEventDoor - 10, 2); }
						else { EventDoor (iEventDoor, 1); }
				} else {
					if (iPoP2DoorLocation[iChangeEvent] <= 19)
						{ iPoP2DoorLocation[iChangeEvent]+=10; }
							else { iPoP2DoorLocation[iChangeEvent]-=20; }
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "left bracket") == 0)
	{
		switch (iScreen)
		{
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					iMovingNewBusy = 0;
					switch (iMovingRoom)
					{
						case 0: iMovingRoom = iRooms; break;
						case 1: iMovingRoom = iRooms; break;
						default: iMovingRoom--; break;
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventRoom = EventInfo (iChangeEvent, 1);
					if ((iEventRoom >= 2) && (iEventRoom <= 24))
					{
						EventRoom (iEventRoom - 1);
					} else {
						EventRoom (24);
					}
				} else {
					if (iPoP2DoorRoom[iChangeEvent] > 1)
					{
						iPoP2DoorRoom[iChangeEvent]--;
					} else {
						iPoP2DoorRoom[iChangeEvent] = 32;
					}
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "right bracket") == 0)
	{
		switch (iScreen)
		{
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					iMovingNewBusy = 0;
					switch (iMovingRoom)
					{
						case 0: iMovingRoom = 1; break;
						case 24:
							if (iEditPoP != 2) { iMovingRoom = 1; }
								else { iMovingRoom++; } break;
						case 32: iMovingRoom = 1; break;
						default: iMovingRoom++; break;
					}
				}
				break;
			case 3:
				if (iEditPoP != 2)
				{
					iEventRoom = EventInfo (iChangeEvent, 1);
					if ((iEventRoom >= 1) && (iEventRoom <= 23))
					{
						EventRoom (iEventRoom + 1);
					} else {
						EventRoom (1);
					}
				} else {
					if (iPoP2DoorRoom[iChangeEvent] < 32)
					{
						iPoP2DoorRoom[iChangeEvent]++;
					} else {
						iPoP2DoorRoom[iChangeEvent] = 1;
					}
					PlaySound ("wav/check_box.wav");
					iChanged++;
				}
				break;
		}
	}

	if (strcmp (sAction, "enter") == 0)
	{
		switch (iScreen)
		{
			case 1:
				ChangePos (iSelected, ascreen);
				break;
			case 2:
				if (iBrokenRoomLinks == 0)
				{
					if (iMovingRoom != 0)
					{
						if (iRoomArray[iMovingNewX][iMovingNewY] == 0)
						{
							RemoveOldRoom();
							AddNewRoom (iMovingNewX, iMovingNewY, iMovingRoom);
							iChanged++;
						}
						iMovingRoom = 0; iMovingNewBusy = 0;
					}
				} else {
					LinkPlus();
				}
				break;
		}
	}

	if (strcmp (sAction, "env") == 0)
	{
		switch (iEditPoP)
		{
			case 1:
				if ((strcmp (sEXEType, "missing") != 0) &&
					(strcmp (sEXEType, "unknown") != 0))
				{
					EXELoad_F2_1();
					switch (cCurType)
					{
						case 'd':
							cCurType = 'p'; iEXEEnv[(int)luLevelNr] = 1; break;
						case 'p':
							cCurType = 'd'; iEXEEnv[(int)luLevelNr] = 0; break;
					}
					EXESave_F2_1();
					PlaySound ("wav/extras.wav");
				} else {
					printf ("[ INFO ] %s does not exist or has an unknown"
						" executable type.\n", POP1_EXECUTABLE);
				}
				break;
			case 2:
				switch (iEXEEnvPoP2)
				{
					case 0x01: iEXEEnvPoP2 = 0x02; cCurType = 't'; break;
					case 0x02: iEXEEnvPoP2 = 0x03; cCurType = 'c'; break;
					case 0x03: iEXEEnvPoP2 = 0x04; cCurType = 'r'; break;
					case 0x04: iEXEEnvPoP2 = 0x05; cCurType = 'o'; break;
					case 0x05: iEXEEnvPoP2 = 0x06; cCurType = 'o'; break;
					case 0x06: iEXEEnvPoP2 = 0x01; cCurType = 'o'; break;
				}
				iChanged++;
				PlaySound ("wav/extras.wav");
				break;
			case 3:
				EXELoad_F2_3();
				switch (cCurType)
				{
					case 'b':
						cCurType = 'f';
						iEXEEnvL[luLevelNr] = 0x01;
						iEXEEnvO[luLevelNr] = 0x01;
						iEXEEnvF[luLevelNr] = 50572;
						break;
					case 'f':
						cCurType = 's';
						iEXEEnvL[luLevelNr] = 0x02;
						iEXEEnvO[luLevelNr] = 0x02;
						iEXEEnvF[luLevelNr] = 50580;
						break;
					case 's':
						cCurType = 'l';
						iEXEEnvL[luLevelNr] = 0x03;
						iEXEEnvO[luLevelNr] = 0x03;
						iEXEEnvF[luLevelNr] = 50588;
						break;
					case 'l':
						cCurType = 'g';
						iEXEEnvL[luLevelNr] = 0x04;
						iEXEEnvO[luLevelNr] = 0x04;
						iEXEEnvF[luLevelNr] = 50596;
						break;
					case 'g':
						cCurType = 'u';
						iEXEEnvL[luLevelNr] = 0x05;
						iEXEEnvO[luLevelNr] = 0x05;
						iEXEEnvF[luLevelNr] = 50604;
						break;
					case 'u':
						cCurType = 'm';
						iEXEEnvL[luLevelNr] = 0x06;
						iEXEEnvO[luLevelNr] = 0x06;
						iEXEEnvF[luLevelNr] = 50612;
						break;
					case 'm':
						cCurType = 'h';
						iEXEEnvL[luLevelNr] = 0x07;
						iEXEEnvO[luLevelNr] = 0x07;
						iEXEEnvF[luLevelNr] = 50620;
						break;
					case 'h':
						cCurType = 'j';
						iEXEEnvL[luLevelNr] = 0x08;
						iEXEEnvO[luLevelNr] = 0x08;
						iEXEEnvF[luLevelNr] = 50620;
						break;
					case 'j':
						cCurType = 'i';
						iEXEEnvL[luLevelNr] = 0x09;
						iEXEEnvO[luLevelNr] = 0x06; /*** It uses marble. ***/
						iEXEEnvF[luLevelNr] = 50612;
						break;
					case 'i':
						cCurType = 'b';
						iEXEEnvL[luLevelNr] = 0x00;
						iEXEEnvO[luLevelNr] = 0x00;
						iEXEEnvF[luLevelNr] = 50564;
						break;
				}
				EXESave_F2_3();
				ForceSpecialsToMatchEnv();
				GiveAnimationGroups();
				PlaySound ("wav/extras.wav");
				break;
		}
	}
}
/*****************************************************************************/
void InitScreen (void)
/*****************************************************************************/
{
	SDL_Event event;
	SDL_Surface *imgicon;
	SDL_AudioSpec fmt;
	int iTemp2;
	int iOldXPos, iOldYPos;
	const Uint8 *keystate;
	SDL_Rect barbox;
	Uint32 newticks;
	Uint32 oldticks;
	char sImage[MAX_IMG + 2];
	int iTemp;
	int iJoyNr;
	int iXJoy1, iYJoy1, iXJoy2, iYJoy2;
	int iBackTemp;
	char sBackTemp[7 + 2];
	int iTileNr;
	int iBack;
	int iButton;
	char sFileName[MAX_FILE + 2];
	char sSixBit[7 + 2];
	char sEXELoc[MAX_FILE + 2];
	int iYesNo;

	/*** Used for looping. ***/
	int iSixBitLoop;
	int iLoopFrame;

	if (SDL_Init (SDL_INIT_AUDIO|SDL_INIT_VIDEO|
		SDL_INIT_GAMECONTROLLER|SDL_INIT_HAPTIC) < 0)
	{
		printf ("[FAILED] Unable to init SDL: %s!\n", SDL_GetError());
		exit (EXIT_ERROR);
	}
	atexit (SDL_Quit);

	/*** main window ***/
	window = SDL_CreateWindow (EDITOR_NAME " " EDITOR_VERSION,
		SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
		(WINDOW_WIDTH) * iScale, (WINDOW_HEIGHT) * iScale, iFullscreen);
	if (window == NULL)
	{
		printf ("[FAILED] Unable to create main window: %s!\n", SDL_GetError());
		exit (EXIT_ERROR);
	}
	iWindowID = SDL_GetWindowID (window);
	iActiveWindowID = iWindowID;
	ascreen = SDL_CreateRenderer (window, -1, 0);
	if (ascreen == NULL)
	{
		printf ("[FAILED] Unable to set video mode: %s!\n", SDL_GetError());
		exit (EXIT_ERROR);
	}

	/*** Map window ***/
	windowmap = SDL_CreateWindow ("Map", SDL_WINDOWPOS_UNDEFINED,
		SDL_WINDOWPOS_UNDEFINED, 1291, 858, SDL_WINDOW_HIDDEN);
	if (windowmap == NULL)
	{
		printf ("[FAILED] Unable to create Map window: %s!\n", SDL_GetError());
		exit (EXIT_ERROR);
	}
	iWindowMapID = SDL_GetWindowID (windowmap);
	mscreen = SDL_CreateRenderer (windowmap, -1, 0);
	if (mscreen == NULL)
	{
		printf ("[FAILED] Unable to set video mode: %s!\n", SDL_GetError());
		exit (EXIT_ERROR);
	}

	/*** Some people may prefer linear, but we're going old school. ***/
	SDL_SetHint (SDL_HINT_RENDER_SCALE_QUALITY, "nearest");
	if (iFullscreen != 0)
	{
		SDL_RenderSetLogicalSize (ascreen, (WINDOW_WIDTH) * iScale,
			(WINDOW_HEIGHT) * iScale);
	}

	if (TTF_Init() == -1)
	{
		exit (EXIT_ERROR);
	}

	LoadFonts();

	curArrow = SDL_CreateSystemCursor (SDL_SYSTEM_CURSOR_ARROW);
	curWait = SDL_CreateSystemCursor (SDL_SYSTEM_CURSOR_WAIT);
	curHand = SDL_CreateSystemCursor (SDL_SYSTEM_CURSOR_HAND);
	curText = SDL_CreateSystemCursor (SDL_SYSTEM_CURSOR_IBEAM);

	if (iNoAudio != 1)
	{
		PrIfDe ("[  OK  ] Initializing Audio\n");
		fmt.freq = 44100;
		fmt.format = AUDIO_S16;
		fmt.channels = 2;
		fmt.samples = 512;
		fmt.callback = MixAudio;
		fmt.userdata = NULL;
		if (SDL_OpenAudio (&fmt, NULL) < 0)
		{
			printf ("[FAILED] Unable to open audio: %s!\n", SDL_GetError());
			exit (EXIT_ERROR);
		}
		SDL_PauseAudio (0);
	}

	/*** main window icon ***/
	snprintf (sImage, MAX_IMG, "%s%s", PNG_VARIOUS, "apoplexy_icon.png");
	imgicon = IMG_Load (sImage);
	SDL_SetWindowIcon (window, imgicon);

	/*** Map window icon ***/
	snprintf (sImage, MAX_IMG, "%s%s", PNG_VARIOUS, "map_icon.png");
	imgicon = IMG_Load (sImage);
	SDL_SetWindowIcon (windowmap, imgicon);

	/*** Open the first available controller. ***/
	iController = 0;
	if (iNoController != 1)
	{
		for (iJoyNr = 0; iJoyNr < SDL_NumJoysticks(); iJoyNr++)
		{
			if (SDL_IsGameController (iJoyNr))
			{
				controller = SDL_GameControllerOpen (iJoyNr);
				if (controller)
				{
					snprintf (sControllerName, MAX_CON, "%s",
						SDL_GameControllerName (controller));
					if (iDebug == 1)
					{
						printf ("[ INFO ] Found a controller \"%s\"; \"%s\".\n",
							sControllerName, SDL_GameControllerNameForIndex (iJoyNr));
					}
					joystick = SDL_GameControllerGetJoystick (controller);
					iController = 1;

					/*** Just for fun, use haptic. ***/
					if (SDL_JoystickIsHaptic (joystick))
					{
						haptic = SDL_HapticOpenFromJoystick (joystick);
						if (SDL_HapticRumbleInit (haptic) == 0)
						{
							SDL_HapticRumblePlay (haptic, 1.0, 1000);
						} else {
							printf ("[ WARN ] Could not initialize the haptic device: %s\n",
								SDL_GetError());
						}
					} else {
						PrIfDe ("[ INFO ] The game controller is not haptic.\n");
					}
				} else {
					printf ("[ WARN ] Could not open game controller %i: %s\n",
						iController, SDL_GetError());
				}
			}
		}
		if (iController != 1) { PrIfDe ("[ INFO ] No controller found.\n"); }
	} else {
		PrIfDe ("[ INFO ] Using keyboard and mouse.\n");
	}

	/*** PoP select ***/
	if (iEditPoP == 0)
	{
		PreLoad (PNG_VARIOUS, "PoP1_PoP2.png", &imgpop);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "PoP1_disabled.png", &imgpop1dis);
			PreLoad (PNG_VARIOUS, "PoP1_off.png", &imgpop1off);
			PreLoad (PNG_VARIOUS, "PoP1_on.png", &imgpop1on);
			PreLoad (PNG_VARIOUS, "PoP2_disabled.png", &imgpop2dis);
			PreLoad (PNG_VARIOUS, "PoP2_off.png", &imgpop2off);
			PreLoad (PNG_VARIOUS, "PoP2_on.png", &imgpop2on);
			PreLoad (PNG_VARIOUS, "PoP1SNES_disabled.png", &imgpop1snesdis);
			PreLoad (PNG_VARIOUS, "PoP1SNES_off.png", &imgpop1snesoff);
			PreLoad (PNG_VARIOUS, "PoP1SNES_on.png", &imgpop1sneson);
			/***/
			PreLoad (PNG_BUTTONS, "Download1.png", &imgdownload1[1]);
			PreLoad (PNG_BUTTONS, "sel_Download1.png", &imgdownload1[2]);
			PreLoad (PNG_BUTTONS, "Download2.png", &imgdownload2[1]);
			PreLoad (PNG_BUTTONS, "sel_Download2.png", &imgdownload2[2]);
			PreLoad (PNG_BUTTONS, "Download3.png", &imgdownload3[1]);
			PreLoad (PNG_BUTTONS, "sel_Download3.png", &imgdownload3[2]);
		} else {
			PreLoad (PNG_CONTROLLER, "PoP1_disabled.png", &imgpop1dis);
			PreLoad (PNG_CONTROLLER, "PoP1_off.png", &imgpop1off);
			PreLoad (PNG_CONTROLLER, "PoP1_on.png", &imgpop1on);
			PreLoad (PNG_CONTROLLER, "PoP2_disabled.png", &imgpop2dis);
			PreLoad (PNG_CONTROLLER, "PoP2_off.png", &imgpop2off);
			PreLoad (PNG_CONTROLLER, "PoP2_on.png", &imgpop2on);
			PreLoad (PNG_CONTROLLER, "PoP1SNES_disabled.png", &imgpop1snesdis);
			PreLoad (PNG_CONTROLLER, "PoP1SNES_off.png", &imgpop1snesoff);
			PreLoad (PNG_CONTROLLER, "PoP1SNES_on.png", &imgpop1sneson);
			/***/
			PreLoad (PNG_CONTROLLER, "Download1.png", &imgdownload1[1]);
			PreLoad (PNG_CONTROLLER, "sel_Download1.png", &imgdownload1[2]);
			PreLoad (PNG_CONTROLLER, "Download2.png", &imgdownload2[1]);
			PreLoad (PNG_CONTROLLER, "sel_Download2.png", &imgdownload2[2]);
			PreLoad (PNG_CONTROLLER, "Download3.png", &imgdownload3[1]);
			PreLoad (PNG_CONTROLLER, "sel_Download3.png", &imgdownload3[2]);
		}
		PreLoad (PNG_VARIOUS, "PR_problem.png", &imgprprob);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "controller_no.png", &imgcontroller);
		} else {
			PreLoad (PNG_VARIOUS, "controller_yes.png", &imgcontroller);
		}
		PreLoad (PNG_VARIOUS, "upgrade_available.png", &imgupgrade);
		PoP1OrPoP2();
		PlaySound ("wav/ok_close.wav");
	}

	/*** loading ***/
	SDL_SetCursor (curWait);
	PreLoad (PNG_VARIOUS, "black.png", &imgblack);
	PreLoad (PNG_VARIOUS, "hourglass.png", &imghourglass);
	PreLoad (PNG_VARIOUS, "hourglass_sprite.png", &imghourglasssprite);
	PreLoad (PNG_VARIOUS, "sand_sprite.png", &imgsandsprite);
	ShowImage (-4, (int[]){1, 0, 0, 0}, ascreen, 31, 0, 0, 692, 455);
	ShowImage (-4, (int[]){2, 0, 0, 0}, ascreen, 46, 0, 0, 93, 89);
	SDL_SetRenderDrawColor (ascreen, 0x22, 0x22, 0x22, SDL_ALPHA_OPAQUE);
	barbox.x = 10 * iScale;
	barbox.y = 10 * iScale;
	barbox.w = 20 * iScale;
	barbox.h = 435 * iScale;
	SDL_RenderFillRect (ascreen, &barbox);
	iHourglassFrame = 1;
	iSandFrame = 1;

	/*** refresh screen ***/
	SDL_RenderPresent (ascreen);

	/*****************************/
	/* Preload all other images. */
	/*****************************/

	iPreLoaded = 0;
	iCurrentBarHeight = 0;
	iStartMilli = SDL_GetTicks();
	switch (iEditPoP)
	{
		/*** These values can be obtained via debug mode. ***/
		case 1: iNrToPreLoad = 841; break;
		case 2: iNrToPreLoad = 871; break;
		case 3: iNrToPreLoad = 4960; break;
	}

	/*** locations; dungeon ***/
	if (iEditPoP == 1)
	{
		PreLoadSet (PNG_DUNGEON, 'd', "0_0", imgd0_0);
		PreLoadSet (PNG_DUNGEON, 'd', "0_1", imgd0_1);
		PreLoadSet (PNG_DUNGEON, 'd', "0_2", imgd0_2);
		PreLoadSet (PNG_DUNGEON, 'd', "0_3", imgd0_3);
		PreLoadSet (PNG_DUNGEON, 'd', "0_255", imgd0_255);
		PreLoadSet (PNG_DUNGEON, 'd', "1_0", imgd1_0);
		PreLoadSet (PNG_DUNGEON, 'd', "1_1", imgd1_1);
		PreLoadSet (PNG_DUNGEON, 'd', "1_2", imgd1_2);
		PreLoadSet (PNG_DUNGEON, 'd', "1_3", imgd1_3);
		PreLoadSet (PNG_DUNGEON, 'd', "1_255", imgd1_255);
		PreLoadSet (PNG_DUNGEON, 'd', "2_0", imgd2_0);
		PreLoadSet (PNG_DUNGEON, 'd', "2_1", imgd2_1);
		PreLoadSet (PNG_DUNGEON, 'd', "2_2", imgd2_2);
		PreLoadSet (PNG_DUNGEON, 'd', "2_3", imgd2_3);
		PreLoadSet (PNG_DUNGEON, 'd', "2_4", imgd2_4);
		PreLoadSet (PNG_DUNGEON, 'd', "2_5", imgd2_5);
		PreLoadSet (PNG_DUNGEON, 'd', "2_6", imgd2_6);
		PreLoadSet (PNG_DUNGEON, 'd', "2_7", imgd2_7);
		PreLoadSet (PNG_DUNGEON, 'd', "2_8", imgd2_8);
		PreLoadSet (PNG_DUNGEON, 'd', "2_9", imgd2_9);
		PreLoadSet (PNG_DUNGEON, 'd', "3_0", imgd3_0);
		PreLoadSet (PNG_DUNGEON, 'd', "4_0", imgd4_0);
		PreLoadSet (PNG_DUNGEON, 'd', "4_1", imgd4_1);
		PreLoadSet (PNG_DUNGEON, 'd', "5_0", imgd5_0);
		PreLoadSet (PNG_DUNGEON, 'd', "6", imgd6);
		PreLoadSet (PNG_DUNGEON, 'd', "7_0", imgd7_0);
		PreLoadSet (PNG_DUNGEON, 'd', "7_1", imgd7_1);
		PreLoadSet (PNG_DUNGEON, 'd', "7_2", imgd7_2);
		PreLoadSet (PNG_DUNGEON, 'd', "7_3", imgd7_3);
		PreLoadSet (PNG_DUNGEON, 'd', "8_0", imgd8_0);
		PreLoadSet (PNG_DUNGEON, 'd', "9_0", imgd9_0);
		PreLoadSet (PNG_DUNGEON, 'd', "10_0", imgd10_0);
		PreLoadSet (PNG_DUNGEON, 'd', "10_1", imgd10_1);
		PreLoadSet (PNG_DUNGEON, 'd', "10_2", imgd10_2);
		PreLoadSet (PNG_DUNGEON, 'd', "10_3", imgd10_3);
		PreLoadSet (PNG_DUNGEON, 'd', "10_4", imgd10_4);
		PreLoadSet (PNG_DUNGEON, 'd', "10_5", imgd10_5);
		PreLoadSet (PNG_DUNGEON, 'd', "10_6", imgd10_6);
		PreLoadSet (PNG_DUNGEON, 'd', "11_0", imgd11_0);
		PreLoadSet (PNG_DUNGEON, 'd', "12_0", imgd12_0);
		PreLoadSet (PNG_DUNGEON, 'd', "12_1", imgd12_1);
		PreLoadSet (PNG_DUNGEON, 'd', "12_2", imgd12_2);
		PreLoadSet (PNG_DUNGEON, 'd', "12_3", imgd12_3);
		PreLoadSet (PNG_DUNGEON, 'd', "12_4", imgd12_4);
		PreLoadSet (PNG_DUNGEON, 'd', "12_5", imgd12_5);
		PreLoadSet (PNG_DUNGEON, 'd', "12_6", imgd12_6);
		PreLoadSet (PNG_DUNGEON, 'd', "12_7", imgd12_7);
		PreLoadSet (PNG_DUNGEON, 'd', "13_0", imgd13_0);
		PreLoadSet (PNG_DUNGEON, 'd', "14_0", imgd14_0);
		PreLoadSet (PNG_DUNGEON, 'd', "15", imgd15);
		PreLoadSet (PNG_DUNGEON, 'd', "16_0", imgd16_0);
		PreLoadSet (PNG_DUNGEON, 'd', "17_0", imgd17_0);
		PreLoadSet (PNG_DUNGEON, 'd', "18_0", imgd18_0);
		PreLoadSet (PNG_DUNGEON, 'd', "18_1", imgd18_1);
		PreLoadSet (PNG_DUNGEON, 'd', "18_2", imgd18_2);
		PreLoadSet (PNG_DUNGEON, 'd', "18_3", imgd18_3);
		PreLoadSet (PNG_DUNGEON, 'd', "18_4", imgd18_4);
		PreLoadSet (PNG_DUNGEON, 'd', "18_5", imgd18_5);
		PreLoadSet (PNG_DUNGEON, 'd', "19_0", imgd19_0);
		PreLoadSet (PNG_DUNGEON, 'd', "20_0", imgd20_0);
		PreLoadSet (PNG_DUNGEON, 'd', "20_1", imgd20_1);
		PreLoadSet (PNG_DUNGEON, 'd', "21_0", imgd21_0);
		PreLoadSet (PNG_DUNGEON, 'd', "22_0", imgd22_0);
		PreLoadSet (PNG_DUNGEON, 'd', "23_0", imgd23_0);
		PreLoadSet (PNG_DUNGEON, 'd', "24_0", imgd24_0);
		PreLoadSet (PNG_DUNGEON, 'd', "25_0", imgd25_0);
		PreLoadSet (PNG_DUNGEON, 'd', "26_0", imgd26_0);
		PreLoadSet (PNG_DUNGEON, 'd', "27_0", imgd27_0);
		PreLoadSet (PNG_DUNGEON, 'd', "28_0", imgd28_0);
		PreLoadSet (PNG_DUNGEON, 'd', "29_0", imgd29_0);
		PreLoadSet (PNG_DUNGEON, 'd', "30_0", imgd30_0);
		PreLoadSet (PNG_DUNGEON, 'd', "43_0", imgd43_0);
		PreLoad (PNG_DUNGEON, "d_19_0_sprite.png", &spriteflamed1);
		PreLoad (PNG_DUNGEON, "d_30_0_sprite.png", &spriteflamed2);
		PreLoad (PNG_DUNGEON, "d_18_0_sprite.png", &spritechomperd);
		PreLoad (PNG_DUNGEON, "d_sel_18_0_sprite.png", &spritechomperdsel);
		PreLoad (PNG_DUNGEON, "d_22_0_sprite.png", &spriteswordd);
		PreLoad (PNG_DUNGEON, "d_sel_22_0_sprite.png", &spritesworddsel);

		/*** native ***/
		PreLoadSet (PNG_DUNGEON, 'd', "0_4", imgd0_4);
		PreLoadSet (PNG_DUNGEON, 'd', "0_5", imgd0_5);
		PreLoadSet (PNG_DUNGEON, 'd', "0_12", imgd0_12);
		PreLoadSet (PNG_DUNGEON, 'd', "0_13", imgd0_13);
		PreLoadSet (PNG_DUNGEON, 'd', "0_50", imgd0_50);
		PreLoadSet (PNG_DUNGEON, 'd', "0_51", imgd0_51);
		PreLoadSet (PNG_DUNGEON, 'd', "0_52", imgd0_52);
		PreLoadSet (PNG_DUNGEON, 'd', "0_53", imgd0_53);
		PreLoadSet (PNG_DUNGEON, 'd', "1_5", imgd1_5);
		PreLoadSet (PNG_DUNGEON, 'd', "1_6", imgd1_6);
		PreLoadSet (PNG_DUNGEON, 'd', "1_13", imgd1_13);
		PreLoadSet (PNG_DUNGEON, 'd', "1_14", imgd1_14);
		PreLoadSet (PNG_DUNGEON, 'd', "1_50", imgd1_50);
		PreLoadSet (PNG_DUNGEON, 'd', "1_51", imgd1_51);
		PreLoadSet (PNG_DUNGEON, 'd', "1_52", imgd1_52);
		PreLoadSet (PNG_DUNGEON, 'd', "1_53", imgd1_53);
		PreLoadSet (PNG_DUNGEON, 'd', "19", imgd19);
		PreLoadSet (PNG_DUNGEON, 'd', "20_4", imgd20_4);
		PreLoadSet (PNG_DUNGEON, 'd', "20_6", imgd20_6);
		PreLoadSet (PNG_DUNGEON, 'd', "20_12", imgd20_12);
		PreLoadSet (PNG_DUNGEON, 'd', "20_14", imgd20_14);
		PreLoadSet (PNG_DUNGEON, 'd', "23", imgd23);
		PreLoadSet (PNG_DUNGEON, 'd', "24", imgd24);
		PreLoadSet (PNG_DUNGEON, 'd', "30", imgd30);
		PreLoad (PNG_DUNGEON, "d_19_sprite.png", &spriteflamed3);
		PreLoad (PNG_DUNGEON, "d_30_sprite.png", &spriteflamed4);
	}

	/*** locations; palace ***/
	if (iEditPoP == 1)
	{
		PreLoadSet (PNG_PALACE, 'p', "0_0", imgp0_0);
		PreLoadSet (PNG_PALACE, 'p', "0_1", imgp0_1);
		PreLoadSet (PNG_PALACE, 'p', "0_2", imgp0_2);
		PreLoadSet (PNG_PALACE, 'p', "0_3", imgp0_3);
		PreLoadSet (PNG_PALACE, 'p', "0_255", imgp0_255);
		PreLoadSet (PNG_PALACE, 'p', "1_0", imgp1_0);
		PreLoadSet (PNG_PALACE, 'p', "1_1", imgp1_1);
		PreLoadSet (PNG_PALACE, 'p', "1_2", imgp1_2);
		PreLoadSet (PNG_PALACE, 'p', "1_3", imgp1_3);
		PreLoadSet (PNG_PALACE, 'p', "1_255", imgp1_255);
		PreLoadSet (PNG_PALACE, 'p', "2_0", imgp2_0);
		PreLoadSet (PNG_PALACE, 'p', "2_1", imgp2_1);
		PreLoadSet (PNG_PALACE, 'p', "2_2", imgp2_2);
		PreLoadSet (PNG_PALACE, 'p', "2_3", imgp2_3);
		PreLoadSet (PNG_PALACE, 'p', "2_4", imgp2_4);
		PreLoadSet (PNG_PALACE, 'p', "2_5", imgp2_5);
		PreLoadSet (PNG_PALACE, 'p', "2_6", imgp2_6);
		PreLoadSet (PNG_PALACE, 'p', "2_7", imgp2_7);
		PreLoadSet (PNG_PALACE, 'p', "2_8", imgp2_8);
		PreLoadSet (PNG_PALACE, 'p', "2_9", imgp2_9);
		PreLoadSet (PNG_PALACE, 'p', "3_0", imgp3_0);
		PreLoadSet (PNG_PALACE, 'p', "4_0", imgp4_0);
		PreLoadSet (PNG_PALACE, 'p', "4_1", imgp4_1);
		PreLoadSet (PNG_PALACE, 'p', "5_0", imgp5_0);
		PreLoadSet (PNG_PALACE, 'p', "6", imgp6);
		PreLoadSet (PNG_PALACE, 'p', "7_0", imgp7_0);
		PreLoadSet (PNG_PALACE, 'p', "7_1", imgp7_1);
		PreLoadSet (PNG_PALACE, 'p', "7_2", imgp7_2);
		PreLoadSet (PNG_PALACE, 'p', "7_3", imgp7_3);
		PreLoadSet (PNG_PALACE, 'p', "8_0", imgp8_0);
		PreLoadSet (PNG_PALACE, 'p', "9_0", imgp9_0);
		PreLoadSet (PNG_PALACE, 'p', "10_0", imgp10_0);
		PreLoadSet (PNG_PALACE, 'p', "10_1", imgp10_1);
		PreLoadSet (PNG_PALACE, 'p', "10_2", imgp10_2);
		PreLoadSet (PNG_PALACE, 'p', "10_3", imgp10_3);
		PreLoadSet (PNG_PALACE, 'p', "10_4", imgp10_4);
		PreLoadSet (PNG_PALACE, 'p', "10_5", imgp10_5);
		PreLoadSet (PNG_PALACE, 'p', "10_6", imgp10_6);
		PreLoadSet (PNG_PALACE, 'p', "11_0", imgp11_0);
		PreLoadSet (PNG_PALACE, 'p', "12_0", imgp12_0);
		PreLoadSet (PNG_PALACE, 'p', "12_1", imgp12_1);
		PreLoadSet (PNG_PALACE, 'p', "12_2", imgp12_2);
		PreLoadSet (PNG_PALACE, 'p', "12_3", imgp12_3);
		PreLoadSet (PNG_PALACE, 'p', "12_4", imgp12_4);
		PreLoadSet (PNG_PALACE, 'p', "12_5", imgp12_5);
		PreLoadSet (PNG_PALACE, 'p', "12_6", imgp12_6);
		PreLoadSet (PNG_PALACE, 'p', "12_7", imgp12_7);
		PreLoadSet (PNG_PALACE, 'p', "13_0", imgp13_0);
		PreLoadSet (PNG_PALACE, 'p', "14_0", imgp14_0);
		PreLoadSet (PNG_PALACE, 'p', "15", imgp15);
		PreLoadSet (PNG_PALACE, 'p', "16_0", imgp16_0);
		PreLoadSet (PNG_PALACE, 'p', "17_0", imgp17_0);
		PreLoadSet (PNG_PALACE, 'p', "18_0", imgp18_0);
		PreLoadSet (PNG_PALACE, 'p', "18_1", imgp18_1);
		PreLoadSet (PNG_PALACE, 'p', "18_2", imgp18_2);
		PreLoadSet (PNG_PALACE, 'p', "18_3", imgp18_3);
		PreLoadSet (PNG_PALACE, 'p', "18_4", imgp18_4);
		PreLoadSet (PNG_PALACE, 'p', "18_5", imgp18_5);
		PreLoadSet (PNG_PALACE, 'p', "19_0", imgp19_0);
		PreLoadSet (PNG_PALACE, 'p', "20_0", imgp20_0);
		PreLoadSet (PNG_PALACE, 'p', "20_1", imgp20_1);
		PreLoadSet (PNG_PALACE, 'p', "21_0", imgp21_0);
		PreLoadSet (PNG_PALACE, 'p', "22_0", imgp22_0);
		PreLoadSet (PNG_PALACE, 'p', "23_0", imgp23_0);
		PreLoadSet (PNG_PALACE, 'p', "24_0", imgp24_0);
		PreLoadSet (PNG_PALACE, 'p', "25_0", imgp25_0);
		PreLoadSet (PNG_PALACE, 'p', "26_0", imgp26_0);
		PreLoadSet (PNG_PALACE, 'p', "27_0", imgp27_0);
		PreLoadSet (PNG_PALACE, 'p', "28_0", imgp28_0);
		PreLoadSet (PNG_PALACE, 'p', "29_0", imgp29_0);
		PreLoadSet (PNG_PALACE, 'p', "30_0", imgp30_0);
		PreLoadSet (PNG_PALACE, 'p', "43_0", imgp43_0);
		PreLoad (PNG_PALACE, "p_19_0_sprite.png", &spriteflamep1);
		PreLoad (PNG_PALACE, "p_30_0_sprite.png", &spriteflamep2);
		PreLoad (PNG_PALACE, "p_18_0_sprite.png", &spritechomperp);
		PreLoad (PNG_PALACE, "p_sel_18_0_sprite.png", &spritechomperpsel);
		PreLoad (PNG_PALACE, "p_22_0_sprite.png", &spriteswordp);
		PreLoad (PNG_PALACE, "p_sel_22_0_sprite.png", &spriteswordpsel);
		PreLoad (PNG_PALACE, "p_26_0_with_lattice.png", &imgp26_0_wl[1]);
		PreLoad (PNG_PALACE, "p_sel_26_0.png", &imgp26_0_wl[2]);

		/*** native ***/
		PreLoadSet (PNG_PALACE, 'p', "0_4", imgp0_4);
		PreLoadSet (PNG_PALACE, 'p', "0_5", imgp0_5);
		PreLoadSet (PNG_PALACE, 'p', "0_12", imgp0_12);
		PreLoadSet (PNG_PALACE, 'p', "0_13", imgp0_13);
		PreLoadSet (PNG_PALACE, 'p', "0_50", imgp0_50);
		PreLoadSet (PNG_PALACE, 'p', "0_51", imgp0_51);
		PreLoadSet (PNG_PALACE, 'p', "0_52", imgp0_52);
		PreLoadSet (PNG_PALACE, 'p', "0_53", imgp0_53);
		PreLoadSet (PNG_PALACE, 'p', "1_5", imgp1_5);
		PreLoadSet (PNG_PALACE, 'p', "1_6", imgp1_6);
		PreLoadSet (PNG_PALACE, 'p', "1_13", imgp1_13);
		PreLoadSet (PNG_PALACE, 'p', "1_14", imgp1_14);
		PreLoadSet (PNG_PALACE, 'p', "1_50", imgp1_50);
		PreLoadSet (PNG_PALACE, 'p', "1_51", imgp1_51);
		PreLoadSet (PNG_PALACE, 'p', "1_52", imgp1_52);
		PreLoadSet (PNG_PALACE, 'p', "1_53", imgp1_53);
		PreLoadSet (PNG_PALACE, 'p', "19", imgp19);
		PreLoadSet (PNG_PALACE, 'p', "20_4", imgp20_4);
		PreLoadSet (PNG_PALACE, 'p', "20_6", imgp20_6);
		PreLoadSet (PNG_PALACE, 'p', "20_12", imgp20_12);
		PreLoadSet (PNG_PALACE, 'p', "20_14", imgp20_14);
		PreLoadSet (PNG_PALACE, 'p', "23", imgp23);
		PreLoadSet (PNG_PALACE, 'p', "24", imgp24);
		PreLoadSet (PNG_PALACE, 'p', "30", imgp30);
		PreLoad (PNG_PALACE, "p_19_sprite.png", &spriteflamep3);
		PreLoad (PNG_PALACE, "p_30_sprite.png", &spriteflamep4);
	}

	/*** locations; rooftops, desert, final ***/
	if (iEditPoP == 2)
	{
		PreLoadSet (PNG_OTH, 'o', "0", imgo0);
		PreLoadSet (PNG_OTH, 'o', "1", imgo1);
		PreLoadSet (PNG_OTH, 'o', "2", imgo2);
		PreLoadSet (PNG_OTH, 'o', "3", imgo3);
		PreLoadSet (PNG_OTH, 'o', "4", imgo4);
		PreLoadSet (PNG_OTH, 'o', "5", imgo5);
		PreLoadSet (PNG_OTH, 'o', "6", imgo6);
		PreLoadSet (PNG_OTH, 'o', "7_0", imgo7_0);
		PreLoadSet (PNG_OTH, 'o', "7_1", imgo7_1);
		PreLoadSet (PNG_OTH, 'o', "7_2", imgo7_2);
		PreLoadSet (PNG_OTH, 'o', "7_3", imgo7_3);
		PreLoadSet (PNG_OTH, 'o', "8", imgo8);
		PreLoadSet (PNG_OTH, 'o', "9", imgo9);
		PreLoadSet (PNG_OTH, 'o', "10_0", imgo10_0);
		PreLoadSet (PNG_OTH, 'o', "10_32", imgo10_32);
		PreLoadSet (PNG_OTH, 'o', "10_64", imgo10_64);
		PreLoadSet (PNG_OTH, 'o', "10_96", imgo10_96);
		PreLoadSet (PNG_OTH, 'o', "10_128", imgo10_128);
		PreLoadSet (PNG_OTH, 'o', "10_160", imgo10_160);
		PreLoadSet (PNG_OTH, 'o', "10_192", imgo10_192);
		PreLoadSet (PNG_OTH, 'o', "10_224", imgo10_224);
		PreLoadSet (PNG_OTH, 'o', "11", imgo11);
		PreLoadSet (PNG_OTH, 'o', "12", imgo12);
		PreLoadSet (PNG_OTH, 'o', "13", imgo13);
		PreLoadSet (PNG_OTH, 'o', "14", imgo14);
		PreLoadSet (PNG_OTH, 'o', "15", imgo15);
		PreLoadSet (PNG_OTH, 'o', "16", imgo16);
		PreLoadSet (PNG_OTH, 'o', "17", imgo17);
		PreLoadSet (PNG_OTH, 'o', "18", imgo18);
		PreLoadSet (PNG_OTH, 'o', "19", imgo19);
		PreLoadSet (PNG_OTH, 'o', "20", imgo20);
		PreLoadSet (PNG_OTH, 'o', "21", imgo21);
		PreLoadSet (PNG_OTH, 'o', "22_0", imgo22_0);
		PreLoadSet (PNG_OTH, 'o', "22_1", imgo22_1);
		PreLoadSet (PNG_OTH, 'o', "23", imgo23);
		PreLoadSet (PNG_OTH, 'o', "24", imgo24);
		PreLoadSet (PNG_OTH, 'o', "25", imgo25);
		PreLoadSet (PNG_OTH, 'o', "26", imgo26);
		PreLoadSet (PNG_OTH, 'o', "27", imgo27);
		PreLoadSet (PNG_OTH, 'o', "28", imgo28);
		PreLoadSet (PNG_OTH, 'o', "29", imgo29);
		PreLoadSet (PNG_OTH, 'o', "30", imgo30);
		PreLoadSet (PNG_OTH, 'o', "31", imgo31);
		PreLoadSet (PNG_OTH, 'o', "32", imgo32);
		PreLoadSet (PNG_OTH, 'o', "33", imgo33);
		PreLoadSet (PNG_OTH, 'o', "34", imgo34);
		PreLoadSet (PNG_OTH, 'o', "35", imgo35);
		PreLoadSet (PNG_OTH, 'o', "36", imgo36);
		PreLoadSet (PNG_OTH, 'o', "37", imgo37);
		PreLoadSet (PNG_OTH, 'o', "38", imgo38);
		PreLoadSet (PNG_OTH, 'o', "39", imgo39);
		PreLoadSet (PNG_OTH, 'o', "40", imgo40);
		PreLoadSet (PNG_OTH, 'o', "41", imgo41);
		PreLoadSet (PNG_OTH, 'o', "43", imgo43);
		PreLoadSet (PNG_OTH, 'o', "44", imgo44);
	}

	/*** locations; caverns ***/
	if (iEditPoP == 2)
	{
		PreLoadSet (PNG_CAVERNS, 'c', "0_0", imgc0_0);
		PreLoadSet (PNG_CAVERNS, 'c', "0_1", imgc0_1);
		PreLoadSet (PNG_CAVERNS, 'c', "0_2", imgc0_2);
		PreLoadSet (PNG_CAVERNS, 'c', "0_3", imgc0_3);
		PreLoadSet (PNG_CAVERNS, 'c', "0_4", imgc0_4);
		PreLoadSet (PNG_CAVERNS, 'c', "1_0", imgc1_0);
		PreLoadSet (PNG_CAVERNS, 'c', "1_1", imgc1_1);
		PreLoadSet (PNG_CAVERNS, 'c', "1_2", imgc1_2);
		PreLoadSet (PNG_CAVERNS, 'c', "2_0", imgc2_0);
		PreLoadSet (PNG_CAVERNS, 'c', "2_5", imgc2_5);
		PreLoadSet (PNG_CAVERNS, 'c', "3", imgc3);
		PreLoadSet (PNG_CAVERNS, 'c', "4_0", imgc4_0);
		PreLoadSet (PNG_CAVERNS, 'c', "4_100", imgc4_100);
		PreLoadSet (PNG_CAVERNS, 'c', "4_200", imgc4_200);
		PreLoadSet (PNG_CAVERNS, 'c', "8_0", imgc8_0);
		PreLoadSet (PNG_CAVERNS, 'c', "8_1", imgc8_1);
		PreLoadSet (PNG_CAVERNS, 'c', "8_2", imgc8_2);
		PreLoadSet (PNG_CAVERNS, 'c', "9", imgc9);
		PreLoadSet (PNG_CAVERNS, 'c', "10_0", imgc10_0);
		PreLoadSet (PNG_CAVERNS, 'c', "10_32", imgc10_32);
		PreLoadSet (PNG_CAVERNS, 'c', "10_64", imgc10_64);
		PreLoadSet (PNG_CAVERNS, 'c', "10_96", imgc10_96);
		PreLoadSet (PNG_CAVERNS, 'c', "10_128", imgc10_128);
		PreLoadSet (PNG_CAVERNS, 'c', "10_160", imgc10_160);
		PreLoadSet (PNG_CAVERNS, 'c', "10_192", imgc10_192);
		PreLoadSet (PNG_CAVERNS, 'c', "10_224", imgc10_224);
		PreLoadSet (PNG_CAVERNS, 'c', "11_0", imgc11_0);
		PreLoadSet (PNG_CAVERNS, 'c', "11_128", imgc11_128);
		PreLoadSet (PNG_CAVERNS, 'c', "14_0", imgc14_0);
		PreLoadSet (PNG_CAVERNS, 'c', "14_1", imgc14_1);
		PreLoadSet (PNG_CAVERNS, 'c', "14_2", imgc14_2);
		PreLoadSet (PNG_CAVERNS, 'c', "16", imgc16);
		PreLoadSet (PNG_CAVERNS, 'c', "17_0", imgc17_0);
		PreLoadSet (PNG_CAVERNS, 'c', "17_21", imgc17_21);
		PreLoadSet (PNG_CAVERNS, 'c', "17_42", imgc17_42);
		PreLoadSet (PNG_CAVERNS, 'c', "18", imgc18);
		PreLoadSet (PNG_CAVERNS, 'c', "19", imgc19);
		PreLoadSet (PNG_CAVERNS, 'c', "20_0", imgc20_0);
		PreLoadSet (PNG_CAVERNS, 'c', "20_1", imgc20_1);
		PreLoadSet (PNG_CAVERNS, 'c', "20_2", imgc20_2);
		PreLoadSet (PNG_CAVERNS, 'c', "20_3", imgc20_3);
		PreLoadSet (PNG_CAVERNS, 'c', "20_4", imgc20_4);
		PreLoadSet (PNG_CAVERNS, 'c', "20_5", imgc20_5);
		PreLoadSet (PNG_CAVERNS, 'c', "20_6", imgc20_6);
		PreLoadSet (PNG_CAVERNS, 'c', "20_7", imgc20_7);
		PreLoadSet (PNG_CAVERNS, 'c', "20_8", imgc20_8);
		PreLoadSet (PNG_CAVERNS, 'c', "20_9", imgc20_9);
		PreLoadSet (PNG_CAVERNS, 'c', "20_10", imgc20_10);
		PreLoadSet (PNG_CAVERNS, 'c', "20_128", imgc20_128);
		PreLoadSet (PNG_CAVERNS, 'c', "20_129", imgc20_129);
		PreLoadSet (PNG_CAVERNS, 'c', "20_130", imgc20_130);
		PreLoadSet (PNG_CAVERNS, 'c', "20_131", imgc20_131);
		PreLoadSet (PNG_CAVERNS, 'c', "20_132", imgc20_132);
		PreLoadSet (PNG_CAVERNS, 'c', "20_133", imgc20_133);
		PreLoadSet (PNG_CAVERNS, 'c', "20_134", imgc20_134);
		PreLoadSet (PNG_CAVERNS, 'c', "20_135", imgc20_135);
		PreLoadSet (PNG_CAVERNS, 'c', "20_136", imgc20_136);
		PreLoadSet (PNG_CAVERNS, 'c', "20_137", imgc20_137);
		PreLoadSet (PNG_CAVERNS, 'c', "20_138", imgc20_138);
		PreLoadSet (PNG_CAVERNS, 'c', "23", imgc23);
		PreLoadSet (PNG_CAVERNS, 'c', "24", imgc24);
		PreLoadSet (PNG_CAVERNS, 'c', "28", imgc28);
		PreLoadSet (PNG_CAVERNS, 'c', "32", imgc32);
		PreLoadSet (PNG_CAVERNS, 'c', "33", imgc33);
		PreLoadSet (PNG_CAVERNS, 'c', "34_E_0", imgc34_E_0);
		PreLoadSet (PNG_CAVERNS, 'c', "34_E_8", imgc34_E_8);
		PreLoadSet (PNG_CAVERNS, 'c', "35", imgc35);
		PreLoadSet (PNG_CAVERNS, 'c', "36", imgc36);
		PreLoadSet (PNG_CAVERNS, 'c', "44", imgc44);
		PreLoad (PNG_CAVERNS, "c_19_sprite.png", &spriteflamec1);
		PreLoad (PNG_CAVERNS, "c_32_sprite.png", &spriteflamec2);
	}

	/*** locations; ruins ***/
	if (iEditPoP == 2)
	{
		PreLoadSet (PNG_RUINS, 'r', "0", imgr0);
		PreLoadSet (PNG_RUINS, 'r', "1_0", imgr1_0);
		PreLoadSet (PNG_RUINS, 'r', "1_1", imgr1_1);
		PreLoadSet (PNG_RUINS, 'r', "1_2", imgr1_2);
		PreLoadSet (PNG_RUINS, 'r', "1_3", imgr1_3);
		PreLoadSet (PNG_RUINS, 'r', "2", imgr2);
		PreLoadSet (PNG_RUINS, 'r', "3_0", imgr3_0);
		PreLoadSet (PNG_RUINS, 'r', "3_1", imgr3_1);
		PreLoadSet (PNG_RUINS, 'r', "3_2", imgr3_2);
		PreLoadSet (PNG_RUINS, 'r', "4_0", imgr4_0);
		PreLoadSet (PNG_RUINS, 'r', "4_100", imgr4_100);
		PreLoadSet (PNG_RUINS, 'r', "4_200", imgr4_200);
		PreLoadSet (PNG_RUINS, 'r', "5_E_0", imgr5_E_0);
		PreLoadSet (PNG_RUINS, 'r', "5_E_8", imgr5_E_8);
		PreLoadSet (PNG_RUINS, 'r', "6_E_0", imgr6_E_0);
		PreLoadSet (PNG_RUINS, 'r', "6_E_8", imgr6_E_8);
		PreLoadSet (PNG_RUINS, 'r', "7_0", imgr7_0);
		PreLoadSet (PNG_RUINS, 'r', "7_1", imgr7_1);
		PreLoadSet (PNG_RUINS, 'r', "7_2", imgr7_2);
		PreLoadSet (PNG_RUINS, 'r', "7_3", imgr7_3);
		PreLoadSet (PNG_RUINS, 'r', "8", imgr8);
		PreLoadSet (PNG_RUINS, 'r', "9", imgr9);
		PreLoadSet (PNG_RUINS, 'r', "10_0", imgr10_0);
		PreLoadSet (PNG_RUINS, 'r', "10_32", imgr10_32);
		PreLoadSet (PNG_RUINS, 'r', "10_64", imgr10_64);
		PreLoadSet (PNG_RUINS, 'r', "10_96", imgr10_96);
		PreLoadSet (PNG_RUINS, 'r', "10_128", imgr10_128);
		PreLoadSet (PNG_RUINS, 'r', "10_160", imgr10_160);
		PreLoadSet (PNG_RUINS, 'r', "10_192", imgr10_192);
		PreLoadSet (PNG_RUINS, 'r', "10_224", imgr10_224);
		PreLoadSet (PNG_RUINS, 'r', "11", imgr11);
		PreLoadSet (PNG_RUINS, 'r', "12_0", imgr12_0);
		PreLoadSet (PNG_RUINS, 'r', "12_128", imgr12_128);
		PreLoadSet (PNG_RUINS, 'r', "12_160", imgr12_160);
		PreLoadSet (PNG_RUINS, 'r', "12_32", imgr12_32);
		PreLoadSet (PNG_RUINS, 'r', "13_0", imgr13_0);
		PreLoadSet (PNG_RUINS, 'r', "13_32", imgr13_32);
		PreLoadSet (PNG_RUINS, 'r', "14_16", imgr14_16);
		PreLoadSet (PNG_RUINS, 'r', "14_32", imgr14_32);
		PreLoadSet (PNG_RUINS, 'r', "14_64", imgr14_64);
		PreLoadSet (PNG_RUINS, 'r', "15_0", imgr15_0);
		PreLoadSet (PNG_RUINS, 'r', "15_1", imgr15_1);
		PreLoadSet (PNG_RUINS, 'r', "15_2", imgr15_2);
		PreLoadSet (PNG_RUINS, 'r', "15_3", imgr15_3);
		PreLoadSet (PNG_RUINS, 'r', "16", imgr16);
		PreLoadSet (PNG_RUINS, 'r', "17_0", imgr17_0);
		PreLoadSet (PNG_RUINS, 'r', "17_21", imgr17_21);
		PreLoadSet (PNG_RUINS, 'r', "17_42", imgr17_42);
		PreLoadSet (PNG_RUINS, 'r', "18", imgr18);
		PreLoadSet (PNG_RUINS, 'r', "20_0", imgr20_0);
		PreLoadSet (PNG_RUINS, 'r', "20_1", imgr20_1);
		PreLoadSet (PNG_RUINS, 'r', "20_2", imgr20_2);
		PreLoadSet (PNG_RUINS, 'r', "20_4", imgr20_4);
		PreLoadSet (PNG_RUINS, 'r', "20_5", imgr20_5);
		PreLoadSet (PNG_RUINS, 'r', "20_6", imgr20_6);
		PreLoadSet (PNG_RUINS, 'r', "20_8", imgr20_8);
		PreLoadSet (PNG_RUINS, 'r', "20_9", imgr20_9);
		PreLoadSet (PNG_RUINS, 'r', "20_10", imgr20_10);
		PreLoadSet (PNG_RUINS, 'r', "20_12", imgr20_12);
		PreLoadSet (PNG_RUINS, 'r', "20_13", imgr20_13);
		PreLoadSet (PNG_RUINS, 'r', "20_14", imgr20_14);
		PreLoadSet (PNG_RUINS, 'r', "21", imgr21);
		PreLoadSet (PNG_RUINS, 'r', "22_1", imgr22_1);
		PreLoadSet (PNG_RUINS, 'r', "22_2", imgr22_2);
	}

	/*** locations; temple ***/
	if (iEditPoP == 2)
	{
		PreLoadSet (PNG_TEMPLE, 't', "0", imgt0);
		PreLoadSet (PNG_TEMPLE, 't', "1_0", imgt1_0);
		PreLoadSet (PNG_TEMPLE, 't', "1_1", imgt1_1);
		PreLoadSet (PNG_TEMPLE, 't', "2_0", imgt2_0);
		PreLoadSet (PNG_TEMPLE, 't', "2_5", imgt2_5);
		PreLoadSet (PNG_TEMPLE, 't', "3_0", imgt3_0);
		PreLoadSet (PNG_TEMPLE, 't', "3_1", imgt3_1);
		PreLoadSet (PNG_TEMPLE, 't', "4_0", imgt4_0);
		PreLoadSet (PNG_TEMPLE, 't', "4_100", imgt4_100);
		PreLoadSet (PNG_TEMPLE, 't', "4_200", imgt4_200);
		PreLoadSet (PNG_TEMPLE, 't', "5_E_0", imgt5_E_0);
		PreLoadSet (PNG_TEMPLE, 't', "5_E_8", imgt5_E_8);
		PreLoadSet (PNG_TEMPLE, 't', "6_E_0", imgt6_E_0);
		PreLoadSet (PNG_TEMPLE, 't', "6_E_8", imgt6_E_8);
		PreLoadSet (PNG_TEMPLE, 't', "8", imgt8);
		PreLoadSet (PNG_TEMPLE, 't', "9", imgt9);
		PreLoadSet (PNG_TEMPLE, 't', "10_0", imgt10_0);
		PreLoadSet (PNG_TEMPLE, 't', "10_32", imgt10_32);
		PreLoadSet (PNG_TEMPLE, 't', "10_64", imgt10_64);
		PreLoadSet (PNG_TEMPLE, 't', "10_96", imgt10_96);
		PreLoadSet (PNG_TEMPLE, 't', "10_128", imgt10_128);
		PreLoadSet (PNG_TEMPLE, 't', "10_160", imgt10_160);
		PreLoadSet (PNG_TEMPLE, 't', "10_192", imgt10_192);
		PreLoadSet (PNG_TEMPLE, 't', "10_224", imgt10_224);
		PreLoadSet (PNG_TEMPLE, 't', "11", imgt11);
		PreLoadSet (PNG_TEMPLE, 't', "12_0", imgt12_0);
		PreLoadSet (PNG_TEMPLE, 't', "12_128", imgt12_128);
		PreLoadSet (PNG_TEMPLE, 't', "12_160", imgt12_160);
		PreLoadSet (PNG_TEMPLE, 't', "12_32", imgt12_32);
		PreLoadSet (PNG_TEMPLE, 't', "13_0", imgt13_0);
		PreLoadSet (PNG_TEMPLE, 't', "13_32", imgt13_32);
		PreLoadSet (PNG_TEMPLE, 't', "14_0", imgt14_0);
		PreLoadSet (PNG_TEMPLE, 't', "14_1", imgt14_1);
		PreLoadSet (PNG_TEMPLE, 't', "16", imgt16);
		PreLoadSet (PNG_TEMPLE, 't', "17_0", imgt17_0);
		PreLoadSet (PNG_TEMPLE, 't', "17_21", imgt17_21);
		PreLoadSet (PNG_TEMPLE, 't', "17_42", imgt17_42);
		PreLoadSet (PNG_TEMPLE, 't', "18", imgt18);
		PreLoadSet (PNG_TEMPLE, 't', "19", imgt19);
		PreLoadSet (PNG_TEMPLE, 't', "20_0", imgt20_0);
		PreLoadSet (PNG_TEMPLE, 't', "20_1", imgt20_1);
		PreLoadSet (PNG_TEMPLE, 't', "20_2", imgt20_2);
		PreLoadSet (PNG_TEMPLE, 't', "25_0", imgt25_0);
		PreLoadSet (PNG_TEMPLE, 't', "25_1", imgt25_1);
		PreLoadSet (PNG_TEMPLE, 't', "25_2", imgt25_2);
		PreLoadSet (PNG_TEMPLE, 't', "26", imgt26);
		PreLoadSet (PNG_TEMPLE, 't', "32", imgt32);
		PreLoad (PNG_TEMPLE, "t_19_sprite.png", &spriteflamet1);
		PreLoad (PNG_TEMPLE, "t_32_sprite.png", &spriteflamet2);
	}

	if (iEditPoP == 3)
	{
		PreLoadTilesSNES ('b'); /*** blue ***/
		PreLoadTilesSNES ('f'); /*** fawn ***/
		PreLoadTilesSNES ('s'); /*** silver ***/
		PreLoadTilesSNES ('l'); /*** lava ***/
		PreLoadTilesSNES ('g'); /*** green ***/
		PreLoadTilesSNES ('u'); /*** umber ***/
		PreLoadTilesSNES ('m'); /*** marble ***/
		PreLoadTilesSNES ('h'); /*** hallway ***/
		PreLoadTilesSNES ('j'); /*** jaffar ***/
		PreLoadTilesSNES ('i'); /*** intro ***/
	}

	if (iEditPoP == 1)
	{
		/*** PoP1 guards ***/
		PreLoad (PNG_LIVING1, "guard_darkblue_beige_l.png", &imggdb[1]);
		PreLoad (PNG_LIVING1, "guard_darkblue_beige_r.png", &imggdb[2]);
		PreLoad (PNG_LIVING1, "guard_green_yellow_l.png", &imgggy[1]);
		PreLoad (PNG_LIVING1, "guard_green_yellow_r.png", &imgggy[2]);
		PreLoad (PNG_LIVING1, "guard_lightblue_pink_l.png", &imgglp[1]);
		PreLoad (PNG_LIVING1, "guard_lightblue_pink_r.png", &imgglp[2]);
		PreLoad (PNG_LIVING1, "guard_orange_yellow_l.png", &imggoy[1]);
		PreLoad (PNG_LIVING1, "guard_orange_yellow_r.png", &imggoy[2]);
		PreLoad (PNG_LIVING1, "guard_purple_beige_l.png", &imggpb[1]);
		PreLoad (PNG_LIVING1, "guard_purple_beige_r.png", &imggpb[2]);
		PreLoad (PNG_LIVING1, "guard_red_purple_l.png", &imggrp[1]);
		PreLoad (PNG_LIVING1, "guard_red_purple_r.png", &imggrp[2]);
		PreLoad (PNG_LIVING1, "guard_yellow_orange_l.png", &imggyo[1]);
		PreLoad (PNG_LIVING1, "guard_yellow_orange_r.png", &imggyo[2]);
		PreLoad (PNG_LIVING1, "guard_unknown_colors_l.png", &imgguc[1]);
		PreLoad (PNG_LIVING1, "guard_unknown_colors_r.png", &imgguc[2]);
		PreLoad (PNG_LIVING1, "skeleton_left.png", &imgskel[1]);
		PreLoad (PNG_LIVING1, "skeleton_right.png", &imgskel[2]);
		PreLoad (PNG_LIVING1, "jaffar_left.png", &imgjaffar[1]);
		PreLoad (PNG_LIVING1, "jaffar_right.png", &imgjaffar[2]);
		PreLoad (PNG_LIVING1, "guard_fat_l.png", &imgfat[1]);
		PreLoad (PNG_LIVING1, "guard_fat_r.png", &imgfat[2]);
		PreLoad (PNG_LIVING1, "shadow_left.png", &imgshadow[1]);
		PreLoad (PNG_LIVING1, "shadow_right.png", &imgshadow[2]);

		/*** PoP1 guards, selected ***/
		PreLoad (PNG_LIVING1, "sel_guard_left.png", &imggsel[1]);
		PreLoad (PNG_LIVING1, "sel_guard_right.png", &imggsel[2]);
		PreLoad (PNG_LIVING1, "sel_skeleton_left.png", &imgskelsel[1]);
		PreLoad (PNG_LIVING1, "sel_skeleton_right.png", &imgskelsel[2]);
		PreLoad (PNG_LIVING1, "sel_jaffar_left.png", &imgjaffarsel[1]);
		PreLoad (PNG_LIVING1, "sel_jaffar_right.png", &imgjaffarsel[2]);
		PreLoad (PNG_LIVING1, "sel_guard_fat_l.png", &imgfatsel[1]);
		PreLoad (PNG_LIVING1, "sel_guard_fat_r.png", &imgfatsel[2]);
		PreLoad (PNG_LIVING1, "sel_shadow_left.png", &imgshadowsel[1]);
		PreLoad (PNG_LIVING1, "sel_shadow_right.png", &imgshadowsel[2]);
	}

	if (iEditPoP == 2)
	{
		/*** PoP2 guards ***/
		PreLoad (PNG_LIVING2, "birdman_l.png", &imgbirdman[1]);
		PreLoad (PNG_LIVING2, "birdman_r.png", &imgbirdman[2]);
		PreLoad (PNG_LIVING2, "fake_prince_l.png", &imgfakeprince[1]);
		PreLoad (PNG_LIVING2, "fake_prince_r.png", &imgfakeprince[2]);
		PreLoad (PNG_LIVING2, "guard_black_l.png", &imgguardblack[1]);
		PreLoad (PNG_LIVING2, "guard_black_r.png", &imgguardblack[2]);
		PreLoad (PNG_LIVING2, "guard_blue_l.png", &imgguardblue[1]);
		PreLoad (PNG_LIVING2, "guard_blue_r.png", &imgguardblue[2]);
		PreLoad (PNG_LIVING2, "guard_red_l.png", &imgguardred[1]);
		PreLoad (PNG_LIVING2, "guard_red_r.png", &imgguardred[2]);
		PreLoad (PNG_LIVING2, "head_long_hair_l.png", &imgheadlong[1]);
		PreLoad (PNG_LIVING2, "head_long_hair_r.png", &imgheadlong[2]);
		PreLoad (PNG_LIVING2, "head_short_hair_l.png", &imgheadshort[1]);
		PreLoad (PNG_LIVING2, "head_short_hair_r.png", &imgheadshort[2]);
		PreLoad (PNG_LIVING2, "skeleton_awake_l.png", &imgskelawake[1]);
		PreLoad (PNG_LIVING2, "skeleton_awake_r.png", &imgskelawake[2]);
		PreLoad (PNG_LIVING2, "skeleton_awakes_l.png", &imgskelawakes[1]);
		PreLoad (PNG_LIVING2, "skeleton_awakes_r.png", &imgskelawakes[2]);
		PreLoad (PNG_LIVING2, "skeleton_awakes_sws_l.png", &imgskelawakessws[1]);
		PreLoad (PNG_LIVING2, "skeleton_awakes_sws_r.png", &imgskelawakessws[2]);
		PreLoad (PNG_LIVING2, "skeleton_sleeps_l.png", &imgskelsleeps[1]);
		PreLoad (PNG_LIVING2, "skeleton_sleeps_r.png", &imgskelsleeps[2]);
		PreLoad (PNG_LIVING2, "snake_l.png", &imgsnake[1]);
		PreLoad (PNG_LIVING2, "snake_r.png", &imgsnake[2]);
		PreLoad (PNG_LIVING2, "sword_l.png", &imgsword[1]);
		PreLoad (PNG_LIVING2, "sword_r.png", &imgsword[2]);
	}

	if (iEditPoP == 3)
	{
		/*** PoP1 for SNES guards (regular and selected) ***/
		PreLoad (PNG_LIVING3, "02_dead_pink_guard_l.png", &imgsg02[1]);
		PreLoad (PNG_LIVING3, "02_dead_pink_guard_r.png", &imgsg02[2]);
		PreLoad (PNG_LIVING3, "sel_02_dead_pink_guard_l.png", &imgsg02sel[1]);
		PreLoad (PNG_LIVING3, "sel_02_dead_pink_guard_r.png", &imgsg02sel[2]);
		PreLoad (PNG_LIVING3, "03_silver_skeleton_l.png", &imgsg03[1]);
		PreLoad (PNG_LIVING3, "03_silver_skeleton_r.png", &imgsg03[2]);
		PreLoad (PNG_LIVING3, "sel_03_silver_skeleton_l.png", &imgsg03sel[1]);
		PreLoad (PNG_LIVING3, "sel_03_silver_skeleton_r.png", &imgsg03sel[2]);
		PreLoad (PNG_LIVING3, "04_bronze_skeleton_l.png", &imgsg04[1]);
		PreLoad (PNG_LIVING3, "04_bronze_skeleton_r.png", &imgsg04[2]);
		PreLoad (PNG_LIVING3, "sel_04_bronze_skeleton_l.png", &imgsg04sel[1]);
		PreLoad (PNG_LIVING3, "sel_04_bronze_skeleton_r.png", &imgsg04sel[2]);
		PreLoad (PNG_LIVING3, "05_golden_skeleton_l.png", &imgsg05[1]);
		PreLoad (PNG_LIVING3, "05_golden_skeleton_r.png", &imgsg05[2]);
		PreLoad (PNG_LIVING3, "sel_05_golden_skeleton_l.png", &imgsg05sel[1]);
		PreLoad (PNG_LIVING3, "sel_05_golden_skeleton_r.png", &imgsg05sel[2]);
		PreLoad (PNG_LIVING3, "06_female_l.png", &imgsg06[1]);
		PreLoad (PNG_LIVING3, "06_female_r.png", &imgsg06[2]);
		PreLoad (PNG_LIVING3, "sel_06_female_l.png", &imgsg06sel[1]);
		PreLoad (PNG_LIVING3, "sel_06_female_r.png", &imgsg06sel[2]);
		PreLoad (PNG_LIVING3, "07_fat_l.png", &imgsg07[1]);
		PreLoad (PNG_LIVING3, "07_fat_r.png", &imgsg07[2]);
		PreLoad (PNG_LIVING3, "sel_07_fat_l.png", &imgsg07sel[1]);
		PreLoad (PNG_LIVING3, "sel_07_fat_r.png", &imgsg07sel[2]);
		PreLoad (PNG_LIVING3, "08_shadow_l.png", &imgsg08[1]);
		PreLoad (PNG_LIVING3, "08_shadow_r.png", &imgsg08[2]);
		PreLoad (PNG_LIVING3, "sel_08_shadow_l.png", &imgsg08sel[1]);
		PreLoad (PNG_LIVING3, "sel_08_shadow_r.png", &imgsg08sel[2]);
		PreLoad (PNG_LIVING3, "09_green_guard_l.png", &imgsg09[1]);
		PreLoad (PNG_LIVING3, "09_green_guard_r.png", &imgsg09[2]);
		PreLoad (PNG_LIVING3, "sel_09_green_guard_l.png", &imgsg09sel[1]);
		PreLoad (PNG_LIVING3, "sel_09_green_guard_r.png", &imgsg09sel[2]);
		PreLoad (PNG_LIVING3, "0a_greenish_blue_guard_l.png", &imgsg0a[1]);
		PreLoad (PNG_LIVING3, "0a_greenish_blue_guard_r.png", &imgsg0a[2]);
		PreLoad (PNG_LIVING3, "sel_0a_greenish_blue_guard_l.png", &imgsg0asel[1]);
		PreLoad (PNG_LIVING3, "sel_0a_greenish_blue_guard_r.png", &imgsg0asel[2]);
		PreLoad (PNG_LIVING3, "0b_blue_guard_l.png", &imgsg0b[1]);
		PreLoad (PNG_LIVING3, "0b_blue_guard_r.png", &imgsg0b[2]);
		PreLoad (PNG_LIVING3, "sel_0b_blue_guard_l.png", &imgsg0bsel[1]);
		PreLoad (PNG_LIVING3, "sel_0b_blue_guard_r.png", &imgsg0bsel[2]);
		PreLoad (PNG_LIVING3, "0c_red_guard_l.png", &imgsg0c[1]);
		PreLoad (PNG_LIVING3, "0c_red_guard_r.png", &imgsg0c[2]);
		PreLoad (PNG_LIVING3, "sel_0c_red_guard_l.png", &imgsg0csel[1]);
		PreLoad (PNG_LIVING3, "sel_0c_red_guard_r.png", &imgsg0csel[2]);
		PreLoad (PNG_LIVING3, "0d_purple_guard_l.png", &imgsg0d[1]);
		PreLoad (PNG_LIVING3, "0d_purple_guard_r.png", &imgsg0d[2]);
		PreLoad (PNG_LIVING3, "sel_0d_purple_guard_l.png", &imgsg0dsel[1]);
		PreLoad (PNG_LIVING3, "sel_0d_purple_guard_r.png", &imgsg0dsel[2]);
		PreLoad (PNG_LIVING3, "0e_blue_faced_guard_l.png", &imgsg0e[1]);
		PreLoad (PNG_LIVING3, "0e_blue_faced_guard_r.png", &imgsg0e[2]);
		PreLoad (PNG_LIVING3, "sel_0e_blue_faced_guard_l.png", &imgsg0esel[1]);
		PreLoad (PNG_LIVING3, "sel_0e_blue_faced_guard_r.png", &imgsg0esel[2]);
		PreLoad (PNG_LIVING3, "0f_red_knight_l.png", &imgsg0f[1]);
		PreLoad (PNG_LIVING3, "0f_red_knight_r.png", &imgsg0f[2]);
		PreLoad (PNG_LIVING3, "sel_0f_red_knight_l.png", &imgsg0fsel[1]);
		PreLoad (PNG_LIVING3, "sel_0f_red_knight_r.png", &imgsg0fsel[2]);
		PreLoad (PNG_LIVING3, "10_blue_knight_l.png", &imgsg10[1]);
		PreLoad (PNG_LIVING3, "10_blue_knight_r.png", &imgsg10[2]);
		PreLoad (PNG_LIVING3, "sel_10_blue_knight_l.png", &imgsg10sel[1]);
		PreLoad (PNG_LIVING3, "sel_10_blue_knight_r.png", &imgsg10sel[2]);
		PreLoad (PNG_LIVING3, "11_sinbad_kali_idol_l.png", &imgsg11[1]);
		PreLoad (PNG_LIVING3, "11_sinbad_kali_idol_r.png", &imgsg11[2]);
		PreLoad (PNG_LIVING3, "sel_11_sinbad_kali_idol_l.png", &imgsg11sel[1]);
		PreLoad (PNG_LIVING3, "sel_11_sinbad_kali_idol_r.png", &imgsg11sel[2]);
		PreLoad (PNG_LIVING3, "12_jaffar_l.png", &imgsg12[1]);
		PreLoad (PNG_LIVING3, "12_jaffar_r.png", &imgsg12[2]);
		PreLoad (PNG_LIVING3, "sel_12_jaffar_l.png", &imgsg12sel[1]);
		PreLoad (PNG_LIVING3, "sel_12_jaffar_r.png", &imgsg12sel[2]);
		PreLoad (PNG_LIVING3, "13_dead_white_guard_l.png", &imgsg13[1]);
		PreLoad (PNG_LIVING3, "13_dead_white_guard_r.png", &imgsg13[2]);
		PreLoad (PNG_LIVING3, "sel_13_dead_white_guard_l.png", &imgsg13sel[1]);
		PreLoad (PNG_LIVING3, "sel_13_dead_white_guard_r.png", &imgsg13sel[2]);
	}

	/*** various ***/
	if (iEditPoP == 1)
	{
		PreLoad (PNG_VARIOUS, "no_other.png", &imgdother);
		PreLoad (PNG_VARIOUS, "no_jaffar.png", &imgdjaffar);
		PreLoad (PNG_VARIOUS, "no_guards.png", &imgdguards);
	}
	PreLoad (PNG_VARIOUS, "prince_warning.png", &imgprincew);
	switch (iEditPoP)
	{
		case 1:
			PreLoad (PNG_VARIOUS, "unknown.png", &imgunk[1]);
			PreLoad (PNG_VARIOUS, "sel_unknown.png", &imgunk[2]);
			break;
		case 2:
			PreLoad (PNG_VARIOUS, "unknown_pop2.png", &imgunk[1]);
			PreLoad (PNG_VARIOUS, "sel_unknown_pop2.png", &imgunk[2]);
			break;
		case 3:
			PreLoad (PNG_VARIOUS, "unknown_snes.png", &imgunk[1]);
			PreLoad (PNG_VARIOUS, "sel_unknown_snes.png", &imgunk[2]);
			break;
	}
	PreLoad (PNG_BUTTONS, "up_0.png", &imgup_0);
	PreLoad (PNG_BUTTONS, "up_1.png", &imgup_1);
	PreLoad (PNG_BUTTONS, "down_0.png", &imgdown_0);
	PreLoad (PNG_BUTTONS, "down_1.png", &imgdown_1);
	PreLoad (PNG_BUTTONS, "left_0.png", &imgleft_0);
	PreLoad (PNG_BUTTONS, "left_1.png", &imgleft_1);
	PreLoad (PNG_BUTTONS, "right_0.png", &imgright_0);
	PreLoad (PNG_BUTTONS, "right_1.png", &imgright_1);
	PreLoad (PNG_BUTTONS, "up_down_no.png", &imgudno);
	PreLoad (PNG_BUTTONS, "left_right_no.png", &imglrno);
	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "up_down_no_nfo.png", &imgudnonfo);
		PreLoad (PNG_BUTTONS, "previous_on_0.png", &imgprevon_0);
		PreLoad (PNG_BUTTONS, "previous_on_1.png", &imgprevon_1);
		PreLoad (PNG_BUTTONS, "next_on_0.png", &imgnexton_0);
		PreLoad (PNG_BUTTONS, "next_on_1.png", &imgnexton_1);
		PreLoad (PNG_BUTTONS, "previous_off.png", &imgprevoff);
		PreLoad (PNG_BUTTONS, "next_off.png", &imgnextoff);
	} else {
		PreLoad (PNG_CONTROLLER, "up_down_no_nfo.png", &imgudnonfo);
		PreLoad (PNG_CONTROLLER, "previous_on_0.png", &imgprevon_0);
		PreLoad (PNG_CONTROLLER, "previous_on_1.png", &imgprevon_1);
		PreLoad (PNG_CONTROLLER, "next_on_0.png", &imgnexton_0);
		PreLoad (PNG_CONTROLLER, "next_on_1.png", &imgnexton_1);
		PreLoad (PNG_CONTROLLER, "previous_off.png", &imgprevoff);
		PreLoad (PNG_CONTROLLER, "next_off.png", &imgnextoff);
	}
	if (iEditPoP != 3)
	{
		PreLoad (PNG_VARIOUS, "distort.png", &imgdistort);
	} else {
		PreLoad (PNG_VARIOUS, "tooltip.png", &imgtooltip);
	}
	if (iEditPoP == 1)
	{
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "level_bar.png", &imgbar);
		} else {
			PreLoad (PNG_CONTROLLER, "level_bar.png", &imgbar);
		}
	}
	if (iEditPoP == 2)
	{
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "level_bar_pop2.png", &imgbar);
		} else {
			PreLoad (PNG_CONTROLLER, "level_bar_pop2.png", &imgbar);
		}
		PreLoad (PNG_VARIOUS, "guard_row.png", &imgguard_row);
		PreLoad (PNG_VARIOUS, "guard_entry.png", &imgguard_entry);
		PreLoad (PNG_VARIOUS, "faded_dynamic_guard.png", &imgfadeddg);
		PreLoad (PNG_VARIOUS, "faded_static_guard_left.png", &imgfadedsgl);
		PreLoad (PNG_VARIOUS, "faded_static_guard_right.png", &imgfadedsgr);
		PreLoad (PNG_VARIOUS, "X-coordinate_tooltip.png", &imgxtooltip);
		PreLoad (PNG_VARIOUS, "level_10_warning.png", &imgl10warn);
		PreLoad (PNG_VARIOUS, "guardwarn_255.png", &imggw_255);
		PreLoad (PNG_VARIOUS, "guardwarn_2.png", &imggw_2);
		PreLoad (PNG_VARIOUS, "guardwarn_5.png", &imggw_5);
		PreLoad (PNG_VARIOUS, "guardwarn_7.png", &imggw_7);
		PreLoad (PNG_VARIOUS, "guardwarn_0.png", &imggw_0);
		PreLoad (PNG_VARIOUS, "guardwarn_dynamic.png", &imggw_dynamic);
		PreLoad (PNG_VARIOUS, "sel_back.png", &imgsb);
		PreLoad (PNG_VARIOUS, "hi_back.png", &imghb);
	}
	if (iEditPoP == 3)
	{
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "level_bar_snes.png", &imgbar);
		} else {
			PreLoad (PNG_CONTROLLER, "level_bar_snes.png", &imgbar);
		}
		PreLoad (PNG_VARIOUS, "sel_back_snes.png", &imgsb);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "hi_back_snes.png", &imghb);
		} else {
			PreLoad (PNG_CONTROLLER, "hi_back_snes.png", &imghb);
		}
		PreLoad (PNG_VARIOUS, "level_21_warning.png", &imgl21warn);
		PreLoad (PNG_VARIOUS, "skill_tooltip.png", &imgstooltip);
		PreLoad (PNG_VARIOUS, "ZSNES.png", &imgzsnes);
		PreLoad (PNG_VARIOUS, "jaffar_tooltip.png", &imgjtooltip);
	}
	PreLoad (PNG_VARIOUS, "hi_check.png", &imghc);

	if (iEditPoP == 3)
	{
		PreLoad (PNG_VARIOUS, "dotted_back.png", &imgsbs);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "custom_snes.png", &imgcustoms);
		} else {
			PreLoad (PNG_CONTROLLER, "custom_snes.png", &imgcustoms);
		}
	}

	if (iEditPoP == 2)
	{
		PreLoad (PNG_INCOMING, "incomingl0.png", &imgincomingl[0]);
		PreLoad (PNG_INCOMING, "incomingl1.png", &imgincomingl[1]);
		PreLoad (PNG_INCOMING, "incomingl2.png", &imgincomingl[2]);
		PreLoad (PNG_INCOMING, "incomingl3.png", &imgincomingl[3]);
		PreLoad (PNG_INCOMING, "incomingl4.png", &imgincomingl[4]);
		PreLoad (PNG_INCOMING, "incomingl5.png", &imgincomingl[5]);
		PreLoad (PNG_INCOMING, "incomingl6.png", &imgincomingl[6]);
		PreLoad (PNG_INCOMING, "incomingl7.png", &imgincomingl[7]);
		PreLoad (PNG_INCOMING, "incomingl8.png", &imgincomingl[8]);
		PreLoad (PNG_INCOMING, "incomingl9.png", &imgincomingl[9]);
		PreLoad (PNG_INCOMING, "incomingl-.png", &imgincomingl[10]);
		PreLoad (PNG_INCOMING, "incomingr0.png", &imgincomingr[0]);
		PreLoad (PNG_INCOMING, "incomingr1.png", &imgincomingr[1]);
		PreLoad (PNG_INCOMING, "incomingr2.png", &imgincomingr[2]);
		PreLoad (PNG_INCOMING, "incomingr3.png", &imgincomingr[3]);
		PreLoad (PNG_INCOMING, "incomingr4.png", &imgincomingr[4]);
		PreLoad (PNG_INCOMING, "incomingr5.png", &imgincomingr[5]);
		PreLoad (PNG_INCOMING, "incomingr6.png", &imgincomingr[6]);
		PreLoad (PNG_INCOMING, "incomingr7.png", &imgincomingr[7]);
		PreLoad (PNG_INCOMING, "incomingr8.png", &imgincomingr[8]);
		PreLoad (PNG_INCOMING, "incomingr9.png", &imgincomingr[9]);
		PreLoad (PNG_INCOMING, "incomingr-.png", &imgincomingr[10]);
	}

	/*** extras ***/
	PreLoad (PNG_EXTRAS, "extras_00.png", &extras_0);
	PreLoad (PNG_EXTRAS, "extras_01.png", &extras_1);
	PreLoad (PNG_EXTRAS, "extras_02.png", &extras_2);
	PreLoad (PNG_EXTRAS, "extras_03.png", &extras_3);
	PreLoad (PNG_EXTRAS, "extras_04.png", &extras_4);
	PreLoad (PNG_EXTRAS, "extras_05.png", &extras_5);
	PreLoad (PNG_EXTRAS, "extras_06.png", &extras_6);
	PreLoad (PNG_EXTRAS, "extras_07.png", &extras_7);
	PreLoad (PNG_EXTRAS, "extras_08.png", &extras_8);
	PreLoad (PNG_EXTRAS, "extras_09.png", &extras_9);
	PreLoad (PNG_EXTRAS, "extras_10.png", &extras_10);

	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "rooms_on_0.png", &imgroomson_0);
		PreLoad (PNG_BUTTONS, "rooms_on_1.png", &imgroomson_1);
		PreLoad (PNG_BUTTONS, "rooms_off.png", &imgroomsoff);
		PreLoad (PNG_BUTTONS, "broken_rooms_on_0.png", &imgbroomson_0);
		PreLoad (PNG_BUTTONS, "broken_rooms_on_1.png", &imgbroomson_1);
		PreLoad (PNG_BUTTONS, "broken_rooms_off.png", &imgbroomsoff);
		/***/
		PreLoad (PNG_BUTTONS, "events_on_0.png", &imgeventson_0);
		PreLoad (PNG_BUTTONS, "events_on_1.png", &imgeventson_1);
		PreLoad (PNG_BUTTONS, "events_off.png", &imgeventsoff);
		PreLoad (PNG_BUTTONS, "save_on_0.png", &imgsaveon_0);
		PreLoad (PNG_BUTTONS, "save_on_1.png", &imgsaveon_1);
		PreLoad (PNG_BUTTONS, "save_off.png", &imgsaveoff);
		PreLoad (PNG_BUTTONS, "save_off_perm.png", &imgsoffp);
		PreLoad (PNG_BUTTONS, "quit_0.png", &imgquit_0);
		PreLoad (PNG_BUTTONS, "quit_1.png", &imgquit_1);
		PreLoad (PNG_VARIOUS, "room_links.png", &imgrl);
		PreLoad (PNG_VARIOUS, "broken_room_links.png", &imgbrl);
		if (iEditPoP == 2)
		{
			PreLoad (PNG_VARIOUS, "room_links_25-32.png", &imgrl2);
			PreLoad (PNG_VARIOUS, "broken_room_links_25-32.png", &imgbrl2);
		}
	} else {
		PreLoad (PNG_CONTROLLER, "rooms_on_0.png", &imgroomson_0);
		PreLoad (PNG_CONTROLLER, "rooms_on_1.png", &imgroomson_1);
		PreLoad (PNG_CONTROLLER, "rooms_off.png", &imgroomsoff);
		PreLoad (PNG_CONTROLLER, "broken_rooms_on_0.png", &imgbroomson_0);
		PreLoad (PNG_CONTROLLER, "broken_rooms_on_1.png", &imgbroomson_1);
		PreLoad (PNG_CONTROLLER, "broken_rooms_off.png", &imgbroomsoff);
		/***/
		PreLoad (PNG_CONTROLLER, "events_on_0.png", &imgeventson_0);
		PreLoad (PNG_CONTROLLER, "events_on_1.png", &imgeventson_1);
		PreLoad (PNG_CONTROLLER, "events_off.png", &imgeventsoff);
		PreLoad (PNG_CONTROLLER, "save_on_0.png", &imgsaveon_0);
		PreLoad (PNG_CONTROLLER, "save_on_1.png", &imgsaveon_1);
		PreLoad (PNG_CONTROLLER, "save_off.png", &imgsaveoff);
		PreLoad (PNG_CONTROLLER, "save_off_perm.png", &imgsoffp);
		PreLoad (PNG_CONTROLLER, "quit_0.png", &imgquit_0);
		PreLoad (PNG_CONTROLLER, "quit_1.png", &imgquit_1);
		PreLoad (PNG_CONTROLLER, "room_links.png", &imgrl);
		PreLoad (PNG_CONTROLLER, "broken_room_links.png", &imgbrl);
		if (iEditPoP == 2)
		{
			PreLoad (PNG_CONTROLLER, "room_links_25-32.png", &imgrl2);
			PreLoad (PNG_CONTROLLER, "broken_room_links_25-32.png", &imgbrl2);
		}
	}
	PreLoad (PNG_VARIOUS, "sel_room_current.png", &imgsrc);
	PreLoad (PNG_VARIOUS, "sel_room_start.png", &imgsrs);
	PreLoad (PNG_VARIOUS, "sel_room_moving.png", &imgsrm);
	PreLoad (PNG_VARIOUS, "sel_room_cross.png", &imgsrp);
	PreLoad (PNG_VARIOUS, "sel_room_broken.png", &imgsrb);
	if (iEditPoP == 3)
	{
		PreLoad (PNG_VARIOUS, "sel_room_outdoor.png", &imgsro);
		PreLoad (PNG_VARIOUS, "broken_room_links_outdoor.png", &imgbrl3);
	}

	switch (iEditPoP)
	{
		case 1:
			PreLoad (PNG_LIVING1, "kid_right.png", &imgkidr[1]);
			PreLoad (PNG_LIVING1, "sel_kid_right.png", &imgkidr[2]);
			PreLoad (PNG_LIVING1, "kid_left.png", &imgkidl[1]);
			PreLoad (PNG_LIVING1, "sel_kid_left.png", &imgkidl[2]);
			break;
		case 2:
			PreLoad (PNG_LIVING2, "kid_right.png", &imgkidr[1]);
			PreLoad (PNG_LIVING2, "sel_kid_right.png", &imgkidr[2]);
			PreLoad (PNG_LIVING2, "kid_left.png", &imgkidl[1]);
			PreLoad (PNG_LIVING2, "sel_kid_left.png", &imgkidl[2]);
			break;
		case 3:
			PreLoad (PNG_LIVING3, "kid_right.png", &imgkidr[1]);
			PreLoad (PNG_LIVING3, "sel_kid_right.png", &imgkidr[2]);
			PreLoad (PNG_LIVING3, "kid_left.png", &imgkidl[1]);
			PreLoad (PNG_LIVING3, "sel_kid_left.png", &imgkidl[2]);
			PreLoad (PNG_LIVING3, "kid_right_red.png", &imgkidrr[1]);
			PreLoad (PNG_LIVING3, "sel_kid_right_red.png", &imgkidrr[2]);
			PreLoad (PNG_LIVING3, "kid_left_red.png", &imgkidlr[1]);
			PreLoad (PNG_LIVING3, "sel_kid_left_red.png", &imgkidlr[2]);
			break;
	}

	if (iEditPoP != 2)
	{
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "events.png", &imgevents);
		} else {
			PreLoad (PNG_CONTROLLER, "events.png", &imgevents);
		}
	} else {
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "events_pop2.png", &imgevents);
		} else {
			PreLoad (PNG_CONTROLLER, "events_pop2.png", &imgevents);
		}
	}
	PreLoad (PNG_VARIOUS, "event_unused.png", &imgeventu);
	PreLoad (PNG_VARIOUS, "chk_black.png", &imgchkb);
	PreLoad (PNG_VARIOUS, "chk_green.png", &imgchkg);

	/*** tiles screens ***/
	if (iEditPoP == 1)
	{
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "dungeon.png", &imgdungeon);
			PreLoad (PNG_VARIOUS, "palace.png", &imgpalace);
		} else {
			PreLoad (PNG_CONTROLLER, "dungeon.png", &imgdungeon);
			PreLoad (PNG_CONTROLLER, "palace.png", &imgpalace);
		}
		PreLoad (PNG_VARIOUS, "event_hover.png", &imgeventh);
	} else if (iEditPoP == 2) {
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "oth.png", &imgoth);
			PreLoad (PNG_VARIOUS, "caverns.png", &imgcaverns);
			PreLoad (PNG_VARIOUS, "ruins.png", &imgruins);
		} else {
			PreLoad (PNG_CONTROLLER, "oth.png", &imgoth);
			PreLoad (PNG_CONTROLLER, "caverns.png", &imgcaverns);
			PreLoad (PNG_CONTROLLER, "ruins.png", &imgruins);
		}
		PreLoad (PNG_VARIOUS, "ruins_back.png", &imgruins_back);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "temple.png", &imgtemple);
		} else {
			PreLoad (PNG_CONTROLLER, "temple.png", &imgtemple);
		}
		PreLoad (PNG_VARIOUS, "temple_back.png", &imgtemple_back);
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "guards.png", &imgguards);
			PreLoad (PNG_VARIOUS, "music.png", &imgmusic);
		} else {
			PreLoad (PNG_CONTROLLER, "guards.png", &imgguards);
			PreLoad (PNG_CONTROLLER, "music.png", &imgmusic);
		}
		PreLoad (PNG_MUSIC, "music_note.png", &imgmusic_note);
		PreLoad (PNG_MUSIC, "music_all_0.png", &imgm_all_0);
		PreLoad (PNG_MUSIC, "music_all_1.png", &imgm_all_1);
		PreLoad (PNG_MUSIC, "music_none_0.png", &imgm_none_0);
		PreLoad (PNG_MUSIC, "music_none_1.png", &imgm_none_1);
		PreLoad (PNG_MUSIC, "music_left_0.png", &imgm_left_0);
		PreLoad (PNG_MUSIC, "music_left_1.png", &imgm_left_1);
		PreLoad (PNG_MUSIC, "music_right_0.png", &imgm_right_0);
		PreLoad (PNG_MUSIC, "music_right_1.png", &imgm_right_1);
		PreLoad (PNG_MUSIC, "music_top_0.png", &imgm_top_0);
		PreLoad (PNG_MUSIC, "music_top_1.png", &imgm_top_1);
		PreLoad (PNG_MUSIC, "music_middle_0.png", &imgm_middle_0);
		PreLoad (PNG_MUSIC, "music_middle_1.png", &imgm_middle_1);
		PreLoad (PNG_MUSIC, "music_bottom_0.png", &imgm_bottom_0);
		PreLoad (PNG_MUSIC, "music_bottom_1.png", &imgm_bottom_1);
		PreLoad (PNG_MUSIC, "music_invert_0.png", &imgm_invert_0);
		PreLoad (PNG_MUSIC, "music_invert_1.png", &imgm_invert_1);
	} else {
		if (iController != 1)
		{
			PreLoad (PNG_VARIOUS, "blue.png", &imgblue);
			PreLoad (PNG_VARIOUS, "fawn.png", &imgfawn);
			PreLoad (PNG_VARIOUS, "silver.png", &imgsilver);
			PreLoad (PNG_VARIOUS, "lava.png", &imglava);
			PreLoad (PNG_VARIOUS, "green.png", &imggreen);
			PreLoad (PNG_VARIOUS, "umber.png", &imgumber);
			PreLoad (PNG_VARIOUS, "marble.png", &imgmarble);
			PreLoad (PNG_VARIOUS, "hallway.png", &imghallway);
			PreLoad (PNG_VARIOUS, "jaffar.png", &imgjaffart);
			PreLoad (PNG_VARIOUS, "intro.png", &imgintro);
			/***/
			PreLoad (PNG_VARIOUS, "snes_back.png", &imgsnesback);
			PreLoad (PNG_VARIOUS, "snes_temp.png", &imgsnestemp);
		} else {
			PreLoad (PNG_CONTROLLER, "blue.png", &imgblue);
			PreLoad (PNG_CONTROLLER, "fawn.png", &imgfawn);
			PreLoad (PNG_CONTROLLER, "silver.png", &imgsilver);
			PreLoad (PNG_CONTROLLER, "lava.png", &imglava);
			PreLoad (PNG_CONTROLLER, "green.png", &imggreen);
			PreLoad (PNG_CONTROLLER, "umber.png", &imgumber);
			PreLoad (PNG_CONTROLLER, "marble.png", &imgmarble);
			PreLoad (PNG_CONTROLLER, "hallway.png", &imghallway);
			PreLoad (PNG_CONTROLLER, "jaffar.png", &imgjaffart);
			PreLoad (PNG_CONTROLLER, "intro.png", &imgintro);
			/***/
			PreLoad (PNG_CONTROLLER, "snes_back.png", &imgsnesback);
			PreLoad (PNG_CONTROLLER, "snes_temp.png", &imgsnestemp);
		}
		PreLoad (PNG_VARIOUS, "animated_back.png", &imganimback);
		PreLoad (PNG_BACKSS, "blue.png", &imgblueb);
		PreLoad (PNG_BACKSS, "fawn.png", &imgfawnb);
		PreLoad (PNG_BACKSS, "silver.png", &imgsilverb);
		PreLoad (PNG_BACKSS, "lava.png", &imglavab);
		PreLoad (PNG_BACKSS, "green.png", &imggreenb);
		PreLoad (PNG_BACKSS, "umber.png", &imgumberb);
		PreLoad (PNG_BACKSS, "marble.png", &imgmarbleb);
		PreLoad (PNG_BACKSS, "hallway.png", &imghallwayb);
		PreLoad (PNG_BACKSS, "jaffar.png", &imgjaffarb);
		PreLoad (PNG_BACKSS, "intro.png", &imgintrob);
		PreLoad (PNG_TEMPS, "blue.png", &imgtempb);
		PreLoad (PNG_TEMPS, "fawn.png", &imgtempf);
		PreLoad (PNG_TEMPS, "silver.png", &imgtemps);
		PreLoad (PNG_TEMPS, "lava.png", &imgtempl);
		PreLoad (PNG_TEMPS, "green.png", &imgtempg);
		PreLoad (PNG_TEMPS, "umber.png", &imgtempu);
		PreLoad (PNG_TEMPS, "marble.png", &imgtempm);
		PreLoad (PNG_TEMPS, "hallway.png", &imgtemph);
		PreLoad (PNG_TEMPS, "jaffar.png", &imgtempj);
		PreLoad (PNG_TEMPS, "intro.png", &imgtempi);
	}

	if (iEditPoP == 2)
	{
		PreLoad (PNG_BACK, "PoP2_l1r1.png", &backl1r1);
		PreLoad (PNG_BACK, "PoP2_l1r2.png", &backl1r2);
		PreLoad (PNG_BACK, "PoP2_l1r3.png", &backl1r3);
		PreLoad (PNG_BACK, "PoP2_l1r4.png", &backl1r4);
		PreLoad (PNG_BACK, "PoP2_l1r5.png", &backl1r5);
		PreLoad (PNG_BACK, "PoP2_l1r10.png", &backl1r10);
		PreLoad (PNG_BACK, "PoP2_l1r11.png", &backl1r11);
		PreLoad (PNG_BACK, "PoP2_l1r12.png", &backl1r12);
		PreLoad (PNG_BACK, "PoP2_l1r15.png", &backl1r15);
		PreLoad (PNG_BACK, "PoP2_l1r16.png", &backl1r16);
		PreLoad (PNG_BACK, "PoP2_l1r19.png", &backl1r19);
		PreLoad (PNG_BACK, "PoP2_l2r1.png", &backl2r1);
		PreLoad (PNG_BACK, "PoP2_l2r2.png", &backl2r2);
		PreLoad (PNG_BACK, "PoP2_l2r3.png", &backl2r3);
		PreLoad (PNG_BACK, "PoP2_l14r1.png", &backl14r1);
		PreLoad (PNG_BACK, "PoP2_l14r2.png", &backl14r2);
		PreLoad (PNG_BACK, "PoP2_l14r3.png", &backl14r3);
		PreLoad (PNG_BACK, "PoP2_l14r4.png", &backl14r4);
		PreLoad (PNG_BACK, "PoP2_l14r5.png", &backl14r5);
		PreLoad (PNG_BACK, "PoP2_l14r6.png", &backl14r6);
		PreLoad (PNG_BACK, "PoP2_l14r7.png", &backl14r7);
		PreLoad (PNG_BACK, "PoP2_l14r8.png", &backl14r8);
		PreLoad (PNG_BACK, "PoP2_l6r27.png", &backl6r27);
		PreLoad (PNG_BACK, "PoP2_l9r2.png", &backl9r2);
		PreLoad (PNG_BACK, "PoP2_l9r11.png", &backl9r11);
		PreLoad (PNG_BACK, "PoP2_l9r12.png", &backl9r12);
		PreLoad (PNG_BACK, "PoP2_l9r13.png", &backl9r13);
		PreLoad (PNG_BACK, "PoP2_l9r14.png", &backl9r14);
		PreLoad (PNG_BACK, "PoP2_l9r15.png", &backl9r15);
		PreLoad (PNG_BACK, "PoP2_l9r16.png", &backl9r16);
		PreLoad (PNG_BACK, "PoP2_l13r4.png", &backl13r4);
		PreLoad (PNG_BACK, "PoP2_l8r9.png", &backl8r9);

		PreLoad (PNG_RUINSD, "crack1.png", &crack1[1]);
		PreLoad (PNG_RUINSD, "crack3.png", &crack3[1]);
		PreLoad (PNG_RUINSD, "crack4.png", &crack4[1]);
		PreLoad (PNG_RUINSD, "crack5.png", &crack5[1]);
		PreLoad (PNG_RUINSD, "crack6.png", &crack6[1]);
		PreLoad (PNG_RUINSD, "crack7.png", &crack7[1]);
		PreLoad (PNG_RUINSD, "crack8.png", &crack8[1]);
		PreLoad (PNG_RUINSD, "crack9.png", &crack9[1]);
		PreLoad (PNG_RUINSD, "crack10.png", &crack10[1]);
		PreLoad (PNG_RUINSD, "crack11.png", &crack11[1]);
		PreLoad (PNG_RUINSD, "crack12.png", &crack12[1]);
		PreLoad (PNG_RUINSD, "symbol16.png", &symbol16[1]);
		PreLoad (PNG_RUINSD, "symbol32.png", &symbol32[1]);
		PreLoad (PNG_RUINSD, "symbol48.png", &symbol48[1]);
		PreLoad (PNG_RUINSD, "sel_crack1.png", &crack1[2]);
		PreLoad (PNG_RUINSD, "sel_crack3.png", &crack3[2]);
		PreLoad (PNG_RUINSD, "sel_crack4.png", &crack4[2]);
		PreLoad (PNG_RUINSD, "sel_crack5.png", &crack5[2]);
		PreLoad (PNG_RUINSD, "sel_crack6.png", &crack6[2]);
		PreLoad (PNG_RUINSD, "sel_crack7.png", &crack7[2]);
		PreLoad (PNG_RUINSD, "sel_crack8.png", &crack8[2]);
		PreLoad (PNG_RUINSD, "sel_crack9.png", &crack9[2]);
		PreLoad (PNG_RUINSD, "sel_crack10.png", &crack10[2]);
		PreLoad (PNG_RUINSD, "sel_crack11.png", &crack11[2]);
		PreLoad (PNG_RUINSD, "sel_crack12.png", &crack12[2]);
		PreLoad (PNG_RUINSD, "sel_symbol16.png", &symbol16[2]);
		PreLoad (PNG_RUINSD, "sel_symbol32.png", &symbol32[2]);
		PreLoad (PNG_RUINSD, "sel_symbol48.png", &symbol48[2]);

		PreLoad (PNG_CAVERNSD, "bottom1.png", &bottom1[1]);
		PreLoad (PNG_CAVERNSD, "bottom2.png", &bottom2[1]);
		PreLoad (PNG_CAVERNSD, "bottom3.png", &bottom3[1]);
		PreLoad (PNG_CAVERNSD, "bottom4.png", &bottom4[1]);
		PreLoad (PNG_CAVERNSD, "bottom5.png", &bottom5[1]);
		PreLoad (PNG_CAVERNSD, "bottom6.png", &bottom6[1]);
		PreLoad (PNG_CAVERNSD, "bottom7.png", &bottom7[1]);
		PreLoad (PNG_CAVERNSD, "stalactite8.png", &stalactite8[1]);
		PreLoad (PNG_CAVERNSD, "stalactite16.png", &stalactite16[1]);
		PreLoad (PNG_CAVERNSD, "stalactite24.png", &stalactite24[1]);
		PreLoad (PNG_CAVERNSD, "stalactite32.png", &stalactite32[1]);
		PreLoad (PNG_CAVERNSD, "stalactite40.png", &stalactite40[1]);
		PreLoad (PNG_CAVERNSD, "stalactite48.png", &stalactite48[1]);
		PreLoad (PNG_CAVERNSD, "stalactite56.png", &stalactite56[1]);
		PreLoad (PNG_CAVERNSD, "sel_bottom1.png", &bottom1[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom2.png", &bottom2[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom3.png", &bottom3[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom4.png", &bottom4[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom5.png", &bottom5[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom6.png", &bottom6[2]);
		PreLoad (PNG_CAVERNSD, "sel_bottom7.png", &bottom7[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite8.png", &stalactite8[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite16.png", &stalactite16[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite24.png", &stalactite24[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite32.png", &stalactite32[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite40.png", &stalactite40[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite48.png", &stalactite48[2]);
		PreLoad (PNG_CAVERNSD, "sel_stalactite56.png", &stalactite56[2]);

		PreLoad (PNG_TEMPLEB, "0.png", &templeb[0]);
		PreLoad (PNG_TEMPLEB, "1.png", &templeb[1]);
		PreLoad (PNG_TEMPLEB, "2.png", &templeb[2]);
		PreLoad (PNG_TEMPLEB, "3.png", &templeb[3]);
		PreLoad (PNG_TEMPLEB, "4.png", &templeb[4]);
		PreLoad (PNG_TEMPLEB, "5.png", &templeb[5]);
		PreLoad (PNG_TEMPLEB, "6.png", &templeb[6]);
		PreLoad (PNG_TEMPLEB, "7.png", &templeb[7]);
		PreLoad (PNG_TEMPLEB, "8.png", &templeb[8]);
		PreLoad (PNG_TEMPLEB, "9.png", &templeb[9]);
		PreLoad (PNG_TEMPLEB, "10.png", &templeb[10]);
		PreLoad (PNG_TEMPLEB, "11.png", &templeb[11]);
		PreLoad (PNG_TEMPLEB, "12.png", &templeb[12]);
		PreLoad (PNG_TEMPLEB, "13.png", &templeb[13]);
		PreLoad (PNG_TEMPLEB, "14.png", &templeb[14]);
		PreLoad (PNG_TEMPLEB, "15.png", &templeb[15]);
		PreLoad (PNG_TEMPLEB, "16.png", &templeb[16]);
		PreLoad (PNG_TEMPLEB, "17.png", &templeb[17]);
		PreLoad (PNG_TEMPLEB, "18.png", &templeb[18]);
		PreLoad (PNG_TEMPLEB, "19.png", &templeb[19]);
		PreLoad (PNG_TEMPLEB, "20.png", &templeb[20]);
		PreLoad (PNG_TEMPLEB, "21.png", &templeb[21]);
		PreLoad (PNG_TEMPLEB, "22.png", &templeb[22]);
		PreLoad (PNG_TEMPLEB, "23.png", &templeb[23]);
		PreLoad (PNG_TEMPLEB, "24.png", &templeb[24]);
		PreLoad (PNG_TEMPLEB, "25.png", &templeb[25]);
		PreLoad (PNG_TEMPLEB, "26.png", &templeb[26]);
		PreLoad (PNG_TEMPLEB, "27.png", &templeb[27]);
		PreLoad (PNG_TEMPLEB, "28.png", &templeb[28]);
		PreLoad (PNG_TEMPLEB, "29.png", &templeb[29]);
		PreLoad (PNG_TEMPLEB, "30.png", &templeb[30]);
		PreLoad (PNG_TEMPLEB, "31.png", &templeb[31]);

		iTempleBHeight[0] = 1;
		iTempleBHeight[1] = 1;
		iTempleBHeight[2] = 1;
		iTempleBHeight[3] = 1;
		iTempleBHeight[4] = 1;
		iTempleBHeight[5] = 1;
		iTempleBHeight[6] = 1;
		iTempleBHeight[7] = 1;
		iTempleBHeight[8] = 1;
		iTempleBHeight[9] = 1;
		iTempleBHeight[10] = 1;
		iTempleBHeight[11] = 1;
		iTempleBHeight[12] = 1;
		iTempleBHeight[13] = 1;
		iTempleBHeight[14] = 1;
		iTempleBHeight[15] = 1;
		iTempleBHeight[16] = 1;
		iTempleBHeight[17] = 1;
		iTempleBHeight[18] = 1;
		iTempleBHeight[19] = 2;
		iTempleBHeight[20] = 2;
		iTempleBHeight[21] = 1;
		iTempleBHeight[22] = 1;
		iTempleBHeight[23] = 1;
		iTempleBHeight[24] = 1;
		iTempleBHeight[25] = 1;
		iTempleBHeight[26] = 1;
		iTempleBHeight[27] = 1;
		iTempleBHeight[28] = 1;
		iTempleBHeight[29] = 1;
		iTempleBHeight[30] = 1;
		iTempleBHeight[31] = 1;

		PreLoad (PNG_RUINSB, "0.png", &ruinsb[0]);
		PreLoad (PNG_RUINSB, "1.png", &ruinsb[1]);
		PreLoad (PNG_RUINSB, "2.png", &ruinsb[2]);
		PreLoad (PNG_RUINSB, "3.png", &ruinsb[3]);
		PreLoad (PNG_RUINSB, "4.png", &ruinsb[4]);
		PreLoad (PNG_RUINSB, "5.png", &ruinsb[5]);
		PreLoad (PNG_RUINSB, "6.png", &ruinsb[6]);
		PreLoad (PNG_RUINSB, "7.png", &ruinsb[7]);
		PreLoad (PNG_RUINSB, "8.png", &ruinsb[8]);
		PreLoad (PNG_RUINSB, "9.png", &ruinsb[9]);
		PreLoad (PNG_RUINSB, "10.png", &ruinsb[10]);
		PreLoad (PNG_RUINSB, "12.png", &ruinsb[12]);
		PreLoad (PNG_RUINSB, "13.png", &ruinsb[13]);
		PreLoad (PNG_RUINSB, "14.png", &ruinsb[14]);
		PreLoad (PNG_RUINSB, "15.png", &ruinsb[15]);
		PreLoad (PNG_RUINSB, "16.png", &ruinsb[16]);
		PreLoad (PNG_RUINSB, "17.png", &ruinsb[17]);
		PreLoad (PNG_RUINSB, "18.png", &ruinsb[18]);
		PreLoad (PNG_RUINSB, "19.png", &ruinsb[19]);
		PreLoad (PNG_RUINSB, "20.png", &ruinsb[20]);
		PreLoad (PNG_RUINSB, "22.png", &ruinsb[22]);
		PreLoad (PNG_RUINSB, "23.png", &ruinsb[23]);
		PreLoad (PNG_RUINSB, "24.png", &ruinsb[24]);
		PreLoad (PNG_RUINSB, "25.png", &ruinsb[25]);
		PreLoad (PNG_RUINSB, "26.png", &ruinsb[26]);
		PreLoad (PNG_RUINSB, "30.png", &ruinsb[30]);
		PreLoad (PNG_RUINSB, "31.png", &ruinsb[31]);

		iRuinsBHeight[0] = 1;
		iRuinsBHeight[1] = 2;
		iRuinsBHeight[2] = 2;
		iRuinsBHeight[3] = 2;
		iRuinsBHeight[4] = 2;
		iRuinsBHeight[5] = 2;
		iRuinsBHeight[6] = 3;
		iRuinsBHeight[7] = 2;
		iRuinsBHeight[8] = 2;
		iRuinsBHeight[9] = 1;
		iRuinsBHeight[10] = 1;
		iRuinsBHeight[12] = 1;
		iRuinsBHeight[13] = 1;
		iRuinsBHeight[14] = 1;
		iRuinsBHeight[15] = 1;
		iRuinsBHeight[16] = 1;
		iRuinsBHeight[17] = 1;
		iRuinsBHeight[18] = 1;
		iRuinsBHeight[19] = 1;
		iRuinsBHeight[20] = 1;
		iRuinsBHeight[22] = 1;
		iRuinsBHeight[23] = 1;
		iRuinsBHeight[24] = 1;
		iRuinsBHeight[25] = 1;
		iRuinsBHeight[26] = 1;
		iRuinsBHeight[30] = 1;
		iRuinsBHeight[31] = 1;

		PreLoad (PNG_VARIOUS, "level_10_horse.png", &imghorse);
		PreLoad (PNG_VARIOUS, "level_6_arrow.png", &imgarrow);
		PreLoad (PNG_VARIOUS, "invisible.png", &imginvisible);
	}

	if (iEditPoP == 3)
	{
		PreLoad (PNG_VARIOUS, "curtain_left.png", &imgcurtainl);
		PreLoad (PNG_VARIOUS, "curtain_right.png", &imgcurtainr);
		PreLoad (PNG_VARIOUS, "gates.png", &imggates);
	}

	PreLoad (PNG_VARIOUS, "exit_left.png", &imgexitl);
	PreLoad (PNG_VARIOUS, "exit_right.png", &imgexitr);
	PreLoad (PNG_VARIOUS, "exit_up.png", &imgexitu);
	PreLoad (PNG_VARIOUS, "exit_down.png", &imgexitd);
	PreLoad (PNG_VARIOUS, "checkp_left.png", &imgcheckpl);
	PreLoad (PNG_VARIOUS, "checkp_right.png", &imgcheckpr);
	PreLoad (PNG_VARIOUS, "checkp_up.png", &imgcheckpu);
	PreLoad (PNG_VARIOUS, "checkp_down.png", &imgcheckpd);

	if (iEditPoP == 3)
	{
		/*** blue backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x53; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_BLUEB, sBackTemp, &blueb[iBackTemp]);
		}

		/*** fawn backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x60; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_FAWNB, sBackTemp, &fawnb[iBackTemp]);
		}

		/*** silver backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x36; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_SILVERB, sBackTemp, &silverb[iBackTemp]);
		}

		/*** lava backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x36; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_LAVAB, sBackTemp, &lavab[iBackTemp]);
		}

		/*** green backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x62; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_GREENB, sBackTemp, &greenb[iBackTemp]);
		}

		/*** umber backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x53; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_UMBERB, sBackTemp, &umberb[iBackTemp]);
		}
		for (iBackTemp = 0x54; iBackTemp <= 0x59; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp + 0xa5);
			PreLoad (PNG_UMBERB, sBackTemp, &umberb[iBackTemp]);
		}

		/*** marble backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x75; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_MARBLEB, sBackTemp, &marbleb[iBackTemp]);
		}

		/*** hallway backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x21; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_HALLWAYB, sBackTemp, &hallwayb[iBackTemp]);
		}

		/*** jaffar backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x0f; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_JAFFARB, sBackTemp, &jaffarb[iBackTemp]);
		}

		/*** intro backgrounds ***/
		for (iBackTemp = 0; iBackTemp <= 0x65; iBackTemp++)
		{
			snprintf (sBackTemp, 7, "%02x.png", iBackTemp);
			PreLoad (PNG_INTROB, sBackTemp, &introb[iBackTemp]);
		}
	}

	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "close_0.png", &imgclose_0);
		PreLoad (PNG_BUTTONS, "close_1.png", &imgclose_1);
		PreLoad (PNG_BUTTONS, "close_big_0.png", &imgclosebig_0);
		PreLoad (PNG_BUTTONS, "close_big_1.png", &imgclosebig_1);
	} else {
		PreLoad (PNG_CONTROLLER, "close_0.png", &imgclose_0);
		PreLoad (PNG_CONTROLLER, "close_1.png", &imgclose_1);
		PreLoad (PNG_CONTROLLER, "close_big_0.png", &imgclosebig_0);
		PreLoad (PNG_CONTROLLER, "close_big_1.png", &imgclosebig_1);
	}
	if (iEditPoP == 2)
	{
		if (iController != 1)
		{
			PreLoad (PNG_BUTTONS, "guards_0.png", &imgguards_0);
			PreLoad (PNG_BUTTONS, "guards_1.png", &imgguards_1);
			PreLoad (PNG_BUTTONS, "music_0.png", &imgmusic_0);
			PreLoad (PNG_BUTTONS, "music_1.png", &imgmusic_1);
		} else {
			PreLoad (PNG_CONTROLLER, "guards_0.png", &imgguards_0);
			PreLoad (PNG_CONTROLLER, "guards_1.png", &imgguards_1);
			PreLoad (PNG_CONTROLLER, "music_0.png", &imgmusic_0);
			PreLoad (PNG_CONTROLLER, "music_1.png", &imgmusic_1);
		}
		PreLoad (PNG_BUTTONS, "edit_event_0.png", &imgee_0);
		PreLoad (PNG_BUTTONS, "edit_event_1.png", &imgee_1);
		PreLoad (PNG_BUTTONS, "end_chain_0.png", &imgec_0);
		PreLoad (PNG_BUTTONS, "end_chain_1.png", &imgec_1);
	}
	if (iEditPoP != 1)
	{
		if (iController != 1)
		{
			PreLoad (PNG_BUTTONS, "background_0.png", &imgback_0);
			PreLoad (PNG_BUTTONS, "background_1.png", &imgback_1);
		} else {
			PreLoad (PNG_CONTROLLER, "background_0.png", &imgback_0);
			PreLoad (PNG_CONTROLLER, "background_1.png", &imgback_1);
		}
	}
	if (iEditPoP == 3)
	{
		if (iController != 1)
		{
			PreLoad (PNG_BUTTONS, "template_0.png", &imgtemp_0);
			PreLoad (PNG_BUTTONS, "template_1.png", &imgtemp_1);
		} else {
			PreLoad (PNG_CONTROLLER, "template_0.png", &imgtemp_0);
			PreLoad (PNG_CONTROLLER, "template_1.png", &imgtemp_1);
		}
		PreLoad (PNG_BUTTONS, "kid_color_0.png", &imgcolor_0);
		PreLoad (PNG_BUTTONS, "kid_color_1.png", &imgcolor_1);
		PreLoad (PNG_VARIOUS, "border_room.png", &imgborderr);
	}
	if (iController != 1)
	{
		PreLoad (PNG_VARIOUS, "border_big.png", &imgborderb);
		PreLoad (PNG_VARIOUS, "border_small.png", &imgborders);
	} else {
		PreLoad (PNG_CONTROLLER, "border_big.png", &imgborderb);
		PreLoad (PNG_CONTROLLER, "border_small.png", &imgborders);
	}
	PreLoad (PNG_VARIOUS, "border_small_live.png", &imgbordersl);
	PreLoad (PNG_VARIOUS, "border_big_live.png", &imgborderbl);

	/*** custom ***/
	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "custom_active_0.png", &imgcustoma0);
		PreLoad (PNG_BUTTONS, "custom_inactive_0.png", &imgcustomi0);
		PreLoad (PNG_BUTTONS, "custom_active_1.png", &imgcustoma1);
		PreLoad (PNG_BUTTONS, "custom_inactive_1.png", &imgcustomi1);
		PreLoad (PNG_VARIOUS, "custom.png", &imgcustom);
		PreLoad (PNG_BUTTONS, "custom_0.png", &imgcustom_0);
		PreLoad (PNG_BUTTONS, "custom_1.png", &imgcustom_1);
	} else {
		PreLoad (PNG_CONTROLLER, "custom_active_0.png", &imgcustoma0);
		PreLoad (PNG_CONTROLLER, "custom_inactive_0.png", &imgcustomi0);
		PreLoad (PNG_CONTROLLER, "custom_active_1.png", &imgcustoma1);
		PreLoad (PNG_CONTROLLER, "custom_inactive_1.png", &imgcustomi1);
		PreLoad (PNG_CONTROLLER, "custom.png", &imgcustom);
		PreLoad (PNG_CONTROLLER, "custom_0.png", &imgcustom_0);
		PreLoad (PNG_CONTROLLER, "custom_1.png", &imgcustom_1);
	}

	/*** popup things ***/
	PreLoad (PNG_VARIOUS, "faded_l.png", &imgfadedl);
	if (iController != 1)
	{
		PreLoad (PNG_VARIOUS, "popup.png", &imgpopup);
		PreLoad (PNG_BUTTONS, "OK.png", &imgok[1]);
		PreLoad (PNG_BUTTONS, "sel_OK.png", &imgok[2]);
		PreLoad (PNG_BUTTONS, "Save.png", &imgsave[1]);
		PreLoad (PNG_BUTTONS, "sel_Save.png", &imgsave[2]);
	} else {
		PreLoad (PNG_CONTROLLER, "popup.png", &imgpopup);
		PreLoad (PNG_CONTROLLER, "OK.png", &imgok[1]);
		PreLoad (PNG_CONTROLLER, "sel_OK.png", &imgok[2]);
		PreLoad (PNG_CONTROLLER, "Save.png", &imgsave[1]);
		PreLoad (PNG_CONTROLLER, "sel_Save.png", &imgsave[2]);
	}
	PreLoad (PNG_VARIOUS, "popup_yn.png", &imgpopup_yn);
	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "Yes.png", &imgyes[1]);
		PreLoad (PNG_BUTTONS, "sel_Yes.png", &imgyes[2]);
		PreLoad (PNG_BUTTONS, "No.png", &imgno[1]);
		PreLoad (PNG_BUTTONS, "sel_No.png", &imgno[2]);
	} else {
		PreLoad (PNG_CONTROLLER, "Yes.png", &imgyes[1]);
		PreLoad (PNG_CONTROLLER, "sel_Yes.png", &imgyes[2]);
		PreLoad (PNG_CONTROLLER, "No.png", &imgno[1]);
		PreLoad (PNG_CONTROLLER, "sel_No.png", &imgno[2]);
	}
	PreLoad (PNG_VARIOUS, "help.png", &imghelp);
	if (iEditPoP == 1)
	{
		PreLoad (PNG_VARIOUS, "exe.png", &imgexe);
		PreLoad (PNG_VARIOUS, "exe_F3.png", &imgexef3);
		PreLoad (PNG_VARIOUS, "exe_F4.png", &imgexef4);
		PreLoad (PNG_VARIOUS, "exe_F5.png", &imgexef5);
		PreLoad (PNG_VARIOUS, "exe_packed.png", &imgexepacked);
		PreLoad (PNG_VARIOUS, "exe_guard_details.png", &imgexedetails);
		PreLoad (PNG_VARIOUS, "exe_packed2.png", &imgexepacked2);
		PreLoad (PNG_VARIOUS, "exe_packed3.png", &imgexepacked3);
		PreLoad (PNG_VARIOUS, "exe_action_R.png", &imgexeactionr);
		PreLoad (PNG_VARIOUS, "exe_action_F.png", &imgexeactionf);
		PreLoad (PNG_VARIOUS, "exe_action_B.png", &imgexeactionb);
		PreLoad (PNG_VARIOUS, "exe_action_U.png", &imgexeactionu);
		PreLoad (PNG_VARIOUS, "exe_action_D.png", &imgexeactiond);
		PreLoad (PNG_VARIOUS, "exe_action_J.png", &imgexeactionj);
		PreLoad (PNG_VARIOUS, "exe_action_S.png", &imgexeactions);
		PreLoad (PNG_VARIOUS, "exe_action_H.png", &imgexeactionh);
		PreLoad (PNG_VARIOUS, "exe_action_E.png", &imgexeactione);
	}
	if (iEditPoP == 2)
	{
		PreLoad (PNG_VARIOUS, "exe_pop2.png", &imgexe);
	}
	if (iEditPoP == 3)
	{
		PreLoad (PNG_VARIOUS, "exe_snes.png", &imgexe);
		PreLoad (PNG_VARIOUS, "exe_snes_music_yes.png", &imgexemusicyes);
		PreLoad (PNG_VARIOUS, "exe_snes_music_no.png", &imgexemusicno);
		PreLoad (PNG_VARIOUS, "exe_snes_haze_yes.png", &imgexehazeyes);
		PreLoad (PNG_VARIOUS, "exe_snes_haze_no.png", &imgexehazeno);
		PreLoad (PNG_VARIOUS, "exe_skel_dis.png", &imgexeskeldis);
		PreLoad (PNG_VARIOUS, "exe_F5_snes.png", &imgexef5);
		PreLoad (PNG_VARIOUS, "no_marker.png", &imgnomarker);
		PreLoad (PNG_VARIOUS, "red_prince.png", &imgredp);
		PreLoad (PNG_VARIOUS, "kid_colors.png", &imgkcolors);
		PreLoad (PNG_VARIOUS, "kid_colors_black.png", &imgkcolorsb);
		PreLoad (PNG_VARIOUS, "kid_colors_white.png", &imgkcolorsw);
		PreLoad (PNG_VARIOUS, "kid_r.png", &imgkcolorsr);
		PreLoad (PNG_VARIOUS, "kid_l.png", &imgkcolorsl);
		PreLoad (PNG_VARIOUS, "kid_f.png", &imgkcolorsf);
		PreLoad (PNG_VARIOUS, "guard_sprites_gray.png", &imggs[1]);
		PreLoad (PNG_VARIOUS, "guard_sprites_blue.png", &imggs[2]);
		/***/
		PreLoad (PNG_VARIOUS, "automatic_snes.png", &imgautomatic);
		PreLoad (PNG_VARIOUS, "sel_automatic_snes.png", &imgautomaticsel);
		for (iLoopFrame = 0; iLoopFrame <= 15; iLoopFrame++)
		{
			snprintf (sFileName, MAX_FILE, "f_%i.png", iLoopFrame);
			PreLoad (PNG_AUTOMATIC, sFileName, &imgautof[iLoopFrame]);
		}
		PreLoad (PNG_AUTOMATIC, "k_0.png", &imgautok[0]);
		PreLoad (PNG_AUTOMATIC, "k_1.png", &imgautok[1]);
		PreLoad (PNG_AUTOMATIC, "k_2.png", &imgautok[2]);
		PreLoad (PNG_AUTOMATIC, "k_4.png", &imgautok[4]);
		PreLoad (PNG_AUTOMATIC, "k_5.png", &imgautok[5]);
		PreLoad (PNG_AUTOMATIC, "k_6.png", &imgautok[6]);
		PreLoad (PNG_AUTOMATIC, "k_8.png", &imgautok[8]);
		PreLoad (PNG_AUTOMATIC, "k_9.png", &imgautok[9]);
		PreLoad (PNG_AUTOMATIC, "k_10.png", &imgautok[10]);
		PreLoad (PNG_AUTOMATIC, "k_32.png", &imgautok[32]);
		PreLoad (PNG_AUTOMATIC, "k_33.png", &imgautok[33]);
		PreLoad (PNG_AUTOMATIC, "k_34.png", &imgautok[34]);
		PreLoad (PNG_AUTOMATIC, "k_36.png", &imgautok[36]);
		PreLoad (PNG_AUTOMATIC, "k_37.png", &imgautok[37]);
		PreLoad (PNG_AUTOMATIC, "k_38.png", &imgautok[38]);
		PreLoad (PNG_AUTOMATIC, "k_40.png", &imgautok[40]);
		PreLoad (PNG_AUTOMATIC, "k_41.png", &imgautok[41]);
		PreLoad (PNG_AUTOMATIC, "k_42.png", &imgautok[42]);
		PreLoad (PNG_AUTOMATIC, "k_255.png", &imgautok[255]);
		PreLoad (PNG_AUTOMATIC, "k_unknown.png", &imgautokunk);
	}
	if (iEditPoP != 2)
	{
		PreLoad (PNG_VARIOUS, "exe_tab.png", &imgexetab);
		PreLoad (PNG_VARIOUS, "statusbar_sprite.png", &imgstatusbarsprite);
	}
	PreLoad (PNG_VARIOUS, "hexeditor.png", &imghexeditor);
	PreLoad (PNG_VARIOUS, "sel_hex_black.png", &imgshb);
	PreLoad (PNG_VARIOUS, "sel_hex_green.png", &imgshg);
	PreLoad (PNG_VARIOUS, "sel_hex_jump.png", &imgshj);
	PreLoad (PNG_VARIOUS, "sel_hex_find.png", &imgshf);
	if (iController != 1)
	{
		PreLoad (PNG_BUTTONS, "Close.png", &imgclosea[1]);
		PreLoad (PNG_BUTTONS, "sel_Close.png", &imgclosea[2]);
	} else {
		PreLoad (PNG_CONTROLLER, "Close.png", &imgclosea[1]);
		PreLoad (PNG_CONTROLLER, "sel_Close.png", &imgclosea[2]);
	}

	/*** faded tiles ***/
	switch (iEditPoP)
	{
		case 1: PreLoad (PNG_VARIOUS, "faded_s.png", &imgfadeds); break;
		case 2: PreLoad (PNG_VARIOUS, "faded_s_pop2.png", &imgfadeds); break;
		case 3: PreLoad (PNG_VARIOUS, "faded_s_snes.png", &imgfadeds); break;
	}

	/*** room thingies, 14x14 ***/
	PreLoad (PNG_ROOMS, "room1.png", &imgroom1);
	PreLoad (PNG_ROOMS, "room2.png", &imgroom2);
	PreLoad (PNG_ROOMS, "room3.png", &imgroom3);
	PreLoad (PNG_ROOMS, "room4.png", &imgroom4);
	PreLoad (PNG_ROOMS, "room5.png", &imgroom5);
	PreLoad (PNG_ROOMS, "room6.png", &imgroom6);
	PreLoad (PNG_ROOMS, "room7.png", &imgroom7);
	PreLoad (PNG_ROOMS, "room8.png", &imgroom8);
	PreLoad (PNG_ROOMS, "room9.png", &imgroom9);
	PreLoad (PNG_ROOMS, "room10.png", &imgroom10);
	PreLoad (PNG_ROOMS, "room11.png", &imgroom11);
	PreLoad (PNG_ROOMS, "room12.png", &imgroom12);
	PreLoad (PNG_ROOMS, "room13.png", &imgroom13);
	PreLoad (PNG_ROOMS, "room14.png", &imgroom14);
	PreLoad (PNG_ROOMS, "room15.png", &imgroom15);
	PreLoad (PNG_ROOMS, "room16.png", &imgroom16);
	PreLoad (PNG_ROOMS, "room17.png", &imgroom17);
	PreLoad (PNG_ROOMS, "room18.png", &imgroom18);
	PreLoad (PNG_ROOMS, "room19.png", &imgroom19);
	PreLoad (PNG_ROOMS, "room20.png", &imgroom20);
	PreLoad (PNG_ROOMS, "room21.png", &imgroom21);
	PreLoad (PNG_ROOMS, "room22.png", &imgroom22);
	PreLoad (PNG_ROOMS, "room23.png", &imgroom23);
	PreLoad (PNG_ROOMS, "room24.png", &imgroom24);
	if (iEditPoP == 2)
	{
		PreLoad (PNG_ROOMS, "room25.png", &imgroom25);
		PreLoad (PNG_ROOMS, "room26.png", &imgroom26);
		PreLoad (PNG_ROOMS, "room27.png", &imgroom27);
		PreLoad (PNG_ROOMS, "room28.png", &imgroom28);
		PreLoad (PNG_ROOMS, "room29.png", &imgroom29);
		PreLoad (PNG_ROOMS, "room30.png", &imgroom30);
		PreLoad (PNG_ROOMS, "room31.png", &imgroom31);
		PreLoad (PNG_ROOMS, "room32.png", &imgroom32);
	}

	/*** native ***/
	if (iEditPoP == 1)
	{
		PreLoad (PNG_NATIVE, "off.png", &imgnativeoff);
		PreLoad (PNG_NATIVE, "on_0.png", &imgnativeon_0);
		PreLoad (PNG_NATIVE, "on_1.png", &imgnativeon_1);
		PreLoad (PNG_NATIVE, "found.png", &imgnative_f);
		for (iButton = 1; iButton <= 12; iButton++)
		{
			snprintf (sFileName, MAX_FILE, "tab_0_%i.png", iButton);
			PreLoad (PNG_NATIVE, sFileName, &imgnativetab_0[iButton]);
			snprintf (sFileName, MAX_FILE, "tab_1_%i.png", iButton);
			PreLoad (PNG_NATIVE, sFileName, &imgnativetab_1[iButton]);
			snprintf (sFileName, MAX_FILE, "tab_0a_%i.png", iButton);
			PreLoad (PNG_NATIVE, sFileName, &imgnativetab_0a[iButton]);
		}
		PreLoad (PNG_NATIVE, "main.png", &imgnative);
		PreLoad (PNG_NATIVE, "border_big.png", &imgnative_bb);
		PreLoad (PNG_NATIVE, "border_big_live.png", &imgnative_bbl);
		for (iButton = 1; iButton <= 12; iButton++)
		{
			snprintf (sFileName, MAX_FILE, "dungeon_%i.png", iButton);
			PreLoad (PNG_NATIVE, sFileName, &imgnative_d[iButton]);
			snprintf (sFileName, MAX_FILE, "palace_%i.png", iButton);
			PreLoad (PNG_NATIVE, sFileName, &imgnative_p[iButton]);
		}
		PreLoad (PNG_NATIVE, "SDLPoP.png", &imgnative_s);
		PreLoad (PNG_NATIVE, "MININIM.png", &imgnative_m);
		PreLoad (PNG_NATIVE, "both.png", &imgnative_b);
		for (iSixBitLoop = 0; iSixBitLoop <= 0x3f; iSixBitLoop++)
		{
			snprintf (sSixBit, 7, "%02x.png", iSixBitLoop);
			PreLoad (PNG_SIXBITRGB, sSixBit, &six_bit_rgb[iSixBitLoop]);
		}
	}

	/*** playtest ***/
	if (iEditPoP == 1)
	{
		PreLoad (PNG_PLAYTEST, "playtest.png", &imgpt);
		PreLoad (PNG_PLAYTEST, "DOSBox_disabled.png", &imgptdosboxdis);
		PreLoad (PNG_PLAYTEST, "DOSBox_off.png", &imgptdosboxoff);
		PreLoad (PNG_PLAYTEST, "DOSBox_on.png", &imgptdosboxon);
		PreLoad (PNG_PLAYTEST, "SDLPoP_disabled.png", &imgptsdlpopdis);
		PreLoad (PNG_PLAYTEST, "SDLPoP_off.png", &imgptsdlpopoff);
		PreLoad (PNG_PLAYTEST, "SDLPoP_on.png", &imgptsdlpopon);
		PreLoad (PNG_PLAYTEST, "MININIM_disabled.png", &imgptmininimdis);
		PreLoad (PNG_PLAYTEST, "MININIM_off.png", &imgptmininimoff);
		PreLoad (PNG_PLAYTEST, "MININIM_on.png", &imgptmininimon);
		PreLoad (PNG_PLAYTEST, "native_off.png", &imgptnativeoff);
		PreLoad (PNG_PLAYTEST, "native_on.png", &imgptnativeon);
		if (iController != 1)
		{
			PreLoad (PNG_PLAYTEST, "DOSBox_key.png", &imgptdosboxkey);
			PreLoad (PNG_PLAYTEST, "SDLPoP_key.png", &imgptsdlpopkey);
			PreLoad (PNG_PLAYTEST, "MININIM_key.png", &imgptmininimkey);
			PreLoad (PNG_BUTTONS, "Downloads.png", &imgdownloads[1]);
			PreLoad (PNG_BUTTONS, "sel_Downloads.png", &imgdownloads[2]);
			PreLoad (PNG_BUTTONS, "Downloadm.png", &imgdownloadm[1]);
			PreLoad (PNG_BUTTONS, "sel_Downloadm.png", &imgdownloadm[2]);
		} else {
			PreLoad (PNG_CONTROLLER, "DOSBox_key.png", &imgptdosboxkey);
			PreLoad (PNG_CONTROLLER, "SDLPoP_key.png", &imgptsdlpopkey);
			PreLoad (PNG_CONTROLLER, "MININIM_key.png", &imgptmininimkey);
			PreLoad (PNG_CONTROLLER, "Downloads.png", &imgdownloads[1]);
			PreLoad (PNG_CONTROLLER, "sel_Downloads.png", &imgdownloads[2]);
			PreLoad (PNG_CONTROLLER, "Downloadm.png", &imgdownloadm[1]);
			PreLoad (PNG_CONTROLLER, "sel_Downloadm.png", &imgdownloadm[2]);
		}
	}

	/*** Map window ***/
	if ((iEditPoP == 1) || (iEditPoP == 3))
	{
		PreLoadMap (PNG_VARIOUS, "map.png", &imgmap);
		PreLoadMap (PNG_VARIOUS, "map_grid.png", &imgmapgrid);
		PreLoadMap (PNG_VARIOUS, "map_sel_tile.png", &imgmapseltile);
		if (iEditPoP == 1)
		{
			PreLoadMap (PNG_VARIOUS, "map_panel_1.png", &imgmappanel);
			/***/
			PreLoadMap (PNG_MINI1, "0.png", &imgmini1[0][0]);
			PreLoadMap (PNG_MINI1, "0_3.png", &imgmini1[0][3]);
			PreLoadMap (PNG_MINI1, "1.png", &imgmini1[1][0]);
			PreLoadMap (PNG_MINI1, "2.png", &imgmini1[2][0]);
			PreLoadMap (PNG_MINI1, "3.png", &imgmini1[3][0]);
			PreLoadMap (PNG_MINI1, "4_0.png", &imgmini1[4][0]);
			PreLoadMap (PNG_MINI1, "4_1.png", &imgmini1[4][1]);
			PreLoadMap (PNG_MINI1, "5.png", &imgmini1[5][0]);
			PreLoadMap (PNG_MINI1, "6.png", &imgmini1[6][0]);
			PreLoadMap (PNG_MINI1, "7.png", &imgmini1[7][0]);
			PreLoadMap (PNG_MINI1, "8.png", &imgmini1[8][0]);
			PreLoadMap (PNG_MINI1, "9.png", &imgmini1[9][0]);
			PreLoadMap (PNG_MINI1, "10_0.png", &imgmini1[10][0]);
			PreLoadMap (PNG_MINI1, "10_1.png", &imgmini1[10][1]);
			PreLoadMap (PNG_MINI1, "10_2.png", &imgmini1[10][2]);
			PreLoadMap (PNG_MINI1, "10_3.png", &imgmini1[10][3]);
			PreLoadMap (PNG_MINI1, "10_4.png", &imgmini1[10][4]);
			PreLoadMap (PNG_MINI1, "10_5.png", &imgmini1[10][5]);
			PreLoadMap (PNG_MINI1, "10_6.png", &imgmini1[10][6]);
			PreLoadMap (PNG_MINI1, "11.png", &imgmini1[11][0]);
			PreLoadMap (PNG_MINI1, "12.png", &imgmini1[12][0]);
			PreLoadMap (PNG_MINI1, "13.png", &imgmini1[13][0]);
			PreLoadMap (PNG_MINI1, "14.png", &imgmini1[14][0]);
			PreLoadMap (PNG_MINI1, "15.png", &imgmini1[15][0]);
			PreLoadMap (PNG_MINI1, "16.png", &imgmini1[16][0]);
			PreLoadMap (PNG_MINI1, "17.png", &imgmini1[17][0]);
			PreLoadMap (PNG_MINI1, "18.png", &imgmini1[18][0]);
			PreLoadMap (PNG_MINI1, "18_2.png", &imgmini1[18][2]);
			PreLoadMap (PNG_MINI1, "19.png", &imgmini1[19][0]);
			PreLoadMap (PNG_MINI1, "20.png", &imgmini1[20][0]);
			PreLoadMap (PNG_MINI1, "21.png", &imgmini1[21][0]);
			PreLoadMap (PNG_MINI1, "22.png", &imgmini1[22][0]);
			PreLoadMap (PNG_MINI1, "23.png", &imgmini1[23][0]);
			PreLoadMap (PNG_MINI1, "24.png", &imgmini1[24][0]);
			PreLoadMap (PNG_MINI1, "25.png", &imgmini1[25][0]);
			PreLoadMap (PNG_MINI1, "26.png", &imgmini1[26][0]);
			PreLoadMap (PNG_MINI1, "27.png", &imgmini1[27][0]);
			PreLoadMap (PNG_MINI1, "28.png", &imgmini1[28][0]);
			PreLoadMap (PNG_MINI1, "29.png", &imgmini1[29][0]);
			PreLoadMap (PNG_MINI1, "30.png", &imgmini1[30][0]);
			PreLoadMap (PNG_MINI1, "guard.png", &imgminiguard);
			PreLoadMap (PNG_MINI1, "prince.png", &imgminiprince);
			PreLoadMap (PNG_MINI1, "hover.png", &imgminihover);
			PreLoadMap (PNG_MINI1, "related.png", &imgminirelated);
		}
		if (iEditPoP == 3)
		{
			PreLoadMap (PNG_VARIOUS, "map_panel_3.png", &imgmappanel);
			/***/
			PreLoadMap (PNG_MINI3, "0.png", &imgmini3[0][0]); /*** custom ***/
			PreLoadMap (PNG_MINI3, "1.png", &imgmini3[1][0]); /*** space ***/
			PreLoadMap (PNG_MINI3, "2.png", &imgmini3[2][0]); /*** floor ***/
			PreLoadMap (PNG_MINI3, "2_3.png", &imgmini3[2][3]); /*** floor ? ***/
			PreLoadMap (PNG_MINI3, "2_4.png", &imgmini3[2][4]); /*** floor ? ***/
			PreLoadMap (PNG_MINI3, "2_7.png", &imgmini3[2][7]); /*** floor ? ***/
			PreLoadMap (PNG_MINI3, "2_255.png", &imgmini3[2][255]); /*** floor ? ***/
			PreLoadMap (PNG_MINI3, "3.png", &imgmini3[3][0]); /*** wall ***/
			PreLoadMap (PNG_MINI3, "3_255.png", &imgmini3[3][255]); /*** wall ? ***/
			PreLoadMap (PNG_MINI3, "4.png", &imgmini3[4][0]); /*** pillar ***/
			PreLoadMap (PNG_MINI3, "5.png", &imgmini3[5][0]); /*** loose ***/
			PreLoadMap (PNG_MINI3, "5_1.png", &imgmini3[5][1]); /*** loose hl ***/
			PreLoadMap (PNG_MINI3, "6.png", &imgmini3[6][0]); /*** debris ***/
			PreLoadMap (PNG_MINI3, "7.png", &imgmini3[7][0]); /*** fake fl; s ***/
			PreLoadMap (PNG_MINI3, "8.png", &imgmini3[8][0]); /*** fake fl; sdo ***/
			PreLoadMap (PNG_MINI3, "9.png", &imgmini3[9][0]); /*** fake wl; s ***/
			PreLoadMap (PNG_MINI3, "10.png", &imgmini3[10][0]); /*** fake s; fl ***/
			PreLoadMap (PNG_MINI3, "11.png", &imgmini3[11][0]); /*** fake wl; fl ***/
			PreLoadMap (PNG_MINI3, "12.png", &imgmini3[12][0]); /*** fake s; wl ***/
			PreLoadMap (PNG_MINI3, "13.png", &imgmini3[13][0]); /*** fake fl; wl ***/
			PreLoadMap (PNG_MINI3, "14.png", &imgmini3[14][0]); /*** raise ***/
			PreLoadMap (PNG_MINI3, "15.png", &imgmini3[15][0]); /*** drop ***/
			PreLoadMap (PNG_MINI3, "16.png", &imgmini3[16][0]); /*** gate; cl. ***/
			PreLoadMap (PNG_MINI3, "17.png", &imgmini3[17][0]); /*** gate; % ***/
			PreLoadMap (PNG_MINI3, "18.png", &imgmini3[18][0]); /*** gate; open ***/
			PreLoadMap (PNG_MINI3, "19.png", &imgmini3[19][0]); /*** gate top ***/
			PreLoadMap (PNG_MINI3, "20.png", &imgmini3[20][0]); /*** lv dr b (1) ***/
			/*** NO 21.png ***/
			PreLoadMap (PNG_MINI3, "22.png", &imgmini3[22][0]); /*** lv dr e (1) ***/
			/*** NO 23.png ***/
			PreLoadMap (PNG_MINI3, "24.png", &imgmini3[24][0]); /*** tele (1) ***/
			/*** NO 25.png ***/
			PreLoadMap (PNG_MINI3, "26.png", &imgmini3[26][0]); /*** sword ***/
			PreLoadMap (PNG_MINI3, "27.png", &imgmini3[27][0]); /*** chomper ***/
			PreLoadMap (PNG_MINI3, "27_2.png", &imgmini3[27][2]); /*** chomp hf ***/
			PreLoadMap (PNG_MINI3, "27_5.png", &imgmini3[27][5]); /*** chomp hl ***/
			PreLoadMap (PNG_MINI3, "28.png", &imgmini3[28][0]); /*** spike ***/
			PreLoadMap (PNG_MINI3, "28_4.png", &imgmini3[28][4]); /*** spike hf ***/
			PreLoadMap (PNG_MINI3, "28_9.png", &imgmini3[28][9]); /*** spike hl ***/
			PreLoadMap (PNG_MINI3, "29.png", &imgmini3[29][0]); /*** guillotine ***/
			PreLoadMap (PNG_MINI3, "29_1.png", &imgmini3[29][1]); /*** guil hl ***/
			PreLoadMap (PNG_MINI3, "29_2.png", &imgmini3[29][2]); /*** guil hf ***/
			PreLoadMap (PNG_MINI3, "30.png", &imgmini3[30][0]); /*** crusher ***/
			PreLoadMap (PNG_MINI3, "30_1.png", &imgmini3[30][1]); /*** crush hl ***/
			PreLoadMap (PNG_MINI3, "30_3.png", &imgmini3[30][3]); /*** crush hf ***/
			PreLoadMap (PNG_MINI3, "31.png", &imgmini3[31][0]); /*** lava ***/
			PreLoadMap (PNG_MINI3, "32.png", &imgmini3[32][0]); /*** fire ***/
			PreLoadMap (PNG_MINI3, "33.png", &imgmini3[33][0]); /*** spin. log ***/
			PreLoadMap (PNG_MINI3, "33_1.png", &imgmini3[33][1]); /*** spin hl ***/
			PreLoadMap (PNG_MINI3, "33_3.png", &imgmini3[33][3]); /*** spin hf ***/
			PreLoadMap (PNG_MINI3, "34.png", &imgmini3[34][0]); /*** stars ***/
			PreLoadMap (PNG_MINI3, "35.png", &imgmini3[35][0]); /*** mirror ***/
			PreLoadMap (PNG_MINI3, "36.png", &imgmini3[36][0]); /*** <<< ***/
			PreLoadMap (PNG_MINI3, "37.png", &imgmini3[37][0]); /*** >>> ***/
			PreLoadMap (PNG_MINI3, "38.png", &imgmini3[38][0]); /*** skeleton ***/
			PreLoadMap (PNG_MINI3, "39.png", &imgmini3[39][0]); /*** skeleton c ***/
			PreLoadMap (PNG_MINI3, "40.png", &imgmini3[40][0]); /*** heal potion ***/
			PreLoadMap (PNG_MINI3, "41.png", &imgmini3[41][0]); /*** life potion ***/
			PreLoadMap (PNG_MINI3, "42.png", &imgmini3[42][0]); /*** hurt potion ***/
			PreLoadMap (PNG_MINI3, "43.png", &imgmini3[43][0]); /*** flip potion ***/
			PreLoadMap (PNG_MINI3, "44.png", &imgmini3[44][0]); /*** flt potion ***/
			PreLoadMap (PNG_MINI3, "45.png", &imgmini3[45][0]); /*** warp potion ***/
			PreLoadMap (PNG_MINI3, "46.png", &imgmini3[46][0]); /*** kill potion ***/
			PreLoadMap (PNG_MINI3, "47.png", &imgmini3[47][0]); /*** torch (fl) ***/
			PreLoadMap (PNG_MINI3, "48.png", &imgmini3[48][0]); /*** torch (s) ***/
			PreLoadMap (PNG_MINI3, "guard.png", &imgminiguard);
			PreLoadMap (PNG_MINI3, "prince.png", &imgminiprince);
			PreLoadMap (PNG_MINI3, "hover.png", &imgminihover);
			PreLoadMap (PNG_MINI3, "related.png", &imgminirelated);
		}
		PreLoadMap (PNG_BUTTONS, "zoom-1_on_0.png", &imgzoom1on_0);
		PreLoadMap (PNG_BUTTONS, "zoom-1_on_1.png", &imgzoom1on_1);
		PreLoadMap (PNG_BUTTONS, "zoom-1_off.png", &imgzoom1off);
		PreLoadMap (PNG_BUTTONS, "zoom-fit_on_0.png", &imgzoomfiton_0);
		PreLoadMap (PNG_BUTTONS, "zoom-fit_on_1.png", &imgzoomfiton_1);
		PreLoadMap (PNG_BUTTONS, "zoom-fit_off.png", &imgzoomfitoff);
		PreLoadMap (PNG_BUTTONS, "zoom-in_on_0.png", &imgzoominon_0);
		PreLoadMap (PNG_BUTTONS, "zoom-in_on_1.png", &imgzoominon_1);
		PreLoadMap (PNG_BUTTONS, "zoom-in_off.png", &imgzoominoff);
		PreLoadMap (PNG_BUTTONS, "zoom-out_on_0.png", &imgzoomouton_0);
		PreLoadMap (PNG_BUTTONS, "zoom-out_on_1.png", &imgzoomouton_1);
		PreLoadMap (PNG_BUTTONS, "zoom-out_off.png", &imgzoomoutoff);
		PreLoadMap (PNG_BUTTONS, "arrow_down_off.png", &imgarrowdoff);
		PreLoadMap (PNG_BUTTONS, "arrow_down_on_0.png", &imgarrowdon_0);
		PreLoadMap (PNG_BUTTONS, "arrow_down_on_1.png", &imgarrowdon_1);
		PreLoadMap (PNG_BUTTONS, "arrow_left_off.png", &imgarrowloff);
		PreLoadMap (PNG_BUTTONS, "arrow_left_on_0.png", &imgarrowlon_0);
		PreLoadMap (PNG_BUTTONS, "arrow_left_on_1.png", &imgarrowlon_1);
		PreLoadMap (PNG_BUTTONS, "arrow_right_off.png", &imgarrowroff);
		PreLoadMap (PNG_BUTTONS, "arrow_right_on_0.png", &imgarrowron_0);
		PreLoadMap (PNG_BUTTONS, "arrow_right_on_1.png", &imgarrowron_1);
		PreLoadMap (PNG_BUTTONS, "arrow_up_off.png", &imgarrowuoff);
		PreLoadMap (PNG_BUTTONS, "arrow_up_on_0.png", &imgarrowuon_0);
		PreLoadMap (PNG_BUTTONS, "arrow_up_on_1.png", &imgarrowuon_1);
		PreLoadMap (PNG_VARIOUS, "border_mroom_active.png", &imgbmrooma);
		PreLoadMap (PNG_VARIOUS, "border_mroom_hover.png", &imgbmroomh);
		PreLoadMap (PNG_VARIOUS, "chk_black.png", &imgchkbmap);
		if (iController != 1)
		{
			PreLoad (PNG_BUTTONS, "map_on_0.png", &imgmapon_0);
			PreLoad (PNG_BUTTONS, "map_on_1.png", &imgmapon_1);
			PreLoad (PNG_BUTTONS, "map_off.png", &imgmapoff);
			PreLoadMap (PNG_BUTTONS, "Close.png", &imgclosem[1]);
			PreLoadMap (PNG_BUTTONS, "sel_Close.png", &imgclosem[2]);
		} else {
			PreLoad (PNG_CONTROLLER, "map_on_0.png", &imgmapon_0);
			PreLoad (PNG_CONTROLLER, "map_on_1.png", &imgmapon_1);
			PreLoad (PNG_CONTROLLER, "map_off.png", &imgmapoff);
			PreLoadMap (PNG_CONTROLLER, "Close.png", &imgclosem[1]);
			PreLoadMap (PNG_CONTROLLER, "sel_Close.png", &imgclosem[2]);
		}
	} else {
		PreLoad (PNG_VARIOUS, "grid_fragment.png", &imggrid);
	}

	/*** text ***/
	PreLoad (PNG_VARIOUS, "text.png", &imgtext);
	PreLoad (PNG_VARIOUS, "text_none.png", &imgtextnone);
	PreLoad (PNG_VARIOUS, "text_hover.png", &imgtexthover);

	/*** jump to room ***/
	PreLoad (PNG_VARIOUS, "jump_to.png", &imgjump);
	if (iEditPoP != 2)
	{
		PreLoad (PNG_VARIOUS, "jump_disable_25-32.png", &imgjumpdis25);
	}
	switch (iEditPoP)
	{
		case 1:
			PreLoad (PNG_VARIOUS, "jump_disable_16-32.png", &imgjumpdis16);
			break;
		case 2:
			PreLoad (PNG_VARIOUS, "jump_disable_29-32.png", &imgjumpdis29);
			break;
		case 3:
			PreLoad (PNG_VARIOUS, "jump_disable_28-32.png", &imgjumpdis28);
			break;
	}
	PreLoad (PNG_VARIOUS, "sel_jump.png", &imgseljump);

	/*** kid button and screen ***/
	if (iEditPoP == 1)
	{
		PreLoad (PNG_VARIOUS, "kid.png", &imgkid);
		PreLoad (PNG_VARIOUS, "kid_pos.png", &imgkidp);
		PreLoad (PNG_VARIOUS, "faded_kid.png", &imgkidf);
		PreLoad (PNG_VARIOUS, "faded_kid_P1.png", &imgkidfp1);
		PreLoad (PNG_VARIOUS, "border_kid.png", &imgkidb);
		PreLoad (PNG_VARIOUS, "border_kid_live.png", &imgkidbl);
		PreLoad (PNG_VARIOUS, "border_kid_button.png", &imgkidbb);
		PreLoad (PNG_BUTTONS, "kid_0.png", &imgkid0);
		PreLoad (PNG_BUTTONS, "kid_1.png", &imgkid1);
	}

	if (iDebug == 1)
		{ printf ("[ INFO ] Preloaded images: %i\n", iPreLoaded); }

	iDownAt = 0;
	iDownAtMap = 0;

	/*** Start with a centered map. ***/
	iXPosMapMoveOffset = 0;
	iYPosMapMoveOffset = 0;
	iMovingMap = 0;
	iDrawingOnMap = 0;

	iSelected = 1; /*** Start with the upper left selected. ***/
	iScreen = 1;

	switch (iEditPoP)
	{
		case 1: PoP1Basics(); break;
		case 2: PoP2Basics(); break;
		case 3: PoP1SNESBasics(); break;
	}
	if (iDebug == 1)
		printf ("[ INFO ] Starting in level: %i\n", iStartLevel);

	LoadLevel (iStartLevel);
	iChangeEvent = 0;
	iChangeStuck = 0;
	iChangeMarker = 0x0d;
	iChangeJumps = 3;
	iChangeFrame = 0;
	iChangePercent = 50;
	iChangeWall = 1;
	iFlameFrameDP = 1;
	iChomperFrameDP = 1;
	iChomped = 0;
	iSwordFrameDP = 1;
	iFlameFrameC = 1;
	iFlameFrameT = 1;
	oldticks = 0;
	iGuardTooltip = 0;
	iEXEDetails = 0;
	if (iEditPoP == 3) { iEXETab = 7; } else { iEXETab = 1; }
	iNativeTab = 1;
	SDL_SetCursor (curArrow);

	ShowScreen (iScreen, ascreen);
	InitPopUp();
	while (1)
	{
		if (iNoAnim == 0)
		{
			/*** This is for the animation; 12 fps (1000/83) is fine for PoP. ***/
			newticks = SDL_GetTicks();
			if (newticks > oldticks + 83)
			{
				iFlameFrameDP++;
				if (iFlameFrameDP == 10) { iFlameFrameDP = 1; }
				iChomperFrameDP++;
				if (iChomperFrameDP == 14) { iChomperFrameDP = 1; }
				iSwordFrameDP++;
				if (iSwordFrameDP == 49) { iSwordFrameDP = 1; }
				iFlameFrameC++;
				if (iFlameFrameC == 9) { iFlameFrameC = 1; }
				iFlameFrameT++;
				if (iFlameFrameT == 5) { iFlameFrameT = 1; }
				ShowScreen (iScreen, ascreen);
				oldticks = newticks;
			}
		}

		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							InitScreenAction ("enter");
							break;
						case SDL_CONTROLLER_BUTTON_B:
							switch (iScreen)
							{
								case 1:
									Quit(); break;
								case 2:
									iBrokenRoomLinks = BrokenRoomLinks (0);
									iScreen = 1; break;
								case 3:
									iScreen = 1; break;
							}
							break;
						case SDL_CONTROLLER_BUTTON_X:
							if (iScreen != 2)
							{
								iScreen = 2;
								iMovingRoom = 0;
								iMovingNewBusy = 0;
								iChangingBrokenRoom = iCurRoom;
								iChangingBrokenSide = 1;
								PlaySound ("wav/screen2or3.wav");
							} else if (iBrokenRoomLinks == 0) {
								iBrokenRoomLinks = 1;
								PlaySound ("wav/screen2or3.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_Y:
							if (iScreen == 2)
							{
								iBrokenRoomLinks = BrokenRoomLinks (0);
							}
							if (iScreen != 3)
							{
								iScreen = 3;
								PlaySound ("wav/screen2or3.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_BACK:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								if ((iUsesNative != 0) ||
									(iFoundSDLPoP != 0) || (iFoundMININIM != 0))
								{
									Native (iSelected, ascreen, 0);
								} else {
									printf ("[ WARN ] No native PoP1 found!\n");
								}
							}
							if (iScreen == 2)
							{
								if (iBrokenRoomLinks == 1)
								{
									LinkMinus();
								} else {
									if ((iEditPoP == 1) || (iEditPoP == 3)) { MapShow(); }
								}
							}
							if ((iScreen == 3) && (iEditPoP != 2))
							{
								if (EventInfo (iChangeEvent, 3) == 0) /*** if "n" ***/
									{ EventNext (0); } /*** "y" ***/
										else { EventNext (1); } /*** "n" ***/
							}
							break;
						case SDL_CONTROLLER_BUTTON_GUIDE:
							if (iChanged != 0) { CallSave (0); } break;
						case SDL_CONTROLLER_BUTTON_START:
							if (iEditPoP == 1)
							{
								AutoUse ((int)luLevelNr);
							} else {
								RunLevel ((int)luLevelNr);
							}
							break;
						case SDL_CONTROLLER_BUTTON_LEFTSHOULDER:
							if ((int)luLevelNr != 1)
							{
								if ((iChanged != 0) && (iNoSave == 0))
									{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
								if (iYesNo != 0)
								{
									if (iYesNo == 2) { CallSave (0); }
									Prev ((int)luLevelNr);
								}
							}
							break;
						case SDL_CONTROLLER_BUTTON_RIGHTSHOULDER:
							if (((int)luLevelNr != 0) && ((int)luLevelNr != 28))
							{
								if ((iChanged != 0) && (iNoSave == 0))
									{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
								if (iYesNo != 0)
								{
									if (iYesNo == 2) { CallSave (0); }
									Next ((int)luLevelNr);
								}
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							InitScreenAction ("left"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							InitScreenAction ("right"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							InitScreenAction ("up"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							InitScreenAction ("down"); break;
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_CONTROLLERAXISMOTION: /*** triggers and analog sticks ***/
					iXJoy1 = SDL_JoystickGetAxis (joystick, 0);
					iYJoy1 = SDL_JoystickGetAxis (joystick, 1);
					iXJoy2 = SDL_JoystickGetAxis (joystick, 3);
					iYJoy2 = SDL_JoystickGetAxis (joystick, 4);
					if ((iXJoy1 < -30000) || (iXJoy2 < -30000)) /*** left ***/
					{
						if ((SDL_GetTicks() - joyleft) > 300)
						{
							switch (iScreen)
							{
								case 1:
									if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][1];
										PlaySound ("wav/scroll.wav");
									}
									break;
								case 3:
									ChangeEvent (-1, 0);
									break;
							}
							joyleft = SDL_GetTicks();
						}
					}
					if ((iXJoy1 > 30000) || (iXJoy2 > 30000)) /*** right ***/
					{
						if ((SDL_GetTicks() - joyright) > 300)
						{
							switch (iScreen)
							{
								case 1:
									if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][2] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][2];
										PlaySound ("wav/scroll.wav");
									}
									break;
								case 3:
									ChangeEvent (1, 0);
									break;
							}
							joyright = SDL_GetTicks();
						}
					}
					if ((iYJoy1 < -30000) || (iYJoy2 < -30000)) /*** up ***/
					{
						if ((SDL_GetTicks() - joyup) > 300)
						{
							switch (iScreen)
							{
								case 1:
									if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][3] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][3];
										PlaySound ("wav/scroll.wav");
									}
									break;
								case 3:
									ChangeEvent (10, 0);
									break;
							}
							joyup = SDL_GetTicks();
						}
					}
					if ((iYJoy1 > 30000) || (iYJoy2 > 30000)) /*** down ***/
					{
						if ((SDL_GetTicks() - joydown) > 300)
						{
							switch (iScreen)
							{
								case 1:
									if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][4] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][4];
										PlaySound ("wav/scroll.wav");
									}
									break;
								case 3:
									ChangeEvent (-10, 0);
									break;
							}
							joydown = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERLEFT)
					{
						if ((SDL_GetTicks() - trigleft) > 300)
						{
							InitScreenAction ("left bracket");
							trigleft = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERRIGHT)
					{
						if ((SDL_GetTicks() - trigright) > 300)
						{
							InitScreenAction ("right bracket");
							trigright = SDL_GetTicks();
						}
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_KEYDOWN: /*** https://wiki.libsdl.org/SDL_Keycode ***/
					switch (event.key.keysym.sym)
					{
						case SDLK_F1:
							if (iScreen == 1)
							{
								Help();
							}
							break;
						case SDLK_F2:
							if (iScreen == 1)
							{
								if (iEditPoP != 2)
								{
									snprintf (sEXELoc, MAX_FILE, "%s", POP1_EXECUTABLE);
								} else {
									snprintf (sEXELoc, MAX_FILE, "%s", POP2_EXECUTABLE);
								}
								if (strcmp (sEXEType, "missing") == 0)
								{
									printf ("[ INFO ] %s does not exist.\n", sEXELoc);
								} else if (strcmp (sEXEType, "unknown") == 0) {
									printf ("[ INFO ] %s has an unknown executable type.\n",
										sEXELoc);
								} else {
									EXE();
								}
							}
							break;
						case SDLK_F3:
							if (iScreen == 1)
							{
								if (iEditPoP == 1)
								{
									if ((strcmp (sEXEType, "missing") != 0) &&
										(strcmp (sEXEType, "unknown") != 0))
									{
										EXE_F3();
									} else {
										printf ("[ INFO ] Missing or unknown executable.\n");
									}
								}
								if (iEditPoP == 3)
								{
									if ((strcmp (sEXEType, "US") == 0) ||
										(strcmp (sEXEType, "EU") == 0))
									{
										Text();
									} else {
										printf ("[ INFO ] %s has an incompatible"
											" executable type.\n", sSNESFile);
									}
								}
							}
							break;
						case SDLK_F4:
							if (iScreen == 1)
							{
								if (iEditPoP == 1)
								{
									if ((strcmp (sEXEType, "missing") != 0) &&
										(strcmp (sEXEType, "unknown") != 0))
									{
										/* This if() prevents the program from reacting to the
										 * closure of other windows, such as SDLPoP, with Alt+F4.
										 */
										if ((!(event.key.keysym.mod & KMOD_LALT)) &&
											(!(event.key.keysym.mod & KMOD_RALT)))
											{ EXE_F4(); }
									} else {
										printf ("[ INFO ] Missing or unknown executable.\n");
									}
								}
								if (iEditPoP == 3) { Automatic(); }
							}
							break;
						case SDLK_F5:
							if (iScreen == 1)
							{
								if (iEditPoP != 2)
								{
									if ((strcmp (sEXEType, "missing") != 0) &&
										(strcmp (sEXEType, "unknown") != 0))
									{
										EXE_F5();
									} else {
										printf ("[ INFO ] Missing or unknown executable.\n");
									}
								}
							}
							break;
						case SDLK_F12:
							if (iScreen == 1)
							{
								if ((strcmp (sEXEType, "missing") != 0) &&
									(strcmp (sEXEType, "unknown") != 0))
								{
									if (iEditPoP != 2)
									{
										snprintf (sEXELoc, MAX_FILE, "%s", POP1_EXECUTABLE);
									} else {
										snprintf (sEXELoc, MAX_FILE, "%s", POP2_EXECUTABLE);
									}
									HexEditor (sEXELoc);
								} else {
									printf ("[ INFO ] Missing or unknown executable.\n");
								}
							}
							break;
						case SDLK_LEFTBRACKET:
							InitScreenAction ("left bracket");
							break;
						case SDLK_RIGHTBRACKET:
							InitScreenAction ("right bracket");
							break;
						case SDLK_d:
							if (iEditPoP == 1)
							{
								AutoUse ((int)luLevelNr);
							} else {
								RunLevel ((int)luLevelNr);
							}
							break;
						case SDLK_SLASH:
							if (iScreen == 1) { ClearRoom(); }
							break;
						case SDLK_BACKSLASH:
							if (iScreen == 1)
							{
								/*** Randomize the entire level. ***/
								iYesNo = InitPopUpYN (2);
								if (iYesNo == 2)
								{
									for (iTemp2 = 1; iTemp2 <= iRooms; iTemp2++)
									{
										for (iTemp = 1; iTemp <= 30; iTemp++)
										{
											UseTile (-1, iTemp, iTemp2, 0);
										}
									}
									iChanged++;
									PlaySound ("wav/ok_close.wav");
								}
							}
							break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							if (((event.key.keysym.mod & KMOD_LALT) ||
								(event.key.keysym.mod & KMOD_RALT)) && (iScreen == 1))
							{
								Zoom (1);
								iExtras = 0;
								PlaySound ("wav/extras.wav");
							} else {
								InitScreenAction ("enter");
							}
							break;
						case SDLK_BACKSPACE:
							if ((iScreen == 2) && (iBrokenRoomLinks == 1))
							{
								LinkMinus();
							}
							break;
						case SDLK_ESCAPE:
						case SDLK_q:
							switch (iScreen)
							{
								case 1:
									Quit(); break;
								case 2:
									iBrokenRoomLinks = BrokenRoomLinks (0);
									iScreen = 1; break;
								case 3:
									iScreen = 1; break;
							}
							break;
						case SDLK_LEFT:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								switch (iScreen)
								{
									case 1:
										if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
											(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
											(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
										{
											iCurRoom = iRoomConnections[iCurRoom][1];
											PlaySound ("wav/scroll.wav");
										}
										break;
									case 3:
										ChangeEvent (-1, 0);
										break;
								}
							} else if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								if (iScreen == 3)
								{
									ChangeEvent (-10, 0);
								}
							} else {
								InitScreenAction ("left");
							}
							break;
						case SDLK_RIGHT:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								switch (iScreen)
								{
									case 1:
										if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
											(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
											(iRoomConnections[iCurRoom][2] != 255)) /*** SNES ***/
										{
											iCurRoom = iRoomConnections[iCurRoom][2];
											PlaySound ("wav/scroll.wav");
										}
										break;
									case 3:
										ChangeEvent (1, 0);
										break;
								}
							} else if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								if (iScreen == 3)
								{
									ChangeEvent (10, 0);
								}
							} else {
								InitScreenAction ("right");
							}
							break;
						case SDLK_UP:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								if (iScreen == 1)
								{
									if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][3] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][3];
										PlaySound ("wav/scroll.wav");
									}
								}
							} else {
								InitScreenAction ("up");
							}
							break;
						case SDLK_DOWN:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								if (iScreen == 1)
								{
									if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
										(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
										(iRoomConnections[iCurRoom][4] != 255)) /*** SNES ***/
									{
										iCurRoom = iRoomConnections[iCurRoom][4];
										PlaySound ("wav/scroll.wav");
									}
								}
							} else {
								InitScreenAction ("down");
							}
							break;
						case SDLK_y:
							if ((iEditPoP != 2) && (iScreen == 3))
							{
								if (EventInfo (iChangeEvent, 3) == 0) { EventNext (0); }
							}
							break;
						case SDLK_n:
							if ((iEditPoP != 2) && (iScreen == 3))
							{
								if (EventInfo (iChangeEvent, 3) == 1) { EventNext (1); }
							}
							break;
						case SDLK_t:
							if (iScreen == 1) { InitScreenAction ("env"); }
							break;
						case SDLK_MINUS:
						case SDLK_KP_MINUS:
							if ((int)luLevelNr != 1)
							{
								if ((iChanged != 0) && (iNoSave == 0))
									{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
								if (iYesNo != 0)
								{
									if (iYesNo == 2) { CallSave (0); }
									Prev ((int)luLevelNr);
								}
							}
							break;
						case SDLK_KP_PLUS:
						case SDLK_EQUALS:
							if (((int)luLevelNr != 0) && ((int)luLevelNr != 28))
							{
								if ((iChanged != 0) && (iNoSave == 0))
									{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
								if (iYesNo != 0)
								{
									if (iYesNo == 2) { CallSave (0); }
									Next ((int)luLevelNr);
								}
							}
							break;
						case SDLK_r:
							if (iScreen != 2)
							{
								iScreen = 2;
								iMovingRoom = 0;
								iMovingNewBusy = 0;
								iChangingBrokenRoom = iCurRoom;
								iChangingBrokenSide = 1;
								PlaySound ("wav/screen2or3.wav");
							} else if (iBrokenRoomLinks == 0) {
								iBrokenRoomLinks = 1;
								PlaySound ("wav/screen2or3.wav");
							}
							break;
						case SDLK_e:
							if (iScreen == 2)
							{
								iBrokenRoomLinks = BrokenRoomLinks (0);
							}
							if (iScreen != 3)
							{
								iScreen = 3;
								PlaySound ("wav/screen2or3.wav");
							}
							break;
						case SDLK_s:
							if (iChanged != 0) { CallSave (0); } break;
						case SDLK_z:
							if (iScreen == 1)
							{
								Zoom (0);
								iExtras = 0;
								PlaySound ("wav/extras.wav");
							}
							break;
						case SDLK_f:
							if (iScreen == 1)
							{
								Zoom (1);
								iExtras = 0;
								PlaySound ("wav/extras.wav");
							}
							break;
						case SDLK_QUOTE:
							if (iScreen == 1)
							{
								if ((event.key.keysym.mod & KMOD_LSHIFT) ||
									(event.key.keysym.mod & KMOD_RSHIFT))
								{
									iYesNo = InitPopUpYN (3);
									if (iYesNo == 2)
									{
										Sprinkle();
										PlaySound ("wav/extras.wav");
										iChanged++;
									}
								} else {
									if (iEditPoP != 3)
									{
										SetLocation (iCurRoom, iSelected, iLastThing,
											iLastModifier[1], iLastModifier[2],
											iLastModifier[3], iLastModifier[4]);
									} else {
										/* If we would only use SetLocationSNES(), the tile
										 * transformation based on what is under the tile
										 * would not happen.
										 */
										iTileNr = GetTileNrSNES (iLastThingSNES[1],
											iLastThingSNES[2], iLastThingSNES[3],
											iLastThingSNES[4], iLastModifierSNES);
										if (iTileNr != 0) /*** If it is not a custom tile... ***/
										{
											UseTile (iTileNr, iSelected, iCurRoom, 0);
										} else {
											SetLocationSNES (iCurRoom, iSelected, iLastThingSNES[1],
												iLastThingSNES[2], iLastThingSNES[3],
												iLastThingSNES[4], iLastModifierSNES, 0);
										}
									}
									PlaySound ("wav/ok_close.wav");
									iChanged++;
								}
							}
							break;
						case SDLK_h:
							if (iScreen == 1)
							{
								FlipRoom (iCurRoom, 1);
								PlaySound ("wav/extras.wav");
								iChanged++;
							}
							break;
						case SDLK_v:
							if (iScreen == 1)
							{
								if ((event.key.keysym.mod & KMOD_LCTRL) ||
									(event.key.keysym.mod & KMOD_RCTRL))
								{
									CopyPaste (iCurRoom, 2);
									PlaySound ("wav/extras.wav");
									iChanged++;
								} else {
									FlipRoom (iCurRoom, 2);
									PlaySound ("wav/extras.wav");
									iChanged++;
								}
							}
							break;
						case SDLK_c:
							if (iScreen == 1)
							{
								if ((event.key.keysym.mod & KMOD_LCTRL) ||
									(event.key.keysym.mod & KMOD_RCTRL))
								{
									CopyPaste (iCurRoom, 1);
									PlaySound ("wav/extras.wav");
								}
							}
							break;
						case SDLK_i:
							if (iScreen == 1)
							{
								if (iInfo == 0) { iInfo = 1; } else { iInfo = 0; }
							}
							break;
						case SDLK_0: /*** empty ***/
						case SDLK_KP_0:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 0, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (1, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_1: /*** floor ***/
						case SDLK_KP_1:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								if (cCurType == 'd')
								{
									SetLocation (iCurRoom, iSelected, 1, 0, -1, -1, -1);
								} else {
									SetLocation (iCurRoom, iSelected, 1, 1, -1, -1, -1);
								}
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (2, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_2: /*** loose floor ***/
						case SDLK_KP_2:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 11, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (5, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_3: /*** closed gate ***/
						case SDLK_KP_3:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 4, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (16, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_4: /*** open gate ***/
						case SDLK_KP_4:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 4, 1, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (18, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_5: /*** flame ***/
						case SDLK_KP_5:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 19, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (47, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_6: /*** spike ***/
						case SDLK_KP_6:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 2, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (28, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_7: /*** small pillar ***/
						case SDLK_KP_7:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 3, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (4, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_8: /*** chomper ***/
						case SDLK_KP_8:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 18, 0, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (27, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_9: /*** wall ***/
						case SDLK_KP_9:
							if ((iScreen == 1) && (iEditPoP == 1))
							{
								SetLocation (iCurRoom, iSelected, 20, 1, -1, -1, -1);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							if ((iScreen == 1) && (iEditPoP == 3))
							{
								UseTile (3, iSelected, iCurRoom, 0);
								PlaySound ("wav/ok_close.wav"); iChanged++;
							}
							break;
						case SDLK_p:
							if (iScreen == 1)
							{
								if ((event.key.keysym.mod & KMOD_LCTRL) ||
									(event.key.keysym.mod & KMOD_RCTRL))
								{
									/*** Print template data. ***/
									if (iEditPoP == 3)
									{
										for (iTemp = 0; iTemp < 30; iTemp++)
										{
											iBack = iBackA[iCurRoom][iTemp];
											if (((iEXEType == 1) || (iEXEType == 2)) &&
												(cCurType == 'f') &&
												((iBack >= 0x80) && (iBack <= 0x97)))
											{
												/*** fawn cloud backgrounds for US and EU ***/
												iBack-=0x55;
											} else if ((cCurType == 'u') &&
												((iBack >= 0xf9) && (iBack <= 0xfe))) {
												/*** umber bus error occurred ***/
												iBack-=0xa5;
											}
											printf ("%02x %02x %02x %02x %02x %02x\n",
												iBlock1A[iCurRoom][iTemp],
												iBlock2A[iCurRoom][iTemp],
												iBlock3A[iCurRoom][iTemp],
												iBlock4A[iCurRoom][iTemp],
												iModifierA[iCurRoom][iTemp][1],
												iBack);
										}
									}
								}
							}
							break;
						case SDLK_x:
							if ((iEditPoP == 1) && (iScreen == 1))
							{
								if ((iUsesNative != 0) ||
									(iFoundSDLPoP != 0) || (iFoundMININIM != 0))
								{
									Native (iSelected, ascreen, 0);
								} else {
									printf ("[ WARN ] No native PoP1 found!\n");
								}
							}
							break;
						case SDLK_m:
							/*** && (iScreen == 2) ***/
							if ((iEditPoP == 1) || (iEditPoP == 3))
							{
								if (iBrokenRoomLinks == 0)
								{
									if (iMapOpen == 0)
									{
										MapShow();
									} else {
										SDL_RaiseWindow (windowmap);
									}
								}
							}
							break;
						case SDLK_j:
							JumpTo (1);
							break;
						case SDLK_l:
							JumpTo (2);
							break;
						default: break;
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_MOUSEMOTION:
					iOldXPos = iXPos;
					iOldYPos = iYPos;
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if ((iOldXPos == iXPos) && (iOldYPos == iYPos)) { break; }

					if (iScreen == 2)
					{
						if (iMovingRoom != 0) { ShowScreen (2, ascreen); }
					}

					/*** Level 10 warning. ***/
					if ((iEditPoP == 2) && ((luLevelNr == 10) ||
						(luLevelNr == 24)) && (arKidRoom[1] == 22))
					{
						if (OnLevelBar() == 1)
						{
							if (iLvlWarning != 10)
								{ iLvlWarning = 10; ShowScreen (iScreen, ascreen); }
						} else {
							if (iLvlWarning != 0)
								{ iLvlWarning = 0; ShowScreen (iScreen, ascreen); }
						}
					}

					/*** Level 21 warning. ***/
					if ((iEditPoP == 3) && (luLevelNr == 21))
					{
						if (OnLevelBar() == 1)
						{
							if (iLvlWarning != 21)
								{ iLvlWarning = 21; ShowScreen (iScreen, ascreen); }
						} else {
							if (iLvlWarning != 0)
								{ iLvlWarning = 0; ShowScreen (iScreen, ascreen); }
						}
					}

					/*** ZSNES ***/
					if (iEditPoP == 3)
					{
						if (OnLevelBar() == 1)
						{
							if (iZSNES != 1)
								{ iZSNES = 1; ShowScreen (iScreen, ascreen); }
						} else {
							if (iZSNES != 0)
								{ iZSNES = 0; ShowScreen (iScreen, ascreen); }
						}
					}

					if (iScreen == 1)
					{
						/*** User hovers over tiles in the upper row. ***/
						if ((InArea (iHor1, iVer1 + iTTP1, iHor2, iVer2 + iTTPO)
							== 1) && (iSelected != 1))
							{ iSelected = 1; ShowScreen (1, ascreen); }
						else if ((InArea (iHor2, iVer1 + iTTP1, iHor3, iVer2 + iTTPO)
							== 1) && (iSelected != 2))
							{ iSelected = 2; ShowScreen (1, ascreen); }
						else if ((InArea (iHor3, iVer1 + iTTP1, iHor4, iVer2 + iTTPO)
							== 1) && (iSelected != 3))
							{ iSelected = 3; ShowScreen (1, ascreen); }
						else if ((InArea (iHor4, iVer1 + iTTP1, iHor5, iVer2 + iTTPO)
							== 1) && (iSelected != 4))
							{ iSelected = 4; ShowScreen (1, ascreen); }
						else if ((InArea (iHor5, iVer1 + iTTP1, iHor6, iVer2 + iTTPO)
							== 1) && (iSelected != 5))
							{ iSelected = 5; ShowScreen (1, ascreen); }
						else if ((InArea (iHor6, iVer1 + iTTP1, iHor7, iVer2 + iTTPO)
							== 1) && (iSelected != 6))
							{ iSelected = 6; ShowScreen (1, ascreen); }
						else if ((InArea (iHor7, iVer1 + iTTP1, iHor8, iVer2 + iTTPO)
							== 1) && (iSelected != 7))
							{ iSelected = 7; ShowScreen (1, ascreen); }
						else if ((InArea (iHor8, iVer1 + iTTP1, iHor9, iVer2 + iTTPO)
							== 1) && (iSelected != 8))
							{ iSelected = 8; ShowScreen (1, ascreen); }
						else if ((InArea (iHor9, iVer1 + iTTP1, iHor10, iVer2 + iTTPO)
							== 1) && (iSelected != 9))
							{ iSelected = 9; ShowScreen (1, ascreen); }
						else if ((InArea (iHor10, iVer1 + iTTP1, iHor10 + iDX,
							iVer2 + iTTPO) == 1) && (iSelected != 10))
						{ iSelected = 10; ShowScreen (1, ascreen); }

						/*** User hovers over tiles in the middle row. ***/
						else if ((InArea (iHor1, iVer2 + iTTPO, iHor2, iVer3 + iTTPO)
							== 1) && (iSelected != 11))
							{ iSelected = 11; ShowScreen (1, ascreen); }
						else if ((InArea (iHor2, iVer2 + iTTPO, iHor3, iVer3 + iTTPO)
							== 1) && (iSelected != 12))
							{ iSelected = 12; ShowScreen (1, ascreen); }
						else if ((InArea (iHor3, iVer2 + iTTPO, iHor4, iVer3 + iTTPO)
							== 1) && (iSelected != 13))
							{ iSelected = 13; ShowScreen (1, ascreen); }
						else if ((InArea (iHor4, iVer2 + iTTPO, iHor5, iVer3 + iTTPO)
							== 1) && (iSelected != 14))
							{ iSelected = 14; ShowScreen (1, ascreen); }
						else if ((InArea (iHor5, iVer2 + iTTPO, iHor6, iVer3 + iTTPO)
							== 1) && (iSelected != 15))
							{ iSelected = 15; ShowScreen (1, ascreen); }
						else if ((InArea (iHor6, iVer2 + iTTPO, iHor7, iVer3 + iTTPO)
							== 1) && (iSelected != 16))
							{ iSelected = 16; ShowScreen (1, ascreen); }
						else if ((InArea (iHor7, iVer2 + iTTPO, iHor8, iVer3 + iTTPO)
							== 1) && (iSelected != 17))
							{ iSelected = 17; ShowScreen (1, ascreen); }
						else if ((InArea (iHor8, iVer2 + iTTPO, iHor9, iVer3 + iTTPO)
							== 1) && (iSelected != 18))
							{ iSelected = 18; ShowScreen (1, ascreen); }
						else if ((InArea (iHor9, iVer2 + iTTPO, iHor10, iVer3 + iTTPO)
							== 1) && (iSelected != 19))
							{ iSelected = 19; ShowScreen (1, ascreen); }
						else if ((InArea (iHor10, iVer2 + iTTPO, iHor10 + iDX,
							iVer3 + iTTPO) == 1) && (iSelected != 20))
						{ iSelected = 20; ShowScreen (1, ascreen); }

						/*** User hovers over tiles in the bottom row. ***/
						else if ((InArea (iHor1, iVer3 + iTTPO, iHor2, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 21))
							{ iSelected = 21; ShowScreen (1, ascreen); }
						else if ((InArea (iHor2, iVer3 + iTTPO, iHor3, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 22))
							{ iSelected = 22; ShowScreen (1, ascreen); }
						else if ((InArea (iHor3, iVer3 + iTTPO, iHor4, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 23))
							{ iSelected = 23; ShowScreen (1, ascreen); }
						else if ((InArea (iHor4, iVer3 + iTTPO, iHor5, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 24))
							{ iSelected = 24; ShowScreen (1, ascreen); }
						else if ((InArea (iHor5, iVer3 + iTTPO, iHor6, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 25))
							{ iSelected = 25; ShowScreen (1, ascreen); }
						else if ((InArea (iHor6, iVer3 + iTTPO, iHor7, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 26))
							{ iSelected = 26; ShowScreen (1, ascreen); }
						else if ((InArea (iHor7, iVer3 + iTTPO, iHor8, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 27))
							{ iSelected = 27; ShowScreen (1, ascreen); }
						else if ((InArea (iHor8, iVer3 + iTTPO, iHor9, iVer3 + iDY + iTTPO)
							== 1) && (iSelected != 28))
							{ iSelected = 28; ShowScreen (1, ascreen); }
						else if ((InArea (iHor9, iVer3 + iTTPO, iHor10, iVer3 + iDY +
							iTTPO) == 1) && (iSelected != 29))
							{ iSelected = 29; ShowScreen (1, ascreen); }
						else if ((InArea (iHor10, iVer3 + iTTPO, iHor10 + iDX,
							iVer3 + iDY + iTTPO) == 1) && (iSelected != 30))
						{ iSelected = 30; ShowScreen (1, ascreen); }

						/*** extras ***/
						if ((InArea (610, 3, 619, 12) == 1) && (iExtras != 1))
							{ iExtras = 1; ShowScreen (1, ascreen); }
						else if ((InArea (620, 3, 629, 12) == 1) && (iExtras != 2))
							{ iExtras = 2; ShowScreen (1, ascreen); }
						else if ((InArea (630, 3, 639, 12) == 1) && (iExtras != 3))
							{ iExtras = 3; ShowScreen (1, ascreen); }
						else if ((InArea (640, 3, 649, 12) == 1) && (iExtras != 4))
							{ iExtras = 4; ShowScreen (1, ascreen); }
						else if ((InArea (650, 3, 659, 12) == 1) && (iExtras != 5))
							{ iExtras = 5; ShowScreen (1, ascreen); }
						else if ((InArea (610, 13, 619, 22) == 1) && (iExtras != 6))
							{ iExtras = 6; ShowScreen (1, ascreen); }
						else if ((InArea (620, 13, 629, 22) == 1) && (iExtras != 7))
							{ iExtras = 7; ShowScreen (1, ascreen); }
						else if ((InArea (630, 13, 639, 22) == 1) && (iExtras != 8))
							{ iExtras = 8; ShowScreen (1, ascreen); }
						else if ((InArea (640, 13, 649, 22) == 1) && (iExtras != 9))
							{ iExtras = 9; ShowScreen (1, ascreen); }
						else if ((InArea (650, 13, 659, 22) == 1) && (iExtras != 10))
							{ iExtras = 10; ShowScreen (1, ascreen); }
						else if ((InArea (610, 3, 659, 22) == 0) && (iExtras != 0))
							{ iExtras = 0; ShowScreen (1, ascreen); }
					}

					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (0, 50, 25, 430) == 1) /*** left arrow ***/
						{
							if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
								iDownAt = 1;
						}
						if (InArea (667, 50, 692, 430) == 1) /*** right arrow ***/
						{
							if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][2] != 255)) /*** SNES ***/
								iDownAt = 2;
						}
						if (InArea (25, 25, 667, 50) == 1) /*** up arrow ***/
						{
							if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][3] != 255)) /*** SNES ***/
								iDownAt = 3;
						}
						if (InArea (25, 430, 667, 455) == 1) /*** down arrow ***/
						{
							if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][4] != 255)) /*** SNES ***/
								iDownAt = 4;
						}
						if (InArea (0, 25, 25, 50) == 1) /*** rooms ***/
						{
							if (iBrokenRoomLinks == 0)
							{
								iDownAt = 5;
							} else {
								iDownAt = 11;
							}
						}
						if (InArea (667, 25, 692, 50) == 1) /*** events ***/
						{
							iDownAt = 6;
						}
						if (InArea (0, 430, 25, 455) == 1) /*** save ***/
						{
							iDownAt = 7;
						}
						if (InArea (667, 430, 692, 455) == 1) /*** quit ***/
						{
							iDownAt = 8;
						}
						if (InArea (0, 0, 25, 25) == 1) /*** previous ***/
						{
							iDownAt = 9;
						}
						if (InArea (667, 0, 692, 25) == 1) /*** next ***/
						{
							iDownAt = 10;
						}

						if (iScreen == 2)
						{
							if (iBrokenRoomLinks == 0)
							{
								for (iTemp = 0; iTemp < iRooms; iTemp++) /*** x ***/
								{
									for (iTemp2 = 0; iTemp2 < iRooms; iTemp2++) /*** y ***/
									{
										if (InArea (297 + (iTemp * 15), 61 + (iTemp2 * 15),
											310 + (iTemp * 15), 74 + (iTemp2 * 15)) == 1)
										{
											if (iRoomArray[iTemp + 1][iTemp2 + 1] != 0)
											{
												iMovingNewBusy = 0;
												iMovingRoom = iRoomArray[iTemp + 1][iTemp2 + 1];
											}
										}
									}
								}
								for (iTemp2 = 0; iTemp2 < iRooms; iTemp2++) /*** y ***/
								{
									if (iTemp2 < 24) /*** right pane ***/
									{
										if (InArea (272, 61 + (iTemp2 * 15),
											272 + 14, 61 + 14 + (iTemp2 * 15)) == 1)
										{
											if (iRoomArray[25][iTemp2 + 1] != 0)
											{
												iMovingNewBusy = 0;
												iMovingRoom = iRoomArray[25][iTemp2 + 1];
											}
										}
									} else { /*** left pane ***/
										if ((InArea (247, 301 + ((iTemp2 - 24) * 15),
											247 + 14, 301 + 14 + ((iTemp2 - 24) * 15)) == 1) &&
											(iEditPoP == 2))
										{
											if (iRoomArray[25][iTemp2 + 1] != 0)
											{
												iMovingNewBusy = 0;
												iMovingRoom = iRoomArray[25][iTemp2 + 1];
											}
										}
									}
								}

								/*** Map window ***/
								if (InArea (599, 63, 599 + 25, 63 + 25) == 1)
								{
									iDownAt = 12;
								}

								/*** rooms broken ***/
								if (InArea (629, 63, 654, 88) == 1)
								{
									iDownAt = 11;
								}
							} else {
								MouseSelectAdj();
							}
						}

						if (iScreen == 3) /*** events ***/
						{
							if (InArea (251, 254, 336, 286) == 1) /*** edit left ***/
								{ if (iEditLeftOn != 1) { iEditLeftOn = 1; } }
							if (InArea (346, 254, 431, 286) == 1) /*** end left ***/
								{ if (iEndLeftOn != 1) { iEndLeftOn = 1; } }
							if (InArea (476, 254, 561, 286) == 1) /*** edit right ***/
								{ if (iEditRightOn != 1) { iEditRightOn = 1; } }
							if (InArea (571, 254, 656, 286) == 1) /*** end right ***/
								{ if (iEndRightOn != 1) { iEndRightOn = 1; } }
						}
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_MOUSEBUTTONUP:
					iDownAt = 0;
					iEditLeftOn = 0;
					iEndLeftOn = 0;
					iEditRightOn = 0;
					iEndRightOn = 0;
					if (event.button.button == 1) /*** left mouse button, change ***/
					{
						if (InArea (0, 50, 25, 430) == 1) /*** left arrow ***/
						{
							if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][1] != 255)) { /*** SNES ***/
								iCurRoom = iRoomConnections[iCurRoom][1];
								PlaySound ("wav/scroll.wav"); }
						}
						if (InArea (667, 50, 692, 430) == 1) /*** right arrow ***/
						{
							if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][2] != 255)) { /*** SNES ***/
								iCurRoom = iRoomConnections[iCurRoom][2];
								PlaySound ("wav/scroll.wav"); }
						}
						if (InArea (25, 25, 667, 50) == 1) /*** up arrow ***/
						{
							if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][3] != 255)) { /*** SNES ***/
								iCurRoom = iRoomConnections[iCurRoom][3];
								PlaySound ("wav/scroll.wav"); }
						}
						if (InArea (25, 430, 667, 455) == 1) /*** down arrow ***/
						{
							if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
								(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
								(iRoomConnections[iCurRoom][4] != 255)) { /*** SNES ***/
								iCurRoom = iRoomConnections[iCurRoom][4];
								PlaySound ("wav/scroll.wav"); }
						}
						if (InArea (0, 25, 25, 50) == 1) /*** rooms ***/
						{
							if (iScreen != 2)
							{
								iScreen = 2; iMovingRoom = 0; iMovingNewBusy = 0;
								iChangingBrokenRoom = iCurRoom;
								iChangingBrokenSide = 1;
								PlaySound ("wav/screen2or3.wav");
							}
						}
						if (InArea (667, 25, 692, 50) == 1) /*** events ***/
						{
							if (iScreen == 2)
							{
								iBrokenRoomLinks = BrokenRoomLinks (0);
							}
							if (iScreen != 3)
							{
								iScreen = 3;
								PlaySound ("wav/screen2or3.wav");
							}
						}
						if (InArea (0, 430, 25, 455) == 1) /*** save ***/
						{
							if (iChanged != 0) { CallSave (0); }
						}
						if (InArea (667, 430, 692, 455) == 1) /*** quit ***/
						{
							switch (iScreen)
							{
								case 1:
									Quit(); break;
								case 2:
									iBrokenRoomLinks = BrokenRoomLinks (0);
									iScreen = 1; break;
								case 3:
									iScreen = 1; break;
							}
						}
						if (InArea (0, 0, 25, 25) == 1) /*** previous ***/
						{
							if ((iChanged != 0) && (iNoSave == 0))
								{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
							if (iYesNo != 0)
							{
								if (iYesNo == 2) { CallSave (0); }
								Prev ((int)luLevelNr);
								ShowScreen (iScreen, ascreen);
							}
							break; /*** Stop processing SDL_MOUSEBUTTONUP. ***/
						}
						if (InArea (667, 0, 692, 25) == 1) /*** next ***/
						{
							if ((iChanged != 0) && (iNoSave == 0))
								{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
							if (iYesNo != 0)
							{
								if (iYesNo == 2) { CallSave (0); }
								Next ((int)luLevelNr);
								ShowScreen (iScreen, ascreen);
							}
							break; /*** Stop processing SDL_MOUSEBUTTONUP. ***/
						}
						if (OnLevelBar() == 1) /*** level bar ***/
						{
							if (iEditPoP == 1)
							{
								AutoUse ((int)luLevelNr);
								break; /*** Stop processing SDL_MOUSEBUTTONUP. ***/
							} else {
								RunLevel ((int)luLevelNr);
							}
						}

						if (iScreen == 1)
						{
							if (InArea (iHor1, iVer1 + iTTP1, iHor10 + iDX,
								iVer3 + iDY + iTTPO) == 1) /*** middle field ***/
							{
								keystate = SDL_GetKeyboardState (NULL);
								if ((keystate[SDL_SCANCODE_LSHIFT]) ||
									(keystate[SDL_SCANCODE_RSHIFT]))
								{
									if (iEditPoP != 3)
									{
										SetLocation (iCurRoom, iSelected, iLastThing,
											iLastModifier[1], iLastModifier[2], iLastModifier[3],
											iLastModifier[4]);
									} else {
										/* If we would only use SetLocationSNES(), the tile
										 * transformation based on what is under the tile
										 * would not happen.
										 */
										iTileNr = GetTileNrSNES (iLastThingSNES[1],
											iLastThingSNES[2], iLastThingSNES[3],
											iLastThingSNES[4], iLastModifierSNES);
										if (iTileNr != 0) /*** If it is not a custom tile... ***/
										{
											UseTile (iTileNr, iSelected, iCurRoom, 0);
										} else {
											SetLocationSNES (iCurRoom, iSelected, iLastThingSNES[1],
												iLastThingSNES[2], iLastThingSNES[3],
												iLastThingSNES[4], iLastModifierSNES, 0);
										}
									}
									PlaySound ("wav/ok_close.wav");
									iChanged++;
								} else if ((keystate[SDL_SCANCODE_LCTRL]) ||
									(keystate[SDL_SCANCODE_RCTRL])) {
									if (iEditPoP == 1)
									{
										if ((iUsesNative != 0) ||
											(iFoundSDLPoP != 0) || (iFoundMININIM != 0))
										{
											Native (iSelected, ascreen, 0);
										} else {
											printf ("[ WARN ] No native PoP1 found!\n");
										}
									}
								} else {
									ChangePos (iSelected, ascreen);
									ShowScreen (iScreen, ascreen); break;
								}
							}

							/*** 1 ***/
							if (InArea (610, 3, 619, 12) == 1)
							{
								Zoom (0);
								iExtras = 0;
								PlaySound ("wav/extras.wav");
							}

							/*** 4 ***/
							if (InArea (640, 3, 649, 12) == 1)
							{
								InitScreenAction ("env");
							}

							/*** 6 ***/
							if (InArea (610, 13, 619, 22) == 1)
							{
								iYesNo = InitPopUpYN (3);
								if (iYesNo == 2)
								{
									Sprinkle();
									PlaySound ("wav/extras.wav");
									iChanged++;
								}
							}

							/*** 8 ***/
							if (InArea (630, 13, 639, 22) == 1)
							{
								FlipRoom (iCurRoom, 1);
								PlaySound ("wav/extras.wav");
								iChanged++;
							}

							/*** 3 ***/
							if (InArea (630, 3, 639, 12) == 1)
							{
								FlipRoom (iCurRoom, 2);
								PlaySound ("wav/extras.wav");
								iChanged++;
							}

							/*** 2 ***/
							if (InArea (620, 3, 629, 12) == 1)
							{
								CopyPaste (iCurRoom, 1);
								PlaySound ("wav/extras.wav");
							}

							/*** 7 ***/
							if (InArea (620, 13, 629, 22) == 1)
							{
								CopyPaste (iCurRoom, 2);
								PlaySound ("wav/extras.wav");
								iChanged++;
							}

							/*** 5 ***/
							if (InArea (650, 3, 659, 12) == 1)
							{
								Help();
							}

							/*** 10 ***/
							if (InArea (650, 13, 659, 22) == 1)
							{
								if (iEditPoP != 2)
								{
									snprintf (sEXELoc, MAX_FILE, "%s", POP1_EXECUTABLE);
								} else {
									snprintf (sEXELoc, MAX_FILE, "%s", POP2_EXECUTABLE);
								}
								if (strcmp (sEXEType, "missing") == 0)
								{
									printf ("[ INFO ] %s does not exist.\n", sEXELoc);
								} else if (strcmp (sEXEType, "unknown") == 0) {
									printf ("[ INFO ] %s has an unknown executable type.\n",
										sEXELoc);
								} else {
									EXE();
								}
							}
						}

						if (iScreen == 2) /*** room links screen ***/
						{
							if (iBrokenRoomLinks == 0)
							{
								for (iTemp = 0; iTemp < iRooms; iTemp++) /*** x ***/
								{
									for (iTemp2 = 0; iTemp2 < iRooms; iTemp2++) /*** y ***/
									{
										if (InArea (297 + (iTemp * 15), 61 + (iTemp2 * 15),
											310 + (iTemp * 15), 74 + (iTemp2 * 15)) == 1)
										{
											if (iMovingRoom != 0)
											{
												if (iRoomArray[iTemp + 1][iTemp2 + 1] == 0)
												{
													RemoveOldRoom();
													AddNewRoom (iTemp + 1, iTemp2 + 1, iMovingRoom);
													iChanged++;
												}
												iMovingRoom = 0; iMovingNewBusy = 0;
											}
										}
									}
								}
								for (iTemp2 = 0; iTemp2 < iRooms; iTemp2++) /*** y ***/
								{
									if (iTemp2 < 24) /*** right pane ***/
									{
										if (InArea (272, 61 + (iTemp2 * 15),
											272 + 14, 61 + 14 + (iTemp2 * 15)) == 1)
										{
											if (iMovingRoom != 0)
											{
												if (iRoomArray[25][iTemp2 + 1] == 0)
												{
													RemoveOldRoom();
													AddNewRoom (25, iTemp2 + 1, iMovingRoom);
													iChanged++;
												}
												iMovingRoom = 0; iMovingNewBusy = 0;
											}
										}
									} else { /*** left pane ***/
										if ((InArea (247, 301 + ((iTemp2 - 24) * 15),
											247 + 14, 301 + 14 + ((iTemp2 - 24) * 15)) == 1) &&
											(iEditPoP == 2))
										{
											if (iMovingRoom != 0)
											{
												if (iRoomArray[25][iTemp2 + 1] == 0)
												{
													RemoveOldRoom();
													AddNewRoom (25, iTemp2 + 1, iMovingRoom);
													iChanged++;
												}
												iMovingRoom = 0; iMovingNewBusy = 0;
											}
										}
									}
								}

								/*** Map window ***/
								if (((iEditPoP == 1) || (iEditPoP == 3)) && (iMapOpen == 0))
								{
									if (InArea (599, 63, 599 + 25, 63 + 25) == 1)
									{
										MapShow();
									}
								}

								/*** rooms broken ***/
								if (InArea (629, 63, 654, 88) == 1)
								{
									iBrokenRoomLinks = 1;
									PlaySound ("wav/screen2or3.wav");
								}
							} else {
								if (MouseSelectAdj() == 1)
								{
									LinkPlus();
								}
							}
						}

						if (iScreen == 3) /*** events screen ***/
						{
							/*** Change event number ***/
							if (InArea (343, 60, 355, 79) == 1)
								{ ChangeEvent (-10, 0); }
							if (InArea (358, 60, 370, 79) == 1)
								{ ChangeEvent (-1, 0); }
							if (InArea (428, 60, 440, 79) == 1)
								{ ChangeEvent (1, 0); }
							if (InArea (443, 60, 455, 79) == 1)
								{ ChangeEvent (10, 0); }

							/*** room (1-24) ***/
							if ((iYPos >= 115 * iScale) &&
								(iYPos <= 129 * iScale))
							{
								for (iTemp = 1; iTemp <= 24; iTemp++)
								{
									if ((iXPos >= (297 + ((iTemp - 1) * 15)) * iScale)
										&& (iXPos <= (311 + ((iTemp - 1) * 15)) * iScale))
									{
										if (iEditPoP != 2)
										{
											EventRoom (iTemp);
										} else {
											iPoP2DoorRoom[iChangeEvent] = iTemp;
											PlaySound ("wav/check_box.wav");
											iChanged++;
										}
									}
								}
							}
							/*** room (25-32) ***/
							if ((iYPos >= 150 * iScale) &&
								(iYPos <= 164 * iScale) && (iEditPoP == 2))
							{
								for (iTemp = 25; iTemp <= 32; iTemp++)
								{
									if ((iXPos >= (297 + ((iTemp - 25) * 15)) * iScale)
										&& (iXPos <= (311 + ((iTemp - 25) * 15)) * iScale))
									{
										iPoP2DoorRoom[iChangeEvent] = iTemp;
										PlaySound ("wav/check_box.wav");
										iChanged++;
									}
								}
							}

							/*** location ***/
							for (iTemp2 = 1; iTemp2 <= 3; iTemp2++)
							{
								for (iTemp = 1; iTemp <= 10; iTemp++)
								{
									if ((iXPos >= (462 + ((iTemp - 1) * 15)) * iScale)
										&& (iXPos <= (475 + ((iTemp - 1) * 15)) * iScale))
									{
										if ((iYPos >= (155 + ((iTemp2 - 1) * 15)) * iScale)
											&& (iYPos <= (168 + ((iTemp2 - 1) * 15)) * iScale))
										{
											if (iEditPoP != 2)
											{
												EventDoor (iTemp, iTemp2);
											} else {
												iPoP2DoorLocation[iChangeEvent] =
													((iTemp2 - 1) * 10) + iTemp - 1;
												PlaySound ("wav/check_box.wav");
												iChanged++;
											}
										}
									}
								}
							}

							if (iEditPoP != 2)
							{
								/*** next ***/
								if (InArea (582, 225, 595, 238) == 1) { EventNext (1); }
								if (InArea (597, 225, 610, 238) == 1) { EventNext (0); }
							} else {
								/*** left chain ***/
								PlusMinus (&iPoP2DoorLeft[iChangeEvent],
									319, 224, 0, 255, -10, 1);
								PlusMinus (&iPoP2DoorLeft[iChangeEvent],
									334, 224, 0, 255, -1, 1);
								PlusMinus (&iPoP2DoorLeft[iChangeEvent],
									404, 224, 0, 255, 1, 1);
								PlusMinus (&iPoP2DoorLeft[iChangeEvent],
									419, 224, 0, 255, 10, 1);
								/*** right chain ***/
								PlusMinus (&iPoP2DoorRight[iChangeEvent],
									544, 224, 0, 255, -10, 1);
								PlusMinus (&iPoP2DoorRight[iChangeEvent],
									559, 224, 0, 255, -1, 1);
								PlusMinus (&iPoP2DoorRight[iChangeEvent],
									629, 224, 0, 255, 1, 1);
								PlusMinus (&iPoP2DoorRight[iChangeEvent],
									644, 224, 0, 255, 10, 1);

								if (InArea (251, 254, 336, 286) == 1)
								{ /*** edit left ***/
									iChangeEvent = iPoP2DoorLeft[iChangeEvent];
									PlaySound ("wav/screen2or3.wav");
								}
								if (InArea (346, 254, 431, 286) == 1)
								{ /*** end left ***/
									iPoP2DoorLeft[iChangeEvent] = 253;
									PlaySound ("wav/screen2or3.wav");
									iChanged++;
								}
								if (InArea (476, 254, 561, 286) == 1)
								{ /*** edit right ***/
									iChangeEvent = iPoP2DoorRight[iChangeEvent];
									PlaySound ("wav/screen2or3.wav");
								}
								if (InArea (571, 254, 656, 286) == 1)
								{ /*** end right ***/
									iPoP2DoorRight[iChangeEvent] = 253;
									PlaySound ("wav/screen2or3.wav");
									iChanged++;
								}

								/*** checkpoints ***/
								PlusMinus (&iCheckPoints[0], 306, 301, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[0], 376, 301, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[1], 391, 301, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[1], 461, 301, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[2], 306, 325, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[2], 376, 325, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[3], 391, 325, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[3], 461, 325, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[4], 306, 349, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[4], 376, 349, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[5], 391, 349, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[5], 461, 349, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[6], 306, 373, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[6], 376, 373, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[7], 391, 373, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[7], 461, 373, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[8], 306, 397, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[8], 376, 397, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[9], 391, 397, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[9], 461, 397, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[10], 484, 325, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[10], 554, 325, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[11], 569, 325, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[11], 639, 325, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[12], 484, 349, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[12], 554, 349, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[13], 569, 349, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[13], 639, 349, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[14], 484, 373, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[14], 554, 373, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[15], 569, 373, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[15], 639, 373, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[16], 484, 397, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[16], 554, 397, 0, 99, 1, 1);
								PlusMinus (&iCheckPoints[17], 569, 397, 0, 99, -1, 1);
								PlusMinus (&iCheckPoints[17], 639, 397, 0, 99, 1, 1);
							}
						}
					}
					if (event.button.button == 2) /*** middle mouse button, clear ***/
					{
						if (iScreen == 1) { ClearRoom(); }
					}
					if (event.button.button == 3) /*** right mouse button ***/
					{
						if (iScreen == 1)
						{
							/*** Randomize the entire level. ***/
							iYesNo = InitPopUpYN (2);
							if (iYesNo == 2)
							{
								for (iTemp2 = 1; iTemp2 <= iRooms; iTemp2++)
								{
									for (iTemp = 1; iTemp <= 30; iTemp++)
									{
										UseTile (-1, iTemp, iTemp2, 0);
									}
								}
								PlaySound ("wav/ok_close.wav");
								iChanged++;
							}
						}
						if (iScreen == 2)
						{
							if (iBrokenRoomLinks == 1)
							{
								if (MouseSelectAdj() == 1)
								{
									LinkMinus();
								}
							}
						}
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_MOUSEWHEEL:
					if (event.wheel.y > 0) /*** scroll wheel up ***/
					{
						if (InArea (iHor1, iVer1 + iTTP1, iHor10 + iDX,
							iVer3 + iDY + iTTPO) == 1) /*** middle field ***/
						{
							keystate = SDL_GetKeyboardState (NULL);
							if ((keystate[SDL_SCANCODE_LSHIFT]) ||
								(keystate[SDL_SCANCODE_RSHIFT]))
							{ /*** right ***/
								if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
									(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
									(iRoomConnections[iCurRoom][2] != 255)) { /*** SNES ***/
									iCurRoom = iRoomConnections[iCurRoom][2];
									PlaySound ("wav/scroll.wav"); }
							} else { /*** up ***/
								if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
									(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
									(iRoomConnections[iCurRoom][3] != 255)) { /*** SNES ***/
									iCurRoom = iRoomConnections[iCurRoom][3];
									PlaySound ("wav/scroll.wav"); }
							}
						}
					}
					if (event.wheel.y < 0) /*** scroll wheel down ***/
					{
						if (InArea (iHor1, iVer1 + iTTP1, iHor10 + iDX,
							iVer3 + iDY + iTTPO) == 1) /*** middle field ***/
						{
							keystate = SDL_GetKeyboardState (NULL);
							if ((keystate[SDL_SCANCODE_LSHIFT]) ||
								(keystate[SDL_SCANCODE_RSHIFT]))
							{ /*** left ***/
								if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
									(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
									(iRoomConnections[iCurRoom][1] != 255)) { /*** SNES ***/
									iCurRoom = iRoomConnections[iCurRoom][1];
									PlaySound ("wav/scroll.wav"); }
							} else { /*** down ***/
								if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
									(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
									(iRoomConnections[iCurRoom][4] != 255)) { /*** SNES ***/
									iCurRoom = iRoomConnections[iCurRoom][4];
									PlaySound ("wav/scroll.wav"); }
							}
						}
					}
					ShowScreen (iScreen, ascreen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowScreen (iScreen, ascreen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
				default:
					break;
			}
		}
		PreventCPUEating();
	}
}
/*****************************************************************************/
void EventDoor (int iX, int iY)
/*****************************************************************************/
{
	char sBinaryFDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sTempBinary[9 + 2]; /*** 8 chars, plus \0 ***/

	/* This part is kind of complicated. Only some bits have
	 * to be changed, so we first convert the event to bits,
	 * change some of them, and then convert them all back.
	 */
	GetAsEightBits (sFirstDoorEvents[iChangeEvent],
		sBinaryFDoors);
	GetAsEightBits ((((iY - 1) * 10) + iX - 1),
		sTempBinary);
	sBinaryFDoors[3] = sTempBinary[3];
	sBinaryFDoors[4] = sTempBinary[4];
	sBinaryFDoors[5] = sTempBinary[5];
	sBinaryFDoors[6] = sTempBinary[6];
	sBinaryFDoors[7] = sTempBinary[7];
	sFirstDoorEvents[iChangeEvent] =
		BitsToInt (sBinaryFDoors);
	PlaySound ("wav/check_box.wav");
	iChanged++;
}
/*****************************************************************************/
void EventNext (int iNoNext)
/*****************************************************************************/
{
	char sBinaryFDoors[9 + 2]; /*** 8 chars, plus \0 ***/

	/* This part is kind of complicated. Only one bit has
	 * to be changed, so we first convert the event to bits,
	 * change one of them, and then convert them all back.
	 */
	GetAsEightBits (sFirstDoorEvents[iChangeEvent],
		sBinaryFDoors);
	switch (iNoNext)
	{
		case 1: sBinaryFDoors[0] = '1'; break;
		case 0: sBinaryFDoors[0] = '0'; break;
	}
	sFirstDoorEvents[iChangeEvent] =
		BitsToInt (sBinaryFDoors);
	PlaySound ("wav/check_box.wav");
	iChanged++;
}
/*****************************************************************************/
void RunLevel (int iLevel)
/*****************************************************************************/
{
	int iFd;
	char sToWrite[MAX_TOWRITE + 2];
	SDL_Thread *princethread;

	if (((iLevel != 15) && (iLevel != 0) && (iEditPoP == 1)) ||
		(iEditPoP == 2))
	{
		/*** Create batch file. ***/
		if (iEditPoP == 1)
		{
			if (iUsesNative == 0)
			{
				iFd = open (BATCH_FILE, O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
			} else {
#if defined WIN32 || _WIN32 || WIN64 || _WIN64
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
#else
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0700);
#endif
			}
		} else {
			iFd = open (BATCH_FILE_POP2, O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
		}
		if (iFd == -1)
		{
			printf ("[FAILED] Could not create batch file: %s!\n",
				strerror (errno));
			exit (EXIT_ERROR);
		}
		if (iEditPoP == 1)
		{
			if (iUsesNative == 0)
			{
				snprintf (sToWrite, MAX_TOWRITE, "PRINCE %s %i\n", sCheat1, iLevel);
			} else {
				if (strcmp (sNativeFile[1], "") == 0)
				{
					printf ("[ WARN ] Native EXE is available, but not for your OS?\n");
					snprintf (sNativeFile[1], MAX_FILE, "%s", "prince"); /*** Fallb. ***/
				}
				snprintf (sToWrite, MAX_TOWRITE, "%s%s %s %i\n",
					HERE, sNativeFile[1], sCheat1, iLevel);
			}
		} else {
			if (iLevel <= 14)
			{
				snprintf (sToWrite, MAX_TOWRITE, "PRINCE %s level%i\n",
					sCheat2, iLevel);
			} else {
				snprintf (sToWrite, MAX_TOWRITE, "PRINCE gameplay %s level%i\n",
					sCheat2, iLevel - 14);
			}
		}
		write (iFd, sToWrite, strlen (sToWrite));
		close (iFd);
		princethread = SDL_CreateThread (StartGame, "StartGame", NULL);
		if (princethread == NULL)
		{
			printf ("[FAILED] Could not create thread!\n");
			exit (EXIT_ERROR);
		}
	}

	if (iEditPoP == 3)
	{
		ModifyForZSNES (iLevel);

		princethread = SDL_CreateThread (StartGame, "StartGame", NULL);
		if (princethread == NULL)
		{
			printf ("[FAILED] Could not create thread!\n");
			exit (EXIT_ERROR);
		}
	}
}
/*****************************************************************************/
void RunLevelS (int iLevel)
/*****************************************************************************/
{
	int iFd;
	char sToWrite[MAX_TOWRITE + 2];
	SDL_Thread *princethread;
	char sMore1[MAX_DATA + 2];
	char sMore2[MAX_DATA + 2];
	char sMore[MAX_DATA + 2];

#if defined WIN32 || _WIN32 || WIN64 || _WIN64
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
#else
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0700);
#endif

	if (iFd == -1)
	{
		printf ("[FAILED] Could not create batch file: %s!\n",
			strerror (errno));
		exit (EXIT_ERROR);
	}

	if (strcmp (sNativeFile[2], "") == 0)
	{
		printf ("[ WARN ] SDLPoP is available, but not for your OS?\n");
		snprintf (sNativeFile[2], MAX_FILE, "%s", "prince"); /*** Fallback. ***/
	}

	/*** sMore ***/
	snprintf (sMore1, MAX_DATA, "%s", "");
	if (iDebug == 1)
		{ snprintf (sMore1, MAX_DATA, "%s", " debug"); }
	snprintf (sMore2, MAX_DATA, "%s", "");
	if (iNoAudio == 1)
		{ snprintf (sMore2, MAX_DATA, "%s", " mute"); }
	snprintf (sMore, MAX_DATA, "%s%s", sMore1, sMore2);

	snprintf (sToWrite, MAX_TOWRITE, "..%s%s%s%s %s %i\n",
		SLASH, SDLPOP_DIR, sNativeFile[2], sMore, sCheat1, iLevel);
	write (iFd, sToWrite, strlen (sToWrite));

	close (iFd);
	princethread = SDL_CreateThread (StartGameS, "StartGameS", NULL);
	if (princethread == NULL)
	{
		printf ("[FAILED] Could not create thread!\n");
		exit (EXIT_ERROR);
	}
}
/*****************************************************************************/
void RunLevelM (int iLevel)
/*****************************************************************************/
{
	int iFd;
	char sToWrite[MAX_TOWRITE + 2];
	SDL_Thread *princethread;
	char sMore1[MAX_DATA + 2];
	char sMore2[MAX_DATA + 2];
	char sMore[MAX_DATA + 2];

	if ((iLevel != 15) && (iLevel != 0))
	{
#if defined WIN32 || _WIN32 || WIN64 || _WIN64
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
#else
iFd = open (POP1_DIR BATCH_FILE_NATIVE,
	O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0700);
#endif

		if (iFd == -1)
		{
			printf ("[FAILED] Could not create batch file: %s!\n",
				strerror (errno));
			exit (EXIT_ERROR);
		}

		/*** Workaround. ***/
		snprintf (sToWrite, MAX_TOWRITE, "%s %s ..%s%s\n",
			COPY, "LEVELS.DAT", SLASH, MININIM_DIR);
		write (iFd, sToWrite, strlen (sToWrite));

		if (strcmp (sNativeFile[3], "") == 0)
		{
			printf ("[ WARN ] MININIM is available, but not for your OS?\n");
			snprintf (sNativeFile[3], MAX_FILE, "%s", "mininim"); /*** Fallback. ***/
		}

		/*** sMore ***/
		snprintf (sMore1, MAX_DATA, "%s", "");
		if (iDebug == 1)
			{ snprintf (sMore1, MAX_DATA, "%s", " --immortal-mode=true"); }
		snprintf (sMore2, MAX_DATA, "%s", "");
		if (iNoAudio == 1)
			{ snprintf (sMore2, MAX_DATA, "%s", " --sound=false"); }
		snprintf (sMore, MAX_DATA, "%s%s", sMore1, sMore2);

		snprintf (sToWrite, MAX_TOWRITE, "..%s%s%s%s %s %i\n",
			SLASH, MININIM_DIR, sNativeFile[3], sMore, sCheat1, iLevel);
		write (iFd, sToWrite, strlen (sToWrite));

		close (iFd);
		princethread = SDL_CreateThread (StartGameM, "StartGameM", NULL);
		if (princethread == NULL)
		{
			printf ("[FAILED] Could not create thread!\n");
			exit (EXIT_ERROR);
		}
	}
}
/*****************************************************************************/
void EventRoom (int iRoom)
/*****************************************************************************/
{
	char sBinarySDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sBinaryFDoors[9 + 2]; /*** 8 chars, plus \0 ***/
	char sTempBinary[9 + 2]; /*** 8 chars, plus \0 ***/

	if (iEditPoP == 3) { iRoom--; }

	/* This part is kind of complicated. Only some bits have
	 * to be changed, so we first convert the event to bits,
	 * change some of them, and then convert all of them back.
	 */
	GetAsEightBits (sFirstDoorEvents[iChangeEvent],
		sBinaryFDoors);
	GetAsEightBits (sSecondDoorEvents[iChangeEvent],
		sBinarySDoors);
	GetAsEightBits (iRoom, sTempBinary);
	sBinarySDoors[0] = sTempBinary[3];
	sBinarySDoors[1] = sTempBinary[4];
	sBinarySDoors[2] = sTempBinary[5];
	sBinarySDoors[3] = '0';
	sBinarySDoors[4] = '0';
	sBinarySDoors[5] = '0';
	sBinarySDoors[6] = '0';
	sBinarySDoors[7] = '0';
	sBinaryFDoors[1] = sTempBinary[6];
	sBinaryFDoors[2] = sTempBinary[7];
	sFirstDoorEvents[iChangeEvent] =
		BitsToInt (sBinaryFDoors);
	sSecondDoorEvents[iChangeEvent] =
		BitsToInt (sBinarySDoors);
	PlaySound ("wav/check_box.wav");
	iChanged++;
}
/*****************************************************************************/
void RemoveOldRoom (void)
/*****************************************************************************/
{
	iRoomArray[iMovingOldX][iMovingOldY] = 0;
	int iNoRoom;

	if (iEditPoP != 3) { iNoRoom = 0; } else { iNoRoom = 255; }

	/* Change the links of the rooms around
	 * the removed room.
	 */

	/*** left of removed ***/
	if ((iMovingOldX >= 2) && (iMovingOldX <= 24))
	{
		if (iRoomArray[iMovingOldX - 1][iMovingOldY] != 0)
		{
			iRoomConnections[iRoomArray[iMovingOldX - 1]
				[iMovingOldY]][2] = iNoRoom; /*** remove right ***/
		}
	}

	/*** right of removed ***/
	if ((iMovingOldX >= 1) && (iMovingOldX <= 23))
	{
		if (iRoomArray[iMovingOldX + 1][iMovingOldY] != 0)
		{
			iRoomConnections[iRoomArray[iMovingOldX + 1]
				[iMovingOldY]][1] = iNoRoom; /*** remove left ***/
		}
	}

	/*** above removed ***/
	if ((iMovingOldY >= 2) && (iMovingOldY <= 24))
	{
		if (iRoomArray[iMovingOldX][iMovingOldY - 1] != 0)
		{
			iRoomConnections[iRoomArray[iMovingOldX]
				[iMovingOldY - 1]][4] = iNoRoom; /*** remove below ***/
		}
	}

	/*** below removed ***/
	if ((iMovingOldY >= 1) && (iMovingOldY <= 23))
	{
		if (iRoomArray[iMovingOldX][iMovingOldY + 1] != 0)
		{
			iRoomConnections[iRoomArray[iMovingOldX]
				[iMovingOldY + 1]][3] = iNoRoom; /*** remove above ***/
		}
	}
}
/*****************************************************************************/
void AddNewRoom (int iX, int iY, int iRoom)
/*****************************************************************************/
{
	iRoomArray[iX][iY] = iRoom;
	int iNoRoom;

	if (iEditPoP != 3) { iNoRoom = 0; } else { iNoRoom = 255; }

	/* Change the links of the rooms around
	 * the new room and the room itself.
	 */

	iRoomConnections[iRoom][1] = iNoRoom;
	iRoomConnections[iRoom][2] = iNoRoom;
	iRoomConnections[iRoom][3] = iNoRoom;
	iRoomConnections[iRoom][4] = iNoRoom;
	if ((iX >= 2) && (iX <= 24)) /*** left of added ***/
	{
		if (iRoomArray[iX - 1][iY] != 0)
		{
			iRoomConnections[iRoomArray[iX - 1]
				[iY]][2] = iRoom; /*** add room right ***/
			iRoomConnections[iRoom][1] = iRoomArray[iX - 1][iY];
		}
	}
	if ((iX >= 1) && (iX <= 23)) /*** right of added ***/
	{
		if (iRoomArray[iX + 1][iY] != 0)
		{
			iRoomConnections[iRoomArray[iX + 1]
				[iY]][1] = iRoom; /*** add room left ***/
			iRoomConnections[iRoom][2] = iRoomArray[iX + 1][iY];
		}
	}
	if ((iY >= 2) && (iY <= 24)) /*** above added ***/
	{
		if (iRoomArray[iX][iY - 1] != 0)
		{
			iRoomConnections[iRoomArray[iX]
				[iY - 1]][4] = iRoom; /*** add room below ***/
			iRoomConnections[iRoom][3] = iRoomArray[iX][iY - 1];
		}
	}
	if ((iY >= 1) && (iY <= 23)) /*** below added ***/
	{
		if (iRoomArray[iX][iY + 1] != 0)
		{
			iRoomConnections[iRoomArray[iX]
				[iY + 1]][3] = iRoom; /*** add room above ***/
			iRoomConnections[iRoom][4] = iRoomArray[iX][iY + 1];
		}
	}
	PlaySound ("wav/move_room.wav");
}
/*****************************************************************************/
void InitRooms (void)
/*****************************************************************************/
{
	int iTemp;
	int iTemp2;

	for (iTemp = 0; iTemp <= iRooms + 1; iTemp++) /*** x ***/
	{
		for (iTemp2 = 0; iTemp2 <= iRooms; iTemp2++) /*** y ***/
		{
			iRoomArray[iTemp][iTemp2] = 0;
		}
	}
}
/*****************************************************************************/
int StartGame (void *unused)
/*****************************************************************************/
{
	char sSystem[200 + 2];
	char sMute[200 + 2];

	if (unused != NULL) { } /*** To prevent warnings. ***/

	PlaySound ("wav/playtest.wav");
	snprintf (sMute, 200, "%s", "");
	switch (iEditPoP)
	{
		case 1:
			if (iUsesNative == 0)
			{
				if (iNoAudio == 1)
					{ snprintf (sMute, 200, "%s", " -c \"mixer master 0\""); }
				snprintf (sSystem, 200, "dosbox%s %s -noconsole > %s", sMute,
					BATCH_FILE, DEVNULL);
				if (system (sSystem) == -1)
					{ printf ("[FAILED] Could not execute PoP1 batch file!\n"); }
			} else {
				if (system ("cd " POP1_DIR " && "
					HERE BATCH_FILE_NATIVE " > " DEVNULL) == -1)
					{ printf ("[FAILED] Could not execute native EXE!\n"); }
			}
			break;
		case 2:
			if (iNoAudio == 1)
				{ snprintf (sMute, 200, "%s", " -c \"mixer master 0\""); }
			snprintf (sSystem, 200, "dosbox%s %s -noconsole > %s", sMute,
				BATCH_FILE_POP2, DEVNULL);
			if (system (sSystem) == -1)
				{ printf ("[FAILED] Could not execute PoP2 batch file!\n"); }
			break;
		case 3:
			if (iNoAudio == 1)
				{ snprintf (sMute, 200, "%s", " -ds"); }
					else { snprintf (sMute, 200, "%s", " -s"); }
			snprintf (sSystem, 200, "zsnes%s \"%s\" > %s", sMute,
				sSNESFile, DEVNULL);
			if (system (sSystem) == -1)
				{ printf ("[FAILED] Could not execute ZSNES!\n"); }
			if (iModified == 1) { ModifyBack(); }
			break;
	}
	return (EXIT_NORMAL);
}
/*****************************************************************************/
int StartGameS (void *unused)
/*****************************************************************************/
{
	if (unused != NULL) { } /*** To prevent warnings. ***/

	PlaySound ("wav/playtest.wav");
	if (system ("cd " POP1_DIR " && "
		HERE BATCH_FILE_NATIVE " > " DEVNULL) == -1)
		{ printf ("[FAILED] Could not execute SDLPoP!\n"); }

	return (EXIT_NORMAL);
}
/*****************************************************************************/
int StartGameM (void *unused)
/*****************************************************************************/
{
	if (unused != NULL) { } /*** To prevent warnings. ***/

	PlaySound ("wav/playtest.wav");
	if (system ("cd " POP1_DIR " && "
		HERE BATCH_FILE_NATIVE " > " DEVNULL) == -1)
		{ printf ("[FAILED] Could not execute MININIM!\n"); }

	return (EXIT_NORMAL);
}
/*****************************************************************************/
int UPack (void *unused)
/*****************************************************************************/
{
	if (unused != NULL) { } /*** To prevent warnings. ***/

	if (system ("dosbox upack.bat -noconsole > " DEVNULL) == -1)
		{ printf ("[FAILED] Could not execute upack batch file!\n"); }
	return (EXIT_NORMAL);
}
/*****************************************************************************/
void Quit (void)
/*****************************************************************************/
{
	int iYesNo;

	if ((iChanged != 0) && (iNoSave == 0))
		{ iYesNo = InitPopUpYN (1); } else { iYesNo = 1; }
	if (iYesNo != 0)
	{
		if (iYesNo == 2) { CallSave (0); }
		if (iModified == 1) { ModifyBack(); }
		TTF_CloseFont (font1);
		TTF_CloseFont (font2);
		TTF_CloseFont (font3);
		TTF_CloseFont (font4);
		TTF_CloseFont (font5);
		TTF_Quit();
		SDL_Quit();
		exit (EXIT_NORMAL);
	}
}
/*****************************************************************************/
void ShowScreen (int iScreenS, SDL_Renderer *screen)
/*****************************************************************************/
{
	char sText[MAX_TEXT + 2];
	char sTemp[MAX_TEXT + 2];
	char sGamePlay[MAX_TEXT + 2];
	char sTraining[MAX_TEXT + 2];
	char sLevelType[MAX_TEXT + 2];
	int iTemp;
	int iLoc;
	int iUnusedRooms;
	int iRoom;
	int iSide;
	int iTargetRoom;
	int iTargetTile;
	int iGuard;
	int iGWidth, iGHeight;
	int iEWidth, iEHeight;
	int iThingOrRoom;
	int iEventUnused;
	int iHor, iVer;

	/*** Used for looping. ***/
	int iLoopPlayer;

	/*** black background ***/
	ShowImage (-4, (int[]){1, 0, 0, 0}, screen, 31, 0, 0, 692, 455);

	if (iScreenS == 1)
	{
		/*** PoP2 backgrounds ***/
		if (iEditPoP == 2)
		{
			if (iEXEEnvPoP2 == 0x05) /*** rooftops ***/
			{
				if (iCurRoom == 1)
					ShowImage (-14, (int[]){1, 1, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 2)
					ShowImage (-14, (int[]){1, 2, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 3)
					ShowImage (-14, (int[]){1, 3, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 4)
					ShowImage (-14, (int[]){1, 4, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 5)
					ShowImage (-14, (int[]){1, 5, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 10)
					ShowImage (-14, (int[]){1, 10, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 11)
					ShowImage (-14, (int[]){1, 11, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 12)
					ShowImage (-14, (int[]){1, 12, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 15)
					ShowImage (-14, (int[]){1, 15, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 16)
					ShowImage (-14, (int[]){1, 16, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 19)
					ShowImage (-14, (int[]){1, 19, 0, 0}, screen, 42, 0, 0, 642, 380);
			}
			if (iEXEEnvPoP2 == 0x01) /*** desert ***/
			{
				if (iCurRoom == 1)
					ShowImage (-14, (int[]){2, 1, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 2)
					ShowImage (-14, (int[]){2, 2, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 3)
					ShowImage (-14, (int[]){2, 3, 0, 0}, screen, 42, 0, 0, 642, 380);
			}
			if (iEXEEnvPoP2 == 0x06) /*** final ***/
			{
				if (iCurRoom == 1)
					ShowImage (-14, (int[]){14, 1, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 2)
					ShowImage (-14, (int[]){14, 2, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 3)
					ShowImage (-14, (int[]){14, 3, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 4)
					ShowImage (-14, (int[]){14, 4, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 5)
					ShowImage (-14, (int[]){14, 5, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 6)
					ShowImage (-14, (int[]){14, 6, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 7)
					ShowImage (-14, (int[]){14, 7, 0, 0}, screen, 42, 0, 0, 642, 380);
				if (iCurRoom == 8)
					ShowImage (-14, (int[]){14, 8, 0, 0}, screen, 42, 0, 0, 642, 380);
			}
			if (((luLevelNr == 6) || (luLevelNr == 20)) && (iCurRoom == 27))
				ShowImage (-14, (int[]){6, 27, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 2))
				ShowImage (-14, (int[]){9, 2, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 11))
				ShowImage (-14, (int[]){9, 11, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 12))
				ShowImage (-14, (int[]){9, 12, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 13))
				ShowImage (-14, (int[]){9, 13, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 14))
				ShowImage (-14, (int[]){9, 14, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 15))
				ShowImage (-14, (int[]){9, 15, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 9) || (luLevelNr == 23)) && (iCurRoom == 16))
				ShowImage (-14, (int[]){9, 16, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 13) || (luLevelNr == 27)) && (iCurRoom == 4))
				ShowImage (-14, (int[]){13, 4, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (((luLevelNr == 8) || (luLevelNr == 22)) && (iCurRoom == 9))
				ShowImage (-14, (int[]){8, 9, 0, 0}, screen, 42, 0, 0, 642, 380);
		}

		if ((cCurType == 'r') || (cCurType == 't') || (iEditPoP == 3))
			{ Backgrounds(); }

		/*** under this room ***/
		if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
			(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
			(iRoomConnections[iCurRoom][4] != 255)) /*** SNES ***/
		{
			for (iTemp = 1; iTemp <= 10; iTemp++)
			{
				if (iEditPoP != 3)
					{ iThingOrRoom = iThingA[iRoomConnections[iCurRoom][4]][iTemp - 1]; }
						else { iThingOrRoom = iCurRoom; }
				ShowImage (iThingOrRoom, (int[]){
					iModifierA[iRoomConnections[iCurRoom][4]][iTemp - 1][1],
					iModifierA[iRoomConnections[iCurRoom][4]][iTemp - 1][2],
					iModifierA[iRoomConnections[iCurRoom][4]][iTemp - 1][3],
					iModifierA[iRoomConnections[iCurRoom][4]][iTemp - 1][4]},
					screen, -4 - iTemp, 0, 0, iTileW, iTileH);
				/*** ShowImage (-11, (int[]){0, 0, 0, 0}, screen,
					-4 - iTemp, 0, 0, iTileW, iTileH); ***/
			}
		}

		for (iTemp = 1; iTemp <= 30; iTemp++)
		{
			/*** locations ***/
			iLoc = 0; /*** To prevent warnings. ***/
			if ((iTemp >= 1) && (iTemp <= 10)) { iLoc = 20 + iTemp; }
			if ((iTemp >= 11) && (iTemp <= 20)) { iLoc = iTemp; }
			if ((iTemp >= 21) && (iTemp <= 30)) { iLoc = -20 + iTemp; }
			if (iEditPoP != 3)
				{ iThingOrRoom = iThingA[iCurRoom][iLoc - 1]; }
					else { iThingOrRoom = iCurRoom; }
			ShowImage (iThingOrRoom, (int[]){
				iModifierA[iCurRoom][iLoc - 1][1],
				iModifierA[iCurRoom][iLoc - 1][2],
				iModifierA[iCurRoom][iLoc - 1][3],
				iModifierA[iCurRoom][iLoc - 1][4]},
				screen, iLoc, 0, 0, iTileW, iTileH);
			/*** kid ***/
			if (iEditPoP == 1)
			{
				for (iLoopPlayer = 1; iLoopPlayer <= iNrPlayers; iLoopPlayer++)
				{
					if ((iCurRoom == arKidRoom[iLoopPlayer]) &&
						(iLoc == arKidPos[iLoopPlayer]))
					{
						ShowImage (-8, (int[]){1, iLoopPlayer, 0, 0},
							screen, iLoc, 0, 0, 22, 84);

						/*** player number (Px) ***/
						if (iNrPlayers != 1)
						{
							snprintf (sText, MAX_TEXT, "P%i", iLoopPlayer);
							GetHorVer (iLoc, &iHor, &iVer);
							DisplayTextLine (iHor + 7, iVer + 145 - (FONT_SIZE_11 *
								iLoopPlayer), sText, font2, color_bl, color_wh, 0);
						}
					}
				}
			}
			if (iEditPoP == 2)
			{
				if ((iCurRoom == arKidRoom[1]) && (iLoc == arKidPos[1]))
				{
					ShowImage (-8, (int[]){1, 1, 0, 0}, screen, iLoc, 0, 0, 24, 84);
				}
			}
			if (iEditPoP == 3)
			{
				if ((iCurRoom == arKidRoom[1]) && (iLoc == arKidPos[1]))
				{
					ShowImage (-8, (int[]){1, 1, 0, 0}, screen, iLoc, 0, 0, 20, 86);
				}
			}
			if (iEditPoP == 1)
			{
				/*** PoP1 guard ***/
				if (sGuardLocations[iCurRoom - 1] + 1 == iLoc)
				{
					switch (iCurGuard)
					{
						case 0: iEWidth = 70; iEHeight = 86; break; /*** guard ***/
						case 1: iEWidth = 70; iEHeight = 86; break; /*** fat ***/
						case 2: iEWidth = 90; iEHeight = 74; break; /*** skeleton ***/
						case 3: iEWidth = 56; iEHeight = 94; break; /*** jaffar ***/
						case 4: iEWidth = 92; iEHeight = 76; break; /*** mirror ***/
						default: iEWidth = 70; iEHeight = 86; break; /*** Fallback. ***/
					}
					ShowImage (-8, (int[]){2, 0, 0, 0}, screen,
						iLoc, 0, 0, iEWidth, iEHeight);
				}
			}
			if (iEditPoP == 2)
			{
				/*** PoP2 guards ***/
				for (iGuard = 0; iGuard < iStaticGuards_Amount[iCurRoom - 1]; iGuard++)
				{
					switch (WhichStaticGuard (iGuard))
					{
						case 1: iGWidth = 68; iGHeight = 86; break;
						case 2: iGWidth = 68; iGHeight = 86; break;
						case 3: iGWidth = 68; iGHeight = 86; break;
						case 4: iGWidth = 76; iGHeight = 44; break;
						case 5: iGWidth = 84; iGHeight = 74; break;
						case 6: iGWidth = 76; iGHeight = 18; break;
						case 7: iGWidth = 78; iGHeight = 44; break;
						case 8: iGWidth = 30; iGHeight = 52; break;
						case 9: iGWidth = 30; iGHeight = 36; break;
						case 10: iGWidth = 98; iGHeight = 20; break;
						case 11: iGWidth = 76; iGHeight = 86; break;
						case 12: iGWidth = 46; iGHeight = 12; break;
						case 13: iGWidth = 22; iGHeight = 82; break;
						default: iGWidth = 68; iGHeight = 86; break; /*** Fallback. ***/
					}
					ShowImage (-8, (int[]){4, iGuard, 0, 0},
						screen, 117, 0, 0, iGWidth, iGHeight);
				}
			}
			if (iEditPoP == 3)
			{
				/*** PoP1 for SNES guard ***/
				if (sGuardLocations[iCurRoom - 1] + 1 == iLoc)
				{
					switch (sGuardTypes[iCurRoom - 1])
					{
						case 0x02: iGWidth = 74; iGHeight = 88; break; /*** dead pink ***/
						case 0x03: iGWidth = 86; iGHeight = 74; break; /*** silver s ***/
						case 0x04: iGWidth = 86; iGHeight = 74; break; /*** bronze s ***/
						case 0x05: iGWidth = 90; iGHeight = 72; break; /*** golden s ***/
						case 0x06: iGWidth = 78; iGHeight = 94; break; /*** female ***/
						case 0x07: iGWidth = 80; iGHeight = 88; break; /*** fat ***/
						case 0x08: iGWidth = 20; iGHeight = 86; break; /*** shadow ***/
						case 0x09: iGWidth = 74; iGHeight = 88; break; /*** green g ***/
						case 0x0a: iGWidth = 74; iGHeight = 88; break; /*** greenish ***/
						case 0x0b: iGWidth = 74; iGHeight = 88; break; /*** blue g ***/
						case 0x0c: iGWidth = 74; iGHeight = 88; break; /*** red g ***/
						case 0x0d: iGWidth = 74; iGHeight = 88; break; /*** purple g ***/
						case 0x0e: iGWidth = 74; iGHeight = 88; break; /*** blue faced ***/
						case 0x0f: iGWidth = 70; iGHeight = 102; break; /*** red k ***/
						case 0x10: iGWidth = 70; iGHeight = 102; break; /*** blue k ***/
						case 0x11: iGWidth = 80; iGHeight = 106; break; /*** sinbad k ***/
						case 0x12: iGWidth = 70; iGHeight = 98; break; /*** jaffar ***/
						case 0x13: iGWidth = 74; iGHeight = 88; break; /*** dead white ***/
						default: iGWidth = 74; iGHeight = 88; break; /*** Fallback. ***/
					}
					ShowImage (-8, (int[]){5, 0, 0, 0}, screen,
						iLoc, 0, 0, iGWidth, iGHeight);
				}
			}

			if (sMusic[((iCurRoom - 1) * 30) + iLoc - 1] == 1)
			{
				ShowImage (-17, (int[]){0, 0, 0, 0}, screen,
					iLoc, 0, 0, 38, 151);
			}
		}

		/*** foreground elements ***/
		if (iEditPoP == 2)
		{
			if (((luLevelNr == 10) || (luLevelNr == 24)) && (iCurRoom == 22))
			{ /*** horse ***/
				ShowImage (-16, (int[]){1, 0, 0, 0}, screen, 118, 0, 0, 154, 168);
			}
			if (((luLevelNr == 6) || (luLevelNr == 20)) && (iCurRoom == 27))
			{ /*** level 6 arrow ***/
				ShowImage (-16, (int[]){2, 0, 0, 0}, screen, 118, 0, 0, 52, 41);
			}
		}
		if (cCurType == 'o')
		{ /*** invisible ***/
			ShowImage (-16, (int[]){3, 0, 0, 0}, screen, 118, 0, 0, 245, 16);
		}
		if (iEditPoP == 3)
		{
			/*** curtains ***/
			ShowImage (-16, (int[]){4, 0, 0, 0}, screen, 145, 0, 0, 81, 380);
			ShowImage (-16, (int[]){5, 0, 0, 0}, screen, 146, 0, 0, 81, 380);
			/*** gates ***/
			if (luLevelNr == 15)
				{ ShowImage (-16, (int[]){6, 0, 0, 0}, screen, 118, 0, 0, 245, 16); }
			/*** exit ***/
			if ((luLevelNr == 9) && (iCurRoom == 12)) { ShowArrow ("exit", 'd'); }
			if ((luLevelNr == 15) && (iCurRoom == 19)) { ShowArrow ("exit", 'l'); }
			if ((luLevelNr == 16) && (iCurRoom == 22)) { ShowArrow ("exit", 'l'); }
			if ((luLevelNr == 17) && (iCurRoom == 4)) { ShowArrow ("exit", 'l'); }
			if ((luLevelNr == 20) && (iCurRoom == 5)) { ShowArrow ("exit", 'l'); }
			/*** checkp ***/
			if ((luLevelNr == 3) && (iCurRoom == 5)) { ShowArrow ("checkp", 'l'); }
			if ((luLevelNr == 6) && (iCurRoom == 16)) { ShowArrow ("checkp", 'r'); }
			if ((luLevelNr == 9) && (iCurRoom == 20)) { ShowArrow ("checkp", 'l'); }
			if ((luLevelNr == 16) && (iCurRoom == 18)) { ShowArrow ("checkp", 'l'); }
			if ((luLevelNr == 18) && (iCurRoom == 5)) { ShowArrow ("checkp", 'l'); }
			if ((luLevelNr == 19) && (iCurRoom == 11)) { ShowArrow ("checkp", 'l'); }
		}

		/*** incoming arrows ***/
		if (iDynamicGuards_Sets[iCurRoom - 1] > 0)
		{
			ShowImage (-8, (int[]){3, 0, 0, 0}, screen, 116, 0, 0, 13, 26);
		}
		if (iDynamicGuards_Sets[iCurRoom - 1] > 1)
		{
			ShowImage (-8, (int[]){3, 1, 0, 0}, screen, 116, 0, 0, 13, 26);
		}
	}
	if (iScreenS == 2) /*** R ***/
	{
		if (iBrokenRoomLinks == 0)
		{
			InitRooms();
			/*** room links ***/
			ShowImage (-6, (int[]){0, 0, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (iEditPoP == 2)
			{
				ShowImage (-6, (int[]){35, 0, 0, 0}, screen, 128, 0, 0, 112, 131);
			}
			/*** Map window ***/
			if ((iEditPoP == 1) || (iEditPoP == 3))
			{
				if (iMapOpen == 0)
				{
					if (iDownAt == 12)
					{
						ShowImageBasic (imgmapon_1, 599, 63, "imgmapon_1",
							screen, iScale, 1);
					} else {
						ShowImageBasic (imgmapon_0, 599, 63, "imgmapon_0",
							screen, iScale, 1);
					}
				} else {
					ShowImageBasic (imgmapoff, 599, 63, "imgmapoff", screen, iScale, 1);
				}
			} else {
				ShowImageBasic (imggrid, 597, 61, "imggrid", screen, iScale, 1);
			}
			/*** rooms broken on ***/
			ShowImage (-2, (int[]){8, 0, 0, 0}, screen, 87, 0, 0, 25, 25);
			WhereToStart();
			for (iTemp = 1; iTemp <= iRooms; iTemp++)
			{
				iDone[iTemp] = 0;
			}
			ShowRooms (arKidRoom[1], iStartRoomsX, iStartRoomsY, 1);
			iUnusedRooms = 0;
			for (iTemp = 1; iTemp <= iRooms; iTemp++)
			{
				if (iDone[iTemp] != 1)
				{
					iUnusedRooms++;
					ShowRooms (iTemp, 25, iUnusedRooms, 0);
				}
			}
			if (iMovingRoom != 0)
			{
				ShowImage (-6, (int[]){iMovingRoom, 0, 0, 0}, screen,
					83, 0, 0, 14, 14);
				if (iCurRoom == iMovingRoom)
				{
					ShowImage (-7, (int[]){0, 0, 0, 0}, screen, 83, 0, 0, 14, 14);
				}
				if (arKidRoom[1] == iMovingRoom)
				{
					ShowImage (-7, (int[]){1, 0, 0, 0}, screen, 83, 0, 0, 14, 14);
				}
				ShowImage (-7, (int[]){2, 0, 0, 0}, screen, 83, 0, 0, 14, 14);
				ShowRooms (-1, iMovingNewX, iMovingNewY, 0);
			}
		} else {
			/*** broken room links ***/
			ShowImage (-6, (int[]){33, 0, 0, 0}, screen, 42, 0, 0, 642, 380);
			if (iEditPoP == 2)
			{
				ShowImage (-6, (int[]){34, 0, 0, 0}, screen, 127, 0, 0, 378, 139);
			}
			if (iEditPoP == 3)
			{
				/*** outdoor (no ceiling) ***/
				ShowImage (-6, (int[]){36, 0, 0, 0}, screen, 186, 0, 0, 155, 16);
			}
			for (iRoom = 1; iRoom <= iRooms; iRoom++)
			{
				/*** green stripes ***/
				if (iCurRoom == iRoom)
				{
					ShowImage (-7, (int[]){0, 0, 0, 0}, screen,
						BrokenRoomChange (iRoom, 0), 0, 0, 14, 14);
				}

				/*** blue border ***/
				if (arKidRoom[1] == iRoom)
				{
					ShowImage (-7, (int[]){1, 0, 0, 0}, screen,
						BrokenRoomChange (iRoom, 0), 0, 0, 14, 14);
				}

				for (iSide = 1; iSide <= 4; iSide++)
				{
					if ((iRoomConnections[iRoom][iSide] != 0) && /*** DOS ***/
						(iRoomConnections[iRoom][iSide] != 254) && /*** SNES ***/
						(iRoomConnections[iRoom][iSide] != 255)) /*** SNES ***/
					{
						ShowImage (-6, (int[]){iRoomConnections[iRoom][iSide], 0, 0, 0},
							screen, BrokenRoomChange (iRoom, iSide), 0, 0, 14, 14);

						/*** blue square ***/
						if (iRoomConnectionsBroken[iRoom][iSide] == 1)
						{
							ShowImage (-7, (int[]){4, 0, 0, 0}, screen,
								BrokenRoomChange (iRoom, iSide), 0, 0, 14, 14);
						}
					}

					/*** yellow square ***/
					if (iRoomConnections[iRoom][iSide] == 254) /*** SNES ***/
					{
						ShowImage (-7, (int[]){5, 0, 0, 0}, screen,
							BrokenRoomChange (iRoom, iSide), 0, 0, 14, 14);
					}

					/*** red stripes ***/
					if ((iChangingBrokenRoom == iRoom) && (iChangingBrokenSide == iSide))
					{
						ShowImage (-7, (int[]){2, 0, 0, 0}, screen,
							BrokenRoomChange (iRoom, iSide), 0, 0, 14, 14);
					}
				}
			}
		}
	}
	if (iScreenS == 3) /*** E ***/
	{
		iEventUnused = 0;

		/*** events screen ***/
		ShowImage (-10, (int[]){0, 0, 0, 0}, screen, 42, 0, 0, 642, 380);

		/*** current event number ***/
		CenterNumber (screen, iChangeEvent + 1, 371, 60, color_wh, color_bl, 0);

		/*** sel event, room ***/
		if (((EventInfo (iChangeEvent, 1) >= 1) &&
			(EventInfo (iChangeEvent, 1) <= 24)) || (iEditPoP == 2))
		{
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 49, 0, 0, 14, 14);
		} else { iEventUnused = 1; }

		/*** sel event, location ***/
		if (((EventInfo (iChangeEvent, 2) >= 1) &&
			(EventInfo (iChangeEvent, 2) <= 30)) || (iEditPoP == 2))
		{
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 50, 0, 0, 14, 14);
		} else { iEventUnused = 1; }

		/*** sel event, next ***/
		if (iEditPoP != 2)
		{
			if ((EventInfo (iChangeEvent, 3) == 0) ||
				(EventInfo (iChangeEvent, 3) == 1))
			{
				ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 51, 0, 0, 14, 14);
			}
		}

		/*** Show target. ***/
		if (iEditPoP != 2)
		{
			iTargetRoom = EventInfo (iChangeEvent, 1);
			iTargetTile = EventInfo (iChangeEvent, 2) - 1;
		} else {
			iTargetRoom = iPoP2DoorRoom[iChangeEvent];
			iTargetTile = iPoP2DoorLocation[iChangeEvent];
		}
		if (((cCurType == 'r') || (cCurType == 't')) && (iEventUnused == 0))
		{
			ShowBackground ((int[]){iModifierA[iTargetRoom][iTargetTile][1],
				iModifierA[iTargetRoom][iTargetTile][2],
				iModifierA[iTargetRoom][iTargetTile][3],
				iModifierA[iTargetRoom][iTargetTile][4]}, 101);
		}
		if ((iEditPoP == 3) && (iEventUnused == 0))
		{
			ShowBackground ((int[]){0, 0,
				iBackA[iTargetRoom][iTargetTile], 0}, 101);
		}
		if (iEditPoP != 3)
			{ iThingOrRoom = iThingA[iTargetRoom][iTargetTile]; }
				else { iThingOrRoom = 998; }
		if (iEventUnused == 0)
		{
			ShowImage (iThingOrRoom, (int[]){
				iModifierA[iTargetRoom][iTargetTile][1],
				iModifierA[iTargetRoom][iTargetTile][2],
				iModifierA[iTargetRoom][iTargetTile][3],
				iModifierA[iTargetRoom][iTargetTile][4]},
				screen, 92, 0, 0, iTileW, iTileH);
		} else {
			ShowImage (-10, (int[]){2, 0, 0, 0}, screen, 185, 0, 0, 136, 171);
		}
		if ((iEditPoP == 2) && (iEventUnused == 0))
		{
			if (sMusic[((iTargetRoom - 1) * 30) + iTargetTile] == 1)
			{
				ShowImage (-17, (int[]){0, 0, 0, 0}, screen,
					92, 0, 0, 38, 151);
			}
		}

		if (iEditPoP == 2)
		{
			/*** left ***/
			CenterNumber (screen, iPoP2DoorLeft[iChangeEvent] + 1, 347, 224,
				color_wh, color_bl, 0);

			/*** right ***/
			CenterNumber (screen, iPoP2DoorRight[iChangeEvent] + 1, 572, 224,
				color_wh, color_bl, 0);

			/*** edit left ***/
			if (iEditLeftOn == 1)
			{ /*** on ***/
				ShowImage (-12, (int[]){43, 1, 0, 0}, screen, 121, 0, 0, 85, 32);
			} else { /*** off ***/
				ShowImage (-12, (int[]){42, 1, 0, 0}, screen, 121, 0, 0, 85, 32);
			}

			/*** end left ***/
			if (iEndLeftOn == 1)
			{ /*** on ***/
				ShowImage (-12, (int[]){45, 2, 0, 0}, screen, 121, 0, 0, 85, 32);
			} else { /*** off ***/
				ShowImage (-12, (int[]){44, 2, 0, 0}, screen, 121, 0, 0, 85, 32);
			}

			/*** edit right ***/
			if (iEditRightOn == 1)
			{ /*** on ***/
				ShowImage (-12, (int[]){43, 3, 0, 0}, screen, 121, 0, 0, 85, 32);
			} else { /*** off ***/
				ShowImage (-12, (int[]){42, 3, 0, 0}, screen, 121, 0, 0, 85, 32);
			}

			/*** end right ***/
			if (iEndRightOn == 1)
			{ /*** on ***/
				ShowImage (-12, (int[]){45, 4, 0, 0}, screen, 121, 0, 0, 85, 32);
			} else { /*** off ***/
				ShowImage (-12, (int[]){44, 4, 0, 0}, screen, 121, 0, 0, 85, 32);
			}

			/*** checkpoints ***/
			CenterNumber (screen, iCheckPoints[0], 319, 301, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[1], 404, 301, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[2], 319, 325, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[3], 404, 325, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[4], 319, 349, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[5], 404, 349, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[6], 319, 373, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[7], 404, 373, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[8], 319, 397, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[9], 404, 397, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[10], 497, 325, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[11], 582, 325, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[12], 497, 349, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[13], 582, 349, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[14], 497, 373, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[15], 582, 373, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[16], 497, 397, color_wh, color_bl, 0);
			CenterNumber (screen, iCheckPoints[17], 582, 397, color_wh, color_bl, 0);
		}
	}

	if ((iRoomConnections[iCurRoom][1] != 0) && /*** DOS ***/
		(iRoomConnections[iCurRoom][1] != 254) && /*** SNES ***/
		(iRoomConnections[iCurRoom][1] != 255)) /*** SNES ***/
	{
		/*** left ***/
		ShowImage (-1, (int[]){1, 0, 0, 0}, screen, 32, 0, 0, 25, 380);
	} else {
		/*** no left ***/
		ShowImage (-1, (int[]){6, 0, 0, 0}, screen, 32, 0, 0, 25, 380);
	}
	if ((iRoomConnections[iCurRoom][2] != 0) && /*** DOS ***/
		(iRoomConnections[iCurRoom][2] != 254) && /*** SNES ***/
		(iRoomConnections[iCurRoom][2] != 255)) /*** SNES ***/
	{
		/*** right ***/
		ShowImage (-1, (int[]){2, 0, 0, 0}, screen, 33, 0, 0, 25, 380);
	} else {
		/*** no right ***/
		ShowImage (-1, (int[]){6, 0, 0, 0}, screen, 33, 0, 0, 25, 380);
	}
	if ((iRoomConnections[iCurRoom][3] != 0) && /*** DOS ***/
		(iRoomConnections[iCurRoom][3] != 254) && /*** SNES ***/
		(iRoomConnections[iCurRoom][3] != 255)) /*** SNES ***/
	{
		/*** up ***/
		ShowImage (-1, (int[]){3, 0, 0, 0}, screen, 34, 0, 0, 642, 25);
	} else {
		if (iScreenS != 1)
		{
			/*** no up ***/
			ShowImage (-1, (int[]){5, 0, 0, 0}, screen, 34, 0, 0, 642, 25);
		} else {
			/*** no up, with info ***/
			ShowImage (-1, (int[]){7, 0, 0, 0}, screen, 34, 0, 0, 642, 25);
		}
	}
	if ((iRoomConnections[iCurRoom][4] != 0) && /*** DOS ***/
		(iRoomConnections[iCurRoom][4] != 254) && /*** SNES ***/
		(iRoomConnections[iCurRoom][4] != 255)) /*** SNES ***/
	{
		/*** down ***/
		ShowImage (-1, (int[]){4, 0, 0, 0}, screen, 35, 0, 0, 642, 25);
	} else {
		/*** no down ***/
		ShowImage (-1, (int[]){5, 0, 0, 0}, screen, 35, 0, 0, 642, 25);
	}
	switch (iScreenS)
	{
		case 1:
			if (iBrokenRoomLinks == 1)
			{
				/*** rooms broken on ***/
				ShowImage (-2, (int[]){8, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			} else {
				/*** rooms on ***/
				ShowImage (-2, (int[]){1, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			}
			/*** events on ***/
			ShowImage (-2, (int[]){2, 0, 0, 0}, screen, 37, 0, 0, 25, 25);
			break;
		case 2:
			if (iBrokenRoomLinks == 1)
			{
				/*** rooms broken off ***/
				ShowImage (-2, (int[]){9, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			} else {
				/*** rooms off ***/
				ShowImage (-2, (int[]){6, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			}
			/*** events on ***/
			ShowImage (-2, (int[]){2, 0, 0, 0}, screen, 37, 0, 0, 25, 25);
			break;
		case 3:
			if (iBrokenRoomLinks == 1)
			{
				/*** rooms broken on ***/
				ShowImage (-2, (int[]){8, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			} else {
				/*** rooms on ***/
				ShowImage (-2, (int[]){1, 0, 0, 0}, screen, 36, 0, 0, 25, 25);
			}
			/*** events off ***/
			ShowImage (-2, (int[]){7, 0, 0, 0}, screen, 37, 0, 0, 25, 25);
			break;
	}
	if (iNoSave == 0)
	{
		if (iChanged != 0)
		{
			/*** save on ***/
			ShowImage (-2, (int[]){3, 0, 0, 0}, screen, 38, 0, 0, 25, 25);
		} else {
			/*** save off ***/
			ShowImage (-2, (int[]){5, 0, 0, 0}, screen, 38, 0, 0, 25, 25);
		}
	} else {
		/*** save off perm ***/
		ShowImage (-2, (int[]){10, 0, 0, 0}, screen, 38, 0, 0, 25, 25);
	}
	/*** quit ***/
	ShowImage (-2, (int[]){4, 0, 0, 0}, screen, 39, 0, 0, 25, 25);
	if ((int)luLevelNr != 1)
	{
		/*** previous on ***/
		ShowImage (-5, (int[]){1, 0, 0, 0}, screen, 31, 0, 0, 25, 25);
	} else {
		/*** previous off ***/
		ShowImage (-5, (int[]){4, 0, 0, 0}, screen, 31, 0, 0, 25, 25);
	}
	if (((iEditPoP == 1) && ((int)luLevelNr != 0)) ||
		((iEditPoP == 2) && ((int)luLevelNr != 28)) ||
		((iEditPoP == 3) && ((int)luLevelNr != 27)))
	{
		/*** next on ***/
		ShowImage (-5, (int[]){2, 0, 0, 0}, screen, 40, 0, 0, 25, 25);
	} else {
		/*** next off ***/
		ShowImage (-5, (int[]){5, 0, 0, 0}, screen, 40, 0, 0, 25, 25);
	}
	/*** level bar ***/
	switch (iLvlWarning)
	{
		case 21:
			ShowImage (-5, (int[]){22, 0, 0, 0}, screen, 41, 0, 0, 642, 25);
			break;
		case 10:
			ShowImage (-5, (int[]){21, 0, 0, 0}, screen, 41, 0, 0, 642, 25);
			break;
		case 0:
			ShowImage (-5, (int[]){3, 0, 0, 0}, screen, 41, 0, 0, 642, 25);
			break;
	}
	/*** ZSNES ***/
	if (iZSNES == 1)
		{ ShowImage (-18, (int[]){2, 0, 0, 0}, screen, 212, 0, 0, 642, 380); }

	if (iEditPoP == 1)
	{
		EnvNrAsName (iEXEEnv[luLevelNr], sLevelType);
		switch (luLevelNr)
		{
			case 1: snprintf (sTemp, MAX_TEXT,
				"level 1 (%s; prison),", sLevelType); break;
			case 2: snprintf (sTemp, MAX_TEXT,
				"level 2 (%s; guards),", sLevelType); break;
			case 3: snprintf (sTemp, MAX_TEXT,
				"level 3 (%s; skeleton),", sLevelType); break;
			case 4: snprintf (sTemp, MAX_TEXT,
				"level 4 (%s; mirror),", sLevelType); break;
			case 5: snprintf (sTemp, MAX_TEXT,
				"level 5 (%s; thief),", sLevelType); break;
			case 6: snprintf (sTemp, MAX_TEXT,
				"level 6 (%s; plunge),", sLevelType); break;
			case 7: snprintf (sTemp, MAX_TEXT,
				"level 7 (%s; weightless),", sLevelType); break;
			case 8: snprintf (sTemp, MAX_TEXT,
				"level 8 (%s; mouse),", sLevelType); break;
			case 9: snprintf (sTemp, MAX_TEXT,
				"level 9 (%s; twisty),", sLevelType); break;
			case 10: snprintf (sTemp, MAX_TEXT,
				"level 10 (%s; quad),", sLevelType); break;
			case 11: snprintf (sTemp, MAX_TEXT,
				"level 11 (%s; fragile),", sLevelType); break;
			case 12: snprintf (sTemp, MAX_TEXT,
				"level 12 (12a; %s; tower),", sLevelType); break;
			case 13: snprintf (sTemp, MAX_TEXT,
				"level 13 (12b; %s; jaffar),", sLevelType); break;
			case 14: snprintf (sTemp, MAX_TEXT,
				"level 14 (%s; rescue),", sLevelType); break;
			case 15: snprintf (sTemp, MAX_TEXT,
				"level 15 (%s; potions),", sLevelType); break;
			case 0: snprintf (sTemp, MAX_TEXT,
				"level 0 (%s; demo),", sLevelType); break;
		}
	} else if (iEditPoP == 2) {
		if (luLevelNr > 14)
			{ snprintf (sGamePlay, MAX_TEXT, "%s", "; gameplay"); }
				else { snprintf (sGamePlay, MAX_TEXT, "%s", ""); }
		switch (iEXEEnvPoP2)
		{
			case 0x01: snprintf (sLevelType, MAX_TEXT, "%s", "desert"); break;
			case 0x02: snprintf (sLevelType, MAX_TEXT, "%s", "temple"); break;
			case 0x03: snprintf (sLevelType, MAX_TEXT, "%s", "caverns"); break;
			case 0x04: snprintf (sLevelType, MAX_TEXT, "%s", "ruins"); break;
			case 0x05: snprintf (sLevelType, MAX_TEXT, "%s", "rooftops"); break;
			case 0x06: snprintf (sLevelType, MAX_TEXT, "%s", "final"); break;
		}
		snprintf (sTemp, MAX_TEXT, "level %lu (%s%s),",
			luLevelNr, sLevelType, sGamePlay);
	} else {
		switch (luLevelNr)
		{
			case 23: snprintf (sTraining, MAX_TEXT, "%s", "; training 1"); break;
			case 24: snprintf (sTraining, MAX_TEXT, "%s", "; training 2"); break;
			case 25: snprintf (sTraining, MAX_TEXT, "%s", "; training 3"); break;
			case 26: snprintf (sTraining, MAX_TEXT, "%s", "; training 4"); break;
			case 27: snprintf (sTraining, MAX_TEXT, "%s", "; training 5"); break;
			default: snprintf (sTraining, MAX_TEXT, "%s", ""); break;
		}
		EnvNrAsName (iEXEEnvL[luLevelNr], sLevelType);
		snprintf (sTemp, MAX_TEXT, "level %lu (%s%s),",
			luLevelNr, sLevelType, sTraining);
	}
	switch (iScreenS)
	{
		case 1:
			snprintf (sText, MAX_TEXT, "%s room %i", sTemp, iCurRoom);
			ShowImage (-5, (int[]){iExtras + 10, 0, 0, 0}, screen,
				93, 0, 0, 200, 70);
			break;
		case 2:
			snprintf (sText, MAX_TEXT, "%s room links", sTemp); break;
		case 3:
			snprintf (sText, MAX_TEXT, "%s events", sTemp); break;
	}

	if (iLvlWarning == 0)
	{
		DisplayTextLine (31, 5, sText, font1, color_bl, color_wh, 0);
	}

	if (iEditPoP != 2) { ShowMap(); }

	/*** refresh screen ***/
	if ((iPlaytest != 1) && (iJumpTo != 1))
		{ SDL_RenderPresent (screen); }
}
/*****************************************************************************/
void Prev (int iCurLevel)
/*****************************************************************************/
{
	int iToLoad;

	iToLoad = -1;
	switch (iEditPoP)
	{
		case 1:
			if (iCurLevel != 1)
			{
				iToLoad = iCurLevel - 1;
				if (iToLoad == -1) { iToLoad = 15; }
			}
			break;
		case 2:
		case 3:
			if (iCurLevel != 1) { iToLoad = iCurLevel - 1; }
			break;
	}
	if (iToLoad != -1)
	{
		LoadLevel (iToLoad);
		PlaySound ("wav/level_change.wav");
	}
}
/*****************************************************************************/
void Next (int iCurLevel)
/*****************************************************************************/
{
	int iToLoad;

	iToLoad = -1;
	switch (iEditPoP)
	{
		case 1:
			if (iCurLevel != 0)
			{
				iToLoad = iCurLevel + 1;
				if (iToLoad == 16) { iToLoad = 0; }
			}
			break;
		case 2:
			if (iCurLevel != 28) { iToLoad = iCurLevel + 1; }
			break;
		case 3:
			if (iCurLevel != 27) { iToLoad = iCurLevel + 1; }
			break;
	}
	if (iToLoad != -1)
	{
		LoadLevel (iToLoad);
		PlaySound ("wav/level_change.wav");
	}
}
/*****************************************************************************/
void WhereToStart (void)
/*****************************************************************************/
{
	int iTemp;
	iMinX = 0;
	iMaxX = 0;
	iMinY = 0;
	iMaxY = 0;

	for (iTemp = 1; iTemp <= iRooms; iTemp++)
	{
		iDone[iTemp] = 0;
	}
	CheckSides (arKidRoom[1], 0, 0);

	iStartRoomsX = round (12 - (((float)iMinX + (float)iMaxX) / 2));
	iStartRoomsY = round (12 - (((float)iMinY + (float)iMaxY) / 2));
}
/*****************************************************************************/
void CheckSides (int iRoom, int iX, int iY)
/*****************************************************************************/
{
	if (iX < iMinX) { iMinX = iX; }
	if (iY < iMinY) { iMinY = iY; }
	if (iX > iMaxX) { iMaxX = iX; }
	if (iY > iMaxY) { iMaxY = iY; }

	if ((iEditPoP == 3) && (iRoom > 24))
	{
		printf ("[ WARN ] Found an impossible room link in level %lu: %i\n",
			luLevelNr, iRoom); return;
	}

	iDone[iRoom] = 1;

	if ((iRoomConnections[iRoom][1] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][1] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][1] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][1]] != 1))
		{ CheckSides (iRoomConnections[iRoom][1], iX - 1, iY); }

	if ((iRoomConnections[iRoom][2] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][2] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][2] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][2]] != 1))
		{ CheckSides (iRoomConnections[iRoom][2], iX + 1, iY); }

	if ((iRoomConnections[iRoom][3] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][3] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][3] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][3]] != 1))
		{ CheckSides (iRoomConnections[iRoom][3], iX, iY - 1); }

	if ((iRoomConnections[iRoom][4] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][4] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][4] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][4]] != 1))
		{ CheckSides (iRoomConnections[iRoom][4], iX, iY + 1); }
}
/*****************************************************************************/
void ShowRooms (int iRoom, int iX, int iY, int iNext)
/*****************************************************************************/
{
	char sOnGrid[MAX_GRID + 2];
	char sTemp[MAX_GRID + 2];

	if (iX < 10)
	{
		snprintf (sTemp, MAX_GRID, "10%i", iX);
	} else {
		snprintf (sTemp, MAX_GRID, "1%i", iX);
	}
	if (iY < 10)
	{
		snprintf (sOnGrid, MAX_GRID, "%s0%i", sTemp, iY);
	} else {
		snprintf (sOnGrid, MAX_GRID, "%s%i", sTemp, iY);
	}
	if (iRoom != -1)
	{
		ShowImage (-6, (int[]){iRoom, 0, 0, 0}, ascreen,
			atoi (sOnGrid), 0, 0, 14, 14);
		if (iCurRoom == iRoom)
		{
			ShowImage (-7, (int[]){0, 0, 0, 0}, ascreen,
				atoi (sOnGrid), 0, 0, 14, 14);
		}
		if (arKidRoom[1] == iRoom)
		{
			ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen,
				atoi (sOnGrid), 0, 0, 14, 14);
		}
		if (iRoom == iMovingRoom)
		{
			ShowImage (-7, (int[]){2, 0, 0, 0}, ascreen,
				atoi (sOnGrid), 0, 0, 14, 14);
		}
	} else {
		ShowImage (-7, (int[]){3, 0, 0, 0}, ascreen, atoi (sOnGrid), 0, 0, 14, 14);
	}
	if (iRoom == iMovingRoom)
	{
		iMovingOldX = iX;
		iMovingOldY = iY;
		if (iMovingNewBusy == 0)
		{
			iMovingNewX = iMovingOldX;
			iMovingNewY = iMovingOldY;
			iMovingNewBusy = 1;
		}
	}

	if (iRoom != -1) { iDone[iRoom] = 1; }

	if (iNext == 1)
	{
		if ((iRoomConnections[iRoom][1] != 0) && /*** DOS ***/
			(iRoomConnections[iRoom][1] != 254) && /*** SNES ***/
			(iRoomConnections[iRoom][1] != 255) && /*** SNES ***/
			(iDone[iRoomConnections[iRoom][1]] != 1))
			{ ShowRooms (iRoomConnections[iRoom][1], iX - 1, iY, 1); }

		if ((iRoomConnections[iRoom][2] != 0) && /*** DOS ***/
			(iRoomConnections[iRoom][2] != 254) && /*** SNES ***/
			(iRoomConnections[iRoom][2] != 255) && /*** SNES ***/
			(iDone[iRoomConnections[iRoom][2]] != 1))
			{ ShowRooms (iRoomConnections[iRoom][2], iX + 1, iY, 1); }

		if ((iRoomConnections[iRoom][3] != 0) && /*** DOS ***/
			(iRoomConnections[iRoom][3] != 254) && /*** SNES ***/
			(iRoomConnections[iRoom][3] != 255) && /*** SNES ***/
			(iDone[iRoomConnections[iRoom][3]] != 1))
			{ ShowRooms (iRoomConnections[iRoom][3], iX, iY - 1, 1); }

		if ((iRoomConnections[iRoom][4] != 0) && /*** DOS ***/
			(iRoomConnections[iRoom][4] != 254) && /*** SNES ***/
			(iRoomConnections[iRoom][4] != 255) && /*** SNES ***/
			(iDone[iRoomConnections[iRoom][4]] != 1))
			{ ShowRooms (iRoomConnections[iRoom][4], iX, iY + 1, 1); }
	}
}
/*****************************************************************************/
void SetMapHover (int iRoom, int iX, int iY)
/*****************************************************************************/
{
	float fOffsetX, fOffsetY;
	float fRoomStartX, fRoomStartY;

	/*** Used for looping. ***/
	int iTileLoop;

	fRoomStartX = MapGridStartX() + ZoomGet() + ((iX - 1) * (51 * ZoomGet()));
	fRoomStartY = MapGridStartY() + ZoomGet() + ((iY - 1) * (31 * ZoomGet()));

	for (iTileLoop = 1; iTileLoop <= 30; iTileLoop++)
	{
		if ((iTileLoop >= 1) && (iTileLoop <= 10))
		{
			fOffsetX = (iTileLoop - 1) * 5;
			fOffsetY = 0;
		}
		else if ((iTileLoop >= 11) && (iTileLoop <= 20))
		{
			fOffsetX = (iTileLoop - 11) * 5;
			fOffsetY = 10;
		}
		else if ((iTileLoop >= 21) && (iTileLoop <= 30))
		{
			fOffsetX = (iTileLoop - 21) * 5;
			fOffsetY = 20;
		}
		fOffsetX = fOffsetX * ZoomGet();
		fOffsetY = fOffsetY * ZoomGet();

		/*** hover tile ***/
		if ((iXPosMap >= fRoomStartX + fOffsetX) &&
			(iXPosMap < fRoomStartX + fOffsetX + (5 * ZoomGet())) &&
			(iYPosMap >= fRoomStartY + fOffsetY) &&
			(iYPosMap < fRoomStartY + fOffsetY + (10 * ZoomGet())))
		{
			iMapHoverTile = iTileLoop;
		}
	}

	/*** hover room ***/
	if ((iXPosMap >= fRoomStartX) &&
		(iXPosMap <= fRoomStartX + (50 * ZoomGet())) &&
		(iYPosMap >= fRoomStartY) &&
		(iYPosMap <= fRoomStartY + (30 * ZoomGet())))
	{
		iMapHoverRoom = iRoom;
		iMapHoverYes = 1;
	}

	iDone[iRoom] = 1;

	if ((iRoomConnections[iRoom][1] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][1] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][1] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][1]] != 1))
		{ SetMapHover (iRoomConnections[iRoom][1], iX - 1, iY); }

	if ((iRoomConnections[iRoom][2] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][2] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][2] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][2]] != 1))
		{ SetMapHover (iRoomConnections[iRoom][2], iX + 1, iY); }

	if ((iRoomConnections[iRoom][3] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][3] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][3] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][3]] != 1))
		{ SetMapHover (iRoomConnections[iRoom][3], iX, iY - 1); }

	if ((iRoomConnections[iRoom][4] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][4] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][4] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][4]] != 1))
		{ SetMapHover (iRoomConnections[iRoom][4], iX, iY + 1); }
}
/*****************************************************************************/
void ShowRoomsMap (int iRoom, int iX, int iY)
/*****************************************************************************/
{
	char sInfo[MAX_INFO + 2];
	int iThing, iMod;
	float fOffsetX, fOffsetY;
	float fRoomStartX, fRoomStartY;
	char sText[MAX_TEXT + 2];
	int iB1, iB2, iB3, iB4;

	/*** Used for looping. ***/
	int iTileLoop;

	fRoomStartX = MapGridStartX() + ZoomGet() + ((iX - 1) * (51 * ZoomGet()));
	fRoomStartY = MapGridStartY() + ZoomGet() + ((iY - 1) * (31 * ZoomGet()));

	for (iTileLoop = 1; iTileLoop <= 30; iTileLoop++)
	{
		if ((iTileLoop >= 1) && (iTileLoop <= 10))
		{
			fOffsetX = (iTileLoop - 1) * 5;
			fOffsetY = 0;
		}
		else if ((iTileLoop >= 11) && (iTileLoop <= 20))
		{
			fOffsetX = (iTileLoop - 11) * 5;
			fOffsetY = 10;
		}
		else if ((iTileLoop >= 21) && (iTileLoop <= 30))
		{
			fOffsetX = (iTileLoop - 21) * 5;
			fOffsetY = 20;
		}
		fOffsetX = fOffsetX * ZoomGet();
		fOffsetY = fOffsetY * ZoomGet();

		if (iEditPoP == 1)
		{
			iThing = iThingA[iRoom][iTileLoop - 1];
			if (iThing > 31) { iThing = iThing % 32; }
			iMod = iModifierA[iRoom][iTileLoop - 1][1];
			switch (iThing)
			{
				case 0: if (iMod != 3) { iMod = 0; } break;
				case 1: iMod = 0; break;
				case 2: iMod = 0; break;
				case 3: iMod = 0; break;
				case 4: if ((iMod != 0) && (iMod != 1)) { iMod = 0; } break;
				case 5: iMod = 0; break;
				case 6: iMod = 0; break;
				case 7: iMod = 0; break;
				case 8: iMod = 0; break;
				case 9: iMod = 0; break;
				case 10: if (iMod > 6) { iMod = 0; } break;
				case 11: iMod = 0; break;
				case 12: iMod = 0; break;
				case 13: iMod = 0; break;
				case 14: iMod = 0; break;
				case 15: iMod = 0; break;
				case 16: iMod = 0; break;
				case 17: iMod = 0; break;
				case 18: if (iMod != 2) { iMod = 0; } break; /*** chomper ***/
				case 19: iMod = 0; break;
				case 20: iMod = 0; break;
				case 21: iMod = 0; break;
				case 22: iMod = 0; break;
				case 23: iMod = 0; break;
				case 24: iMod = 0; break;
				case 25: iMod = 0; break;
				case 26: iMod = 0; break;
				case 27: iMod = 0; break;
				case 28: iMod = 0; break;
				case 29: iMod = 0; break;
				case 30: iMod = 0; break;
			}
			snprintf (sInfo, MAX_INFO, "imgmini1[%i][%i]", iThing, iMod);
			ShowImageBasic (imgmini1[iThing][iMod],
				fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY,
				sInfo, mscreen, ZoomGet(), 0);
		}
		if (iEditPoP == 3)
		{
			iB1 = iBlock1A[iRoom][iTileLoop - 1];
			iB2 = iBlock2A[iRoom][iTileLoop - 1];
			iB3 = iBlock3A[iRoom][iTileLoop - 1];
			iB4 = iBlock4A[iRoom][iTileLoop - 1];
			iMod = iModifierA[iRoom][iTileLoop - 1][1];
			CurTypeBlocks(); /*** Maybe not necessary. ***/
			iThing = GetTileNrSNES (iB1, iB2, iB3, iB4, iMod);
			if (iThing == 0)
				{ iThing = GetTileNrSNESApprox (iB3, iB4, iMod); }
			switch (iThing)
			{
				case 14: iMod = 0; break; /*** raise ***/
				case 15: iMod = 0; break; /*** drop ***/
				case 18: iMod = 0; break; /*** gate (open) ***/
				case 24: iMod = 0; break; /*** teleport ***/
			}
			if (imgmini3[iThing][iMod] == NULL)
			{
				if (iDebug == 1)
				{
					printf ("[ WARN ] Strange tile (level %i, room %i,"
						" tile %i): %i %i!\n",
						(int)luLevelNr, iRoom, iTileLoop, iThing, iMod);
				}
				iThing = 0; iMod = 0; /*** Fallback. ***/
			}
			snprintf (sInfo, MAX_INFO, "imgmini3[%i][%i]", iThing, iMod);
			ShowImageBasic (imgmini3[iThing][iMod],
				fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY,
				sInfo, mscreen, ZoomGet(), 0);
		}

		/*** guard ***/
		if (sGuardLocations[iRoom - 1] == iTileLoop - 1)
		{
			ShowImageBasic (imgminiguard, fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY, "imgminiguard", mscreen, ZoomGet(), 0);
		}

		/*** prince ***/
		if ((arKidRoom[1] == iRoom) && (arKidPos[1] == iTileLoop))
		{
			ShowImageBasic (imgminiprince, fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY, "imgminiprince", mscreen, ZoomGet(), 0);
		}

		/*** hover tile (green) ***/
		if ((iXPosMap >= fRoomStartX + fOffsetX) &&
			(iXPosMap < fRoomStartX + fOffsetX + (5 * ZoomGet())) &&
			(iYPosMap >= fRoomStartY + fOffsetY) &&
			(iYPosMap < fRoomStartY + fOffsetY + (10 * ZoomGet())))
		{
			ShowImageBasic (imgminihover, fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY, "imgminihover", mscreen, ZoomGet(), 0);
		}

		/*** related tile (yellow) ***/
		if (((iEditPoP == 1) && (RelatedToHover1 (iRoom, iTileLoop) == 1)) ||
			((iEditPoP == 3) && (RelatedToHover3 (iRoom, iTileLoop) == 1)))
		{
			ShowImageBasic (imgminirelated, fRoomStartX + fOffsetX,
				fRoomStartY + fOffsetY, "imgminirelated", mscreen, ZoomGet(), 0);
		}
	}

	/*** active room (green border) ***/
	if (iCurRoom == iRoom)
	{
		ShowImageBasic (imgbmrooma, fRoomStartX - ZoomGet(),
			fRoomStartY - ZoomGet(), "imgbmrooma", mscreen, ZoomGet(), 0);
	}

	/*** hover room (bright green border) ***/
	if ((iXPosMap >= fRoomStartX) &&
		(iXPosMap <= fRoomStartX + (50 * ZoomGet())) &&
		(iYPosMap >= fRoomStartY) &&
		(iYPosMap <= fRoomStartY + (30 * ZoomGet())))
	{
		ShowImageBasic (imgbmroomh, fRoomStartX - ZoomGet(),
			fRoomStartY - ZoomGet(), "imgbmroomh", mscreen, ZoomGet(), 0);
	}

	/*** room number ***/
	if (iMapShowNumbers == 1)
	{
		snprintf (sText, MAX_TEXT, "%i", iRoom);
		DisplayTextLine (fRoomStartX, fRoomStartY, sText,
			font4, color_bl, color_wh, 1);
	}

	iDone[iRoom] = 1;

	if ((iRoomConnections[iRoom][1] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][1] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][1] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][1]] != 1))
		{ ShowRoomsMap (iRoomConnections[iRoom][1], iX - 1, iY); }

	if ((iRoomConnections[iRoom][2] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][2] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][2] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][2]] != 1))
		{ ShowRoomsMap (iRoomConnections[iRoom][2], iX + 1, iY); }

	if ((iRoomConnections[iRoom][3] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][3] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][3] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][3]] != 1))
		{ ShowRoomsMap (iRoomConnections[iRoom][3], iX, iY - 1); }

	if ((iRoomConnections[iRoom][4] != 0) && /*** DOS ***/
		(iRoomConnections[iRoom][4] != 254) && /*** SNES ***/
		(iRoomConnections[iRoom][4] != 255) && /*** SNES ***/
		(iDone[iRoomConnections[iRoom][4]] != 1))
		{ ShowRoomsMap (iRoomConnections[iRoom][4], iX, iY + 1); }
}
/*****************************************************************************/
void InitPopUp (void)
/*****************************************************************************/
{
	SDL_Event event;
	int iPopUp;

	iPopUp = 1;

	PlaySound ("wav/popup.wav");
	ShowPopUp();
	SDL_RaiseWindow (window);

	while (iPopUp == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							iPopUp = 0; break;
					}
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
						case SDLK_o:
							iPopUp = 0;
						default: break;
					}
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (440, 317, 440 + 85, 317 + 32) == 1) /*** OK ***/
						{
							if (iOKOn != 1) { iOKOn = 1; }
							ShowPopUp();
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iOKOn = 0;
					if (event.button.button == 1)
					{
						if (InArea (440, 317, 440 + 85, 317 + 32) == 1) /*** OK ***/
						{
							iPopUp = 0;
						}
					}
					ShowPopUp(); break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowScreen (iScreen, ascreen); ShowPopUp(); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/popup_close.wav");
	ShowScreen (iScreen, ascreen);
}
/*****************************************************************************/
void ShowPopUp (void)
/*****************************************************************************/
{
	char arText[9 + 2][MAX_TEXT + 2];

	/*** faded background ***/
	ShowImage (-9, (int[]){1, 0, 0, 0}, ascreen, 31, 0, 0, 692, 455);
	/*** popup ***/
	ShowImage (-9, (int[]){2, 0, 0, 0}, ascreen, 44, 0, 0, 524, 361);
	switch (iOKOn)
	{
		case 0:
			/*** OK off ***/
			ShowImage (-9, (int[]){3, 0, 0, 0}, ascreen, 45, 0, 0, 85, 32); break;
		case 1:
			/*** OK on ***/
			ShowImage (-9, (int[]){4, 0, 0, 0}, ascreen, 45, 0, 0, 85, 32); break;
	}

	snprintf (arText[0], MAX_TEXT, "%s %s", EDITOR_NAME, EDITOR_VERSION);
	snprintf (arText[1], MAX_TEXT, "%s", COPYRIGHT);
	snprintf (arText[2], MAX_TEXT, "%s", "");
	if (iController != 1)
	{
		snprintf (arText[3], MAX_TEXT, "%s", "single tile (change or select)");
		snprintf (arText[4], MAX_TEXT, "%s", "entire room (clear or fill)");
		snprintf (arText[5], MAX_TEXT, "%s", "entire level (randomize or fill)");
	} else {
		snprintf (arText[3], MAX_TEXT, "%s", "The detected game controller:");
		snprintf (arText[4], MAX_TEXT, "%s", sControllerName);
		snprintf (arText[5], MAX_TEXT, "%s", "Have fun using it!");
	}
	snprintf (arText[6], MAX_TEXT, "%s", "");
	if (iEditPoP != 2)
	{
		snprintf (arText[7], MAX_TEXT, "%s", "You may use one guard per room.");
	} else {
		snprintf (arText[7], MAX_TEXT, "%s", "You may use five guards per room.");
	}
	snprintf (arText[8], MAX_TEXT, "%s", "The tile behavior may differ per"
		" level.");

	DisplayText (180, 118, FONT_SIZE_15, arText, 9, font1);

	/*** refresh screen ***/
	SDL_RenderPresent (ascreen);
}
/*****************************************************************************/
int InitPopUpYN (int iYNText)
/*****************************************************************************/
{
	SDL_Event event;
	int iPopUp;
	int iReturn;

	iReturn = 0; /*** Cancelled. ***/
	iPopUp = 1;

	PlaySound ("wav/popup_yn.wav");
	ShowPopUpYN (iYNText);
	SDL_RaiseWindow (window);

	while (iPopUp == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_B: /*** Cancelled. ***/
							iReturn = 0;
							iPopUp = 0;
							break;
						case SDL_CONTROLLER_BUTTON_X: /*** No (left) ***/
							iReturn = 1;
							iPopUp = 0;
							break;
						case SDL_CONTROLLER_BUTTON_Y: /*** Yes (right) ***/
							iReturn = 2;
							iPopUp = 0;
							break;
					}
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE: /*** Cancelled. ***/
							iReturn = 0;
							iPopUp = 0;
							break;
						case SDLK_n: /*** No (left) ***/
							iReturn = 1;
							iPopUp = 0;
							break;
						case SDLK_y: /*** Yes (right) ***/
							iReturn = 2;
							iPopUp = 0;
							break;
						default: break;
					}
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (167, 317, 167 + 85, 317 + 32) == 1)
						{ /*** No (left) ***/
							if (iNoOn != 1) { iNoOn = 1; }
							ShowPopUpYN (iYNText);
						}
						if (InArea (440, 317, 440 + 85, 317 + 32) == 1)
						{ /*** Yes (right) ***/
							if (iYesOn != 1) { iYesOn = 1; }
							ShowPopUpYN (iYNText);
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iYesOn = 0;
					iNoOn = 0;
					if (event.button.button == 1)
					{
						if (InArea (167, 317, 167 + 85, 317 + 32) == 1)
						{ /*** No (left) ***/
							iReturn = 1;
							iPopUp = 0;
						}
						if (InArea (440, 317, 440 + 85, 317 + 32) == 1)
						{ /*** Yes (right) ***/
							iReturn = 2;
							iPopUp = 0;
						}
					}
					ShowPopUpYN (iYNText); break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowScreen (iScreen, ascreen); ShowPopUpYN (iYNText); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/popup_close.wav");
	ShowScreen (iScreen, ascreen);

	return (iReturn);
}
/*****************************************************************************/
void ShowPopUpYN (int iYNText)
/*****************************************************************************/
{
	char arText[9 + 2][MAX_TEXT + 2];

	/*** faded background ***/
	ShowImage (-9, (int[]){1, 0, 0, 0}, ascreen, 31, 0, 0, 692, 455);
	/*** popup_yn ***/
	ShowImage (-9, (int[]){5, 0, 0, 0}, ascreen, 84, 0, 0, 392, 277);
	switch (iYesOn)
	{
		case 0:
			/*** Yes off ***/
			ShowImage (-9, (int[]){6, 0, 0, 0}, ascreen, 85, 0, 0, 85, 32); break;
		case 1:
			/*** Yes on ***/
			ShowImage (-9, (int[]){7, 0, 0, 0}, ascreen, 85, 0, 0, 85, 32); break;
	}
	switch (iNoOn)
	{
		case 0:
			/*** No off ***/
			ShowImage (-9, (int[]){8, 0, 0, 0}, ascreen, 86, 0, 0, 85, 32); break;
		case 1:
			/*** No on ***/
			ShowImage (-9, (int[]){9, 0, 0, 0}, ascreen, 86, 0, 0, 85, 32); break;
	}

	switch (iYNText)
	{
		case 1:
			if (iChanged == 1)
			{
				snprintf (arText[0], MAX_TEXT, "%s", "You made an unsaved change.");
				snprintf (arText[1], MAX_TEXT, "%s", "Do you want to save it?");
			} else {
				snprintf (arText[0], MAX_TEXT, "There are unsaved changes.");
				snprintf (arText[1], MAX_TEXT, "%s", "Do you wish to save these?");
			}
			break;
		case 2:
			snprintf (arText[0], MAX_TEXT, "%s", "Randomize the entire level?");
			snprintf (arText[1], MAX_TEXT, "%s", "");
			break;
		case 3:
			snprintf (arText[0], MAX_TEXT, "%s", "Sprinkle the level with");
			snprintf (arText[1], MAX_TEXT, "%s", "decorations?");
			break;
	}

	DisplayText (180, 118, FONT_SIZE_15, arText, 2, font1);

	/*** refresh screen ***/
	SDL_RenderPresent (ascreen);
}
/*****************************************************************************/
void DisplayText (int iStartX, int iStartY, int iFontSize,
	char arText[9 + 2][MAX_TEXT + 2], int iLines, TTF_Font *font)
/*****************************************************************************/
{
	int iTemp;

	for (iTemp = 0; iTemp <= (iLines - 1); iTemp++)
	{
		if (strcmp (arText[iTemp], "") != 0)
		{
			message = TTF_RenderText_Shaded (font,
				arText[iTemp], color_bl, color_wh);
			messaget = SDL_CreateTextureFromSurface (ascreen, message);
			if ((strcmp (arText[iTemp], "single tile (change or select)") == 0) ||
				(strcmp (arText[iTemp], "entire room (clear or fill)") == 0) ||
				(strcmp (arText[iTemp], "entire level (randomize or fill)") == 0))
			{
				offset.x = iStartX + 20;
			} else {
				offset.x = iStartX;
			}
			offset.y = iStartY + (iTemp * (iFontSize + 4));
			offset.w = message->w; offset.h = message->h;
			CustomRenderCopy (messaget, "message", NULL, ascreen, &offset);
			SDL_DestroyTexture (messaget); SDL_FreeSurface (message);
		}
	}
}
/*****************************************************************************/
void DisplayTextLine (int iStartX, int iStartY, char sText[MAX_TEXT + 2],
	TTF_Font *font, SDL_Color fore, SDL_Color back, int iOnMap)
/*****************************************************************************/
{
	if (strcmp (sText, "") == 0)
	{
		printf ("[ WARN ] Tried to display an empty text.\n");
	} else {
		message = TTF_RenderText_Shaded (font, sText, fore, back);
		if (iOnMap == 0)
		{
			messaget = SDL_CreateTextureFromSurface (ascreen, message);
		} else {
			messaget = SDL_CreateTextureFromSurface (mscreen, message);
		}
		offset.x = iStartX;
		offset.y = iStartY;
		offset.w = message->w; offset.h = message->h;
		if (iOnMap == 0)
		{
			CustomRenderCopy (messaget, "message", NULL, ascreen, &offset);
		} else {
			CustomRenderCopy (messaget, "map message", NULL, mscreen, &offset);
		}
		SDL_DestroyTexture (messaget); SDL_FreeSurface (message);
	}
}
/*****************************************************************************/
void ShowPos (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img_first[2 + 2], SDL_Texture *img_second[2 + 2], char *sLbl)
/*****************************************************************************/
{
	if (cCurType == 'd')
	{
		CustomRenderCopy (img_first[1], "img_first[1]", &loc,
			ascreen, &dest);
	} else {
		CustomRenderCopy (img_second[1], "img_second[1]", &loc,
			ascreen, &dest);
	}

	if ((strcmp (sLbl, "") != 0) && (strcmp (sLbl, "SDLPoP") != 0) &&
		(strcmp (sLbl, "MININIM") != 0) && (strcmp (sLbl, "both") != 0))
	{
		DisplayTextLine (dest.x + 7, dest.y + 145 - FONT_SIZE_11,
			sLbl, font2, color_bl, color_wh, 0);
	}

	if (iSelected == iLocation)
	{
		if (cCurType == 'd')
		{
			CustomRenderCopy (img_first[2], "img_first[2]", &loc,
				ascreen, &dest);
		} else {
			CustomRenderCopy (img_second[2], "img_second[2]", &loc,
				ascreen, &dest);
		}
	}

	if (strcmp (sLbl, "SDLPoP") == 0)
	{
		ShowImageBasic (imgnative_s, dest.x + 22, dest.y + 32, "imgnative_s",
			ascreen, iScale, 1);
	}
	if (strcmp (sLbl, "MININIM") == 0)
	{
		ShowImageBasic (imgnative_m, dest.x + 22, dest.y + 32, "imgnative_m",
			ascreen, iScale, 1);
	}
	if (strcmp (sLbl, "both") == 0)
	{
		ShowImageBasic (imgnative_b, dest.x + 22, dest.y + 32, "imgnative_b",
			ascreen, iScale, 1);
	}

	iPosShown = 1;
}
/*****************************************************************************/
void ShowPosPoP2 (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img[2 + 2], char *sLbl)
/*****************************************************************************/
{
	CustomRenderCopy (img[1], "img[1]", &loc, ascreen, &dest);

	if (strcmp (sLbl, "") != 0)
	{
		DisplayTextLine (dest.x + 7, dest.y + 145 - FONT_SIZE_11,
			sLbl, font2, color_bl, color_wh, 0);
	}

	if (iSelected == iLocation)
	{
		CustomRenderCopy (img[2], "img[2]", &loc, ascreen, &dest);
	}

	iPosShown = 1;
}
/*****************************************************************************/
void ShowPosSNES (SDL_Rect loc, SDL_Rect dest, int iLocation,
	SDL_Texture *img[2 + 2], char *sLbl)
/*****************************************************************************/
{
	/*** Currently, the only difference from ShowPosPoP2() is 145->119. ***/

	CustomRenderCopy (img[1], "img[1]", &loc, ascreen, &dest);

	if (strcmp (sLbl, "") != 0)
	{
		DisplayTextLine (dest.x + 7, dest.y + 119 - FONT_SIZE_11,
			sLbl, font2, color_bl, color_wh, 0);
	}

	if (iSelected == iLocation)
	{
		CustomRenderCopy (img[2], "img[2]", &loc, ascreen, &dest);
	}

	iPosShown = 1;
}
/*****************************************************************************/
void ShowDetail (SDL_Texture *img[2 + 2], SDL_Rect loc,
	SDL_Renderer *screen, SDL_Rect dest, int iLocation)
/*****************************************************************************/
{
	CustomRenderCopy (img[1], "img[1]", &loc, screen, &dest);
	if (iSelected == iLocation)
	{
		CustomRenderCopy (img[2], "img[2]", &loc, screen, &dest);
	}
}
/*****************************************************************************/
void ChangePosAction (char *sAction, int iLocation)
/*****************************************************************************/
{
	if (strcmp (sAction, "left") == 0)
	{
		do {
			iOnTile--;
			if ((cCurType == 'd') || (cCurType == 'p'))
			{
				switch (iOnTile)
				{
					case 0: iOnTile = 13; break;
					case 13: iOnTile = 26; break;
					case 26: iOnTile = 39; break;
					case 39: iOnTile = 52; break;
					case 52: iOnTile = 65; break;
					case 65: iOnTile = 78; break;
					case 91: iOnTile = 109; break;
					case 107: iOnTile = 105; break;
				}
			}
			if (cCurType == 'o')
			{
				switch (iOnTile)
				{
					case 16: iOnTile = 26; break;
					case 22: iOnTile = 19; break;
					case 28: iOnTile = 39; break;
					case 35: iOnTile = 32; break;
					case 39: iOnTile = 52; break;
					case 52: iOnTile = 62; break;
					case 65: iOnTile = 75; break;
					case 78: iOnTile = 88; break;
					case 105: iOnTile = 83; break;
					case 86: iOnTile = 107; break;
				}
			}
			if (cCurType == 'c')
			{
				switch (iOnTile)
				{
					case 0: iOnTile = 13; break;
					case 13: iOnTile = 26; break;
					case 26: iOnTile = 39; break;
					case 39: iOnTile = 52; break;
					case 52: iOnTile = 58; break;
					case 105: iOnTile = 107; break;
				}
			}
			if (cCurType == 'r')
			{
				switch (iOnTile)
				{
					case 0: iOnTile = 13; break;
					case 13: iOnTile = 26; break;
					case 26: iOnTile = 39; break;
					case 39: iOnTile = 52; break;
					case 52: iOnTile = 55; break;
					case 105: iOnTile = 107; break;
				}
			}
			if (cCurType == 't')
			{
				switch (iOnTile)
				{
					case 0: iOnTile = 13; break;
					case 13: iOnTile = 26; break;
					case 31: iOnTile = 39; break;
					case 44: iOnTile = 52; break;
					case 57: iOnTile = 58; break;
					case 105: iOnTile = 107; break;
				}
			}
			if (iEditPoP == 3)
			{
				switch (iOnTile)
				{
					case 0: iOnTile = 13; break;
					case 13: iOnTile = 26; break;
					case 26: iOnTile = 39; break;
					case 39: iOnTile = 48; break;
					case 91: iOnTile = 117; break;
					case 117: iOnTile = 129; break;
				}
			}
		} while (IsDisabled (iOnTile) == 1);
	}

	if (strcmp (sAction, "right") == 0)
	{
		do {
			iOnTile++;
			if ((cCurType == 'd') || (cCurType == 'p'))
			{
				switch (iOnTile)
				{
					case 14: iOnTile = 1; break;
					case 27: iOnTile = 14; break;
					case 40: iOnTile = 27; break;
					case 53: iOnTile = 40; break;
					case 66: iOnTile = 53; break;
					case 79: iOnTile = 66; break;
					case 106: iOnTile = 108; break;
					case 110: iOnTile = 92; break;
				}
			}
			if (cCurType == 'o')
			{
				switch (iOnTile)
				{
					case 20: iOnTile = 23; break;
					case 27: iOnTile = 17; break;
					case 33: iOnTile = 36; break;
					case 40: iOnTile = 29; break;
					case 53: iOnTile = 40; break;
					case 63: iOnTile = 53; break;
					case 76: iOnTile = 66; break;
					case 84: iOnTile = 106; break;
					case 108: iOnTile = 87; break;
					case 89: iOnTile = 79; break;
				}
			}
			if (cCurType == 'c')
			{
				switch (iOnTile)
				{
					case 14: iOnTile = 1; break;
					case 27: iOnTile = 14; break;
					case 40: iOnTile = 27; break;
					case 53: iOnTile = 40; break;
					case 59: iOnTile = 53; break;
					case 108: iOnTile = 106; break;
				}
			}
			if (cCurType == 'r')
			{
				switch (iOnTile)
				{
					case 14: iOnTile = 1; break;
					case 27: iOnTile = 14; break;
					case 40: iOnTile = 27; break;
					case 53: iOnTile = 40; break;
					case 56: iOnTile = 53; break;
					case 108: iOnTile = 106; break;
				}
			}
			if (cCurType == 't')
			{
				switch (iOnTile)
				{
					case 14: iOnTile = 1; break;
					case 27: iOnTile = 14; break;
					case 40: iOnTile = 32; break;
					case 53: iOnTile = 45; break;
					case 59: iOnTile = 58; break;
					case 108: iOnTile = 106; break;
				}
			}
			if (iEditPoP == 3)
			{
				switch (iOnTile)
				{
					case 14: iOnTile = 1; break;
					case 27: iOnTile = 14; break;
					case 40: iOnTile = 27; break;
					case 49: iOnTile = 40; break;
					case 118: iOnTile = 92; break;
					case 130: iOnTile = 118; break;
				}
			}
		} while (IsDisabled (iOnTile) == 1);
	}

	if (strcmp (sAction, "up") == 0)
	{
		if ((cCurType == 'd') || (cCurType == 'p'))
		{
			switch (iOnTile)
			{
				case 1: iOnTile = 92; break;
				case 2: iOnTile = 94; break;
				case 3: iOnTile = 96; break;
				case 4: iOnTile = 98; break;
				case 5: iOnTile = 100; break;
				case 6: iOnTile = 102; break;
				case 7: iOnTile = 104; break;
				case 8: iOnTile = 105; break;
				case 9: iOnTile = 108; break;
				case 10: iOnTile = 109; break;
				case 11: iOnTile = 109; break;
				case 12: iOnTile = 109; break;
				case 13: iOnTile = 109; break;
				case 92: iOnTile = 66; break;
				case 93: iOnTile = 66; break;
				case 94: iOnTile = 67; break;
				case 95: iOnTile = 67; break;
				case 96: iOnTile = 68; break;
				case 97: iOnTile = 68; break;
				case 98: iOnTile = 69; break;
				case 99: iOnTile = 69; break;
				case 100: iOnTile = 70; break;
				case 101: iOnTile = 70; break;
				case 102: iOnTile = 71; break;
				case 103: iOnTile = 71; break;
				case 104: iOnTile = 72; break;
				case 105: iOnTile = 72; break;
				case 108: iOnTile = 74; break;
				case 109: iOnTile = 74; break;
				default: iOnTile-=13; break;
			}
		}
		if (cCurType == 'o')
		{
			switch (iOnTile)
			{
				case 40: iOnTile = 79; break;
				case 41: iOnTile = 80; break;
				case 29: iOnTile = 81; break;
				case 17: iOnTile = 82; break;
				case 18: iOnTile = 83; break;
				case 19: iOnTile = 71; break;
				case 46: iOnTile = 72; break;
				case 47: iOnTile = 106; break;
				case 48: iOnTile = 87; break;
				case 23: iOnTile = 88; break;
				case 24: iOnTile = 50; break;
				case 25: iOnTile = 51; break;
				case 26: iOnTile = 52; break;
				case 106: iOnTile = 73; break;
				case 107: iOnTile = 73; break;
				default: iOnTile-=13; break;
			}
		}
		if (cCurType == 'c')
		{
			switch (iOnTile)
			{
				case 1: iOnTile = 53; break;
				case 2: iOnTile = 54; break;
				case 3: iOnTile = 55; break;
				case 4: iOnTile = 56; break;
				case 5: iOnTile = 57; break;
				case 6: iOnTile = 58; break;
				case 7: iOnTile = 46; break;
				case 8: iOnTile = 106; break;
				case 9: iOnTile = 48; break;
				case 10: iOnTile = 49; break;
				case 11: iOnTile = 50; break;
				case 12: iOnTile = 51; break;
				case 13: iOnTile = 52; break;
				case 106: iOnTile = 47; break;
				case 107: iOnTile = 47; break;
				default: iOnTile-=13; break;
			}
		}
		if (cCurType == 'r')
		{
			switch (iOnTile)
			{
				case 1: iOnTile = 53; break;
				case 2: iOnTile = 54; break;
				case 3: iOnTile = 55; break;
				case 4: iOnTile = 43; break;
				case 5: iOnTile = 44; break;
				case 6: iOnTile = 45; break;
				case 7: iOnTile = 46; break;
				case 8: iOnTile = 106; break;
				case 9: iOnTile = 48; break;
				case 10: iOnTile = 49; break;
				case 11: iOnTile = 50; break;
				case 12: iOnTile = 51; break;
				case 13: iOnTile = 52; break;
				case 106: iOnTile = 47; break;
				case 107: iOnTile = 47; break;
				default: iOnTile-=13; break;
			}
		}
		if (cCurType == 't')
		{
			switch (iOnTile)
			{
				case 1: iOnTile = 14; break;
				case 2: iOnTile = 15; break;
				case 3: iOnTile = 16; break;
				case 4: iOnTile = 17; break;
				case 5: iOnTile = 18; break;
				case 6: iOnTile = 58; break;
				case 7: iOnTile = 46; break;
				case 8: iOnTile = 106; break;
				case 9: iOnTile = 48; break;
				case 10: iOnTile = 49; break;
				case 11: iOnTile = 50; break;
				case 12: iOnTile = 51; break;
				case 13: iOnTile = 52; break;
				case 106: iOnTile = 47; break;
				case 107: iOnTile = 47; break;
				default: iOnTile-=13; break;
			}
		}
		if (iEditPoP == 3)
		{
			switch (iOnTile)
			{
				case 1: iOnTile = 118; break;
				case 2: iOnTile = 120; break;
				case 3: iOnTile = 122; break;
				case 4: iOnTile = 124; break;
				case 5: iOnTile = 126; break;
				case 6: iOnTile = 128; break;
				case 7: iOnTile = 104; break;
				case 8: iOnTile = 106; break;
				case 9: iOnTile = 108; break;
				case 10: iOnTile = 110; break;
				case 11: iOnTile = 112; break;
				case 12: iOnTile = 114; break;
				case 13: iOnTile = 116; break;
				/***/
				case 92: case 93: iOnTile = 40; break;
				case 94: case 95: iOnTile = 41; break;
				case 96: case 97: iOnTile = 42; break;
				case 98: case 99: iOnTile = 43; break;
				case 100: case 101: iOnTile = 44; break;
				case 102: case 103: iOnTile = 45; break;
				case 104: case 105: iOnTile = 46; break;
				case 106: case 107: iOnTile = 47; break;
				case 108: case 109: iOnTile = 48; break;
				case 110: case 111: iOnTile = 36; break;
				case 112: case 113: iOnTile = 37; break;
				case 114: case 115: iOnTile = 38; break;
				case 116: case 117: iOnTile = 39; break;
				/***/
				case 118: iOnTile = 92; break;
				case 119: iOnTile = 93; break;
				case 120: iOnTile = 94; break;
				case 121: iOnTile = 95; break;
				case 122: iOnTile = 96; break;
				case 123: iOnTile = 97; break;
				case 124: iOnTile = 98; break;
				case 125: iOnTile = 99; break;
				case 126: iOnTile = 100; break;
				case 127: iOnTile = 101; break;
				case 128: iOnTile = 102; break;
				case 129: iOnTile = 103; break;
				/***/
				default: iOnTile-=13; break;
			}
		}
		while (IsDisabled (iOnTile) == 1) { iOnTile--; }
	}

	if (strcmp (sAction, "down") == 0)
	{
		if ((cCurType == 'd') || (cCurType == 'p'))
		{
			switch (iOnTile)
			{
				case 66: iOnTile = 92; break;
				case 67: iOnTile = 94; break;
				case 68: iOnTile = 96; break;
				case 69: iOnTile = 98; break;
				case 70: iOnTile = 100; break;
				case 71: iOnTile = 102; break;
				case 72: iOnTile = 104; break;
				case 73: iOnTile = 105; break;
				case 74: iOnTile = 108; break;
				case 75: iOnTile = 109; break;
				case 76: iOnTile = 109; break;
				case 77: iOnTile = 109; break;
				case 78: iOnTile = 109; break;
				case 92: iOnTile = 1; break;
				case 93: iOnTile = 1; break;
				case 94: iOnTile = 2; break;
				case 95: iOnTile = 2; break;
				case 96: iOnTile = 3; break;
				case 97: iOnTile = 3; break;
				case 98: iOnTile = 4; break;
				case 99: iOnTile = 4; break;
				case 100: iOnTile = 5; break;
				case 101: iOnTile = 5; break;
				case 102: iOnTile = 6; break;
				case 103: iOnTile = 6; break;
				case 104: iOnTile = 7; break;
				case 105: iOnTile = 7; break;
				case 108: iOnTile = 9; break;
				case 109: iOnTile = 9; break;
				default: iOnTile+=13; break;
			}
		}
		if (cCurType == 'o')
		{
			switch (iOnTile)
			{
				case 79: iOnTile = 40; break;
				case 80: iOnTile = 41; break;
				case 81: iOnTile = 29; break;
				case 82: iOnTile = 17; break;
				case 83: iOnTile = 18; break;
				case 71: iOnTile = 19; break;
				case 72: iOnTile = 46; break;
				case 73: iOnTile = 106; break;
				case 87: iOnTile = 48; break;
				case 88: iOnTile = 23; break;
				case 50: iOnTile = 24; break;
				case 51: iOnTile = 25; break;
				case 52: iOnTile = 26; break;
				case 106: iOnTile = 47; break;
				case 107: iOnTile = 47; break;
				default: iOnTile+=13; break;
			}
		}
		if (cCurType == 'c')
		{
			switch (iOnTile)
			{
				case 53: iOnTile = 1; break;
				case 54: iOnTile = 2; break;
				case 55: iOnTile = 3; break;
				case 56: iOnTile = 4; break;
				case 57: iOnTile = 5; break;
				case 58: iOnTile = 6; break;
				case 46: iOnTile = 7; break;
				case 47: iOnTile = 106; break;
				case 48: iOnTile = 9; break;
				case 49: iOnTile = 10; break;
				case 50: iOnTile = 11; break;
				case 51: iOnTile = 12; break;
				case 52: iOnTile = 13; break;
				case 106: iOnTile = 8; break;
				case 107: iOnTile = 8; break;
				default: iOnTile+=13; break;
			}
		}
		if (cCurType == 'r')
		{
			switch (iOnTile)
			{
				case 53: iOnTile = 1; break;
				case 54: iOnTile = 2; break;
				case 55: iOnTile = 3; break;
				case 43: iOnTile = 4; break;
				case 44: iOnTile = 5; break;
				case 45: iOnTile = 6; break;
				case 46: iOnTile = 7; break;
				case 47: iOnTile = 106; break;
				case 48: iOnTile = 9; break;
				case 49: iOnTile = 10; break;
				case 50: iOnTile = 11; break;
				case 51: iOnTile = 12; break;
				case 52: iOnTile = 13; break;
				case 106: iOnTile = 8; break;
				case 107: iOnTile = 8; break;
				default: iOnTile+=13; break;
			}
		}
		if (cCurType == 't')
		{
			switch (iOnTile)
			{
				case 14: iOnTile = 1; break;
				case 15: iOnTile = 2; break;
				case 16: iOnTile = 3; break;
				case 17: iOnTile = 4; break;
				case 18: iOnTile = 5; break;
				case 58: iOnTile = 6; break;
				case 46: iOnTile = 7; break;
				case 47: iOnTile = 106; break;
				case 48: iOnTile = 9; break;
				case 49: iOnTile = 10; break;
				case 50: iOnTile = 11; break;
				case 51: iOnTile = 12; break;
				case 52: iOnTile = 13; break;
				case 106: iOnTile = 8; break;
				case 107: iOnTile = 8; break;
				default: iOnTile+=13; break;
			}
		}
		if (iEditPoP == 3)
		{
			switch (iOnTile)
			{
				case 36: iOnTile = 110; break;
				case 37: iOnTile = 112; break;
				case 38: iOnTile = 114; break;
				case 39: iOnTile = 116; break;
				/***/
				case 40: iOnTile = 92; break;
				case 41: iOnTile = 94; break;
				case 42: iOnTile = 96; break;
				case 43: iOnTile = 98; break;
				case 44: iOnTile = 100; break;
				case 45: iOnTile = 102; break;
				case 46: iOnTile = 104; break;
				case 47: iOnTile = 106; break;
				case 48: iOnTile = 108; break;
				/***/
				case 92: iOnTile = 118; break;
				case 93: iOnTile = 119; break;
				case 94: iOnTile = 120; break;
				case 95: iOnTile = 121; break;
				case 96: iOnTile = 122; break;
				case 97: iOnTile = 123; break;
				case 98: iOnTile = 124; break;
				case 99: iOnTile = 125; break;
				case 100: iOnTile = 126; break;
				case 101: iOnTile = 127; break;
				case 102: iOnTile = 128; break;
				case 103: iOnTile = 129; break;
				case 104: case 105: iOnTile = 7; break;
				case 106: case 107: iOnTile = 8; break;
				case 108: case 109: iOnTile = 9; break;
				case 110: case 111: iOnTile = 10; break;
				case 112: case 113: iOnTile = 11; break;
				case 114: case 115: iOnTile = 12; break;
				case 116: case 117: iOnTile = 13; break;
				/***/
				case 118: case 119: iOnTile = 1; break;
				case 120: case 121: iOnTile = 2; break;
				case 122: case 123: iOnTile = 3; break;
				case 124: case 125: iOnTile = 4; break;
				case 126: case 127: iOnTile = 5; break;
				case 128: case 129: iOnTile = 6; break;
				/***/
				default: iOnTile+=13; break;
			}
		}
		while (IsDisabled (iOnTile) == 1) { iOnTile--; }
	}

	if (strcmp (sAction, "no") == 0)
	{
		if (iChangeStuck != 0)
		{
			iChangeStuck = 0;
			PlaySound ("wav/check_box.wav");
			ApplyStuckIfNecessary (iLocation);
		}
	}

	if (strcmp (sAction, "harmful") == 0)
	{
		if (iChangeStuck != 1)
		{
			iChangeStuck = 1;
			PlaySound ("wav/check_box.wav");
			ApplyStuckIfNecessary (iLocation);
		}
	}

	if (strcmp (sAction, "harmless") == 0)
	{
		if (iChangeStuck != 2)
		{
			iChangeStuck = 2;
			PlaySound ("wav/check_box.wav");
			ApplyStuckIfNecessary (iLocation);
		}
	}

	if (strcmp (sAction, "marker") == 0)
	{
		switch (iChangeMarker)
		{
			case 0x0d: ChangePosAction ("marker 0x11", iLocation); break;
			case 0x11: ChangePosAction ("marker 0x12", iLocation); break;
			case 0x12: ChangePosAction ("marker 0x14", iLocation); break;
			case 0x14: ChangePosAction ("marker 0x15", iLocation); break;
			case 0x15: ChangePosAction ("marker 0x16", iLocation); break;
			case 0x16: ChangePosAction ("marker 0x17", iLocation); break;
			case 0x17: ChangePosAction ("marker 0x0d", iLocation); break;
		}
	}

	if (strcmp (sAction, "marker 0x0d") == 0)
	{
		if (iChangeMarker != 0x0d)
		{
			iChangeMarker = 0x0d;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x11") == 0)
	{
		if (iChangeMarker != 0x11)
		{
			iChangeMarker = 0x11;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x12") == 0)
	{
		if (iChangeMarker != 0x12)
		{
			iChangeMarker = 0x12;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x14") == 0)
	{
		if (iChangeMarker != 0x14)
		{
			iChangeMarker = 0x14;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x15") == 0)
	{
		if (iChangeMarker != 0x15)
		{
			iChangeMarker = 0x15;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x16") == 0)
	{
		if (iChangeMarker != 0x16)
		{
			iChangeMarker = 0x16;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}
	if (strcmp (sAction, "marker 0x17") == 0)
	{
		if (iChangeMarker != 0x17)
		{
			iChangeMarker = 0x17;
			PlaySound ("wav/check_box.wav");
			ApplyMarkerIfNecessary (iLocation);
		}
	}

	if (strcmp (sAction, "skill less") == 0)
	{
		if (iGuardSkill > 0)
		{
			iGuardSkill--;
			PlaySound ("wav/plus_minus.wav");
			ApplySkillIfNecessary (iLocation);
		}
	}

	if (strcmp (sAction, "skill more") == 0)
	{
		if (iGuardSkill < 255)
		{
			iGuardSkill++;
			PlaySound ("wav/plus_minus.wav");
			ApplySkillIfNecessary (iLocation);
		}
	}
}
/*****************************************************************************/
void ChangePos (int iLocation, SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iChanging;
	int iTemp;
	int iTemp2;
	int iNowOn;
	int iOldXPos;
	int iOldYPos;
	int iUseTile;
	int iWallChanged;
	int iMod2Ch;
	int iXJoy1, iYJoy1, iXJoy2, iYJoy2;

	iChanging = 1;
	iSkillTooltip = 0;
	iJaffarTooltip = 0;
	if (iEditPoP != 3) { iGuardSkill = 0; } else { iGuardSkill = 1; }
	iTooltip = 0;
	iTooltipHeight = 0;

	ShowChange (iLocation, ascreen);
	while (iChanging == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							if (iOnTile != 0)
							{
								UseTile (iOnTile, iLocation, iCurRoom, 0);
								if ((iOnTile <= 72) || ((iOnTile <= (7 * 13))
									&& (iEditPoP == 2))) { iChanging = 0; }
								iChanged++;
							}
							break;
						case SDL_CONTROLLER_BUTTON_B:
							iChanging = 0; break;
						case SDL_CONTROLLER_BUTTON_X:
							switch (iEditPoP)
							{
								case 1:
									if (iGuardSkill < 11) { iGuardSkill++; }
										else { iGuardSkill = 0; }
									if (sGuardLocations[iCurRoom - 1] + 1 == iSelected)
									{
										sGuardSkills[iCurRoom - 1] = iGuardSkill;
										iChanged++;
									}
									PlaySound ("wav/check_box.wav");
									break;
								case 2:
									PlaySound ("wav/screen2or3.wav");
									ChangeGuards (screen);
									break;
								case 3:
									switch (iChangeStuck)
									{
										case 0: ChangePosAction ("harmful", iLocation); break;
										case 1: ChangePosAction ("harmless", iLocation); break;
										case 2: ChangePosAction ("no", iLocation); break;
									}
									break;
							}
							break;
						case SDL_CONTROLLER_BUTTON_Y:
							PlaySound ("wav/screen2or3.wav");
							iChanging = ChangePosCustom (iLocation, screen); break;
						case SDL_CONTROLLER_BUTTON_BACK:
							if (((iEditPoP == 2) && ((cCurType == 'r') ||
								(cCurType == 't'))) || (iEditPoP == 3))
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = ChangeBackground (iLocation, screen);
							}
							break;
						case SDL_CONTROLLER_BUTTON_START:
							if (iEditPoP == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = Kid (iLocation, screen);
								ShowChange (iLocation, ascreen); break;
							}
							if (iEditPoP == 2)
							{
								PlaySound ("wav/screen2or3.wav");
								ChangeMusic (screen);
							}
							if (iEditPoP == 3)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = PickTemplate (screen);
							}
							break;
						case SDL_CONTROLLER_BUTTON_LEFTSHOULDER:
							if (iEditPoP != 1)
							{
								iChangePercent--;
								if (iChangePercent == -1) { iChangePercent = 100; }
								PlaySound ("wav/plus_minus.wav");
								ApplyPercentIfNecessary (iLocation);
							}
							break;
						case SDL_CONTROLLER_BUTTON_RIGHTSHOULDER:
							if (iEditPoP != 1)
							{
								iChangePercent++;
								if (iChangePercent == 101) { iChangePercent = 0; }
								PlaySound ("wav/plus_minus.wav");
								ApplyPercentIfNecessary (iLocation);
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							ChangePosAction ("left", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							ChangePosAction ("right", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							ChangePosAction ("up", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							ChangePosAction ("down", iLocation); break;
						case SDL_CONTROLLER_BUTTON_GUIDE:
							if (cCurType == 'g')
								{ ChangePosAction ("marker", iLocation); }
							break;
					}
					ShowChange (iLocation, ascreen);
					break;
				case SDL_CONTROLLERAXISMOTION: /*** triggers and analog sticks ***/
					iXJoy1 = SDL_JoystickGetAxis (joystick, 0);
					iYJoy1 = SDL_JoystickGetAxis (joystick, 1);
					iXJoy2 = SDL_JoystickGetAxis (joystick, 3);
					iYJoy2 = SDL_JoystickGetAxis (joystick, 4);
					if ((iXJoy1 < -30000) || (iXJoy2 < -30000)) /*** left ***/
					{
						if ((SDL_GetTicks() - joyleft) > 300)
						{
							ChangeEvent (-1, 1);
							joyleft = SDL_GetTicks();
						}
					}
					if ((iXJoy1 > 30000) || (iXJoy2 > 30000)) /*** right ***/
					{
						if ((SDL_GetTicks() - joyright) > 300)
						{
							ChangeEvent (1, 1);
							joyright = SDL_GetTicks();
						}
					}
					if ((iYJoy1 < -30000) || (iYJoy2 < -30000)) /*** up ***/
					{
						if ((SDL_GetTicks() - joyup) > 300)
						{
							ChangeEvent (10, 1);
							joyup = SDL_GetTicks();
						}
					}
					if ((iYJoy1 > 30000) || (iYJoy2 > 30000)) /*** down ***/
					{
						if ((SDL_GetTicks() - joydown) > 300)
						{
							ChangeEvent (-10, 1);
							joydown = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERLEFT)
					{
						if ((SDL_GetTicks() - trigleft) > 300)
						{
							if (iEditPoP == 2)
							{
								iChangeJumps--;
								if (iChangeJumps == 0) { iChangeJumps = 4; }
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if (iEditPoP == 3) { ChangePosAction ("skill less", iLocation); }
							trigleft = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERRIGHT)
					{
						if ((SDL_GetTicks() - trigright) > 300)
						{
							if (iEditPoP == 2)
							{
								iChangeJumps++;
								if (iChangeJumps == 5) { iChangeJumps = 1; }
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if (iEditPoP == 3) { ChangePosAction ("skill more", iLocation); }
							trigright = SDL_GetTicks();
						}
					}
					ShowChange (iLocation, ascreen);
					break;
				case SDL_KEYDOWN:
					iTemp = 0;
					switch (event.key.keysym.sym)
					{
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								if ((iOnTile >= 1) && (
									((iOnTile <= 72) && (iEditPoP == 1)) ||
									((iOnTile <= (7 * 13)) && (iEditPoP == 2)) ||
									((iOnTile <= 48) && (iEditPoP == 3))
									))
								{
									for (iTemp2 = 1; iTemp2 <= iRooms; iTemp2++)
									{
										for (iTemp = 1; iTemp <= 30; iTemp++)
											{ UseTile (iOnTile, iTemp, iTemp2, 0); }
									}
									iChanging = 0;
									iChanged++;
								}
							} else if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								if ((iOnTile >= 1) && (
									((iOnTile <= 72) && (iEditPoP == 1)) ||
									((iOnTile <= (7 * 13)) && (iEditPoP == 2)) ||
									((iOnTile <= 48) && (iEditPoP == 3))
									))
								{
									for (iTemp = 1; iTemp <= 30; iTemp++)
										{ UseTile (iOnTile, iTemp, iCurRoom, 0); }
									iChanging = 0;
									iChanged++;
								}
							} else if (iOnTile != 0) {
								UseTile (iOnTile, iLocation, iCurRoom, 0);
								if (
									((iOnTile <= 72) && (iEditPoP == 1)) ||
									((iOnTile <= (7 * 13)) && (iEditPoP == 2)) ||
									((iOnTile <= 48) && (iEditPoP == 3))
									) { iChanging = 0; }
								iChanged++;
							}
							break;
						case SDLK_ESCAPE:
						case SDLK_q:
							iChanging = 0; break;
						case SDLK_c:
							if (cCurType == 'r')
							{
								switch (iChangeCrk)
								{
									case 1: iChangeCrk = 3; break;
									case 12: iChangeCrk = 0; break;
									case 2: case 13: case 14: case 15:
										printf ("[ WARN ] Strange crack value: %i\n",
											iChangeCrk);
										iChangeCrk = 1; break;
									default: iChangeCrk++; break;
								}
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							} else if (iEditPoP == 3) {
								/*** No PlaySound() here. ***/
								KidColors();
								ShowChange (iLocation, ascreen);
							} else {
								iChanging = 0;
							}
							break;
						case SDLK_0:
						case SDLK_KP_0:
							if ((iEditPoP == 1) && (iGuardSkill != 0))
								{ iGuardSkill = 0; iTemp = 1; } break;
						case SDLK_1:
						case SDLK_KP_1:
							if ((iEditPoP == 1) && (iGuardSkill != 1))
								{ iGuardSkill = 1; iTemp = 1; }
							if ((iEditPoP == 2) && (iChangeJumps != 1))
							{
								iChangeJumps = 1;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							break;
						case SDLK_2:
						case SDLK_KP_2:
							if ((iEditPoP == 1) && (iGuardSkill != 2))
								{ iGuardSkill = 2; iTemp = 1; }
							if ((iEditPoP == 2) && (iChangeJumps != 2))
							{
								iChangeJumps = 2;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							break;
						case SDLK_3:
						case SDLK_KP_3:
							if ((iEditPoP == 1) && (iGuardSkill != 3))
								{ iGuardSkill = 3; iTemp = 1; }
							if ((iEditPoP == 2) && (iChangeJumps != 3))
							{
								iChangeJumps = 3;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							break;
						case SDLK_4:
						case SDLK_KP_4:
							if ((iEditPoP == 1) && (iGuardSkill != 4))
								{ iGuardSkill = 4; iTemp = 1; }
							if ((iEditPoP == 2) && (iChangeJumps != 4))
							{
								iChangeJumps = 4;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							break;
						case SDLK_5:
						case SDLK_KP_5:
							if ((iEditPoP == 1) && (iGuardSkill != 5))
								{ iGuardSkill = 5; iTemp = 1; } break;
						case SDLK_6:
						case SDLK_KP_6:
							if ((iEditPoP == 1) && (iGuardSkill != 6))
								{ iGuardSkill = 6; iTemp = 1; } break;
						case SDLK_7:
						case SDLK_KP_7:
							if ((iEditPoP == 1) && (iGuardSkill != 7))
								{ iGuardSkill = 7; iTemp = 1; } break;
						case SDLK_8:
						case SDLK_KP_8:
							if ((iEditPoP == 1) && (iGuardSkill != 8))
								{ iGuardSkill = 8; iTemp = 1; } break;
						case SDLK_9:
						case SDLK_KP_9:
							if ((iEditPoP == 1) && (iGuardSkill != 9))
								{ iGuardSkill = 9; iTemp = 1; } break;
						case SDLK_a:
							if ((iEditPoP == 1) && (iGuardSkill != 10))
								{ iGuardSkill = 10; iTemp = 1; }
							if (cCurType == 'c')
							{
								iChangeWall++;
								if (iChangeWall == 3) { iChangeWall = 1; }
								PlaySound ("wav/check_box.wav");
								ApplyWallIfNecessary (iLocation);
							}
							if (cCurType == 't')
							{
								iChangeWall++;
								if (iChangeWall == 4) { iChangeWall = 1; }
								PlaySound ("wav/check_box.wav");
								ApplyWallIfNecessary (iLocation);
							}
							break;
						case SDLK_b:
							if ((iEditPoP == 1) && (iGuardSkill != 11))
								{ iGuardSkill = 11; iTemp = 1; }
							if (((iEditPoP == 2) && ((cCurType == 'r') ||
								(cCurType == 't'))) || (iEditPoP == 3))
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = ChangeBackground (iLocation, screen);
							}
							if ((iEditPoP == 2) && (cCurType == 'c'))
							{
								iChangeBot++;
								if (iChangeBot == 8) { iChangeBot = 0; }
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}
							break;
						case SDLK_f:
							if (iEditPoP == 2)
							{
								iChangeFrame++;
								if (iChangeFrame == 16) { iChangeFrame = 0; }
								PlaySound ("wav/plus_minus.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if (iEditPoP == 3)
								{ ChangePosAction ("harmful", iLocation); }
							break;
						case SDLK_g:
							if (iEditPoP == 2)
							{
								PlaySound ("wav/screen2or3.wav");
								ChangeGuards (screen);
							}
							break;
						case SDLK_j: /*** jumps ***/
							if (iEditPoP == 2)
							{
								iChangeJumps++;
								if (iChangeJumps == 5) { iChangeJumps = 1; }
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							break;
						case SDLK_l:
							if (iEditPoP == 3)
								{ ChangePosAction ("harmless", iLocation); }
							break;
						case SDLK_m:
							if (iEditPoP == 2)
							{
								PlaySound ("wav/screen2or3.wav");
								ChangeMusic (screen);
							}
							if (cCurType == 'g')
								{ ChangePosAction ("marker", iLocation); }
							break;
						case SDLK_n:
							if (iEditPoP == 3)
								{ ChangePosAction ("no", iLocation); }
							break;
						case SDLK_p:
							if (iEditPoP == 2)
							{
								iChangePercent++;
								if (iChangePercent == 101) { iChangePercent = 0; }
								PlaySound ("wav/plus_minus.wav");
								ApplyPercentIfNecessary (iLocation);
							}
							break;
						case SDLK_r:
							if (cCurType == 'r')
							{
								iChangeWall++;
								if (iChangeWall == 5) { iChangeWall = 1; }
								PlaySound ("wav/check_box.wav");
								ApplyWallIfNecessary (iLocation);
							}
							if (iEditPoP == 3)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = PickTemplate (screen);
								ShowChange (iLocation, ascreen);
							}
							break;
						case SDLK_s:
							if ((cCurType == 'd') || (cCurType == 'p'))
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = Kid (iLocation, screen);
								ShowChange (iLocation, ascreen); break;
							}
							if (cCurType == 'c')
							{
								iChangeStal++;
								if (iChangeStal == 8) { iChangeStal = 0; }
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}
							if (cCurType == 'r')
							{
								iChangeSym++;
								if (iChangeSym == 4) { iChangeSym = 0; }
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}
							break;
						case SDLK_LEFT:
							if (event.key.keysym.mod & KMOD_LCTRL)
							{
								ChangeEvent (-10, 1);
							} else if (event.key.keysym.mod & KMOD_RCTRL) {
								if (iEditPoP != 1)
								{
									if (iChangePercent > 0)
									{
										iChangePercent-=10;
										if (iChangePercent < 0) { iChangePercent = 0; }
										PlaySound ("wav/plus_minus.wav");
										ApplyPercentIfNecessary (iLocation);
									}
								} else {
									ChangeEvent (-10, 1);
								}
							} else if (event.key.keysym.mod & KMOD_LSHIFT) {
								ChangeEvent (-1, 1);
							} else if (event.key.keysym.mod & KMOD_RSHIFT) {
								if (iEditPoP != 1)
								{
									if (iChangePercent > 0)
									{
										iChangePercent--;
										PlaySound ("wav/plus_minus.wav");
										ApplyPercentIfNecessary (iLocation);
									}
								} else {
									ChangeEvent (-1, 1);
								}
							} else {
								ChangePosAction ("left", iLocation);
							}
							break;
						case SDLK_RIGHT:
							if (event.key.keysym.mod & KMOD_LCTRL)
							{
								ChangeEvent (10, 1);
							} else if (event.key.keysym.mod & KMOD_RCTRL) {
								if (iEditPoP != 1)
								{
									if (iChangePercent < 100)
									{
										iChangePercent+=10;
										if (iChangePercent > 100) { iChangePercent = 100; }
										PlaySound ("wav/plus_minus.wav");
										ApplyPercentIfNecessary (iLocation);
									}
								} else {
									ChangeEvent (10, 1);
								}
							} else if (event.key.keysym.mod & KMOD_LSHIFT) {
								ChangeEvent (1, 1);
							} else if (event.key.keysym.mod & KMOD_RSHIFT) {
								if (iEditPoP != 1)
								{
									if (iChangePercent < 100)
									{
										iChangePercent++;
										PlaySound ("wav/plus_minus.wav");
										ApplyPercentIfNecessary (iLocation);
									}
								} else {
									ChangeEvent (1, 1);
								}
							} else {
								ChangePosAction ("right", iLocation);
							}
							break;
						case SDLK_UP:
							ChangePosAction ("up", iLocation);
							break;
						case SDLK_DOWN:
							ChangePosAction ("down", iLocation);
							break;
						case SDLK_o:
							PlaySound ("wav/screen2or3.wav");
							iChanging = ChangePosCustom (iLocation, screen);
							ShowChange (iLocation, ascreen); break;
						case SDLK_LEFTBRACKET:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								if (iEditPoP == 3)
									{ ChangePosAction ("skill less", iLocation); }
							} else if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								if ((iEditPoP == 3) && (iGuardSkill > 0))
								{
									iGuardSkill-=10;
									if (iGuardSkill < 0) { iGuardSkill = 0; }
									PlaySound ("wav/plus_minus.wav");
									ApplySkillIfNecessary (iLocation);
								}
							} else {
								/*** Nothing for now. ***/
							}
							break;
						case SDLK_RIGHTBRACKET:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								if (iEditPoP == 3)
									{ ChangePosAction ("skill more", iLocation); }
							} else if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								if ((iEditPoP == 3) && (iGuardSkill < 255))
								{
									iGuardSkill+=10;
									if (iGuardSkill > 255) { iGuardSkill = 255; }
									PlaySound ("wav/plus_minus.wav");
									ApplySkillIfNecessary (iLocation);
								}
							} else {
								/*** Nothing for now. ***/
							}
							break;
						default: break;
					}
					if (iTemp == 1)
					{
						ApplySkillIfNecessary (iSelected);
						PlaySound ("wav/check_box.wav");
					}
					ShowChange (iLocation, ascreen);
					break;
				case SDL_MOUSEMOTION:
					iOldXPos = iXPos;
					iOldYPos = iYPos;
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if ((iOldXPos == iXPos) && (iOldYPos == iYPos)) { break; }

					/*** skill tooltip ***/
					if (iEditPoP == 3)
					{
						iSkillTooltipOld = iSkillTooltip;
						iSkillTooltip = 0;
						if (InArea (355, 419, 501, 449) == 1) { iSkillTooltip = 1; }
						if (iSkillTooltip != iSkillTooltipOld)
							{ ShowChange (iLocation, ascreen); }
					}

					/*** jaffar tooltip ***/
					if (cCurType == 'j')
					{
						iJaffarTooltipOld = iJaffarTooltip;
						iJaffarTooltip = 0;
						if (InArea (4, 4, 652, 258) == 1) { iJaffarTooltip = 1; }
						if (iJaffarTooltip != iJaffarTooltipOld)
							{ ShowChange (iLocation, ascreen); }
					}

					if (iEditPoP == 1)
					{
						if (InArea (530, 420, 530 + 121, 420 + 29) == 1)
						{
							if (iEventHover == 0)
								{ iEventHover = 1; ShowChange (iLocation, ascreen); }
						} else {
							if (iEventHover == 1)
								{ iEventHover = 0; ShowChange (iLocation, ascreen); }
						}
					}

					iNowOn = OnTile();
					if ((iOnTile != iNowOn) && (iNowOn != 0))
					{
						if (IsDisabled (iNowOn) == 0)
						{
							iOnTile = iNowOn;
							ShowChange (iLocation, ascreen);
						}
					}
					break;
				case SDL_MOUSEBUTTONDOWN: /*** ChangePos ***/
					if (event.button.button == 1) /*** left mouse button ***/
					{
						if (InArea (656, 0, 692, 387) == 1) /*** close ***/
						{
							if (iCloseOn != 1) { iCloseOn = 1; }
							ShowChange (iLocation, ascreen);
						}
						if (InArea (656, 387, 692, 455) == 1) /*** custom ***/
						{
							if (iCustomOn != 1) { iCustomOn = 1; }
							ShowChange (iLocation, ascreen);
						}
						if ((cCurType == 'r') || (cCurType == 't'))
						{
							if (InArea (254, 324, 402, 386) == 1) /*** background ***/
							{
								if (iBackgroundOn != 1) { iBackgroundOn = 1; }
								ShowChange (iLocation, ascreen);
							}
						}
						if (iEditPoP == 1)
						{
							if (InArea (354, 388, 354 + 48, 388 + 62) == 1) /*** kid ***/
							{
								if (iKidOn != 1) { iKidOn = 1; }
								ShowChange (iLocation, ascreen);
							}
						}
						if (iEditPoP == 2)
						{
							if (InArea (254, 388, 352, 450) == 1) /*** guards ***/
							{
								if (iGuardsOn != 1) { iGuardsOn = 1; }
								ShowChange (iLocation, ascreen);
							}
							if (InArea (637, 305, 651, 329) == 1) /*** music ***/
							{
								if (iMusicOn != 1) { iMusicOn = 1; }
								ShowChange (iLocation, ascreen);
							}
						}
						if (iEditPoP == 3)
						{
							if (InArea (504, 196, 652, 258) == 1) /*** background ***/
							{
								if (iBackgroundOn != 1) { iBackgroundOn = 1; }
								ShowChange (iLocation, ascreen);
							}
							if (InArea (454, 196, 502, 258) == 1) /*** templates ***/
							{
								if (iTemplatesOn != 1) { iTemplatesOn = 1; }
								ShowChange (iLocation, ascreen);
							}
							if (InArea (304, 324, 352, 386) == 1) /*** kid colors ***/
							{
								if (iColorsOn != 1) { iColorsOn = 1; }
								ShowChange (iLocation, ascreen);
							}
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseOn = 0;
					iBackgroundOn = 0;
					iTemplatesOn = 0;
					iColorsOn = 0;
					iKidOn = 0;
					iGuardsOn = 0;
					iCustomOn = 0;
					iMusicOn = 0;

					/*** On tile or human. ***/
					iUseTile = 0;
					if (((cCurType == 'd') || (cCurType == 'p')) &&
						((InArea (2, 2, 654, 388) == 1) ||
						(InArea (2, 386, 354, 452) == 1) ||
						(InArea (402, 386, 454, 452) == 1))) { iUseTile = 1; }
					if ((cCurType == 'o') &&
						((InArea (154, 48, 302, 110) == 1) ||
						(InArea (454, 48, 652, 110) == 1) ||
						(InArea (104, 122, 302, 184) == 1) ||
						(InArea (454, 122, 652, 184) == 1) ||
						(InArea (4, 196, 652, 258) == 1) ||
						(InArea (4, 260, 502, 386) == 1) ||
						(InArea (4, 388, 252, 450) == 1) ||
						(InArea (354, 388, 502, 450) == 1))) { iUseTile = 1; }
					if ((cCurType == 'c') &&
						((InArea (4, 4, 652, 258) == 1) ||
						(InArea (4, 260, 302, 322) == 1) ||
						(InArea (354, 388, 402, 450) == 1))) { iUseTile = 1; }
					if ((cCurType == 'r') &&
						((InArea (4, 4, 652, 258) == 1) ||
						(InArea (4, 260, 152, 322) == 1) ||
						(InArea (354, 388, 402, 450) == 1))) { iUseTile = 1; }
					if ((cCurType == 't') &&
						((InArea (4, 4, 652, 130) == 1) ||
						(InArea (254, 132, 652, 258) == 1) ||
						(InArea (254, 260, 302, 322) == 1) ||
						(InArea (354, 388, 402, 450) == 1))) { iUseTile = 1; }
					if ((iEditPoP == 3) &&
						((InArea (2, 2, 654, 196) == 1) ||
						(InArea (2, 194, 454, 260) == 1) ||
						(InArea (2, 258, 654, 324) == 1) ||
						(InArea (2, 322, 304, 388) == 1))) { iUseTile = 1; }

					if (event.button.button == 1) /*** left mouse button, tile ***/
					{
						if (iEditPoP == 1)
						{
							iTemp = 0;
							if (InArea (455, 420, 468, 433) == 1)
								if (iGuardSkill != 0) { iGuardSkill = 0; iTemp = 1; }
							if (InArea (470, 420, 483, 433) == 1)
								if (iGuardSkill != 1) { iGuardSkill = 1; iTemp = 1; }
							if (InArea (485, 420, 498, 433) == 1)
								if (iGuardSkill != 2) { iGuardSkill = 2; iTemp = 1; }
							if (InArea (500, 420, 513, 433) == 1)
								if (iGuardSkill != 3) { iGuardSkill = 3; iTemp = 1; }
							if (InArea (515, 420, 528, 433) == 1)
								if (iGuardSkill != 4) { iGuardSkill = 4; iTemp = 1; }
							if (InArea (455, 435, 468, 448) == 1)
								if (iGuardSkill != 5) { iGuardSkill = 5; iTemp = 1; }
							if (InArea (470, 435, 483, 448) == 1)
								if (iGuardSkill != 6) { iGuardSkill = 6; iTemp = 1; }
							if (InArea (485, 435, 498, 448) == 1)
								if (iGuardSkill != 7) { iGuardSkill = 7; iTemp = 1; }
							if (InArea (500, 435, 513, 448) == 1)
								if (iGuardSkill != 8) { iGuardSkill = 8; iTemp = 1; }
							if (InArea (515, 435, 528, 448) == 1)
								if (iGuardSkill != 9) { iGuardSkill = 9; iTemp = 1; }
							if (InArea (500, 405, 513, 418) == 1)
								if (iGuardSkill != 10) { iGuardSkill = 10; iTemp = 1; }
							if (InArea (515, 405, 528, 418) == 1)
								if (iGuardSkill != 11) { iGuardSkill = 11; iTemp = 1; }
							if (iTemp == 1)
							{
								ApplySkillIfNecessary (iSelected);
								PlaySound ("wav/check_box.wav");
							}
						}
						if (iEditPoP == 3)
						{
							iTemp = 0;
							if (PlusMinus (&iGuardSkill, 371, 424, 0, 255, -10, 0))
								{ iTemp = 1; }
							if (PlusMinus (&iGuardSkill, 386, 424, 0, 255, -1, 0))
								{ iTemp = 1; }
							if (PlusMinus (&iGuardSkill, 456, 424, 0, 255, 1, 0))
								{ iTemp = 1; }
							if (PlusMinus (&iGuardSkill, 471, 424, 0, 255, 10, 0))
								{ iTemp = 1; }
							if (iTemp == 1)
							{
								ApplySkillIfNecessary (iSelected);
								/*** No PlaySound here. ***/
							}
						}

						/*** Changing the event number. ***/
						if (iEditPoP == 1)
						{
							if (InArea (534, 424, 546, 444) == 1)
								{ ChangeEvent (-10, 1); }
							if (InArea (549, 424, 561, 444) == 1)
								{ ChangeEvent (-1, 1); }
							if (InArea (619, 424, 631, 444) == 1)
								{ ChangeEvent (1, 1); }
							if (InArea (634, 424, 646, 444) == 1)
								{ ChangeEvent (10, 1); }
						} else {
							if (InArea (521, 424, 534, 444) == 1)
								{ ChangeEvent (-10, 1); }
							if (InArea (536, 424, 549, 444) == 1)
								{ ChangeEvent (-1, 1); }
							if (InArea (606, 424, 619, 444) == 1)
								{ ChangeEvent (1, 1); }
							if (InArea (621, 424, 634, 444) == 1)
								{ ChangeEvent (10, 1); }
						}

						/*** On close: exit ChangePos. ***/
						if (InArea (656, 0, 692, 387) == 1) { iChanging = 0; }

						/*** On custom, mouse button up. ***/
						if (InArea (656, 387, 692, 455) == 1)
						{
							PlaySound ("wav/screen2or3.wav");
							iChanging = ChangePosCustom (iLocation, screen);
							ShowChange (iLocation, ascreen); break;
						}

						if (iEditPoP == 1)
						{
							/*** kid button ***/
							if (InArea (354, 388, 354 + 48, 388 + 62) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = Kid (iLocation, screen);
								ShowChange (iLocation, ascreen); break;
							}
						}

						if (iEditPoP == 2)
						{
							if (InArea (254, 388, 352, 450) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								ChangeGuards (screen);
								ShowChange (iLocation, ascreen); break;
							}
							if (InArea (637, 305, 651, 327) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								ChangeMusic (screen);
								ShowChange (iLocation, ascreen); break;
							}

							/*** jumps ***/
							if ((InArea (588, 265, 602, 279) == 1) &&
								(iChangeJumps != 1))
							{
								iChangeJumps = 1;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if ((InArea (603, 265, 617, 279) == 1) &&
								(iChangeJumps != 2))
							{
								iChangeJumps = 2;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if ((InArea (618, 265, 632, 279) == 1) &&
								(iChangeJumps != 3))
							{
								iChangeJumps = 3;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}
							if ((InArea (633, 265, 647, 279) == 1) &&
								(iChangeJumps != 4))
							{
								iChangeJumps = 4;
								PlaySound ("wav/check_box.wav");
								ApplyJumpsFrameIfNecessary (iLocation);
							}

							/*** alt wall ***/
							iWallChanged = 0;
							if (cCurType == 'c')
							{
								if ((InArea (618, 287, 632, 301) == 1) &&
									(iChangeWall != 1)) { iChangeWall = 1; iWallChanged = 1; }
								if ((InArea (633, 287, 647, 301) == 1) &&
									(iChangeWall != 2)) { iChangeWall = 2; iWallChanged = 1; }
							}
							if (cCurType == 'r')
							{
								if ((InArea (588, 287, 602, 301) == 1) &&
									(iChangeWall != 1)) { iChangeWall = 1; iWallChanged = 1; }
								if ((InArea (603, 287, 617, 301) == 1) &&
									(iChangeWall != 2)) { iChangeWall = 2; iWallChanged = 1; }
								if ((InArea (618, 287, 632, 301) == 1) &&
									(iChangeWall != 3)) { iChangeWall = 3; iWallChanged = 1; }
								if ((InArea (633, 287, 647, 301) == 1) &&
									(iChangeWall != 4)) { iChangeWall = 4; iWallChanged = 1; }
							}
							if (cCurType == 't')
							{
								if ((InArea (603, 287, 617, 301) == 1) &&
									(iChangeWall != 1)) { iChangeWall = 1; iWallChanged = 1; }
								if ((InArea (618, 287, 632, 301) == 1) &&
									(iChangeWall != 2)) { iChangeWall = 2; iWallChanged = 1; }
								if ((InArea (633, 287, 647, 301) == 1) &&
									(iChangeWall != 3)) { iChangeWall = 3; iWallChanged = 1; }
							}
							if (iWallChanged == 1)
							{
								PlaySound ("wav/check_box.wav");
								ApplyWallIfNecessary (iLocation);
							}

							/*** frame ***/
							if (PlusMinus (&iChangeFrame, 574, 307, 0, 15, -1, 0))
								{ ApplyJumpsFrameIfNecessary (iLocation); }
							if (PlusMinus (&iChangeFrame, 621, 307, 0, 15, 1, 0))
								{ ApplyJumpsFrameIfNecessary (iLocation); }

							/*** percent open ***/
							if (PlusMinus (&iChangePercent, 521, 364, 0, 100, -10, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 536, 364, 0, 100, -1, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 606, 364, 0, 100, 1, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 621, 364, 0, 100, 10, 0))
								{ ApplyPercentIfNecessary (iLocation); }
						}

						if (iEditPoP == 3)
						{
							/*** percent open ***/
							if (PlusMinus (&iChangePercent, 371, 360, 0, 100, -10, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 386, 360, 0, 100, -1, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 456, 360, 0, 100, 1, 0))
								{ ApplyPercentIfNecessary (iLocation); }
							if (PlusMinus (&iChangePercent, 471, 360, 0, 100, 10, 0))
								{ ApplyPercentIfNecessary (iLocation); }

							/*** background ***/
							if (InArea (504, 196, 652, 258) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = ChangeBackground (iLocation, screen);
								ShowChange (iLocation, ascreen); break;
							}

							/*** templates ***/
							if (InArea (454, 196, 502, 258) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = PickTemplate (screen);
								ShowChange (iLocation, ascreen); break;
							}

							/*** kid colors ***/
							if (InArea (304, 324, 352, 386) == 1)
							{
								/*** No PlaySound() here. ***/
								KidColors();
								ShowChange (iLocation, ascreen); break;
							}

							/*** stuck tile ***/
							if (InArea (163, 427, 177, 441) == 1)
								{ ChangePosAction ("no", iLocation); }
							if (InArea (206, 427, 220, 441) == 1)
								{ ChangePosAction ("harmful", iLocation); }
							if (InArea (278, 427, 292, 441) == 1)
								{ ChangePosAction ("harmless", iLocation); }

							/*** teleport marker ***/
							if (cCurType == 'g')
							{
								if (InArea (14, 427, 28, 441) == 1)
									{ ChangePosAction ("marker 0x0d", iLocation); }
								if (InArea (33, 427, 47, 441) == 1)
									{ ChangePosAction ("marker 0x11", iLocation); }
								if (InArea (52, 427, 66, 441) == 1)
									{ ChangePosAction ("marker 0x12", iLocation); }
								if (InArea (71, 427, 85, 441) == 1)
									{ ChangePosAction ("marker 0x14", iLocation); }
								if (InArea (90, 427, 104, 441) == 1)
									{ ChangePosAction ("marker 0x15", iLocation); }
								if (InArea (109, 427, 123, 441) == 1)
									{ ChangePosAction ("marker 0x16", iLocation); }
								if (InArea (128, 427, 142, 441) == 1)
									{ ChangePosAction ("marker 0x17", iLocation); }
							}
						}

						if ((cCurType == 'r') || (cCurType == 't'))
						{
							if (InArea (254, 324, 402, 386) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChanging = ChangeBackground (iLocation, screen);
								ShowChange (iLocation, ascreen); break;
							}
						}

						if (cCurType == 'c')
						{
							/*** stal ***/
							iMod2Ch = iChangeStal;
							if (InArea (231, 393, 245, 407) == 1) { iChangeStal = 0; }
							if (InArea (11, 347, 25, 361) == 1) { iChangeStal = 1; }
							if (InArea (67, 347, 81, 361) == 1) { iChangeStal = 2; }
							if (InArea (117, 347, 131, 361) == 1) { iChangeStal = 3; }
							if (InArea (185, 347, 199, 361) == 1) { iChangeStal = 4; }
							if (InArea (11, 393, 25, 407) == 1) { iChangeStal = 5; }
							if (InArea (95, 393, 109, 407) == 1) { iChangeStal = 6; }
							if (InArea (145, 393, 159, 407) == 1) { iChangeStal = 7; }
							if (iMod2Ch != iChangeStal)
							{
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}

							/*** bot ***/
							iMod2Ch = iChangeBot;
							if (InArea (411, 283, 425, 297) == 1) { iChangeBot = 0; }
							if (InArea (411, 304, 425, 318) == 1) { iChangeBot = 1; }
							if (InArea (411, 325, 425, 339) == 1) { iChangeBot = 2; }
							if (InArea (411, 346, 425, 360) == 1) { iChangeBot = 3; }
							if (InArea (411, 367, 425, 381) == 1) { iChangeBot = 4; }
							if (InArea (411, 388, 425, 402) == 1) { iChangeBot = 5; }
							if (InArea (411, 409, 425, 423) == 1) { iChangeBot = 6; }
							if (InArea (411, 430, 425, 444) == 1) { iChangeBot = 7; }
							if (iMod2Ch != iChangeBot)
							{
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}
						}

						if (cCurType == 'r')
						{
							/*** sym ***/
							iMod2Ch = iChangeSym;
							if (InArea (411, 429, 425, 443) == 1) { iChangeSym = 0; }
							if (InArea (411, 304, 425, 318) == 1) { iChangeSym = 1; }
							if (InArea (411, 362, 425, 376) == 1) { iChangeSym = 2; }
							if (InArea (411, 404, 425, 418) == 1) { iChangeSym = 3; }
							if (iMod2Ch != iChangeSym)
							{
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}

							/*** crk ***/
							iMod2Ch = iChangeCrk;
							if (InArea (231, 415, 245, 429) == 1) { iChangeCrk = 0; }
							if (InArea (11, 352, 25, 366) == 1) { iChangeCrk = 1; }
							if (InArea (115, 331, 129, 345) == 1) { iChangeCrk = 3; }
							if (InArea (161, 331, 175, 345) == 1) { iChangeCrk = 4; }
							if (InArea (202, 331, 216, 345) == 1) { iChangeCrk = 5; }
							if (InArea (11, 380, 25, 394) == 1) { iChangeCrk = 6; }
							if (InArea (85, 380, 99, 394) == 1) { iChangeCrk = 7; }
							if (InArea (85, 415, 99, 429) == 1) { iChangeCrk = 8; }
							if (InArea (11, 415, 25, 429) == 1) { iChangeCrk = 9; }
							if (InArea (143, 415, 157, 429) == 1) { iChangeCrk = 10; }
							if (InArea (143, 380, 157, 394) == 1) { iChangeCrk = 11; }
							if (InArea (231, 380, 245, 394) == 1) { iChangeCrk = 12; }
							if (iMod2Ch != iChangeCrk)
							{
								PlaySound ("wav/check_box.wav");
								UpdateMod2IfNecessary (iLocation);
							}
						}

						if (iUseTile == 1)
						{
							UseTile (iOnTile, iLocation, iCurRoom, 0);
							if (((iEditPoP != 2) && (iOnTile <= 72)) ||
								((iEditPoP == 2) && (iOnTile <= 91)))
							{
								iChanging = 0;
							}
							iChanged++;
						}
					}

					if (event.button.button == 2)
					{
						if ((iUseTile == 1) && (iOnTile >= 1) && (iOnTile <= 91))
						{
							for (iTemp = 1; iTemp <= 30; iTemp++)
							{
								UseTile (iOnTile, iTemp, iCurRoom, 0);
							}
							iChanging = 0;
							iChanged++;
						}
					}

					if (event.button.button == 3)
					{
						if ((iUseTile == 1) && (iOnTile >= 1) && (iOnTile <= 91))
						{
							for (iTemp2 = 1; iTemp2 <= iRooms; iTemp2++)
							{
								for (iTemp = 1; iTemp <= 30; iTemp++)
								{
									UseTile (iOnTile, iTemp, iTemp2, 0);
								}
							}
							iChanging = 0;
							iChanged++;
						}
					}

					ShowChange (iLocation, ascreen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowChange (iLocation, ascreen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}

		/*** tooltip ***/
		switch (iTooltip)
		{
			case 0:
				if (iTooltipHeight != 0)
				{
					iTooltipHeight = 0;
					ShowChange (iLocation, ascreen);
				}
				break;
			case 1:
				if (iTooltipHeight < 32)
				{
					switch (iTooltipHeight)
					{
						case 31: case 30: case 29: iTooltipHeight++; break;
						case 27: case 25: case 23: case 21: iTooltipHeight+=2; break;
						default: iTooltipHeight+=3; break;
					}
					ShowChange (iLocation, ascreen);
				}
				break;
		}
		PreventCPUEating();
	}
	PlaySound ("wav/ok_close.wav");
}
/*****************************************************************************/
void ChangePosCustomAction (char *sAction, int iLocation)
/*****************************************************************************/
{
	int iTemp;

	if (strcmp (sAction, "use") == 0)
	{
		if (iEditPoP != 3)
		{
			iTemp = 0;
			switch (iChangeForeRand)
			{
				case 0: break;
				case 1: iTemp+=64; break;
				case 2: iTemp+=128; break;
				case 3: iTemp+=192; break;
			}
			if (iChangeForeMod == 1) { iTemp+=32; }
			iTemp+=iChangeFore;
			SetLocation (iCurRoom, iLocation, iTemp, iChangeMod[1],
				iChangeMod[2], iChangeMod[3], iChangeMod[4]);
		} else {
			SetLocationSNES (iCurRoom, iLocation, iChangeBlock[1],
				iChangeBlock[2], iChangeBlock[3], iChangeBlock[4],
				iChangeMod[1], 0);
		}
	}
}
/*****************************************************************************/
int ChangePosCustom (int iLocation, SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iChanging;
	int iChangingCustom;
	int iTemp;
	int iArNr;
	int iXJoy1, iYJoy1, iXJoy2, iYJoy2;
	int iPlusMinus;

	iChanging = 1;
	iChangingCustom = 1;

	/*** Set iChangeForeRand, iChangeForeMod and iChangeFore. ***/
	if (iEditPoP != 3)
	{
		iTemp = iThingA[iCurRoom][iLocation - 1];
		iChangeForeRand = 0;
		if (iTemp >= 192) { iTemp-=192; iChangeForeRand = 3; }
		if (iTemp >= 128) { iTemp-=128; iChangeForeRand = 2; }
		if (iTemp >= 64) { iTemp-=64; iChangeForeRand = 1; }
		if (iTemp >= 32) { iTemp-=32; iChangeForeMod = 1; }
			else { iChangeForeMod = 0; }
		iChangeFore = iTemp;
	}

	/*** Set iChangeBlock[]. ***/
	if (iEditPoP == 3)
	{
		iChangeBlock[1] = iBlock1A[iCurRoom][iLocation - 1];
		iChangeBlock[2] = iBlock2A[iCurRoom][iLocation - 1];
		iChangeBlock[3] = iBlock3A[iCurRoom][iLocation - 1];
		iChangeBlock[4] = iBlock4A[iCurRoom][iLocation - 1];
	}

	/*** Set iChangeMod. ***/
	for (iArNr = 1; iArNr <= 4; iArNr++)
	{
		iTemp = iModifierA[iCurRoom][iLocation - 1][iArNr];
		if (iTemp == -1) { iTemp = 255; }
		iChangeMod[iArNr] = iTemp;
	}

	ShowChangeCustom (screen);
	while (iChangingCustom == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							ChangePosCustomAction ("use", iLocation);
							iChanged++;
							iChangingCustom = 0;
							iChanging = 0;
							break;
						case SDL_CONTROLLER_BUTTON_B:
							iChangingCustom = 0; break;
						case SDL_CONTROLLER_BUTTON_X:
							if (iEditPoP != 3)
							{
								if (iChangeForeRand < 3) { iChangeForeRand++; }
									else { iChangeForeRand = 0; }
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_Y:
							if (iEditPoP != 3)
							{
								if (iChangeForeMod != 0) { iChangeForeMod = 0; }
									else { iChangeForeMod = 1; }
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_BACK:
							if ((iEditPoP == 1) && (iUsesNative != 0))
							{
								PlaySound ("wav/screen2or3.wav");
								iChangingCustom = Native (iLocation, screen, 1);
								if (iChangingCustom == 0) { iChanging = 0; }
							}
							if (iEditPoP == 2)
							{
								ChangeCustom (-1, 2, 3);
							}
							if (iEditPoP == 3)
							{
								switch (iChangeBlock[4])
								{
									case 0x00: iChangeBlock[4] = 0x02; break;
									case 0x01: iChangeBlock[4] = 0x00; break;
									case 0x02: iChangeBlock[4] = 0x01; break;
									default: iChangeBlock[4] = 0x00; break;
								}
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_START:
							if (iEditPoP == 2)
							{
								ChangeCustom (1, 2, 3);
							}
							if (iEditPoP == 3)
							{
								switch (iChangeBlock[4])
								{
									case 0x00: iChangeBlock[4] = 0x01; break;
									case 0x01: iChangeBlock[4] = 0x02; break;
									case 0x02: iChangeBlock[4] = 0x00; break;
									default: iChangeBlock[4] = 0x02; break;
								}
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_LEFTSHOULDER:
							if (iEditPoP != 3)
							{
								ChangeCustom (-1, 1, 1);
							} else {
								ChangeCustom (-1, 1, 3);
							}
							break;
						case SDL_CONTROLLER_BUTTON_RIGHTSHOULDER:
							if (iEditPoP != 3)
							{
								ChangeCustom (1, 1, 1);
							} else {
								ChangeCustom (1, 1, 3);
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							if (iEditPoP == 2)
							{
								ChangeCustom (-1, 2, 2);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (-1, 1, 1);
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							if (iEditPoP == 2)
							{
								ChangeCustom (1, 2, 2);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (1, 1, 1);
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							if (iEditPoP == 2)
							{
								ChangeCustom (10, 2, 2);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (10, 1, 1);
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							if (iEditPoP == 2)
							{
								ChangeCustom (-10, 2, 2);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (-10, 1, 1);
							}
							break;
					}
					ShowChangeCustom (screen);
					break;
				case SDL_CONTROLLERAXISMOTION: /*** triggers and analog sticks ***/
					iXJoy1 = SDL_JoystickGetAxis (joystick, 0);
					iYJoy1 = SDL_JoystickGetAxis (joystick, 1);
					iXJoy2 = SDL_JoystickGetAxis (joystick, 3);
					iYJoy2 = SDL_JoystickGetAxis (joystick, 4);
					if ((iXJoy1 < -30000) || (iXJoy2 < -30000)) /*** left ***/
					{
						if ((SDL_GetTicks() - joyleft) > 300)
						{
							ChangeCustom (-1, 2, 1);
							joyleft = SDL_GetTicks();
						}
					}
					if ((iXJoy1 > 30000) || (iXJoy2 > 30000)) /*** right ***/
					{
						if ((SDL_GetTicks() - joyright) > 300)
						{
							ChangeCustom (1, 2, 1);
							joyright = SDL_GetTicks();
						}
					}
					if ((iYJoy1 < -30000) || (iYJoy2 < -30000)) /*** up ***/
					{
						if ((SDL_GetTicks() - joyup) > 300)
						{
							ChangeCustom (10, 2, 1);
							joyup = SDL_GetTicks();
						}
					}
					if ((iYJoy1 > 30000) || (iYJoy2 > 30000)) /*** down ***/
					{
						if ((SDL_GetTicks() - joydown) > 300)
						{
							ChangeCustom (-10, 2, 1);
							joydown = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERLEFT)
					{
						if ((SDL_GetTicks() - trigleft) > 300)
						{
							if (iEditPoP == 2)
							{
								ChangeCustom (-1, 2, 4);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (-1, 1, 2);
							}
							trigleft = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERRIGHT)
					{
						if ((SDL_GetTicks() - trigright) > 300)
						{
							if (iEditPoP == 2)
							{
								ChangeCustom (1, 2, 4);
							}
							if (iEditPoP == 3)
							{
								ChangeCustom (1, 1, 2);
							}
							trigright = SDL_GetTicks();
						}
					}
					ShowChangeCustom (screen);
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							ChangePosCustomAction ("use", iLocation);
							iChanged++;
							iChangingCustom = 0;
							iChanging = 0;
							break;
						case SDLK_f:
							if ((iEditPoP == 3) && (iChangeBlock[4] != 0x01))
							{
								iChangeBlock[4] = 0x01;
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDLK_n:
							if ((iEditPoP != 3) && (iChangeForeMod != 0))
							{
								iChangeForeMod = 0;
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDLK_s:
							if ((iEditPoP == 3) && (iChangeBlock[4] != 0x00))
							{
								iChangeBlock[4] = 0x00;
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDLK_w:
							if ((iEditPoP == 3) && (iChangeBlock[4] != 0x02))
							{
								iChangeBlock[4] = 0x02;
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDLK_x:
							if ((iEditPoP == 1) && (iUsesNative != 0))
							{
								PlaySound ("wav/screen2or3.wav");
								iChangingCustom = Native (iLocation, screen, 1);
								if (iChangingCustom == 0) { iChanging = 0; }
							}
							break;
						case SDLK_y:
							if ((iEditPoP != 3) && (iChangeForeMod != 1))
							{
								iChangeForeMod = 1;
								PlaySound ("wav/check_box.wav");
							}
							break;
						case SDLK_ESCAPE:
						case SDLK_q:
						case SDLK_c:
							iChangingCustom = 0; break;
						case SDLK_0:
						case SDLK_KP_0:
							if ((iEditPoP != 3) && (iChangeForeRand != 0))
								{ iChangeForeRand = 0; PlaySound ("wav/check_box.wav"); }
							break;
						case SDLK_1:
						case SDLK_KP_1:
							if ((iEditPoP != 3) && (iChangeForeRand != 1))
								{ iChangeForeRand = 1; PlaySound ("wav/check_box.wav"); }
							break;
						case SDLK_2:
						case SDLK_KP_2:
							if ((iEditPoP != 3) && (iChangeForeRand != 2))
								{ iChangeForeRand = 2; PlaySound ("wav/check_box.wav"); }
							break;
						case SDLK_3:
						case SDLK_KP_3:
							if ((iEditPoP != 3) && (iChangeForeRand != 3))
								{ iChangeForeRand = 3; PlaySound ("wav/check_box.wav"); }
							break;
						case SDLK_LEFT:
							if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								ChangeCustom (-10, 2, 1);
							} else if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								ChangeCustom (-1, 2, 1);
							} else {
								if (iEditPoP != 3)
								{
									ChangeCustom (-1, 1, 1);
								} else {
									ChangeCustom (-1, 1, 3);
								}
							}
							break;
						case SDLK_RIGHT:
							if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								ChangeCustom (10, 2, 1);
							} else if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								ChangeCustom (1, 2, 1);
							} else {
								if (iEditPoP != 3)
								{
									ChangeCustom (1, 1, 1);
								} else {
									ChangeCustom (1, 1, 3);
								}
							}
							break;
						default: break;
					}
					ShowChangeCustom (screen);
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (656, 0, 692, 387) == 1) /*** close ***/
						{
							if (iCloseCustomOn != 1) { iCloseCustomOn = 1; }
							ShowChangeCustom (screen);
						}
						if (InArea (656, 387, 692, 455) == 1) /*** use ***/
						{
							if (iCustomUseOn != 1) { iCustomUseOn = 1; }
							ShowChangeCustom (screen);
						}
						if (InArea (275, 14, 381, 147) == 1) /*** native ***/
						{
							if (iNativeOn != 1) { iNativeOn = 1; }
							ShowChangeCustom (screen);
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseCustomOn = 0;
					iCustomUseOn = 0;
					iNativeOn = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						/*** foreground random ***/
						if (iEditPoP != 3)
						{
							iTemp = 0;
							if (InArea (33, 114, 46, 127) == 1)
								if (iChangeForeRand != 0) { iChangeForeRand = 0; iTemp = 1; }
							if (InArea (48, 114, 61, 127) == 1)
								if (iChangeForeRand != 1) { iChangeForeRand = 1; iTemp = 1; }
							if (InArea (63, 114, 76, 127) == 1)
								if (iChangeForeRand != 2) { iChangeForeRand = 2; iTemp = 1; }
							if (InArea (78, 114, 91, 127) == 1)
								if (iChangeForeRand != 3) { iChangeForeRand = 3; iTemp = 1; }
							if (iTemp == 1) { PlaySound ("wav/check_box.wav"); }
						}

						/*** foreground mod ***/
						if (iEditPoP != 3)
						{
							if ((InArea (114, 114, 127, 127) == 1) &&
								(iChangeForeMod != 0))
							{
								iChangeForeMod = 0;
								PlaySound ("wav/check_box.wav");
							}
							if ((InArea (129, 114, 142, 127) == 1) &&
								(iChangeForeMod != 1))
							{
								iChangeForeMod = 1;
								PlaySound ("wav/check_box.wav");
							}
						}

						if (iEditPoP == 3)
						{
							/*** fore ***/
							if (InArea (32, 109, 32 + 13, 109 + 20) == 1)
								{ ChangeCustom (-16, 1, 1); }
							if (InArea (47, 109, 47 + 13, 109 + 20) == 1)
								{ ChangeCustom (-1, 1, 1); }
							if (InArea (117, 109, 117 + 13, 109 + 20) == 1)
								{ ChangeCustom (1, 1, 1); }
							if (InArea (132, 109, 132 + 13, 109 + 20) == 1)
								{ ChangeCustom (16, 1, 1); }

							/*** back ***/
							if (InArea (32, 57, 32 + 13, 57 + 20) == 1)
								{ ChangeCustom (-16, 1, 2); }
							if (InArea (47, 57, 47 + 13, 57 + 20) == 1)
								{ ChangeCustom (-1, 1, 2); }
							if (InArea (117, 57, 117 + 13, 57 + 20) == 1)
								{ ChangeCustom (1, 1, 2); }
							if (InArea (132, 57, 132 + 13, 57 + 20) == 1)
								{ ChangeCustom (16, 1, 2); }

							/*** object ***/
							if (InArea (164, 57, 164 + 13, 57 + 20) == 1)
								{ ChangeCustom (-1, 1, 3); }
							if (InArea (234, 57, 234 + 13, 57 + 20) == 1)
								{ ChangeCustom (1, 1, 3); }
						}

						if (iEditPoP != 3)
						{
							/*** foreground code ***/
							if (InArea (164, 109, 164 + 13, 109 + 20) == 1)
							{
								ChangeCustom (-1, 1, 1);
							}
							if (InArea (234, 109, 234 + 13, 109 + 20) == 1)
							{
								ChangeCustom (1, 1, 1);
							}
						} else {
							/*** attributes ***/
							iTemp = 0;
							if (InArea (183, 114, 183 + 14, 114 + 14) == 1)
								if (iChangeBlock[4] != 0x00)
								{ iChangeBlock[4] = 0x00; iTemp = 1; }
							if (InArea (198, 114, 198 + 14, 114 + 14) == 1)
								if (iChangeBlock[4] != 0x01)
								{ iChangeBlock[4] = 0x01; iTemp = 1; }
							if (InArea (213, 114, 213 + 14, 114 + 14) == 1)
								if (iChangeBlock[4] != 0x02)
								{ iChangeBlock[4] = 0x02; iTemp = 1; }
							if (iTemp == 1) { PlaySound ("wav/check_box.wav"); }
						}

						/*** modifier code 1 ***/
						if (iEditPoP != 3) { iPlusMinus = 10; } else { iPlusMinus = 16; }
						if (InArea (409, 109, 409 + 13, 109 + 20) == 1)
							{ ChangeCustom (0 - iPlusMinus, 2, 1); }
						if (InArea (424, 109, 424 + 13, 109 + 20) == 1)
							{ ChangeCustom (-1, 2, 1); }
						if (InArea (494, 109, 494 + 13, 109 + 20) == 1)
							{ ChangeCustom (1, 2, 1); }
						if (InArea (509, 109, 509 + 13, 109 + 20) == 1)
							{ ChangeCustom (iPlusMinus, 2, 1); }

						if (iEditPoP == 2)
						{
							/*** modifier code 2 ***/
							if (InArea (521, 22, 533, 41) == 1)
								{ ChangeCustom (-10, 2, 2); }
							if (InArea (536, 22, 548, 41) == 1)
								{ ChangeCustom (-1, 2, 2); }
							if (InArea (606, 22, 618, 41) == 1)
								{ ChangeCustom (1, 2, 2); }
							if (InArea (621, 22, 633, 41) == 1)
								{ ChangeCustom (10, 2, 2); }

							/*** modifier code 3 ***/
							if (InArea (521, 45, 533, 64) == 1)
								{ ChangeCustom (-10, 2, 3); }
							if (InArea (536, 45, 548, 64) == 1)
								{ ChangeCustom (-1, 2, 3); }
							if (InArea (606, 45, 618, 64) == 1)
								{ ChangeCustom (1, 2, 3); }
							if (InArea (621, 45, 633, 64) == 1)
								{ ChangeCustom (10, 2, 3); }

							/*** modifier code 4 ***/
							if (InArea (521, 68, 533, 87) == 1)
								{ ChangeCustom (-10, 2, 4); }
							if (InArea (536, 68, 548, 87) == 1)
								{ ChangeCustom (-1, 2, 4); }
							if (InArea (606, 68, 618, 87) == 1)
								{ ChangeCustom (1, 2, 4); }
							if (InArea (621, 68, 633, 87) == 1)
								{ ChangeCustom (10, 2, 4); }
						}

						/*** CLOSE ***/
						if (InArea (656, 0, 692, 387) == 1)
							{ iChangingCustom = 0; }

						/*** USE ***/
						if (InArea (656, 387, 692, 455) == 1)
						{
							ChangePosCustomAction ("use", iLocation);
							iChanged++;
							iChangingCustom = 0;
							iChanging = 0;
						}

						/*** native ***/
						if (iUsesNative != 0)
						{
							if (InArea (275, 14, 381, 147) == 1)
							{
								PlaySound ("wav/screen2or3.wav");
								iChangingCustom = Native (iLocation, screen, 1);
								if (iChangingCustom == 0) { iChanging = 0; }
							}
						}
					}

					ShowChangeCustom (screen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowChangeCustom (screen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	if (iChanging == 1) { PlaySound ("wav/ok_close.wav"); }

	return (iChanging);
}
/*****************************************************************************/
void ApplyNewGuardType (int iGuardNr, int iGuardType)
/*****************************************************************************/
{
	switch (iGuardType)
	{
		case 1: /*** black guard ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 0;
			iStaticGuards_10_Colors[iCurRoom - 1][iGuardNr] = 1;
			break;
		case 2: /*** blue guard ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 0;
			iStaticGuards_10_Colors[iCurRoom - 1][iGuardNr] = 2;
			break;
		case 3: /*** red guard ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 0;
			iStaticGuards_10_Colors[iCurRoom - 1][iGuardNr] = 3;
			break;
		case 4: /*** skeleton wakes up; wobbly if jump ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 2;
			iStaticGuards_18_SkelAct1[iCurRoom - 1][iGuardNr] = 0;
			iStaticGuards_19_SkelAct2[iCurRoom - 1][iGuardNr] = 0;
			break;
		case 5: /*** skeleton already awake ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 2;
			iStaticGuards_18_SkelAct1[iCurRoom - 1][iGuardNr] = 1;
			iStaticGuards_19_SkelAct2[iCurRoom - 1][iGuardNr] = 0;
			break;
		case 6: /*** skeleton only sleeps ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 2;
			iStaticGuards_18_SkelAct1[iCurRoom - 1][iGuardNr] = 255;
			iStaticGuards_19_SkelAct2[iCurRoom - 1][iGuardNr] = 255;
			break;
		case 7: /*** skeleton wakes up; NOT wobbly if jump ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 2;
			iStaticGuards_18_SkelAct1[iCurRoom - 1][iGuardNr] = 255;
			iStaticGuards_19_SkelAct2[iCurRoom - 1][iGuardNr] = 0;
			break;
		case 8: /*** head, long hair ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 5;
			break;
		case 9: /*** head, short hair ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 6;
			break;
		case 10: /*** snake ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 8;
			break;
		case 11: /*** birdman ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 7;
			break;
		case 12: /*** sword ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 1;
			break;
		case 13: /*** fake prince ***/
			iStaticGuards_16_Type[iCurRoom - 1][iGuardNr] = 3;
			break;
		default: printf ("[ WARN ] Unknown iGuardType.\n"); break;
	}
}
/*****************************************************************************/
void ChangeGuards (SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iChangingGuards;
	int iGuardType;
	int iGuardY;
	int iGuardNrDir;
	int iGuardNr;
	int iGuardDir;
	int iGuardX;
	int iRowGuard, iRowTo;
	int iEntryGuard, iRow, iColumn;
	int iTempCoor;
	int iXJoy1, iYJoy1, iXJoy2, iYJoy2;

	iChangingGuards = 1;

	ShowChangeGuards (screen);
	while (iChangingGuards == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							iStaticGuards_4_Directions[iCurRoom - 1][iEditGuardNr] =
								iEditGuardDir;
							ApplyNewGuardType (iEditGuardNr, iEditGuardType);
							iChanged++;
							PlaySound ("wav/check_box.wav");
							break;
						case SDL_CONTROLLER_BUTTON_B:
							iChangingGuards = 0; break;
						case SDL_CONTROLLER_BUTTON_X:
							if (iStaticGuards_Amount[iCurRoom - 1] < 5)
								{ iStaticGuards_Amount[iCurRoom - 1]++; }
									else { iStaticGuards_Amount[iCurRoom - 1] = 0; }
							iChanged++; PlaySound ("wav/check_box.wav");
							break;
						case SDL_CONTROLLER_BUTTON_Y:
							if (iDynamicGuards_Sets[iCurRoom - 1] < 2)
								{ iDynamicGuards_Sets[iCurRoom - 1]++; }
									else { iDynamicGuards_Sets[iCurRoom - 1] = 0; }
							iChanged++; PlaySound ("wav/check_box.wav");
							break;
						case SDL_CONTROLLER_BUTTON_BACK:
							if (iStaticGuards_5_Skills[iCurRoom - 1][iEditGuardNr] > 0)
							{
								iStaticGuards_5_Skills[iCurRoom - 1][iEditGuardNr]--;
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_GUIDE:
							if (iStaticGuards_1_Locations[iCurRoom - 1][iEditGuardNr] < 10)
							{
								iStaticGuards_1_Locations[iCurRoom - 1][iEditGuardNr] = 10;
							} else if ((iStaticGuards_1_Locations[iCurRoom - 1]
								[iEditGuardNr] >= 10) &&
								(iStaticGuards_1_Locations[iCurRoom - 1][iEditGuardNr] < 20))
							{
								iStaticGuards_1_Locations[iCurRoom - 1][iEditGuardNr] = 20;
							} else {
								iStaticGuards_1_Locations[iCurRoom - 1][iEditGuardNr] = 0;
							}
							iChanged++;
							PlaySound ("wav/hum_adj.wav");
							break;
						case SDL_CONTROLLER_BUTTON_START:
							if (iStaticGuards_5_Skills[iCurRoom - 1][iEditGuardNr] < 255)
							{
								iStaticGuards_5_Skills[iCurRoom - 1][iEditGuardNr]++;
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_LEFTSHOULDER:
							if (iDynamicGuards_Skill[iCurRoom - 1] > 0)
							{
								iDynamicGuards_Skill[iCurRoom - 1]--;
								iChanged++; PlaySound ("wav/plus_minus.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_RIGHTSHOULDER:
							if (iDynamicGuards_Skill[iCurRoom - 1] < 255)
							{
								iDynamicGuards_Skill[iCurRoom - 1]++;
								iChanged++; PlaySound ("wav/plus_minus.wav");
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							if (iEditGuardDir == 0) /*** right ***/
							{
								iEditGuardDir = 255;
							} else { /*** left ***/
								iEditGuardDir = 0;
								iEditGuardNr--;
								if (iEditGuardNr == -1) { iEditGuardNr = 4; }
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							if (iEditGuardDir == 255) /*** left ***/
							{
								iEditGuardDir = 0;
							} else { /*** right ***/
								iEditGuardDir = 255;
								iEditGuardNr++;
								if (iEditGuardNr == 5) { iEditGuardNr = 0; }
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							iEditGuardType--;
							if (iEditGuardType == 0) { iEditGuardType = 13; }
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							iEditGuardType++;
							if (iEditGuardType == 14) { iEditGuardType = 1; }
							break;
					}
					ShowChangeGuards (screen);
					break;
				case SDL_CONTROLLERAXISMOTION: /*** triggers and analog sticks ***/
					iXJoy1 = SDL_JoystickGetAxis (joystick, 0);
					iYJoy1 = SDL_JoystickGetAxis (joystick, 1);
					iXJoy2 = SDL_JoystickGetAxis (joystick, 3);
					iYJoy2 = SDL_JoystickGetAxis (joystick, 4);
					if ((iXJoy1 < -30000) || (iXJoy2 < -30000)) /*** left ***/
					{
						if ((SDL_GetTicks() - joyleft) > 300)
						{
							iTempCoor = IntsToHexToSSLittleEndian
								(iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
								iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
							if (iTempCoor > 0)
							{
								iTempCoor--;
								SSLittleEndianToHexToInts (iTempCoor,
									&iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
									&iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							joyleft = SDL_GetTicks();
						}
					}
					if ((iXJoy1 > 30000) || (iXJoy2 > 30000)) /*** right ***/
					{
						if ((SDL_GetTicks() - joyright) > 300)
						{
							iTempCoor = IntsToHexToSSLittleEndian
								(iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
								iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
							if (iTempCoor < 608)
							{
								iTempCoor++;
								SSLittleEndianToHexToInts (iTempCoor,
									&iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
									&iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							joyright = SDL_GetTicks();
						}
					}
					if ((iYJoy1 < -30000) || (iYJoy2 < -30000)) /*** up ***/
					{
						if ((SDL_GetTicks() - joyup) > 300)
						{
							iTempCoor = IntsToHexToSSLittleEndian
								(iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
								iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
							if (iTempCoor < 608)
							{
								iTempCoor+=10; if (iTempCoor > 608) { iTempCoor = 608; }
								SSLittleEndianToHexToInts (iTempCoor,
									&iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
									&iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							joyup = SDL_GetTicks();
						}
					}
					if ((iYJoy1 > 30000) || (iYJoy2 > 30000)) /*** down ***/
					{
						if ((SDL_GetTicks() - joydown) > 300)
						{
							iTempCoor = IntsToHexToSSLittleEndian
								(iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
								iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
							if (iTempCoor > 0)
							{
								iTempCoor-=10; if (iTempCoor < 0) { iTempCoor = 0; }
								SSLittleEndianToHexToInts (iTempCoor,
									&iStaticGuards_3_Offsets2[iCurRoom - 1][iEditGuardNr],
									&iStaticGuards_2_Offsets1[iCurRoom - 1][iEditGuardNr]);
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							joydown = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERLEFT)
					{
						if ((SDL_GetTicks() - trigleft) > 300)
						{
							if (iStaticGuards_17_Hitpoints[iCurRoom - 1][iEditGuardNr] > 0)
							{
								iStaticGuards_17_Hitpoints[iCurRoom - 1][iEditGuardNr]--;
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							trigleft = SDL_GetTicks();
						}
					}
					if (event.caxis.axis == SDL_CONTROLLER_AXIS_TRIGGERRIGHT)
					{
						if ((SDL_GetTicks() - trigright) > 300)
						{
							if (iStaticGuards_17_Hitpoints[iCurRoom - 1][iEditGuardNr] < 128)
							{
								iStaticGuards_17_Hitpoints[iCurRoom - 1][iEditGuardNr]++;
								iChanged++;
								PlaySound ("wav/plus_minus.wav");
							}
							trigright = SDL_GetTicks();
						}
					}
					ShowChangeGuards (screen);
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							iChangingGuards = 0; break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							iStaticGuards_4_Directions[iCurRoom - 1][iEditGuardNr] =
								iEditGuardDir;
							ApplyNewGuardType (iEditGuardNr, iEditGuardType);
							iChanged++;
							PlaySound ("wav/check_box.wav");
							break;
						case SDLK_LEFT:
							if (iEditGuardDir == 0) /*** right ***/
							{
								iEditGuardDir = 255;
							} else { /*** left ***/
								iEditGuardDir = 0;
								iEditGuardNr--;
								if (iEditGuardNr == -1) { iEditGuardNr = 4; }
							}
							break;
						case SDLK_RIGHT:
							if (iEditGuardDir == 255) /*** left ***/
							{
								iEditGuardDir = 0;
							} else { /*** right ***/
								iEditGuardDir = 255;
								iEditGuardNr++;
								if (iEditGuardNr == 5) { iEditGuardNr = 0; }
							}
							break;
						case SDLK_UP:
							iEditGuardType--;
							if (iEditGuardType == 0) { iEditGuardType = 13; }
							break;
						case SDLK_DOWN:
							iEditGuardType++;
							if (iEditGuardType == 14) { iEditGuardType = 1; }
							break;
						default: break;
					}
					ShowChangeGuards (screen);
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;

					/*** X-coordinate tooltip ***/
					iGuardTooltipOld = iGuardTooltip;
					iGuardTooltip = 0;
					if (InArea (290, 119, 403, 152) == 1)
						{ iGuardTooltip = 1; }
					if (InArea (408, 119, 521, 152) == 1)
						{ iGuardTooltip = 2; }
					if (InArea (526, 119, 639, 152) == 1)
						{ iGuardTooltip = 3; }
					if (InArea (290, 260, 403, 293) == 1)
						{ iGuardTooltip = 4; }
					if (InArea (408, 260, 521, 293) == 1)
						{ iGuardTooltip = 5; }
					if (iGuardTooltip != iGuardTooltipOld)
						{ ShowChangeGuards (screen); }
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (656, 0, 692, 455) == 1) /*** close ***/
						{
							if (iCloseGuardsOn != 1) { iCloseGuardsOn = 1; }
							ShowChangeGuards (screen);
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseGuardsOn = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						/*** guards in room ***/
						if (InArea (544, 191, 556, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 0;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (559, 191, 571, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (573, 191, 587, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (588, 191, 602, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 3;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (603, 191, 617, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 4;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (618, 191, 632, 205) == 1)
						{
							iStaticGuards_Amount[iCurRoom - 1] = 5;
							iChanged++; PlaySound ("wav/check_box.wav");
						}

						/*** incoming sets ***/
						if (InArea (566, 233, 580, 247) == 1)
						{
							iDynamicGuards_Sets[iCurRoom - 1] = 0;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (581, 233, 595, 247) == 1)
						{
							iDynamicGuards_Sets[iCurRoom - 1] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (596, 233, 610, 247) == 1)
						{
							iDynamicGuards_Sets[iCurRoom - 1] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}

						/*** incoming skill ***/
						PlusMinus (&iDynamicGuards_Skill[iCurRoom - 1],
							546, 271, 0, 255, -1, 1);
						PlusMinus (&iDynamicGuards_Skill[iCurRoom - 1],
							616, 271, 0, 255, +1, 1);

						/*** rows ***/
						iRowGuard = -1;
						iRowTo = -1;
						/*** row 1st ***/
						if (InArea (366, 18, 366 + ROWW, 18 + ROWH) == 1)
							{ iRowGuard = 0; iRowTo = 0; }
						if (InArea (366, 25, 366 + ROWW, 25 + ROWH) == 1)
							{ iRowGuard = 0; iRowTo = 10; }
						if (InArea (366, 32, 366 + ROWW, 32 + ROWH) == 1)
							{ iRowGuard = 0; iRowTo = 20; }
						/*** row 2nd ***/
						if (InArea (484, 18, 484 + ROWW, 18 + ROWH) == 1)
							{ iRowGuard = 1; iRowTo = 0; }
						if (InArea (484, 25, 484 + ROWW, 25 + ROWH) == 1)
							{ iRowGuard = 1; iRowTo = 10; }
						if (InArea (484, 32, 484 + ROWW, 32 + ROWH) == 1)
							{ iRowGuard = 1; iRowTo = 20; }
						/*** row 3rd ***/
						if (InArea (602, 18, 602 + ROWW, 18 + ROWH) == 1)
							{ iRowGuard = 2; iRowTo = 0; }
						if (InArea (602, 25, 602 + ROWW, 25 + ROWH) == 1)
							{ iRowGuard = 2; iRowTo = 10; }
						if (InArea (602, 32, 602 + ROWW, 32 + ROWH) == 1)
							{ iRowGuard = 2; iRowTo = 20; }
						/*** row 4th ***/
						if (InArea (366, 159, 366 + ROWW, 159 + ROWH) == 1)
							{ iRowGuard = 3; iRowTo = 0; }
						if (InArea (366, 166, 366 + ROWW, 166 + ROWH) == 1)
							{ iRowGuard = 3; iRowTo = 10; }
						if (InArea (366, 173, 366 + ROWW, 173 + ROWH) == 1)
							{ iRowGuard = 3; iRowTo = 20; }
						/*** row 5th ***/
						if (InArea (484, 159, 484 + ROWW, 159 + ROWH) == 1)
							{ iRowGuard = 4; iRowTo = 0; }
						if (InArea (484, 166, 484 + ROWW, 166 + ROWH) == 1)
							{ iRowGuard = 4; iRowTo = 10; }
						if (InArea (484, 173, 484 + ROWW, 173 + ROWH) == 1)
							{ iRowGuard = 4; iRowTo = 20; }
						if (iRowGuard != -1)
						{
							iStaticGuards_1_Locations[iCurRoom - 1][iRowGuard] = iRowTo;
							iChanged++;
							PlaySound ("wav/hum_adj.wav");
						}

						/*** checkboxes ***/
						for (iGuardType = 1; iGuardType <= 13; iGuardType++)
						{
							switch (iGuardType)
							{
								case 1: iGuardY = GTYPE1; break;
								case 2: iGuardY = GTYPE2; break;
								case 3: iGuardY = GTYPE3; break;
								case 4: iGuardY = GTYPE4; break;
								case 5: iGuardY = GTYPE5; break;
								case 6: iGuardY = GTYPE6; break;
								case 7: iGuardY = GTYPE7; break;
								case 8: iGuardY = GTYPE8; break;
								case 9: iGuardY = GTYPE9; break;
								case 10: iGuardY = GTYPE10; break;
								case 11: iGuardY = GTYPE11; break;
								case 12: iGuardY = GTYPE12; break;
								case 13: iGuardY = GTYPE13; break;
								default: printf ("[ WARN ] Unknown iGuardType.\n"); break;
							}
							for (iGuardNrDir = 1; iGuardNrDir <= 10; iGuardNrDir++)
							{
								switch (iGuardNrDir)
								{
									case 1: iGuardX = G1LEFT; break;
									case 2: iGuardX = G1RIGHT; break;
									case 3: iGuardX = G2LEFT; break;
									case 4: iGuardX = G2RIGHT; break;
									case 5: iGuardX = G3LEFT; break;
									case 6: iGuardX = G3RIGHT; break;
									case 7: iGuardX = G4LEFT; break;
									case 8: iGuardX = G4RIGHT; break;
									case 9: iGuardX = G5LEFT; break;
									case 10: iGuardX = G5RIGHT; break;
									default: printf ("[ WARN ] Unknown iGuardNrDir.\n"); break;
								}
								if (InArea (iGuardX, iGuardY,
									iGuardX + 14, iGuardY + 14) == 1)
								{
									switch (iGuardNrDir)
									{
										case 1: iGuardNr = 0; iGuardDir = 255; break;
										case 2: iGuardNr = 0; iGuardDir = 0; break;
										case 3: iGuardNr = 1; iGuardDir = 255; break;
										case 4: iGuardNr = 1; iGuardDir = 0; break;
										case 5: iGuardNr = 2; iGuardDir = 255; break;
										case 6: iGuardNr = 2; iGuardDir = 0; break;
										case 7: iGuardNr = 3; iGuardDir = 255; break;
										case 8: iGuardNr = 3; iGuardDir = 0; break;
										case 9: iGuardNr = 4; iGuardDir = 255; break;
										case 10: iGuardNr = 4; iGuardDir = 0; break;
										default: printf ("[ WARN ] Unknown iGuardNrDir.\n"); break;
									}
									iStaticGuards_4_Directions[iCurRoom - 1][iGuardNr] =
										iGuardDir;
									ApplyNewGuardType (iGuardNr, iGuardType);
									iChanged++;
									PlaySound ("wav/check_box.wav");
								}
							}
						}

						/*** entry ***/
						iEntryGuard = -1;
						iRow = 0; iColumn = 0; /*** To prevent warnings. ***/
						/*** 1st ***/
						if (InArea (303, 367, 319, 373) == 1)
							{ iEntryGuard = 0; iRow = 0; iColumn = 0; }
						if (InArea (320, 367, 336, 373) == 1)
							{ iEntryGuard = 0; iRow = 0; iColumn = 9; }
						if (InArea (303, 374, 319, 380) == 1)
							{ iEntryGuard = 0; iRow = 1; iColumn = 0; }
						if (InArea (320, 374, 336, 380) == 1)
							{ iEntryGuard = 0; iRow = 1; iColumn = 9; }
						if (InArea (303, 381, 319, 387) == 1)
							{ iEntryGuard = 0; iRow = 2; iColumn = 0; }
						if (InArea (320, 381, 336, 387) == 1)
							{ iEntryGuard = 0; iRow = 2; iColumn = 9; }
						/*** 2nd ***/
						if (InArea (474, 367, 490, 373) == 1)
							{ iEntryGuard = 1; iRow = 0; iColumn = 0; }
						if (InArea (491, 367, 507, 373) == 1)
							{ iEntryGuard = 1; iRow = 0; iColumn = 9; }
						if (InArea (474, 374, 490, 380) == 1)
							{ iEntryGuard = 1; iRow = 1; iColumn = 0; }
						if (InArea (491, 374, 507, 380) == 1)
							{ iEntryGuard = 1; iRow = 1; iColumn = 9; }
						if (InArea (474, 381, 490, 387) == 1)
							{ iEntryGuard = 1; iRow = 2; iColumn = 0; }
						if (InArea (491, 381, 507, 387) == 1)
							{ iEntryGuard = 1; iRow = 2; iColumn = 9; }
						if (iEntryGuard != -1)
						{
							iDynamicGuards_3_Row[iCurRoom - 1][iEntryGuard] = iRow;
							iDynamicGuards_4_Column[iCurRoom - 1][iEntryGuard] = iColumn;
							iChanged++;
							PlaySound ("wav/hum_adj.wav");
						}

						/*** prince row ***/
						/*** 1st ***/
						if (InArea (341, 310, 376, 317) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][0] = 0;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (341, 318, 376, 325) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][0] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (341, 326, 376, 332) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][0] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						/*** 2nd ***/
						if (InArea (512, 310, 547, 317) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][1] = 0;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (512, 317, 547, 325) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][1] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (512, 324, 547, 332) == 1)
						{
							iDynamicGuards_8_PrinceRow[iCurRoom - 1][1] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}

						/*** max alive ***/
						/*** 1st ***/
						if (InArea (438, 311, 452, 325) == 1)
						{
							iDynamicGuards_2_MaxTog[iCurRoom - 1][0] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (453, 311, 467, 325) == 1)
						{
							iDynamicGuards_2_MaxTog[iCurRoom - 1][0] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						/*** 2nd ***/
						if (InArea (609, 311, 623, 325) == 1)
						{
							iDynamicGuards_2_MaxTog[iCurRoom - 1][1] = 1;
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (624, 311, 638, 325) == 1)
						{
							iDynamicGuards_2_MaxTog[iCurRoom - 1][1] = 2;
							iChanged++; PlaySound ("wav/check_box.wav");
						}

						/*** can jump ***/
						/*** 1st ***/
						if (InArea (438, 331, 452, 345) == 1)
						{
							iDynamicGuards_7_CanJump[iCurRoom - 1][0] = 255; /*** N ***/
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (453, 331, 467, 345) == 1)
						{
							iDynamicGuards_7_CanJump[iCurRoom - 1][0] = 1; /*** Y ***/
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						/*** 2nd ***/
						if (InArea (609, 331, 623, 345) == 1)
						{
							iDynamicGuards_7_CanJump[iCurRoom - 1][1] = 255; /*** N ***/
							iChanged++; PlaySound ("wav/check_box.wav");
						}
						if (InArea (624, 331, 638, 345) == 1)
						{
							iDynamicGuards_7_CanJump[iCurRoom - 1][1] = 1; /*** Y ***/
							iChanged++; PlaySound ("wav/check_box.wav");
						}

						/*** hit points, dynamic ***/
						/*** 1st ***/
						PlusMinus (&iDynamicGuards_10_Hitpoints[iCurRoom - 1][0],
							385, 350, 0, 128, -1, 1);
						PlusMinus (&iDynamicGuards_10_Hitpoints[iCurRoom - 1][0],
							455, 350, 0, 128, 1, 1);
						/*** 2nd ***/
						PlusMinus (&iDynamicGuards_10_Hitpoints[iCurRoom - 1][1],
							556, 350, 0, 128, -1, 1);
						PlusMinus (&iDynamicGuards_10_Hitpoints[iCurRoom - 1][1],
							626, 350, 0, 128, 1, 1);

						/*** nr. of guards ***/
						/*** 1st ***/
						PlusMinus (&iDynamicGuards_9_Amount[iCurRoom - 1][0],
							385, 372, 0, 9, -1, 1);
						PlusMinus (&iDynamicGuards_9_Amount[iCurRoom - 1][0],
							455, 372, 0, 9, 1, 1);
						/*** 2nd ***/
						PlusMinus (&iDynamicGuards_9_Amount[iCurRoom - 1][1],
							556, 372, 0, 9, -1, 1);
						PlusMinus (&iDynamicGuards_9_Amount[iCurRoom - 1][1],
							626, 372, 0, 9, 1, 1);

						/*** before spawn ***/
						/*** 1st ***/
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][0],
							355, 394, 0, 255, -10, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][0],
							370, 394, 0, 255, -1, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][0],
							440, 394, 0, 255, 1, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][0],
							455, 394, 0, 255, 10, 1);
						/*** 2nd ***/
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][1],
							526, 394, 0, 255, -10, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][1],
							541, 394, 0, 255, -1, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][1],
							611, 394, 0, 255, 1, 1);
						PlusMinus (&iDynamicGuards_5_LatBefore[iCurRoom - 1][1],
							626, 394, 0, 255, 10, 1);

						/*** between spawns ***/
						/*** 1st ***/
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][0],
							355, 416, 0, 255, -10, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][0],
							370, 416, 0, 255, -1, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][0],
							440, 416, 0, 255, 1, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][0],
							455, 416, 0, 255, 10, 1);
						/*** 2nd ***/
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][1],
							526, 416, 0, 255, -10, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][1],
							541, 416, 0, 255, -1, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][1],
							611, 416, 0, 255, 1, 1);
						PlusMinus (&iDynamicGuards_6_LatBetween[iCurRoom - 1][1],
							626, 416, 0, 255, 10, 1);

						/*** skill ***/
						/*** 1st ***/
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][0],
							305, 56, 0, 255, -1, 1);
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][0],
							375, 56, 0, 255, 1, 1);
						/*** 2nd ***/
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][1],
							423, 56, 0, 255, -1, 1);
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][1],
							493, 56, 0, 255, 1, 1);
						/*** 3rd ***/
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][2],
							541, 56, 0, 255, -1, 1);
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][2],
							611, 56, 0, 255, 1, 1);
						/*** 4th ***/
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][3],
							305, 197, 0, 255, -1, 1);
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][3],
							375, 197, 0, 255, 1, 1);
						/*** 5th ***/
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][4],
							423, 197, 0, 255, -1, 1);
						PlusMinus (&iStaticGuards_5_Skills[iCurRoom - 1][4],
							493, 197, 0, 255, 1, 1);

						/*** hit points, static ***/
						/*** 1st ***/
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][0],
							305, 94, 0, 128, -1, 1);
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][0],
							375, 94, 0, 128, 1, 1);
						/*** 2nd ***/
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][1],
							423, 94, 0, 128, -1, 1);
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][1],
							493, 94, 0, 128, 1, 1);
						/*** 3rd ***/
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][2],
							541, 94, 0, 128, -1, 1);
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][2],
							611, 94, 0, 128, 1, 1);
						/*** 4th ***/
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][3],
							305, 235, 0, 128, -1, 1);
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][3],
							375, 235, 0, 128, 1, 1);
						/*** 5th ***/
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][4],
							423, 235, 0, 128, -1, 1);
						PlusMinus (&iStaticGuards_17_Hitpoints[iCurRoom - 1][4],
							493, 235, 0, 128, 1, 1);

						/*** X-coordinate ***/
						/*** 1st ***/
						iTempCoor = IntsToHexToSSLittleEndian
							(iStaticGuards_3_Offsets2[iCurRoom - 1][0],
							iStaticGuards_2_Offsets1[iCurRoom - 1][0]);
						PlusMinus (&iTempCoor, 290, 132, 0, 608, -10, 1);
						PlusMinus (&iTempCoor, 305, 132, 0, 608, -1, 1);
						PlusMinus (&iTempCoor, 375, 132, 0, 608, 1, 1);
						PlusMinus (&iTempCoor, 390, 132, 0, 608, 10, 1);
						SSLittleEndianToHexToInts (iTempCoor,
							&iStaticGuards_3_Offsets2[iCurRoom - 1][0],
							&iStaticGuards_2_Offsets1[iCurRoom - 1][0]);
						/*** 2nd ***/
						iTempCoor = IntsToHexToSSLittleEndian
							(iStaticGuards_3_Offsets2[iCurRoom - 1][1],
							iStaticGuards_2_Offsets1[iCurRoom - 1][1]);
						PlusMinus (&iTempCoor, 408, 132, 0, 608, -10, 1);
						PlusMinus (&iTempCoor, 423, 132, 0, 608, -1, 1);
						PlusMinus (&iTempCoor, 493, 132, 0, 608, 1, 1);
						PlusMinus (&iTempCoor, 508, 132, 0, 608, 10, 1);
						SSLittleEndianToHexToInts (iTempCoor,
							&iStaticGuards_3_Offsets2[iCurRoom - 1][1],
							&iStaticGuards_2_Offsets1[iCurRoom - 1][1]);
						/*** 3rd ***/
						iTempCoor = IntsToHexToSSLittleEndian
							(iStaticGuards_3_Offsets2[iCurRoom - 1][2],
							iStaticGuards_2_Offsets1[iCurRoom - 1][2]);
						PlusMinus (&iTempCoor, 526, 132, 0, 608, -10, 1);
						PlusMinus (&iTempCoor, 541, 132, 0, 608, -1, 1);
						PlusMinus (&iTempCoor, 611, 132, 0, 608, 1, 1);
						PlusMinus (&iTempCoor, 626, 132, 0, 608, 10, 1);
						SSLittleEndianToHexToInts (iTempCoor,
							&iStaticGuards_3_Offsets2[iCurRoom - 1][2],
							&iStaticGuards_2_Offsets1[iCurRoom - 1][2]);
						/*** 4th ***/
						iTempCoor = IntsToHexToSSLittleEndian
							(iStaticGuards_3_Offsets2[iCurRoom - 1][3],
							iStaticGuards_2_Offsets1[iCurRoom - 1][3]);
						PlusMinus (&iTempCoor, 290, 273, 0, 608, -10, 1);
						PlusMinus (&iTempCoor, 305, 273, 0, 608, -1, 1);
						PlusMinus (&iTempCoor, 375, 273, 0, 608, 1, 1);
						PlusMinus (&iTempCoor, 390, 273, 0, 608, 10, 1);
						SSLittleEndianToHexToInts (iTempCoor,
							&iStaticGuards_3_Offsets2[iCurRoom - 1][3],
							&iStaticGuards_2_Offsets1[iCurRoom - 1][3]);
						/*** 5th ***/
						iTempCoor = IntsToHexToSSLittleEndian
							(iStaticGuards_3_Offsets2[iCurRoom - 1][4],
							iStaticGuards_2_Offsets1[iCurRoom - 1][4]);
						PlusMinus (&iTempCoor, 408, 273, 0, 608, -10, 1);
						PlusMinus (&iTempCoor, 423, 273, 0, 608, -1, 1);
						PlusMinus (&iTempCoor, 493, 273, 0, 608, 1, 1);
						PlusMinus (&iTempCoor, 508, 273, 0, 608, 10, 1);
						SSLittleEndianToHexToInts (iTempCoor,
							&iStaticGuards_3_Offsets2[iCurRoom - 1][4],
							&iStaticGuards_2_Offsets1[iCurRoom - 1][4]);

						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
							{ iChangingGuards = 0; }
					}
					ShowChangeGuards (screen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowChangeGuards (screen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/ok_close.wav");
}
/*****************************************************************************/
void ChangeMusicAction (char *sAction)
/*****************************************************************************/
{
	int iTile;

	if (strcmp (sAction, "all") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
			{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "none") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
			{ sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "left") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if (((iTile >= 0) && (iTile <= 4)) ||
				((iTile >= 10) && (iTile <= 14)) ||
				((iTile >= 20) && (iTile <= 24)))
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "right") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if (((iTile >= 5) && (iTile <= 9)) ||
				((iTile >= 15) && (iTile <= 19)) ||
				((iTile >= 25) && (iTile <= 29)))
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "top") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if ((iTile >= 0) && (iTile <= 9))
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "middle") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if ((iTile >= 10) && (iTile <= 19))
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "bottom") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if ((iTile >= 20) && (iTile <= 29))
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}

	if (strcmp (sAction, "invert") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if (sMusic[((iCurRoom - 1) * 30) + iTile] == 0)
				{ sMusic[((iCurRoom - 1) * 30) + iTile] = 1; }
					else { sMusic[((iCurRoom - 1) * 30) + iTile] = 0; }
		}
		PlaySound ("wav/screen2or3.wav");
		iChanged++;
	}
}
/*****************************************************************************/
void ChangeMusic (SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iChangingMusic;
	int iTemp;
	int iX1, iY1, iX2, iY2;
	int iXJoy1, iYJoy1, iXJoy2, iYJoy2;

	iChangingMusic = 1;

	ShowChangeMusic (screen);
	while (iChangingMusic == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							if (sMusic[((iCurRoom - 1) * 30) + iEditNote] == 0)
								{ sMusic[((iCurRoom - 1) * 30) + iEditNote] = 1; }
									else { sMusic[((iCurRoom - 1) * 30) + iEditNote] = 0; }
							PlaySound ("wav/check_box.wav");
							iChanged++;
							break;
						case SDL_CONTROLLER_BUTTON_B:
							iChangingMusic = 0; break;
						case SDL_CONTROLLER_BUTTON_X:
							ChangeMusicAction ("top"); break;
						case SDL_CONTROLLER_BUTTON_Y:
							ChangeMusicAction ("bottom"); break;
						case SDL_CONTROLLER_BUTTON_BACK:
							ChangeMusicAction ("middle"); break;
						case SDL_CONTROLLER_BUTTON_START:
							ChangeMusicAction ("invert"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							iEditNote--;
							switch (iEditNote)
							{
								case -1: iEditNote = 9; break;
								case 9: iEditNote = 19; break;
								case 19: iEditNote = 29; break;
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							iEditNote++;
							switch (iEditNote)
							{
								case 10: iEditNote = 0; break;
								case 20: iEditNote = 10; break;
								case 30: iEditNote = 20; break;
							}
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							if (iEditNote >= 10) { iEditNote-=10; } else { iEditNote+=20; }
							break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							if (iEditNote <= 19) { iEditNote+=10; } else { iEditNote-=20; }
							break;
					}
					ShowChangeMusic (screen);
					break;
				case SDL_CONTROLLERAXISMOTION: /*** triggers and analog sticks ***/
					iXJoy1 = SDL_JoystickGetAxis (joystick, 0);
					iYJoy1 = SDL_JoystickGetAxis (joystick, 1);
					iXJoy2 = SDL_JoystickGetAxis (joystick, 3);
					iYJoy2 = SDL_JoystickGetAxis (joystick, 4);
					if ((iXJoy1 < -30000) || (iXJoy2 < -30000)) /*** left ***/
					{
						if ((SDL_GetTicks() - joyleft) > 300)
						{
							ChangeMusicAction ("left");
							joyleft = SDL_GetTicks();
						}
					}
					if ((iXJoy1 > 30000) || (iXJoy2 > 30000)) /*** right ***/
					{
						if ((SDL_GetTicks() - joyright) > 300)
						{
							ChangeMusicAction ("right");
							joyright = SDL_GetTicks();
						}
					}
					if ((iYJoy1 < -30000) || (iYJoy2 < -30000)) /*** up ***/
					{
						if ((SDL_GetTicks() - joyup) > 300)
						{
							ChangeMusicAction ("all");
							joyup = SDL_GetTicks();
						}
					}
					if ((iYJoy1 > 30000) || (iYJoy2 > 30000)) /*** down ***/
					{
						if ((SDL_GetTicks() - joydown) > 300)
						{
							ChangeMusicAction ("none");
							joydown = SDL_GetTicks();
						}
					}
					ShowChangeMusic (screen);
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							iChangingMusic = 0; break;
						case SDLK_LEFT:
							iEditNote--;
							switch (iEditNote)
							{
								case -1: iEditNote = 9; break;
								case 9: iEditNote = 19; break;
								case 19: iEditNote = 29; break;
							}
							break;
						case SDLK_RIGHT:
							iEditNote++;
							switch (iEditNote)
							{
								case 10: iEditNote = 0; break;
								case 20: iEditNote = 10; break;
								case 30: iEditNote = 20; break;
							}
							break;
						case SDLK_UP:
							if (iEditNote >= 10) { iEditNote-=10; } else { iEditNote+=20; }
							break;
						case SDLK_DOWN:
							if (iEditNote <= 19) { iEditNote+=10; } else { iEditNote-=20; }
							break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							if (sMusic[((iCurRoom - 1) * 30) + iEditNote] == 0)
								{ sMusic[((iCurRoom - 1) * 30) + iEditNote] = 1; }
									else { sMusic[((iCurRoom - 1) * 30) + iEditNote] = 0; }
							PlaySound ("wav/check_box.wav");
							iChanged++;
							break;
						case SDLK_1:
						case SDLK_KP_1:
							ChangeMusicAction ("all"); break;
						case SDLK_2:
						case SDLK_KP_2:
							ChangeMusicAction ("left"); break;
						case SDLK_3:
						case SDLK_KP_3:
							ChangeMusicAction ("none"); break;
						case SDLK_4:
						case SDLK_KP_4:
							ChangeMusicAction ("right"); break;
						case SDLK_5:
						case SDLK_KP_5:
							ChangeMusicAction ("top"); break;
						case SDLK_6:
						case SDLK_KP_6:
							ChangeMusicAction ("bottom"); break;
						case SDLK_7:
						case SDLK_KP_7:
							ChangeMusicAction ("middle"); break;
						case SDLK_8:
						case SDLK_KP_8:
							ChangeMusicAction ("invert"); break;
						default: break;
					}
					ShowChangeMusic (screen);
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (32, 115, 103, 144) == 1) /*** music all ***/
							{ if (iMAllOn != 1) { iMAllOn = 1; } }
						if (InArea (32, 145, 103, 174) == 1) /*** music none ***/
							{ if (iMNoneOn != 1) { iMNoneOn = 1; } }
						if (InArea (104, 115, 175, 144) == 1) /*** music left ***/
							{ if (iMLeftOn != 1) { iMLeftOn = 1; } }
						if (InArea (104, 145, 175, 174) == 1) /*** music right ***/
							{ if (iMRightOn != 1) { iMRightOn = 1; } }
						if (InArea (481, 115, 552, 144) == 1) /*** music top ***/
							{ if (iMTopOn != 1) { iMTopOn = 1; } }
						if (InArea (481, 145, 552, 174) == 1) /*** music middle ***/
							{ if (iMMiddleOn != 1) { iMMiddleOn = 1; } }
						if (InArea (553, 115, 624, 144) == 1) /*** music bottom ***/
							{ if (iMBottomOn != 1) { iMBottomOn = 1; } }
						if (InArea (553, 145, 624, 174) == 1) /*** music invert ***/
							{ if (iMInvertOn != 1) { iMInvertOn = 1; } }

						if (InArea (656, 0, 692, 455) == 1) /*** close ***/
						{
							if (iCloseMusicOn != 1) { iCloseMusicOn = 1; }
						}
						ShowChangeMusic (screen);
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseMusicOn = 0;
					iMAllOn = 0;
					iMNoneOn = 0;
					iMLeftOn = 0;
					iMRightOn = 0;
					iMTopOn = 0;
					iMMiddleOn = 0;
					iMBottomOn = 0;
					iMInvertOn = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						/*** music checkboxes ***/
						for (iTemp = 0; iTemp < 30; iTemp++)
						{
							if ((iTemp >= 0) && (iTemp <= 9)) { iY1 = 130; }
							if ((iTemp >= 10) && (iTemp <= 19)) { iY1 = 145; }
							if ((iTemp >= 20) && (iTemp <= 29)) { iY1 = 160; }
							switch (iTemp)
							{
								case 0: case 10: case 20: iX1 = 253 + (0 * 15); break;
								case 1: case 11: case 21: iX1 = 253 + (1 * 15); break;
								case 2: case 12: case 22: iX1 = 253 + (2 * 15); break;
								case 3: case 13: case 23: iX1 = 253 + (3 * 15); break;
								case 4: case 14: case 24: iX1 = 253 + (4 * 15); break;
								case 5: case 15: case 25: iX1 = 253 + (5 * 15); break;
								case 6: case 16: case 26: iX1 = 253 + (6 * 15); break;
								case 7: case 17: case 27: iX1 = 253 + (7 * 15); break;
								case 8: case 18: case 28: iX1 = 253 + (8 * 15); break;
								case 9: case 19: case 29: iX1 = 253 + (9 * 15); break;
							}
							iX2 = iX1 + 14;
							iY2 = iY1 + 14;
							if (InArea (iX1, iY1, iX2, iY2) == 1)
							{
								if (sMusic[((iCurRoom - 1) * 30) + iTemp] == 1)
								{
									sMusic[((iCurRoom - 1) * 30) + iTemp] = 0;
								} else {
									sMusic[((iCurRoom - 1) * 30) + iTemp] = 1;
								}
								ShowChangeMusic (screen);
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
						}

						/*** music buttons ***/
						if (InArea (32, 115, 103, 144) == 1)
							{ ChangeMusicAction ("all"); }
						if (InArea (32, 145, 103, 174) == 1)
							{ ChangeMusicAction ("none"); }
						if (InArea (104, 115, 175, 144) == 1)
							{ ChangeMusicAction ("left"); }
						if (InArea (104, 145, 175, 174) == 1)
							{ ChangeMusicAction ("right"); }
						if (InArea (481, 115, 552, 144) == 1)
							{ ChangeMusicAction ("top"); }
						if (InArea (481, 145, 552, 174) == 1)
							{ ChangeMusicAction ("middle"); }
						if (InArea (553, 115, 624, 144) == 1)
							{ ChangeMusicAction ("bottom"); }
						if (InArea (553, 145, 624, 174) == 1)
							{ ChangeMusicAction ("invert"); }

						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
							{ iChangingMusic = 0; }
					}
					ShowChangeMusic (screen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowChangeMusic (screen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/ok_close.wav");
}
/*****************************************************************************/
void ChangeBackgroundAction (char *sAction, int iLocation)
/*****************************************************************************/
{
	int iBackRow, iBackColumn;
	int iTile, iRoom;
	int iBackTo;

	if (strcmp (sAction, "right") == 0)
	{
		if (iEditPoP == 3)
		{
			BackRowAndColumnSNES (&iBackRow, &iBackColumn);
			if (iBackColumn == 20)
			{
				iModHi = (iBackRow * 20) - 19;
			} else if (iModHi - 1 == MaxBackSNES()) {
				iModHi = (iBackRow * 20) - 19;
			} else {
				iModHi++;
			}
		}
	}

	if (strcmp (sAction, "left") == 0)
	{
		BackRowAndColumnSNES (&iBackRow, &iBackColumn);
		if (iBackColumn == 1)
		{
			iModHi+=19;
			if (iModHi - 1 > MaxBackSNES()) { iModHi = MaxBackSNES() + 1; }
		} else {
			iModHi--;
		}
	}

	if (strcmp (sAction, "up") == 0)
	{
		BackRowAndColumnSNES (&iBackRow, &iBackColumn);
		if (iBackRow == 1)
		{
			iModHi+=200; /*** Lots (multiple of 20). ***/
			do {
				iModHi-=20;
			} while (iModHi - 1 > MaxBackSNES());
		} else {
			iModHi-=20;
		}
	}

	if (strcmp (sAction, "down") == 0)
	{
		BackRowAndColumnSNES (&iBackRow, &iBackColumn);
		if (iModHi + 20 - 1 > MaxBackSNES())
		{
			iModHi-=200; /*** Lots (multiple of 20). ***/
			do {
				iModHi+=20;
			} while (iModHi < 1);
		} else {
			iModHi+=20;
		}
	}

	iBackTo = iModHi - 1; /*** Outside the if, to prevent warnings. ***/
	if ((iEditPoP == 3) && (
		(strcmp (sAction, "entire room") == 0) ||
		(strcmp (sAction, "entire level") == 0) ||
		(strcmp (sAction, "single tile") == 0)))
	{
		if (((iEXEType == 1) || (iEXEType == 2)) &&
			(cCurType == 'f') &&
			((iBackTo >= 0x2b) && (iBackTo <= 0x42)))
		{
			/*** fawn cloud backgrounds for US and EU ***/
			iBackTo+=0x55;
		} else if ((cCurType == 'u') &&
			((iBackTo >= 0x54) && (iBackTo <= 0x59))) {
			/*** umber bus error occurred ***/
			iBackTo+=0xa5;
		}
	}

	if (strcmp (sAction, "entire room") == 0)
	{
		for (iTile = 0; iTile < 30; iTile++)
		{
			if (iEditPoP == 2)
			{
				iModifierA[iCurRoom][iTile][3] = iMod3Hi;
				iModifierA[iCurRoom][iTile][4] = iMod4Hi;
			} else {
				iBackA[iCurRoom][iTile] = iBackTo;
			}
		}
	}

	if (strcmp (sAction, "entire level") == 0)
	{
		for (iRoom = 1; iRoom <= iRooms; iRoom++)
		{
			for (iTile = 0; iTile < 30; iTile++)
			{
				if (iEditPoP == 2)
				{
					iModifierA[iRoom][iTile][3] = iMod3Hi;
					iModifierA[iRoom][iTile][4] = iMod4Hi;
				} else {
					iBackA[iRoom][iTile] = iBackTo;
				}
			}
		}
	}

	if (strcmp (sAction, "single tile") == 0)
	{
		if (iEditPoP == 2)
		{
			iModifierA[iCurRoom][iLocation - 1][3] = iMod3Hi;
			iModifierA[iCurRoom][iLocation - 1][4] = iMod4Hi;
		} else {
			iBackA[iCurRoom][iLocation - 1] = iBackTo;
		}
	}
}
/*****************************************************************************/
int ChangeBackground (int iLocation, SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iChangingBackground;
	int iChanging;
	int iBK;
	int iHeight, iWidth;
	int iBackValue;

	iChanging = 1;

	iChangingBackground = 1;

	ShowChangeBackground (iLocation, screen);
	while (iChangingBackground == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_B:
							iChangingBackground = 0; break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							ChangeBackgroundAction ("right", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							ChangeBackgroundAction ("left", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							ChangeBackgroundAction ("up", iLocation); break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							ChangeBackgroundAction ("down", iLocation); break;
						case SDL_CONTROLLER_BUTTON_X:
							ChangeBackgroundAction ("entire room", iLocation);
							iChanged++; iChangingBackground = 0; iChanging = 0; break;
						case SDL_CONTROLLER_BUTTON_Y:
							ChangeBackgroundAction ("entire level", iLocation);
							iChanged++; iChangingBackground = 0; iChanging = 0; break;
						case SDL_CONTROLLER_BUTTON_A:
							ChangeBackgroundAction ("single tile", iLocation);
							iChanged++; iChangingBackground = 0; iChanging = 0; break;
					}
					ShowChangeBackground (iLocation, screen);
					break;
				case SDL_KEYDOWN:
					iBK = 0;
					switch (event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							ChangeBackgroundAction ("right", iLocation); break;
						case SDLK_LEFT:
							ChangeBackgroundAction ("left", iLocation); break;
						case SDLK_UP:
							ChangeBackgroundAction ("up", iLocation); break;
						case SDLK_DOWN:
							ChangeBackgroundAction ("down", iLocation); break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							if ((event.key.keysym.mod & KMOD_LSHIFT) ||
								(event.key.keysym.mod & KMOD_RSHIFT))
							{
								ChangeBackgroundAction ("entire room", iLocation);
							} else if ((event.key.keysym.mod & KMOD_LCTRL) ||
								(event.key.keysym.mod & KMOD_RCTRL))
							{
								ChangeBackgroundAction ("entire level", iLocation);
							} else {
								ChangeBackgroundAction ("single tile", iLocation);
							}
							iChanged++; iChangingBackground = 0; iChanging = 0;
							break;

						case SDLK_PERIOD: case SDLK_KP_PERIOD:
							iBK = BackKey (event, '.', iLocation); break;
						case SDLK_a: iBK = BackKey (event, 'a', iLocation); break;
						case SDLK_b: iBK = BackKey (event, 'b', iLocation); break;
						case SDLK_c: iBK = BackKey (event, 'c', iLocation); break;
						case SDLK_d: iBK = BackKey (event, 'd', iLocation); break;
						case SDLK_e: iBK = BackKey (event, 'e', iLocation); break;
						case SDLK_f: iBK = BackKey (event, 'f', iLocation); break;
						case SDLK_g: iBK = BackKey (event, 'g', iLocation); break;
						case SDLK_h: iBK = BackKey (event, 'h', iLocation); break;
						case SDLK_i: iBK = BackKey (event, 'i', iLocation); break;
						case SDLK_j: iBK = BackKey (event, 'j', iLocation); break;
						case SDLK_k: iBK = BackKey (event, 'k', iLocation); break;
						case SDLK_l: iBK = BackKey (event, 'l', iLocation); break;
						case SDLK_m: iBK = BackKey (event, 'm', iLocation); break;
						case SDLK_n: iBK = BackKey (event, 'n', iLocation); break;
						case SDLK_o: iBK = BackKey (event, 'o', iLocation); break;
						case SDLK_p: iBK = BackKey (event, 'p', iLocation); break;
						case SDLK_q: iBK = BackKey (event, 'q', iLocation); break;
						case SDLK_r: iBK = BackKey (event, 'r', iLocation); break;
						case SDLK_s: iBK = BackKey (event, 's', iLocation); break;
						case SDLK_t: iBK = BackKey (event, 't', iLocation); break;
						case SDLK_u: iBK = BackKey (event, 'u', iLocation); break;
						case SDLK_v: iBK = BackKey (event, 'v', iLocation); break;
						case SDLK_w: iBK = BackKey (event, 'w', iLocation); break;
						case SDLK_x: iBK = BackKey (event, 'x', iLocation); break;
						case SDLK_y: iBK = BackKey (event, 'y', iLocation); break;
						case SDLK_z: iBK = BackKey (event, 'z', iLocation); break;
						case SDLK_0: case SDLK_KP_0:
							iBK = BackKey (event, '0', iLocation); break;
						case SDLK_1: case SDLK_KP_1:
							iBK = BackKey (event, '1', iLocation); break;
						case SDLK_2: case SDLK_KP_2:
							iBK = BackKey (event, '2', iLocation); break;
						case SDLK_3: case SDLK_KP_3:
							iBK = BackKey (event, '3', iLocation); break;
						case SDLK_4: case SDLK_KP_4:
							iBK = BackKey (event, '4', iLocation); break;
						case SDLK_5: case SDLK_KP_5:
							iBK = BackKey (event, '5', iLocation); break;
						case SDLK_6: case SDLK_KP_6:
							iBK = BackKey (event, '6', iLocation); break;
						case SDLK_7: case SDLK_KP_7:
							iBK = BackKey (event, '7', iLocation); break;
						case SDLK_8: case SDLK_KP_8:
							iBK = BackKey (event, '8', iLocation); break;
						case SDLK_9: case SDLK_KP_9:
							iBK = BackKey (event, '9', iLocation); break;

						case SDLK_ESCAPE:
							iChangingBackground = 0; break;
						default: break;
					}
					if (iBK == 1)
						{ iChanged++; iChangingBackground = 0; iChanging = 0; }
					ShowChangeBackground (iLocation, screen);
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if (iEditPoP == 2)
					{
						HiSetBack (iLocation, 0);
					} else {
						for (iHeight = 0; iHeight <= 5; iHeight++)
						{
							for (iWidth = 0; iWidth <= 19; iWidth++)
							{
								if (InArea ((iWidth * 29) + 9, (iHeight * 69) + 9,
									(iWidth * 29) + 9 + 24, (iHeight * 69) + 9 + 64) == 1)
								{
									iBackValue = (iHeight * 20) + iWidth + 1;
									if ((iModHi != iBackValue) &&
										(iBackValue - 1 <= MaxBackSNES()))
									{
										iModHi = iBackValue;
										ShowChangeBackground (iLocation, screen);
									}
								}
							}
						}
					}
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
						{
							if (iCloseBackgroundOn != 1) { iCloseBackgroundOn = 1; }
							ShowChangeBackground (iLocation, screen);
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseBackgroundOn = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						if (iEditPoP == 2)
						{
							if (HiSetBack (iLocation, 1) == 1)
								{ iChanged++; iChangingBackground = 0; iChanging = 0; }
						} else {
							if (InArea (9, 9, 584, 418) == 1)
							{
								ChangeBackgroundAction ("single tile", iLocation);
								iChanged++; iChangingBackground = 0; iChanging = 0;
							}
						}

						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
							{ iChangingBackground = 0; }
					}
					if (event.button.button == 2) /*** middle mouse button ***/
					{
						if (iEditPoP == 2)
						{
							if (HiSetBack (iLocation, 2) == 1)
								{ iChanged++; iChangingBackground = 0; iChanging = 0; }
						} else {
							if (InArea (9, 9, 584, 418) == 1)
							{
								ChangeBackgroundAction ("entire room", iLocation);
								iChanged++; iChangingBackground = 0; iChanging = 0;
							}
						}
					}
					if (event.button.button == 3) /*** right mouse button ***/
					{
						if (iEditPoP == 2)
						{
							if (HiSetBack (iLocation, 3) == 1)
								{ iChanged++; iChangingBackground = 0; iChanging = 0; }
						} else {
							if (InArea (9, 9, 584, 418) == 1)
							{
								ChangeBackgroundAction ("entire level", iLocation);
								iChanged++; iChangingBackground = 0; iChanging = 0;
							}
						}
					}
					ShowChangeBackground (iLocation, screen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowChangeBackground (iLocation, screen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	if (iChanging == 1) { PlaySound ("wav/ok_close.wav"); }

	return (iChanging);
}
/*****************************************************************************/
void PickTemplateAction (char *sAction)
/*****************************************************************************/
{
	char sFileName[MAX_FILE + 2];
	char sLine[MAX_DATA + 2];
	int iLine;
	int iEOF;
	int iFd;
	char sB1[10 + 2], sB2[10 + 2], sB3[10 + 2];
	char sB4[10 + 2], sMod[10 + 2], sBack[10 + 2];
	int iB1, iB2, iB3, iB4, iMod, iBack;

	if (strcmp (sAction, "right") == 0)
	{
		switch (iTempHi)
		{
			case 1: iTempHi = 2; break;
			case 2: iTempHi = 3; break;
			case 3: iTempHi = 1; break;
			case 4: iTempHi = 5; break;
			case 5: iTempHi = 6; break;
			case 6: iTempHi = 4; break;
		}
	}

	if (strcmp (sAction, "left") == 0)
	{
		switch (iTempHi)
		{
			case 1: iTempHi = 3; break;
			case 2: iTempHi = 1; break;
			case 3: iTempHi = 2; break;
			case 4: iTempHi = 6; break;
			case 5: iTempHi = 4; break;
			case 6: iTempHi = 5; break;
		}
	}

	if ((strcmp (sAction, "up") == 0) ||
		(strcmp (sAction, "down") == 0))
	{
		switch (iTempHi)
		{
			case 1: iTempHi = 4; break;
			case 2: iTempHi = 5; break;
			case 3: iTempHi = 6; break;
			case 4: iTempHi = 1; break;
			case 5: iTempHi = 2; break;
			case 6: iTempHi = 3; break;
		}
	}

	if (strcmp (sAction, "apply") == 0)
	{
		/*** Open template file. ***/
		snprintf (sFileName, MAX_FILE, "%s%c%i.txt",
			TEMPLATES_SNES, cCurType, iTempHi);
		iFd = open (sFileName, O_RDONLY);
		if (iFd == -1)
		{
			printf ("[ WARN ] Cannot open template file \"%s\": %s!\n",
				sFileName, strerror (errno));
		} else {
			iLine = 1;
			do {
				iEOF = ReadLineFromFile (iFd, sLine, 0);
				if (iEOF == 0)
				{
					if ((int)strlen (sLine) != 17)
					{
						printf ("[ WARN ] Line %i of \"%s\" is not 17 characters!\n",
							iLine, sFileName);
					} else {
						if ((iLine >= 1) && (iLine <= 30))
						{
							snprintf (sB1, 10, "%c%c", sLine[0], sLine[1]);
							iB1 = (int)strtol (sB1, NULL, 16);
							snprintf (sB2, 10, "%c%c", sLine[3], sLine[4]);
							iB2 = (int)strtol (sB2, NULL, 16);
							snprintf (sB3, 10, "%c%c", sLine[6], sLine[7]);
							iB3 = (int)strtol (sB3, NULL, 16);
							snprintf (sB4, 10, "%c%c", sLine[9], sLine[10]);
							iB4 = (int)strtol (sB4, NULL, 16);
							snprintf (sMod, 10, "%c%c", sLine[12], sLine[13]);
							iMod = (int)strtol (sMod, NULL, 16);
							SetLocationSNES (iCurRoom, iLine, iB1, iB2, iB3, iB4, iMod, 0);

							/*** background ***/
							snprintf (sBack, 10, "%c%c", sLine[15], sLine[16]);
							iBack = (int)strtol (sBack, NULL, 16);
							if (((iEXEType == 1) || (iEXEType == 2)) &&
								(cCurType == 'f') &&
								((iBack >= 0x2b) && (iBack <= 0x42)))
							{
								/*** fawn cloud backgrounds for US and EU ***/
								iBack+=0x55;
							} else if ((cCurType == 'u') &&
								((iBack >= 0x54) && (iBack <= 0x59))) {
								/*** umber bus error occurred ***/
								iBack+=0xa5;
							}
							iBackA[iCurRoom][iLine - 1] = iBack;
						}
					}
					iLine++;
				}
			} while (iEOF == 0);
			if (iLine != 31)
			{
				printf ("[ WARN ] Strange line count for \"%s\": %i!\n",
					sFileName, iLine - 1);
			}
		}
	}
}
/*****************************************************************************/
int PickTemplate (SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Event event;
	int iPickingTemplate;
	int iChanging;

	iChanging = 1;

	iPickingTemplate = 1;

	ShowPickTemplate (screen);
	while (iPickingTemplate == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_B:
							iPickingTemplate = 0; break;
						case SDL_CONTROLLER_BUTTON_DPAD_RIGHT:
							PickTemplateAction ("right"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_LEFT:
							PickTemplateAction ("left"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_UP:
							PickTemplateAction ("up"); break;
						case SDL_CONTROLLER_BUTTON_DPAD_DOWN:
							PickTemplateAction ("down"); break;
						case SDL_CONTROLLER_BUTTON_A:
							PickTemplateAction ("apply");
							iChanged++; iPickingTemplate = 0; iChanging = 0; break;
					}
					ShowPickTemplate (screen);
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_RIGHT:
							PickTemplateAction ("right"); break;
						case SDLK_LEFT:
							PickTemplateAction ("left"); break;
						case SDLK_UP:
							PickTemplateAction ("up"); break;
						case SDLK_DOWN:
							PickTemplateAction ("down"); break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
							PickTemplateAction ("apply");
							iChanged++; iPickingTemplate = 0; iChanging = 0;
							break;
						case SDLK_ESCAPE:
							iPickingTemplate = 0; break;
						default: break;
					}
					ShowPickTemplate (screen);
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if (InArea (9, 9, 219, 177) == 1)
						{ if (iTempHi != 1) { iTempHi = 1; ShowPickTemplate (screen); } }
					if (InArea (223, 9, 433, 177) == 1)
						{ if (iTempHi != 2) { iTempHi = 2; ShowPickTemplate (screen); } }
					if (InArea (437, 9, 647, 177) == 1)
						{ if (iTempHi != 3) { iTempHi = 3; ShowPickTemplate (screen); } }
					if (InArea (9, 181, 219, 349) == 1)
						{ if (iTempHi != 4) { iTempHi = 4; ShowPickTemplate (screen); } }
					if (InArea (223, 181, 433, 349) == 1)
						{ if (iTempHi != 5) { iTempHi = 5; ShowPickTemplate (screen); } }
					if (InArea (437, 181, 647, 349) == 1)
						{ if (iTempHi != 6) { iTempHi = 6; ShowPickTemplate (screen); } }
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
						{
							if (iCloseTemplateOn != 1) { iCloseTemplateOn = 1; }
							ShowPickTemplate (screen);
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iCloseTemplateOn = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						if (InArea (9, 9, 647, 349) == 1)
						{
							PickTemplateAction ("apply");
							iChanged++; iPickingTemplate = 0; iChanging = 0;
						}

						/*** CLOSE ***/
						if (InArea (656, 0, 692, 455) == 1)
							{ iPickingTemplate = 0; }
					}
					ShowPickTemplate (screen);
					break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowPickTemplate (screen); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	if (iChanging == 1) { PlaySound ("wav/ok_close.wav"); }

	return (iChanging);
}
/*****************************************************************************/
void ChangeEvent (int iAmount, int iChangePos)
/*****************************************************************************/
{
	int iChange;

	if (((iAmount > 0) && (iChangeEvent != 255)) ||
		((iAmount < 0) && (iChangeEvent != 0)))
	{
		switch (iAmount)
		{
			case -10: iChangeEvent-=10; break;
			case -1: iChangeEvent--; break;
			case 1: iChangeEvent++; break;
			case 10: iChangeEvent+=10; break;
		}
		if (iChangeEvent < 0) { iChangeEvent = 0; }
		if (iChangeEvent > 255) { iChangeEvent = 255; }
		if (iChangePos == 1)
		{
			iChange = 0;
			switch (iEditPoP)
			{
				case 1:
					if ((iThingA[iCurRoom][iSelected - 1] == 6) ||
						(iThingA[iCurRoom][iSelected - 1] == 15) ||
						(iThingA[iCurRoom][iSelected - 1] == 38) ||
						(iThingA[iCurRoom][iSelected - 1] == 47)) { iChange = 1; }
					break;
				case 2:
					if ((iThingA[iCurRoom][iSelected - 1] == 5) ||
						(iThingA[iCurRoom][iSelected - 1] == 6) ||
						(iThingA[iCurRoom][iSelected - 1] == 34)) { iChange = 1; }
					break;
				case 3:
					if ((iBlock3A[iCurRoom][iSelected - 1] == 0x04) ||
						(iBlock3A[iCurRoom][iSelected - 1] == 0x05) ||
						(iBlock3A[iCurRoom][iSelected - 1] == 0x23)) { iChange = 1; }
					break;
			}
			if (iChange == 1)
			{
				iModifierA[iCurRoom][iSelected - 1][1] = iChangeEvent;
				iChanged++;
			}
		}
		PlaySound ("wav/plus_minus.wav");
	}
}
/*****************************************************************************/
void ChangeCustom (int iAmount, int iForeModi, int iArNr)
/*****************************************************************************/
{
	switch (iForeModi)
	{
		case 1: /*** fore ***/
			if (iEditPoP != 3)
			{
				if (((iAmount == 1) && (iChangeFore != 31)) ||
					((iAmount == -1) && (iChangeFore != 0)))
				{
					switch (iAmount)
					{
						case -1: iChangeFore--; break;
						case 1: iChangeFore++; break;
					}
					PlaySound ("wav/plus_minus.wav");
				}
			} else {
				if (((iAmount > 0) && (iChangeBlock[iArNr] != 255)) ||
					((iAmount < 0) && (iChangeBlock[iArNr] != 0)))
				{
					iChangeBlock[iArNr] += iAmount;
					if (iChangeBlock[iArNr] < 0) { iChangeBlock[iArNr] = 0; }
					if (iChangeBlock[iArNr] > 255) { iChangeBlock[iArNr] = 255; }
					PlaySound ("wav/plus_minus.wav");
				}
			}
			break;
		case 2: /*** modi ***/
			if (((iAmount > 0) && (iChangeMod[iArNr] != 255)) ||
				((iAmount < 0) && (iChangeMod[iArNr] != 0)))
			{
				iChangeMod[iArNr] += iAmount;
				if (iChangeMod[iArNr] < 0) { iChangeMod[iArNr] = 0; }
				if (iChangeMod[iArNr] > 255) { iChangeMod[iArNr] = 255; }
				PlaySound ("wav/plus_minus.wav");
			}
			break;
	}
}
/*****************************************************************************/
int IsDisabled (int iTile)
/*****************************************************************************/
{
	if (iEditPoP != 1) { return (0); }

	if (((iTile >= 92) && (iTile <= 105)) && (iCurGuard != 0))
		{ PrIfDe ("[  OK  ] State of guards: disabled\n"); return (1); }
	else if (((iTile == 75) || (iTile == 76)) && (iCurGuard != 1))
		{ PrIfDe ("[  OK  ] State of fat guard: disabled\n"); return (1); }
	else if (((iTile == 77) || (iTile == 78)) && (iCurGuard != 2))
		{ PrIfDe ("[  OK  ] State of skeleton: disabled\n"); return (1); }
	else if (((iTile == 108) || (iTile == 109)) && (iCurGuard != 3))
		{ PrIfDe ("[  OK  ] State of jaffar: disabled\n"); return (1); }
	else if (((iTile == 73) || (iTile == 74)) && (iCurGuard != 4))
		{ PrIfDe ("[  OK  ] State of shadow: disabled\n"); return (1); }
	else { return (0); }
}
/*****************************************************************************/
void UseTile (int iTile, int iLocation, int iRoom, int iTileUnderMe)
/*****************************************************************************/
{
	int iTemp;
	int iB1, iB2, iB3, iB4, iMod;
	int iU;
	int iType, iDir;

	/*** Used for entrance, exit and teleport sets. ***/
	int iSetTL1, iSetTL2, iSetTL3, iSetTL4;
	int iSetTM1, iSetTM2, iSetTM3, iSetTM4;
	int iSetTR1, iSetTR2, iSetTR3, iSetTR4;
	int iSetTF1, iSetTF2, iSetTF3, iSetTF4;
	int iSetL1, iSetL2, iSetL3, iSetL4;
	int iSetR1, iSetR2, iSetR3, iSetR4;
	int iSetBackTL, iSetBackTM, iSetBackTR;
	int iSetBackL, iSetBackM, iSetBackR;

	/*** To prevent warnings. ***/
	iSetTL1 = -1; iSetTL2 = -1; iSetTL3 = -1; iSetTL4 = -1;
	iSetTM1 = -1; iSetTM2 = -1; iSetTM3 = -1; iSetTM4 = -1;
	iSetTR1 = -1; iSetTR2 = -1; iSetTR3 = -1; iSetTR4 = -1;
	iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
	iSetL1 = -1; iSetL2 = -1; iSetL3 = -1; iSetL4 = -1;
	iSetR1 = -1; iSetR2 = -1; iSetR3 = -1; iSetR4 = -1;
	iSetBackTL = -1; iSetBackTM = -1; iSetBackTR = -1;
	iSetBackL = -1; iSetBackM = -1; iSetBackR = -1;

	/*** Random tile. ***/
	if (iTile == -1)
	{
		switch (cCurType)
		{
			case 'd':
				do {
					iTile = 1 + (int) (72.0 * rand() / (RAND_MAX + 1.0));
				} while ((iTile == 48) || (iTile == 64) || (iTile == 65) ||
				(iTile == 67) || (iTile == 68) || (iTile == 69) || (iTile == 70));
				break;
			case 'p':
				do {
					iTile = 1 + (int) (72.0 * rand() / (RAND_MAX + 1.0));
				} while (iTile == 62);
				break;
			case 'o':
				iTemp = 1 + (int) (3.0 * rand() / (RAND_MAX + 1.0));
				switch (iTemp)
				{
					case 1: iTile = 17; break;
					case 2: iTile = 18; break;
					case 3: iTile = 19; break;
				}
				break;
			case 'c':
				do {
					iTile = 1 + (int) (57.0 * rand() / (RAND_MAX + 1.0));
				} while ((iTile == 36) || (iTile == 51));
				break;
			case 'r':
				iTile = 1 + (int) (55.0 * rand() / (RAND_MAX + 1.0));
				break;
			case 't':
				do {
					iTile = 1 + (int) (58.0 * rand() / (RAND_MAX + 1.0));
				} while (((iTile >= 27) && (iTile <= 31)) || ((iTile >= 40) &&
					(iTile <= 44)) || ((iTile >= 53) && (iTile <= 57)));
				break;
			case 'b': case 'f': case 'g': case 'h': case 'i':
			case 'j': case 'l': case 'm': case 's': case 'u':
				do {
					iTile = 1 + (int) (48.0 * rand() / (RAND_MAX + 1.0));
				} while ((iTile == 21) || (iTile == 23) || (iTile == 25));

				/*** Default background value. ***/
				switch (cCurType)
				{
					case 'b': iBackA[iRoom][iLocation - 1] = 0x01; break;
					case 'f': iBackA[iRoom][iLocation - 1] = 0x01; break;
					case 's': iBackA[iRoom][iLocation - 1] = 0x19; break;
					case 'l': iBackA[iRoom][iLocation - 1] = 0x29; break;
					case 'g': iBackA[iRoom][iLocation - 1] = 0x01; break;
					case 'u': iBackA[iRoom][iLocation - 1] = 0x33; break;
					case 'm': iBackA[iRoom][iLocation - 1] = 0x6c; break;
					case 'h': iBackA[iRoom][iLocation - 1] = 0x00; break;
					case 'j': iBackA[iRoom][iLocation - 1] = 0x00; break;
					case 'i': iBackA[iRoom][iLocation - 1] = 0x53; break;
				}
				break;
		}
	}

	/*** Make sure the disabled PoP1 guards can't be used. ***/
	if (iEditPoP == 1)
	{
		if (((iTile >= 92) && (iTile <= 105)) && (iCurGuard != 0)) { return; }
		if (((iTile == 75) || (iTile == 76)) && (iCurGuard != 1)) { return; }
		if (((iTile == 77) || (iTile == 78)) && (iCurGuard != 2)) { return; }
		if (((iTile == 108) || (iTile == 109)) && (iCurGuard != 3)) { return; }
		if (((iTile == 73) || (iTile == 74)) && (iCurGuard != 4)) { return; }
	}

	if (((iTile == 106) && (iEditPoP == 2)) || /*** kid, turned right ***/
		((iTile == 92) && (iEditPoP == 3)))
	{
		if ((arKidRoom[1] != iCurRoom) || (arKidPos[1] != iLocation) ||
			(arKidDir[1] != 0))
		{
			arKidRoom[1] = iCurRoom;
			arKidPos[1] = iLocation;
			arKidDir[1] = 0;
			PlaySound ("wav/hum_adj.wav");
		}
	}
	if (((iTile == 107) && (iEditPoP == 2)) || /*** kid, turned left ***/
		((iTile == 93) && (iEditPoP == 3)))
	{
		if ((arKidRoom[1] != iCurRoom) || (arKidPos[1] != iLocation) ||
			(arKidDir[1] != 255))
		{
			arKidRoom[1] = iCurRoom;
			arKidPos[1] = iLocation;
			arKidDir[1] = 255;
			PlaySound ("wav/hum_adj.wav");
		}
	}

	if ((cCurType == 'd') || (cCurType == 'p'))
	{
		switch (iTile)
		{
			case 1: SetLocation (iRoom, iLocation, 0, 0, -1, -1, -1); break;
			case 2: SetLocation (iRoom, iLocation, 0, 1, -1, -1, -1); break;
			case 3: SetLocation (iRoom, iLocation, 0, 2, -1, -1, -1); break;
			case 4: SetLocation (iRoom, iLocation, 0, 3, -1, -1, -1); break;
			case 5: SetLocation (iRoom, iLocation, 0, 255, -1, -1, -1); break;
			case 6: SetLocation (iRoom, iLocation, 1, 0, -1, -1, -1); break;
			case 7: SetLocation (iRoom, iLocation, 1, 1, -1, -1, -1); break;
			case 8: SetLocation (iRoom, iLocation, 1, 2, -1, -1, -1); break;
			case 9: SetLocation (iRoom, iLocation, 1, 3, -1, -1, -1); break;
			case 10: SetLocation (iRoom, iLocation, 1, 255, -1, -1, -1); break;
			case 11: SetLocation (iRoom, iLocation, 2, 0, -1, -1, -1); break;
			case 12: SetLocation (iRoom, iLocation, 2, 1, -1, -1, -1); break;
			case 13: SetLocation (iRoom, iLocation, 2, 2, -1, -1, -1); break;
			case 14: SetLocation (iRoom, iLocation, 2, 3, -1, -1, -1); break;
			case 15: SetLocation (iRoom, iLocation, 2, 4, -1, -1, -1); break;
			case 16: SetLocation (iRoom, iLocation, 2, 5, -1, -1, -1); break;
			case 17: SetLocation (iRoom, iLocation, 2, 6, -1, -1, -1); break;
			case 18: SetLocation (iRoom, iLocation, 2, 7, -1, -1, -1); break;
			case 19: SetLocation (iRoom, iLocation, 2, 8, -1, -1, -1); break;
			case 20: SetLocation (iRoom, iLocation, 2, 9, -1, -1, -1); break;
			case 21: SetLocation (iRoom, iLocation, 3, 0, -1, -1, -1); break;
			case 22: SetLocation (iRoom, iLocation, 4, 0, -1, -1, -1); break;
			case 23: SetLocation (iRoom, iLocation, 4, 1, -1, -1, -1); break;
			case 24: SetLocation (iRoom, iLocation, 5, 0, -1, -1, -1); break;
			case 25: SetLocation (iRoom, iLocation, 6,
				iChangeEvent, -1, -1, -1); break;
			case 26: SetLocation (iRoom, iLocation, 7, 0, -1, -1, -1); break;
			case 27: SetLocation (iRoom, iLocation, 7, 1, -1, -1, -1); break;
			case 28: SetLocation (iRoom, iLocation, 7, 2, -1, -1, -1); break;
			case 29: SetLocation (iRoom, iLocation, 7, 3, -1, -1, -1); break;
			case 30: SetLocation (iRoom, iLocation, 8, 0, -1, -1, -1); break;
			case 31: SetLocation (iRoom, iLocation, 9, 0, -1, -1, -1); break;
			case 32: SetLocation (iRoom, iLocation, 10, 0, -1, -1, -1); break;
			case 33: SetLocation (iRoom, iLocation, 10, 1, -1, -1, -1); break;
			case 34: SetLocation (iRoom, iLocation, 10, 2, -1, -1, -1); break;
			case 35: SetLocation (iRoom, iLocation, 10, 3, -1, -1, -1); break;
			case 36: SetLocation (iRoom, iLocation, 10, 4, -1, -1, -1); break;
			case 37: SetLocation (iRoom, iLocation, 10, 5, -1, -1, -1); break;
			case 38: SetLocation (iRoom, iLocation, 10, 6, -1, -1, -1); break;
			case 39: SetLocation (iRoom, iLocation, 11, 0, -1, -1, -1); break;
			case 40: SetLocation (iRoom, iLocation, 12, 0, -1, -1, -1); break;
			case 41: SetLocation (iRoom, iLocation, 12, 1, -1, -1, -1); break;
			case 42: SetLocation (iRoom, iLocation, 12, 2, -1, -1, -1); break;
			case 43: SetLocation (iRoom, iLocation, 12, 3, -1, -1, -1); break;
			case 44: SetLocation (iRoom, iLocation, 12, 4, -1, -1, -1); break;
			case 45: SetLocation (iRoom, iLocation, 12, 5, -1, -1, -1); break;
			case 46: SetLocation (iRoom, iLocation, 12, 6, -1, -1, -1); break;
			case 47: SetLocation (iRoom, iLocation, 12, 7, -1, -1, -1); break;
			case 48: SetLocation (iRoom, iLocation, 13, 0, -1, -1, -1); break;
			case 49: SetLocation (iRoom, iLocation, 14, 0, -1, -1, -1); break;
			case 50: SetLocation (iRoom, iLocation, 15,
				iChangeEvent, -1, -1, -1); break;
			case 51: SetLocation (iRoom, iLocation, 16, 0, -1, -1, -1); break;
			case 52: SetLocation (iRoom, iLocation, 17, 0, -1, -1, -1); break;
			case 53: SetLocation (iRoom, iLocation, 18, 0, -1, -1, -1); break;
			case 54: SetLocation (iRoom, iLocation, 18, 1, -1, -1, -1); break;
			case 55: SetLocation (iRoom, iLocation, 18, 2, -1, -1, -1); break;
			case 56: SetLocation (iRoom, iLocation, 18, 3, -1, -1, -1); break;
			case 57: SetLocation (iRoom, iLocation, 18, 4, -1, -1, -1); break;
			case 58: SetLocation (iRoom, iLocation, 18, 5, -1, -1, -1); break;
			case 59: SetLocation (iRoom, iLocation, 19, 0, -1, -1, -1); break;
			case 60: SetLocation (iRoom, iLocation, 20, 0, -1, -1, -1); break;
			case 61: SetLocation (iRoom, iLocation, 20, 1, -1, -1, -1); break;
			case 62: SetLocation (iRoom, iLocation, 21, 0, -1, -1, -1); break;
			case 63: SetLocation (iRoom, iLocation, 22, 0, -1, -1, -1); break;
			case 64: SetLocation (iRoom, iLocation, 23, 0, -1, -1, -1); break;
			case 65: SetLocation (iRoom, iLocation, 24, 0, -1, -1, -1); break;
			case 66: SetLocation (iRoom, iLocation, 25, 0, -1, -1, -1); break;
			case 67: SetLocation (iRoom, iLocation, 26, 0, -1, -1, -1); break;
			case 68: SetLocation (iRoom, iLocation, 27, 0, -1, -1, -1); break;
			case 69: SetLocation (iRoom, iLocation, 28, 0, -1, -1, -1); break;
			case 70: SetLocation (iRoom, iLocation, 29, 0, -1, -1, -1); break;
			case 71: SetLocation (iRoom, iLocation, 30, 0, -1, -1, -1); break;
			case 72: SetLocation (iRoom, iLocation, 43, 0, -1, -1, -1); break;
			case 73: /*** shadow, turned right ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 0))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 0, iGuardSkill, -1); } break;
			case 74: /*** shadow, turned left ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 255))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 255, iGuardSkill, -1); } break;
			case 75: /*** fat, turned right ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 0))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 0, iGuardSkill, -1); } break;
			case 76: /*** fat, turned left ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 255))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 255, iGuardSkill, -1); } break;
			case 77: /*** skeleton, turned right ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 0))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 0, iGuardSkill, -1); } break;
			case 78: /*** skeleton, turned left ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 255))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 255, iGuardSkill, -1); } break;
			case 108: /*** jaffar, turned right ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 0))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 0, iGuardSkill, -1); } break;
			case 109: /*** jaffar, turned left ***/
				if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
					&& (sGuardDirections[iCurRoom - 1] == 255))
					{ sGuardLocations[iCurRoom - 1] = 30; } else
					{ SetGuard (iLocation - 1, 255, iGuardSkill, -1); } break;
			case 92: /*** normal guards ***/
			case 93:
			case 94:
			case 95:
			case 96:
			case 97:
			case 98:
			case 99:
			case 100:
			case 101:
			case 102:
			case 103:
			case 104:
			case 105:
				switch (iTile) /*** store color ***/
				{
					case 92: case 93: iTemp = 1; break;
					case 94: case 95: iTemp = 2; break;
					case 96: case 97: iTemp = 3; break;
					case 98: case 99: iTemp = 4; break;
					case 100: case 101: iTemp = 5; break;
					case 102: case 103: iTemp = 6; break;
					case 104: case 105: iTemp = 7; break;
					default: iTemp = 1; break; /*** As a fallback. ***/
				}
				switch (iTile)
				{
					case 92: case 94: case 96: case 98: case 100: case 102: case 104:
						if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
							&& (sGuardDirections[iCurRoom - 1] == 0) &&
							(sGuardColors[iCurRoom - 1] == iTemp))
							{ sGuardLocations[iCurRoom - 1] = 30; } else
							{ SetGuard (iLocation - 1, 0, iGuardSkill, iTemp); } break;
					case 93: case 95: case 97: case 99: case 101: case 103: case 105:
						if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
							&& (sGuardDirections[iCurRoom - 1] == 255) &&
							(sGuardColors[iCurRoom - 1] == iTemp))
							sGuardLocations[iCurRoom - 1] = 30; else
							SetGuard (iLocation - 1, 255, iGuardSkill, iTemp);
						break;
				}
				break;
		}
	}
	if (cCurType == 'o')
	{
		switch (iTile)
		{
			case 17: SetLocation (iRoom, iLocation, 0, 0, -1, -1, -1); break;
			case 18: SetLocation (iRoom, iLocation, 1, 0, -1, -1, -1); break;
			case 19: SetLocation (iRoom, iLocation, 20, 0, -1, -1, -1); break;
			case 23: SetLocation (iRoom, iLocation, 3, 0, -1, -1, -1); break;
			case 24: SetLocation (iRoom, iLocation, 37, 0, -1, -1, -1); break;
			case 25: SetLocation (iRoom, iLocation, 38, 0, -1, -1, -1); break;
			case 26: SetLocation (iRoom, iLocation, 39, 0, -1, -1, -1); break;
			case 29: SetLocation (iRoom, iLocation, 4,
				PercentAsMod (iChangePercent, 4), -1, -1, -1); break;
			case 30: SetLocation (iRoom, iLocation, 28, 0, -1, -1, -1); break;
			case 31: SetLocation (iRoom, iLocation, 29, 0, -1, -1, -1); break;
			case 32: SetLocation (iRoom, iLocation, 30, 0, -1, -1, -1); break;
			case 36: SetLocation (iRoom, iLocation, 10, 32, -1, -1, -1); break;
			case 37: SetLocation (iRoom, iLocation, 31, 0, -1, -1, -1); break;
			case 38: SetLocation (iRoom, iLocation, 40, 0, -1, -1, -1); break;
			case 39: SetLocation (iRoom, iLocation, 41, 0, -1, -1, -1); break;
			case 40: SetLocation (iRoom, iLocation, 2, 0, -1, -1, -1); break;
			case 41: SetLocation (iRoom, iLocation, 5,
				iChangeEvent, -1, -1, -1); break;
			case 42: SetLocation (iRoom, iLocation, 6,
				iChangeEvent, -1, -1, -1); break;
			case 43: SetLocation (iRoom, iLocation, 7, 0, -1, -1, -1); break;
			case 44: SetLocation (iRoom, iLocation, 7, 1, -1, -1, -1); break;
			case 45: SetLocation (iRoom, iLocation, 7, 2, -1, -1, -1); break;
			case 46: SetLocation (iRoom, iLocation, 7, 3, -1, -1, -1); break;
			case 47: SetLocation (iRoom, iLocation, 8, 0, -1, -1, -1); break;
			case 48: SetLocation (iRoom, iLocation, 9, 0, -1, -1, -1); break;
			case 49: SetLocation (iRoom, iLocation, 10, 0, -1, -1, -1); break;
			case 50: SetLocation (iRoom, iLocation, 10, 64, -1, -1, -1); break;
			case 51: SetLocation (iRoom, iLocation, 10, 96, -1, -1, -1); break;
			case 52: SetLocation (iRoom, iLocation, 10, 128, -1, -1, -1); break;
			case 53: SetLocation (iRoom, iLocation, 10, 160, -1, -1, -1); break;
			case 54: SetLocation (iRoom, iLocation, 10, 192, -1, -1, -1); break;
			case 55: SetLocation (iRoom, iLocation, 10, 224, -1, -1, -1); break;
			case 56: SetLocation (iRoom, iLocation, 11, JumpsAsMod
				(iChangeJumps) + FrameAsMod (iChangeFrame), -1, -1, -1); break;
			case 57: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame), -1, -1, -1); break;
			case 58: SetLocation (iRoom, iLocation, 13, 0, -1, -1, -1); break;
			case 59: SetLocation (iRoom, iLocation, 14, 0, -1, -1, -1); break;
			case 60: SetLocation (iRoom, iLocation, 15, 0, -1, -1, -1); break;
			case 61: SetLocation (iRoom, iLocation, 16, 0, -1, -1, -1); break;
			case 62: SetLocation (iRoom, iLocation, 17,
				PercentAsMod (iChangePercent, 17), -1, -1, -1); break;
			case 66: SetLocation (iRoom, iLocation, 18, 0, -1, -1, -1); break;
			case 67: SetLocation (iRoom, iLocation, 19, 0, -1, -1, -1); break;
			case 68: SetLocation (iRoom, iLocation, 21, 0, -1, -1, -1); break;
			case 69: SetLocation (iRoom, iLocation, 22, 0, -1, -1, -1); break;
			case 70: SetLocation (iRoom, iLocation, 22, 1, -1, -1, -1); break;
			case 71: SetLocation (iRoom, iLocation, 23, 0, -1, -1, -1); break;
			case 72: SetLocation (iRoom, iLocation, 24, 0, -1, -1, -1); break;
			case 73: SetLocation (iRoom, iLocation, 25, 0, -1, -1, -1); break;
			case 74: SetLocation (iRoom, iLocation, 26, 0, -1, -1, -1); break;
			case 75: SetLocation (iRoom, iLocation, 27, 0, -1, -1, -1); break;
			case 79: SetLocation (iRoom, iLocation, 32, 0, -1, -1, -1); break;
			case 80: SetLocation (iRoom, iLocation, 33, 0, -1, -1, -1); break;
			case 81: SetLocation (iRoom, iLocation, 34,
				iChangeEvent, -1, -1, -1); break;
			case 82: SetLocation (iRoom, iLocation, 35, 0, -1, -1, -1); break;
			case 83: SetLocation (iRoom, iLocation, 36, FrameAsMod
				(iChangeFrame), -1, -1, -1); break;
			case 87: SetLocation (iRoom, iLocation, 43, 0, -1, -1, -1); break;
			case 88: SetLocation (iRoom, iLocation, 44, 0, -1, -1, -1); break;
		}
	}
	if (cCurType == 'c')
	{
		switch (iTile)
		{
			case 1: SetLocation (iRoom, iLocation, 0, 0,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 2: SetLocation (iRoom, iLocation, 0, 1,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 3: SetLocation (iRoom, iLocation, 0, 2,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 4: SetLocation (iRoom, iLocation, 0, 3,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 5: SetLocation (iRoom, iLocation, 0, 4,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 6: SetLocation (iRoom, iLocation, 1, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 7: SetLocation (iRoom, iLocation, 1, 1,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 8: SetLocation (iRoom, iLocation, 1, 2,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 9: SetLocation (iRoom, iLocation, 2, 0,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 10: SetLocation (iRoom, iLocation, 2, 5,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 11: SetLocation (iRoom, iLocation, 3, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 12: SetLocation (iRoom, iLocation, 4, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 13: SetLocation (iRoom, iLocation, 4, PercentAsMod
				(iChangePercent, 4), ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 14: SetLocation (iRoom, iLocation, 4, 200,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 15: SetLocation (iRoom, iLocation, 8, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 16: SetLocation (iRoom, iLocation, 8, 1,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 17: SetLocation (iRoom, iLocation, 8, 2,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 18: SetLocation (iRoom, iLocation, 9, 0,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 19: SetLocation (iRoom, iLocation, 10, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 20: SetLocation (iRoom, iLocation, 10, 32,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 21: SetLocation (iRoom, iLocation, 10, 64,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 22: SetLocation (iRoom, iLocation, 10, 96,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 23: SetLocation (iRoom, iLocation, 10, 128,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 24: SetLocation (iRoom, iLocation, 10, 160,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 25: SetLocation (iRoom, iLocation, 10, 192,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 26: SetLocation (iRoom, iLocation, 10, 224,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 27: SetLocation (iRoom, iLocation, 11, JumpsAsMod (iChangeJumps) +
				FrameAsMod (iChangeFrame), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 28: SetLocation (iRoom, iLocation, 11, JumpsAsMod (iChangeJumps) +
				FrameAsMod (iChangeFrame) + 128,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 29: SetLocation (iRoom, iLocation, 14, 0,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 30: SetLocation (iRoom, iLocation, 14, 1,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 31: SetLocation (iRoom, iLocation, 14, 2,
				ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 32: SetLocation (iRoom, iLocation, 16, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 33: SetLocation (iRoom, iLocation, 17, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 34: SetLocation (iRoom, iLocation, 17, PercentAsMod
				(iChangePercent, 17), ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 35: SetLocation (iRoom, iLocation, 17, 42,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 36: SetLocation (iRoom, iLocation, 18, 0,
				ExtractedAsMod2 (' ', ' '), -1, -1); break;
			case 37: SetLocation (iRoom, iLocation, 19, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 38: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 0), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 39: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 1), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 40: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 2), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 41: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 3), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 42: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 4), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 43: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 5), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 44: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 6), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 45: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 7), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 46: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 8), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 47: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 9), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 48: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 10), ExtractedAsMod2 ('b', ' '), -1, -1); break;
			case 49: SetLocation (iRoom, iLocation, 23, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 50: SetLocation (iRoom, iLocation, 24, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 51: SetLocation (iRoom, iLocation, 28, 0,
				ExtractedAsMod2 (' ', ' '), -1, -1); break;
			case 52: SetLocation (iRoom, iLocation, 32, 0,
				ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 53: SetLocation (iRoom, iLocation, 33, 0,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 54: SetLocation (iRoom, iLocation, 34, iChangeEvent,
				ExtractedAsMod2 ('b', ' ') + 0, -1, -1); break;
			case 55: SetLocation (iRoom, iLocation, 34, iChangeEvent,
				ExtractedAsMod2 ('b', ' ') + 8, -1, -1); break;
			case 56: SetLocation (iRoom, iLocation, 35, 0,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 57: SetLocation (iRoom, iLocation, 36, FrameAsMod
				(iChangeFrame), ExtractedAsMod2 ('b', 's'), -1, -1); break;
			case 58: SetLocation (iRoom, iLocation, 44, 0,
				ExtractedAsMod2 (' ', ' '), -1, -1); break;
		}
	}
	if (cCurType == 'r')
	{
		switch (iTile)
		{
			case 1: SetLocation (iRoom, iLocation, 0, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 2: SetLocation (iRoom, iLocation, 1, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 3: SetLocation (iRoom, iLocation, 1, 1,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 4: SetLocation (iRoom, iLocation, 1, 2,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 5: SetLocation (iRoom, iLocation, 1, 3,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 6: SetLocation (iRoom, iLocation, 2, 0,
				ExtractedAsMod2 (' ', ' '), -1, -1); break;
			case 7: SetLocation (iRoom, iLocation, 3, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 8: SetLocation (iRoom, iLocation, 3, 1,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 9: SetLocation (iRoom, iLocation, 3, 2,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 10: SetLocation (iRoom, iLocation, 4, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 11: SetLocation (iRoom, iLocation, 4, PercentAsMod
				(iChangePercent, 4), ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 12: SetLocation (iRoom, iLocation, 4, 200,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 13: SetLocation (iRoom, iLocation, 5, iChangeEvent,
				ExtractedAsMod2 (' ', ' ') + 0, -1, -1); break;
			case 14: SetLocation (iRoom, iLocation, 5, iChangeEvent,
				ExtractedAsMod2 (' ', ' ') + 8, -1, -1); break;
			case 15: SetLocation (iRoom, iLocation, 6, iChangeEvent,
				ExtractedAsMod2 (' ', ' ') + 0, -1, -1); break;
			case 16: SetLocation (iRoom, iLocation, 6, iChangeEvent,
				ExtractedAsMod2 (' ', ' ') + 8, -1, -1); break;
			case 17: SetLocation (iRoom, iLocation, 7, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 18: SetLocation (iRoom, iLocation, 7, 1,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 19: SetLocation (iRoom, iLocation, 7, 2,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 20: SetLocation (iRoom, iLocation, 7, 3,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 21: SetLocation (iRoom, iLocation, 8, 0,
				ExtractedAsMod2 ('c', ' '), -1, -1); break;
			case 22: SetLocation (iRoom, iLocation, 9, 0,
				ExtractedAsMod2 ('c', ' '), -1, -1); break;
			case 23: SetLocation (iRoom, iLocation, 10, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 24: SetLocation (iRoom, iLocation, 10, 32,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 25: SetLocation (iRoom, iLocation, 10, 64,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 26: SetLocation (iRoom, iLocation, 10, 96,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 27: SetLocation (iRoom, iLocation, 10, 128,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 28: SetLocation (iRoom, iLocation, 10, 160,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 29: SetLocation (iRoom, iLocation, 10, 192,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 30: SetLocation (iRoom, iLocation, 10, 224,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 31: SetLocation (iRoom, iLocation, 11, JumpsAsMod
				(iChangeJumps) + FrameAsMod (iChangeFrame),
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 32: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 0, ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 33: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 32, ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 34: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 128, ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 35: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 160, ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 36: SetLocation (iRoom, iLocation, 13, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 37: SetLocation (iRoom, iLocation, 13, 32,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 38: SetLocation (iRoom, iLocation, 14, 16,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 39: SetLocation (iRoom, iLocation, 14, 32,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 40: SetLocation (iRoom, iLocation, 14, 64,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 41: SetLocation (iRoom, iLocation, 15, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 42: SetLocation (iRoom, iLocation, 15, 1,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 43: SetLocation (iRoom, iLocation, 15, 2,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 44: SetLocation (iRoom, iLocation, 15, 3,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 45: SetLocation (iRoom, iLocation, 16, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 46: SetLocation (iRoom, iLocation, 17, 0,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 47: SetLocation (iRoom, iLocation, 17, PercentAsMod
				(iChangePercent, 17), ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 48: SetLocation (iRoom, iLocation, 17, 42,
				ExtractedAsMod2 (' ', 's'), -1, -1); break;
			case 49: SetLocation (iRoom, iLocation, 18, 0,
				ExtractedAsMod2 (' ', ' '), -1, -1); break;
			case 50: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 0), ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 51: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 1), ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 52: SetLocation (iRoom, iLocation, 20, WallAsMod
				(iChangeWall, 2), ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 53: SetLocation (iRoom, iLocation, 21, 0,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 54: SetLocation (iRoom, iLocation, 22, 2,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
			case 55: SetLocation (iRoom, iLocation, 22, 1,
				ExtractedAsMod2 ('c', 's'), -1, -1); break;
		}
	}
	if (cCurType == 't')
	{
		switch (iTile)
		{
			case 1: SetLocation (iRoom, iLocation, 0, 0, 0, -1, -1); break;
			case 2: SetLocation (iRoom, iLocation, 1, 0, 0, -1, -1); break;
			case 3: SetLocation (iRoom, iLocation, 1, 1, 0, -1, -1); break;
			case 4: SetLocation (iRoom, iLocation, 2, 0, 0, -1, -1); break;
			case 5: SetLocation (iRoom, iLocation, 2, 5, 0, -1, -1); break;
			case 6: SetLocation (iRoom, iLocation, 3, 0, 0, -1, -1); break;
			case 7: SetLocation (iRoom, iLocation, 3, 1, 0, -1, -1); break;
			case 8: SetLocation (iRoom, iLocation, 4, 0, 0, -1, -1); break;
			case 9: SetLocation (iRoom, iLocation, 4,
				PercentAsMod (iChangePercent, 4), 0, -1, -1); break;
			case 10: SetLocation (iRoom, iLocation, 4, 200, 0, -1, -1); break;
			case 11: SetLocation (iRoom, iLocation, 5,
				iChangeEvent, 0, -1, -1); break;
			case 12: SetLocation (iRoom, iLocation, 5,
				iChangeEvent, 8, -1, -1); break;
			case 13: SetLocation (iRoom, iLocation, 6,
				iChangeEvent, 0, -1, -1); break;
			case 14: SetLocation (iRoom, iLocation, 6,
				iChangeEvent, 8, -1, -1); break;
			case 15: SetLocation (iRoom, iLocation, 8, 0, 0, -1, -1); break;
			case 16: SetLocation (iRoom, iLocation, 9, 0, 0, -1, -1); break;
			case 17: SetLocation (iRoom, iLocation, 10, 0, 0, -1, -1); break;
			case 18: SetLocation (iRoom, iLocation, 10, 32, 0, -1, -1); break;
			case 19: SetLocation (iRoom, iLocation, 10, 64, 0, -1, -1); break;
			case 20: SetLocation (iRoom, iLocation, 10, 96, 0, -1, -1); break;
			case 21: SetLocation (iRoom, iLocation, 10, 128, 0, -1, -1); break;
			case 22: SetLocation (iRoom, iLocation, 10, 160, 0, -1, -1); break;
			case 23: SetLocation (iRoom, iLocation, 10, 192, 0, -1, -1); break;
			case 24: SetLocation (iRoom, iLocation, 10, 224, 0, -1, -1); break;
			case 25: SetLocation (iRoom, iLocation, 11, JumpsAsMod
				(iChangeJumps) + FrameAsMod (iChangeFrame), 0, -1, -1); break;
			case 26: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 0, 0, -1, -1); break;
			case 32: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 32, 0, -1, -1); break;
			case 33: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 128, 0, -1, -1); break;
			case 34: SetLocation (iRoom, iLocation, 12, FrameAsMod
				(iChangeFrame) + 160, 0, -1, -1); break;
			case 35: SetLocation (iRoom, iLocation, 13, 0, 0, -1, -1); break;
			case 36: SetLocation (iRoom, iLocation, 13, 32, 0, -1, -1); break;
			case 37: SetLocation (iRoom, iLocation, 14, 0, 0, -1, -1); break;
			case 38: SetLocation (iRoom, iLocation, 14, 1, 0, -1, -1); break;
			case 39: SetLocation (iRoom, iLocation, 16, 0, 0, -1, -1); break;
			case 45: SetLocation (iRoom, iLocation, 17, 0, 0, -1, -1); break;
			case 46: SetLocation (iRoom, iLocation, 17,
				PercentAsMod (iChangePercent, 17), 0, -1, -1); break;
			case 47: SetLocation (iRoom, iLocation, 17, 42, 0, -1, -1); break;
			case 48: SetLocation (iRoom, iLocation, 18, 0, 0, -1, -1); break;
			case 49: SetLocation (iRoom, iLocation, 19, 0, 0, -1, -1); break;
			case 50: SetLocation (iRoom, iLocation, 20,
				WallAsMod (iChangeWall, 0), 0, -1, -1); break;
			case 51: SetLocation (iRoom, iLocation, 25,
				WallAsMod (iChangeWall, 0), 0, -1, -1); break;
			case 52: SetLocation (iRoom, iLocation, 26, 0, 0, -1, -1); break;
			case 58: SetLocation (iRoom, iLocation, 32, 0, 0, -1, -1); break;
		}
	}
	if (iEditPoP == 3)
	{
		iMod = 0x00; /*** Default. ***/
		CurTypeBlocks();
		iU = TileUnderMe (iRoom, iLocation, iTileUnderMe);
		switch (iTile)
		{
			/*********/
			/* Row 1 */
			/*********/
			case 1: /*** space ***/
				iB1 = 0x00; iB2 = 0x00; iB3 = 0x00; iB4 = 0x00; break;
			case 2: /*** floor ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x00; iB4 = 0x01; break;
			case 3: /*** wall ***/
				iB1 = iWallOne; iB2 = iWallTwo[iU]; iB3 = 0x00; iB4 = 0x02; break;
			case 4: /*** pillar ***/
				iB1 = iPillarOne; iB2 = iPillarTwo[iU]; iB3 = 0x00; iB4 = 0x01; break;
			case 5: /*** loose ***/
				iB1 = 0x00; iB2 = iSpaceTwo[iU]; iB3 = 0x02; iB4 = 0x00;
				iMod = StuckAsMod (iChangeStuck, 0x02);
				break;
			case 6: /*** debris ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x17; iB4 = 0x01; break;
			case 7: /*** fake floor; space ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x00; iB4 = 0x00; break;
			case 8: /*** fake floor; space; down only ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x1b; iB4 = 0x01; break;
			case 9: /*** fake wall; space ***/
				iB1 = iWallOne; iB2 = iWallTwo[iU]; iB3 = 0x00; iB4 = 0x00; break;
			case 10: /*** fake space; floor ***/
				iB1 = 0x00; iB2 = 0x00; iB3 = 0x00; iB4 = 0x01; break;
			case 11: /*** fake wall; floor ***/
				iB1 = iWallOne; iB2 = iWallTwo[iU]; iB3 = 0x00; iB4 = 0x01; break;
			case 12: /*** fake space; wall ***/
				iB1 = 0x00; iB2 = 0x00; iB3 = 0x00; iB4 = 0x02; break;
			case 13: /*** fake floor; wall ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x00; iB4 = 0x02; break;
			/*********/
			/* Row 2 */
			/*********/
			case 14: /*** raise ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x04; iB4 = 0x01;
				iMod = iChangeEvent;
				break;
			case 15: /*** drop ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x05; iB4 = 0x01;
				iMod = iChangeEvent;
				break;
			case 16: /*** gate; 0% (closed) ***/
				iB1 = iGateOne; iB2 = iGateTwo[iU]; iB3 = 0x06; iB4 = 0x01;
				iMod = 0x00;
				break;
			case 17: /*** gate; % ***/
				iB1 = iGateOne; iB2 = iGateTwo[iU]; iB3 = 0x06; iB4 = 0x01;
				iMod = PercentAsMod (iChangePercent, 6);
				break;
			case 18: /*** gate; 100% (open) ***/
				iB1 = iGateOne; iB2 = iGateTwo[iU]; iB3 = 0x06; iB4 = 0x01;
				iMod = 0xff;
				break;
			case 19: /*** gate top ***/
				iB1 = iDoorTopOne; iB2 = iDoorTopTwo[iU]; iB3 = 0x18; iB4 = 0x00;
				break;
			case 20: case 21: /*** level door begin (single and set) ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x24; iB4 = 0x01; break;
			case 22: case 23: /*** level door end (single and set) ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x07; iB4 = 0x01; break;
			case 24: case 25: /*** teleport (single and set) ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x23; iB4 = 0x01;
				iMod = iChangeEvent;
				break;
			case 26: /*** sword ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x0a; iB4 = 0x01; break;
			/*********/
			/* Row 3 */
			/*********/
			case 27: /*** chomper ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x0c; iB4 = 0x01;
				iMod = StuckAsMod (iChangeStuck, 0x0c);
				break;
			case 28: /*** spike ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x0e; iB4 = 0x01;
				iMod = StuckAsMod (iChangeStuck, 0x0e);
				break;
			case 29: /*** guillotine ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x0d; iB4 = 0x01;
				iMod = StuckAsMod (iChangeStuck, 0x0d);
				break;
			case 30: /*** crusher ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x10; iB4 = 0x01;
				iMod = StuckAsMod (iChangeStuck, 0x10);
				break;
			case 31: /*** lava ***/
				iB1 = iLavaOne; iB2 = iFloorTwo[iU]; iB3 = 0x27; iB4 = 0x01; break;
			case 32: /*** fire ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x19; iB4 = 0x01; break;
			case 33: /*** spinning log ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x1e; iB4 = 0x01;
				iMod = StuckAsMod (iChangeStuck, 0x1e);
				break;
			case 34: /*** stars ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x20; iB4 = 0x01; break;
			case 35: /*** mirror ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x08; iB4 = 0x01; break;
			case 36: /*** <<< ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x2b; iB4 = 0x01; break;
			case 37: /*** >>> ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x2a; iB4 = 0x01; break;
			case 38: /*** skeleton ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x09; iB4 = 0x01; break;
			case 39: /*** skeleton continue ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x28; iB4 = 0x01; break;
			/*********/
			/* Row 4 */
			/*********/
			case 40: /*** heal potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x12; iB4 = 0x01; break;
			case 41: /*** life potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x13; iB4 = 0x01; break;
			case 42: /*** hurt potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x14; iB4 = 0x01; break;
			case 43: /*** upside down potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x15; iB4 = 0x01; break;
			case 44: /*** slow fall potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x16; iB4 = 0x01; break;
			case 45: /*** potion of warp ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x1a; iB4 = 0x01; break;
			case 46: /*** kill potion ***/
				iB1 = 0x00; iB2 = iFloorTwo[iU]; iB3 = 0x1c; iB4 = 0x01; break;
			case 47: /*** torch (on floor) ***/
				iB1 = 0x00; iB2 = iTorchOFTwo[iU];
				iB3 = iTorchOFThree; iB4 = 0x01; break;
			case 48: /*** torch (on space) ***/
				iB1 = iTorchOnSpaceOne; iB2 = iTorchOnSpaceTwo;
				iB3 = iTorchOnSpaceThree; iB4 = 0x00; break;
			default:
				/*** To prevent warnings. Do not printf a WARN here. ***/
				iB1 = 0x00; iB2 = 0x00; iB3 = 0x00; iB4 = 0x00; break;
		}
		if ((iTile >= 1) && (iTile <= 48))
		{
			SetLocationSNES (iRoom, iLocation, iB1, iB2, iB3, iB4,
				iMod, iTileUnderMe);

			/*** jaffar background ***/
			if (cCurType == 'j')
			{
				if ((iTile == 1) || (iTile == 5) || (iTile == 10) ||
					(iTile == 12) || (iTile == 19) || (iTile == 48))
				{
					iBackA[iRoom][iLocation - 1] = 0x00;
				} else if ((iTile == 3) || (iTile == 9) || (iTile == 11)) {
					iBackA[iRoom][iLocation - 1] = 0x01;
				} else {
					iBackA[iRoom][iLocation - 1] = 0x04;
				}
			}
		}

		/*** guards ***/
		if ((iTile >= 94) && (iTile <= 129))
		{
			switch (iTile)
			{
				case 94: iType = 0x03; iDir = 0; break;
				case 95: iType = 0x03; iDir = 1; break;
				case 96: iType = 0x04; iDir = 0; break;
				case 97: iType = 0x04; iDir = 1; break;
				case 98: iType = 0x05; iDir = 0; break;
				case 99: iType = 0x05; iDir = 1; break;
				case 100: iType = 0x06; iDir = 0; break;
				case 101: iType = 0x06; iDir = 1; break;
				case 102: iType = 0x07; iDir = 0; break;
				case 103: iType = 0x07; iDir = 1; break;
				case 104: iType = 0x08; iDir = 0; break;
				case 105: iType = 0x08; iDir = 1; break;
				case 106: iType = 0x09; iDir = 0; break;
				case 107: iType = 0x09; iDir = 1; break;
				case 108: iType = 0x0a; iDir = 0; break;
				case 109: iType = 0x0a; iDir = 1; break;
				case 110: iType = 0x0b; iDir = 0; break;
				case 111: iType = 0x0b; iDir = 1; break;
				case 112: iType = 0x0c; iDir = 0; break;
				case 113: iType = 0x0c; iDir = 1; break;
				case 114: iType = 0x0d; iDir = 0; break;
				case 115: iType = 0x0d; iDir = 1; break;
				case 116: iType = 0x0e; iDir = 0; break;
				case 117: iType = 0x0e; iDir = 1; break;
				case 118: iType = 0x0f; iDir = 0; break;
				case 119: iType = 0x0f; iDir = 1; break;
				case 120: iType = 0x10; iDir = 0; break;
				case 121: iType = 0x10; iDir = 1; break;
				case 122: iType = 0x11; iDir = 0; break;
				case 123: iType = 0x11; iDir = 1; break;
				case 124: iType = 0x12; iDir = 0; break;
				case 125: iType = 0x12; iDir = 1; break;
				case 126: iType = 0x13; iDir = 0; break;
				case 127: iType = 0x13; iDir = 1; break;
				case 128: iType = 0x02; iDir = 0; break;
				case 129: iType = 0x02; iDir = 1; break;
			}
			if ((sGuardLocations[iCurRoom - 1] == iLocation - 1)
				&& (sGuardDirections[iCurRoom - 1] == iDir) &&
				(sGuardTypes[iCurRoom - 1] == iType))
				sGuardLocations[iCurRoom - 1] = 0xff; else
				SetGuardSNES (iLocation - 1, iDir, iGuardSkill, iType);
		}

		/*** Entrance, exit and teleport sets. ***/
		if ((iTile == 21) || (iTile == 23) || (iTile == 25))
		{
			switch (cCurType)
			{
				case 'b':
					iSetTL1 = 0x00; iSetTL2 = 0x3c; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x3d; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x3e; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x1f; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x20; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x44; iSetBackTM = 0x45; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x19; iSetBackTM = 0x1a; iSetBackTR = -1;
						iSetBackL = 0x17; iSetBackM = 0x18; iSetBackR = -1;
					}
					break;
				case 'f':
					iSetTL1 = 0x00; iSetTL2 = 0x0e; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x0f; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x10; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x11; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x11; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x0a; iSetBackTM = 0x0a; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x17; iSetBackTM = 0x18; iSetBackTR = -1;
						iSetBackL = 0x19; iSetBackM = 0x1a; iSetBackR = -1;
					}
					break;
				case 's':
					iSetTL1 = 0x00; iSetTL2 = 0x2b; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x2c; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x2d; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x2a; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x2a; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x28; iSetBackTM = 0x30; iSetBackTR = -1;
						iSetBackL = 0x32; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x24; iSetBackTM = 0x25; iSetBackTR = -1;
						iSetBackL = 0x20; iSetBackM = 0x21; iSetBackR = -1;
					}
					break;
				case 'l':
					iSetTL1 = 0x00; iSetTL2 = 0x12; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x27; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x13; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x10; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x10; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x33; iSetBackTM = 0x34; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x2e; iSetBackTM = 0x2f; iSetBackTR = -1;
						iSetBackL = 0x2c; iSetBackM = 0x2d; iSetBackR = -1;
					}
					break;
				case 'g':
					if ((iTile == 21) || (iTile == 23))
					{ /*** entrance, exit ***/
						iSetTL1 = 0x00; iSetTL2 = 0x24; iSetTL3 = 0x00; iSetTL4 = 0x00;
						iSetTM1 = 0x00; iSetTM2 = 0x26; iSetTM3 = 0x00; iSetTM4 = 0x00;
						iSetTR1 = 0x00; iSetTR2 = 0x25; iSetTR3 = 0x00; iSetTR4 = 0x00;
						iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
						iSetL1 = 0x00; iSetL2 = 0x23; iSetL3 = 0x00; iSetL4 = 0x01;
						iSetR1 = 0x00; iSetR2 = 0x23; iSetR3 = 0x00; iSetR4 = 0x01;
					} else { /*** teleport ***/
						iSetTL1 = 0x00; iSetTL2 = 0x0c; iSetTL3 = 0x00; iSetTL4 = 0x00;
						iSetTM1 = 0x00; iSetTM2 = iChangeMarker; iSetTM3 = 0x00;
							iSetTM4 = 0x00;
						iSetTR1 = 0x00; iSetTR2 = 0x0e; iSetTR3 = 0x00; iSetTR4 = 0x00;
						iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
						iSetL1 = 0x00; iSetL2 = 0x0f; iSetL3 = 0x00; iSetL4 = 0x01;
						iSetR1 = 0x00; iSetR2 = 0x10; iSetR3 = 0x00; iSetR4 = 0x01;
					}
					switch (iTile)
					{
						case 21: /*** entrance ***/
							iSetBackTL = 0x06; iSetBackTM = 0x06; iSetBackTR = -1;
							iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
							break;
						case 23: /*** exit ***/
							iSetBackTL = 0x0a; iSetBackTM = 0x0b; iSetBackTR = -1;
							iSetBackL = 0x08; iSetBackM = 0x09; iSetBackR = -1;
							break;
						case 25: /*** teleport ***/
							iSetBackTL = -1; iSetBackTM = 0x31; iSetBackTR = 0x32;
							iSetBackL = -1; iSetBackM = 0x10; iSetBackR = 0x11;
							break;
					}
					break;
				case 'u':
					iSetTL1 = 0x00; iSetTL2 = 0x36; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x00; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x37; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x38; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x38; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x35; iSetBackTM = 0x36; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x3e; iSetBackTM = 0x3f; iSetBackTR = -1;
						iSetBackL = 0x40; iSetBackM = 0x41; iSetBackR = -1;
					}
					break;
				case 'm':
					iSetTL1 = 0x47; iSetTL2 = 0x10; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x1e; iSetTM2 = 0x00; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x1f; iSetTR2 = 0x10; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = 0x20; iSetTF2 = 0x00; iSetTF3 = 0x00; iSetTF4 = 0x00;
					iSetL1 = 0x00; iSetL2 = 0x0f; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x0f; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x71; iSetBackTM = 0x71; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x6f; iSetBackTM = 0x70; iSetBackTR = -1;
						iSetBackL = 0x6d; iSetBackM = 0x6e; iSetBackR = -1;
					}
					break;
				case 'h':
					iSetTL1 = 0x00; iSetTL2 = 0x0e; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x0f; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = -1; iSetTR2 = -1; iSetTR3 = -1; iSetTR4 = -1;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x0d; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = -1; iSetR2 = -1; iSetR3 = -1; iSetR4 = -1;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x00; iSetBackTM = 0x00; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x00; iSetBackTM = 0x00; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					}
					break;
				case 'j':
					iSetTL1 = 0x00; iSetTL2 = 0x00; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x00; iSetTM2 = 0x00; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x00; iSetTR2 = 0x00; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = -1; iSetTF2 = -1; iSetTF3 = -1; iSetTF4 = -1;
					iSetL1 = 0x00; iSetL2 = 0x00; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x00; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x00; iSetBackTM = 0x00; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x00; iSetBackTM = 0x00; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					}
					break;
				case 'i':
					iSetTL1 = 0x47; iSetTL2 = 0x10; iSetTL3 = 0x00; iSetTL4 = 0x00;
					iSetTM1 = 0x1e; iSetTM2 = 0x00; iSetTM3 = 0x00; iSetTM4 = 0x00;
					iSetTR1 = 0x1f; iSetTR2 = 0x10; iSetTR3 = 0x00; iSetTR4 = 0x00;
					iSetTF1 = 0x20; iSetTF2 = 0x00; iSetTF3 = 0x00; iSetTF4 = 0x00;
					iSetL1 = 0x00; iSetL2 = 0x0f; iSetL3 = 0x00; iSetL4 = 0x01;
					iSetR1 = 0x00; iSetR2 = 0x0f; iSetR3 = 0x00; iSetR4 = 0x01;
					if ((iTile == 21) || (iTile == 25)) /*** entrance, teleport ***/
					{
						iSetBackTL = 0x44; iSetBackTM = 0x44; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					} else { /*** exit ***/
						iSetBackTL = 0x44; iSetBackTM = 0x44; iSetBackTR = -1;
						iSetBackL = 0x00; iSetBackM = 0x00; iSetBackR = -1;
					}
					break;
			}

			/*** top left ***/
			if ((iLocation > 11) && (iLocation != 21))
			{
				if (iSetTL1 != -1)
				{
					SetLocationSNES (iRoom, iLocation - 11, iSetTL1, iSetTL2,
						iSetTL3, iSetTL4, 0x00, iTileUnderMe);
				}
				if (iSetBackTL != -1) { iBackA[iRoom][iLocation - 11] = iSetBackTL; }
			}

			/*** top middle ***/
			if (iLocation > 10)
			{
				if (iSetTM1 != -1)
				{
					SetLocationSNES (iRoom, iLocation - 10, iSetTM1, iSetTM2,
						iSetTM3, iSetTM4, 0x00, iTileUnderMe);
				}
				if (iSetBackTM != -1) { iBackA[iRoom][iLocation - 10] = iSetBackTM; }
			}

			/*** top right ***/
			if ((iLocation > 10) && (iLocation != 20) && (iLocation != 30))
			{
				if (iSetTR1 != -1)
				{
					SetLocationSNES (iRoom, iLocation - 9, iSetTR1, iSetTR2,
						iSetTR3, iSetTR4, 0x00, iTileUnderMe);
				}
				if (iSetBackTR != -1) { iBackA[iRoom][iLocation - 9] = iSetBackTR; }
			}

			/*** top far right ***/
			if ((iLocation > 10) && (iLocation != 19) && (iLocation != 20) &&
				(iLocation != 29) && (iLocation != 30))
			{
				if (iSetTF1 != -1)
				{
					SetLocationSNES (iRoom, iLocation - 8, iSetTF1, iSetTF2,
						iSetTF3, iSetTF4, 0x00, iTileUnderMe);
				}
				/*** Never any need to update the background here. ***/
			}

			/*** left ***/
			if ((iLocation != 1) && (iLocation != 11) && (iLocation != 21))
			{
				if (iSetL1 != -1)
				{
					SetLocationSNES (iRoom, iLocation - 1, iSetL1, iSetL2,
						iSetL3, iSetL4, 0x00, iTileUnderMe);
				}
				if (iSetBackL != -1) { iBackA[iRoom][iLocation - 1] = iSetBackL; }
			}

			/*** middle ***/
			if (cCurType == 'h') { iBlock2A[iRoom][iLocation - 1] = 0x10; }
			iBackA[iRoom][iLocation] = iSetBackM;

			/*** right ***/
			if ((iLocation != 10) && (iLocation != 20) && (iLocation != 30))
			{
				if (iSetR1 != -1)
				{
					SetLocationSNES (iRoom, iLocation + 1, iSetR1, iSetR2,
						iSetR3, iSetR4, 0x00, iTileUnderMe);
				}
				if (iSetBackR != -1) { iBackA[iRoom][iLocation + 1] = iSetBackR; }
			}
		}
	}
}
/*****************************************************************************/
void SetGuard (int iLoc, int iDirection, int iSkill, int iColor)
/*****************************************************************************/
{
	/* Give 'non-colored' guards a color, to prevent random colors from
	 * appearing (and game crashes from occurring) if we ever switch back
	 * to regular guards.
	 */
	if (iColor == -1) { iColor = 1; }

	sGuardLocations[iCurRoom - 1] = iLoc;
	sGuardDirections[iCurRoom - 1] = iDirection;
	sGuardSkills[iCurRoom - 1] = iSkill;
	sGuardColors[iCurRoom - 1] = iColor;
	/*** PoP1 for DOS does not use sGuardTypes. ***/
	PlaySound ("wav/hum_adj.wav");
}
/*****************************************************************************/
void SetGuardSNES (int iLoc, int iDirection, int iSkill, int iType)
/*****************************************************************************/
{
	sGuardLocations[iCurRoom - 1] = iLoc;
	sGuardDirections[iCurRoom - 1] = iDirection;
	sGuardSkills[iCurRoom - 1] = iSkill;
	sGuardTypes[iCurRoom - 1] = iType;
	/*** PoP1 for SNES does not use sGuardColors. ***/
	PlaySound ("wav/hum_adj.wav");
}
/*****************************************************************************/
void ShowChange (int iLocation, SDL_Renderer *screen)
/*****************************************************************************/
{
	int iDistort;
	int iMod;
	int iGuardL, iGuardR;
	SDL_Color skcolor;
	char sText[MAX_TEXT + 2];

	/*** Used for looping. ***/
	int iLoopPlayer;

	switch (cCurType)
	{
		/*** PoP1 ***/
		case 'd': iMod = 0; break;
		case 'p': iMod = 1; break;
		/*** PoP2 ***/
		case 'o': iMod = 20; break;
		case 'c': iMod = 21; break;
		case 'r': iMod = 22; break;
		case 't': iMod = 24; break;
		/*** PoP1 for SNES ***/
		case 'b': iMod = 58; break;
		case 'f': iMod = 59; break;
		case 'g': iMod = 60; break;
		case 'h': iMod = 61; break;
		case 'i': iMod = 62; break;
		case 'j': iMod = 63; break;
		case 'l': iMod = 64; break;
		case 'm': iMod = 65; break;
		case 's': iMod = 66; break;
		case 'u': iMod = 67; break;
		default:
			printf ("[FAILED] cCurType is weird: %c!\n", cCurType);
			exit (EXIT_ERROR); break;
	}
	ShowImage (-12, (int[]){iMod, 0, 0, 0}, screen, 31, 0, 0, 692, 455);

	switch (iCloseOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){2, 0, 0, 0}, screen, 47, 0, 0, 36, 387); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){3, 0, 0, 0}, screen, 47, 0, 0, 36, 387); break;
	}
	if ((cCurType == 'r') || (cCurType == 't') || (iEditPoP == 3))
	{
		switch (iBackgroundOn)
		{
			case 0: /*** off ***/
				ShowImage (-12, (int[]){26, 0, 0, 0},
					screen, 96, 0, 0, 148, 62); break;
			case 1: /*** on ***/
				ShowImage (-12, (int[]){27, 0, 0, 0},
					screen, 96, 0, 0, 148, 62); break;
		}
	}
	if (iEditPoP == 1)
	{
		/*** kid button ***/
		switch (iKidOn)
		{
			case 0: /*** off ***/
				ShowImageBasic (imgkid0, 354, 388, "imgkid0", screen, iScale, 1);
				break;
			case 1: /*** on ***/
				ShowImageBasic (imgkid1, 354, 388, "imgkid1", screen, iScale, 1);
				break;
		}
	}
	if (iEditPoP == 3)
	{
		/*** templates button ***/
		switch (iTemplatesOn)
		{
			case 0: /*** off ***/
				ShowImage (-12, (int[]){70, 0, 0, 0},
					screen, 190, 0, 0, 48, 62); break;
			case 1: /*** on ***/
				ShowImage (-12, (int[]){71, 0, 0, 0},
					screen, 190, 0, 0, 48, 62); break;
		}

		/*** kid colors button ***/
		switch (iColorsOn)
		{
			case 0: /*** off ***/
				ShowImage (-12, (int[]){75, 0, 0, 0},
					screen, 201, 0, 0, 48, 62); break;
			case 1: /*** on ***/
				ShowImage (-12, (int[]){76, 0, 0, 0},
					screen, 201, 0, 0, 48, 62); break;
		}
	}
	if (iEditPoP == 2)
	{
		switch (iGuardsOn)
		{
			case 0: /*** off ***/
				ShowImage (-12, (int[]){28, 0, 0, 0}, screen, 97, 0, 0, 98, 62); break;
			case 1: /*** on ***/
				ShowImage (-12, (int[]){29, 0, 0, 0}, screen, 97, 0, 0, 98, 62); break;
		}

		switch (iMusicOn)
		{
			case 0: /*** off ***/
				ShowImage (-12, (int[]){39, 0, 0, 0},
					screen, 119, 0, 0, 14, 24); break;
			case 1: /*** on ***/
				ShowImage (-12, (int[]){40, 0, 0, 0},
					screen, 119, 0, 0, 14, 24); break;
		}
	}
	if (iEditPoP == 1)
	{
		DisableSome();
	}
	if (iEditPoP == 2)
	{
		/*** In these levels, the prince always starts at a specific location. ***/
		if (((luLevelNr == 7) || (luLevelNr == 21)) &&
			((iCurRoom != 32) || (iLocation != 25)))
		{ /*** prince warning ***/
			ShowImage (-12, (int[]){46, 0, 0, 0}, screen, 123, 0, 0, 52, 66);
		}
	}
	if (iEditPoP == 3)
	{
		/*** In this level, the prince always starts at a specific location. ***/
		if (luLevelNr == 21)
		{ /*** prince warning ***/
			ShowImage (-12, (int[]){46, 0, 0, 0}, screen, 194, 0, 0, 52, 66);
		}

		/*** red prince ***/
		if ((luLevelNr >= 10) && (luLevelNr <= 12))
		{
			ShowImage (-12, (int[]){79, 0, 0, 0}, screen, 208, 0, 0, 48, 62);
		}
	}
	/*** old tile ***/
	ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 82, 0, 0, 52, 66);
	switch (iCustomOn)
	{
		case 0:
			if (iIsCustom == 1)
				ShowImage (-12, (int[]){13, 0, 0, 0}, screen, 88, 0, 0, 36, 68);
			if (iIsCustom == 0)
				ShowImage (-12, (int[]){14, 0, 0, 0}, screen, 88, 0, 0, 36, 68);
			break;
		case 1:
			if (iIsCustom == 1)
				ShowImage (-12, (int[]){15, 0, 0, 0}, screen, 88, 0, 0, 36, 68);
			if (iIsCustom == 0)
				ShowImage (-12, (int[]){16, 0, 0, 0}, screen, 88, 0, 0, 36, 68);
			break;
	}
	if (iEditPoP == 1)
	{
		for (iLoopPlayer = 1; iLoopPlayer <= 8; iLoopPlayer++)
		{
			if ((iCurRoom == arKidRoom[iLoopPlayer]) &&
				(iLocation == arKidPos[iLoopPlayer]))
			{
				ShowImageBasic (imgkidbb, 352, 386, "imgkidbb",
					ascreen, iScale, 1);
			}
		}
	} else {
		if ((iCurRoom == arKidRoom[1]) && (iLocation == arKidPos[1]))
		{
			switch (arKidDir[1])
			{
				case 0: ShowImage (-12, (int[]){10, 0, 0, 0},
					screen, 57, 0, 0, 27, 66); break;
				case 255: ShowImage (-12, (int[]){10, 0, 0, 0},
					screen, 58, 0, 0, 27, 66); break;
			}
		}
	}

	/* PoP1, if the current location has a guard, then add a green border
	 * around its image here. Also, set iGuardSkill to the skill of the guard.
	 */
	if ((iEditPoP == 1) && (iLocation == sGuardLocations[iCurRoom - 1] + 1))
	{
		iGuardSkill = sGuardSkills[iCurRoom - 1];
		switch (iCurGuard)
		{
			case 2: /*** skeleton ***/
				if (sGuardDirections[iCurRoom - 1] == 0)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 73, 0, 0, 52, 66);
				if (sGuardDirections[iCurRoom - 1] == 255)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 74, 0, 0, 52, 66);
				break;
			case 1: /*** fat ***/
				if (sGuardDirections[iCurRoom - 1] == 0)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 75, 0, 0, 52, 66);
				if (sGuardDirections[iCurRoom - 1] == 255)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 76, 0, 0, 52, 66);
				break;
			case 3: /*** jaffar ***/
				if (sGuardDirections[iCurRoom - 1] == 0)
					ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 77, 0, 0, 27, 66);
				if (sGuardDirections[iCurRoom - 1] == 255)
					ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 78, 0, 0, 27, 66);
				break;
			case 4: /*** shadow ***/
				if (sGuardDirections[iCurRoom - 1] == 0)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 79, 0, 0, 52, 66);
				if (sGuardDirections[iCurRoom - 1] == 255)
					ShowImage (-12, (int[]){11, 0, 0, 0}, screen, 80, 0, 0, 52, 66);
				break;
			case 0: /*** regular ***/
				switch (sGuardColors[iCurRoom - 1] - 1)
				{
					case 0:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 59, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 60, 0, 0, 27, 66);
						break;
					case 1:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 61, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 62, 0, 0, 27, 66);
						break;
					case 2:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 63, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 64, 0, 0, 27, 66);
						break;
					case 3:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 65, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 66, 0, 0, 27, 66);
						break;
					case 4:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 67, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 68, 0, 0, 27, 66);
						break;
					case 5:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 69, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 70, 0, 0, 27, 66);
						break;
					case 6:
						if (sGuardDirections[iCurRoom - 1] == 0)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 71, 0, 0, 27, 66);
						if (sGuardDirections[iCurRoom - 1] == 255)
							ShowImage (-12, (int[]){10, 0, 0, 0}, screen, 72, 0, 0, 27, 66);
						break;
					default:
						/*** Do not show a small border. ***/
						if (iDebug == 1)
						{
							printf ("[ INFO ] Strange guard color: %i (jaffar, shadow, "
								"fat, skeleton?)\n", sGuardColors[iCurRoom - 1] - 1);
						}
						break;
				}
				break;
		}
	}
	/* PoP1 for SNES, if the current location has a guard, then add a green
	 * border around its image here. Also, set iGuardSkill to the skill of
	 * the guard.
	 */
	if ((iEditPoP == 3) && (iLocation == sGuardLocations[iCurRoom - 1] + 1))
	{
		iGuardSkill = sGuardSkills[iCurRoom - 1];
		switch (sGuardTypes[iCurRoom - 1])
		{
			case 0x02: iGuardL = 148; iGuardR = 149; break; /*** dead pink ***/
			case 0x03: iGuardL = 150; iGuardR = 151; break; /*** silver s ***/
			case 0x04: iGuardL = 152; iGuardR = 153; break; /*** bronze s ***/
			case 0x05: iGuardL = 154; iGuardR = 155; break; /*** golden s ***/
			case 0x06: iGuardL = 156; iGuardR = 157; break; /*** female ***/
			case 0x07: iGuardL = 158; iGuardR = 159; break; /*** fat ***/
			case 0x08: iGuardL = 160; iGuardR = 161; break; /*** shadow ***/
			case 0x09: iGuardL = 162; iGuardR = 163; break; /*** green g ***/
			case 0x0a: iGuardL = 164; iGuardR = 165; break; /*** greenish ***/
			case 0x0b: iGuardL = 166; iGuardR = 167; break; /*** blue g ***/
			case 0x0c: iGuardL = 168; iGuardR = 169; break; /*** red g ***/
			case 0x0d: iGuardL = 170; iGuardR = 171; break; /*** purple g ***/
			case 0x0e: iGuardL = 172; iGuardR = 173; break; /*** blue faced ***/
			case 0x0f: iGuardL = 174; iGuardR = 175; break; /*** red k ***/
			case 0x10: iGuardL = 176; iGuardR = 177; break; /*** blue k ***/
			case 0x11: iGuardL = 178; iGuardR = 179; break; /*** sinbad k ***/
			case 0x12: iGuardL = 180; iGuardR = 181; break; /*** jaffar ***/
			case 0x13: iGuardL = 182; iGuardR = 183; break; /*** dead white ***/
			default: iGuardL = 0; iGuardR = 0; break;
		}
		if ((iGuardL != 0) && (iGuardR != 0))
		{
			if (sGuardDirections[iCurRoom - 1] == 1)
				ShowImage (-12, (int[]){10, 0, 0, 0}, screen, iGuardL, 0, 0, 27, 66);
			if (sGuardDirections[iCurRoom - 1] == 0)
				ShowImage (-12, (int[]){10, 0, 0, 0}, screen, iGuardR, 0, 0, 27, 66);
		} else {
			printf ("[ WARN ] Strange guard type \"%i\"!\n",
				sGuardTypes[iCurRoom - 1]);
		}
	}
	/*** PoP1, guard skill ***/
	if (iEditPoP == 1)
		{ ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 81, 0, 0, 14, 14); }
	/*** PoP1 for SNES, guard skill ***/
	if (iEditPoP == 3)
	{
		/*** Red if the number is unused in the original game. ***/
		if (((iGuardSkill >= 1) && (iGuardSkill <= 11)) ||
			((iGuardSkill >= 13) && (iGuardSkill <= 15)))
		{ skcolor = color_bl; } else { skcolor = color_red; }

		CenterNumber (screen, iGuardSkill, 399, 424, skcolor, color_wh, 0);
	}

	/*** bright green border ***/
	if (iOnTile != 0)
		{ ShowImage (-12, (int[]){4, 0, 0, 0}, screen, 48, 0, 0, 52, 66); }

	/*** show event number ***/
	if (iEditPoP == 1)
	{
		CenterNumber (screen, iChangeEvent + 1, 562, 424, color_bl, color_wh, 0);
	} else {
		CenterNumber (screen, iChangeEvent + 1, 549, 424, color_bl, color_wh, 0);
	}

	if (iEditPoP == 2)
	{
		/*** jumps ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 125, 0, 0, 14, 14);

		/*** frame ***/
		if (iChangeFrame != 0)
		{
			CenterNumber (screen, iChangeFrame, 576, 306, color_red, color_wh, 0);
		} else {
			CenterNumber (screen, iChangeFrame, 576, 306, color_bl, color_wh, 0);
		}

		/*** percent open ***/
		CenterNumber (screen, iChangePercent, 549, 364, color_bl, color_wh, 0);

		/*** alt wall ***/
		if (cCurType != 'o')
		{
			ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 130, 0, 0, 14, 14);
		}

		if (cCurType == 'c')
		{
			/*** stal ***/
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 131, 0, 0, 14, 14);
			/*** bot ***/
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 132, 0, 0, 14, 14);
		}

		if (cCurType == 'r')
		{
			/*** sym ***/
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 133, 0, 0, 14, 14);
			/*** crk ***/
			ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 134, 0, 0, 14, 14);
		}
	}

	if (iEditPoP == 3)
	{
		/*** percent open ***/
		CenterNumber (screen, iChangePercent, 399, 360, color_bl, color_wh, 0);

		/*** stuck tile ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 188, 0, 0, 14, 14);

		/* This needs to happen after the old tile is shown, because that
		 * function also sets the teleport marker.
		 */
		if (cCurType != 'g')
		{
			/*** no teleport marker ***/
			ShowImage (-9, (int[]){20, 0, 0, 0}, ascreen, 197, 0, 0, 148, 62);
		} else {
			/*** teleport marker ***/
			ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 198, 0, 0, 14, 14);
		}
	}

	/*** distort ***/
	iDistort = 0;
	if (cCurType == 'd')
	{
		if ((iOnTile == 48) || (iOnTile == 64) || (iOnTile == 65) ||
			(iOnTile == 67) || (iOnTile == 68) || (iOnTile == 69) || (iOnTile == 70))
			{ iDistort = 1; }
	}
	if (cCurType == 'p')
	{
		if (iOnTile == 62) { iDistort = 1; }
	}
	if (cCurType == 'o')
	{
		if ((iOnTile == 25) || (iOnTile == 26) || (iOnTile == 31) ||
			(iOnTile == 32) || (iOnTile == 36) || (iOnTile == 38) ||
			(iOnTile == 39) || (iOnTile == 50) || (iOnTile == 51) ||
			(iOnTile == 52) || (iOnTile == 53) || (iOnTile == 54) ||
			(iOnTile == 55) || (iOnTile == 57) || (iOnTile == 58) ||
			(iOnTile == 60) || (iOnTile == 66) || (iOnTile == 87) ||
			(iOnTile == 88))
			{ iDistort = 1; }
	}
	if (cCurType == 'c')
	{
		if ((iOnTile == 36) || (iOnTile == 51) || (iOnTile == 58))
			{ iDistort = 1; }
	}
	if (iDistort == 1)
	{
		ShowImage (-12, (int[]){56, 0, 0, 0}, screen, 137, 0, 0, 648, 32);
	}

	/*** tooltip ***/
	iTooltip = 0;
	if (iEditPoP == 3)
	{
		if ((iOnTile == 24) || (iOnTile == 31) ||
			(iOnTile == 39) || (iOnTile == 45)) { iTooltip = 1; }
	}
	if (iTooltip == 1)
	{
		ShowImage (-12, (int[]){80, 0, 0, 0}, screen, 137,
			0, 32 - iTooltipHeight, 648, iTooltipHeight);
		if (iTooltipHeight == 32)
		{
			switch (iOnTile)
			{
				case 24:
					snprintf (sText, MAX_TEXT, "%s", "Entering triggers its N-W tile,"
						" exiting N. Don't place right of gate/wall."); break;
				case 31:
					snprintf (sText, MAX_TEXT, "%s", "Kills the prince if he falls"
						" on it from any height."); break;
				case 39:
					snprintf (sText, MAX_TEXT, "%s", "If a silver or bronze skeleton"
						" falls into this room, it will re-appear here."); break;
				case 45:
					snprintf (sText, MAX_TEXT, "%s", "The target destination can be"
						" changed on the EXE screen."); break;
			}
			DisplayTextLine (39, 11, sText, font1, color_bl, color_tooltip, 0);
		}
	}

	/*** skill tooltip ***/
	if (iEditPoP == 3)
	{
		if (iSkillTooltip == 1)
			{ ShowImage (-12, (int[]){77, 0, 0, 0}, screen, 204, 0, 0, 146, 30); }
	}

	/*** jaffar tooltip ***/
	if (cCurType == 'j')
	{
		if (iJaffarTooltip == 1)
			{ ShowImage (-18, (int[]){3, 0, 0, 0}, screen, 213, 0, 0, 656, 196); }
	}

	if (iEditPoP == 1)
	{
		if (iEventHover == 1)
			{ ShowImageBasic (imgeventh, 502, 66, "imgeventh", ascreen, iScale, 1); }
	}

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void ShowChangeCustom (SDL_Renderer *screen)
/*****************************************************************************/
{
	SDL_Rect remove;

	ShowImage (-12, (int[]){17, 0, 0, 0}, screen, 31, 0, 0, 692, 455);

	/*** custom snes ***/
	if (iEditPoP == 3)
	{
		ShowImage (-18, (int[]){1, 0, 0, 0}, ascreen, 147, 0, 0, 251, 133);
	}

	switch (iCloseCustomOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){2, 0, 0, 0}, screen, 47, 0, 0, 36, 387); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){3, 0, 0, 0}, screen, 47, 0, 0, 36, 387); break;
	}
	switch (iCustomUseOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){18, 0, 0, 0}, screen, 88, 0, 0, 36, 68); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){19, 0, 0, 0}, screen, 88, 0, 0, 36, 68); break;
	}

	if (iEditPoP != 3)
	{
		/*** foreground random ***/
		ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 89, 0, 0, 14, 14);
		/*** foreground mod ***/
		ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 90, 0, 0, 14, 14);
	}

	/*** foreground code and modifiers ***/
	if (iEditPoP != 3)
	{
		CenterNumber (screen, iChangeFore, 177, 109, color_wh, color_bl, 0);
	} else {
		/*** fore, lower left ***/
		CenterNumber (screen, iChangeBlock[1], 60, 109, color_wh, color_bl, 1);
		/*** back, upper left ***/
		CenterNumber (screen, iChangeBlock[2], 60, 57, color_wh, color_bl, 1);
		/*** object, upper right ***/
		CenterNumber (screen, iChangeBlock[3], 177, 57, color_wh, color_bl, 1);
		/*** attributes, lower right ***/
		ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 189, 0, 0, 14, 14);
	}
	if (iEditPoP != 3)
	{
		CenterNumber (screen, iChangeMod[1], 437, 109, color_wh, color_bl, 0);
	} else {
		CenterNumber (screen, iChangeMod[1], 437, 109, color_wh, color_bl, 1);
	}
	if (iEditPoP == 2)
	{
		CenterNumber (screen, iChangeMod[2], 549, 22, color_wh, color_bl, 0);
		CenterNumber (screen, iChangeMod[3], 549, 45, color_wh, color_bl, 0);
		CenterNumber (screen, iChangeMod[4], 549, 68, color_wh, color_bl, 0);
	}
	if (iEditPoP != 1)
	{
		/*** remove PoP1 suggestion ***/
		remove.x = 276 * iScale; remove.y = 287 * iScale;
		remove.w = 319 * iScale; remove.h = 33 * iScale;
		SDL_SetRenderDrawColor (screen, 0x00, 0x00, 0x00, SDL_ALPHA_OPAQUE);
		SDL_RenderFillRect (screen, &remove);
	}
	if (iEditPoP != 2)
	{
		/*** remove PoP2 modifiers ***/
		remove.x = 517 * iScale; remove.y = 18 * iScale;
		remove.w = 121 * iScale; remove.h = 74 * iScale;
		SDL_SetRenderDrawColor (screen, 0x00, 0x00, 0x00, SDL_ALPHA_OPAQUE);
		SDL_RenderFillRect (screen, &remove);
	}

	/*** native ***/
	if (iEditPoP == 1)
	{
		if (iUsesNative == 0)
		{
			ShowImage (-3, (int[]){0, 0, 0, 0}, screen, 214, 0, 0, 106, 133);
			/*** Not found ***/
			ShowImage (-3, (int[]){3, 1, 0, 0}, screen, 215, 0, 0, 102, 15);
		} else {
			switch (iNativeOn)
			{
				case 0: /*** off ***/
					ShowImage (-3, (int[]){1, 0, 0, 0},
						screen, 214, 0, 0, 106, 133);
					if ((iUsesNative == 1) || (iUsesNative == 3) ||
						(iUsesNative == 5) || (iUsesNative == 9))
					{
						/*** Linux ELF ***/
						ShowImage (-3, (int[]){3, 2, 0, 0}, screen, 215, 0, 0, 102, 15);
					}
					if ((iUsesNative == 2) || (iUsesNative == 3))
					{
						/*** MS Windows: i386 32-bit ***/
						ShowImage (-3, (int[]){3, 3, 0, 0}, screen, 215, 0, 0, 102, 15);
					}
					if ((iUsesNative == 4) || (iUsesNative == 5))
					{
						/*** MS Windows: AMD64 64-bit ***/
						ShowImage (-3, (int[]){3, 4, 0, 0}, screen, 215, 0, 0, 102, 15);
					}
					if ((iUsesNative == 8) || (iUsesNative == 9))
					{
						/*** MS Windows: Other ***/
						ShowImage (-3, (int[]){3, 5, 0, 0}, screen, 215, 0, 0, 102, 15);
					}
					break;
				case 1: /*** on ***/
					ShowImage (-3, (int[]){2, 0, 0, 0},
						screen, 214, 0, 0, 106, 133); break;
			}
		}
	}

	/*** current custom ***/
	ShowCurrentCustom (screen);

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void ShowChangeGuards (SDL_Renderer *screen)
/*****************************************************************************/
{
	ShowImage (-12, (int[]){30, 0, 0, 0}, screen, 31, 0, 0, 692, 455);

	switch (iCloseGuardsOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){31, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){32, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
	}

	/*****************/
	/* Static Guards */
	/*****************/

	/*** guards in room ***/
	ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 98, 0, 0, 14, 14);
	/*** rows ***/
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 100, 0, 0, 35, 8);
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 101, 0, 0, 35, 8);
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 102, 0, 0, 35, 8);
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 103, 0, 0, 35, 8);
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 104, 0, 0, 35, 8);
	/*** skills ***/
	if (iStaticGuards_5_Skills[iCurRoom - 1][0] > 11)
	{
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][0],
			318, 56, color_red, color_bl, 0);
	} else {
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][0],
			318, 56, color_wh, color_bl, 0);
	}
	if (iStaticGuards_5_Skills[iCurRoom - 1][1] > 11)
	{
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][1],
			436, 56, color_red, color_bl, 0);
	} else {
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][1],
			436, 56, color_wh, color_bl, 0);
	}
	if (iStaticGuards_5_Skills[iCurRoom - 1][2] > 11)
	{
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][2],
			554, 56, color_red, color_bl, 0);
	} else {
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][2],
			554, 56, color_wh, color_bl, 0);
	}
	if (iStaticGuards_5_Skills[iCurRoom - 1][3] > 11)
	{
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][3],
			318, 197, color_red, color_bl, 0);
	} else {
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][3],
			318, 197, color_wh, color_bl, 0);
	}
	if (iStaticGuards_5_Skills[iCurRoom - 1][4] > 11)
	{
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][4],
			436, 197, color_red, color_bl, 0);
	} else {
		CenterNumber (screen, iStaticGuards_5_Skills[iCurRoom - 1][4],
			436, 197, color_wh, color_bl, 0);
	}
	/*** hit points, static ***/
	CenterNumber (screen, iStaticGuards_17_Hitpoints[iCurRoom - 1][0],
		318, 94, color_wh, color_bl, 0);
	CenterNumber (screen, iStaticGuards_17_Hitpoints[iCurRoom - 1][1],
		436, 94, color_wh, color_bl, 0);
	CenterNumber (screen, iStaticGuards_17_Hitpoints[iCurRoom - 1][2],
		554, 94, color_wh, color_bl, 0);
	CenterNumber (screen, iStaticGuards_17_Hitpoints[iCurRoom - 1][3],
		318, 235, color_wh, color_bl, 0);
	CenterNumber (screen, iStaticGuards_17_Hitpoints[iCurRoom - 1][4],
		436, 235, color_wh, color_bl, 0);
	/*** X-coordinate ***/
	CenterNumber (screen, (int)IntsToHexToSSLittleEndian
		(iStaticGuards_3_Offsets2[iCurRoom - 1][0],
		iStaticGuards_2_Offsets1[iCurRoom - 1][0]),
		318, 132, color_wh, color_bl, 0);
	CenterNumber (screen, (int)IntsToHexToSSLittleEndian
		(iStaticGuards_3_Offsets2[iCurRoom - 1][1],
		iStaticGuards_2_Offsets1[iCurRoom - 1][1]),
		436, 132, color_wh, color_bl, 0);
	CenterNumber (screen, (int)IntsToHexToSSLittleEndian
		(iStaticGuards_3_Offsets2[iCurRoom - 1][2],
		iStaticGuards_2_Offsets1[iCurRoom - 1][2]),
		554, 132, color_wh, color_bl, 0);
	CenterNumber (screen, (int)IntsToHexToSSLittleEndian
		(iStaticGuards_3_Offsets2[iCurRoom - 1][3],
		iStaticGuards_2_Offsets1[iCurRoom - 1][3]),
		318, 273, color_wh, color_bl, 0);
	CenterNumber (screen, (int)IntsToHexToSSLittleEndian
		(iStaticGuards_3_Offsets2[iCurRoom - 1][4],
		iStaticGuards_2_Offsets1[iCurRoom - 1][4]),
		436, 273, color_wh, color_bl, 0);
	/*** checkboxes ***/
	ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 105, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 1, 0, 0}, screen, 105, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 2, 0, 0}, screen, 105, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 3, 0, 0}, screen, 105, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 4, 0, 0}, screen, 105, 0, 0, 14, 14);
	/*** selected ***/
	ShowImage (-12, (int[]){57, iEditGuardNr, 1, 0}, screen, 105, 0, 0, 16, 16);

	/******************/
	/* Dynamic Guards */
	/******************/

	/*** incoming sets ***/
	ShowImage (-12, (int[]){12, 0, 0, 0}, screen, 99, 0, 0, 14, 14);
	/*** incoming skill ***/
	if ((iDynamicGuards_Skill[iCurRoom - 1] == 1) ||
		(iDynamicGuards_Skill[iCurRoom - 1] == 9) ||
		(iDynamicGuards_Skill[iCurRoom - 1] == 10) ||
		(iDynamicGuards_Skill[iCurRoom - 1] >= 12))
	{ /*** Unused in (the original) PoP2. ***/
		CenterNumber (screen, iDynamicGuards_Skill[iCurRoom - 1],
			559, 271, color_red, color_wh, 0);
	} else {
		CenterNumber (screen, iDynamicGuards_Skill[iCurRoom - 1],
			559, 271, color_bl, color_wh, 0);
	}
	/*** hit points, dynamic ***/
	CenterNumber (screen, iDynamicGuards_10_Hitpoints[iCurRoom - 1][0],
		398, 350, color_wh, color_bl, 0);
	CenterNumber (screen, iDynamicGuards_10_Hitpoints[iCurRoom - 1][1],
		569, 350, color_wh, color_bl, 0);
	/*** nr. of guards ***/
	CenterNumber (screen, iDynamicGuards_9_Amount[iCurRoom - 1][0],
		398, 372, color_wh, color_bl, 0);
	CenterNumber (screen, iDynamicGuards_9_Amount[iCurRoom - 1][1],
		569, 372, color_wh, color_bl, 0);
	/*** before spawn ***/
	CenterNumber (screen, iDynamicGuards_5_LatBefore[iCurRoom - 1][0],
		383, 394, color_wh, color_bl, 0);
	CenterNumber (screen, iDynamicGuards_5_LatBefore[iCurRoom - 1][1],
		554, 394, color_wh, color_bl, 0);
	/*** between spawns ***/
	CenterNumber (screen, iDynamicGuards_6_LatBetween[iCurRoom - 1][0],
		383, 416, color_wh, color_bl, 0);
	CenterNumber (screen, iDynamicGuards_6_LatBetween[iCurRoom - 1][1],
		554, 416, color_wh, color_bl, 0);
	/*** entry ***/
	ShowImage (-12, (int[]){34, 0, 0, 0}, screen, 106, 0, 0, 18, 8);
	ShowImage (-12, (int[]){34, 0, 0, 0}, screen, 107, 0, 0, 18, 8);
	/*** max alive ***/
	ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 108, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 1, 0, 0}, screen, 108, 0, 0, 14, 14);
	/*** can jump ***/
	ShowImage (-10, (int[]){1, 0, 0, 0}, screen, 109, 0, 0, 14, 14);
	ShowImage (-10, (int[]){1, 1, 0, 0}, screen, 109, 0, 0, 14, 14);
	/*** prince row ***/
	ShowImage (-12, (int[]){33, 0, 0, 0}, screen, 110, 0, 0, 35, 8);
	ShowImage (-12, (int[]){33, 1, 0, 0}, screen, 110, 0, 0, 35, 8);

	/************/
	/* Tooltips */
	/************/

	if (iGuardTooltip != 0)
	{
		ShowImage (-12, (int[]){38, iGuardTooltip - 1, 0, 0},
			screen, 115, 0, 0, 117, 99);
	}

	/************/
	/* Warnings */
	/************/

	/*** guard warning static ***/
	if (iEXEGuardTypePoP2 == 0x00)
	{
		ShowImage (-12, (int[]){52, 0, 0, 0}, screen, 124, 0, 0, 203, 373);
	}
	if (iEXEGuardTypePoP2 == 0xff)
	{
		ShowImage (-12, (int[]){48, 0, 0, 0}, screen, 124, 0, 0, 203, 373);
	}
	if (iEXEGuardTypePoP2 == 0x02)
	{
		ShowImage (-12, (int[]){49, 0, 0, 0}, screen, 124, 0, 0, 203, 373);
	}
	if (iEXEGuardTypePoP2 == 0x05)
	{
		ShowImage (-12, (int[]){50, 0, 0, 0}, screen, 124, 0, 0, 203, 373);
	}
	if (iEXEGuardTypePoP2 == 0x07)
	{
		ShowImage (-12, (int[]){51, 0, 0, 0}, screen, 124, 0, 0, 203, 373);
	}
	/*** guard warning dynamic ***/
	if ((iEXEGuardTypePoP2 == 0x05) || (iEXEGuardTypePoP2 == 0xff))
	{
		ShowImage (-12, (int[]){53, 0, 0, 0}, screen, 126, 0, 0, 347, 137);
	}

	/******************/
	/* Disable Guards */
	/******************/

	/*** disable static ***/
	if (iStaticGuards_Amount[iCurRoom - 1] < 1)
	{
		ShowImage (-12, (int[]){36, 0, 0, 0}, screen, 111, 0, 0, 43, 426);
		ShowImage (-12, (int[]){37, 0, 0, 0}, screen, 112, 0, 0, 119, 142);
	}
	if (iStaticGuards_Amount[iCurRoom - 1] < 2)
	{
		ShowImage (-12, (int[]){36, 1, 0, 0}, screen, 111, 0, 0, 43, 426);
		ShowImage (-12, (int[]){37, 1, 0, 0}, screen, 112, 0, 0, 119, 142);
	}
	if (iStaticGuards_Amount[iCurRoom - 1] < 3)
	{
		ShowImage (-12, (int[]){36, 2, 0, 0}, screen, 111, 0, 0, 43, 426);
		ShowImage (-12, (int[]){37, 2, 0, 0}, screen, 112, 0, 0, 119, 142);
	}
	if (iStaticGuards_Amount[iCurRoom - 1] < 4)
	{
		ShowImage (-12, (int[]){36, 3, 0, 0}, screen, 111, 0, 0, 43, 426);
		ShowImage (-12, (int[]){37, 3, 0, 0}, screen, 112, 0, 0, 119, 142);
	}
	if (iStaticGuards_Amount[iCurRoom - 1] < 5)
	{
		ShowImage (-12, (int[]){36, 4, 0, 0}, screen, 111, 0, 0, 43, 426);
		ShowImage (-12, (int[]){37, 4, 0, 0}, screen, 112, 0, 0, 119, 142);
	}

	/*** disable dynamic ***/
	if (iDynamicGuards_Sets[iCurRoom - 1] < 1)
		{ ShowImage (-12, (int[]){35, 0, 0, 0}, screen, 113, 0, 0, 172, 133); }
	if (iDynamicGuards_Sets[iCurRoom - 1] < 2)
		{ ShowImage (-12, (int[]){35, 0, 0, 0}, screen, 114, 0, 0, 172, 133); }

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void ShowChangeMusic (SDL_Renderer *screen)
/*****************************************************************************/
{
	int iTile;

	ShowImage (-12, (int[]){41, 0, 0, 0}, screen, 31, 0, 0, 692, 455);

	for (iTile = 0; iTile < 30; iTile++)
	{
		if (sMusic[((iCurRoom - 1) * 30) + iTile] == 1)
		{
			ShowImage (-10, (int[]){1, iTile, 0, 0}, screen, 120, 0, 0, 14, 14);
		}
		if (iEditNote == iTile)
		{
			ShowImage (-12, (int[]){57, iTile, 0, 0}, screen, 120, 0, 0, 16, 16);
		}
	}

	switch (iMAllOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){1, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){2, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMNoneOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){3, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){4, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMLeftOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){5, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){6, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMRightOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){7, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){8, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMTopOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){9, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){10, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMMiddleOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){11, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){12, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMBottomOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){13, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){14, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}
	switch (iMInvertOn)
	{
		case 0: /*** off ***/
			ShowImage (-17, (int[]){15, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
		case 1: /*** on ***/
			ShowImage (-17, (int[]){16, 0, 0, 0}, screen, 122, 0, 0, 71, 29); break;
	}

	switch (iCloseMusicOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){31, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){32, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
	}

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void ShowChangeBackground (int iLocation, SDL_Renderer *screen)
/*****************************************************************************/
{
	char sText[MAX_TEXT + 2];
	int iBackRow, iBackColumn;
	int iX;
	int iWhat;
	int iTemp;

	if (cCurType == 'r')
		{ ShowImage (-12, (int[]){23, 0, 0, 0}, screen, 31, 0, 0, 692, 455); }
	if (cCurType == 't')
		{ ShowImage (-12, (int[]){25, 0, 0, 0}, screen, 31, 0, 0, 692, 455); }
	if (iEditPoP == 3)
	{
		ShowImage (-12, (int[]){68, 0, 0, 0}, screen, 31, 0, 0, 692, 455);
		ShowImage (-12, (int[]){69, 0, 0, 0}, screen, 184, 0, 0, 585, 419);

		/*** animated back ***/
		for (iTemp = 0; iTemp < 256; iTemp++)
		{
			if (arAnim[iTemp] != 0x00)
			{
				iWhat = iTemp;
				if (((iEXEType == 1) || (iEXEType == 2)) &&
					(cCurType == 'f') &&
					((iWhat >= 0x80) && (iWhat <= 0x97)))
				{
					/*** fawn cloud backgrounds for US and EU ***/
					iWhat-=0x55;
				} else if ((cCurType == 'u') &&
					((iWhat >= 0xf9) && (iWhat <= 0xfe))) {
					/*** umber bus error occurred ***/
					iWhat-=0xa5;
				}
				iWhat++;
				if (iWhat <= 120)
				{
					ShowImage (-12, (int[]){78, iWhat, arAnim[iTemp], 0},
						screen, 207, 0, 0, 30, 70);
				}
			}
		}
	}

	if ((cCurType == 'r') || (cCurType == 't'))
	{
		/*** sel back ***/
		ShowImage (-12, (int[]){54, 0,
			iModifierA[iCurRoom][iLocation - 1][3],
			iModifierA[iCurRoom][iLocation - 1][4]},
			screen, 129, 0, 0, 32, 63);

		/*** highlight back ***/
		ShowImage (-12, (int[]){55, 0, iMod3Hi, iMod4Hi},
			screen, 129, 0, 0, 32, 63);
	} else {
		/*** sel back ***/
		iWhat = iBackA[iCurRoom][iLocation - 1];
		if (BackOutOfBounds (iWhat) == 1) { iWhat = 0x00; /*** Black. ***/ }
		if (((iEXEType == 1) || (iEXEType == 2)) &&
			(cCurType == 'f') &&
			((iWhat >= 0x80) && (iWhat <= 0x97)))
		{
			/*** fawn cloud backgrounds for US and EU ***/
			iWhat-=0x55;
		} else if ((cCurType == 'u') &&
			((iWhat >= 0xf9) && (iWhat <= 0xfe))) {
			/*** umber bus error occurred ***/
			iWhat-=0xa5;
		}
		iWhat++;
		ShowImage (-12, (int[]){54, iWhat, 0, 0}, screen, 129, 0, 0, 24, 64);

		/*** highlight back ***/
		iWhat = iModHi;
		ShowImage (-12, (int[]){55, iWhat, 0, 0}, screen, 129, 0, 0, 24, 64);

		/*** preview ***/
		iWhat = iModHi - 1;
		if (((iEXEType == 1) || (iEXEType == 2)) &&
			(cCurType == 'f') &&
			((iModHi - 1 >= 0x2b) && (iModHi - 1 <= 0x42)))
		{
			/*** fawn cloud backgrounds for US and EU ***/
			iWhat+=0x55;
		} else if ((cCurType == 'u') &&
			((iModHi - 1 >= 0x54) && (iModHi - 1 <= 0x59))) {
			/*** umber bus error occurred ***/
			iWhat+=0xa5;
		}
		ShowBackground ((int[]){0, 0, iWhat, 0}, 102);

		/*** mouse/controller text ***/
		DisplayTextLine (35 + (iController * 13), 426,
			"single tile", font1, color_wh, color_g3, 0);
		DisplayTextLine (227 + (iController * 13), 426,
			"entire room", font1, color_wh, color_g3, 0);
		DisplayTextLine (419 + (iController * 13), 426,
			"entire level", font1, color_wh, color_g3, 0);

		/*** hex no. ***/
		iWhat = iModHi - 1;
		if (((iEXEType == 1) || (iEXEType == 2)) &&
			(cCurType == 'f') &&
			((iWhat >= 0x2b) && (iWhat <= 0x42)))
		{
			/*** fawn cloud backgrounds for US and EU ***/
			iWhat+=0x55;
		} else if ((cCurType == 'u') &&
			((iWhat >= 0x54) && (iWhat <= 0x59))) {
			/*** umber bus error occurred ***/
			iWhat+=0xa5;
		}
		snprintf (sText, MAX_TEXT, "%02x", iWhat);
		DisplayTextLine (608, 182, sText, font1, color_bl, color_gb, 0);

		/*** row and column ***/
		BackRowAndColumnSNES (&iBackRow, &iBackColumn);
		snprintf (sText, MAX_TEXT, "%i", iBackRow);
		if (iBackRow < 10) { iX = 613; } else { iX = 608; }
		DisplayTextLine (iX, 245, sText, font1, color_bl, color_gb, 0);
		snprintf (sText, MAX_TEXT, "%i", iBackColumn);
		if (iBackColumn < 10) { iX = 613; } else { iX = 608; }
		DisplayTextLine (iX, 308, sText, font1, color_bl, color_gb, 0);
	}

	switch (iCloseBackgroundOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){31, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){32, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
	}

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void ShowPickTemplate (SDL_Renderer *screen)
/*****************************************************************************/
{
	ShowImage (-12, (int[]){72, 0, 0, 0}, screen, 31, 0, 0, 692, 455);
	ShowImage (-12, (int[]){73, 0, 0, 0}, screen, 191, 0, 0, 638, 340);

	/*** highlight ***/
	ShowImage (-12, (int[]){74, 0, 0, 0}, screen, 192, 0, 0, 218, 176);

	switch (iCloseTemplateOn)
	{
		case 0: /*** off ***/
			ShowImage (-12, (int[]){31, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
		case 1: /*** on ***/
			ShowImage (-12, (int[]){32, 0, 0, 0}, screen, 47, 0, 0, 36, 455); break;
	}

	/*** refresh screen ***/
	SDL_RenderPresent (screen);
}
/*****************************************************************************/
void DisableSome (void)
/*****************************************************************************/
{
	if (iCurGuard != 0) /*** disable guards ***/
		{ ShowImage (-12, (int[]){9, 0, 0, 0}, ascreen, 56, 0, 0, 352, 66); }
	if (iCurGuard != 1) /*** disable fat guard ***/
		{ ShowImage (-12, (int[]){6, 0, 0, 0}, ascreen, 53, 0, 0, 102, 66); }
	if (iCurGuard != 2) /*** disable skeleton ***/
		{ ShowImage (-12, (int[]){5, 0, 0, 0}, ascreen, 52, 0, 0, 102, 66); }
	if (iCurGuard != 3) /*** disable jaffar ***/
		{ ShowImage (-12, (int[]){7, 0, 0, 0}, ascreen, 54, 0, 0, 52, 66); }
	if (iCurGuard != 4) /*** disable shadow ***/
		{ ShowImage (-12, (int[]){8, 0, 0, 0}, ascreen, 55, 0, 0, 102, 66); }
}
/*****************************************************************************/
int OnTile (void)
/*****************************************************************************/
{
	int iTempX;
	int iTempY;
	int iTempOn;
	int iLiving;

	/*** Take care of the special rows for the rooftops, desert and final. ***/
	if (cCurType == 'o')
	{
		/*** 1.5 row ***/
		if (InArea (154, 48, 154 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (17); }
		if (InArea (204, 48, 204 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (18); }
		if (InArea (254, 48, 254 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (19); }
		if (InArea (454, 48, 454 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (23); }
		if (InArea (504, 48, 504 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (24); }
		if (InArea (554, 48, 554 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (25); }
		if (InArea (604, 48, 604 + TILEWIDTH, 48 + TILEHEIGHT) == 1)
			{ return (26); }

		/*** 2.5 row ***/
		if (InArea (104, 122, 104 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (29); }
		if (InArea (154, 122, 154 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (30); }
		if (InArea (204, 122, 204 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (31); }
		if (InArea (254, 122, 254 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (32); }
		if (InArea (454, 122, 454 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (36); }
		if (InArea (504, 122, 504 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (37); }
		if (InArea (554, 122, 554 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (38); }
		if (InArea (604, 122, 604 + TILEWIDTH, 122 + TILEHEIGHT) == 1)
			{ return (39); }
	}

	/*** Regular large tiles. ***/
	for (iTempY = 0; iTempY < 7; iTempY++)
	{
		for (iTempX = 0; iTempX < 13; iTempX++)
		{
			if (InArea (4 + (iTempX * (TILEWIDTH + 2)),
				4 + (iTempY * (TILEHEIGHT + 2)),
				2 + ((iTempX + 1) * (TILEWIDTH + 2)),
				2 + ((iTempY + 1) * (TILEHEIGHT + 2))) == 1)
			{
				iTempOn = (iTempY * 13) + iTempX + 1;
				switch (cCurType)
				{
					case 'd':
					case 'p':
						if ((iTempOn >= 1) && (iTempOn <= 78)) { return (iTempOn); }
						break;
					case 'o':
						if ((iTempOn >= 40) && (iTempOn <= 62)) { return (iTempOn); }
						if ((iTempOn >= 66) && (iTempOn <= 75)) { return (iTempOn); }
						if ((iTempOn >= 79) && (iTempOn <= 83)) { return (iTempOn); }
						if ((iTempOn >= 87) && (iTempOn <= 88)) { return (iTempOn); }
						break;
					case 'c':
						if ((iTempOn >= 1) && (iTempOn <= 58)) { return (iTempOn); }
						break;
					case 'r':
						if ((iTempOn >= 1) && (iTempOn <= 55)) { return (iTempOn); }
						break;
					case 't':
						if ((iTempOn >= 1) && (iTempOn <= 26)) { return (iTempOn); }
						if ((iTempOn >= 32) && (iTempOn <= 39)) { return (iTempOn); }
						if ((iTempOn >= 45) && (iTempOn <= 52)) { return (iTempOn); }
						if (iTempOn == 58) { return (iTempOn); }
						break;
					default: /*** PoP1 for SNES ***/
						if ((iTempOn >= 1) && (iTempOn <= 48)) { return (iTempOn); }
						break;
				}
			}
		}
	}

	/*** PoP1, regular guards ***/
	if ((cCurType == 'd') || (cCurType == 'p'))
	{
		if (InArea (4 + (25 * 0), 388, 2 + (25 * 1), 450) == 1)
			{ return (92); }
		if (InArea (4 + (25 * 1), 388, 2 + (25 * 2), 450) == 1)
			{ return (93); }
		if (InArea (4 + (25 * 2), 388, 2 + (25 * 3), 450) == 1)
			{ return (94); }
		if (InArea (4 + (25 * 3), 388, 2 + (25 * 4), 450) == 1)
			{ return (95); }
		if (InArea (4 + (25 * 4), 388, 2 + (25 * 5), 450) == 1)
			{ return (96); }
		if (InArea (4 + (25 * 5), 388, 2 + (25 * 6), 450) == 1)
			{ return (97); }
		if (InArea (4 + (25 * 6), 388, 2 + (25 * 7), 450) == 1)
			{ return (98); }
		if (InArea (4 + (25 * 7), 388, 2 + (25 * 8), 450) == 1)
			{ return (99); }
		if (InArea (4 + (25 * 8), 388, 2 + (25 * 9), 450) == 1)
			{ return (100); }
		if (InArea (4 + (25 * 9), 388, 2 + (25 * 10), 450) == 1)
			{ return (101); }
		if (InArea (4 + (25 * 10), 388, 2 + (25 * 11), 450) == 1)
			{ return (102); }
		if (InArea (4 + (25 * 11), 388, 2 + (25 * 12), 450) == 1)
			{ return (103); }
		if (InArea (4 + (25 * 12), 388, 2 + (25 * 13), 450) == 1)
			{ return (104); }
		if (InArea (4 + (25 * 13), 388, 2 + (25 * 14), 450) == 1)
			{ return (105); }
	}

	/*** PoP2, prince ***/
	if (iEditPoP == 2)
	{
		/*** turned right ***/
		if (InArea (4 + (25 * 14), 388, 2 + (25 * 15), 450) == 1)
			{ return (106); }
		/*** turned left ***/
		if (InArea (4 + (25 * 15), 388, 2 + (25 * 16), 450) == 1)
			{ return (107); }
	}

	/*** PoP1, Jaffar ***/
	if ((cCurType == 'd') || (cCurType == 'p'))
	{
		/*** turned right ***/
		if (InArea (4 + (25 * 16), 388, 2 + (25 * 17), 450) == 1)
			{ return (108); }
		/*** turned left ***/
		if (InArea (4 + (25 * 17), 388, 2 + (25 * 18), 450) == 1)
			{ return (109); }
	}

	/*** PoP1 for SNES, living ***/
	if (iEditPoP == 3)
	{
		/*** top row ***/
		for (iLiving = 1; iLiving <= 26; iLiving++)
		{
			if (InArea (4 + (25 * (iLiving - 1)), 260, 2 + (25 * iLiving), 322) == 1)
				{ return (91 + iLiving); }
		}
		/*** bottom row ***/
		for (iLiving = 1; iLiving <= 12; iLiving++)
		{
			if (InArea (4 + (25 * (iLiving - 1)), 324, 2 + (25 * iLiving), 386) == 1)
				{ return (117 + iLiving); }
		}
	}

	return (0);
}
/*****************************************************************************/
int Modulo (long lOne, long lTwo, int iType)
/*****************************************************************************/
{
	/*** This (somewhat strange) function is no longer in use. ***/

	long lTemp;
	int iCount;

	iCount = 0;
	do {
		lTemp = lOne - lTwo;
		lOne = lTemp;
		iCount++;
	} while (lOne > 0);
	if (iType == 1)
	{
		if (lOne == 0)
		{
			return (lTwo); /*** The % modulo would return 0 here. ***/
		}
		else
		{
			return (lOne + lTwo);
		}
	} else {
		return (iCount);
	}
}
/*****************************************************************************/
void SetLocation (int iRoom, int iLocation, int iThing, int iModifier1,
	int iModifier2, int iModifier3, int iModifier4)
/*****************************************************************************/
{
	iThingA[iRoom][iLocation - 1] = iThing;
	iModifierA[iRoom][iLocation - 1][1] = iModifier1;
	if (iModifier2 != -1) /*** Don't mess up the oth backgrounds. ***/
		{ iModifierA[iRoom][iLocation - 1][2] = iModifier2; }
	if (iModifier3 != -1) /*** Don't mess up backgrounds. ***/
		{ iModifierA[iRoom][iLocation - 1][3] = iModifier3; }
	if (iModifier4 != -1) /*** Don't mess up backgrounds. ***/
		{ iModifierA[iRoom][iLocation - 1][4] = iModifier4; }

	iLastThing = iThing;
	iLastModifier[1] = iModifier1;
	iLastModifier[2] = iModifier2;
	iLastModifier[3] = iModifier3;
	iLastModifier[4] = iModifier4;
}
/*****************************************************************************/
void SetLocationSNES (int iRoom, int iLocation, int iBlock1, int iBlock2,
	int iBlock3, int iBlock4, int iModifier, int iTileUnderMe)
/*****************************************************************************/
{
	char sImage[MAX_IMG + 2];
	char sCurDir[MAX_CURDIR + 2];

	if ((iTileUnderMe == 0) || (iTileUnderMe == -1))
	{
		iBlock1A[iRoom][iLocation - 1] = iBlock1;
		iBlock2A[iRoom][iLocation - 1] = iBlock2;
		iBlock3A[iRoom][iLocation - 1] = iBlock3;
		iBlock4A[iRoom][iLocation - 1] = iBlock4;
		iModifierA[iRoom][iLocation - 1][1] = iModifier;
	}

	if (iTileUnderMe == 0)
	{
		iLastThingSNES[1] = iBlock1;
		iLastThingSNES[2] = iBlock2;
		iLastThingSNES[3] = iBlock3;
		iLastThingSNES[4] = iBlock4;
		iLastModifierSNES = iModifier;

		if (cCurType != 'j') { UpdateTileAboveMe (iRoom, iLocation); }
	}

	/*** Used only for -t/--test. ***/
	if ((iTileUnderMe >= 1) && (iTileUnderMe <= 4))
	{
		GetCurDir (cCurType, sCurDir);
		snprintf (sImage, MAX_IMG, "%s%c_%02x_%02x_%02x_%02x.png",
			sCurDir, cCurType, iBlock1, iBlock2, iBlock3, iBlock4);
		if (access (sImage, R_OK) == -1)
		{
			printf ("[FAILED] %s\n", sImage);
		} else {
			printf ("[  OK  ] %s\n", sImage);
		}
	}
}
/*****************************************************************************/
void CallSave (int iJustXML)
/*****************************************************************************/
{
	char sFileName[MAX_FILE + 2];

	if (iNoSave == 1) { return; }

	if (iJustXML != 1) { CreateBAK(); }

	if (iEditPoP == 1)
	{
		switch ((int)luLevelNr)
		{
			case 0: if (iJustXML != 1) { SavePLV (OUT_DIR "demo.plv"); }
				SaveXML (XML_DIR "demo.xml"); break;
			case 1: if (iJustXML != 1) { SavePLV (OUT_DIR "level1.plv"); }
				SaveXML (XML_DIR "level1.xml"); break;
			case 2: if (iJustXML != 1) { SavePLV (OUT_DIR "level2.plv"); }
				SaveXML (XML_DIR "level2.xml"); break;
			case 3: if (iJustXML != 1) { SavePLV (OUT_DIR "level3.plv"); }
				SaveXML (XML_DIR "level3.xml"); break;
			case 4: if (iJustXML != 1) { SavePLV (OUT_DIR "level4.plv"); }
				SaveXML (XML_DIR "level4.xml"); break;
			case 5: if (iJustXML != 1) { SavePLV (OUT_DIR "level5.plv"); }
				SaveXML (XML_DIR "level5.xml"); break;
			case 6: if (iJustXML != 1) { SavePLV (OUT_DIR "level6.plv"); }
				SaveXML (XML_DIR "level6.xml"); break;
			case 7: if (iJustXML != 1) { SavePLV (OUT_DIR "level7.plv"); }
				SaveXML (XML_DIR "level7.xml"); break;
			case 8: if (iJustXML != 1) { SavePLV (OUT_DIR "level8.plv"); }
				SaveXML (XML_DIR "level8.xml"); break;
			case 9: if (iJustXML != 1) { SavePLV (OUT_DIR "level9.plv"); }
				SaveXML (XML_DIR "level9.xml"); break;
			case 10: if (iJustXML != 1) { SavePLV (OUT_DIR "level10.plv"); }
				SaveXML (XML_DIR "level10.xml"); break;
			case 11: if (iJustXML != 1) { SavePLV (OUT_DIR "level11.plv"); }
				SaveXML (XML_DIR "level11.xml"); break;
			case 12: if (iJustXML != 1) { SavePLV (OUT_DIR "level12a.plv"); }
				SaveXML (XML_DIR "level12a.xml"); break;
			case 13: if (iJustXML != 1) { SavePLV (OUT_DIR "level12b.plv"); }
				SaveXML (XML_DIR "level12b.xml"); break;
			case 14: if (iJustXML != 1) { SavePLV (OUT_DIR "princess.plv"); }
				SaveXML (XML_DIR "princess.xml"); break;
			case 15: if (iJustXML != 1) { SavePLV (OUT_DIR "potions.plv"); }
				SaveXML (XML_DIR "potions.xml"); break;
		}
	}

	if (iEditPoP == 2)
	{
		if ((int)luLevelNr < 15)
		{
			snprintf (sFileName, MAX_FILE, "%s____0%i.plv",
				OUT_DIR_POP2, 1999 + (int)luLevelNr);
		} else {
			snprintf (sFileName, MAX_FILE, "%s____0%i.plv",
				OUT_DIR_POP2, 2005 + (int)luLevelNr);
		}
		if (iJustXML != 1) { SavePLV (sFileName); }
	}

	if (iEditPoP == 3)
	{
		SaveSMC ((int)luLevelNr);
	}
}
/*****************************************************************************/
int ChecksumOrWrite (int iFd)
/*****************************************************************************/
{
	long lSum;
	int iSC;
	int iTemp;
	int iTemp2;
	int iAct1, iAct2;
	int iGuardMod;
	char sToWrite[MAX_TOWRITE + 2];
	int iMP;

	lSum = 0;

/*** PoP1 = 0; PoP2 = 0 ***/

	/*** Level Foreground ***/
	for (iTemp = 1; iTemp <= iRooms; iTemp++)
	{
		for (iTemp2 = 0; iTemp2 <= 29; iTemp2++)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c", iThingA[iTemp][iTemp2]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
		}
	}

/*** PoP1 = 720; PoP2 = 960 ***/

	/*** Level Modifier ***/
	for (iTemp = 1; iTemp <= iRooms; iTemp++)
	{
		for (iTemp2 = 0; iTemp2 <= 29; iTemp2++)
		{
			if (iEditPoP != 2)
			{
				snprintf (sToWrite, MAX_TOWRITE, "%c", iModifierA[iTemp][iTemp2][1]);
				if (iFd == -1)
					{ lSum+=sToWrite[0]; }
						else { write (iFd, sToWrite, 1); }
			} else {
				snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c",
					iModifierA[iTemp][iTemp2][1], iModifierA[iTemp][iTemp2][2],
					iModifierA[iTemp][iTemp2][3], iModifierA[iTemp][iTemp2][4]);
				if (iFd == -1)
					{ for (iSC = 0; iSC < 4; iSC++) { lSum+=sToWrite[iSC]; } }
						else { write (iFd, sToWrite, 4); }
			}
		}
	}

/*** PoP1 = 1440; PoP2 = 4800 ***/

	if (iEditPoP != 2)
	{
		if (iFd == -1)
			{ for (iSC = 0; iSC < 256; iSC++) { lSum+=sFirstDoorEvents[iSC]; } }
				else { WriteCharByChar (iFd, sFirstDoorEvents, 256); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 256; iSC++) { lSum+=sSecondDoorEvents[iSC]; } }
				else { WriteCharByChar (iFd, sSecondDoorEvents, 256); }
	} else {
		for (iTemp = 0; iTemp < 256; iTemp++)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c", iPoP2DoorRoom[iTemp],
				iPoP2DoorLocation[iTemp], iPoP2DoorType[iTemp],
				iPoP2DoorLeft[iTemp], iPoP2DoorRight[iTemp]);
			if (iFd == -1)
				{ for (iSC = 0; iSC < 5; iSC++) { lSum+=sToWrite[iSC]; } }
					else { write (iFd, sToWrite, 5); }
		}
	}

/*** PoP1 = 1952; PoP2 = 6080 ***/

	for (iTemp = 1; iTemp <= iRoomLinks; iTemp++)
	{
		/*** Were: Modulo (iTemp, 4, 2) and Modulo (iTemp, 4, 1) ***/
		snprintf (sToWrite, MAX_TOWRITE, "%c",
			iRoomConnections[((int)((iTemp - 1) / 4)) + 1][((iTemp - 1) % 4) + 1]);
		if (iFd == -1)
			{ lSum+=sToWrite[0]; }
				else { write (iFd, sToWrite, 1); }
	}

/*** PoP1 = 2048; PoP2 = 6208 ***/

	if (iEditPoP != 2)
	{
		/*** multiplayer ***/
		if (iNrPlayers > 1) { iMP = 0x01; } else { iMP = 0x00; }
		snprintf (sToWrite, MAX_TOWRITE, "%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c",
			0x18, iMP, iNrPlayers,
			arKidU1[8], arKidU2[8], arKidU3[8], arKidU4[8],
				arKidClr[8], arKidRoom[8], arKidPos[8] - 1, FixDir (arKidDir[8]),
			arKidU1[7], arKidU2[7], arKidU3[7], arKidU4[7],
				arKidClr[7], arKidRoom[7], arKidPos[7] - 1, FixDir (arKidDir[7]),
			arKidU1[6], arKidU2[6], arKidU3[6], arKidU4[6],
				arKidClr[6], arKidRoom[6], arKidPos[6] - 1, FixDir (arKidDir[6]),
			arKidU1[5], arKidU2[5], arKidU3[5], arKidU4[5],
				arKidClr[5], arKidRoom[5], arKidPos[5] - 1, FixDir (arKidDir[5]),
			arKidU1[4], arKidU2[4], arKidU3[4], arKidU4[4],
				arKidClr[4], arKidRoom[4], arKidPos[4] - 1, FixDir (arKidDir[4]),
			arKidU1[3], arKidU2[3], arKidU3[3], arKidU4[3],
				arKidClr[3], arKidRoom[3], arKidPos[3] - 1, FixDir (arKidDir[3]),
			arKidU1[2], arKidU2[2], arKidU3[2], arKidU4[2],
				arKidClr[2], arKidRoom[2], arKidPos[2] - 1, FixDir (arKidDir[2]),
			arKidU1[1], arKidU2[1], arKidU3[1], arKidU4[1],
				arKidClr[1]);
		if (iFd == -1)
			{ for (iSC = 0; iSC < 64; iSC++) { lSum+=sToWrite[iSC]; } }
				else { write (iFd, sToWrite, 64); }
	} else {
		/*** Instead of saving sLastRoom; always use 32. ***/
		snprintf (sToWrite, MAX_TOWRITE, "%c", 32);
		if (iFd == -1)
			{ lSum+=sToWrite[0]; }
				else { write (iFd, sToWrite, 1); }

		if (iFd == -1)
			{ for (iSC = 0; iSC < 4; iSC++) { lSum+=sJEFF[iSC]; } }
				else { WriteCharByChar (iFd, sJEFF, 4); }
		snprintf (sToWrite, MAX_TOWRITE, "%c", iEXEEnvPoP2);
		if (iFd == -1)
			{ lSum+=sToWrite[0]; }
				else { write (iFd, sToWrite, 1); }
		if (iFd == -1)
			{ lSum+=sUnknownI[0]; }
				else { write (iFd, sUnknownI, 1); }

		/*** Instead of saving sLevelInit; fixes gameplay lv2 problem. ***/
		if (iFd == -1)
			{ lSum+=sLevelNumber[0]; }
				else { write (iFd, sLevelNumber, 1); }

		/*** Instead of saving sExtraImgResources; enable more resources. ***/
		if (iEXEEnvPoP2 == 0x05)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0);
		}
		if (iEXEEnvPoP2 == 0x01)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
		}
		if (iEXEEnvPoP2 == 0x03)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0,
				0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0);
		}
		if (iEXEEnvPoP2 == 0x04)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0);
		}
		if (iEXEEnvPoP2 == 0x02)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0,
				1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0);
		}
		if (iEXEEnvPoP2 == 0x06)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c"
				"%c%c%c%c%c%c%c%c%c%c%c%c", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
				0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0);
		}
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sToWrite[iSC]; } }
				else { write (iFd, sToWrite, 24); }
	}

/*** PoP1 = 2112; PoP2 = 6240 ***/

	snprintf (sToWrite, MAX_TOWRITE, "%c", arKidRoom[1]);
	if (iFd == -1)
		{ lSum+=sToWrite[0]; }
			else { write (iFd, sToWrite, 1); }
	snprintf (sToWrite, MAX_TOWRITE, "%c", arKidPos[1] - 1);
	if (iFd == -1)
		{ lSum+=sToWrite[0]; }
			else { write (iFd, sToWrite, 1); }
	snprintf (sToWrite, MAX_TOWRITE, "%c", FixDir (arKidDir[1]));
	/*** 3 of 4 (DOS) ***/
	if (iEditPoP != 1)
	{
		if ((luLevelNr == 2) || (luLevelNr == 16) ||
			(((luLevelNr == 1) || (luLevelNr == 15)) && (arKidRoom[1] == 4)) ||
			(((luLevelNr == 6) || (luLevelNr == 20)) && (arKidRoom[1] == 27)) ||
			(((luLevelNr == 10) || (luLevelNr == 24)) && (arKidRoom[1] == 22)) ||
			(((luLevelNr == 14) || (luLevelNr == 28)) && (arKidRoom[1] == 1)))
		{
			if (arKidDir[1] == 0) { snprintf (sToWrite, MAX_TOWRITE, "%c", 255); }
				else { snprintf (sToWrite, MAX_TOWRITE, "%c", 0); }
		}
	}
	if (iFd == -1)
		{ lSum+=sToWrite[0]; }
			else { write (iFd, sToWrite, 1); }

/*** PoP1 = 2115; PoP2 = 6243 ***/

	if (iEditPoP != 2)
	{
		switch ((int)luLevelNr)
		{
			case 15: /*** potions level ***/
				if (iFd == -1)
					{ for (iSC = 0; iSC < 3; iSC++) { lSum+=sUnknownIIandIII[iSC]; } }
						else { WriteCharByChar (iFd, sUnknownIIandIII, 3); }
				break;
			default:
				if (iFd == -1)
					{ for (iSC = 0; iSC < 4; iSC++) { lSum+=sUnknownIIandIII[iSC]; } }
						else { WriteCharByChar (iFd, sUnknownIIandIII, 4); }
				break;
		}
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sGuardLocations[iSC]; } }
				else { WriteCharByChar (iFd, sGuardLocations, 24); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sGuardDirections[iSC]; } }
				else { WriteCharByChar (iFd, sGuardDirections, 24); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 48; iSC++) { lSum+=sUnknownIVaandIVb[iSC]; } }
				else { WriteCharByChar (iFd, sUnknownIVaandIVb, 48); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sGuardSkills[iSC]; } }
				else { WriteCharByChar (iFd, sGuardSkills, 24); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sUnknownIVc[iSC]; } }
				else { WriteCharByChar (iFd, sUnknownIVc, 24); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 24; iSC++) { lSum+=sGuardColors[iSC]; } }
				else { WriteCharByChar (iFd, sGuardColors, 24); }
		if (iFd == -1)
			{ for (iSC = 0; iSC < 16; iSC++) { lSum+=sUnknownIVd[iSC]; } }
				else { WriteCharByChar (iFd, sUnknownIVd, 16); }
	} else {
		if (iFd == -1)
			{ for (iSC = 0; iSC < 3; iSC++) { lSum+=sUnknownII[iSC]; } }
				else { WriteCharByChar (iFd, sUnknownII, 3); }
		snprintf (sToWrite, MAX_TOWRITE, "%c", iEXEGuardTypePoP2);
		if (iFd == -1)
			{ lSum+=sToWrite[0]; }
				else { write (iFd, sToWrite, 1); }
		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c", iStaticGuards_Amount[iTemp]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
			for (iTemp2 = 0; iTemp2 < 5; iTemp2++)
			{
				if (iStaticGuards_16_Type[iTemp][iTemp2] != 2)
				{ /*** not a skeleton ***/
					iAct1 = 0;
					iAct2 = 0;
				} else { /*** a skeleton ***/
					iAct1 = iStaticGuards_18_SkelAct1[iTemp][iTemp2];
					iAct2 = iStaticGuards_19_SkelAct2[iTemp][iTemp2];
				}
				switch (iStaticGuards_16_Type[iTemp][iTemp2])
				{
					case 0: iGuardMod = 77; break; /*** guard ***/
					case 1: iGuardMod = 105; break; /*** sword ***/
					case 2: /*** skeleton ***/
						if (((iAct1 == 0) && (iAct2 == 0)) ||
							((iAct1 == 1) && (iAct2 == 0)) ||
							((iAct1 == 255) && (iAct2 == 0)))
							{ iGuardMod = 112; }
								else { iGuardMod = 119; }
						break;
					case 3: iGuardMod = 2; break; /*** fake prince ***/
					case 5: iGuardMod = 130; break; /*** head, long hair ***/
					case 6: iGuardMod = 130; break; /*** head, short hair ***/
					case 7: iGuardMod = 77; break; /*** birdman ***/
					case 8: iGuardMod = 170; break; /*** snake ***/
					default: iGuardMod = 77; break; /*** As a fallback. ***/
				}
				snprintf (sToWrite, MAX_TOWRITE,
					"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
					iStaticGuards_1_Locations[iTemp][iTemp2],
					iStaticGuards_2_Offsets1[iTemp][iTemp2],
					iStaticGuards_3_Offsets2[iTemp][iTemp2],
					iStaticGuards_4_Directions[iTemp][iTemp2],
					iStaticGuards_5_Skills[iTemp][iTemp2],
					iGuardMod,
					iStaticGuards_7_Unknown[iTemp][iTemp2],
					iStaticGuards_8_Unknown[iTemp][iTemp2],
					iStaticGuards_9_Unknown[iTemp][iTemp2],
					iStaticGuards_10_Colors[iTemp][iTemp2],
					iTemp2,
					iStaticGuards_12_Unknown[iTemp][iTemp2],
					iStaticGuards_13_Unknown[iTemp][iTemp2],
					iStaticGuards_14_Unknown[iTemp][iTemp2],
					iStaticGuards_15_Unknown[iTemp][iTemp2],
					iStaticGuards_16_Type[iTemp][iTemp2],
					iStaticGuards_17_Hitpoints[iTemp][iTemp2],
					iAct1,
					iAct2,
					iStaticGuards_20_Unknown[iTemp][iTemp2],
					iStaticGuards_21_Unknown[iTemp][iTemp2],
					iStaticGuards_22_Unknown[iTemp][iTemp2],
					iStaticGuards_23_Unknown[iTemp][iTemp2]);
				if (iFd == -1)
					{ for (iSC = 0; iSC < 23; iSC++) { lSum+=sToWrite[iSC]; } }
						else { write (iFd, sToWrite, 23); }
			}
		}
		snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c"
			"%c%c%c%c%c%c%c%c", iCheckPoints[0], iCheckPoints[1], iCheckPoints[2],
			iCheckPoints[3], iCheckPoints[4], iCheckPoints[5],
			iCheckPoints[6], iCheckPoints[7], iCheckPoints[8],
			iCheckPoints[9], iCheckPoints[10], iCheckPoints[11],
			iCheckPoints[12], iCheckPoints[13], iCheckPoints[14],
			iCheckPoints[15], iCheckPoints[16], iCheckPoints[17]);
		if (iFd == -1)
			{ for (iSC = 0; iSC < 18; iSC++) { lSum+=sToWrite[iSC]; } }
				else { write (iFd, sToWrite, 18); }
		for (iTemp = 0; iTemp < iRooms; iTemp++)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%c", iDynamicGuards_Sets[iTemp]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
			snprintf (sToWrite, MAX_TOWRITE, "%c", iDynamicGuards_Skill[iTemp]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
			snprintf (sToWrite, MAX_TOWRITE, "%c", iDynamicGuards_Unknown1[iTemp]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
			snprintf (sToWrite, MAX_TOWRITE, "%c", iDynamicGuards_Unknown2[iTemp]);
			if (iFd == -1)
				{ lSum+=sToWrite[0]; }
					else { write (iFd, sToWrite, 1); }
			for (iTemp2 = 0; iTemp2 < 3; iTemp2++)
			{
				snprintf (sToWrite, MAX_TOWRITE,
					"%c%c%c%c%c%c%c%c%c%c",
					iTemp2,
					iDynamicGuards_2_MaxTog[iTemp][iTemp2],
					iDynamicGuards_3_Row[iTemp][iTemp2],
					iDynamicGuards_4_Column[iTemp][iTemp2],
					iDynamicGuards_5_LatBefore[iTemp][iTemp2],
					iDynamicGuards_6_LatBetween[iTemp][iTemp2],
					iDynamicGuards_7_CanJump[iTemp][iTemp2],
					iDynamicGuards_8_PrinceRow[iTemp][iTemp2],
					iDynamicGuards_9_Amount[iTemp][iTemp2],
					iDynamicGuards_10_Hitpoints[iTemp][iTemp2]);
				if (iFd == -1)
					{ for (iSC = 0; iSC < 10; iSC++) { lSum+=sToWrite[iSC]; } }
						else { write (iFd, sToWrite, 10); }
			}
		}
		if (iFd == -1)
			{ for (iSC = 0; iSC < 960; iSC++) { lSum+=sMusic[iSC]; } }
				else { WriteCharByChar (iFd, sMusic, 960); }
	}

/*** PoP1 = 2302/2303; PoP2 = 12025 ***/

	if (iEditPoP != 2)
	{
		if (iFd == -1)
			{ lSum = lSum + sEndCode[0] + sEndCode[1]; }
				else { WriteCharByChar (iFd, sEndCode, 2); }
	}

/*** PoP1 = 2304/2305; PoP2 = 12025 ***/

	/*** Was: 255 - Modulo (lSum, 256, 1) ***/
	/*** Now returns 255 instead of -1. ***/
	return (255 - (lSum % 256));
}
/*****************************************************************************/
void SavePLV (char *sFileName)
/*****************************************************************************/
{
	int iFd;
	int iTemp;
	unsigned int iHex;
	char sToWrite[MAX_TOWRITE + 2];
	char sToTemp[MAX_TOWRITE + 2];

	/*** Open file. ***/
	iFd = open (sFileName, O_WRONLY|O_TRUNC|O_CREAT|O_BINARY, 0600);
	if (iFd == -1)
	{
		printf ("[FAILED] Could not create level file: %s!\n", strerror (errno));
		exit (EXIT_ERROR);
	}

	WriteCharByChar (iFd, sMagicID, 7);
	WriteCharByChar (iFd, sPOPVersion, 1);
	WriteCharByChar (iFd, sPLVVersion, 1);
	WriteCharByChar (iFd, sLevelNumber, 1);
	WriteCharByChar (iFd, sNumberOfFields, 4);
	WriteCharByChar (iFd, sLevelSize, 4);
	snprintf (sToWrite, MAX_TOWRITE, "%c", ChecksumOrWrite (-1));
	write (iFd, sToWrite, 1);

	ChecksumOrWrite (iFd);

	iHex = 0;
	snprintf (sToTemp, MAX_TOWRITE, "%08x", WriteUserData (-1, 2));
	for (iTemp = 0; iTemp <= 3; iTemp++)
	{
		snprintf (sToWrite, MAX_TOWRITE, "%c%c", sToTemp[6 - (2 * iTemp)],
			sToTemp[7 - (2 * iTemp)]);
		sscanf (sToWrite, "%x", &iHex);
		snprintf (sToWrite, MAX_TOWRITE, "%c", iHex);
		write (iFd, sToWrite, 1);
	}

	WriteUserData (iFd, 1);

	close (iFd);

	if (iEditPoP != 2)
	{
		if (system (PR_EXECUTABLE " -i -f --resource=" PR_RESOURCES
			" " LEVELS_DAT " > " DEVNULL) == -1)
		{
			printf ("[FAILED] Could not import the PoP1 levels: %s!\n",
				strerror (errno)); exit (EXIT_ERROR);
		}
	} else {
		if (system (PR_EXECUTABLE " -ilevels2 -f --resource=" PR_POP2
			" " PRINCE_DAT " > " DEVNULL) == -1)
		{
			printf ("[FAILED] Could not import the PoP2 levels: %s!\n",
				strerror (errno)); exit (EXIT_ERROR);
		}
	}

	PlaySound ("wav/save.wav");

	iChanged = 0;
}
/*****************************************************************************/
int WriteUserData (int iFd, int iType)
/*****************************************************************************/
{
	int iTemp;
	char sToWrite[MAX_TOWRITE + 2];
	char sDateTime[MAX_DATETIME + 2];
	int iChars;

	iChars = 0;
	for (iTemp = 1; iTemp <= iInformationNr; iTemp++)
	{
		snprintf (sToWrite, MAX_TOWRITE, "%s", sInformation[iTemp][0]);
		if (iType == 1) { write (iFd, sToWrite, strlen (sToWrite)); }
			else { iChars += strlen (sToWrite); }
		snprintf (sToWrite, MAX_TOWRITE, "%c", 0x00);
		if (iType == 1) { write (iFd, sToWrite, 1); }
			else { iChars += 1; }
		if (strcmp (sInformation[iTemp][0], "Editor Name") == 0)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%s", EDITOR_NAME);
		}
		else if (strcmp (sInformation[iTemp][0], "Level Author") == 0)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%s", sAuthor);
		}
		else if (strcmp (sInformation[iTemp][0], "Editor Version") == 0)
		{
			snprintf (sToWrite, MAX_TOWRITE, "%s", EDITOR_VERSION);
		}
		else if (strcmp (sInformation[iTemp][0], "Time Last Modified") == 0)
		{
			DateTime (sDateTime);
			snprintf (sToWrite, MAX_TOWRITE, "%s", sDateTime);
		}
		else
		{
			snprintf (sToWrite, MAX_TOWRITE, "%s", sInformation[iTemp][1]);
		}
		if (iType == 1) { write (iFd, sToWrite, strlen (sToWrite)); }
			else { iChars += strlen (sToWrite); }
		snprintf (sToWrite, MAX_TOWRITE, "%c", 0x00);
		if (iType == 1) { write (iFd, sToWrite, 1); }
			else { iChars += 1; }
	}

	return (iChars);
}
/*****************************************************************************/
void WriteCharByChar (int iFd, unsigned char *sString, int iLength)
/*****************************************************************************/
{
	int iTemp;
	char sToWrite[MAX_TOWRITE + 2];

	for (iTemp = 0; iTemp < iLength; iTemp++)
	{
		snprintf (sToWrite, MAX_TOWRITE, "%c", sString[iTemp]);
		write (iFd, sToWrite, 1);
	}
}
/*****************************************************************************/
int AddCharByChar (unsigned char *sTo, int iToSize,
	unsigned char *sString, int iLength)
/*****************************************************************************/
{
	int iLoop;

	for (iLoop = 0; iLoop < iLength; iLoop++)
	{
		sTo[iToSize + iLoop] = sString[iLoop];
	}
	sTo[iToSize + iLoop + 1] = '\0';

	return (iLength);
}
/*****************************************************************************/
void ShowUsage (void)
/*****************************************************************************/
{
	printf ("%s %s\n%s\n\n", EDITOR_NAME, EDITOR_VERSION, COPYRIGHT);
	printf ("Usage:\n");
	printf ("  %s [OPTIONS]\n\nOptions:\n", EDITOR_NAME);
	printf ("  -h, -?,    --help           display this help and exit\n");
	printf ("  -v,        --version        output version information and"
		" exit\n");
	printf ("  -x,        --xml            export PoP1 for DOS levels as XML and"
		" exit\n");
	printf ("  -y,        --import         import PoP1 for DOS levels as XML\n");
	printf ("  -d,        --debug          also show levels on the console\n");
	printf ("  -n,        --noaudio        mute editor and game audio\n");
	printf ("  -q,        --quiteloud      chompers in-editor make noise\n");
	printf ("  -i,        --improved       use \"improved\" as the cheat"
		" code\n");
	printf ("                              (default: \"megahit\"/autodetect)\n");
	printf ("  -m,        --makinit        \"makinit\" instead of"
		" \"yippeeyahoo\"\n");
	printf ("  -c='CODE', --cheat='CODE'   use CODE as the cheat code\n");
	printf ("  -a='NAME', --author='NAME'  use NAME as the author when"
		" saving\n");
	printf ("  -z,        --zoom           double the interface size\n");
	printf ("  -f,        --fullscreen     start in fullscreen mode\n");
	printf ("  -l=NR,     --level=NR       start in level NR\n");
	printf ("  -1,        --pop1           edit PoP1 for DOS levels\n");
	printf ("  -2,        --pop2           edit PoP2 for DOS levels\n");
	printf ("  -3,        --snes1          edit PoP1 for SNES levels\n");
	printf ("  -s,        --static         do not display animations\n");
	printf ("  -k,        --keyboard       do not use a game controller\n");
	printf ("  -e=TYPE    --exe=TYPE       specify executable type\n");
	printf ("                              (default: autodetect)\n");
	printf ("  -t=ENV     --test=ENV       test PoP1 for SNES tile images"
		" availability\n\n");
	printf ("Types:\n");
	printf ("  p0, u0, p3, u3, p4, u4      (PoP1 for DOS)\n");
	printf ("  F0, F1, IR, D0, D1          (PoP2 for DOS)\n");
	printf ("  JP, US, EU                  (PoP1 for SNES)\n\n");
	printf ("Envs:\n");
	printf ("  b, f, g, h, i, j, l, m, s, u\n\n");
	exit (EXIT_NORMAL);
}
/*****************************************************************************/
void PrIfDe (char *sString)
/*****************************************************************************/
{
	if (iDebug == 1) { printf ("%s", sString); }
}
/*****************************************************************************/
void MixAudio (void *unused, Uint8 *stream, int iLen)
/*****************************************************************************/
{
	int iTemp;
	int iAmount;

	if (unused != NULL) { } /*** To prevent warnings. ***/

	SDL_memset (stream, 0, iLen); /*** SDL2 ***/
	for (iTemp = 0; iTemp < NUM_SOUNDS; iTemp++)
	{
		iAmount = (sounds[iTemp].dlen-sounds[iTemp].dpos);
		if (iAmount > iLen)
		{
			iAmount = iLen;
		}
		SDL_MixAudio (stream, &sounds[iTemp].data[sounds[iTemp].dpos], iAmount,
			SDL_MIX_MAXVOLUME);
		sounds[iTemp].dpos += iAmount;
	}
}
/*****************************************************************************/
void PlaySound (char *sFile)
/*****************************************************************************/
{
	int iIndex;
	SDL_AudioSpec wave;
	Uint8 *data;
	Uint32 dlen;
	SDL_AudioCVT cvt;

	if (iNoAudio == 1) { return; }
	for (iIndex = 0; iIndex < NUM_SOUNDS; iIndex++)
	{
		if (sounds[iIndex].dpos == sounds[iIndex].dlen)
		{
			break;
		}
	}
	if (iIndex == NUM_SOUNDS) { return; }

	if (SDL_LoadWAV (sFile, &wave, &data, &dlen) == NULL)
	{
		printf ("[FAILED] Could not load %s: %s!\n", sFile, SDL_GetError());
		exit (EXIT_ERROR);
	}
	SDL_BuildAudioCVT (&cvt, wave.format, wave.channels, wave.freq, AUDIO_S16, 2,
		44100);
	/*** The "+ 1" is a workaround for SDL bug #2274. ***/
	cvt.buf = (Uint8 *)malloc (dlen * (cvt.len_mult + 1));
	memcpy (cvt.buf, data, dlen);
	cvt.len = dlen;
	SDL_ConvertAudio (&cvt);
	SDL_FreeWAV (data);

	if (sounds[iIndex].data)
	{
		free (sounds[iIndex].data);
	}
	SDL_LockAudio();
	sounds[iIndex].data = cvt.buf;
	sounds[iIndex].dlen = cvt.len_cvt;
	sounds[iIndex].dpos = 0;
	SDL_UnlockAudio();
}
/*****************************************************************************/
int BrokenRoomLinks (int iPrint)
/*****************************************************************************/
{
	int iBroken;
	int iTemp;

	for (iTemp = 1; iTemp <= iRooms; iTemp++)
	{
		iDone[iTemp] = 0;
		iRoomConnectionsBroken[iTemp][1] = 0;
		iRoomConnectionsBroken[iTemp][2] = 0;
		iRoomConnectionsBroken[iTemp][3] = 0;
		iRoomConnectionsBroken[iTemp][4] = 0;
	}
	CheckSides (arKidRoom[1], 0, 0);
	iBroken = 0;

	for (iTemp = 1; iTemp <= iRooms; iTemp++)
	{
		/*** If the room is in use... ***/
		if (iDone[iTemp] == 1)
		{
			/*** check left ***/
			if ((iRoomConnections[iTemp][1] != 0) && /*** DOS ***/
				(iRoomConnections[iTemp][1] != 254) && /*** SNES ***/
				(iRoomConnections[iTemp][1] != 255)) /*** SNES ***/
			{
				if ((iRoomConnections[iTemp][1] == iTemp) ||
					(iRoomConnections[iRoomConnections[iTemp][1]][2] != iTemp))
				{
					iRoomConnectionsBroken[iTemp][1] = 1;
					iBroken = 1;
					if ((iDebug == 1) && (iPrint == 1))
					{
						printf ("[ INFO ] The left of room %i has a broken link.\n",
							iTemp);
					}
				}
			}
			/*** check right ***/
			if ((iRoomConnections[iTemp][2] != 0) && /*** DOS ***/
				(iRoomConnections[iTemp][2] != 254) && /*** SNES ***/
				(iRoomConnections[iTemp][2] != 255)) /*** SNES ***/
			{
				if ((iRoomConnections[iTemp][2] == iTemp) ||
					(iRoomConnections[iRoomConnections[iTemp][2]][1] != iTemp))
				{
					iRoomConnectionsBroken[iTemp][2] = 1;
					iBroken = 1;
					if ((iDebug == 1) && (iPrint == 1))
					{
						printf ("[ INFO ] The right of room %i has a broken link.\n",
							iTemp);
					}
				}
			}
			/*** check up ***/
			if ((iRoomConnections[iTemp][3] != 0) && /*** DOS ***/
				(iRoomConnections[iTemp][3] != 254) && /*** SNES ***/
				(iRoomConnections[iTemp][3] != 255)) /*** SNES ***/
			{
				if ((iRoomConnections[iTemp][3] == iTemp) ||
					(iRoomConnections[iRoomConnections[iTemp][3]][4] != iTemp))
				{
					iRoomConnectionsBroken[iTemp][3] = 1;
					iBroken = 1;
					if ((iDebug == 1) && (iPrint == 1))
					{
						printf ("[ INFO ] The top of room %i has a broken link.\n",
							iTemp);
					}
				}
			}
			/*** check down ***/
			if ((iRoomConnections[iTemp][4] != 0) && /*** DOS ***/
				(iRoomConnections[iTemp][4] != 254) && /*** SNES ***/
				(iRoomConnections[iTemp][4] != 255)) /*** SNES ***/
			{
				if ((iRoomConnections[iTemp][4] == iTemp) ||
					(iRoomConnections[iRoomConnections[iTemp][4]][3] != iTemp))
				{
					iRoomConnectionsBroken[iTemp][4] = 1;
					iBroken = 1;
					if ((iDebug == 1) && (iPrint == 1))
					{
						printf ("[ INFO ] The bottom of room %i has a broken link.\n",
							iTemp);
					}
				}
			}
		}
	}

	if (iBroken == 1) { MapHide(); }

	return (iBroken);
}
/*****************************************************************************/
int BrokenRoomChange (int iRoom, int iSide)
/*****************************************************************************/
{
	char sOnAdj[MAX_ADJ + 2];

	if (iRoom < 10)
		{ snprintf (sOnAdj, MAX_ADJ, "20%i%i", iRoom, iSide); }
			else { snprintf (sOnAdj, MAX_ADJ, "2%i%i", iRoom, iSide); }

	return (atoi (sOnAdj));
}
/*****************************************************************************/
int MouseSelectAdj (void)
/*****************************************************************************/
{
	int iOnAdj;
	int iRoom;
	int iAdjBaseX;
	int iAdjBaseY;

	iOnAdj = 0;
	for (iRoom = 1; iRoom <= iRooms; iRoom++)
	{
		switch (iRoom)
		{
			case 1: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 0); break;
			case 2: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 0); break;
			case 3: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 0); break;
			case 4: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 0); break;
			case 5: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 1); break;
			case 6: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 1); break;
			case 7: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 1); break;
			case 8: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 1); break;
			case 9: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 2); break;
			case 10: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 2); break;
			case 11: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 2); break;
			case 12: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 2); break;
			case 13: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 3); break;
			case 14: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 3); break;
			case 15: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 3); break;
			case 16: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 3); break;
			case 17: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 18: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 19: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 20: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 21: iAdjBaseX = ADJ_BASE_X + (63 * 0);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 22: iAdjBaseX = ADJ_BASE_X + (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 23: iAdjBaseX = ADJ_BASE_X + (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 24: iAdjBaseX = ADJ_BASE_X + (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 25: iAdjBaseX = ADJ_BASE_X - (63 * 4);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 26: iAdjBaseX = ADJ_BASE_X - (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 27: iAdjBaseX = ADJ_BASE_X - (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 28: iAdjBaseX = ADJ_BASE_X - (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 4); break;
			case 29: iAdjBaseX = ADJ_BASE_X - (63 * 4);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 30: iAdjBaseX = ADJ_BASE_X - (63 * 3);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 31: iAdjBaseX = ADJ_BASE_X - (63 * 2);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			case 32: iAdjBaseX = ADJ_BASE_X - (63 * 1);
				iAdjBaseY = ADJ_BASE_Y + (63 * 5); break;
			default:
				printf ("[FAILED] iRoom is not in the 1-32 range!\n");
				exit (EXIT_ERROR);
		}
		if (InArea (iAdjBaseX + 1, iAdjBaseY + 16,
			iAdjBaseX + 15, iAdjBaseY + 30) == 1)
		{
			iChangingBrokenRoom = iRoom;
			iChangingBrokenSide = 1; /*** left ***/
			iOnAdj = 1;
		}
		if (InArea (iAdjBaseX + 31, iAdjBaseY + 16,
			iAdjBaseX + 45, iAdjBaseY + 30) == 1)
		{
			iChangingBrokenRoom = iRoom;
			iChangingBrokenSide = 2; /*** right ***/
			iOnAdj = 1;
		}
		if (InArea (iAdjBaseX + 16, iAdjBaseY + 1,
			iAdjBaseX + 30, iAdjBaseY + 14) == 1)
		{
			iChangingBrokenRoom = iRoom;
			iChangingBrokenSide = 3; /*** up ***/
			iOnAdj = 1;
		}
		if (InArea (iAdjBaseX + 16, iAdjBaseY + 31,
			iAdjBaseX + 30, iAdjBaseY + 45) == 1)
		{
			iChangingBrokenRoom = iRoom;
			iChangingBrokenSide = 4; /*** down ***/
			iOnAdj = 1;
		}
	}

	return (iOnAdj);
}
/*****************************************************************************/
void CustomRenderCopy (SDL_Texture* src, char *srcn, SDL_Rect* srcrect,
	SDL_Renderer* dst, SDL_Rect *dstrect)
/*****************************************************************************/
{
	SDL_Rect stuff;
	int iW, iH;
	char srcnpart[100];

	SDL_QueryTexture (src, NULL, NULL, &iW, &iH);
	if (strcmp (srcn, "spriteflamed1") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamed2") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamed3") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamed4") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamep1") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamep2") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamep3") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spriteflamep4") == 0) { iW = iW / 9; }
	if (strcmp (srcn, "spritechomperd") == 0) { iW = iW / 5; }
	if (strcmp (srcn, "spritechomperdsel") == 0) { iW = iW / 5; }
	if (strcmp (srcn, "spritechomperp") == 0) { iW = iW / 5; }
	if (strcmp (srcn, "spritechomperpsel") == 0) { iW = iW / 5; }
	if (strcmp (srcn, "spriteswordd") == 0) { iW = iW / 2; }
	if (strcmp (srcn, "spritesworddsel") == 0) { iW = iW / 2; }
	if (strcmp (srcn, "spriteswordp") == 0) { iW = iW / 2; }
	if (strcmp (srcn, "spriteswordpsel") == 0) { iW = iW / 2; }
	if (strcmp (srcn, "spriteflamec1") == 0) { iW = iW / 8; }
	if (strcmp (srcn, "spriteflamec2") == 0) { iW = iW / 8; }
	if (strcmp (srcn, "spriteflamet1") == 0) { iW = iW / 4; }
	if (strcmp (srcn, "spriteflamet2") == 0) { iW = iW / 4; }
	if (strcmp (srcn, "imghourglasssprite") == 0) { iW = iW / 7; }
	if (strcmp (srcn, "imgsandsprite") == 0) { iW = iW / 3; }
	if (strcmp (srcn, "imgstatusbarsprite") == 0) { iW = iW / 18; }
	if ((strcmp (srcn, "imggs[1]") == 0) ||
		(strcmp (srcn, "imggs[2]") == 0)) { iW = iW / 8; }
	if (strcmp (srcn, "imgtooltip") == 0) { iH = iTooltipHeight; }

	/*** backgrounds ***/
	strncpy (srcnpart, srcn, 6);
	srcnpart[6] = '\0';
	if (strcmp (srcnpart, "ruinsb") == 0) { iW = 64; iH = 126; }
	strncpy (srcnpart, srcn, 7);
	srcnpart[7] = '\0';
	if (strcmp (srcnpart, "templeb") == 0) { iW = 64; iH = 126; }

	if (strcmp (srcn, "map message") == 0)
	{
		stuff.x = dstrect->x;
		stuff.y = dstrect->y;
	} else {
		stuff.x = dstrect->x * iScale;
		stuff.y = dstrect->y * iScale;
	}
	dstrect->w = iW;
	dstrect->h = iH;
	if (srcrect != NULL) /*** image ***/
	{
		stuff.w = dstrect->w * iScale;
		stuff.h = dstrect->h * iScale;
	} else { /*** font ***/
		stuff.w = dstrect->w;
		stuff.h = dstrect->h;
	}
	if (SDL_RenderCopy (dst, src, srcrect, &stuff) != 0)
	{
		printf ("[ WARN ] SDL_RenderCopy (%s): %s\n", srcn, SDL_GetError());
	}
}
/*****************************************************************************/
void LoadFonts (void)
/*****************************************************************************/
{
	font1 = TTF_OpenFont ("ttf/Bitstream-Vera-Sans-Bold.ttf",
		FONT_SIZE_15 * iScale);
	font2 = TTF_OpenFont ("ttf/Bitstream-Vera-Sans-Bold.ttf",
		FONT_SIZE_11 * iScale);
	font3 = TTF_OpenFont ("ttf/Bitstream-Vera-Sans-Bold.ttf",
		FONT_SIZE_20 * iScale);
	font4 = TTF_OpenFont ("ttf/Bitstream-Vera-Sans-Bold.ttf",
		FONT_SIZE_11); /*** No iScale. ***/
	font5 = TTF_OpenFont ("ttf/Terminus-Bold.ttf", 14 * iScale);
	if ((font1 == NULL) || (font2 == NULL) || (font3 == NULL) ||
		(font4 == NULL) || (font5 == NULL))
	{
		printf ("[FAILED] TTF_OpenFont() failed!\n");
		exit (EXIT_ERROR);
	}
}
/*****************************************************************************/
void CustomTile (int iThing, int iModifier[], char *sRetString)
/*****************************************************************************/
{
	/*** This function is not used for SNES. ***/

	int iTemp;
	char cRandom;
	char cMod;

	iTemp = iThing;
	cRandom = '0';
	if (iTemp >= 192) { iTemp-=192; cRandom = '3'; }
	if (iTemp >= 128) { iTemp-=128; cRandom = '2'; }
	if (iTemp >= 64) { iTemp-=64; cRandom = '1'; }
	if (iTemp >= 32) { iTemp-=32; cMod = 'Y'; }
		else { cMod = 'N'; }
	snprintf (sRetString, MAX_CUSTOM, "%c%c%i/%i",
		cRandom, cMod, iTemp, iModifier[0]);

	if (iEditPoP == 2)
	{
		if ((iThing == 27) && (iModifier[0] == 0) && (cCurType == 'c'))
			{ snprintf (sRetString, MAX_CUSTOM, "%s", "(grate)"); }
		if ((iThing == 43) && (iModifier[0] == 0) && (cCurType == 't'))
			{ snprintf (sRetString, MAX_CUSTOM, "%s", "(flame l)"); }
		if ((iThing == 5) && (iModifier[0] == 183) && (cCurType == 't'))
			{ snprintf (sRetString, MAX_CUSTOM, "%s", "(flame r)"); }
	}
}
/*****************************************************************************/
void ShowCurrentCustom (SDL_Renderer *screen)
/*****************************************************************************/
{
	int iTemp;

	iTemp = 0;
	switch (iChangeForeRand)
	{
		case 0: break;
		case 1: iTemp+=64; break;
		case 2: iTemp+=128; break;
		case 3: iTemp+=192; break;
	}
	if (iChangeForeMod == 1) { iTemp+=32; }
	iTemp+=iChangeFore;

	if ((cCurType == 'r') || (cCurType == 't'))
	{
		ShowBackground ((int[]){iChangeMod[1], iChangeMod[2],
			iChangeMod[3], iChangeMod[4]}, 100);
	}
	if (iEditPoP == 3)
	{
		ShowBackground ((int[]){0, 0, iBackA[iCurRoom][iSelected - 1], 0}, 100);
	}

	/*** iLocation 91 is the current custom. ***/
	if (iEditPoP != 3)
	{
		ShowImage (iTemp, (int[]){iChangeMod[1], iChangeMod[2],
			iChangeMod[3], iChangeMod[4]}, screen, 91, 0, 0, iTileW, iTileH);
	} else {
		ShowImage (999, (int[]){iChangeMod[1], iChangeMod[2],
			iChangeMod[3], iChangeMod[4]}, screen, 91, 0, 0, iTileW, iTileH);
	}
}
/*****************************************************************************/
void CreateBAK (void)
/*****************************************************************************/
{
	FILE *fDAT;
	FILE *fBAK;
	int iData;

	switch (iEditPoP)
	{
		case 1: fDAT = fopen (LEVELS_DAT, "rb"); break;
		case 2: fDAT = fopen (PRINCE_DAT, "rb"); break;
		case 3: fDAT = fopen (sSNESFile, "rb"); break;
		default:
			printf ("[FAILED] Impossible iEditPoP value: %i!\n", iEditPoP);
			exit (EXIT_ERROR); break;
	}
	if (fDAT == NULL)
		{ printf ("[FAILED] Could not open %s: %s!\n",
			LEVELS_DAT, strerror (errno)); }

	switch (iEditPoP)
	{
		case 1: fBAK = fopen (LEVELS_BAK, "wb"); break;
		case 2: fBAK = fopen (PRINCE_BAK, "wb"); break;
		case 3: fBAK = fopen (SNES_BAK, "wb"); break;
		default:
			printf ("[FAILED] Impossible iEditPoP value: %i!\n", iEditPoP);
			exit (EXIT_ERROR); break;
	}
	if (fBAK == NULL)
		{ printf ("[FAILED] Could not open %s: %s!\n",
			LEVELS_BAK, strerror (errno)); }

	while (1)
	{
		iData = fgetc (fDAT);
		if (iData == EOF) { break; }
			else { putc (iData, fBAK); }
	}

	fclose (fDAT);
	fclose (fBAK);
}
/*****************************************************************************/
void Help (void)
/*****************************************************************************/
{
	SDL_Event event;
	int iHelp;

	iHelp = 1;

	PlaySound ("wav/popup.wav");
	ShowHelp();
	while (iHelp == 1)
	{
		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							iHelp = 0; break;
					}
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
						case SDLK_o:
							iHelp = 0;
						default: break;
					}
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if ((InArea (66, 38, 66 + 560, 38 + 23) == 1) ||
						(InArea (31, 108, 661, 131) == 1) ||
						(InArea (45, 178, 647, 201) == 1) ||
						(InArea (38, 248, 654, 271) == 1) ||
						(InArea (31, 318, 661, 341) == 1))
					{
						SDL_SetCursor (curHand);
					} else {
						SDL_SetCursor (curArrow);
					}
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (590, 405, 674, 436) == 1) /*** OK ***/
						{
							if (iHelpOK != 1) { iHelpOK = 1; }
							ShowHelp();
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iHelpOK = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						if (InArea (590, 405, 674, 436) == 1)
							{ iHelp = 0; }
						if (InArea (66, 38, 66 + 560, 38 + 23) == 1)
							{ OpenURL ("https://apoplexy.github.io/apoplexysite/"); }
						if (InArea (31, 108, 661, 131) == 1)
							{ OpenURL ("https://forum.princed.org/viewforum.php?f=112"); }
						if (InArea (45, 178, 647, 201) == 1)
							{ OpenURL ("https://www.youtube.com/watch?v=dtZiAb180ds"); }
						if (InArea (38, 248, 654, 271) == 1)
							{ OpenURL ("https://forum.princed.org/viewforum.php?f=73"); }
						if (InArea (31, 318, 661, 341) == 1)
							{ OpenURL ("https://forum.princed.org/viewforum.php?f=116"); }
					}
					ShowHelp(); break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowHelp(); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/popup_close.wav");
	SDL_SetCursor (curArrow);
	ShowScreen (iScreen, ascreen);
}
/*****************************************************************************/
void ShowHelp (void)
/*****************************************************************************/
{
	/*** help ***/
	ShowImage (-9, (int[]){10, 0, 0, 0}, ascreen, 31, 0, 0, 692, 455);
	switch (iHelpOK)
	{
		case 0:
			/*** OK off ***/
			ShowImage (-9, (int[]){3, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
		case 1:
			/*** OK on ***/
			ShowImage (-9, (int[]){4, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
	}

	/*** refresh screen ***/
	SDL_RenderPresent (ascreen);
}
/*****************************************************************************/
unsigned long BytesAsLU (unsigned char *sData, int iBytes)
/*****************************************************************************/
{
	unsigned long luReturn;
	char sString[MAX_DATA + 2];
	char sTemp[MAX_DATA + 2];
	int iTemp;

	snprintf (sString, MAX_DATA, "%s", "");
	for (iTemp = iBytes - 1; iTemp >= 0; iTemp--)
	{
		snprintf (sTemp, MAX_DATA, "%s%02x", sString, sData[iTemp]);
		snprintf (sString, MAX_DATA, "%s", sTemp);
	}
	luReturn = strtoul (sString, NULL, 16);

	return (luReturn);
}
/*****************************************************************************/
void EXELoad_F2_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sData[MAX_DATA + 2];
	int iTemp;
	int iTab;

	iFdEXE = open (POP1_EXECUTABLE, O_RDONLY|O_BINARY);
	if (iFdEXE == -1)
	{
		printf ("[FAILED] Error opening %s: %s!\n", POP1_EXECUTABLE,
			strerror (errno));
		exit (EXIT_ERROR);
	}

	/*** Starting minutes left. Starting hit points. ***/
	LSeek (iFdEXE, arStartTimeHit[iEXEType]);
	CheckCodes ("C7 06 .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXEMinutesLeft = BytesAsLU (sData, 2);
	CheckCodes ("C7 06 .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData); /*** Not using this sData. ***/
	CheckCodes ("C7 06 .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXEHitPoints = BytesAsLU (sData, 2);

	/*** Allow triggering of any tile. ***/
	LSeek (iFdEXE, arAllowTr[iEXEType]);
	CheckCodes ("83 7E 0C 10", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData);
	if ((sData[0] == 0x75) && (sData[1] == 0x18))
	{
		iEXETriggering = 0;
	} else if ((sData[0] == 0x75) && (sData[1] == 0x13)) {
		iEXETriggering = 1;
	} else {
		printf ("[ WARN ] Strange triggering value!\n");
		iEXETriggering = 0; /*** As a fallback. ***/
	}

	/*** Prince has sword. ***/
	LSeek (iFdEXE, arSword[iEXEType]);
	CheckCodes ("83 7E 06 01", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData);
	if ((sData[0] == 0x74) && (sData[1] == 0x05)) /*** D ***/
	{
		iEXESword = -1;
	} else if ((sData[0] == 0xEB) && (sData[1] == 0x05)) { /*** N ***/
		iEXESword = 0;
	} else if ((sData[0] == 0x90) && (sData[1] == 0x90)) { /*** Y ***/
		iEXESword = 1;
	} else {
		printf ("[ WARN ] Strange sword value!\n");
		iEXESword = -1; /*** As a fallback. ***/
	}

	/*** Win. ***/
	LSeek (iFdEXE, arWin[iEXEType]);
	CheckCodes ("83 3E .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWinLevel = BytesAsLU (sData, 1);
	CheckCodes ("75 0C 83 3E .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWinRoom = BytesAsLU (sData, 1);

	/*** Base speed. ***/
	LSeek (iFdEXE, arBaseSpeed[iEXEType]);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXEBaseSpeed = BytesAsLU (sData, 2);

	/*** Fight speed. ***/
	LSeek (iFdEXE, arFightSpeed[iEXEType]);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXEFightSpeed = BytesAsLU (sData, 2);

	/*** Chomper speed. ***/
	LSeek (iFdEXE, arChomperSpeed[iEXEType]);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXEChomperSpeed = BytesAsLU (sData, 2);

	/*** (environments and enemy resources) ***/
	LSeek (iFdEXE, arEnvironment[iEXEType]);
	CheckCodes ("74 00", iFdEXE);
	for (iTemp = 0; iTemp <= 15; iTemp++)
	{
		ReadFromFile (iFdEXE, "", 1, sData);
		iEXEEnv[iTemp] = BytesAsLU (sData, 1);
	}
	if (iEXEPacked == 0)
	{
		LSeek (iFdEXE, arGuardRes[iEXEType]);
		for (iTemp = 0; iTemp <= 15; iTemp++)
		{
			ReadFromFile (iFdEXE, "", 2, sData);
			iEXEGRes[iTemp] = BytesAsLU (sData, 2);
		}
	}

	/*** Guard hit points per game level. ***/
	LSeek (iFdEXE, arGuardHit[iEXEType]);
	for (iTemp = 0; iTemp <= 15; iTemp++)
	{
		ReadFromFile (iFdEXE, "", 1, sData);
		iEXEGuard[iTemp] = BytesAsLU (sData, 1);
	}

	/*** Edit guard details. ***/
	for (iTab = 1; iTab <= 7; iTab++)
	{
		if ((iEXEPacked != 1) || ((iTab != 6) && (iTab != 7)))
		{
			LSeek (iFdEXE, arGuardDetails[iTab - 1][iEXEType]);
			for (iTemp = 1; iTemp <= 12; iTemp++)
			{
				ReadFromFile (iFdEXE, "", 2, sData);
				iEXEGuardD[iTab][iTemp] = BytesAsLU (sData, 2);
			}
		}
	}

	close (iFdEXE);
}
/*****************************************************************************/
void EXELoad_F3_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sData[MAX_DATA + 2];

	/*** Used for looping. ***/
	int iLoopMoves;

	iFdEXE = open (POP1_EXECUTABLE, O_RDONLY|O_BINARY);
	if (iFdEXE == -1)
	{
		printf ("[FAILED] Error opening %s: %s!\n", POP1_EXECUTABLE,
			strerror (errno));
		exit (EXIT_ERROR);
	}

	/*** Loose floor delay. ***/
	LSeek (iFdEXE, arLooseDelayA[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXELooseDelayA = BytesAsLU (sData, 1);
	LSeek (iFdEXE, arLooseDelayB[iEXEType]);
	ReadFromFile (iFdEXE, "", 2, sData);
	iEXELooseDelayB = BytesAsLU (sData, 2);
	if (((iEXELooseDelayA == 11) && (iEXELooseDelayB != 3956)) ||
		((iEXELooseDelayA != 11) && (iEXELooseDelayB != 37008)))
		{ printf ("[ WARN ] Strange loose floor delay values!\n"); }

	/*** Allow loose floor climbing. ***/
	LSeek (iFdEXE, arLooseClimbing[iEXEType]);
	ReadFromFile (iFdEXE, "", 2, sData);
	if ((sData[0] == 0x75) && (sData[1] == 0xD3))
	{
		iEXELooseClimbing = 0;
	} else if ((sData[0] == 0x90) && (sData[1] == 0x90)) {
		iEXELooseClimbing = 1;
	} else {
		printf ("[ WARN ] Strange loose climbing value!\n");
		iEXELooseClimbing = 0; /*** As a fallback. ***/
	}

	/*** Shadow start. ***/
	LSeek (iFdEXE, arShadowStart[iEXEType]);
	ReadFromFile (iFdEXE, "", 24, sData);
	iEXEShadowStartF6 = sData[0]; /*** Yes, 6 before 5. ***/
	iEXEShadowStartX6 = sData[1];
	iEXEShadowStartY6 = sData[2];
	iEXEShadowStartD6 = sData[3];
	iEXEShadowStartC6 = sData[4];
	iEXEShadowStartR6 = sData[5];
	iEXEShadowStartA6 = sData[6];
	iEXEShadowStartN6 = sData[7];
	iEXEShadowStartF5 = sData[8];
	iEXEShadowStartX5 = sData[9];
	iEXEShadowStartY5 = sData[10];
	iEXEShadowStartD5 = sData[11];
	iEXEShadowStartC5 = sData[12];
	iEXEShadowStartR5 = sData[13];
	iEXEShadowStartA5 = sData[14];
	iEXEShadowStartN5 = sData[15];
	iEXEShadowStartF12 = sData[16];
	iEXEShadowStartX12 = sData[17];
	iEXEShadowStartY12 = sData[18];
	iEXEShadowStartD12 = sData[19];
	iEXEShadowStartC12 = sData[20];
	iEXEShadowStartR12 = sData[21];
	iEXEShadowStartA12 = sData[22];
	iEXEShadowStartN12 = sData[23];

	/*** Shadow moves. ***/
	LSeek (iFdEXE, arShadowMoves[iEXEType]);
	for (iLoopMoves = 1; iLoopMoves <= 7; iLoopMoves++)
	{
		ReadFromFile (iFdEXE, "", 2, sData);
		iEXEShadowMovesTime[iLoopMoves] = BytesAsLU (sData, 2);
		ReadFromFile (iFdEXE, "", 2, sData);
		iEXEShadowMovesAction[iLoopMoves] = BytesAsLU (sData, 2);
	}

	/*** Prince moves. ***/
	LSeek (iFdEXE, arPrinceMoves[iEXEType]);
	for (iLoopMoves = 1; iLoopMoves <= 24; iLoopMoves++)
	{
		ReadFromFile (iFdEXE, "", 2, sData);
		iEXEPrinceMovesTime[iLoopMoves] = BytesAsLU (sData, 2);
		ReadFromFile (iFdEXE, "", 2, sData);
		iEXEPrinceMovesAction[iLoopMoves] = BytesAsLU (sData, 2);
	}

	close (iFdEXE);
}
/*****************************************************************************/
void EXELoad_F4_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sData[MAX_DATA + 2];
	unsigned char sData2[MAX_DATA + 2];

	iFdEXE = open (POP1_EXECUTABLE, O_RDONLY|O_BINARY);
	if (iFdEXE == -1)
	{
		printf ("[FAILED] Error opening %s: %s!\n", POP1_EXECUTABLE,
			strerror (errno));
		exit (EXIT_ERROR);
	}

	/*** (Demo level) Playable. ***/
	LSeek (iFdEXE, arDemoPlayableD1[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	LSeek (iFdEXE, arDemoPlayableD2[iEXEType]);
	ReadFromFile (iFdEXE, "", 3, sData2);
	if ((sData[0] == 0x75) &&
		((((iEXEType == 0) || (iEXEType == 1)) && (sData2[0] == 0xB8) &&
			(sData2[1] == 0x42) && (sData2[2] == 0x00)) ||
		(((iEXEType == 2) || (iEXEType == 3)) && (sData2[0] == 0xB2) &&
			(sData2[1] == 0x44) && (sData2[2] == 0x00)) ||
		(((iEXEType == 4) || (iEXEType == 5)) && (sData2[0] == 0x84) &&
			(sData2[1] == 0x42) && (sData2[2] == 0x00)))) /*** N ***/
	{
		iEXEDemoPlayableD = 0;
	} else if ((sData[0] == 0xEB) &&
		((((iEXEType == 0) || (iEXEType == 1)) && (sData2[0] == 0x9E) &&
			(sData2[1] == 0x0F) && (sData2[2] == 0xFF)) ||
		(((iEXEType == 2) || (iEXEType == 3)) && (sData2[0] == 0xB0) &&
			(sData2[1] == 0x10) && (sData2[2] == 0xFF)) ||
		(((iEXEType == 4) || (iEXEType == 5)) && (sData2[0] == 0xAA) &&
			(sData2[1] == 0x10) && (sData2[2] == 0xFF)))) { /*** Y ***/
		iEXEDemoPlayableD = 1;
	} else {
		printf ("[ WARN ] Strange playable value!\n");
		iEXEDemoPlayableD = 0; /*** As a fallback. ***/
	}

	/*** (Demo level) Prince HP. ***/
	LSeek (iFdEXE, arDemoPrinceHP[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEDemoPrinceHP = BytesAsLU (sData, 1);

	/*** (Demo level) Ending room. ***/
	LSeek (iFdEXE, arDemoEndingRoom[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEDemoEndingRoom = BytesAsLU (sData, 1);

	/*** (Demo level) Prince skill. ***/
	LSeek (iFdEXE, arDemoPrinceSkill[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEDemoPrinceSkill = BytesAsLU (sData, 1);

	/*** (Demo level) Guard skill. ***/
	LSeek (iFdEXE, arDemoGuardSkill[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEDemoGuardSkill = BytesAsLU (sData, 1);

	/*** Disable. ***/
	if (iEXEType == 1)
	{
		LSeek (iFdEXE, arDisable2[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0xDC: iEXEDisable2 = 0; break;
			case 0x8C: iEXEDisable2 = 1; break;
			default: iEXEDisable2 = 0; break; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisable4[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0xD7: iEXEDisable4 = 0; break;
			case 0x8C: iEXEDisable4 = 1; break;
			default: iEXEDisable4 = 0; break; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisable5[iEXEType]);
		ReadFromFile (iFdEXE, "", 5, sData);
		if ((sData[0] == 0xD8) && (sData[1] == 0x28) &&
			(sData[2] == 0x00) && (sData[3] == 0x75) &&
			(sData[4] == 0x07)) /*** Not disabled. ***/
		{
			iEXEDisable5 = 0;
		} else if ((sData[0] == 0x8C) && (sData[1] == 0x28) &&
			(sData[2] == 0x00) && (sData[3] == 0x75) &&
			(sData[4] == 0x07)) { /*** Disabled. ***/
			iEXEDisable5 = 1;
		} else if ((sData[0] == 0x64) && (sData[1] == 0x43) &&
			(sData[2] == 0x00) && (sData[3] == 0x74) &&
			(sData[4] == 0x0C)) { /*** Disabled, but allow sheathing. ***/
			iEXEDisable5 = 2;
		} else {
			printf ("[ WARN ] Strange disable value!\n");
			iEXEDisable5 = 0; /*** As a fallback. ***/
		}
		LSeek (iFdEXE, arDisable6[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0xD9: iEXEDisable6 = 0; break;
			case 0x8C: iEXEDisable6 = 1; break;
			default: iEXEDisable6 = 0; break; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisable7A[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		LSeek (iFdEXE, arDisable7B[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData2);
		if ((sData[0] == 0xD3) && (sData2[0] == 0xD3))
		{
			iEXEDisable7 = 0;
		} else if ((sData[0] == 0x8C) && (sData2[0] == 0x8C)) {
			iEXEDisable7 = 1;
		} else {
			iEXEDisable7 = 0; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisable8[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0xD4: iEXEDisable8 = 0; break;
			case 0x8C: iEXEDisable8 = 1; break;
			default: iEXEDisable8 = 0; break; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisable9A[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		LSeek (iFdEXE, arDisable9B[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData2);
		if ((sData[0] == 0xD5) && (sData2[0] == 0xD5))
		{
			iEXEDisable9 = 0;
		} else if ((sData[0] == 0x8C) && (sData2[0] == 0x8C)) {
			iEXEDisable9 = 1;
		} else {
			iEXEDisable9 = 0; /*** Fallback. ***/
		}
		LSeek (iFdEXE, arDisableS[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0x03: iEXEDisableS = 0; break;
			case 0x00: iEXEDisableS = 1; break;
			default: iEXEDisableS = 0; break; /*** Fallback. ***/
		}
	}

	/*** Autorun. ***/
	if (iEXEType == 1)
	{
		LSeek (iFdEXE, arAutorun[iEXEType]);
		ReadFromFile (iFdEXE, "", 2, sData);
		if ((sData[0] == 0x75) && (sData[1] == 0x07))
		{
			iEXEAutorun = 0; /*** No autorun. ***/
		} else if ((sData[0] == 0xEB) && (sData[1] == 0x07)) {
			iEXEAutorun = 1; /*** Left. ***/
		} else if ((sData[0] == 0xEB) && (sData[1] == 0x1C)) {
			iEXEAutorun = 2; /*** Right. ***/
		} else {
			iEXEAutorun = 0; /*** Fallback. ***/
		}
	}

	/*** Quicker painful falls. ***/
	if (iEXEType == 1)
	{
		LSeek (iFdEXE, arQuicker[iEXEType]);
		ReadFromFile (iFdEXE, "", 1, sData);
		switch (sData[0])
		{
			case 0x14: iEXEQuicker = 0; break; /*** N ***/
			case 0x11: iEXEQuicker = 1; break; /*** Y ***/
			default: iEXEQuicker = 0; break; /*** Fallback. ***/
		}
	}

	close (iFdEXE);
}
/*****************************************************************************/
void EXELoad_F5_1 (void)
/*****************************************************************************/
{
	/*** Nothing for now. ***/
}
/*****************************************************************************/
void EXELoad_F2_2 (void)
/*****************************************************************************/
{
	/*** Nothing for now. ***/
}
/*****************************************************************************/
void EXELoad_F2_3 (void)
/*****************************************************************************/
{
	int iFdEXE;
	int iGuardType;
	unsigned char sData[MAX_DATA + 2];
	unsigned char sData2[MAX_DATA + 2];
	int iTab;
	int iLevel;

	iFdEXE = open (sSNESFile, O_RDONLY|O_BINARY);

	/***************************/
	/* Used on the EXE screen. */
	/***************************/

	/*** Guard settings. ***/
	for (iTab = 1; iTab <= 9; iTab++)
	{
		LSeek (iFdEXE, ulGuardSNES[iTab - 1]);
		for (iGuardType = 1; iGuardType <= 18; iGuardType++)
		{
			if (iTab != 9)
			{
				ReadFromFile (iFdEXE, "", 1, sData);
				iEXEGuardSNES[iTab][iGuardType] = BytesAsLU (sData, 1);
			} else { /*** sprite ***/
				ReadFromFile (iFdEXE, "", 2, sData);
				switch (BytesAsLU (sData, 2))
				{
					case 244: /*** guard ***/
						iEXEGuardSNES[iTab][iGuardType] = 1; break;
					case 308: /*** skeleton ***/
						iEXEGuardSNES[iTab][iGuardType] = 2; break;
					case 936: /*** female ***/
						iEXEGuardSNES[iTab][iGuardType] = 3; break;
					case 212: /*** fat ***/
						iEXEGuardSNES[iTab][iGuardType] = 4; break;
					case 276: /*** prince ***/
						iEXEGuardSNES[iTab][iGuardType] = 5; break;
					case 340: /*** knight ***/
						iEXEGuardSNES[iTab][iGuardType] = 6; break;
					case 988: /*** kali idol ***/
						iEXEGuardSNES[iTab][iGuardType] = 7; break;
					case 372: /*** jaffar ***/
						iEXEGuardSNES[iTab][iGuardType] = 8; break;
					default: /*** Fallback. ***/
						printf ("[ WARN ] Strange sprite value: %i.\n",
							(int)BytesAsLU (sData, 2));
						iEXEGuardSNES[iTab][iGuardType] = 1; break;
				}
			}
		}
	}

	/*** Music current level. ***/
	LSeek (iFdEXE, ulMusicSNES + (int)luLevelNr - 1);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEMusicSNESValue = BytesAsLU (sData, 1);
	switch (iEXEMusicSNESValue)
	{
		case 255:
			iEXEMusicSNESOnOff = 0;
			/*** To make it easier for the user. ***/
			if (iEXEType == 0) /*** JP ***/
			{
				iEXEMusicSNESValue = arDefaultMusicValuesJP[(int)luLevelNr - 1];
			} else if ((iEXEType == 1) || (iEXEType == 2)) { /*** US or EU ***/
				iEXEMusicSNESValue = arDefaultMusicValuesUSandEU[(int)luLevelNr - 1];
			} else { /*** As a fallback. ***/
				iEXEMusicSNESValue = 1;
			}
			break;
		default: iEXEMusicSNESOnOff = 1; break;
	}

	/*** Heat haze. ***/
	LSeek (iFdEXE, ulHazeSNES);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEHazeSNESValue = BytesAsLU (sData, 1);
	switch (iEXEHazeSNESValue)
	{
		case 204:
			iEXEHazeSNESOnOff = 0;
			/*** To make it easier for the user. ***/
			iEXEHazeSNESValue = ulDefaultHazeValue;
			break;
		default: iEXEHazeSNESOnOff = 1; break;
	}

	/*** Starting hit points. ***/
	LSeek (iFdEXE, ulHitSNES);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEHitPoints = BytesAsLU (sData, 1);

	/*** Prince has sword. ***/
	LSeek (iFdEXE, ulSwordSNES);
	ReadFromFile (iFdEXE, "", 5, sData);
	if ((sData[0] == 0x00) && (sData[1] == 0x80) && (sData[2] == 0x02) &&
		(sData[3] == 0xa9) && (sData[4] == 0x01)) /*** D ***/
	{
		iEXESword = -1;
	} else if ((sData[0] == 0x00) && (sData[1] == 0x80) && (sData[2] == 0x02) &&
		(sData[3] == 0xa9) && (sData[4] == 0x00)) { /*** N ***/
		iEXESword = 0;
	} else if ((sData[0] == 0x01) && (sData[1] == 0x80) && (sData[2] == 0x02) &&
		(sData[3] == 0xa9) && (sData[4] == 0x01)) { /*** Y ***/
		iEXESword = 1;
	} else {
		printf ("[ WARN ] Strange sword value!\n");
		iEXESword = -1; /*** As a fallback. ***/
	}

	/*** Intro (level 22) is playable. ***/
	LSeek (iFdEXE, arDemoPlayableS1[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData);
	LSeek (iFdEXE, arDemoPlayableS2[iEXEType]);
	ReadFromFile (iFdEXE, "", 1, sData2);
	if ((sData[0] == 0x15) && (sData2[0] == 0x15)) /*** N ***/
	{
		iEXEDemoPlayableS = 0;
	} else if ((sData[0] == 0xcc) && (sData2[0] == 0xcc)) { /*** Y ***/
		iEXEDemoPlayableS = 1;
	} else {
		printf ("[ WARN ] Strange demo value!\n");
		iEXEDemoPlayableS = 0; /*** As a fallback. ***/
	}

	/*** Warp potion. ***/
	LSeek (iFdEXE, ulWarpRoom);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWarpRoom = BytesAsLU (sData, 1);
	LSeek (iFdEXE, ulWarpFace);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWarpFace = BytesAsLU (sData, 1);
	LSeek (iFdEXE, ulWarpCol);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWarpCol = BytesAsLU (sData, 1);
	LSeek (iFdEXE, ulWarpRow);
	ReadFromFile (iFdEXE, "", 1, sData);
	iEXEWarpRow = BytesAsLU (sData, 1);

	/*************************************/
	/* Used when switching environments. */
	/*************************************/

	/*** Level type. ***/
	LSeek (iFdEXE, ulEnvL);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		ReadFromFile (iFdEXE, "", 1, sData);
		iEXEEnvL[iLevel] = BytesAsLU (sData, 1);
	}

	/*** Loose, buttons, doors. ***/
	LSeek (iFdEXE, ulEnvO);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		ReadFromFile (iFdEXE, "", 1, sData);
		iEXEEnvO[iLevel] = BytesAsLU (sData, 1);
	}

	/*** Flame addresses. ***/
	LSeek (iFdEXE, ulEnvF);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		ReadFromFile (iFdEXE, "", 2, sData);
		iEXEEnvF[iLevel] = BytesAsLU (sData, 2);
	}

	close (iFdEXE);
}
/*****************************************************************************/
void EXELoad_F5_3 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sData[MAX_DATA + 2];

	iFdEXE = open (sSNESFile, O_RDONLY|O_BINARY);

	/*** Skeleton continue for all. ***/
	LSeek (iFdEXE, ulSkelCont);
	ReadFromFile (iFdEXE, "", 11, sData);
	if ((sData[0] == 0xAD) && (sData[1] == 0x84) && (sData[2] == 0x04) &&
		(sData[3] == 0xC9) && (sData[4] == 0x01) && (sData[5] == 0xF0) &&
		(sData[6] == 0x20) && (sData[7] == 0xC9) && (sData[8] == 0x04) &&
		(sData[9] == 0x80) && (sData[10] == 0x2C))
	{
		iEXESkelCont = 1;
	} else {
		iEXESkelCont = 0;
	}

	close (iFdEXE);
}
/*****************************************************************************/
void EXESave_F2_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sData[MAX_DATA + 2];
	unsigned char sBytes[2 + 2];
	char sToWrite[MAX_TOWRITE + 2];
	int iTemp;
	int iTab;
	int iType;
	int iOut1, iOut2;

	iFdEXE = open (POP1_EXECUTABLE, O_RDWR|O_BINARY);

	/*** Starting minutes left. Starting hit points. ***/
	LSeek (iFdEXE, arStartTimeHit[iEXEType]);
	CheckCodes ("C7 06 .. ..", iFdEXE);
	sBytes[0] = (iEXEMinutesLeft >> 0) & 0xFF;
	sBytes[1] = (iEXEMinutesLeft >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);
	CheckCodes ("C7 06 .. ..", iFdEXE);
	ReadFromFile (iFdEXE, "", 2, sData); /*** Not using this sData. ***/
	CheckCodes ("C7 06 .. ..", iFdEXE);
	sBytes[0] = (iEXEHitPoints >> 0) & 0xFF;
	sBytes[1] = (iEXEHitPoints >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Allow triggering of any tile. ***/
	LSeek (iFdEXE, arAllowTr[iEXEType]);
	CheckCodes ("83 7E 0C 10", iFdEXE);
	if (iEXETriggering == 0)
		{ sBytes[0] = 0x75; sBytes[1] = 0x18; }
			else { sBytes[0] = 0x75; sBytes[1] = 0x13; }
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Prince has sword. ***/
	LSeek (iFdEXE, arSword[iEXEType]);
	CheckCodes ("83 7E 06 01", iFdEXE);
	switch (iEXESword)
	{
		case -1: sBytes[0] = 0x74; sBytes[1] = 0x05; break; /*** D ***/
		case 0: sBytes[0] = 0xEB; sBytes[1] = 0x05; break; /*** N ***/
		case 1: sBytes[0] = 0x90; sBytes[1] = 0x90; break; /*** Y ***/
	}
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Win. ***/
	LSeek (iFdEXE, arWin[iEXEType]);
	CheckCodes ("83 3E .. ..", iFdEXE);
	sBytes[0] = iEXEWinLevel;
	WriteCharByChar (iFdEXE, sBytes, 1);
	CheckCodes ("75 0C 83 3E .. ..", iFdEXE);
	sBytes[0] = iEXEWinRoom;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Base speed. ***/
	LSeek (iFdEXE, arBaseSpeed[iEXEType]);
	sBytes[0] = (iEXEBaseSpeed >> 0) & 0xFF;
	sBytes[1] = (iEXEBaseSpeed >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Fight speed. ***/
	LSeek (iFdEXE, arFightSpeed[iEXEType]);
	sBytes[0] = (iEXEFightSpeed >> 0) & 0xFF;
	sBytes[1] = (iEXEFightSpeed >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Chomper speed. ***/
	LSeek (iFdEXE, arChomperSpeed[iEXEType]);
	sBytes[0] = (iEXEChomperSpeed >> 0) & 0xFF;
	sBytes[1] = (iEXEChomperSpeed >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** (environments and enemy resources) ***/
	LSeek (iFdEXE, arEnvironment[iEXEType]);
	CheckCodes ("74 00", iFdEXE);
	snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
		iEXEEnv[0], iEXEEnv[1], iEXEEnv[2], iEXEEnv[3],
		iEXEEnv[4], iEXEEnv[5], iEXEEnv[6], iEXEEnv[7],
		iEXEEnv[8], iEXEEnv[9], iEXEEnv[10], iEXEEnv[11],
		iEXEEnv[12], iEXEEnv[13], iEXEEnv[14], iEXEEnv[15]);
	WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 16);
	if (iEXEPacked == 0)
	{
		LSeek (iFdEXE, arGuardRes[iEXEType]);
		for (iTemp = 0; iTemp <= 15; iTemp++)
		{
			sBytes[0] = (iEXEGRes[iTemp] >> 0) & 0xFF;
			sBytes[1] = (iEXEGRes[iTemp] >> 8) & 0xFF;
			WriteCharByChar (iFdEXE, sBytes, 2);
		}
	}

	/*** Update cCurType if necessary. ***/
	if ((iEXEEnv[(int)luLevelNr] == 0) && (cCurType == 'p'))
		{ cCurType = 'd'; }
	if ((iEXEEnv[(int)luLevelNr] == 1) && (cCurType == 'd'))
		{ cCurType = 'p'; }

	/*** Update iCurGuard if necessary. ***/
	if (iCurGuard != iEXEGRes[(int)luLevelNr])
		{ iCurGuard = iEXEGRes[(int)luLevelNr]; }

	/*** Skeletons should be immortal. ***/
	if (iEXEPacked == 0)
	{
		LSeek (iFdEXE, arImmortal[iEXEType]);
		if ((iEXEGRes[3] != 2) || (iEXEGRes[0] == 2) ||
			(iEXEGRes[1] == 2) || (iEXEGRes[2] == 2) || (iEXEGRes[4] == 2) ||
			(iEXEGRes[5] == 2) || (iEXEGRes[6] == 2) || (iEXEGRes[7] == 2) ||
			(iEXEGRes[8] == 2) || (iEXEGRes[9] == 2) || (iEXEGRes[10] == 2) ||
			(iEXEGRes[11] == 2) || (iEXEGRes[12] == 2) || (iEXEGRes[13] == 2) ||
			(iEXEGRes[14] == 2) || (iEXEGRes[15] == 2))
		{
			/*** Make all skeletons immortal. ***/
			switch (iEXEType)
			{
				case 1: /*** u0 ***/
					snprintf (sToWrite, MAX_TOWRITE,
						"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
						0xEB, 0x0F, 0xC7, 0x06, 0x88, 0x58, 0x00, 0x00, 0xB0, 0x04,
						0x83, 0xBF, 0xD4, 0x03, 0x02, 0x74, 0x02, 0xB0, 0x02, 0xA2,
						0x2D, 0x3D, 0x90, 0x90, 0x90, 0x90, 0x90);
					WriteCharByChar (iFdEXE, (unsigned char *)sToWrite, 27);
					break;
				case 3: /*** u3 ***/
					break;
				case 5: /*** u4 ***/
					break;
			}
		} else {
			/*** Back to the default. ***/
			switch (iEXEType)
			{
				case 1: /*** u0 ***/
					snprintf (sToWrite, MAX_TOWRITE,
						"%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
						0xEB, 0x06, 0xC7, 0x06, 0x88, 0x58, 0x00, 0x00, 0x83, 0x3E,
						0x9E, 0x0F, 0x03, 0x75, 0x07, 0xC6, 0x06, 0x2D, 0x3D, 0x04,
						0xEB, 0x05, 0xC6, 0x06, 0x2D, 0x3D, 0x02);
					WriteCharByChar (iFdEXE, (unsigned char *)sToWrite, 27);
					break;
				case 3: /*** u3 ***/
					break;
				case 5: /*** u4 ***/
					break;
			}
		}
	}

	/*** Guard hit points per game level. ***/
	LSeek (iFdEXE, arGuardHit[iEXEType]);
	snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",
		iEXEGuard[0], iEXEGuard[1], iEXEGuard[2], iEXEGuard[3],
		iEXEGuard[4], iEXEGuard[5], iEXEGuard[6], iEXEGuard[7],
		iEXEGuard[8], iEXEGuard[9], iEXEGuard[10], iEXEGuard[11],
		iEXEGuard[12], iEXEGuard[13], iEXEGuard[14], iEXEGuard[15]);
	WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 16);

	/*** Edit guard details. ***/
	for (iTab = 1; iTab <= 7; iTab++)
	{
		if ((iEXEPacked != 1) || ((iTab != 6) && (iTab != 7)))
		{
			LSeek (iFdEXE, arGuardDetails[iTab - 1][iEXEType]);
			for (iType = 1; iType <= 12; iType++)
			{
				SSLittleEndianToHexToInts (iEXEGuardD[iTab][iType], &iOut1, &iOut2);
				snprintf (sToWrite, MAX_TOWRITE, "%c%c", iOut2, iOut1);
				WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 2);
			}
		}
	}

	close (iFdEXE);

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F3_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sBytes[8 + 2];

	/*** Used for looping. ***/
	int iLoopMoves;

	iFdEXE = open (POP1_EXECUTABLE, O_RDWR|O_BINARY);

	/*** Loose floor delay. ***/
	LSeek (iFdEXE, arLooseDelayA[iEXEType]);
	sBytes[0] = iEXELooseDelayA;
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, arLooseDelayB[iEXEType]);
	sBytes[0] = (iEXELooseDelayB >> 0) & 0xFF;
	sBytes[1] = (iEXELooseDelayB >> 8) & 0xFF;
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Allow loose floor climbing. ***/
	LSeek (iFdEXE, arLooseClimbing[iEXEType]);
	if (iEXELooseClimbing == 0)
		{ sBytes[0] = 0x75; sBytes[1] = 0xD3; }
			else { sBytes[0] = 0x90; sBytes[1] = 0x90; }
	WriteCharByChar (iFdEXE, sBytes, 2);

	/*** Shadow start. ***/
	LSeek (iFdEXE, arShadowStart[iEXEType]);
	sBytes[0] = iEXEShadowStartF6; /*** Yes, 6 before 5. ***/
	sBytes[1] = iEXEShadowStartX6;
	sBytes[2] = iEXEShadowStartY6;
	sBytes[3] = iEXEShadowStartD6;
	sBytes[4] = iEXEShadowStartC6;
	sBytes[5] = iEXEShadowStartR6;
	sBytes[6] = iEXEShadowStartA6;
	sBytes[7] = iEXEShadowStartN6;
	WriteCharByChar (iFdEXE, sBytes, 8);
	sBytes[0] = iEXEShadowStartF5;
	sBytes[1] = iEXEShadowStartX5;
	sBytes[2] = iEXEShadowStartY5;
	sBytes[3] = iEXEShadowStartD5;
	sBytes[4] = iEXEShadowStartC5;
	sBytes[5] = iEXEShadowStartR5;
	sBytes[6] = iEXEShadowStartA5;
	sBytes[7] = iEXEShadowStartN5;
	WriteCharByChar (iFdEXE, sBytes, 8);
	sBytes[0] = iEXEShadowStartF12;
	sBytes[1] = iEXEShadowStartX12;
	sBytes[2] = iEXEShadowStartY12;
	sBytes[3] = iEXEShadowStartD12;
	sBytes[4] = iEXEShadowStartC12;
	sBytes[5] = iEXEShadowStartR12;
	sBytes[6] = iEXEShadowStartA12;
	sBytes[7] = iEXEShadowStartN12;
	WriteCharByChar (iFdEXE, sBytes, 8);

	/*** Shadow moves. ***/
	LSeek (iFdEXE, arShadowMoves[iEXEType]);
	for (iLoopMoves = 1; iLoopMoves <= 7; iLoopMoves++)
	{
		sBytes[0] = (iEXEShadowMovesTime[iLoopMoves] >> 0) & 0xFF;
		sBytes[1] = (iEXEShadowMovesTime[iLoopMoves] >> 8) & 0xFF;
		WriteCharByChar (iFdEXE, sBytes, 2);
		sBytes[0] = (iEXEShadowMovesAction[iLoopMoves] >> 0) & 0xFF;
		sBytes[1] = (iEXEShadowMovesAction[iLoopMoves] >> 8) & 0xFF;
		WriteCharByChar (iFdEXE, sBytes, 2);
	}

	/*** Prince moves. ***/
	LSeek (iFdEXE, arPrinceMoves[iEXEType]);
	for (iLoopMoves = 1; iLoopMoves <= 24; iLoopMoves++)
	{
		sBytes[0] = (iEXEPrinceMovesTime[iLoopMoves] >> 0) & 0xFF;
		sBytes[1] = (iEXEPrinceMovesTime[iLoopMoves] >> 8) & 0xFF;
		WriteCharByChar (iFdEXE, sBytes, 2);
		sBytes[0] = (iEXEPrinceMovesAction[iLoopMoves] >> 0) & 0xFF;
		sBytes[1] = (iEXEPrinceMovesAction[iLoopMoves] >> 8) & 0xFF;
		WriteCharByChar (iFdEXE, sBytes, 2);
	}

	close (iFdEXE);

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F4_1 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sBytes[8 + 2];

	iFdEXE = open (POP1_EXECUTABLE, O_RDWR|O_BINARY);

	/*** (Demo level) Playable. ***/
	LSeek (iFdEXE, arDemoPlayableD1[iEXEType]);
	switch (iEXEDemoPlayableD)
	{
		case 0: sBytes[0] = 0x75; break; /*** N ***/
		case 1: sBytes[0] = 0xEB; break; /*** Y ***/
	}
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, arDemoPlayableD2[iEXEType]);
	switch (iEXEDemoPlayableD)
	{
		case 0: /*** N ***/
			switch (iEXEType)
			{
				case 0: case 1:
					sBytes[0] = 0xB8; sBytes[1] = 0x42; sBytes[2] = 0x00; break;
				case 2: case 3:
					sBytes[0] = 0xB2; sBytes[1] = 0x44; sBytes[2] = 0x00; break;
				case 4: case 5:
					sBytes[0] = 0x84; sBytes[1] = 0x42; sBytes[2] = 0x00; break;
			}
			break;
		case 1: /*** Y ***/
			switch (iEXEType)
			{
				case 0: case 1:
					sBytes[0] = 0x9E; sBytes[1] = 0x0F; sBytes[2] = 0xFF; break;
				case 2: case 3:
					sBytes[0] = 0xB0; sBytes[1] = 0x10; sBytes[2] = 0xFF; break;
				case 4: case 5:
					sBytes[0] = 0xAA; sBytes[1] = 0x10; sBytes[2] = 0xFF; break;
			}
			break;
	}
	WriteCharByChar (iFdEXE, sBytes, 3);

	/*** (Demo level) Prince HP. ***/
	LSeek (iFdEXE, arDemoPrinceHP[iEXEType]);
	sBytes[0] = iEXEDemoPrinceHP;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** (Demo level) Ending room. ***/
	LSeek (iFdEXE, arDemoEndingRoom[iEXEType]);
	sBytes[0] = iEXEDemoEndingRoom;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** (Demo level) Prince skill. ***/
	LSeek (iFdEXE, arDemoPrinceSkill[iEXEType]);
	sBytes[0] = iEXEDemoPrinceSkill;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** (Demo level) Guard skill. ***/
	LSeek (iFdEXE, arDemoGuardSkill[iEXEType]);
	sBytes[0] = iEXEDemoGuardSkill;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Disable. ***/
	if (iEXEType == 1)
	{
		switch (iEXEDisable2)
		{
			case 0: sBytes[0] = 0xDC; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable2[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisable4)
		{
			case 0: sBytes[0] = 0xD7; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable4[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisable5)
		{
			case 0: /*** Not disabled. ***/
				sBytes[0] = 0xD8; sBytes[1] = 0x28; sBytes[2] = 0x00;
				sBytes[3] = 0x75; sBytes[4] = 0x07; break;
			case 1: /*** Disabled. ***/
				sBytes[0] = 0x8C; sBytes[1] = 0x28; sBytes[2] = 0x00;
				sBytes[3] = 0x75; sBytes[4] = 0x07; break;
			case 2: /*** Disabled, but allow sheathing. ***/
				sBytes[0] = 0x64; sBytes[1] = 0x43; sBytes[2] = 0x00;
				sBytes[3] = 0x74; sBytes[4] = 0x0C; break;
		}
		LSeek (iFdEXE, arDisable5[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 5);
		/***/
		switch (iEXEDisable6)
		{
			case 0: sBytes[0] = 0xD9; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable6[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisable7)
		{
			case 0: sBytes[0] = 0xD3; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable7A[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		LSeek (iFdEXE, arDisable7B[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisable8)
		{
			case 0: sBytes[0] = 0xD4; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable8[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisable9)
		{
			case 0: sBytes[0] = 0xD5; break;
			case 1: sBytes[0] = 0x8C; break;
		}
		LSeek (iFdEXE, arDisable9A[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		LSeek (iFdEXE, arDisable9B[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
		/***/
		switch (iEXEDisableS)
		{
			case 0: sBytes[0] = 0x03; break;
			case 1: sBytes[0] = 0x00; break;
		}
		LSeek (iFdEXE, arDisableS[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
	}

	/*** Autorun. ***/
	if (iEXEType == 1)
	{
		switch (iEXEAutorun)
		{
			case 0: /*** No autorun. ***/
				sBytes[0] = 0x75; sBytes[1] = 0x07; break;
			case 1: /*** Left. ***/
				sBytes[0] = 0xEB; sBytes[1] = 0x07; break;
			case 2: /*** Right. ***/
				sBytes[0] = 0xEB; sBytes[1] = 0x1C; break;
		}
		LSeek (iFdEXE, arAutorun[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 2);
	}

	/*** Quicker painful falls. ***/
	if (iEXEType == 1)
	{
		switch (iEXEQuicker)
		{
			case 0: sBytes[0] = 0x14; break; /*** N ***/
			case 1: sBytes[0] = 0x11; break; /*** Y ***/
		}
		LSeek (iFdEXE, arQuicker[iEXEType]);
		WriteCharByChar (iFdEXE, sBytes, 1);
	}

	close (iFdEXE);

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F5_1 (void)
/*****************************************************************************/
{
	/*** Nothing for now. ***/

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F2_2 (void)
/*****************************************************************************/
{
	/*** Nothing for now. ***/

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F2_3 (void)
/*****************************************************************************/
{
	int iFdEXE;
	unsigned char sBytes[5 + 2];
	char sToWrite[MAX_TOWRITE + 2];
	int iTab;
	int iType;
	int iIn, iOut1, iOut2;
	int iLevel;

	iFdEXE = open (sSNESFile, O_RDWR|O_BINARY);

	/***************************/
	/* Used on the EXE screen. */
	/***************************/

	/*** Guard settings. ***/
	for (iTab = 1; iTab <= 9; iTab++)
	{
		LSeek (iFdEXE, ulGuardSNES[iTab - 1]);
		for (iType = 1; iType <= 18; iType++)
		{
			if (iTab != 9)
			{
				snprintf (sToWrite, MAX_TOWRITE, "%c", iEXEGuardSNES[iTab][iType]);
				WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 1);
			} else { /*** sprite ***/
				switch (iEXEGuardSNES[iTab][iType])
				{
					case 1: iIn = 244; break; /*** guard ***/
					case 2: iIn = 308; break; /*** skeleton ***/
					case 3: iIn = 936; break; /*** female ***/
					case 4: iIn = 212; break; /*** fat ***/
					case 5: iIn = 276; break; /*** prince ***/
					case 6: iIn = 340; break; /*** knight ***/
					case 7: iIn = 988; break; /*** kali idol ***/
					case 8: iIn = 372; break; /*** jaffar ***/
					default: iIn = 244; break; /*** To prevent warnings. ***/
				}
				SSLittleEndianToHexToInts (iIn, &iOut1, &iOut2);
				snprintf (sToWrite, MAX_TOWRITE, "%c%c", iOut2, iOut1);
				WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 2);
			}
		}
	}

	/*** Music current level. ***/
	LSeek (iFdEXE, ulMusicSNES + (int)luLevelNr - 1);
	switch (iEXEMusicSNESOnOff)
	{
		case 1: sBytes[0] = iEXEMusicSNESValue; break;
		case 0: sBytes[0] = 255; break;
		default:
			printf ("[ WARN ] Invalid iEXEMusicSNESOnOff value: %i!\n",
				iEXEMusicSNESOnOff); sBytes[0] = 1; break; /*** Fallback. ***/
	}
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Heat haze. ***/
	LSeek (iFdEXE, ulHazeSNES);
	switch (iEXEHazeSNESOnOff)
	{
		case 1: sBytes[0] = iEXEHazeSNESValue; break;
		case 0: sBytes[0] = 204; break;
	}
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Starting hit points. ***/
	LSeek (iFdEXE, ulHitSNES);
	sBytes[0] = iEXEHitPoints;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Prince has sword. ***/
	LSeek (iFdEXE, ulSwordSNES);
	switch (iEXESword)
	{
		case -1: /*** D ***/
			sBytes[0] = 0x00; sBytes[1] = 0x80; sBytes[2] = 0x02;
			sBytes[3] = 0xa9; sBytes[4] = 0x01; break;
		case 0: /*** N ***/
			sBytes[0] = 0x00; sBytes[1] = 0x80; sBytes[2] = 0x02;
			sBytes[3] = 0xa9; sBytes[4] = 0x00; break;
		case 1: /*** Y ***/
			sBytes[0] = 0x01; sBytes[1] = 0x80; sBytes[2] = 0x02;
			sBytes[3] = 0xa9; sBytes[4] = 0x01; break;
	}
	WriteCharByChar (iFdEXE, sBytes, 5);

	/*** Intro (level 22) is playable. ***/
	LSeek (iFdEXE, arDemoPlayableS1[iEXEType]);
	switch (iEXEDemoPlayableS)
	{
		case 0: sBytes[0] = 0x15; break; /*** N ***/
		case 1: sBytes[0] = 0xcc; break; /*** Y ***/
	}
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, arDemoPlayableS2[iEXEType]);
	switch (iEXEDemoPlayableS)
	{
		case 0: sBytes[0] = 0x15; break; /*** N ***/
		case 1: sBytes[0] = 0xcc; break; /*** Y ***/
	}
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*** Warp potion. ***/
	LSeek (iFdEXE, ulWarpRoom);
	sBytes[0] = iEXEWarpRoom;
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, ulWarpFace);
	sBytes[0] = iEXEWarpFace;
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, ulWarpCol);
	sBytes[0] = iEXEWarpCol;
	WriteCharByChar (iFdEXE, sBytes, 1);
	LSeek (iFdEXE, ulWarpRow);
	sBytes[0] = iEXEWarpRow;
	WriteCharByChar (iFdEXE, sBytes, 1);

	/*************************************/
	/* Used when switching environments. */
	/*************************************/

	/*** Level type. ***/
	LSeek (iFdEXE, ulEnvL);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		snprintf (sToWrite, MAX_TOWRITE, "%c", iEXEEnvL[iLevel]);
		WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 1);
	}

	/*** Loose, buttons, doors. ***/
	LSeek (iFdEXE, ulEnvO);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		snprintf (sToWrite, MAX_TOWRITE, "%c", iEXEEnvO[iLevel]);
		WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 1);
	}

	/*** Flame addresses. ***/
	LSeek (iFdEXE, ulEnvF);
	for (iLevel = 1; iLevel <= 27; iLevel++)
	{
		SSLittleEndianToHexToInts (iEXEEnvF[iLevel], &iOut1, &iOut2);
		snprintf (sToWrite, MAX_TOWRITE, "%c%c", iOut2, iOut1);
		WriteCharByChar (iFdEXE, (unsigned char*)sToWrite, 2);
	}

	close (iFdEXE);

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXESave_F5_3 (void)
/*****************************************************************************/
{
	int iFdEXE;
	char sToWrite[MAX_TOWRITE + 2];

	iFdEXE = open (sSNESFile, O_RDWR|O_BINARY);

	/*** Skeleton continue for all. ***/
	LSeek (iFdEXE, ulSkelCont);
	switch (iEXESkelCont)
	{
		case 0:
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c",
				0xAD, 0x84, 0x04, 0xC9, 0x04, 0xF0, 0x30, 0xC9, 0x01, 0xF0, 0x1C);
			WriteCharByChar (iFdEXE, (unsigned char *)sToWrite, 11); break;
		case 1:
			snprintf (sToWrite, MAX_TOWRITE, "%c%c%c%c%c%c%c%c%c%c%c",
				0xAD, 0x84, 0x04, 0xC9, 0x01, 0xF0, 0x20, 0xC9, 0x04, 0x80, 0x2C);
			WriteCharByChar (iFdEXE, (unsigned char *)sToWrite, 11); break;
	}

	close (iFdEXE);

	PlaySound ("wav/save.wav");
}
/*****************************************************************************/
void EXECheckbox (int iX, int iY17, int *iChange, int iTo)
/*****************************************************************************/
{
	if ((InArea (iX, 241 + (iY17 * 17), iX + 14, 255 + (iY17 * 17)) == 1) &&
		(*iChange != iTo))
	{
		*iChange = iTo;
		PlaySound ("wav/check_box.wav");
	}
}
/*****************************************************************************/
void EXE (void)
/*****************************************************************************/
{
	int iEXE;
	SDL_Event event;
	int iTemp, iTemp2;
	int iRow, iCol, iUseL, iUseR;
	int iTabMin, iTabMax;
	int iEXEMusicSNESValueOld;

	iEXE = 1;
	iStatusBarFrame = 1;
	snprintf (sStatus, MAX_STATUS, "%s", "");

	switch (iEditPoP)
	{
		case 1: EXELoad_F2_1(); break;
		case 2: EXELoad_F2_2(); break;
		case 3: EXELoad_F2_3(); break;
	}

	PlaySound ("wav/popup.wav");
	ShowEXE();
	while (iEXE == 1)
	{
		if (iNoAnim == 0)
		{
			/*** We use the global REFRESH. No need for newticks/oldticks. ***/
			iStatusBarFrame++;
			if (iStatusBarFrame == 19) { iStatusBarFrame = 1; }
			ShowEXE();
		}

		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							switch (iEditPoP)
							{
								case 1: EXESave_F2_1(); break;
								case 2: EXESave_F2_2(); break;
								case 3: EXESave_F2_3(); break;
							}
							iEXE = 0; break;
					}
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							iEXE = 0; break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
						case SDLK_s:
							switch (iEditPoP)
							{
								case 1: EXESave_F2_1(); break;
								case 2: EXESave_F2_2(); break;
								case 3: EXESave_F2_3(); break;
							}
							iEXE = 0; break;
						default: break;
					}
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if (iEditPoP == 1)
					{
						if ((InArea (608, 35, 656, 51) == 1) || /*** CusPop ***/
							((InArea (445, 296, 445 + 115, 296 + 16) == 1) &&
							(iEXEDetails == 0)) || /*** Edit guard details. ***/
							((InArea (572, 293, 572 + 87, 293 + 16) == 1) &&
							(iEXEDetails == 1))) /*** Edit hit points. ***/
						{
							SDL_SetCursor (curHand);
						} else {
							SDL_SetCursor (curArrow);
						}

						UpdateStatusBar_F2_1();
					}
					if (iEditPoP == 3)
					{
						if (InArea (614, 35, 655, 51) == 1) /*** thread ***/
						{
							SDL_SetCursor (curHand);
						} else {
							SDL_SetCursor (curArrow);
						}

						UpdateStatusBar_F2_3();
					}
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (590, 405, 674, 436) == 1) /*** Save ***/
						{
							if (iEXESave != 1) { iEXESave = 1; }
							ShowEXE();
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iEXESave = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						/*** Save ***/
						if (InArea (590, 405, 674, 436) == 1)
						{
							switch (iEditPoP)
							{
								case 1: EXESave_F2_1(); break;
								case 2: EXESave_F2_2(); break;
								case 3: EXESave_F2_3(); break;
							}
							iEXE = 0;
						}

						if (iEditPoP == 1)
						{
							/*** CusPop ***/
							if (InArea (608, 35, 656, 51) == 1)
							{
								OpenURL (URL_CUSPOP);
							}

							/*** Starting minutes left. ***/
							PlusMinus (&iEXEMinutesLeft, 219, 76 + (0 * 24), 0, 999, -10, 0);
							PlusMinus (&iEXEMinutesLeft, 234, 76 + (0 * 24), 0, 999, -1, 0);
							PlusMinus (&iEXEMinutesLeft, 304, 76 + (0 * 24), 0, 999, +1, 0);
							PlusMinus (&iEXEMinutesLeft, 319, 76 + (0 * 24), 0, 999, +10, 0);

							/*** Starting hit points. ***/
							PlusMinus (&iEXEHitPoints, 219, 76 + (1 * 24), 0, 999, -10, 0);
							PlusMinus (&iEXEHitPoints, 234, 76 + (1 * 24), 0, 999, -1, 0);
							PlusMinus (&iEXEHitPoints, 304, 76 + (1 * 24), 0, 999, +1, 0);
							PlusMinus (&iEXEHitPoints, 319, 76 + (1 * 24), 0, 999, +10, 0);

							/*** Allow triggering of any tile. ***/
							if ((InArea (261, 129, 275, 143) == 1) && (iEXETriggering == 1))
								{ iEXETriggering = 0; PlaySound ("wav/check_box.wav"); }
							if ((InArea (276, 129, 290, 143) == 1) && (iEXETriggering == 0))
								{ iEXETriggering = 1; PlaySound ("wav/check_box.wav"); }

							/*** Prince has sword (PoP1 for DOS). ***/
							if ((InArea (253, 153, 267, 167) == 1) && (iEXESword != -1))
								{ iEXESword = -1; PlaySound ("wav/check_box.wav"); }
							if ((InArea (268, 153, 282, 167) == 1) && (iEXESword != 0))
								{ iEXESword = 0; PlaySound ("wav/check_box.wav"); }
							if ((InArea (283, 153, 297, 167) == 1) && (iEXESword != 1))
								{ iEXESword = 1; PlaySound ("wav/check_box.wav"); }

							/*** Win. ***/
							/*** level ***/
							PlusMinus (&iEXEWinLevel, 81, 176, 1, 14, -1, 0);
							PlusMinus (&iEXEWinLevel, 151, 176, 1, 14, +1, 0);
							/*** room ***/
							PlusMinus (&iEXEWinRoom, 219, 176, 1, 24, -10, 0);
							PlusMinus (&iEXEWinRoom, 234, 176, 1, 24, -1, 0);
							PlusMinus (&iEXEWinRoom, 304, 176, 1, 24, +1, 0);
							PlusMinus (&iEXEWinRoom, 319, 176, 1, 24, +10, 0);

							/*** Base speed. ***/
							PlusMinus (&iEXEBaseSpeed, 415, 331, 0, 10, -1, 0);
							PlusMinus (&iEXEBaseSpeed, 485, 331, 0, 10, +1, 0);

							/*** Fight speed. ***/
							PlusMinus (&iEXEFightSpeed, 415, 355, 0, 15, -1, 0);
							PlusMinus (&iEXEFightSpeed, 485, 355, 0, 15, +1, 0);

							/*** Chomper speed. ***/
							PlusMinus (&iEXEChomperSpeed, 576, 331, 6, 127, -1, 0);
							PlusMinus (&iEXEChomperSpeed, 646, 331, 6, 127, +1, 0);

							/*** (environments and enemy resources) ***/
							for (iTemp = 0; iTemp <= 7; iTemp++) /*** 1-8 ***/
							{
								iTemp2 = iTemp + 1;
								EXECheckbox (35, iTemp, &iEXEEnv[iTemp2], 0); /*** D ***/
								EXECheckbox (50, iTemp, &iEXEEnv[iTemp2], 1); /*** P ***/
								if (iEXEPacked == 0)
								{
									EXECheckbox (69, iTemp, &iEXEGRes[iTemp2], 0); /*** G ***/
									EXECheckbox (84, iTemp, &iEXEGRes[iTemp2], 1); /*** F ***/
									EXECheckbox (99, iTemp, &iEXEGRes[iTemp2], 2); /*** S ***/
									EXECheckbox (114, iTemp, &iEXEGRes[iTemp2], 3); /*** J ***/
									EXECheckbox (129, iTemp, &iEXEGRes[iTemp2], 4); /*** M ***/
									EXECheckbox (144, iTemp,
										&iEXEGRes[iTemp2], 65535); /*** N ***/
								}
							}
							for (iTemp = 0; iTemp <= 7; iTemp++) /*** 9-15 and 0 ***/
							{
								iTemp2 = iTemp + 9;
								if (iTemp2 == 16) { iTemp2 = 0; }
								EXECheckbox (208, iTemp, &iEXEEnv[iTemp2], 0); /*** D ***/
								EXECheckbox (223, iTemp, &iEXEEnv[iTemp2], 1); /*** P ***/
								if (iEXEPacked == 0)
								{
									EXECheckbox (242, iTemp, &iEXEGRes[iTemp2], 0); /*** G ***/
									EXECheckbox (257, iTemp, &iEXEGRes[iTemp2], 1); /*** F ***/
									EXECheckbox (272, iTemp, &iEXEGRes[iTemp2], 2); /*** S ***/
									EXECheckbox (287, iTemp, &iEXEGRes[iTemp2], 3); /*** J ***/
									EXECheckbox (302, iTemp, &iEXEGRes[iTemp2], 4); /*** M ***/
									EXECheckbox (317, iTemp,
										&iEXEGRes[iTemp2], 65535); /*** N ***/
								}
							}

							if (iEXEDetails == 0)
							{
								/*** Edit guard details. ***/
								if (InArea (445, 296, 445 + 115, 296 + 16) == 1)
								{
									iEXEDetails = 1;
								}

								/*** Guard hit points per game level. ***/
								/*** 1 ***/
								PlusMinus (&iEXEGuard[1], 361, 76 + (0 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[1], 376, 76 + (0 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[1], 446, 76 + (0 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[1], 461, 76 + (0 * 24), 0, 255, +10, 0);
								/*** 2 ***/
								PlusMinus (&iEXEGuard[2], 361, 76 + (1 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[2], 376, 76 + (1 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[2], 446, 76 + (1 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[2], 461, 76 + (1 * 24), 0, 255, +10, 0);
								/*** 3 ***/
								PlusMinus (&iEXEGuard[3], 361, 76 + (2 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[3], 376, 76 + (2 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[3], 446, 76 + (2 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[3], 461, 76 + (2 * 24), 0, 255, +10, 0);
								/*** 4 ***/
								PlusMinus (&iEXEGuard[4], 361, 76 + (3 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[4], 376, 76 + (3 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[4], 446, 76 + (3 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[4], 461, 76 + (3 * 24), 0, 255, +10, 0);
								/*** 5 ***/
								PlusMinus (&iEXEGuard[5], 361, 76 + (4 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[5], 376, 76 + (4 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[5], 446, 76 + (4 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[5], 461, 76 + (4 * 24), 0, 255, +10, 0);
								/*** 6 ***/
								PlusMinus (&iEXEGuard[6], 361, 76 + (5 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[6], 376, 76 + (5 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[6], 446, 76 + (5 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[6], 461, 76 + (5 * 24), 0, 255, +10, 0);
								/*** 7 ***/
								PlusMinus (&iEXEGuard[7], 361, 76 + (6 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[7], 376, 76 + (6 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[7], 446, 76 + (6 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[7], 461, 76 + (6 * 24), 0, 255, +10, 0);
								/*** 8 ***/
								PlusMinus (&iEXEGuard[8], 361, 76 + (7 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[8], 376, 76 + (7 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[8], 446, 76 + (7 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[8], 461, 76 + (7 * 24), 0, 255, +10, 0);
								/*** 9 ***/
								PlusMinus (&iEXEGuard[9], 546, 76 + (0 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[9], 561, 76 + (0 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[9], 631, 76 + (0 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[9], 646, 76 + (0 * 24), 0, 255, +10, 0);
								/*** 10 ***/
								PlusMinus (&iEXEGuard[10], 546, 76 + (1 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[10], 561, 76 + (1 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[10], 631, 76 + (1 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[10], 646, 76 + (1 * 24), 0, 255, +10, 0);
								/*** 11 ***/
								PlusMinus (&iEXEGuard[11], 546, 76 + (2 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[11], 561, 76 + (2 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[11], 631, 76 + (2 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[11], 646, 76 + (2 * 24), 0, 255, +10, 0);
								/*** 12a ***/
								PlusMinus (&iEXEGuard[12], 546, 76 + (3 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[12], 561, 76 + (3 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[12], 631, 76 + (3 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[12], 646, 76 + (3 * 24), 0, 255, +10, 0);
								/*** 12b ***/
								PlusMinus (&iEXEGuard[13], 546, 76 + (4 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[13], 561, 76 + (4 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[13], 631, 76 + (4 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[13], 646, 76 + (4 * 24), 0, 255, +10, 0);
								/*** prncss ***/
								PlusMinus (&iEXEGuard[14], 546, 76 + (5 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[14], 561, 76 + (5 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[14], 631, 76 + (5 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[14], 646, 76 + (5 * 24), 0, 255, +10, 0);
								/*** potions ***/
								PlusMinus (&iEXEGuard[15], 546, 76 + (6 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[15], 561, 76 + (6 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[15], 631, 76 + (6 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[15], 646, 76 + (6 * 24), 0, 255, +10, 0);
								/*** demo ***/
								PlusMinus (&iEXEGuard[0], 546, 76 + (7 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuard[0], 561, 76 + (7 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuard[0], 631, 76 + (7 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuard[0], 646, 76 + (7 * 24), 0, 255, +10, 0);
							} else {
								/*** Edit hit points. ***/
								if (InArea (572, 293, 572 + 87, 293 + 16) == 1)
								{
									iEXEDetails = 0;
								}

								/*** strike prob. ***/
								if ((InArea (361, 236, 454, 254) == 1) && (iEXETab != 1))
									{ iEXETab = 1; PlaySound ("wav/extras.wav"); }
								/*** re-strike prob. ***/
								if ((InArea (463, 236, 556, 254) == 1) && (iEXETab != 2))
									{ iEXETab = 2; PlaySound ("wav/extras.wav"); }
								/*** block prob. ***/
								if ((InArea (565, 236, 658, 254) == 1) && (iEXETab != 3))
									{ iEXETab = 3; PlaySound ("wav/extras.wav"); }
								/*** imp. block prob. ***/
								if ((InArea (361, 263, 454, 281) == 1) && (iEXETab != 4))
									{ iEXETab = 4; PlaySound ("wav/extras.wav"); }
								/*** advance prob. ***/
								if ((InArea (463, 263, 556, 281) == 1) && (iEXETab != 5))
									{ iEXETab = 5; PlaySound ("wav/extras.wav"); }
								/*** refractory timer ***/
								if ((InArea (565, 263, 658, 281) == 1) && (iEXETab != 6) &&
									(iEXEPacked == 0))
									{ iEXETab = 6; PlaySound ("wav/extras.wav"); }
								/*** extra hit points ***/
								if ((InArea (361, 290, 454, 308) == 1) && (iEXETab != 7) &&
									(iEXEPacked == 0))
									{ iEXETab = 7; PlaySound ("wav/extras.wav"); }

								/*** guard: 0 ***/
								PlusMinus (&iEXEGuardD[iEXETab][1],
									361, 76 + (0 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][1],
									376, 76 + (0 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][1],
									446, 76 + (0 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][1],
									461, 76 + (0 * 24), 0, 255, +10, 0);
								/*** guard: 1 ***/
								PlusMinus (&iEXEGuardD[iEXETab][2],
									361, 76 + (1 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][2],
									376, 76 + (1 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][2],
									446, 76 + (1 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][2],
									461, 76 + (1 * 24), 0, 255, +10, 0);
								/*** guard: 2 ***/
								PlusMinus (&iEXEGuardD[iEXETab][3],
									361, 76 + (2 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][3],
									376, 76 + (2 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][3],
									446, 76 + (2 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][3],
									461, 76 + (2 * 24), 0, 255, +10, 0);
								/*** guard: 3 ***/
								PlusMinus (&iEXEGuardD[iEXETab][4],
									361, 76 + (3 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][4],
									376, 76 + (3 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][4],
									446, 76 + (3 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][4],
									461, 76 + (3 * 24), 0, 255, +10, 0);
								/*** guard: 4 ***/
								PlusMinus (&iEXEGuardD[iEXETab][5],
									361, 76 + (4 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][5],
									376, 76 + (4 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][5],
									446, 76 + (4 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][5],
									461, 76 + (4 * 24), 0, 255, +10, 0);
								/*** guard: 5 ***/
								PlusMinus (&iEXEGuardD[iEXETab][6],
									361, 76 + (5 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][6],
									376, 76 + (5 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][6],
									446, 76 + (5 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][6],
									461, 76 + (5 * 24), 0, 255, +10, 0);
								/*** guard: 6 ***/
								PlusMinus (&iEXEGuardD[iEXETab][7],
									546, 76 + (0 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][7],
									561, 76 + (0 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][7],
									631, 76 + (0 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][7],
									646, 76 + (0 * 24), 0, 255, +10, 0);
								/*** guard: 7 ***/
								PlusMinus (&iEXEGuardD[iEXETab][8],
									546, 76 + (1 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][8],
									561, 76 + (1 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][8],
									631, 76 + (1 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][8],
									646, 76 + (1 * 24), 0, 255, +10, 0);
								/*** guard: 8 ***/
								PlusMinus (&iEXEGuardD[iEXETab][9],
									546, 76 + (2 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][9],
									561, 76 + (2 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][9],
									631, 76 + (2 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][9],
									646, 76 + (2 * 24), 0, 255, +10, 0);
								/*** guard: 9 ***/
								PlusMinus (&iEXEGuardD[iEXETab][10],
									546, 76 + (3 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][10],
									561, 76 + (3 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][10],
									631, 76 + (3 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][10],
									646, 76 + (3 * 24), 0, 255, +10, 0);
								/*** guard: a ***/
								PlusMinus (&iEXEGuardD[iEXETab][11],
									546, 76 + (4 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][11],
									561, 76 + (4 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][11],
									631, 76 + (4 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][11],
									646, 76 + (4 * 24), 0, 255, +10, 0);
								/*** guard: b ***/
								PlusMinus (&iEXEGuardD[iEXETab][12],
									546, 76 + (5 * 24), 0, 255, -10, 0);
								PlusMinus (&iEXEGuardD[iEXETab][12],
									561, 76 + (5 * 24), 0, 255, -1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][12],
									631, 76 + (5 * 24), 0, 255, +1, 0);
								PlusMinus (&iEXEGuardD[iEXETab][12],
									646, 76 + (5 * 24), 0, 255, +10, 0);
							}
						}

						if (iEditPoP == 2)
						{
							/*** Current level type. ***/
							if ((InArea (35, 99, 35 + 14, 99 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x01)) /*** desert ***/
							{
								iEXEEnvPoP2 = 0x01; cCurType = 'o';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (35, 120, 35 + 14, 120 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x02)) /*** temple ***/
							{
								iEXEEnvPoP2 = 0x02; cCurType = 't';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (35, 141, 35 + 14, 141 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x03)) /*** caverns ***/
							{
								iEXEEnvPoP2 = 0x03; cCurType = 'c';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (35, 162, 35 + 14, 162 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x04)) /*** ruins ***/
							{
								iEXEEnvPoP2 = 0x04; cCurType = 'r';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (35, 183, 35 + 14, 183 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x05)) /*** rooftops ***/
							{
								iEXEEnvPoP2 = 0x05; cCurType = 'o';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (35, 204, 35 + 14, 204 + 14) == 1) &&
								(iEXEEnvPoP2 != 0x06)) /*** final ***/
							{
								iEXEEnvPoP2 = 0x06; cCurType = 'o';
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}

							/*** Current level guards. ***/
							if ((InArea (164, 99, 164 + 14, 99 + 14) == 1) &&
								(iEXEGuardTypePoP2 != 0x00)) /*** guards, sword ***/
							{
								iEXEGuardTypePoP2 = 0x00;
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (164, 120, 164 + 14, 120 + 14) == 1) &&
								(iEXEGuardTypePoP2 != 0x02)) /*** skeletons, sword ***/
							{
								iEXEGuardTypePoP2 = 0x02;
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (164, 141, 164 + 14, 141 + 14) == 1) &&
								(iEXEGuardTypePoP2 != 0x05)) /*** heads, snake ***/
							{
								iEXEGuardTypePoP2 = 0x05;
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (164, 162, 164 + 14, 162 + 14) == 1) &&
								(iEXEGuardTypePoP2 != 0x07)) /*** birdman, sword ***/
							{
								iEXEGuardTypePoP2 = 0x07;
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
							if ((InArea (164, 183, 164 + 14, 183 + 14) == 1) &&
								(iEXEGuardTypePoP2 != 0xff)) /*** sword ***/
							{
								iEXEGuardTypePoP2 = 0xff;
								PlaySound ("wav/check_box.wav");
								iChanged++;
							}
						}

						if (iEditPoP == 3)
						{
							/*** thread ***/
							if (InArea (614, 35, 655, 51) == 1)
							{
								OpenURL (URL_THREAD);
							}

							/*** strike prob. ***/
							if ((InArea (361, 302, 455, 321) == 1) && (iEXETab != 1))
								{ iEXETab = 1; PlaySound ("wav/extras.wav"); }
							/*** re-strike prob. ***/
							if ((InArea (463, 302, 557, 321) == 1) && (iEXETab != 2))
								{ iEXETab = 2; PlaySound ("wav/extras.wav"); }
							/*** block prob. ***/
							if ((InArea (565, 302, 659, 321) == 1) && (iEXETab != 3))
								{ iEXETab = 3; PlaySound ("wav/extras.wav"); }
							/*** imp. block prob. ***/
							if ((InArea (361, 329, 455, 348) == 1) && (iEXETab != 4))
								{ iEXETab = 4; PlaySound ("wav/extras.wav"); }
							/*** advance prob. ***/
							if ((InArea (463, 329, 557, 348) == 1) && (iEXETab != 5))
								{ iEXETab = 5; PlaySound ("wav/extras.wav"); }
							/*** refractory timer ***/
							if ((InArea (565, 329, 659, 348) == 1) && (iEXETab != 6))
								{ iEXETab = 6; PlaySound ("wav/extras.wav"); }
							/*** hit points ***/
							if ((InArea (361, 356, 455, 375) == 1) && (iEXETab != 7))
								{ iEXETab = 7; PlaySound ("wav/extras.wav"); }
							/*** palette ***/
							if ((InArea (463, 356, 557, 375) == 1) && (iEXETab != 8))
								{ iEXETab = 8; PlaySound ("wav/extras.wav"); }
							/*** sprite ***/
							if ((InArea (565, 356, 659, 375) == 1) && (iEXETab != 9))
								{ iEXETab = 9; PlaySound ("wav/extras.wav"); }

							/*** Guard settings. ***/
							for (iRow = 1; iRow <= 9; iRow++)
							{
								if ((iEXETab != 7) || (iRow != 1))
								{
									iUseL = iRow * 2;
									iUseR = iUseL + 1;
									if (iUseR == 19) { iUseR = 1; }
									if (iEXETab != 9)
										{ iTabMin = 0; iTabMax = 255; }
											else { iTabMin = 1; iTabMax = 8; }

									PlusMinus (&iEXEGuardSNES[iEXETab][iUseL], 390,
										52 + (iRow * 24), iTabMin, iTabMax, -10, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseL], 405,
										52 + (iRow * 24), iTabMin, iTabMax, -1, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseL], 475,
										52 + (iRow * 24), iTabMin, iTabMax, +1, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseL], 490,
										52 + (iRow * 24), iTabMin, iTabMax, +10, 0);

									PlusMinus (&iEXEGuardSNES[iEXETab][iUseR], 546,
										52 + (iRow * 24), iTabMin, iTabMax, -10, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseR], 561,
										52 + (iRow * 24), iTabMin, iTabMax, -1, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseR], 631,
										52 + (iRow * 24), iTabMin, iTabMax, +1, 0);
									PlusMinus (&iEXEGuardSNES[iEXETab][iUseR], 646,
										52 + (iRow * 24), iTabMin, iTabMax, +10, 0);
								}
							}

							/*** Music current level. ***/
							if (iEXEMusicSNESOnOff == 1)
							{
								iEXEMusicSNESValueOld = iEXEMusicSNESValue;
								PlusMinus (&iEXEMusicSNESValue, 219, 76, 0, 255, -10, 0);
								PlusMinus (&iEXEMusicSNESValue, 234, 76, 0, 255, -1, 0);
								PlusMinus (&iEXEMusicSNESValue, 304, 76, 0, 255, +1, 0);
								PlusMinus (&iEXEMusicSNESValue, 319, 76, 0, 255, +10, 0);
								if (iEXEMusicSNESValue != iEXEMusicSNESValueOld)
									{ UpdateStatusBar_F2_3(); }
							}
							if (InArea (196, 79, 210, 93) == 1) /*** on ***/
							{
								if (iEXEMusicSNESOnOff != 1)
								{
									iEXEMusicSNESOnOff = 1;
									UpdateStatusBar_F2_3();
									PlaySound ("wav/check_box.wav");
								}
							}
							if (InArea (196, 103, 210, 117) == 1) /*** off ***/
							{
								if (iEXEMusicSNESOnOff != 0)
								{
									iEXEMusicSNESOnOff = 0;
									UpdateStatusBar_F2_3();
									PlaySound ("wav/check_box.wav");
								}
							}

							/*** Heat haze. ***/
							if (iEXEHazeSNESOnOff == 1)
							{
								PlusMinus (&iEXEHazeSNESValue, 219, 147, 0, 26, -10, 0);
								PlusMinus (&iEXEHazeSNESValue, 234, 147, 0, 26, -1, 0);
								PlusMinus (&iEXEHazeSNESValue, 304, 147, 0, 26, +1, 0);
								PlusMinus (&iEXEHazeSNESValue, 319, 147, 0, 26, +10, 0);
							}
							if (InArea (196, 150, 210, 164) == 1) /*** on ***/
							{
								if (iEXEHazeSNESOnOff != 1)
								{
									iEXEHazeSNESOnOff = 1;
									PlaySound ("wav/check_box.wav");
								}
							}
							if (InArea (196, 174, 210, 188) == 1) /*** off ***/
							{
								if (iEXEHazeSNESOnOff != 0)
								{
									iEXEHazeSNESOnOff = 0;
									PlaySound ("wav/check_box.wav");
								}
							}

							/*** Starting hit points (PoP1 for SNES). ***/
							PlusMinus (&iEXEHitPoints, 219, 218, 0, 255, -10, 0);
							PlusMinus (&iEXEHitPoints, 234, 218, 0, 255, -1, 0);
							PlusMinus (&iEXEHitPoints, 304, 218, 0, 255, +1, 0);
							PlusMinus (&iEXEHitPoints, 319, 218, 0, 255, +10, 0);

							/*** Prince has sword (PoP1 for SNES). ***/
							if ((InArea (253, 247, 267, 261) == 1) && (iEXESword != -1))
								{ iEXESword = -1; PlaySound ("wav/check_box.wav"); }
							if ((InArea (268, 247, 282, 261) == 1) && (iEXESword != 0))
								{ iEXESword = 0; PlaySound ("wav/check_box.wav"); }
							if ((InArea (283, 247, 297, 261) == 1) && (iEXESword != 1))
								{ iEXESword = 1; PlaySound ("wav/check_box.wav"); }

							/*** Intro (level 22) is playable. ***/
							if ((InArea (261, 271, 275, 285) == 1) &&
								(iEXEDemoPlayableS != 0))
								{ iEXEDemoPlayableS = 0; PlaySound ("wav/check_box.wav"); }
							if ((InArea (276, 271, 290, 285) == 1) &&
								(iEXEDemoPlayableS != 1))
								{ iEXEDemoPlayableS = 1; PlaySound ("wav/check_box.wav"); }

							/*** Warp potion. ***/
							PlusMinus (&iEXEWarpRoom, 84, 355, 0, 23, -1, 0);
							PlusMinus (&iEXEWarpRoom, 154, 355, 0, 23, +1, 0);
							if ((InArea (111, 336, 125, 350) == 1) && (iEXEWarpFace != 0xff))
								{ iEXEWarpFace = 0xff; PlaySound ("wav/check_box.wav"); }
							if ((InArea (126, 336, 140, 350) == 1) && (iEXEWarpFace != 0x00))
								{ iEXEWarpFace = 0x00; PlaySound ("wav/check_box.wav"); }
							for (iRow = 0; iRow <= 2; iRow++)
							{
								for (iCol = 0; iCol <= 9; iCol++)
								{
									if (InArea (182 + (iCol * 15), 330 + (iRow * 15),
										182 + (iCol * 15) + 14, 330 + (iRow * 15) + 14) == 1)
									{
										if ((iEXEWarpCol != iCol) || (iEXEWarpRow != iRow))
										{
											iEXEWarpCol = iCol; iEXEWarpRow = iRow;
											PlaySound ("wav/check_box.wav");
										}
									}
								}
							}
						}
					}
					ShowEXE(); break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowEXE(); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/popup_close.wav");
	SDL_SetCursor (curArrow);
	ShowScreen (iScreen, ascreen);
}
/*****************************************************************************/
void ShowEXE (void)
/*****************************************************************************/
{
	char arText[9 + 2][MAX_TEXT + 2];
	SDL_Color clr;
	SDL_Color clrs[18 + 2];
	int iTemp;
	int iLeft, iRight;
	int iColor[18 + 2];
	int iX, iY;
	int iC;

	/*** exe ***/
	ShowImage (-9, (int[]){11, 0, 0, 0}, ascreen, 31, 0, 0, 692, 455);

	/*** Edit guard details. ***/
	if ((iEditPoP == 1) && (iEXEDetails == 1))
	{
		ShowImageBasic (imgexedetails, 361, 76,
			"imgexedetails", ascreen, iScale, 1);

		/*** guard tab ***/
		switch (iEXETab)
		{
			case 1: iX = 361; iY = 236; break; /*** strike prob. ***/
			case 2: iX = 463; iY = 236; break; /*** re-strike prob. ***/
			case 3: iX = 565; iY = 236; break; /*** block prob. ***/
			case 4: iX = 361; iY = 263; break; /*** imp. block prob. ***/
			case 5: iX = 463; iY = 263; break; /*** advance prob. ***/
			case 6: iX = 565; iY = 263; break; /*** refractory timer ***/
			case 7: iX = 361; iY = 290; break; /*** extra hit points ***/
			default:
				iEXETab = 1; iX = 361; iY = 236; break; /*** Fallback. ***/
		}
		ShowImageBasic (imgexetab, iX, iY, "imgexetab", ascreen, iScale, 1);
	}

	/*** packed ***/
	if ((iEditPoP == 1) && (iEXEPacked != 0))
	{
		ShowImage (-9, (int[]){14, 0, 0, 0}, ascreen, 143, 0, 0, 264, 135);
		if (iEXEDetails == 1)
		{
			ShowImageBasic (imgexepacked2, 361, 263,
				"imgexepacked2", ascreen, iScale, 1);
		}
	}

	if (iEditPoP == 3)
	{
		/*** music ***/
		if (iEXEMusicSNESOnOff == 1)
		{ /*** on ***/
			ShowImage (-9, (int[]){15, 0, 0, 0}, ascreen, 187, 0, 0, 137, 42);
		} else { /*** off ***/
			ShowImage (-9, (int[]){16, 0, 0, 0}, ascreen, 187, 0, 0, 137, 42);
		}

		/*** haze ***/
		if (iEXEHazeSNESOnOff == 1)
		{ /*** on ***/
			ShowImage (-9, (int[]){17, 0, 0, 0}, ascreen, 193, 0, 0, 137, 42);
		} else { /*** off ***/
			ShowImage (-9, (int[]){18, 0, 0, 0}, ascreen, 193, 0, 0, 137, 42);
		}

		/*** unchangeable skeletons ***/
		if (iEXETab == 7)
		{
			ShowImage (-9, (int[]){23, 0, 0, 0}, ascreen, 205, 0, 0, 298, 20);
		}

		/*** guard tab ***/
		ShowImage (-9, (int[]){24, 0, 0, 0}, ascreen, 206, 0, 0, 94, 19);
	}

	/*** status bar ***/
	if (strcmp (sStatus, "") != 0)
	{
		/*** bulb ***/
		ShowImage (-9, (int[]){25, 0, 0, 0}, ascreen, 209, 0, 0, 20, 20);
		/*** text ***/
		DisplayTextLine (50, 415, sStatus, font2, color_bl, color_f4, 0);
	}

	/*** save ***/
	switch (iEXESave)
	{
		case 0:
			/*** Save off ***/
			ShowImage (-9, (int[]){12, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
		case 1:
			/*** Save on ***/
			ShowImage (-9, (int[]){13, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
	}

	/*** type text ***/
	snprintf (arText[0], MAX_TEXT, "Executable type is: %s (%i)",
		sEXEType, iEXEType);
	DisplayText (33, 32, FONT_SIZE_15, arText, 1, font1);

	if (iEditPoP == 1)
	{
		/*** Starting minutes left. ***/
		if (iEXEMinutesLeft == 60) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEMinutesLeft, 247, 76, clr, color_wh, 0);

		/*** Starting hit points. ***/
		if (iEXEHitPoints == 3) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEHitPoints, 247, 100, clr, color_wh, 0);

		/*** Allow triggering of any tile. ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 139, 0, 0, 14, 14);
		if (iEXETriggering == 1)
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 139, 0, 0, 14, 14); }

		/*** Prince has sword (PoP1 for DOS). ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 140, 0, 0, 14, 14);
		if (iEXESword != -1)
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 140, 0, 0, 14, 14); }

		/*** Win. ***/
		if (iEXEWinLevel == 14) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEWinLevel, 94, 176, clr, color_wh, 0);
		if (iEXEWinRoom == 5) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEWinRoom, 247, 176, clr, color_wh, 0);

		/*** Base speed. ***/
		if (iEXEBaseSpeed == 5) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEBaseSpeed, 428, 331, clr, color_wh, 0);

		/*** Fight speed. ***/
		if (iEXEFightSpeed == 6) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEFightSpeed, 428, 355, clr, color_wh, 0);

		/*** Chomper speed. ***/
		if (iEXEChomperSpeed == 15) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEChomperSpeed, 589, 331, clr, color_wh, 0);

		/*** (environments and enemy resources) ***/
		for (iTemp = 0; iTemp <= 15; iTemp++)
		{
			ShowImage (-12, (int[]){12, iEXEEnv[iTemp], iTemp, 0},
				ascreen, 141, 0, 0, 14, 14);
			if (iEXEEnv[iTemp] != arDefaultEnv[iTemp])
			{
				ShowImage (-7, (int[]){1, iEXEEnv[iTemp], iTemp, 0},
					ascreen, 141, 0, 0, 14, 14);
			}
		}
		if (iEXEPacked == 0)
		{
			for (iTemp = 0; iTemp <= 15; iTemp++)
			{
				ShowImage (-12, (int[]){12, iEXEGRes[iTemp], iTemp, 0},
					ascreen, 142, 0, 0, 14, 14);
				if (iEXEGRes[iTemp] != arDefaultGRes[iTemp])
				{
					ShowImage (-7, (int[]){1, iEXEGRes[iTemp], iTemp, 0},
						ascreen, 142, 0, 0, 14, 14);
				}
			}
		}

		if (iEXEDetails == 0)
		{
			/*** Guard hit points per game level. ***/
			if (iEXEGuard[1] == 3) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[1], 389, 76, clr, color_wh, 0);
			if (iEXEGuard[2] == 3) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[2], 389, 100, clr, color_wh, 0);
			if (iEXEGuard[3] == 3) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[3], 389, 124, clr, color_wh, 0);
			if (iEXEGuard[4] == 3) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[4], 389, 148, clr, color_wh, 0);
			if (iEXEGuard[5] == 4) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[5], 389, 172, clr, color_wh, 0);
			if (iEXEGuard[6] == 5) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[6], 389, 196, clr, color_wh, 0);
			if (iEXEGuard[7] == 4) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[7], 389, 220, clr, color_wh, 0);
			if (iEXEGuard[8] == 4) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[8], 389, 244, clr, color_wh, 0);
			if (iEXEGuard[9] == 5) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[9], 574, 76, clr, color_wh, 0);
			if (iEXEGuard[10] == 5) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[10], 574, 100, clr, color_wh, 0);
			if (iEXEGuard[11] == 5) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[11], 574, 124, clr, color_wh, 0);
			if (iEXEGuard[12] == 4) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[12], 574, 148, clr, color_wh, 0);
			if (iEXEGuard[13] == 6) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[13], 574, 172, clr, color_wh, 0);
			if (iEXEGuard[14] == 0) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[14], 574, 196, clr, color_wh, 0);
			if (iEXEGuard[15] == 0) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[15], 574, 220, clr, color_wh, 0);
			if (iEXEGuard[0] == 4) { clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuard[0], 574, 244, clr, color_wh, 0);
		} else {
			/*** Edit guard details. ***/
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][0]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][0]; }
			if (iEXEGuardD[iEXETab][1] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][1],
				389, 76, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][1]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][1]; }
			if (iEXEGuardD[iEXETab][2] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][2],
				389, 100, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][2]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][2]; }
			if (iEXEGuardD[iEXETab][3] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][3],
				389, 124, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][3]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][3]; }
			if (iEXEGuardD[iEXETab][4] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][4],
				389, 148, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][4]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][4]; }
			if (iEXEGuardD[iEXETab][5] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][5],
				389, 172, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][5]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][5]; }
			if (iEXEGuardD[iEXETab][6] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][6],
				389, 196, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][6]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][6]; }
			if (iEXEGuardD[iEXETab][7] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][7],
				574, 76, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][7]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][7]; }
			if (iEXEGuardD[iEXETab][8] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][8],
				574, 100, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][8]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][8]; }
			if (iEXEGuardD[iEXETab][9] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][9],
				574, 124, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][9]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][9]; }
			if (iEXEGuardD[iEXETab][10] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][10],
				574, 148, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][10]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][10]; }
			if (iEXEGuardD[iEXETab][11] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][11],
				574, 172, clr, color_wh, 0);
			if (iEXEType < 2) { iC = arDefaultGuardD0[iEXETab - 1][11]; }
				else { iC = arDefaultGuardD1[iEXETab - 1][11]; }
			if (iEXEGuardD[iEXETab][12] == iC)
				{ clr = color_bl; } else { clr = color_blue; }
			CenterNumber (ascreen, iEXEGuardD[iEXETab][12],
				574, 196, clr, color_wh, 0);
		}
	}

	if (iEditPoP == 2)
	{
		/*** Current level type. ***/
		switch (iEXEEnvPoP2)
		{
			case 0x01: iX = 35; iY = 99; break;
			case 0x02: iX = 35; iY = 120; break;
			case 0x03: iX = 35; iY = 141; break;
			case 0x04: iX = 35; iY = 162; break;
			case 0x05: iX = 35; iY = 183; break;
			case 0x06: iX = 35; iY = 204; break;
			default:
				printf ("[ WARN ] Unknown level type: %i\n", iEXEEnvPoP2);
				iX = 35; iY = 99; break; /*** Fallback. ***/
		}
		ShowImageBasic (imgchkb, iX, iY, "imgchkb", ascreen, iScale, 1);
		if (iEXEEnvPoP2 != arDefaultEnvPoP2[luLevelNr])
		{
			ShowImageBasic (imgsrs, iX, iY, "imgsrs", ascreen, iScale, 1);
		}

		/*** Current level guards. ***/
		switch (iEXEGuardTypePoP2)
		{
			case 0x00: iX = 164; iY = 99; break;
			case 0x02: iX = 164; iY = 120; break;
			case 0x05: iX = 164; iY = 141; break;
			case 0x07: iX = 164; iY = 162; break;
			case 0xff: iX = 164; iY = 183; break;
			default:
				printf ("[ WARN ] Unknown level guards: %i\n", iEXEGuardTypePoP2);
				iX = 164; iY = 99; break; /*** Fallback. ***/
		}
		ShowImageBasic (imgchkb, iX, iY, "imgchkb", ascreen, iScale, 1);
		if (iEXEGuardTypePoP2 != arDefaultGuardTypePoP2[luLevelNr])
		{
			ShowImageBasic (imgsrs, iX, iY, "imgsrs", ascreen, iScale, 1);
		}
	}

	if (iEditPoP == 3)
	{
		/*******************/
		/* Guard settings. */
		/*******************/

		/*** Use black. ***/
		for (iTemp = 1; iTemp <= 18; iTemp++)
			{ clrs[iTemp] = color_bl; iColor[iTemp] = 1; }

		/*** Override with blue if the setting does not match the default. ***/
		for (iTemp = 1; iTemp <= 18; iTemp++)
		{
			if (iEXEGuardSNES[iEXETab][iTemp] !=
				arDefaultGuard[iEXETab - 1][iTemp - 1])
				{ clrs[iTemp] = color_blue; iColor[iTemp] = 2; }
		}

		/*** Override with grey for certain skeletons. ***/
		if (iEXETab == 7)
		{
			iEXEGuardSNES[iEXETab][2] = 255;
			iEXEGuardSNES[iEXETab][3] = 1;
			clrs[2] = color_gb;
			clrs[3] = color_gb;
		}

		if (iEXETab != 9)
		{
			iLeft = 418; iRight = 574;
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][2],
				iLeft, 52 + (1 * 24), clrs[2], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][3],
				iRight, 52 + (1 * 24), clrs[3], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][4],
				iLeft, 52 + (2 * 24), clrs[4], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][5],
				iRight, 52 + (2 * 24), clrs[5], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][6],
				iLeft, 52 + (3 * 24), clrs[6], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][7],
				iRight, 52 + (3 * 24), clrs[7], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][8],
				iLeft, 52 + (4 * 24), clrs[8], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][9],
				iRight, 52 + (4 * 24), clrs[9], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][10],
				iLeft, 52 + (5 * 24), clrs[10], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][11],
				iRight, 52 + (5 * 24), clrs[11], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][12],
				iLeft, 52 + (6 * 24), clrs[12], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][13],
				iRight, 52 + (6 * 24), clrs[13], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][14],
				iLeft, 52 + (7 * 24), clrs[14], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][15],
				iRight, 52 + (7 * 24), clrs[15], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][16],
				iLeft, 52 + (8 * 24), clrs[16], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][17],
				iRight, 52 + (8 * 24), clrs[17], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][18],
				iLeft, 52 + (9 * 24), clrs[18], color_wh, 0);
			CenterNumber (ascreen, iEXEGuardSNES[iEXETab][1],
				iRight, 52 + (9 * 24), clrs[1], color_wh, 0);
		} else {
			iLeft = 435; iRight = 591;
			ShowImage (-9, (int[]){26, iLeft, 52 + (1 * 24), iColor[2]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][2] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (1 * 24), iColor[3]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][3] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (2 * 24), iColor[4]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][4] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (2 * 24), iColor[5]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][5] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (3 * 24), iColor[6]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][6] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (3 * 24), iColor[7]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][7] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (4 * 24), iColor[8]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][8] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (4 * 24), iColor[9]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][9] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (5 * 24), iColor[10]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][10] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (5 * 24), iColor[11]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][11] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (6 * 24), iColor[12]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][12] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (6 * 24), iColor[13]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][13] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (7 * 24), iColor[14]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][14] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (7 * 24), iColor[15]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][15] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (8 * 24), iColor[16]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][16] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (8 * 24), iColor[17]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][17] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iLeft, 52 + (9 * 24), iColor[18]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][18] - 1) * 23, 0, 23, 20);
			ShowImage (-9, (int[]){26, iRight, 52 + (9 * 24), iColor[1]}, ascreen,
				210, (iEXEGuardSNES[iEXETab][1] - 1) * 23, 0, 23, 20);
		}

		/*******************/
		/* Other settings. */
		/*******************/

		/*** Music current level. ***/
		if (iEXEMusicSNESOnOff == 1)
		{
			if (iEXEType == 0) /*** JP ***/
			{
				if (iEXEMusicSNESValue ==
					(int)arDefaultMusicValuesJP[(int)luLevelNr - 1])
					{ clr = color_bl; } else { clr = color_blue; }
			} else if ((iEXEType == 1) || (iEXEType == 2)) { /*** US or EU ***/
				if (iEXEMusicSNESValue ==
					(int)arDefaultMusicValuesUSandEU[(int)luLevelNr - 1])
					{ clr = color_bl; } else { clr = color_blue; }
			} else { /*** As a fallback. ***/
				clr = color_bl;
			}
		} else { clr = color_gb; }
		CenterNumber (ascreen, iEXEMusicSNESValue,
			247, 76, clr, color_wh, 0);

		/*** Heat haze. ***/
		if (iEXEHazeSNESOnOff == 1)
		{
			if (iEXEHazeSNESValue == (int)ulDefaultHazeValue)
				{ clr = color_bl; } else { clr = color_blue; }
		} else { clr = color_gb; }
		CenterNumber (ascreen, iEXEHazeSNESValue + 1,
			247, 147, clr, color_wh, 0);

		/*** Starting hit points (PoP1 for SNES). ***/
		if (iEXEHitPoints == 3) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEHitPoints, 247, 218, clr, color_wh, 0);

		/*** Prince has sword (PoP1 for SNES). ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 140, 0, 0, 14, 14);
		if (iEXESword != -1)
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 140, 0, 0, 14, 14); }

		/*** Intro (level 22) is playable. ***/
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 196, 0, 0, 14, 14);
		if (iEXEDemoPlayableS != 0)
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 196, 0, 0, 14, 14); }

		/*** Warp potion. ***/
		if (iEXEWarpRoom == 0x11) { clr = color_bl; } else { clr = color_blue; }
		CenterNumber (ascreen, iEXEWarpRoom + 1, 97, 355, clr, color_wh, 0);
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 199, 0, 0, 14, 14);
		if (iEXEWarpFace != 0xff)
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 199, 0, 0, 14, 14); }
		ShowImage (-12, (int[]){12, 0, 0, 0}, ascreen, 200, 0, 0, 14, 14);
		if ((iEXEWarpCol != 0x01) || (iEXEWarpRow != 0x01))
			{ ShowImage (-7, (int[]){1, 0, 0, 0}, ascreen, 200, 0, 0, 14, 14); }
	}

	/*** refresh screen ***/
	SDL_RenderPresent (ascreen);
}
/*****************************************************************************/
void EXE_F3 (void)
/*****************************************************************************/
{
	int iEXE;
	SDL_Event event;

	iEXE = 1;
	iStatusBarFrame = 1;
	snprintf (sStatus, MAX_STATUS, "%s", "");

	EXELoad_F3_1();

	PlaySound ("wav/popup.wav");
	ShowEXE_F3();
	while (iEXE == 1)
	{
		if (iNoAnim == 0)
		{
			/*** We use the global REFRESH. No need for newticks/oldticks. ***/
			iStatusBarFrame++;
			if (iStatusBarFrame == 19) { iStatusBarFrame = 1; }
			ShowEXE_F3();
		}

		while (SDL_PollEvent (&event))
		{
			if (MapEvents (event) == 0)
			switch (event.type)
			{
				case SDL_CONTROLLERBUTTONDOWN:
					/*** Nothing for now. ***/
					break;
				case SDL_CONTROLLERBUTTONUP:
					switch (event.cbutton.button)
					{
						case SDL_CONTROLLER_BUTTON_A:
							EXESave_F3_1();
							iEXE = 0; break;
					}
					break;
				case SDL_KEYDOWN:
					switch (event.key.keysym.sym)
					{
						case SDLK_ESCAPE:
							iEXE = 0; break;
						case SDLK_KP_ENTER:
						case SDLK_RETURN:
						case SDLK_SPACE:
						case SDLK_s:
							EXESave_F3_1();
							iEXE = 0; break;
						default: break;
					}
					break;
				case SDL_MOUSEMOTION:
					iXPos = event.motion.x;
					iYPos = event.motion.y;
					if (InArea (608, 35, 656, 51) == 1) /*** CusPop ***/
					{
						SDL_SetCursor (curHand);
					} else {
						SDL_SetCursor (curArrow);
					}
					UpdateStatusBar_F3_1();
					break;
				case SDL_MOUSEBUTTONDOWN:
					if (event.button.button == 1)
					{
						if (InArea (590, 405, 674, 436) == 1) /*** Save ***/
						{
							if (iEXESave != 1) { iEXESave = 1; }
							ShowEXE_F3();
						}
					}
					break;
				case SDL_MOUSEBUTTONUP:
					iEXESave = 0;
					if (event.button.button == 1) /*** left mouse button ***/
					{
						/*** Save ***/
						if (InArea (590, 405, 674, 436) == 1)
						{
							EXESave_F3_1(); iEXE = 0;
						}

						/*** CusPop ***/
						if (InArea (608, 35, 656, 51) == 1)
						{
							OpenURL (URL_CUSPOP);
						}

						/*** Loose floor delay. ***/
						PlusMinus (&iEXELooseDelayA, 219, 76 + (0 * 24), 0, 127, -10, 0);
						PlusMinus (&iEXELooseDelayA, 234, 76 + (0 * 24), 0, 127, -1, 0);
						PlusMinus (&iEXELooseDelayA, 304, 76 + (0 * 24), 0, 127, +1, 0);
						PlusMinus (&iEXELooseDelayA, 319, 76 + (0 * 24), 0, 127, +10, 0);
						if (iEXELooseDelayA == 11) { iEXELooseDelayB = 3956; }
							else { iEXELooseDelayB = 37008; }

						/*** Allow loose floor climbing. ***/
						if ((InArea (261, 105, 261 + 14, 105 + 14) == 1) &&
							(iEXELooseClimbing == 1))
							{ iEXELooseClimbing = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (276, 105, 276 + 14, 105 + 14) == 1) &&
							(iEXELooseClimbing == 0))
							{ iEXELooseClimbing = 1; PlaySound ("wav/check_box.wav"); }

						/*** Shadow start level 5. ***/
						PlusMinus (&iEXEShadowStartX5, 34, 146, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartX5, 49, 146, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartX5, 119, 146, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartX5, 134, 146, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartY5, 149, 146, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartY5, 164, 146, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartY5, 234, 146, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartY5, 249, 146, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartC5, 264, 146, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartC5, 279, 146, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartC5, 349, 146, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartC5, 364, 146, 0, 255, +10, 0);
						/***/
						if ((InArea (73, 178, 73 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartR5 != 0))
							{ iEXEShadowStartR5 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (88, 178, 88 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartR5 != 1))
							{ iEXEShadowStartR5 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (103, 178, 103 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartR5 != 2))
							{ iEXEShadowStartR5 = 2; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (165, 178, 165 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartD5 != 255))
							{ iEXEShadowStartD5 = 255; PlaySound ("wav/check_box.wav"); }
						if ((InArea (180, 178, 180 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartD5 != 0))
							{ iEXEShadowStartD5 = 0; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (242, 178, 242 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 0))
							{ iEXEShadowStartA5 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (257, 178, 257 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 1))
							{ iEXEShadowStartA5 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (272, 178, 272 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 2))
							{ iEXEShadowStartA5 = 2; PlaySound ("wav/check_box.wav"); }
						if ((InArea (287, 178, 287 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 3))
							{ iEXEShadowStartA5 = 3; PlaySound ("wav/check_box.wav"); }
						if ((InArea (302, 178, 302 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 4))
							{ iEXEShadowStartA5 = 4; PlaySound ("wav/check_box.wav"); }
						if ((InArea (317, 178, 317 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 5))
							{ iEXEShadowStartA5 = 5; PlaySound ("wav/check_box.wav"); }
						if ((InArea (332, 178, 332 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 6))
							{ iEXEShadowStartA5 = 6; PlaySound ("wav/check_box.wav"); }
						if ((InArea (347, 178, 347 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 7))
							{ iEXEShadowStartA5 = 7; PlaySound ("wav/check_box.wav"); }
						if ((InArea (362, 178, 362 + 14, 178 + 14) == 1) &&
							(iEXEShadowStartA5 != 99))
							{ iEXEShadowStartA5 = 99; PlaySound ("wav/check_box.wav"); }

						/*** Shadow start level 6. ***/
						PlusMinus (&iEXEShadowStartX6, 34, 294, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartX6, 49, 294, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartX6, 119, 294, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartX6, 134, 294, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartY6, 149, 294, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartY6, 164, 294, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartY6, 234, 294, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartY6, 249, 294, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartC6, 264, 294, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartC6, 279, 294, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartC6, 349, 294, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartC6, 364, 294, 0, 255, +10, 0);
						/***/
						if ((InArea (73, 317, 73 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartR6 != 0))
							{ iEXEShadowStartR6 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (88, 317, 88 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartR6 != 1))
							{ iEXEShadowStartR6 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (103, 317, 103 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartR6 != 2))
							{ iEXEShadowStartR6 = 2; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (165, 317, 165 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartD6 != 255))
							{ iEXEShadowStartD6 = 255; PlaySound ("wav/check_box.wav"); }
						if ((InArea (180, 317, 180 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartD6 != 0))
							{ iEXEShadowStartD6 = 0; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (242, 317, 242 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 0))
							{ iEXEShadowStartA6 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (257, 317, 257 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 1))
							{ iEXEShadowStartA6 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (272, 317, 272 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 2))
							{ iEXEShadowStartA6 = 2; PlaySound ("wav/check_box.wav"); }
						if ((InArea (287, 317, 287 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 3))
							{ iEXEShadowStartA6 = 3; PlaySound ("wav/check_box.wav"); }
						if ((InArea (302, 317, 302 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 4))
							{ iEXEShadowStartA6 = 4; PlaySound ("wav/check_box.wav"); }
						if ((InArea (317, 317, 317 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 5))
							{ iEXEShadowStartA6 = 5; PlaySound ("wav/check_box.wav"); }
						if ((InArea (332, 317, 332 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 6))
							{ iEXEShadowStartA6 = 6; PlaySound ("wav/check_box.wav"); }
						if ((InArea (347, 317, 347 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 7))
							{ iEXEShadowStartA6 = 7; PlaySound ("wav/check_box.wav"); }
						if ((InArea (362, 317, 362 + 14, 317 + 14) == 1) &&
							(iEXEShadowStartA6 != 99))
							{ iEXEShadowStartA6 = 99; PlaySound ("wav/check_box.wav"); }

						/*** Shadow start level 12. ***/
						PlusMinus (&iEXEShadowStartX12, 34, 337, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartX12, 49, 337, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartX12, 119, 337, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartX12, 134, 337, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartY12, 149, 337, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartY12, 164, 337, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartY12, 234, 337, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartY12, 249, 337, 0, 255, +10, 0);
						/***/
						PlusMinus (&iEXEShadowStartC12, 264, 337, 0, 255, -10, 0);
						PlusMinus (&iEXEShadowStartC12, 279, 337, 0, 255, -1, 0);
						PlusMinus (&iEXEShadowStartC12, 349, 337, 0, 255, +1, 0);
						PlusMinus (&iEXEShadowStartC12, 364, 337, 0, 255, +10, 0);
						/***/
						if ((InArea (73, 360, 73 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartR12 != 0))
							{ iEXEShadowStartR12 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (88, 360, 88 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartR12 != 1))
							{ iEXEShadowStartR12 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (103, 360, 103 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartR12 != 2))
							{ iEXEShadowStartR12 = 2; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (165, 360, 165 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartD12 != 255))
							{ iEXEShadowStartD12 = 255; PlaySound ("wav/check_box.wav"); }
						if ((InArea (180, 360, 180 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartD12 != 0))
							{ iEXEShadowStartD12 = 0; PlaySound ("wav/check_box.wav"); }
						/***/
						if ((InArea (242, 360, 242 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 0))
							{ iEXEShadowStartA12 = 0; PlaySound ("wav/check_box.wav"); }
						if ((InArea (257, 360, 257 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 1))
							{ iEXEShadowStartA12 = 1; PlaySound ("wav/check_box.wav"); }
						if ((InArea (272, 360, 272 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 2))
							{ iEXEShadowStartA12 = 2; PlaySound ("wav/check_box.wav"); }
						if ((InArea (287, 360, 287 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 3))
							{ iEXEShadowStartA12 = 3; PlaySound ("wav/check_box.wav"); }
						if ((InArea (302, 360, 302 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 4))
							{ iEXEShadowStartA12 = 4; PlaySound ("wav/check_box.wav"); }
						if ((InArea (317, 360, 317 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 5))
							{ iEXEShadowStartA12 = 5; PlaySound ("wav/check_box.wav"); }
						if ((InArea (332, 360, 332 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 6))
							{ iEXEShadowStartA12 = 6; PlaySound ("wav/check_box.wav"); }
						if ((InArea (347, 360, 347 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 7))
							{ iEXEShadowStartA12 = 7; PlaySound ("wav/check_box.wav"); }
						if ((InArea (362, 360, 362 + 14, 360 + 14) == 1) &&
							(iEXEShadowStartA12 != 99))
							{ iEXEShadowStartA12 = 99; PlaySound ("wav/check_box.wav"); }

						/*** Shadow moves. ***/
						Move (&iEXEShadowMovesTime[1], &iEXEShadowMovesAction[1],
							34, 197, END_SHADOW);
						Move (&iEXEShadowMovesTime[2], &iEXEShadowMovesAction[2],
							34, 221, END_SHADOW);
						Move (&iEXEShadowMovesTime[3], &iEXEShadowMovesAction[3],
							34, 245, END_SHADOW);
						Move (&iEXEShadowMovesTime[4], &iEXEShadowMovesAction[4],
							34, 269, END_SHADOW);
						Move (&iEXEShadowMovesTime[5], &iEXEShadowMovesAction[5],
							169, 197, END_SHADOW);
						Move (&iEXEShadowMovesTime[6], &iEXEShadowMovesAction[6],
							169, 221, END_SHADOW);
						Move (&iEXEShadowMovesTime[7], &iEXEShadowMovesAction[7],
							169, 245, END_SHADOW);

						/*** Prince moves. ***/
						Move (&iEXEPrinceMovesTime[1], &iEXEPrinceMovesAction[1],
							393, 76, END_PRINCE);
						Move (&iEXEPrinceMovesTime[2], &iEXEPrinceMovesAction[2],
							393, 100, END_PRINCE);
						Move (&iEXEPrinceMovesTime[3], &iEXEPrinceMovesAction[3],
							393, 124, END_PRINCE);
						Move (&iEXEPrinceMovesTime[4], &iEXEPrinceMovesAction[4],
							393, 148, END_PRINCE);
						Move (&iEXEPrinceMovesTime[5], &iEXEPrinceMovesAction[5],
							393, 172, END_PRINCE);
						Move (&iEXEPrinceMovesTime[6], &iEXEPrinceMovesAction[6],
							393, 196, END_PRINCE);
						Move (&iEXEPrinceMovesTime[7], &iEXEPrinceMovesAction[7],
							393, 220, END_PRINCE);
						Move (&iEXEPrinceMovesTime[8], &iEXEPrinceMovesAction[8],
							393, 244, END_PRINCE);
						Move (&iEXEPrinceMovesTime[9], &iEXEPrinceMovesAction[9],
							393, 268, END_PRINCE);
						Move (&iEXEPrinceMovesTime[10], &iEXEPrinceMovesAction[10],
							393, 292, END_PRINCE);
						Move (&iEXEPrinceMovesTime[11], &iEXEPrinceMovesAction[11],
							393, 316, END_PRINCE);
						Move (&iEXEPrinceMovesTime[12], &iEXEPrinceMovesAction[12],
							393, 340, END_PRINCE);
						Move (&iEXEPrinceMovesTime[13], &iEXEPrinceMovesAction[13],
							528, 76, END_PRINCE);
						Move (&iEXEPrinceMovesTime[14], &iEXEPrinceMovesAction[14],
							528, 100, END_PRINCE);
						Move (&iEXEPrinceMovesTime[15], &iEXEPrinceMovesAction[15],
							528, 124, END_PRINCE);
						Move (&iEXEPrinceMovesTime[16], &iEXEPrinceMovesAction[16],
							528, 148, END_PRINCE);
						Move (&iEXEPrinceMovesTime[17], &iEXEPrinceMovesAction[17],
							528, 172, END_PRINCE);
						Move (&iEXEPrinceMovesTime[18], &iEXEPrinceMovesAction[18],
							528, 196, END_PRINCE);
						Move (&iEXEPrinceMovesTime[19], &iEXEPrinceMovesAction[19],
							528, 220, END_PRINCE);
						Move (&iEXEPrinceMovesTime[20], &iEXEPrinceMovesAction[20],
							528, 244, END_PRINCE);
						Move (&iEXEPrinceMovesTime[21], &iEXEPrinceMovesAction[21],
							528, 268, END_PRINCE);
						Move (&iEXEPrinceMovesTime[22], &iEXEPrinceMovesAction[22],
							528, 292, END_PRINCE);
						Move (&iEXEPrinceMovesTime[23], &iEXEPrinceMovesAction[23],
							528, 316, END_PRINCE);
						Move (&iEXEPrinceMovesTime[24], &iEXEPrinceMovesAction[24],
							528, 340, END_PRINCE);
					}
					ShowEXE_F3(); break;
				case SDL_WINDOWEVENT:
					switch (event.window.event)
					{
						case SDL_WINDOWEVENT_EXPOSED:
							ShowEXE_F3(); break;
						case SDL_WINDOWEVENT_CLOSE:
							Quit(); break;
						case SDL_WINDOWEVENT_FOCUS_GAINED:
							iActiveWindowID = iWindowID; break;
					}
					break;
				case SDL_QUIT:
					Quit(); break;
			}
		}
		PreventCPUEating();
	}
	PlaySound ("wav/popup_close.wav");
	SDL_SetCursor (curArrow);
	ShowScreen (iScreen, ascreen);
}
/*****************************************************************************/
void ShowEXE_F3 (void)
/*****************************************************************************/
{
	char arText[9 + 2][MAX_TEXT + 2];
	SDL_Color clr;

	ShowImageBasic (imgexef3, 0, 0, "imgexef3", ascreen, iScale, 1);

	/*** status bar ***/
	if (strcmp (sStatus, "") != 0)
	{
		/*** bulb ***/
		ShowImage (-9, (int[]){25, 0, 0, 0}, ascreen, 209, 0, 0, 20, 20);
		/*** text ***/
		DisplayTextLine (50, 415, sStatus, font2, color_bl, color_f4, 0);
	}

	/*** save ***/
	switch (iEXESave)
	{
		case 0:
			/*** Save off ***/
			ShowImage (-9, (int[]){12, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
		case 1:
			/*** Save on ***/
			ShowImage (-9, (int[]){13, 0, 0, 0}, ascreen, 43, 0, 0, 85, 32); break;
	}

	/*** type text ***/
	snprintf (arText[0], MAX_TEXT, "Executable type is: %s (%i)",
		sEXEType, iEXEType);
	DisplayText (33, 32, FONT_SIZE_15, arText, 1, font1);

	/*** Loose floor delay. ***/
	if (iEXELooseDelayA == 11) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXELooseDelayA, 247, 76, clr, color_wh, 0);

	/*** Allow loose floor climbing. ***/
	if (iEXELooseClimbing == 0)
	{
		ShowImageBasic (imgchkb, 261, 105, "imgchkb", ascreen, iScale, 1);
	} else {
		ShowImageBasic (imgchkb, 276, 105, "imgchkb", ascreen, iScale, 1);
		ShowImageBasic (imgsrs, 276, 105, "imgsrs", ascreen, iScale, 1);
	}

	/*** Shadow start. ***/
	if (iEXEShadowStartX5 == 55) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartX5, 62, 146, clr, color_wh, 0);
	if (iEXEShadowStartY5 == 55) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartY5, 177, 146, clr, color_wh, 0);
	if (iEXEShadowStartC5 == 255) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartC5, 292, 146, clr, color_wh, 0);
	switch (iEXEShadowStartR5)
	{
		case 0: /*** top (default for 5) ***/
			ShowImageBasic (imgchkb, 73, 178, "imgchkb", ascreen, iScale, 1);
			break;
		case 1: /*** middle ***/
			ShowImageBasic (imgchkb, 88, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 88, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 2: /*** bottom ***/
			ShowImageBasic (imgchkb, 103, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 103, 178, "imgsrs", ascreen, iScale, 1);
			break;
	}
	switch (iEXEShadowStartD5)
	{
		case 255: /*** left ***/
			ShowImageBasic (imgchkb, 165, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 165, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 0: /*** right (default for 5) ***/
			ShowImageBasic (imgchkb, 180, 178, "imgchkb", ascreen, iScale, 1);
			break;
	}
	switch (iEXEShadowStartA5)
	{
		case 0: /*** stand (default for 5) ***/
			ShowImageBasic (imgchkb, 242, 178, "imgchkb", ascreen, iScale, 1);
			break;
		case 1: /*** run jump ***/
			ShowImageBasic (imgchkb, 257, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 257, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 2: /*** hang climb ***/
			ShowImageBasic (imgchkb, 272, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 272, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 3: /*** in midair ***/
			ShowImageBasic (imgchkb, 287, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 287, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 4: /*** in freefall ***/
			ShowImageBasic (imgchkb, 302, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 302, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 5: /*** bumped ***/
			ShowImageBasic (imgchkb, 317, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 317, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 6: /*** hang straight ***/
			ShowImageBasic (imgchkb, 332, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 332, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 7: /*** turn ***/
			ShowImageBasic (imgchkb, 347, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 347, 178, "imgsrs", ascreen, iScale, 1);
			break;
		case 99: /*** hurt ***/
			ShowImageBasic (imgchkb, 362, 178, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 362, 178, "imgsrs", ascreen, iScale, 1);
			break;
	}
	/***/
	if (iEXEShadowStartX6 == 81) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartX6, 62, 294, clr, color_wh, 0);
	if (iEXEShadowStartY6 == 118) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartY6, 177, 294, clr, color_wh, 0);
	if (iEXEShadowStartC6 == 0) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartC6, 292, 294, clr, color_wh, 0);
	switch (iEXEShadowStartR6)
	{
		case 0: /*** top ***/
			ShowImageBasic (imgchkb, 73, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 73, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 1: /*** middle (default for 6) ***/
			ShowImageBasic (imgchkb, 88, 317, "imgchkb", ascreen, iScale, 1);
			break;
		case 2: /*** bottom ***/
			ShowImageBasic (imgchkb, 103, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 103, 317, "imgsrs", ascreen, iScale, 1);
			break;
	}
	switch (iEXEShadowStartD6)
	{
		case 255: /*** left ***/
			ShowImageBasic (imgchkb, 165, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 165, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 0: /*** right (default for 6) ***/
			ShowImageBasic (imgchkb, 180, 317, "imgchkb", ascreen, iScale, 1);
			break;
	}
	switch (iEXEShadowStartA6)
	{
		case 0: /*** stand (default for 6) ***/
			ShowImageBasic (imgchkb, 242, 317, "imgchkb", ascreen, iScale, 1);
			break;
		case 1: /*** run jump ***/
			ShowImageBasic (imgchkb, 257, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 257, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 2: /*** hang climb ***/
			ShowImageBasic (imgchkb, 272, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 272, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 3: /*** in midair ***/
			ShowImageBasic (imgchkb, 287, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 287, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 4: /*** in freefall ***/
			ShowImageBasic (imgchkb, 302, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 302, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 5: /*** bumped ***/
			ShowImageBasic (imgchkb, 317, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 317, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 6: /*** hang straight ***/
			ShowImageBasic (imgchkb, 332, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 332, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 7: /*** turn ***/
			ShowImageBasic (imgchkb, 347, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 347, 317, "imgsrs", ascreen, iScale, 1);
			break;
		case 99: /*** hurt ***/
			ShowImageBasic (imgchkb, 362, 317, "imgchkb", ascreen, iScale, 1);
			ShowImageBasic (imgsrs, 362, 317, "imgsrs", ascreen, iScale, 1);
			break;
	}
	/***/
	if (iEXEShadowStartX12 == 81) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartX12, 62, 337, clr, color_wh, 0);
	if (iEXEShadowStartY12 == 232) { clr = color_bl; } else { clr = color_blue; }
	CenterNumber (ascreen, iEXEShadowStartY12, 177, 3