// TrackEdView.h : interface of the CTrackEdView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRACKEDVIEW_H__44585E7C_2663_404F_834A_269621BD2BA4__INCLUDED_)
#define AFX_TRACKEDVIEW_H__44585E7C_2663_404F_834A_269621BD2BA4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBestLineSeg;

#include "TrackSeg.h"

class CTrackEdView : public CView
{
protected: // create from serialization only
	CTrackEdView();
	DECLARE_DYNCREATE(CTrackEdView)

// Attributes
public:
	CTrack* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTrackEdView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CTrackEdView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	void MoveEditPointer( char nChar );
	int m_iMaxTy;
	int m_iMaxTx;
	boolean m_bDrawSegs;
	boolean m_bDrawPoints;
	int m_iDy;
	int m_iDx;
	double m_scale;
	void DrawArc( CDC * pDC, int x, int y, float stangle, float endangle, float str, float endr );
	void DrawLine( CDC * pDC, int x1, int y1, int x2, int y2 );
	void DrawCCLineSegment( CDC * pDC, const CRect &rectClip, CBestLineSeg * pBl );
	void DrawTrackSegment( CDC * pDC, const CRect &rectClip, CTrackSeg * pTr, bool bPit );
	void DrawGraph( CDC * pDC );
	//{{AFX_MSG(CTrackEdView)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnPreferencesNewCcline();
	afx_msg void OnUpdatePreferencesNewCcline(CCmdUI* pCmdUI);
	afx_msg void OnPreferencesOldCcline();
	afx_msg void OnUpdatePreferencesOldCcline(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in TrackEdView.cpp
inline CTrack* CTrackEdView::GetDocument()
   { return (CTrack*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TRACKEDVIEW_H__44585E7C_2663_404F_834A_269621BD2BA4__INCLUDED_)
