// EditCommandDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TrackEd.h"
#include "EditCommandDialog.h"
#include "Command.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditCommandDialog dialog


CEditCommandDialog::CEditCommandDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CEditCommandDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditCommandDialog)
	m_strCommandID = _T("");
	m_strA0 = _T("");
	m_strA1 = _T("");
	m_strA2 = _T("");
	m_strA3 = _T("");
	m_strA4 = _T("");
	m_strA5 = _T("");
	//}}AFX_DATA_INIT
	m_pCmd = NULL;
}


void CEditCommandDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditCommandDialog)
	DDX_Text(pDX, IDC_EDIT_COMMANDID, m_strCommandID);
	DDX_Text(pDX, IDC_EDIT_A0, m_strA0);
	DDX_Text(pDX, IDC_EDIT_A1, m_strA1);
	DDX_Text(pDX, IDC_EDIT_A2, m_strA2);
	DDX_Text(pDX, IDC_EDIT_A3, m_strA3);
	DDX_Text(pDX, IDC_EDIT_A4, m_strA4);
	DDX_Text(pDX, IDC_EDIT_A5, m_strA5);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditCommandDialog, CDialog)
	//{{AFX_MSG_MAP(CEditCommandDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditCommandDialog message handlers

void CEditCommandDialog::SetCommand(CCommand *pCmd)
{
	m_pCmd = pCmd;
}

BOOL CEditCommandDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if ( m_pCmd != NULL )
	{
		m_strCommandID.Format( "%02X", m_pCmd->cmd );
		m_strA0.Format( "%02X", m_pCmd->a0 );
		m_strA1.Format( "%02X", m_pCmd->a1 );
		m_strA2.Format( "%02X", m_pCmd->a2 );
		m_strA3.Format( "%02X", m_pCmd->a3 );
		m_strA4.Format( "%02X", m_pCmd->a4 );
		m_strA5.Format( "%02X", m_pCmd->a5 );
		UpdateData( FALSE );
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditCommandDialog::OnOK() 
{
	// transfer data back into command object
	if ( m_pCmd != NULL )
	{
		UpdateData();
		int i;
		sscanf( m_strCommandID, "%X", &i );
		m_pCmd->cmd = (unsigned char) i;
		sscanf( m_strA0, "%X", &i );
		m_pCmd->a0 = (unsigned char) i;
		sscanf( m_strA1, "%X", &i );
		m_pCmd->a1 = (short) i;
		sscanf( m_strA2, "%X", &i );
		m_pCmd->a2 = (short) i;
		sscanf( m_strA3, "%X", &i );
		m_pCmd->a3 = (short) i;
		sscanf( m_strA4, "%X", &i );
		m_pCmd->a4 = (short) i;
		sscanf( m_strA5, "%X", &i );
		m_pCmd->a5 = (short) i;
	}
	CDialog::OnOK();
}
