//***************************************************************************
//
// Copyright (c) 1993 Sierra Semiconductor Corp.
//
// FILE:    cdvol.c
//
// LANGUAGE:
//          Microsoft C/C++ Version 7.0
//
// DESCRIPTION:
//
//          A utility to set the CD-ROM audio volume (AUX2)
//
//          Compile:  cl /c /Ox /Zp cdvol.c
//          Link:     link cdvol,,,aria_s;
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\cdvol.c_v   1.2   03 Sep 1993 10:14:34   golds  $
// $Log:   F:\projects\ariai\dos\archives\cdvol.c_v  $
// 
//    Rev 1.2   03 Sep 1993 10:14:34   golds
// Recompiled with API library version 2.2
// 
//    Rev 1.1   13 Aug 1993 09:13:18   golds
// Changed order of setting volume level - it now waits until user has entered
// volume level before switching system mode
//
//    Rev 1.0   24 Jun 1993 12:51:16   golds
// Initial revision.

#include <stdio.h>
#include <stdlib.h>
#include "aria.h"

main (short argc, char *argv[])
   {
   short status;
   WORD  cd_vol;

   printf ("\nCDVOL - Set CD-ROM audio volume (Version 1.2)\n");
   printf ("Copyright (c) 1993 Sierra Semiconductor Corp.\n");

   if (argc < 2)
      {
      printf ("\nPlease enter CD-ROM volume (0 to 127): ");
      scanf ("%d", &cd_vol);
      }
   else
      cd_vol = atoi (argv[1]);
   if (cd_vol > 127)
      cd_vol = 127;
   cd_vol <<= 8;

   status = SystemInit (ARIA_SYNTH);
   if (status < 0)
      {
      printf ("\nERROR - Audio system not found!\n");
      exit (1);
      }
   SetAuxVolume (cd_vol, cd_vol);
   SetMixerConfig (1, 1, 0, 0, (UINT) (cd_vol > 0));

   printf ("\nCD-ROM audio volume set to %d\n", cd_vol>>8);
   status = SystemInit (DEFAULT_SYNTH);
   if (status != 0)
      printf ("\nERROR - Could not reset to Sound Blaster mode\n");
   exit (0);
   }

