//***************************************************************************
//
// Copyright (c) 1991-93 Sierra Semiconductor Corp.
//
// FILE:    ariamidi.h
//
// LANGUAGES:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//          Borland Turbo C Versions 1.5 and 2.0
//
// DESCRIPTION:
//
//          Header file for Aria MIDI applications
//
// AdLib is a trademark of AdLib Inc.
// Aria, Aria Synthesizer and Aria Listener are trademarks of Sierra
//  Semiconductor Corp.
// QSound is a trademark of Archer Communications
// Sound Blaster is a trademark of Creative Labs Inc.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\ariamidi.h_v   2.2   03 Sep 1993 10:04:34   golds  $
// $Log:   F:\projects\ariai\dos\archives\ariamidi.h_v  $
// 
//    Rev 2.2   03 Sep 1993 10:04:34   golds
// Fixed recording from external input source
// 
//    Rev 2.1   13 Aug 1993 09:24:14   golds
// Reverb support added, 16-channel MIDI, other optimizations
// 
//    Rev 2.0   24 Jun 1993 14:04:38   golds
// Initial revision.

#define UNUSEDB     0xff
#define UNUSEDW     0xffff
#define MAXCOUNT    0xffff
#define MAXDATE     0xffffffff

#define LOMIDI 1    // Lowest note we will play without octave transpose
#define HIMIDI 112  // Highest note we can play without octave transpose

#define CLOSEDHIHAT 42        // GM percussion closed hihat cymbal note
#define PEDALHIHAT  44        // GM percussion pedal hihat cymbal note
#define OPENHIHAT   46        // GM percussion open hihat cymbal note

#define PERCUSSIONCH 9        // Percussion channel
#define MAXCHANNEL  16        // Maximum MIDI channel number supported

#define COMMASK     0xF0      // MIDI command mask
#define CHMASK      0x0F      // MIDI channel mask

#define NOTEOFF     0x80      // MIDI note off command
#define NOTEON      0x90      // MIDI note on command
#define KEYPRES     0xA0      // MIDI key pressure command
#define CONTROLLER  0xB0      // MIDI controller command
#define PCHANGE     0xC0      // MIDI program change command
#define CHPRES      0xD0      // MIDI channel pressure command
#define PBEND       0xE0      // MIDI pitch bend command

#define SYSEX       0xF0      // MIDI system exclusive command
#define TIMECODE    0xF1      // MIDI time code command
#define POSPTR      0xF2      // MIDI song position pointer command
#define SELECT      0xF3      // MIDI song select command
#define TUNEREQ     0xF6      // MIDI tune request command
#define EOX         0xF7      // End of transmission code

#define TIMING      0xF8      // MIDI timing command
#define MIDIF9      0xF9      // Undefined MIDI command
#define START       0xFA      // MIDI start command
#define CONTINUE    0xFB      // MIDI continue command
#define STOP        0xFC      // MIDI stop command
#define MIDIFD      0xFD      // Undefined MIDI command
#define ACTIVESENSE 0xFE      // MIDI active sensing command

#define DATAENTRY   6         // Data entry
#define VOL         7         // Channel volume controller
#define PAN         10        // Pan controller
#define SUS         64        // Hold or sustain pedal controller
#define REVERB      91        // Reverb level
#define CHORUS      93        // Chorus depth
#define DATAINC     96        // Data increment
#define DATADEC     97        // Data decrement
#define RPNLSB      100       // Registered Parameter Number (LSB)
#define RPNMSB      101       // Registered Parameter Number (MSB)
#define ALLSOFF     120       // All sounds off
#define ALLCTRLOFF  121       // Reset all controllers
#define ALLNOFF     123       // All notes off

#define RPN_BENDSENS 0x0000   // RPN 0 (Pitch Bend Sens)
#define RPN_RESET    0x7F7F   // RPN 16383 (RPN reset)

#define CENTER_PITCH 0x2000   // Center pitch for pitch bend command
#define CENTER_PAN   0x40     // Center pan for pan controller
#define REVERB_DEFAULT   64   // Channel reverb default level
#define VOLUME_DEFAULT   100  // Channel volume default level
#define BENDSENS_DEFAULT 2    // Pitch bend sensitivity default

// Custom Aria controllers - can be assigned to any MIDI controller

#define VIBRATOSPEED 0        // Vibrato speed
#define VIBRATODEPTH 1        // Vibrato depth
#define TREMOLOSPEED 2        // Tremolo speed
#define TREMOLODEPTH 3        // Tremolo depth
#define PANMODSPEED  4        // Pan modulation speed
#define PANMODDEPTH  5        // Pan modulation depth

// Macros to calculate pitch value
//  (b) = Base MIDI note
//  (m) = MIDI note to play
//  (l) = Loop flag (0=loop,1=single)

#define DIFFPITCH(b,m)    (127+((short)(m)-(short)(b)))
#define CORRFACTOR(b,m,l) ((l)?0L:(dwCorrFactor[DIFFPITCH(b,m)]))
#define CALCPITCH(b,m,l)  (dwPitchTable[DIFFPITCH(b,m)]+(CORRFACTOR(b,m,l)))

// Macros to calculate pan values

#define PAN1(chpan)   (((chpan)>=64)?(short)(127-(chpan)):(short)(chpan))
#define PAN2(oppan)   (((oppan)>=64)?((short)(oppan)-64):-(64-(short)(oppan)))
#define GetOpPan(ch,op) ((short)(ch)+((PAN1(ch)*PAN2(op))>>6))

// Macros to calculate LFO speed and depth values

#define getLFOspeed(s,d,v) (((WORD)(s)+((v*((d*(500-(WORD)(s)))/127))/127))<<5)
#define getLFOdepth(m,d,v) ((WORD)(m)+((v*((d*(255-(WORD)(m)))/127))/127))

// Macro to calculate MIDI channel/operator offset

#define calcOFF(ch,op) (((ch)<<3)+op)  // Same as ((ch * 8) + op)

// Macro to calculate WPT base offset

#define calcWPT(ch) (WPTchan[ch].base)

// Macro to mask off operator from WPT table entry

#define WPToff(wpt,op) (WPT[wpt].opmask&=~((DWORD)1L<<(op)))

// Macro to mask on operator from WPT table entry

#define WPTon(wpt,op) (WPT[wpt].opmask|=((DWORD)1L<<(op)))

// MIDI channel information structures

typedef struct
   {
   char   name[PATCHNAMELEN];
   BYTE   level;
   BYTE   patchID;
   BYTE   minOperators;
   BYTE   totalOperators;
   BYTE   pitchWheel;
   MODULATORDEF vibmod;
   MODULATORDEF tremmod;
   MODULATORDEF panmod;
   BYTE   ctrlID[3];
   BYTE   ctrlDepth[3];
   BYTE   ctrlUse[3];
	BYTE   pan;
   } PATCH;

typedef struct
   {
   short  detune;
   short  transpose;
   BYTE   velocityTableID;
   BYTE   balance;
   BYTE   keybias;
   BYTE   opAmp;
   ENVDEF opEnvelope[MAXSTAGES];
   BYTE   minPitch;
   BYTE   maxPitch;
   BYTE   minVelocity;
   BYTE   maxVelocity;
   BYTE   pitchScale;
   BYTE   waveCount;
   WAVEDEF waveTable[MAXWAVESPEROP];
   } OP;

typedef struct
   {
   PATCH  patch;
   OP     op[MAXOPSPERPATCH];
   WPTLFO wptLFO[3];                       
   BYTE   vol;
   BYTE   pan;
   BYTE   reverb;
   BOOL   sus;
   WORD   pbend;
   } CH_INFO;

typedef CH_INFO FAR *CHANNELPTR;

// Aria synthesis operator information structure

struct op_info
   {
   BYTE  channel;    // MIDI channel
   BYTE  basenote;   // Waveform base pitch
   BYTE  note;       // MIDI note played
   BYTE  transposed; // MIDI note after transpositions
   BYTE  velocity;   // MIDI velocity
   BYTE  opnum;      // DSP operator number
   WORD  type;       // Waveform type (0=loop, 1=single)
   WORD  flags;      // Status flags (0,ACTIVE,SUSTAINED)*/
   WORD  priority;   // Operator priority (0,1,2)
   LONG  pfactor;    // Pitch range scaling factor
   DWORD date;       // Relative time tag
   };

typedef struct op_info OP_INFO;

// Aria synthesis LFO information structure

struct lfo_info
   {
   BYTE channel;     // MIDI channel
   WORD speed;       // LFO speed
   BYTE shape;       // LFO shape
   BYTE depth;       // LFO depth
   };

typedef struct lfo_info LFO_INFO;

typedef struct       // Wave Parameter Table Information Structure
   {                 //   (One per operator)
   BYTE   wptno;     // Wave Parameter Table number to index
   DWORD  opmask;    // Operator mask indicating operators using this WPT 
   DWORD  date;      // Time tag for dynamic allocation
   } WPTINFO;

typedef struct       // Wave Parameter Table MIDI Channel Structure
   {                 //   (One per MIDI channel)
   BYTE   base;      // Starting index for WPTINFO table
   BYTE   size;      // Number of entries in WPTINFO for this MIDI channel
   } WPTCHAN;

typedef struct       // Percussion Patch Information
   {
   WORD  midipitch;  // Percussion note number
   DWORD date;       // Activity counter for dynamic operator allocation
   } PERCPATCH;

//*** External library declarations ***

extern short InitPatchBank (VOID FAR *, UINT);
extern short MIDImessage (BYTE, BYTE, BYTE);
extern short SetMode (UINT, UINT);

