//***************************************************************************
//
// Copyright (c) 1993 Sierra Semiconductor Corp.
//
// FILE:    ariadsp.h
//
// LANGUAGES:
//          Microsoft C Versions 5.0, 6.0, and 7.0
//          Borland Turbo C Versions 1.5 and 2.0
//
// DESCRIPTION:
//
//          Header file for Aria DSP application function library
//
// AdLib is a trademark of AdLib Inc.
// Aria, Aria Synthesizer and Aria Listener are trademarks of Sierra
//  Semiconductor Corp.
// QSound is a trademark of Archer Communications
// Sound Blaster is a trademark of Creative Labs Inc.
//
//***************************************************************************

// $Header:   F:\projects\ariai\dos\archives\ariadsp.h_v   2.2   03 Sep 1993 10:05:40   golds  $
// $Log:   F:\projects\ariai\dos\archives\ariadsp.h_v  $
// 
//    Rev 2.2   03 Sep 1993 10:05:40   golds
// Fixed recording from external input source
// 
//    Rev 2.1   13 Aug 1993 09:24:08   golds
// Reverb support added, 16-channel MIDI, other optimizations
// 
//    Rev 2.0   24 Jun 1993 14:04:30   golds
// Initial revision.

#define MAXAPPS         16          // Maximum number of DSP apps allowed

#define DSPMAXUSAGE     11000       // DSP maximum utilization (110% !!)
#define DSPWAVEUNIT     708         // Wave channel utilization
#define DSPSYNTHBASIC   2500        // Aria Synthesizer base utilization
#define DSPSYNTHUNIT    156         // Aria Synthesizer operator utilization

#define REVERBMODEDEF   1           // Reverb default mode
#define REVERBLEVELDEF  0x28        // Reverb default level (overall)
#define WREVERB_DEFAULT 0x3FFF      // Reverb wave channel default level

//***********************************
//*** RDSP - RIFF DSP File Format ***
//***********************************
/*
<RDSP-form>  ->  RIFF(  'RDSP'           // form type
                        <hdr-ck>         // header chunk
                       [<data-ck>...])   // data chunk(s)

<hdr-ck>     ->  RIFF(  'dsph'           // DSP header form type
                        <header> )       // DSP header info

<header>     ->  struct
                    {
                    WORD   wAppID;       // DSP application ID number
                    char   szAppName[MAXAPPNAMELEN]; // DSP Application name
                    WORD   wVersion;     // DSP application version number

                    WORD   wFormat;      // DSP application format:
                                         //  0 = ROM-based app, header only
                                         //  1 = RAM-based app, code on disk
                    WORD   wTotalChunks; // Total number of code/data chunks
                                         //  in this file
                    WORD   wKey;         // Encryption key for security
                                         //  0 = no encryption
                    WORD   wMid;         // DSP hardware manufacturer ID:
                                         //  0 = Sierra Semiconductor Corp.
                    WORD   wPid;         // DSP product ID:
                                         //    18025, 18026, etc.

                    DWORD  dwDSPMap;     // DSP Compatibility bit map,
                                         //   hardware dependent
                    DWORD  dwRAMMap;     // RAM Compatibility bit map,
                                         //   hardware dependent

                    BYTE   bMinUsage;    // Minimum DSP app utilization,
                                         //   0 to 100 percent
                    BYTE   bMaxUsage;    // Maximum DSP app utilization,
                                         //   0 to 100 percent
                    WORD   wVoiceCount;  // Maximum number of synthesizer
                                         //   voices allowed simultaneously
                    } Header

<data-ck>    ->  RIFF(  'dspd'           // DSP data form type
                        <dsp-data> )     // DSP data info

<dsp-data>   ->  struct
                    {
                    WORD   wType;        // 1 = Program code chunk
                                         // 2 = Program data chunk
                                         // 3 = Combined program/data chunk
                    DWORD  dwAddr;       // DSP RAM absolute load address
                    DWORD  reserved1;    // Reserved for future use
                    DWORD  reserved2;    // Reserved for future use
                    BYTE   data[];       // Actual DSP data
                    }
*/

// MMIO macro
#define mmioFOURCC( ch0, ch1, ch2, ch3 )                                \
                ( (DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |    \
                ( (DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ) )
typedef DWORD           FOURCC;         // A four character code

#define RDSP_MAXAPPNAMELEN   30
#define FOURCC_RDSP     mmioFOURCC('R', 'D', 'S', 'P')
#define FOURCC_DSPH     mmioFOURCC('d', 's', 'p', 'h')
#define FOURCC_DSPD     mmioFOURCC('d', 's', 'p', 'd')
#define FOURCC_DSPH_OLD mmioFOURCC('D', 'S', 'P', 'H')  // Some files may
#define FOURCC_DSPD_OLD mmioFOURCC('D', 'S', 'P', 'D')  // define it this way

// Future expansion of this header structure could include data page 
// utilization, relocation information, etc.

typedef struct rdsp_header_tag
   {
   FOURCC ckID;         // Chunk ID - Will be "RDSP"
   DWORD  ckSize;       // Length of this file in bytes
   } RDSP_HEADER;

typedef struct dsp_header_tag
   {
   FOURCC ckID;         // Chunk ID - Will be "dsph"
   DWORD  ckSize;       // Length of this header chunk in bytes

   WORD   wAppID;       // DSP application ID number
   char   szAppName[RDSP_MAXAPPNAMELEN]; // DSP Application name (ASCIZ str)
   WORD   wVersion;     // DSP application version number
   
   WORD   wFormat;      // DSP application format:
                        //    0 = ROM-based application, header only
                        //    1 = RAM-based application, code on disk
   WORD   wTotalChunks; // Total number of code/data chunks in this file
   WORD   wKey;         // Encryption key for security, 0 = no encryption
   WORD   wMid;         // DSP hardware manufacturer ID:
                        //    0 = Sierra Semiconductor Corp.
   WORD   wPid;         // DSP product ID:
                        //    18025, 18026, etc.

   DWORD  dwDSPMap;     // DSP Compatibility bit map, hardware dependent
   DWORD  dwRAMMap;     // RAM Compatibility bit map, hardware dependent

   BYTE   bMinUsage;    // Minimum DSP app utilization, 0 to 100 percent
   BYTE   bMaxUsage;    // Maximum DSP app utilization, 0 to 100 percent

   WORD   wVoiceCount;  // Maximum number of synthesizer voices allowed
                        //  simultaneously
   } DSP_APP_HEADER;

typedef struct dsp_data_tag
   {
   FOURCC ckID;         // Chunk ID - Will be "dspd"
   DWORD  ckSize;       // Length of this DSP data chunk in bytes
   WORD   wType;        // 1 = Program code chunk
                        // 2 = Program data chunk
                        // 3 = Combined program code/data chunk
   DWORD  dwAddr;       // DSP RAM absolute load address for this chunk
   DWORD  reserved1;    // Reserved for future use
   DWORD  reserved2;    // Reserved for future use
   } DSP_APP_DATA;

//*** Public function declarations ***

VOID  SetDSPUsage (UINT, UINT);
short SetMode (UINT, UINT);
short SetADC (UINT);

