/* A quick and dirty way of getting the IT8705F into the state I want it in :) */

#include <sys/io.h>
#include <stdio.h>
#include <time.h>

unsigned char read_byte(unsigned char addr)
{
        outb(addr, 0x295);
        return (inb(0x296));
}

int write_byte (unsigned char addr, unsigned char data)
{
	outb(addr, 0x295);
	outb(data, 0x296);

	if (read_byte(addr) != data)
	{
		printf("Error Writing addr: 0x%02X, wrote: 0x%02X, read: 0x%02X\n", addr, data, read_byte(addr));
	}
}

int main (void)
{
	unsigned char speed, temp1, temp2;

	if (ioperm(0x295, 2, 1) == -1)
	{
		printf("Error getting access\n");
                return -1;
	}
		

	// Disable Controller
	write_byte(0x00, 0x18);

	// Set Tachometer divider
	write_byte(0x0b, 0x24);

	// Set controller mode
	write_byte(0x13, 0x73);
/*
//# Set all fans to Automatic operation
write_byte(0x15, 0x80); // # Fan1
write_byte(0x16, 0x80); // # Fan2
write_byte(0x17, 0x80); // # Fan3 (unused)

speed = 0x3f;
//# Set all fans to manual operation
write_byte(0x15, (speed&0x7f)); // # Fan1
write_byte(0x16, (speed&0x7f)); // # Fan2
write_byte(0x17, (speed&0x7f)); // # Fan3 (unused)
*/

//# Set FAN1 Limits
write_byte(0x60, 0x1b); // # Fan Off Value ( <28 deg c)
write_byte(0x61, 0x1e); // # Fan Start Value ( >29 Deg C)
write_byte(0x62, 0x40); // # Fan FULL speed Value (?? Deg C)
write_byte(0x63, 0x01); // # PWM Start Value 
write_byte(0x64, 0x84); // # SmartGuardian Control


//# Set FAN2 Limits
write_byte(0x68, 0x1b); // # Fan Off Value ( <28 deg c)
write_byte(0x69, 0x1e); // # Fan Start Value ( >29 Deg C)
write_byte(0x6a, 0x40); // # Fan FULL speed Value (?? Deg C)
write_byte(0x6b, 0x01); // # PWM Start Value
write_byte(0x6c, 0x84); // # SmartGuardian Control

//#Enable Controller
write_byte(0x00, 0x11);


//    while (1)
    {
        temp1 = read_byte(0x29);
	temp2 = read_byte(0x2b);

        // Set the fan speed depending on temperature
	if (0) //(temp1 < 0x26 || temp2 < 0x26)
	{
            // Set all fans to Automatic operation
            write_byte(0x15, 0x80); // # Fan1
            write_byte(0x16, 0x80); // # Fan2
            write_byte(0x17, 0x80); // # Fan3 (unused)
	}
	else
	{
            speed = ((temp1>temp2?temp1:temp2) - 25) * 6;
            //# Set all fans to manual operation
            write_byte(0x15, (speed&0x7f)); // # Fan1
            write_byte(0x16, (speed&0x7f)); // # Fan2
            write_byte(0x17, (speed&0x7f)); // # Fan3 (unused)
	}
	//delay(1000);
    }
}

