        TITLE   SETBP35 - Set device characteristics for 3.5" 720K drive
        PAGE    60,120
COMMENT @

This program will set the device characteristics for the A: or the B:
diskette drive to indicate that the drive is a 720K drive and not a
360K drive.  It requires DOS 3.2 or later.

The only command line parameter is the drive number (A or B).

(c) Copyright Ronald W. Hoffman  1988.  All rights reserved.

@

PSP     struc
        db      128 dup (?)
parmlen db      ?                       ;Length of command line parameters
parmstr db      ?                       ;Command line parameters
PSP     ends

CR      equ     13              ;Carriage return
LF      equ     10              ;Line feed

DOS_CALL equ    21H             ;DOS function interrupt number

DATA    segment para public 'DATA'
crnote1 db      'SETBPB35 - Set 720K diskette device characteristics',CR,LF,'$'
crnote2 db      '(c) Copyright Ronald W. Hoffman  1988.  All rights reserved.'
skip    db      CR,LF,'$'

goodmsg db      'Drive '
gooddrv db      ' '
        db      ' successfully set to 720K',CR,LF,'$'

badmsg  db      'Unable to set drive '
baddrv  db      ' '
        db      ' to 720K',CR,LF,'$'

invmsg  db      'Invalid drive specification',CR,LF,'$'

;       Define the parameter block for Subfunction 44h

parmblk   db    04h                     ;Special functions
                                        ;  04 = all sectors have same size
          db    02h                     ;Device type
                                        ;  02 = 720K 3.5" diskette drive
          db    00h,00h                 ;Device attributes
                                        ;  Removable media, no change line
          dw    80                      ;Number of cylinders
          db    00h                     ;Default media type

          dw    512                     ;Bytes per sector
          db    2                       ;Sectors per cluster
          dw    1                       ;Reserved sectors
          db    2                       ;Number of FATs
          dw    112                     ;Root entries
          dw    1440                    ;Total sectors
          db    0F9h                    ;Media descriptor
          dw    3                       ;Sectors per FAT
          dw    9                       ;Sectors per track
          dw    2                       ;Number of heads
          dd    0                       ;Hidden sectors
          db    10 dup (00h)            ;Reserved

          dw    9                       ;Sector count
          dw    1,512                   ;Track layout
          dw    2,512
          dw    3,512
          dw    4,512
          dw    5,512
          dw    6,512
          dw    7,512
          dw    8,512
          dw    9,512
DATA    ends

STACK   segment para stack 'STACK'
        dw      128 dup (0)             ;Define a stack
STACK   ends
        PAGE
CODE    segment para public 'CODE'
        assume  CS:CODE,SS:STACK,DS:NOTHING,ES:NOTHING

SETBPB35 proc   far
        mov     ax,DATA                 ;Set data segment register
        mov     ds,ax
        assume  DS:DATA

;       Print the startup messages

        mov     dx,offset crnote1
        mov     ah,9
        int     DOS_CALL
        mov     dx,offset crnote2
        mov     ah,9
        int     DOS_CALL
        mov     dx,offset skip
        mov     ah,9
        int     DOS_CALL

;       Get the drive specification from the command line

        mov     cl,ES:parmlen           ;Get the parameter length
        sub     ch,ch
        cmp     cx,0                    ;Are there any parameters?
        je      badparm                 ;...No, post error
        mov     di,parmstr              ;Point to parameter string
        mov     al,' '                  ;Set to scan for blanks
        cld                             ;Clear the direction flag
        repe    scasb                   ;Skip leading blanks
        jz      badparm                 ;Branch if all blanks
        dec     di                      ;Point to the non-blank
        mov     al,ES:[di]              ;Get the first non-blank
        and     al,0dfh                 ;Make sure it is uppercase
        cmp     al,'A'                  ;Is it the A drive?
        je      parmok                  ;...Yes, that is acceptable
        cmp     al,'B'                  ;Is it the B drive?
        je      parmok                  ;...Yes, that is also acceptable
badparm:
        mov     dx,offset invmsg
        mov     ah,9
        int     DOS_CALL                ;Invalid drive specification
        mov     al,1                    ;Indicate error
        jmp     return                  ;Quit now

;       Set the drive characteristics

parmok:
        mov     gooddrv,al              ;Set drive letter in messages
        mov     baddrv,al
        sub     al,'A'-1                ;Convert to drive number
        mov     bl,al                   ;Need drive number in BL
        mov     ax,440dh                ;Indicate Generic IOCTL Request
        mov     cx,0840h                ;Indicate Set Device Parameters
        lea     dx,parmblk              ;Point to parameter block
        int     DOS_CALL                ;Set device characteristics
        jc      seterr                  ;Jump if the set failed
        mov     ah,9
        mov     dx,offset goodmsg       ;Set for good completion
        int     DOS_CALL                ;Drive set to 720K
        xor     al,al                   ;Set return code to 0
        jmp     short return            ;All done
seterr:
        mov     ah,9
        mov     dx,offset badmsg        ;Set for bad completion
        int     DOS_CALL                ;Drive set to 720K
        mov     al,2                    ;Set return code to 2

return:
        mov     ah,4ch
        int     DOS_CALL                ;All done
SETBPB35 endp
CODE    ends
        end     SETBPB35
