#define		PROGRAM		"SMBPD"
#define		VERSION		"Version 0.94 1997-01-31"
#define		AUTHOR		"Copyright (C) 1997 Ken Yap (ken@syd.dit.csiro.au)"

#ifdef	unix
#define	tcp_Socket	int
#else
#include	<tcp.h>
#define		strcasecmp(a,b,c)	stricmp(a,b,c)
#define		strncasecmp(a,b,c)	strnicmp(a,b,c)
#endif

enum connstate { INIT, WANT_CONN, WANT_LENGTH, WANT_SMB, PRINTING, CLOSING, ABORT };

/* The order of members is arbitrary but I've arranged them for
   ease of printing in debugging, so the large buffers are last */

struct smbconn
{
	enum connstate		state;			/* of connection */
	int			connid;			/* index */
	long			to_read;		/* bytes expected */
	long			smblen;			/* current SMB */
	char			cname[16];		/* client */
	char			pname[MAXLABEL];	/* requested printer */
	int			printer;		/* 0 to 2 */
	unsigned short		fid;			/* fid when connected */
	time_t			starttime;		/* of printing */
	unsigned char		*dataptr;		/* where data is */
	int			datalength;		/* bytes this block */
	int			dataoffset;		/* in data */
	long			joblen;			/* bytes printed */
	void			*queueinfo;		/* -> queue info */
	struct smbhdr		*sh;			/* -> SMB */
	unsigned char		smallbuf[512];		/* inline buffer */
	unsigned char		*largebuf;		/* large printer buffer */
	tcp_Socket		socket;			/* Wattcp stuff */
};

#define	DBUFSIZE		(63*1024U)
#define	HDR_OVERHEAD		(4+SMB_HDR_SIZE+8)
#define	MAXBUFFER		(HDR_OVERHEAD+DBUFSIZE)

extern int			verbose;
extern unsigned short		maxbuffer;
