;************************************************************************
;************************************************************************
;*
;*		Packet interface routines
;*
;************************************************************************
;************************************************************************


int_pkt		macro
		pushf
		cli
		call	their_isr
		endm

their_isr	dd	?
packet_int_no	db	60h,?,?,?
signature	db	'PKT DRVR',0
signature_len	equ	$-signature
no_signature	db	"No packet driver at that address",'$'



;************************************************************************
;*		FindPktint
;************************************************************************

FindPktint	proc	near
  FindLoop:
		call	TestPktInt
		je	FindRet
		inc	packet_int_no
		cmp	packet_int_no,80h
		jb	FindLoop

		mov	dx,offset no_signature
		mov	ah,9
		int	21h
		mov	ax,4c02h
		int	21h
  FindRet:
		ret
Findpktint	endp



;************************************************************************
;*		TestPktInt
;************************************************************************

TestPktInt	proc	near
		mov	ah,35h			; get their packet interrupt.
		mov	al,packet_int_no
		int	21h
		mov	their_isr.offs,bx
		mov	their_isr.segm,es
		lea	di,3[bx]
		mov	si,offset signature
		mov	cx,signature_len
		repe	cmpsb
		ret
TestPktInt	endp


