/*
 *
 * Top100 - The Oracle Shared Pool Profiler
 * Copyright  1995-2003 by Material Dreams
 * All Rights Reserved.
 * 
 * www.materialdreams.com/oracle
 * info@materialdreams.com
 *
 *
 * NAME
 *    Top100CleanUp.sql
 *
 * DESCRIPTION
 *    This script can be used to cleanup any objects that might have been left over by using Top100.
 *
 * NOTES
 *    Please run this script logged on as user SYS or SYSTEM.
 *
 *
 */

BEGIN
DECLARE
	CURSOR cT IS SELECT object_name FROM all_objects WHERE object_type = 'TABLE'   AND object_name LIKE 'TOP100$%';
	CURSOR cP IS SELECT object_name FROM all_objects WHERE object_type = 'PACKAGE' AND object_name LIKE 'TOP100$%';
	aSqlCmd VARCHAR2(100);
	aCursor	INTEGER;
	aReturn	INTEGER;
BEGIN
	aCursor := dbms_sql.open_cursor;
	FOR aTR IN cT LOOP
		aSqlCmd := 'DROP TABLE ' || aTR.object_name;
--		dbms_output.put_line(aSqlCmd);
		dbms_sql.parse(aCursor, aSqlCmd, dbms_sql.native);
		aReturn := dbms_sql.execute(aCursor);
	END LOOP;
	FOR aPR IN cP LOOP
	    	aSqlCmd := 'DROP PACKAGE ' || aPR.object_name;
--	    	dbms_output.put_line(aSqlCmd);
		dbms_sql.parse(aCursor, aSqlCmd, dbms_sql.native);
		aReturn := dbms_sql.execute(aCursor);
	END LOOP;
	dbms_sql.close_cursor(aCursor);
END;
END;
