#!/usr/bin/perl

###############################################################################
#
# _CGI.pl - an include file for perl...
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:53 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: _CGI.pl,v 1.44.2.5 2001/08/21 17:50:53 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

# Add the current directory to the search path

use lib '.';

# CGI.pm - http://stein.cshl.org/WWW/software/CGI/cgi_docs.html
# use CGI laods the module
# use CGI::Carp qw/fatalsToBrowser/ outputs meaningful error messages
#  to the browser

use CGI qw/escape unescape/;
use CGI::Carp qw/fatalsToBrowser/;

# print $CGI::VERSION, "\n";

# Import constants for flock
# Constants are now hard coded, since dynamic loading broke on my machine
# use Fcntl ':flock';
# use Fcntl;

###############################################################################
#
# Initializations

# Initialize the query object.
# This loads submitted data into a CGI object, to be accessed later. There
# are many nifty ways to access the data, whether you know the variable names
# or not. The most basic is by name-value pair, like this:
# $value = $CGIQuery->param('name');
# You can get an array of names like this:
# @names = $CGIQuery->param;

$CGIQuery = new CGI;

# Initialize some variables - standard Environment variables
# $CGIEnvScript is used as the action for the forms. Some of the others may or
# may not be used.
$CGIEnvUser = $ENV{'REMOTE_USER'};
$CGIEnvScript = $ENV{'SCRIPT_NAME'};
$CGIEnvReferer = $ENV{'HTTP_REFERER'};
$CGIEnvRemoteHost = $ENV{'REMOTE_HOST'};
$CGIEnvUserAgent = $ENV{'HTTP_USER_AGENT'};
$CGIEnvQuery = $ENV{'QUERY_STRING'};

# Directories
$DIR_FORUMUPLOADS = "+uploads+";
$DIR_FORUMREPLIES = "+replies+";
$DIR_CLASSFORUM = "Forum";
$DIR_CLASSANNOUNCE = "Announce";
$DIR_CONFIG = ".Admin";
$DIR_CGI = "cgi-bin";
$DIR_NEWCLASS = "newclass";
$DIR_UTIL = "util";
$DIR_IMAGES = "images";
$DIR_BGIMAGES = "backgrounds";
$DIR_NEWTEMPLATE = "Templates";

# What are the names of the scripts?
$CGI_Forum = "Forum.cgi";
$CGI_ForumViewSubjects = "FVwSubj.cgi";
$CGI_ForumViewThreads = "FVwThrDate.cgi";
$CGI_ForumViewMsgThread = "FVwMsgThr.cgi";
$CGI_ForumChangePass = "ChgPasswd.cgi";
$CGI_ForumUserAddSelf = "FUserAddSelf.cgi";
$CGI_ForumEditSubjectsAdd = "_AFEdSubjAdd.cgi";
$CGI_ForumEditSubjectsMult = "_AFEdSubjMult.cgi";
$CGI_ForumEditSubjectsDelete = "_AFEdSubjDel.cgi";
$CGI_ForumEditSubjectsPost = "_AFEdSubjPost.cgi";
$CGI_ForumEditSubjectsBatch = "_AFEdSubjBatch.cgi";
$CGI_ForumEditSubjectsRename = "_AFEdSubjRename.cgi";
$CGI_ForumEditUserSingle = "_AFEdUserSngl.cgi";
$CGI_ForumEditUserMultiple = "_AFEdUserMult.cgi";
$CGI_ForumEditUserDelete = "_AFEdUserDel.cgi";
$CGI_ForumEditUserPhoto = "_AFEdUserPhoto.cgi";
$CGI_ClassCreate = "_AClassCreate.cgi";
$CGI_ClassEdit = "_AClassEdit.cgi";
$CGI_ClassViewColor = "_AClassVwColor.cgi";
$CGI_ForumEditUserBatch = "_AFEdUserBatch.cgi";
$CGI_ForumAdminMenu = "_AFAdminMenu.cgi";
$CGI_ForumMsgDelete = "_AFMsgDel.cgi";
$CGI_ForumUploadDelete = "_AFUploadDel.cgi";
$CGI_ForumVwMsgBatch = "_AFVwMsgBatch.cgi";
$CGI_ForumEditFiles = "_AFEdFile.cgi";
$CGI_ForumCookieLogin = "FCLogin.cgi";
$CGI_ForumProfile = "FUserProfile.cgi";
$CGI_ForumStats = "FPrintStats.cgi";
$CGI_ForumDemo = "Demo.cgi";
$CGI_ClassEditColor = "_AFColorScheme.cgi";
$CGI_ClassEditColorVw = "_AFColorSchemeVw.cgi";
$CGI_ClassHexToRGB = "FHexToRGB.cgi";
$CGI_ForumVersion = "_AFShowVersion.cgi";
$CGI_ForumHelp = "Help.cgi";
$CGI_AdminHelp = "_AFHelp.cgi";
$CGI_ForumLayout = "_AFLayout.cgi";
$CGI_ForumDisable = "_AClassDisable.cgi";
$CGI_TechSupp = "_AFTechSupp.cgi";
$CGI_License = "_ALicense.cgi";

# Database access programs
$prtDB = $DIR_UTIL . "/prtDB";
$setDB = $DIR_UTIL . "/setDB";
$delDB = $DIR_UTIL . "/delDB";

# Message Deletion
$delMsgThread = $DIR_UTIL . "/delMsgThread";

# Image programs
$IMGmogrify = $DIR_UTIL . "/mogrify";
$IMGidentify = $DIR_UTIL . "/identify";

# HTML Programs
$safehtml = $DIR_UTIL . "/safehtml";
$mkHTML = $DIR_UTIL . "/mkHTML";

# User Programs
$encodeUser = $DIR_UTIL . "/encodeUser";
$decodeUser = $DIR_UTIL . "/decodeUser";

# License check for Lite version
$checkLite = $DIR_UTIL . "/checkLite";

# Crypt for Windows
$crypt = $DIR_UTIL . "/crypt";

# Database programs for file input
$setHashDB = $DIR_UTIL . "/setHashDB";

# Announcement Scripts (For AdminMenu)
$CGI_AnnForm = "_AAForm.cgi";
$CGI_AnnDel = "_AADel.cgi";
$CGI_AnnBuild = "_AABuild.cgi";
$CGI_AnnViewOne = "_AAViewOne.cgi";
$CGI_AnnEmail = "_AAEmail.cgi";
$CGI_AnnPost = "_AAPost.cgi";

if ($ENV{'COMSPEC'} ne "" && $ENV{'WINDIR'} ne "") {
	$CGI_Forum =~ s/\.cgi$/\.exe/i;
	$CGI_ForumViewSubjects =~ s/\.cgi$/\.exe/i;
	$CGI_ForumViewThreads =~ s/\.cgi$/\.exe/i;
	$CGI_ForumViewMsgThread =~ s/\.cgi$/\.exe/i;
	$CGI_ForumChangePass =~ s/\.cgi$/\.exe/i;
	$CGI_ForumAdminMenu =~ s/\.cgi$/\.exe/i;
	$CGI_ForumCookieLogin =~ s/\.cgi$/\.exe/i;
	$CGI_ForumStats =~ s/\.cgi$/\.exe/i;
	$CGI_ForumDemo =~ s/\.cgi$/\.exe/i;
	$CGI_ForumHelp =~ s/\.cgi$/\.exe/i;
	$CGI_AdminHelp =~ s/\.cgi$/\.exe/i;
	$CGI_License =~ s/\.cgi$/\.exe/i;
	$CGI_AnnForm =~ s/\.cgi$/\.exe/i;
	$CGI_AnnBuild =~ s/\.cgi$/\.exe/i;
	$CGI_AnnEmail =~ s/\.cgi$/\.exe/i;
	$CGI_AnnPost =~ s/\.cgi$/\.exe/i;
	$CGI_ForumHelp =~ s/\.cgi$/\.exe/i;
	
	$prtDB =~ s/\//\\/g;
	$setDB =~ s/\//\\/g;
	$delDB =~ s/\//\\/g;
	$setHashDB =~ s/\//\\/g;
	$IMGmogrify =~ s/\//\\/g;
	$IMGidentify =~ s/\//\\/g;
	$safehtml =~ s/\//\\/g;
	$mkHTML =~ s/\//\\/g;
	$encodeUser =~ s/\//\\/g;
	$decodeUser =~ s/\//\\/g;
	$crypt =~ s/\//\\/g;
	$delMsgThread =~ s/\//\\/g;
	$checkLite =~ s/\//\\/g;
}

# This must come after decodeUser is defined.
$USERID_COOKIE = 'panForaUser';
$USERSAVE_COOKIE = 'panForaUserSave';

# Append the forum id to the user id cookie, if  one exists
$fidtmp = $CGIQuery->param("fid");
if ($fidtmp ne "") {
	$USERID_COOKIE .= "-" . $fidtmp;
}

if ($CGIEnvUser eq "") {
	if ($CGIQuery->cookie($USERID_COOKIE) ne "") {
		if ($Demo) {
			$CGIEnvUser = $CGIQuery->cookie($USERID_COOKIE);
		} else {
			local($crumb) = $CGIQuery->cookie($USERID_COOKIE);
			local($udate, $tmpuser, $chkid) = split(/\s/, `$decodeUser $crumb`);
			chomp($tmpuser);
			chomp($chkid);
			if ($udate =~ /\=ERROR\=/) {
				$CGIEnvUser = "Guest";
			} else {
				if ($fidtmp ne "") {
					if ($chkid ne $fidtmp) {
						$CGIEnvUser = "Guest";
					} else {
						$CGIEnvUser = $tmpuser;
					}
				} else {
					$CGIEnvUser = $tmpuser;
				}
			}
		}
	} else {
		#if ($CGIQuery->cookie($USERSAVE_COOKIE) ne "") {
		#	$CGIEnvUser=&unescapeUserSave($CGIQuery->cookie($USERSAVE_COOKIE));
		#} else {
			$CGIEnvUser = "Guest";
		#}
	}
}

1;
